'use strict';

function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

var throttle = _interopDefault(require('throttleit'));

/**
* forked from https://github.com/camwiegert/in-view/blob/master/src/viewport.js
* Check whether an element is in the viewport by
* more than offset px.
*/
var inViewport = function (element, ref) {
  if ( ref === void 0 ) ref = {};
  var offset = ref.offset; if ( offset === void 0 ) offset = {};
  var threshold = ref.threshold;

  var ref$1 = element.getBoundingClientRect();
  var top = ref$1.top;
  var right = ref$1.right;
  var bottom = ref$1.bottom;
  var left = ref$1.left;
  var width = ref$1.width;
  var height = ref$1.height;

  var intersection = {
    t: bottom,
    r: window.innerWidth - left,
    b: window.innerHeight - top,
    l: right
  };

  var elementThreshold = {
    x: threshold * width,
    y: threshold * height
  };

  return intersection.t >= (offset.top || 0 + elementThreshold.y) &&
    intersection.r >= (offset.right || 0 + elementThreshold.x) &&
    intersection.b >= (offset.bottom || 0 + elementThreshold.y) &&
    intersection.l >= (offset.left || 0 + elementThreshold.x)
};

var triggers = ['scroll', 'resize'];

var MugenScroll = {
  name: 'mugen-scroll',
  props: {
    handler: {
      type: Function,
      required: true
    },
    shouldHandle: {
      type: Boolean,
      default: true
    },
    threshold: {
      type: Number,
      default: 0
    },
    handleOnMount: {
      type: Boolean,
      default: true
    },
    scrollContainer: {
      type: String
    }
  },
  mounted: function mounted() {
    this.checkInView();
  },
  methods: {
    checkInView: function checkInView() {
      var this$1 = this;

      var execute = function () {
        var inView = inViewport(this$1.$refs.scroll, {
          threshold: this$1.threshold
        });
        if (this$1.shouldHandle && inView) {
          this$1.handler();
        }
      };

      // checkInView right after this component is mounted
      if (this.handleOnMount) {
        execute();
      }

      this._scrollContainer = this.scrollContainer ?
        this.$parent.$refs[this.scrollContainer] :
        window;

      // add event listeners
      this.check = throttle(execute, 200);
      triggers.forEach(function (event) { return this$1._scrollContainer.addEventListener(event, this$1.check); });
    }
  },
  render: function render(h) {
    return h('div', {
      staticClass: 'mugen-scroll',
      ref: 'scroll'
    }, this.$slots.default)
  },
  beforeDestroy: function beforeDestroy() {
    var this$1 = this;

    triggers.forEach(function (event) { return this$1._scrollContainer.removeEventListener(event, this$1.check); });
  }
};

if (typeof window !== 'undefined' && window.Vue) {
  window.Vue.component(MugenScroll.name, MugenScroll);
}

module.exports = MugenScroll;
