'use strict';

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var template = require('./template.js');
var bus = require('./bus');

module.exports = {
  render: template.call(undefined),
  props: {
    for: {
      type: String,
      required: false
    },
    theme: {
      type: String,
      default: 'bootstrap3'
    },
    align: {
      type: String,
      default: 'center'
    },
    records: {
      type: Number,
      required: true
    },
    perPage: {
      type: Number,
      required: false,
      default: 25
    },
    chunk: {
      type: Number,
      required: false,
      default: 10
    },
    countText: {
      type: String,
      required: false,
      default: 'Showing {from} to {to} of {count} records|{count} records|One record'
    },
    vuex: {
      type: Boolean
    },
    format: {
      type: Boolean,
      default: true
    }
  },
  created: function created() {

    if (!this.vuex) return;

    if (!this.for) {
      throw new Error('vue-pagination-2: The "for" prop is required when using vuex');
    }

    var name = this.for;

    if (this.$store.state[name]) return;

    this.$store.registerModule(this.for, {
      state: {
        page: 1
      },
      mutations: _defineProperty({}, name + '/PAGINATE', function undefined(state, page) {
        state.page = page;
      })
    });
  },
  data: function data() {
    return {
      Page: 1
    };
  },
  computed: {
    Theme: function Theme() {

      var themes = {
        bootstrap3: require('./themes/bootstrap3'),
        bootstrap4: require('./themes/bootstrap4'),
        bulma: require('./themes/bulma')
      };

      return themes[this.theme];
    },
    page: function page() {
      return this.vuex ? this.$store.state[this.for].page : this.Page;
    },

    pages: function pages() {
      if (!this.records) return [];

      return range(this.paginationStart, this.pagesInCurrentChunk);
    },
    totalPages: function totalPages() {
      return this.records ? Math.ceil(this.records / this.perPage) : 1;
    },
    totalChunks: function totalChunks() {
      return Math.ceil(this.totalPages / this.chunk);
    },
    currentChunk: function currentChunk() {
      return Math.ceil(this.page / this.chunk);
    },
    paginationStart: function paginationStart() {
      return (this.currentChunk - 1) * this.chunk + 1;
    },
    pagesInCurrentChunk: function pagesInCurrentChunk() {

      return this.paginationStart + this.chunk <= this.totalPages ? this.chunk : this.totalPages - this.paginationStart + 1;
    },
    count: function count() {

      var from = (this.page - 1) * this.perPage + 1;
      var to = this.page == this.totalPages ? this.records : from + this.perPage - 1;
      var parts = this.countText.split('|');
      var i = Math.min(this.records == 1 ? 2 : this.totalPages == 1 ? 1 : 0, parts.length - 1);

      return parts[i].replace('{count}', this.formatNumber(this.records)).replace('{from}', this.formatNumber(from)).replace('{to}', this.formatNumber(to));
    }
  },
  methods: {
    setPage: function setPage(page) {
      if (this.allowedPage(page)) {
        this.paginate(page);
      }
    },
    paginate: function paginate(page) {
      if (this.vuex) {
        this.$store.commit(this.for + '/PAGINATE', page);
      } else {
        this.Page = page;
      }

      this.$emit('paginate', page);

      if (this.for) {
        bus.$emit('vue-pagination::' + this.for, page);
      }
    },

    next: function next() {
      return this.setPage(this.page + 1);
    },
    prev: function prev() {
      return this.setPage(this.page - 1);
    },
    nextChunk: function nextChunk() {
      return this.setChunk(1);
    },
    prevChunk: function prevChunk() {
      return this.setChunk(-1);
    },
    setChunk: function setChunk(direction) {
      this.setPage((this.currentChunk - 1 + direction) * this.chunk + 1);
    },
    allowedPage: function allowedPage(page) {
      return page >= 1 && page <= this.totalPages;
    },
    allowedChunk: function allowedChunk(direction) {
      return direction == 1 && this.currentChunk < this.totalChunks || direction == -1 && this.currentChunk > 1;
    },
    allowedPageClass: function allowedPageClass(direction) {
      return this.allowedPage(direction) ? '' : 'disabled';
    },
    allowedChunkClass: function allowedChunkClass(direction) {
      return this.allowedChunk(direction) ? '' : 'disabled';
    },
    activeClass: function activeClass(page) {
      return this.page == page ? this.Theme.active : '';
    },
    formatNumber: function formatNumber(num) {

      if (!this.format) return num;

      return num.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
    }
  },
  beforeDestroy: function beforeDestroy() {
    bus.$off();
    bus.$destroy();
  }
};

function range(start, count) {
  return Array.apply(0, Array(count)).map(function (element, index) {
    return index + start;
  });
}