English | [简体中文](README.zh.md)

<p align="center">
  <a href="https://bhuh12.github.io/vue-router-tab/" target="_blank" rel="noopener noreferrer">
    <img width="100" src="public/img/logo.png" alt="vue-router-tab logo">
  </a>
</p>

<p align="center">
  <a target="_blank" href="https://www.travis-ci.org/bhuh12/vue-router-tab">
    <img src="https://www.travis-ci.org/bhuh12/vue-router-tab.svg" alt="Build">
  </a>

  <a href="https://github.com/vuejs/vue">
    <img src="https://img.shields.io/badge/vue-2.5.22-brightgreen.svg" alt="vue">
  </a>

  <a href="https://github.com/vuejs/vue-router">
    <img src="https://img.shields.io/badge/vue--router-3.0.1-brightgreen.svg" alt="vue-router">
  </a>

  <a target="_blank" href="https://github.com/bhuh12/vue-router-tab">
    <img alt="GitHub last commit" src="https://img.shields.io/github/last-commit/bhuh12/vue-router-tab.svg">
  </a>
</p>

<p align="center">
  <a target="_blank" href="https://www.npmjs.com/package/vue-router-tab">
    <img src="https://img.shields.io/npm/v/vue-router-tab.svg" alt="Version">
  </a>

  <a target="_blank" href="https://npmcharts.com/compare/vue-router-tab?minimal=true">
    <img src="https://img.shields.io/npm/dm/vue-router-tab.svg" alt="Downloads">
  </a>

  <a target="_blank" href="https://www.npmjs.com/package/vue-router-tab">
    <img alt="npm bundle size" src="https://img.shields.io/bundlephobia/minzip/vue-router-tab.svg?label=gzip:JS">
  </a>

  <a target="_blank" href="https://www.npmjs.com/package/vue-router-tab">
    <img alt="gzip size: css" src="http://img.badgesize.io/https://unpkg.com/vue-router-tab/dist/lib/vue-router-tab.css?compression=gzip&label=gzip:CSS">
  </a>
  
  <a target="_blank" href="https://github.com/bhuh12/vue-router-tab/blob/main/LICENSE">
    <img src="https://img.shields.io/npm/l/vue-router-tab.svg" alt="License">
  </a>
</p>

<h2 align="center">Vue Router Tab</h2>

Vue.js tab components, based on Vue Router.

## 📌 Features

✅ Open or switch to tabs responding to route change

✅ Tabs mouse wheel scrolling

✅ Tabs drag sort

✅ [Tab Operations](https://bhuh12.github.io/vue-router-tab/guide/essentials/operate.html): open, switch, close, refresh, reset

✅ [Iframe tab](https://bhuh12.github.io/vue-router-tab/guide/essentials/iframe.html): for external website

✅ Customized：[transition](https://bhuh12.github.io/vue-router-tab/guide/custom/transition.html), [slot](https://bhuh12.github.io/vue-router-tab/guide/custom/slot.html), [contextmenu](https://bhuh12.github.io/vue-router-tab/guide/custom/contextmenu.html)

✅ [I18n](https://bhuh12.github.io/vue-router-tab/guide/custom/i18n.html)

✅ [Keep scroll position](https://bhuh12.github.io/vue-router-tab/guide/custom/scroll.html) after tab switching

✅ [Cache control](https://bhuh12.github.io/vue-router-tab/guide/advanced/cache.html): tab rules, cacheable, maximum keep alive, reusable

✅ [Dynamic Tab Info](https://bhuh12.github.io/vue-router-tab/guide/advanced/dynamic-tab-info.html): title, icon, tooltip

✅ [Initial Tabs](https://bhuh12.github.io/vue-router-tab/guide/advanced/initial-tabs.html): initially opened tabs when entering page

✅ [Restore Tabs](https://bhuh12.github.io/vue-router-tab/guide/advanced/restore.html): reopen tabs after browser refresh

✅ [Page Leave Confirm](https://bhuh12.github.io/vue-router-tab/guide/advanced/page-leave.html)

✅ [Nuxt Support](https://bhuh12.github.io/vue-router-tab/guide/essentials/nuxt.html)

## 🔗 Links

### [🛠 Installation](https://bhuh12.github.io/vue-router-tab/guide/essentials/installation.html)

### [📝 Documentation](https://bhuh12.github.io/vue-router-tab/) ([Gitee](https://bhuh12.gitee.io/vue-router-tab/))

- [Introduction](https://bhuh12.github.io/vue-router-tab/guide/)

- [Getting Started](https://bhuh12.github.io/vue-router-tab/guide/essentials/)

- [API](https://bhuh12.github.io/vue-router-tab/api/)

### [📺 Online Demo](https://bhuh12.github.io/vue-router-tab/demo/) ([Gitee](https://bhuh12.gitee.io/vue-router-tab/demo/))

### [👨‍💻 Sample Project](https://github.com/bhuh12/router-tab-sample)

### [📃 Changelog](https://bhuh12.github.io/vue-router-tab/guide/changelog.html)

---

## 🏷 NPM Task

| Task                           | Command                    | Description                        |
| ------------------------------ | -------------------------- | ---------------------------------- |
| Lib build                      | `npm run lib:build`        |
| Lib build and generate report  | `npm run lib:build:report` |
| Lib publish                    | `npm run lib:publish`      | change `version` in `package.json` |
| Demo develop                   | `npm run demo:dev`         |
| Demo build                     | `npm run demo:build`       |
| Document develop               | `npm run docs:dev`         |
| Document build                 | `npm run docs:build`       |
| Code format check              | `npm run lint`             |
| Code format check and auto fix | `npm run lint:fix`         |
| Commit code                    | `npm run commit`           |

## License

[MIT](http://opensource.org/licenses/MIT)

Copyright (c) 2019-present, 碧海幽虹
