# vue-snotify

[![Build Status](https://travis-ci.org/artemsky/vue-snotify.svg?branch=master)](https://travis-ci.org/artemsky/vue-snotify)
[![NPM Version](https://img.shields.io/npm/v/vue-snotify.svg)](https://www.npmjs.com/package/vue-snotify)
[![NPM Downloads](https://img.shields.io/npm/dt/vue-snotify.svg)](https://www.npmjs.com/package/vue-snotify)
[![Dev dependencies status list](https://david-dm.org/artemsky/vue-snotify/dev-status.svg)](https://david-dm.org/artemsky/vue-snotify?type=dev)

## Example
https://artemsky.github.io/vue-snotify/

## Features

- 9 types of toast notifications (async, confirm, prompt, html and more...)
- Many config options (icons, backdrop, timeout, position and much more...)
- Repository includes 3 different styles. So you can use on of them, or create your own.
- Callbacks
- 5KB minified and gzipped
- Typescript definitions
- ESM, CommonJS, UMD versions

###### Looking for an Angular version? [Here](https://github.com/artemsky/ng-snotify/)

![Snotify Gif](https://artemsky.github.io/vue-snotify/static/vue-snotify-demo.gif)

## Installation

###### NPM 5
`npm install vue-snotify`

###### yarn
`yarn add vue-snotify`

[see detailed instruction](https://artemsky.github.io/vue-snotify/documentation/installation.html)

## Documentation and Examples

Documentation - [here](https://artemsky.github.io/vue-snotify/documentation/index.html)  
Example application source - [here](https://github.com/artemsky/vue-snotify/tree/master/example/src)   
Change Log - [here](https://github.com/artemsky/vue-snotify/blob/master/CHANGELOG.md)

#### CDN
  - JS
    - [unpkg.com](https://unpkg.com/vue-snotify@latest/vue-snotify.min.js) | [jsDelivr.com](https://cdn.jsdelivr.net/npm/vue-snotify@latest/vue-snotify.min.js)
  - CSS
    - material [unpkg.com](https://unpkg.com/vue-snotify@latest/styles/material.css) | [jsDelivr.com](https://cdn.jsdelivr.net/npm/vue-snotify@latest/styles/material.css)
    - simple [unpkg.com](https://unpkg.com/vue-snotify@latest/styles/simple.css) | [jsDelivr.com](https://cdn.jsdelivr.net/npm/vue-snotify@latest/styles/simple.css)
    - dark [unpkg.com](https://unpkg.com/vue-snotify@latest/styles/dark.css) | [jsDelivr.com](https://cdn.jsdelivr.net/npm/vue-snotify@latest/styles/dark.css)

## License

MIT © [artemsky](mailto:mr.artemsky@gmail.com)
