import Vue from 'vue';
import { SnotifyToastConfig } from '../interfaces';
import { SnotifyEvent } from '../types';
/**
 * Toast model
 */
export declare class SnotifyToast {
    id: number | string;
    title: string;
    body: string;
    config: SnotifyToastConfig;
    /**
     * Emits {SnotifyEvent}
     * @type {Vue}
     */
    readonly eventEmitter: object & Record<never, any> & Vue;
    /**
     * Holds all subscribers because we need to unsubscribe from all before toast get destroyed
     * @type {Vue[]}
     * @private
     */
    private _eventsHolder;
    /**
     * Toast prompt value
     */
    value: string;
    /**
     * Toast validator
     */
    valid: boolean;
    /**
     *
     * @param {number|string} id
     * @param {string} title
     * @param {string} body
     * @param {SnotifyToastConfig} [config]
     */
    constructor(id: number | string, title: string, body: string, config: SnotifyToastConfig);
    /**
     * This callback is displayed as a global member.
     * @callback action
     * @param {toast} responseCode
     * @returns {void}
     */
    /**
     * Subscribe to toast events
     * @param {String<SnotifyEvent>} event
     * @param  {SnotifyToast~action} action
     * @returns {SnotifyToast}
     */
    on(event: SnotifyEvent, action: (toast: this) => void): this;
}
