'use strict';

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var object_filled_keys_count = require('../helpers/object-filled-keys-count');
var is_valid_moment_object = require('../helpers/is-valid-moment-object');
var filterByCustomFilters = require('../filters/custom-filters');

module.exports = function (data, e) {

  if (e) {

    var _query = this.query;

    this.setPage(1, true);

    var name = this.getName(e.target.name);
    var value = _typeof(e.target.value) === 'object' ? e.target.value : '' + e.target.value;

    if (name) {
      _query[name] = value;
    } else {
      _query = value;
    }

    this.vuex ? this.commit('SET_FILTER', _query) : this.query = _query;

    this.updateState('query', _query);

    if (name) {
      this.dispatch('filter', { name: name, value: value });
      this.dispatch('filter::' + name, value);
    } else {
      this.dispatch('filter', value);
    }
  }

  var query = this.query;

  var totalQueries = !query ? 0 : 1;

  if (!this.opts) return data;

  if (this.opts.filterByColumn) {
    totalQueries = object_filled_keys_count(query);
  }

  var value;
  var found;
  var currentQuery;
  var dateFormat = this.opts.dateFormat;
  var filterByDate;
  var isListFilter;

  var data = filterByCustomFilters(data, this.opts.customFilters, this.customQueries);

  if (!totalQueries) return data;

  return data.filter(function (row, index) {

    found = 0;

    this.filterableColumns.forEach(function (column) {

      filterByDate = this.opts.dateColumns.indexOf(column) > -1 && this.opts.filterByColumn;
      isListFilter = this.isListFilter(column) && this.opts.filterByColumn;

      value = getValue(row[column], filterByDate, dateFormat);

      currentQuery = this.opts.filterByColumn ? query[column] : query;

      currentQuery = setCurrentQuery(currentQuery);

      if (currentQuery && foundMatch(currentQuery, value, isListFilter)) found++;
    }.bind(this));

    return found >= totalQueries;
  }.bind(this));
};

function setCurrentQuery(query) {

  if (!query) return '';

  if (typeof query == 'string') return query.toLowerCase();

  // Date Range

  return query;
}

function foundMatch(query, value, isListFilter) {

  // List Filter
  if (isListFilter) return value == query;

  //Text Filter
  if (['string', 'number'].includes(typeof value === 'undefined' ? 'undefined' : _typeof(value))) {
    return String(value).toLowerCase().indexOf(query) > -1;
  }

  // Date range

  if (is_valid_moment_object(value)) {
    var start = moment(query.start, 'YYYY-MM-DD HH:mm:ss');
    var end = moment(query.end, 'YYYY-MM-DD HH:mm:ss');

    return value >= start && value <= end;
  }

  if ((typeof value === 'undefined' ? 'undefined' : _typeof(value)) === 'object') {

    for (var key in value) {
      if (foundMatch(query, value[key])) return true;
    }

    return false;
  }

  return value >= start && value <= end;
}

function getValue(val, filterByDate, dateFormat) {

  if (is_valid_moment_object(val)) {

    if (filterByDate) return val;
    return val.format(dateFormat);
  }

  return val;
}