import toNow from 'date-fns/distance_in_words_to_now';

var defaultConverter = (function (date, locale, converterOptions) {
  var includeSeconds = converterOptions.includeSeconds,
      _converterOptions$add = converterOptions.addSuffix,
      addSuffix = _converterOptions$add === void 0 ? true : _converterOptions$add;
  return toNow(date, {
    locale: locale,
    includeSeconds: includeSeconds,
    addSuffix: addSuffix
  });
});

var createTimeago = function createTimeago() {
  var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var locales = opts.locales || {};
  var name = opts.name || 'Timeago';
  return {
    name: name,
    props: {
      datetime: {
        required: true
      },
      title: {
        type: [String, Boolean]
      },
      locale: {
        type: String
      },
      autoUpdate: {
        type: [Number, Boolean]
      },
      converter: {
        type: Function
      },
      converterOptions: {
        type: Object
      }
    },
    data: function data() {
      return {
        timeago: this.getTimeago()
      };
    },
    mounted: function mounted() {
      this.startUpdater();
    },
    beforeDestroy: function beforeDestroy() {
      this.stopUpdater();
    },
    render: function render(h) {
      return h('time', {
        attrs: {
          datetime: new Date(this.datetime),
          title: typeof this.title === 'string' ? this.title : this.title === false ? null : this.timeago
        }
      }, [this.timeago]);
    },
    methods: {
      getTimeago: function getTimeago(datetime) {
        var converter = this.converter || opts.converter || defaultConverter;
        return converter(datetime || this.datetime, locales[this.locale || opts.locale], this.converterOptions || {});
      },
      convert: function convert(datetime) {
        this.timeago = this.getTimeago(datetime);
      },
      startUpdater: function startUpdater() {
        var _this = this;

        if (this.autoUpdate) {
          var autoUpdaye = this.autoUpdate === true ? 60 : this.autoUpdate;
          this.updater = setInterval(function () {
            _this.convert();
          }, autoUpdaye * 1000);
        }
      },
      stopUpdater: function stopUpdater() {
        if (this.updater) {
          clearInterval(this.updater);
          this.updater = null;
        }
      }
    },
    watch: {
      autoUpdate: function autoUpdate(newValue) {
        this.stopUpdater();

        if (newValue) {
          this.startUpdater();
        }
      },
      datetime: function datetime() {
        this.convert();
      },
      locale: function locale() {
        this.convert();
      },
      converter: function converter() {
        this.convert();
      },
      converterOptions: {
        handler: function handler() {
          this.convert();
        },
        deep: true
      }
    }
  };
};
var install = function install(Vue, opts) {
  var Component = createTimeago(opts);
  Vue.component(Component.name, Component);
};
var converter = defaultConverter;

export default install;
export { createTimeago, install, converter };
