import { VTransmitFile } from "../classes/VTransmitFile";
import { VTransmitUploadContext } from "../classes/VTransmitUploadContext";
import { UploaderInterface, UploadResult } from "../core/interfaces";
/**
 * Responsibilities:
 * - send and manage upload via transport
 * - on progress: emit progress stats
 * - on error: emit to vue-transmit & update file status
 * - on timeout: emit to vue-transmit & update file status
 * - on error: emit to vue-transmit & update file status
 * - on success: emit to vue-transmit & update file status
 * - once complete: emit to vue-transmit & update file status
 */
export declare type XHRUploadOptions<T = any> = {
    /**
     * A string representing the URL to send the request to.
     */
    url: string;
    /**
     * The HTTP method to use, such as "GET", "POST", "PUT", "DELETE", etc.
     * Ignored for non-HTTP(S) URLs.
     *
     * ```
     * // default => "post"
     * ```
     */
    method?: string;
    /**
     * The XMLHttpRequest.withCredentials property is a Boolean that indicates
     * whether or not cross-site Access-Control requests should be made using
     * credentials such as cookies, authorization headers or TLS client
     * certificates. Setting withCredentials has no effect on same-site requests.
     */
    withCredentials?: boolean;
    /**
     * The XMLHttpRequest.timeout property is an unsigned long representing the
     * number of milliseconds a request can take before automatically being
     * terminated. The default value is 0, which means there is no timeout.
     * Timeout shouldn't be used for synchronous XMLHttpRequests requests used in
     * a document environment or it will throw an InvalidAccessError exception.
     * When a timeout happens, a timeout event is fired.
     */
    timeout?: number;
    /**
     * The name of the file param that gets transferred.
     */
    paramName?: string;
    /**
     * An object of additional parameters to transfer to the server.
     * This is the same as adding hidden input fields in the form element.
     */
    params?: {
        [key: string]: string;
    };
    headers?: {
        [key: string]: string;
    };
    /**
     * The XMLHttpRequest.responseType property is an enumerated value that
     * returns the type of response. It also lets the author change the response
     * type. If an empty string is set as the value of responseType, the default
     * value text will be used.
     *
     * Setting the value of responseType to "document" is ignored if done in a
     * Worker environment. When setting responseType to a particular value,
     * the author should make sure that the server is actually sending a response
     * compatible to that format. If the server returns data that is not
     * compatible to the responseType that was set, the value of response will be
     * null. Also, setting responseType for synchronous requests will throw an
     * InvalidAccessError exception.
     */
    responseType?: XMLHttpRequestResponseType;
    /**
     * responseParseFunc is a function that given an XMLHttpRequest
     * returns a response object. Allows for custom response parsing.
     */
    responseParseFunc?: (xhr: XMLHttpRequest) => T;
    errUploadError?: (xhr: XMLHttpRequest) => string;
    errUploadTimeout?: (xhr: XMLHttpRequest) => string;
    renameFile?: (name: string) => string;
};
export declare type UploadGroup = {
    id: number;
    files: VTransmitFile[];
    xhr: XMLHttpRequest;
};
export declare class XHRUploadAdapter<T = any> implements UploaderInterface {
    context: VTransmitUploadContext;
    url: string;
    method: string;
    withCredentials: boolean;
    timeout: number;
    paramName: string;
    params: {
        [key: string]: string;
    };
    headers: {
        [key: string]: string;
    };
    responseType: XMLHttpRequestResponseType;
    errUploadError: (xhr: XMLHttpRequest) => string;
    errUploadTimeout: (xhr: XMLHttpRequest) => string;
    renameFile: (name: string) => string;
    responseParseFunc?: (xhr: XMLHttpRequest) => T;
    private uploadGroups;
    constructor(context: VTransmitUploadContext, options: XHRUploadOptions<T>);
    uploadFiles(files: VTransmitFile[]): Promise<UploadResult<T>>;
    handleUploadProgress(files: VTransmitFile[]): (e?: ProgressEvent) => void;
    getParamName(index: string | number): string;
    cancelUpload(file: VTransmitFile): VTransmitFile[];
    rmGroup(id: number): void;
}
