/*!
 * Name: vue-upload-component
 * Version: 2.8.21
 * Author: Marco Lang
 */!function(e){var n={};function t(i){if(n[i])return n[i].exports;var a=n[i]={i:i,l:!1,exports:{}};return e[i].call(a.exports,a,a.exports,t),a.l=!0,a.exports}t.m=e,t.c=n,t.d=function(e,n,i){t.o(e,n)||Object.defineProperty(e,n,{enumerable:!0,get:i})},t.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},t.t=function(e,n){if(1&n&&(e=t(e)),8&n)return e;if(4&n&&"object"==typeof e&&e&&e.__esModule)return e;var i=Object.create(null);if(t.r(i),Object.defineProperty(i,"default",{enumerable:!0,value:e}),2&n&&"string"!=typeof e)for(var a in e)t.d(i,a,function(n){return e[n]}.bind(null,a));return i},t.n=function(e){var n=e&&e.__esModule?function(){return e.default}:function(){return e};return t.d(n,"a",n),n},t.o=function(e,n){return Object.prototype.hasOwnProperty.call(e,n)},t.p="/dist",t(t.s=26)}([function(e,n,t){"use strict";function i(e,n,t,i,a,o,s,r){var l,u="function"==typeof e?e.options:e;if(n&&(u.render=n,u.staticRenderFns=t,u._compiled=!0),i&&(u.functional=!0),o&&(u._scopeId="data-v-"+o),s?(l=function(e){(e=e||this.$vnode&&this.$vnode.ssrContext||this.parent&&this.parent.$vnode&&this.parent.$vnode.ssrContext)||"undefined"==typeof __VUE_SSR_CONTEXT__||(e=__VUE_SSR_CONTEXT__),a&&a.call(this,e),e&&e._registeredComponents&&e._registeredComponents.add(s)},u._ssrRegister=l):a&&(l=r?function(){a.call(this,(u.functional?this.parent:this).$root.$options.shadowRoot)}:a),l)if(u.functional){u._injectStyles=l;var d=u.render;u.render=function(e,n){return l.call(n),d(e,n)}}else{var p=u.beforeCreate;u.beforeCreate=p?[].concat(p,l):[l]}return{exports:e,options:u}}t.d(n,"a",(function(){return i}))},function(e,n,t){e.exports=t(51)},function(e,n){e.exports=function(e){var n=[];return n.toString=function(){return this.map((function(n){var t=function(e,n){var t=e[1]||"",i=e[3];if(!i)return t;if(n&&"function"==typeof btoa){var a=(s=i,"/*# sourceMappingURL=data:application/json;charset=utf-8;base64,"+btoa(unescape(encodeURIComponent(JSON.stringify(s))))+" */"),o=i.sources.map((function(e){return"/*# sourceURL="+i.sourceRoot+e+" */"}));return[t].concat(o).concat([a]).join("\n")}var s;return[t].join("\n")}(n,e);return n[2]?"@media "+n[2]+"{"+t+"}":t})).join("")},n.i=function(e,t){"string"==typeof e&&(e=[[null,e,""]]);for(var i={},a=0;a<this.length;a++){var o=this[a][0];"number"==typeof o&&(i[o]=!0)}for(a=0;a<e.length;a++){var s=e[a];"number"==typeof s[0]&&i[s[0]]||(t&&!s[2]?s[2]=t:t&&(s[2]="("+s[2]+") and ("+t+")"),n.push(s))}},n}},function(e,n,t){"use strict";t.r(n),t.d(n,"default",(function(){return m}));var i=t(9),a=t.n(i),o="undefined"!=typeof document;if("undefined"!=typeof DEBUG&&DEBUG&&!o)throw new Error("vue-style-loader cannot be used in a non-browser environment. Use { target: 'node' } in your Webpack config to indicate a server-rendering environment.");var s={},r=o&&(document.head||document.getElementsByTagName("head")[0]),l=null,u=0,d=!1,p=function(){},c=null,f="undefined"!=typeof navigator&&/msie [6-9]\b/.test(navigator.userAgent.toLowerCase());function m(e,n,t,i){d=t,c=i||{};var o=a()(e,n);return h(o),function(n){for(var t=[],i=0;i<o.length;i++){var r=o[i];(l=s[r.id]).refs--,t.push(l)}n?h(o=a()(e,n)):o=[];for(i=0;i<t.length;i++){var l;if(0===(l=t[i]).refs){for(var u=0;u<l.parts.length;u++)l.parts[u]();delete s[l.id]}}}}function h(e){for(var n=0;n<e.length;n++){var t=e[n],i=s[t.id];if(i){i.refs++;for(var a=0;a<i.parts.length;a++)i.parts[a](t.parts[a]);for(;a<t.parts.length;a++)i.parts.push(b(t.parts[a]));i.parts.length>t.parts.length&&(i.parts.length=t.parts.length)}else{var o=[];for(a=0;a<t.parts.length;a++)o.push(b(t.parts[a]));s[t.id]={id:t.id,refs:1,parts:o}}}}function v(){var e=document.createElement("style");return e.type="text/css",r.appendChild(e),e}function b(e){var n,t,i=document.querySelector('style[data-vue-ssr-id~="'+e.id+'"]');if(i){if(d)return p;i.parentNode.removeChild(i)}if(f){var a=u++;i=l||(l=v()),n=_.bind(null,i,a,!1),t=_.bind(null,i,a,!0)}else i=v(),n=x.bind(null,i),t=function(){i.parentNode.removeChild(i)};return n(e),function(i){if(i){if(i.css===e.css&&i.media===e.media&&i.sourceMap===e.sourceMap)return;n(e=i)}else t()}}var g,y=(g=[],function(e,n){return g[e]=n,g.filter(Boolean).join("\n")});function _(e,n,t,i){var a=t?"":i.css;if(e.styleSheet)e.styleSheet.cssText=y(n,a);else{var o=document.createTextNode(a),s=e.childNodes;s[n]&&e.removeChild(s[n]),s.length?e.insertBefore(o,s[n]):e.appendChild(o)}}function x(e,n){var t=n.css,i=n.media,a=n.sourceMap;if(i&&e.setAttribute("media",i),c.ssrId&&e.setAttribute("data-vue-ssr-id",n.id),a&&(t+="\n/*# sourceURL="+a.sources[0]+" */",t+="\n/*# sourceMappingURL=data:application/json;base64,"+btoa(unescape(encodeURIComponent(JSON.stringify(a))))+" */"),e.styleSheet)e.styleSheet.cssText=t;else{for(;e.firstChild;)e.removeChild(e.firstChild);e.appendChild(document.createTextNode(t))}}},function(e,n){e.exports=Vue},function(e,n){e.exports=marked},function(e,n){e.exports=Vuex},function(e,n){e.exports=Cropper},function(e,n){e.exports=hljs},function(e,n,t){"use strict";Object.defineProperty(n,"__esModule",{value:!0}),n.default=function(e,n){for(var t=[],i={},a=0;a<n.length;a++){var o=n[a],s=o[0],r=o[1],l=o[2],u=o[3],d={id:e+":"+a,css:r,media:l,sourceMap:u};i[s]?i[s].parts.push(d):t.push(i[s]={id:s,parts:[d]})}return t}},function(e,n){e.exports='\n> **The document uses Google Translate**\n\n## Getting Started\n\n### NPM\n\n``` bash\nnpm install vue-upload-component --save\n```\n\n``` js\nconst VueUploadComponent = require(\'vue-upload-component\')\nVue.component(\'file-upload\', VueUploadComponent)\n```\n\n### Curated\n\n**No data**\n\n\n### Script\n\n\nunpkg\n\n``` html\n<script src="https://unpkg.com/vue"><\/script>\n<script src="https://unpkg.com/vue-upload-component"><\/script>\n<script>\nVue.component(\'file-upload\', VueUploadComponent)\n<\/script>\n```\n\njsDelivr\n\n``` html\n<script src="https://cdn.jsdelivr.net/npm/vue/dist/vue.js"><\/script>\n<script src="https://cdn.jsdelivr.net/npm/vue-upload-component"><\/script>\n<script>\nVue.component(\'file-upload\', VueUploadComponent)\n<\/script>\n```\n\n\n### Simple example\n\n\n\n```html\n<!DOCTYPE html>\n<html>\n<head>\n  <meta charset="utf-8">\n  <title>Vue-upload-component Test</title>\n  <script src="https://unpkg.com/vue"><\/script>\n  <script src="https://unpkg.com/vue-upload-component"><\/script>\n</head>\n<body>\n<div id="app">\n  <ul>\n    <li v-for="file in files">{{file.name}} - Error: {{file.error}}, Success: {{file.success}}</li>\n  </ul>\n  <file-upload\n    ref="upload"\n    v-model="files"\n    post-action="/post.method"\n    put-action="/put.method"\n    @input-file="inputFile"\n    @input-filter="inputFilter"\n  >\n  Upload file\n  </file-upload>\n  <button v-show="!$refs.upload || !$refs.upload.active" @click.prevent="$refs.upload.active = true" type="button">Start upload</button>\n  <button v-show="$refs.upload && $refs.upload.active" @click.prevent="$refs.upload.active = false" type="button">Stop upload</button>\n</div>\n<script>\nnew Vue({\n  el: \'#app\',\n  data: function () {\n    return {\n      files: []\n    }\n  },\n  components: {\n    FileUpload: VueUploadComponent\n  },\n  methods: {\n    /**\n     * Has changed\n     * @param  Object|undefined   newFile   Read only\n     * @param  Object|undefined   oldFile   Read only\n     * @return undefined\n     */\n    inputFile: function (newFile, oldFile) {\n      if (newFile && oldFile && !newFile.active && oldFile.active) {\n        // Get response data\n        console.log(\'response\', newFile.response)\n        if (newFile.xhr) {\n          //  Get the response status code\n          console.log(\'status\', newFile.xhr.status)\n        }\n      }\n    },\n    /**\n     * Pretreatment\n     * @param  Object|undefined   newFile   Read and write\n     * @param  Object|undefined   oldFile   Read only\n     * @param  Function           prevent   Prevent changing\n     * @return undefined\n     */\n    inputFilter: function (newFile, oldFile, prevent) {\n      if (newFile && !oldFile) {\n        // Filter non-image file\n        if (!/\\.(jpeg|jpe|jpg|gif|png|webp)$/i.test(newFile.name)) {\n          return prevent()\n        }\n      }\n\n      // Create a blob field\n      newFile.blob = \'\'\n      let URL = window.URL || window.webkitURL\n      if (URL && URL.createObjectURL) {\n        newFile.blob = URL.createObjectURL(newFile.file)\n      }\n    }\n  }\n});\n<\/script>\n</body>\n</html>\n```\n\n### Chunk Upload\n\nThis package allows chunk uploads, which means you can upload a file in different parts.\n\nThis process is divided in three phases: <strong>start</strong>, <strong>upload</strong>,<strong>finish</strong></p>\n\n#### start\n\nThis is the first phase of the process. We\'ll tell the backend that we are going to upload a file, with certain `size`, `name` and `mime_type`.\n\nUse the option `startBody` to add more parameters to the body of this request.\n\nThe backend should provide a `session_id` (to identify the upload) and a `end_offset` which is the size of every chunk\n\n##### HTTP start phase example\n\nRequest body example:\n```\n{\n  "phase": "start",\n  "mime_type": "image/png",\n  "size": 12669430,\n  "name":"hubbleimage1stscihp1809af6400x4800.png"\n}\n```\n\nResponse body example:\n```\n{\n  "data": {\n    "end_offset": 6291456,\n    "session_id": "61db8102-fca6-44ae-81e2-a499d438e7a5"\n  },\n  "status": "success"\n}\n\n```\n\n#### upload\n\nIn this phase we\'ll upload every chunk until all of them are uploaded. This step allows some failures in the backend, and will retry up to `maxRetries` times.\n\nWe\'ll send the `session_id`, `start_offset` and `chunk` (the sliced blob - part of file we are uploading). We expect the backend to return `{ status: \'success\' }`, we\'ll retry otherwise.\n\nUse the option `uploadBody` to add more parameters to the body of this request.\n\n##### HTTP upload phase example with 3 chunks\n\nRequest body example - chunk 1 from 3:\n```\n------WebKitFormBoundaryuI0uiY8h7MCbcysx\nContent-Disposition: form-data; name="phase"\n\nupload\n------WebKitFormBoundaryuI0uiY8h7MCbcysx\nContent-Disposition: form-data; name="session_id"\n\n61db8102-fca6-44ae-81e2-a499d438e7a5\n------WebKitFormBoundaryuI0uiY8h7MCbcysx\nContent-Disposition: form-data; name="start_offset"\n\n0\n------WebKitFormBoundaryuI0uiY8h7MCbcysx\nContent-Disposition: form-data; name="chunk"; filename="blob"\nContent-Type: application/octet-stream\n\n\n------WebKitFormBoundaryuI0uiY8h7MCbcysx--\n```\n\nResponse body example - chunk 1 from 3:\n```\n{\n  "status": "success"\n}\n```\n\nRequest body example - chunk 2 from 3:\n```\n------WebKitFormBoundary4cjBupFqrx1SrHoR\nContent-Disposition: form-data; name="phase"\n\nupload\n------WebKitFormBoundary4cjBupFqrx1SrHoR\nContent-Disposition: form-data; name="session_id"\n\n61db8102-fca6-44ae-81e2-a499d438e7a5\n------WebKitFormBoundary4cjBupFqrx1SrHoR\nContent-Disposition: form-data; name="start_offset"\n\n6291456\n------WebKitFormBoundary4cjBupFqrx1SrHoR\nContent-Disposition: form-data; name="chunk"; filename="blob"\nContent-Type: application/octet-stream\n\n\n------WebKitFormBoundary4cjBupFqrx1SrHoR-\n```\n\nResponse body example - chunk 2 from 3:\n```\n{\n  "status": "success"\n}\n```\n\nRequest body example - chunk 3 from 3:\n```\n------WebKitFormBoundarypWxg4xnB5QBDoFys\nContent-Disposition: form-data; name="phase"\n\nupload\n------WebKitFormBoundarypWxg4xnB5QBDoFys\nContent-Disposition: form-data; name="session_id"\n\n61db8102-fca6-44ae-81e2-a499d438e7a5\n------WebKitFormBoundarypWxg4xnB5QBDoFys\nContent-Disposition: form-data; name="start_offset"\n\n12582912\n------WebKitFormBoundarypWxg4xnB5QBDoFys\nContent-Disposition: form-data; name="chunk"; filename="blob"\nContent-Type: application/octet-stream\n\n\n------WebKitFormBoundarypWxg4xnB5QBDoFys--\n```\n\nResponse body example - chunk 1 from 3:\n```\n{\n  "status": "success"\n}\n```\n\n#### finish\n\nIn this phase we tell the backend that there are no more chunks to upload, so it can wrap everything. We send the `session_id` in this phase.\n\nUse the option `finishBody` to add more parameters to the body of this request.\n\n##### HTTP finish phase example\n\nRequest body example:\n```\n{\n  "phase": "finish",\n  "session_id": "61db8102-fca6-44ae-81e2-a499d438e7a5"\n}\n```\n\nResponse body example:\n```\n{\n  "status": "success"\n}\n```\n\n#### Example\n\nIn the following example we are going to add `Chunk Upload Functionality`. This component will use `Chunk Upload` when the size of the file is > `1MB`, it will behave as the `Simple example` when the size of the file is lower.\n\n```html\n  <file-upload\n    ref="upload"\n    v-model="files"\n    post-action="/post.method"\n    put-action="/put.method"\n\n    chunk-enabled\n    :chunk="{\n      action: \'/upload/chunk\',\n      minSize: 1048576,\n      maxActive: 3,\n      maxRetries: 5,\n\n      // Example in the case your backend also needs the user id to operate\n      startBody: {\n        user_id: user.id\n      }\n    }"\n\n    @input-file="inputFile"\n    @input-filter="inputFilter"\n  >\n  Upload file\n  </file-upload>\n```\n\n#### Extending the handler\n\nWe are using the class `src/chunk/ChunkUploadHandler` class to implement this protocol. You can extend this class (or even create a different one from scratch) to implement your own way to communicat with the backend.\n\nThis class must implement a method called `upload` which **must** return a promise. This promise will be used by the `FileUpload` component to determinate whether the file was uploaded or failed.\n\nUse the `handler` parameter to use a different Handler\n\n```html\n :chunk="{\n   action: \'/upload/chunk\',\n   minSize: 1048576,\n   maxActive: 3,\n   maxRetries: 5,\n\n   handler: MyHandlerClass\n }\n```\n\n### SSR (Server isomorphism)\n\n\n```html\n<template>\n  <file-upload v-model="files" post-action="/">Upload file</file-upload>\n</template>\n<style>\n/*\nimport \'~vue-upload-component/dist/vue-upload-component.part.css\'\n@import "~vue-upload-component/dist/vue-upload-component.part.css";\n\n\nor\n\n\n */\n.file-uploads {\n  overflow: hidden;\n  position: relative;\n  text-align: center;\n  display: inline-block;\n}\n.file-uploads.file-uploads-html4 input[type="file"] {\n  opacity: 0;\n  font-size: 20em;\n  z-index: 1;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  position: absolute;\n  width: 100%;\n  height: 100%;\n}\n.file-uploads.file-uploads-html5 input[type="file"] {\n  overflow: hidden;\n  position: fixed;\n  width: 1px;\n  height: 1px;\n  z-index: -1;\n  opacity: 0;\n}\n</style>\n<script>\nimport FileUpload from \'vue-upload-component/dist/vue-upload-component.part.js\'\nexport default {\n  components: {\n    FileUpload,\n  },\n  data() {\n    return {\n      files: []\n    }\n  },\n}\n<\/script>\n```\n\n\n** OR **\n\n\n```js\nimport FileUpload from \'vue-upload-component/src\'\n```\n\n\nwebpack.config.js\n\n```js\nconst nodeExternals = require(\'webpack-node-externals\');\n{\n  //.....\n  externals: [\n    nodeExternals({whitelist:[/^vue-upload-component\\/src/]})\n  ]\n  //.....\n}\n```\n\n* [https://github.com/liady/webpack-node-externals](https://github.com/liady/webpack-node-externals)\n\n* [**`vue-hackernews` demo**](https://github.com/lian-yue/vue-hackernews-2.0/)\n\n* [**View changes**](https://github.com/lian-yue/vue-hackernews-2.0/commit/bd6c58a30cc6b8ba6c0148e737b3ce9336b99cf8)\n\n\n\n\n## Options / Props\n\n\n### input-id\n\nThe `id` attribute of the input tag\n\n* **Type:** `String`\n\n* **Default:** `this.name`\n\n* **Usage:**\n  ```html\n  <file-upload input-id="file2"></file-upload>\n  \x3c!--Output--\x3e\n  <input id="file2" />\n  ```\n\n\n\n\n\n### name\n\nThe `name` attribute of the input tag\n\n* **Type:** `String`\n\n* **Default:** `file`\n\n* **Usage:**\n  ```html\n  <file-upload name="file"></file-upload>\n  \x3c!--Output--\x3e\n  <input name="file" />\n  ```\n\n\n\n\n\n### post-action\n\n`POST` Request upload URL\n\n* **Type:** `String`\n\n* **Default:** `undefined`\n\n* **Usage:**\n  ```html\n  <file-upload post-action="/upload/post.php"></file-upload>\n  ```\n\n\n\n\n\n### put-action\n\n`PUT` Request upload URL\n\n* **Type:** `String`\n\n* **Default:** `undefined`\n\n* **Browser:** `> IE9`\n\n* **Details:**\n\n  `put-action` is not empty Please give priority to` PUT` request\n\n* **Usage:**\n  ```html\n  <file-upload put-action="/upload/put.php"></file-upload>\n  ```\n\n\n\n### custom-action\n\nCustom upload method\n\n* **Type:** `async Function`\n\n* **Default:** `undefined`\n\n* **Details:**  \n\n  `custom-action` priority than `put-action, post-action`\n\n* **Usage:**\n  ```html\n  <file-upload :custom-action="customAction"></file-upload>\n  ```\n  ```js\n  async function customAction(file, component) {\n    // return await component.uploadPut(file)\n    return await component.uploadHtml4(file)\n  }\n  ```\n\n\n\n\n\n### headers\n\nAttach `header` data\n\n* **Type:** `Object`\n\n* **Default:** `{}`\n\n* **Browser:** `> IE9`\n\n* **Usage:**\n  ```html\n  <file-upload :headers="{\'X-Token-CSRF\': \'code\'}"></file-upload>\n  ```\n\n\n\n\n\n### data\n\n`POST request`:  Append request `body`\n`PUT request`:  Append request `query`\n\n* **Type:** `Object`\n\n* **Default:** `{}`\n\n* **Usage:**\n  ```html\n  <file-upload :data="{access_token: \'access_token\'}"></file-upload>\n  ```\n\n\n\n\n### value, v-model\n\nFile List\n\n* **Type:** `Array<File | Object>`\n\n* **Default:** `[]`\n\n* **Details:**\n\n  View **[`File`](#file)** details\n  > In order to prevent unpredictable errors, can not directly modify the `files`, please use [`add`](#instance-methods-add), [`update`](#instance-methods-update), [`remove`](#instance-methods-remove) method to modify\n\n* **Usage:**\n  ```html\n  <file-upload :value="files" @input="updatetValue"></file-upload>\n  \x3c!--or--\x3e\n  <file-upload v-model="files"></file-upload>\n  ```\n\n\n\n\n\n### accept\n\nThe `accept` attribute of the input tag, MIME type\n\n* **Type:** `String`\n\n* **Default:** `undefined`\n\n* **Browser:** `> IE9`\n\n* **Usage:**\n  ```html\n  <file-upload accept="image/png,image/gif,image/jpeg,image/webp"></file-upload>\n  \x3c!--or--\x3e\n  <file-upload accept="image/*"></file-upload>\n  ```\n\n\n\n\n\n### multiple\n\nThe `multiple` attribute of the input tag\nWhether to allow multiple files to be selected\n\n* **Type:** `Boolean`\n\n* **Default:** `false`\n\n* **Details:**\n\n  If it is `false` file inside only one file will be automatically deleted\n\n* **Usage:**\n  ```html\n  <file-upload :multiple="true"></file-upload>\n  ```\n\n\n\n### directory\n\nThe `directory` attribute of the input tag\nWhether it is a upload folder\n\n* **Type:** `Boolean`\n\n* **Default:** `false`\n\n* **Browser:** [http://caniuse.com/#feat=input-file-directory](http://caniuse.com/#feat=input-file-directory)\n\n* **Usage:**\n  ```html\n  <file-upload :directory="true" :multiple="true"></file-upload>\n  ```\n\n\n\n\n\n### extensions\n\nAllow upload file extensions\n\n* **Type:** `Array | String | RegExp`\n\n* **Default:** `undefined`\n\n* **Usage:**\n  ```html\n  <file-upload extensions="jpg,gif,png,webp"></file-upload>\n  \x3c!--or--\x3e\n  <file-upload :extensions="[\'jpg\', \'gif\', \'png\', \'webp\']"></file-upload>\n  \x3c!--or--\x3e\n  <file-upload :extensions="/\\.(gif|jpe?g|png|webp)$/i"></file-upload>\n  ```\n\n\n\n\n### size\n\nAllow the maximum byte to upload\n\n* **Type:** `Number`\n\n* **Default:** `0`\n\n* **Browser:** `> IE9`\n\n* **Details:**\n\n  `0` is equal to not limit\n\n* **Usage:**\n  ```html\n  <file-upload :size="1024 * 1024"></file-upload>\n  ```\n\n\n\n\n### timeout\n\nUpload timeout time in milliseconds\n\n* **Type:** `Number`\n\n* **Default:** `0`\n\n* **Browser:** `> IE9`\n\n* **Usage:**\n  ```html\n  <file-upload :timeout="600 * 1000"></file-upload>\n  ```\n\n### maximum\n\nList the maximum number of files\n\n* **Type:** `Number`\n\n* **Default:** `props.multiple ? 0 : 1`\n\n* **Usage:**\n  ```html\n  <file-upload :maximum="10"></file-upload>\n  ```\n\n\n\n### thread\n\nAlso upload the number of files at the same time (number of threads)\n\n* **Type:** `Number`\n\n* **Default:** `1`\n\n* **Browser:** `> IE9`\n\n* **Usage:**\n  ```html\n  <file-upload :thread="3"></file-upload>\n  ```\n\n### chunk-enabled\n\nWhether chunk uploads is enabled or not\n\n* **Type:** `Boolean`\n\n* **Default:** `false`\n\n* **Usage:**\n  ```html\n  <file-upload :chunk-enabled="true"></file-upload>\n  <file-upload chunk-enabled></file-upload>\n  ```\n\n### chunk\n\nAll the options to handle chunk uploads\n\n* **Type:** `Object`\n\n* **Default:**\n```js\n{\n    headers: {\n      \'Content-Type\': \'application/json\'\n    },\n    action: \'\',\n    minSize: 1048576,\n    maxActive: 3,\n    maxRetries: 5,\n\n    // This is the default Handler implemented in this package\n    // you can use your own handler if your protocol is different\n    handler: ChunkUploadDefaultHandler\n}\n```\n\n### drop\n\nDrag and drop upload\n\n* **Type:** `Boolean | Element | CSS selector`\n\n* **Default:** `false`\n\n* **Browser:** [http://caniuse.com/#feat=dragndrop](http://caniuse.com/#feat=dragndrop)\n\n* **Details:**\n\n  If set to `true`, read the parent component as a container\n\n* **Usage:**\n  ```html\n  <file-upload :drop="true"></file-upload>\n  ```\n\n\n\n\n\n### drop-directory\n\nWhether to open the drag directory\n\n* **Type:** `Boolean`\n\n* **Default:** `true`\n\n* **Details:**\n\n  If set to `false` filter out the directory\n\n* **Usage:**\n  ```html\n  <file-upload :drop-directory="false"></file-upload>\n  ```\n\n\n\n### add-index\n\n* **Type:** `Boolean, Number`\n\n* **Default:** `undefined`\n\n* **Version:** : `>=2.6.1`\n\n* **Details:**\n\n  The default value of the `index` parameter for the [`add()`](#instance-methods-add) method\n\n* **Usage:**\n  ```html\n  <file-upload :add-index="true"></file-upload>\n  ```\n\n\n\n\n## Options / Events\n\nThe files is changed to trigger the method\nDefault for `v-model` binding\n\n### @input\n* **Arguments:**\n\n  * `files: Array<File | Object>`\n\n\n* **Usage:**\n  ```html\n  <template>\n    <file-upload :value="files" @input="updatetValue"></file-upload>\n    \x3c!--or--\x3e\n    <file-upload v-model="files"></file-upload>\n  </template>\n  <script>\n  export default {\n    data() {\n      return {\n        files: []\n      }\n    },\n    methods: {\n      updatetValue(value) {\n        this.files = value\n      }\n    }\n  }\n  <\/script>\n  ```\n\n\n\n### @input-filter\n\nAdd, update, remove pre-filter\n\n* **Arguments:**\n\n  * `newFile: File | Object | undefined`  `Read and write`\n  * `oldFile: File | Object | undefined`  `Read only`\n  * `prevent: Function`   Call this function to prevent modification\n\n\n* **Details:**\n\n  If the `newFile` value is `undefined` \'is deleted\n  If the `oldFile` value is `undefined` \'is added\n  If `newFile`, `oldFile` is exist, it is updated\n\n  > Synchronization modify `newFile`\n  > Asynchronous Please use `update`,` add`, `remove`,` clear` method\n  > Asynchronous Please set an error first to prevent being uploaded\n\n  > Synchronization can not use `update`,` add`, `remove`,` clear` methods\n  > Asynchronous can not modify `newFile`\n\n* **Usage:**\n  ```html\n  <template>\n    <ul>\n      <li v-for="file in files">\n        <img :src="file.blob" width="50" height="50" />\n      </li>\n    </ul>\n    <file-upload :value="files" @input-filter="inputFilter"></file-upload>\n  </template>\n  <script>\n  export default {\n    data() {\n      return {\n        files: []\n      }\n    },\n    methods: {\n      inputFilter(newFile, oldFile, prevent) {\n        if (newFile && !oldFile) {\n          // Add file\n\n          // Filter non-image file\n          // Will not be added to files\n          if (!/\\.(jpeg|jpe|jpg|gif|png|webp)$/i.test(newFile.name)) {\n            return prevent()\n          }\n\n          // Create the \'blob\' field for thumbnail preview\n          newFile.blob = \'\'\n          let URL = window.URL || window.webkitURL\n          if (URL && URL.createObjectURL) {\n            newFile.blob = URL.createObjectURL(newFile.file)\n          }\n        }\n\n        if (newFile && oldFile) {\n          // Update file\n\n          // Increase the version number\n          if (!newFile.version) {\n            newFile.version = 0\n          }\n          newFile.version++\n        }\n\n        if (!newFile && oldFile) {\n          // Remove file\n\n          // Refused to remove the file\n          // return prevent()\n        }\n      }\n    }\n  }\n  <\/script>\n  ```\n\n### @input-file\n\nAdd, update, remove after\n\n* **Arguments:**\n\n  * `newFile: File | Object | undefined` `Read only`\n  * `oldFile: File | Object | undefined` `Read only`\n\n\n* **Details:**\n\n  If the `newFile` value is `undefined` \'is deleted\n  If the `oldFile` value is `undefined` \'is added\n  If `newFile`, `oldFile` is exist, it is updated\n\n\n  >You can use `update`,` add`, `remove`,` clear` methods in the event\n  >You can not modify the `newFile` object in the event\n  >You can not modify the `oldFile` object in the event\n\n* **Usage:**\n  ```html\n  <template>\n    <file-upload ref="upload" v-model="files" @input-file="inputFile"></file-upload>\n  </template>\n  <script>\n  export default {\n    data() {\n      return {\n        files: []\n      }\n    },\n    methods: {\n      inputFile(newFile, oldFile) {\n        if (newFile && !oldFile) {\n          // Add file\n        }\n\n        if (newFile && oldFile) {\n          // Update file\n\n          // Start upload\n          if (newFile.active !== oldFile.active) {\n            console.log(\'Start upload\', newFile.active, newFile)\n\n            // min size\n            if (newFile.size >= 0 && newFile.size < 100 * 1024) {\n              newFile = this.$refs.upload.update(newFile, {error: \'size\'})\n            }\n          }\n\n          // Upload progress\n          if (newFile.progress !== oldFile.progress) {\n            console.log(\'progress\', newFile.progress, newFile)\n          }\n\n          // Upload error\n          if (newFile.error !== oldFile.error) {\n            console.log(\'error\', newFile.error, newFile)\n          }\n\n          // Uploaded successfully\n          if (newFile.success !== oldFile.success) {\n            console.log(\'success\', newFile.success, newFile)\n          }\n        }\n\n        if (!newFile && oldFile) {\n          // Remove file\n\n          // Automatically delete files on the server\n          if (oldFile.success && oldFile.response.id) {\n            // $.ajax({\n            //   type: \'DELETE\',\n            //   url: \'/file/delete?id=\' + oldFile.response.id,\n            // });\n          }\n        }\n\n        // Automatic upload\n        if (Boolean(newFile) !== Boolean(oldFile) || oldFile.error !== newFile.error) {\n          if (!this.$refs.upload.active) {\n            this.$refs.upload.active = true\n          }\n        }\n      }\n    }\n  }\n  <\/script>\n  ```\n\n\n\n## Instance / Data\n\n### features\n\nUsed to determine the browser support features\n\n* **Type:** `Object`\n\n* **Read only:** `true`\n\n* **Default:** `{ html5: true, directory: false, drop: false }`\n\n* **Usage:**\n  ```html\n  <app>\n    <file-upload ref="upload"></file-upload>\n    <span v-show="$refs.upload && $refs.upload.features.drop">Support drag and drop upload</span>\n    <span v-show="$refs.upload && $refs.upload.features.directory">Support folder upload</span>\n    <span v-show="$refs.upload && $refs.upload.features.html5">Support for HTML5</span>\n  </app>\n  ```\n\n\n\n### active\n\nActivation or abort upload\n\n* **Type:** `Boolean`\n\n* **Read only:** `false`\n\n* **Default:** `false`\n\n* **Usage:**\n  ```html\n  <app>\n    <file-upload ref="upload"></file-upload>\n    <span v-if="!$refs.upload || !$refs.upload.active" @click="$refs.upload.active = true">Start upload</span>\n    <span v-else @click="$refs.upload.active = false">Stop upload</span>\n  </app>\n  ```\n\n\n\n### dropActive\n\nIs dragging\n\n* **Type:** `Boolean`\n\n* **Read only:** `true`\n\n* **Default:** `false`\n\n* **Usage:**\n  ```html\n  <app>\n    <file-upload ref="upload" :drop="true"></file-upload>\n    <span v-show="$refs.upload && $refs.upload.dropActive">Drag and drop here for upload</span>\n  </app>\n  ```\n\n\n\n\n\n### uploaded\n\nAll uploaded\n\n* **Type:** `Boolean`\n\n* **Read only:** `true`\n\n* **Default:** `true`\n\n* **Usage:**\n  ```html\n  <app>\n    <file-upload ref="upload"></file-upload>\n    <span v-show="$refs.upload && $refs.upload.uploaded">All files have been uploaded</span>\n  </app>\n  ```\n\n\n\n\n\n## Instance / Methods\n\n\n\n### get()\n\nUse `id` to get a file object\n\n* **Arguments:**\n\n  * `id: File | Object | String`\n\n\n* **Result:** `File | Object | Boolean` There is a return file, object that otherwise returns `false`\n\n\n\n### add()\n\nAdd one or more files\n\n* **Arguments:**\n\n  * `files: Array<File | window.File | Object> | File | window.File | Object`     If it is an array of responses will be an array\n  * `index: Number | Boolean` = [`props.add-index`](#options-props-add-index)   `true = ` Start, `false = ` End, `Number = ` Index\n\n\n* **Result:** `Object | Array<File | Object> | Boolean`     The incoming array is returned to the array otherwise the object or `false`\n\n* **Usage:**\n  ```html\n  <template>\n    <ul>\n      <li v-for="file in files">\n        <span>{{file.name}}</span>\n      </li>\n    </ul>\n    <file-upload v-model="files"></file-upload>\n    <button type="button" @click.prevent="addText">Add a file</button>\n  </template>\n  <script>\n  export default {\n    data() {\n      return {\n        files: []\n      }\n    },\n    methods: {\n      addText() {\n        let file = new window.File([\'foo\'], \'foo.txt\', {\n          type: "text/plain",\n        })\n        this.$refs.upload.add(file)\n      }\n    }\n  }\n  <\/script>\n  ```\n\n\n###  addInputFile()\n\nAdd the file selected by `<input type = "file">` to the upload list\n\n* **Arguments:**\n\n  * `el: HTMLInputElement`     File element\n\n\n* **Result:** `Array<File>`  Added list of files\n\n* **Version:** : `>=2.5.1`\n\n\n\n###  addDataTransfer()\n\nAdd files that are dragged or pasted into the upload list\n\n* **Arguments:**\n\n  * `dataTransfer: DataTransfer`  Drag or paste data\n\n\n* **Result:** `Promise<Array<File>>`   Added list of files\n\n\n* **Version:** : `>=2.5.1`\n\n\n\n### update()\n\nUpdate a file object\n\n* **Arguments:**\n\n  * `id: File | Object | String`\n  * `data: Object`                    Updated data object\n\n\n* **Result:**  `Object | Boolean`  Successfully returned `newFile` failed to return` false`\n\n\n* **Usage:**\n  ```html\n  <template>\n    <ul>\n      <li v-for="file in files">\n        <span>{{file.name}}</span>\n        <button v-show="file.active" type="button" @click.prevent="abort(file)">Abort</button>\n      </li>\n    </ul>\n    <file-upload v-model="files"></file-upload>\n  </template>\n  <script>\n  export default {\n    data() {\n      return {\n        files: []\n      }\n    },\n    methods: {\n      abort(file) {\n        this.$refs.upload.update(file, {active: false})\n        // or\n        // this.$refs.upload.update(file, {error: \'abort\'})\n      }\n    }\n  }\n  <\/script>\n  ```\n\n### remove()\n\nRemove a file object\n\n* **Arguments:**\n\n  * `id: File | Object | String`\n\n\n* **Result:**  `Object | Boolean`  Successfully returned `oldFile` failed to return` false`\n\n* **Usage:**\n  ```html\n  <template>\n    <ul>\n      <li v-for="file in files">\n        <span>{{file.name}}</span>\n        <button type="button" @click.prevent="remove(file)">Remove</button>\n      </li>\n    </ul>\n    <file-upload v-model="files"></file-upload>\n  </template>\n  <script>\n  export default {\n    data() {\n      return {\n        files: []\n      }\n    },\n    methods: {\n      remove(file) {\n        this.$refs.upload.remove(file)\n      }\n    }\n  }\n  <\/script>\n  ```\n\n### replace()\n  Replace the location of the two files\n\n* **Arguments:**\n\n  * `id1: File | Object | String`\n  * `id2: File | Object | String`\n\n\n* **Result:**  `Boolean`\n\n\n### clear()\n\nEmpty the file list\n\n* **Result:**  `Boolean`  Always return `true`\n\n\n\n## Instance / File\n\n\n\n> **File object in the `@input-filter` event outside the use of [`update`](#instance-methods-update) method**\n\n\n\n\n### fileObject\n\n* **Type:** `Boolean`\n\n* **Read only:** `true`\n\n* **Required:** `true`\n\n* **Default:** `true`\n\n* **Version:** : `>=2.6.0`\n\n* **Details:**\n\n  If the attribute does not exist, the object will not be processed internally\n  If the attribute does not exist, it is not `File` but `Object`\n\n\n\n\n### id\n\nFile ID\n\n* **Type:** `String | Number`\n\n* **Read only:** `false`\n\n* **Default:** `Math.random().toString(36).substr(2)`\n\n* **Details:**\n\n  >`id` can not be repeated\n  >Upload can not modify `id`\n\n\n### size\n\nFile size\n\n* **Type:** `Number`\n\n* **Read only:** `false`\n\n* **Default:** `-1`\n\n* **Browser:** `> IE9`\n\n\n### name\n\nFilename\n\n* **Type:** `String`\n\n* **Read only:** `false`\n\n* **Default:** ` `\n\n* **Details:**\n\n  Format:  `directory/filename.gif`  `filename.gif`\n\n\n\n### type\n\nMIME type\n\n* **Type:** `String`\n\n* **Read only:** `false`\n\n* **Default:** ` `\n\n* **Browser:** `> IE9`\n\n* **Details:**\n\n  Format:  `image/gif`   `image/png`  `text/html`\n\n\n\n\n### active\n\nActivation or abort upload\n\n* **Type:** `Boolean`\n\n* **Read only:** `false`\n\n* **Default:** `false`\n\n* **Details:**\n\n  `true` = Upload\n  `false` = Abort\n\n\n\n\n\n\n### error\n\nUpload failed error code\n\n* **Type:** `String`\n\n* **Read only:** `false`\n\n* **Default:** ` `\n\n* **Details:**\n\n  Built-in\n  `size`, `extension`, `timeout`, `abort`, `network`, `server`, `denied`\n\n\n\n\n### success\n\nWhether the upload was successful\n\n* **Type:** `Boolean`\n\n* **Read only:** `false`\n\n* **Default:** `false`\n\n\n### putAction\n\nCustomize the current file `PUT` URL\n\n* **Type:** `String`\n\n* **Read only:** `false`\n\n* **Default:** `this.putAction`\n\n\n\n### postAction\n\nCustomize the current file `POST` URL\n\n* **Type:** `String`\n\n* **Read only:** `false`\n\n* **Default:** `this.postAction`\n\n\n\n\n### headers\n\nCustomize the current file `HTTP` Header\n\n* **Type:** `Object`\n\n* **Read only:** `false`\n\n* **Default:** `this.headers`\n\n\n### data\n\nCustomize the current file `body` or` query` to attach content\n\n* **Type:** `Object`\n\n* **Read only:** `false`\n\n* **Default:** `this.data`\n\n\n### timeout\n\nCustomize the upload timeout for a current single file\n\n* **Type:** `Number`\n\n* **Read only:** `false`\n\n* **Default:** `this.timeout`\n\n\n### response\n\nResponse data\n\n* **Type:** `Object | String`\n\n* **Read only:** `false`\n\n* **Default:** `{}`\n\n\n\n\n### progress\n\nUpload progress\n\n* **Type:** `String`\n\n* **Read only:** `false`\n\n* **Default:** `0.00`\n\n* **Browser:** `> IE9`\n\n\n\n### speed\n\nPer second upload speed\n\n* **Type:** `Number`\n\n* **Read only:** `true`\n\n* **Default:** `0`\n\n* **Browser:** `> IE9`\n\n\n\n\n### xhr\n\n`HTML5` upload` XMLHttpRequest` object\n\n* **Type:** `XMLHttpRequest`\n\n* **Read only:** `true`\n\n* **Default:** `undefined`\n\n* **Browser:** `> IE9`\n\n\n\n\n### iframe\n\n`HTML4` upload` iframe` element\n\n* **Type:** `Element`\n\n* **Read only:** `true`\n\n* **Default:** `undefined`\n\n* **Browser:** `= IE9`\n'},function(e,n){e.exports='## 入门开始\n\n### NPM\n\n``` bash\nnpm install vue-upload-component --save\n```\n\n``` js\nconst VueUploadComponent = require(\'vue-upload-component\')\nVue.component(\'file-upload\', VueUploadComponent)\n```\n\n### Curated\n\n**No data**\n\n\n### 直接使用\n\n\nunpkg\n\n``` html\n<script src="https://unpkg.com/vue"><\/script>\n<script src="https://unpkg.com/vue-upload-component"><\/script>\n<script>\nVue.component(\'file-upload\', VueUploadComponent)\n<\/script>\n```\n\njsDelivr\n\n``` html\n<script src="https://cdn.jsdelivr.net/npm/vue/dist/vue.js"><\/script>\n<script src="https://cdn.jsdelivr.net/npm/vue-upload-component"><\/script>\n<script>\nVue.component(\'file-upload\', VueUploadComponent)\n<\/script>\n```\n\n\n### 简单的例子\n\n\n\n```html\n<!DOCTYPE html>\n<html>\n<head>\n  <meta charset="utf-8">\n  <title>Vue-upload-component Test</title>\n  <script src="https://unpkg.com/vue"><\/script>\n  <script src="https://unpkg.com/vue-upload-component"><\/script>\n</head>\n<body>\n<div id="app">\n  <ul>\n    <li v-for="file in files">{{file.name}} - Error: {{file.error}}, Success: {{file.success}}</li>\n  </ul>\n  <file-upload\n    ref="upload"\n    v-model="files"\n    post-action="/post.method"\n    put-action="/put.method"\n    @input-file="inputFile"\n    @input-filter="inputFilter"\n  >\n  上传文件\n  </file-upload>\n  <button v-show="!$refs.upload || !$refs.upload.active" @click.prevent="$refs.upload.active = true" type="button">开始上传</button>\n  <button v-show="$refs.upload && $refs.upload.active" @click.prevent="$refs.upload.active = false" type="button">停止上传</button>\n</div>\n<script>\nnew Vue({\n  el: \'#app\',\n  data: function () {\n    return {\n      files: []\n    }\n  },\n  components: {\n    FileUpload: VueUploadComponent\n  },\n  methods: {\n    /**\n     * Has changed\n     * @param  Object|undefined   newFile   只读\n     * @param  Object|undefined   oldFile   只读\n     * @return undefined\n     */\n    inputFile: function (newFile, oldFile) {\n      if (newFile && oldFile && !newFile.active && oldFile.active) {\n        // 获得相应数据\n        console.log(\'response\', newFile.response)\n        if (newFile.xhr) {\n          //  获得响应状态码\n          console.log(\'status\', newFile.xhr.status)\n        }\n      }\n    },\n    /**\n     * Pretreatment\n     * @param  Object|undefined   newFile   读写\n     * @param  Object|undefined   oldFile   只读\n     * @param  Function           prevent   阻止回调\n     * @return undefined\n     */\n    inputFilter: function (newFile, oldFile, prevent) {\n      if (newFile && !oldFile) {\n        // 过滤不是图片后缀的文件\n        if (!/\\.(jpeg|jpe|jpg|gif|png|webp)$/i.test(newFile.name)) {\n          return prevent()\n        }\n      }\n\n      // 创建 blob 字段 用于图片预览\n      newFile.blob = \'\'\n      let URL = window.URL || window.webkitURL\n      if (URL && URL.createObjectURL) {\n        newFile.blob = URL.createObjectURL(newFile.file)\n      }\n    }\n  }\n});\n<\/script>\n</body>\n</html>\n```\n\n\n\n### SSR (服务器同构)\n\n\n```html\n<template>\n  <file-upload v-model="files" post-action="/">Upload file</file-upload>\n</template>\n<style>\n/*\nimport \'~vue-upload-component/dist/vue-upload-component.part.css\'\n@import "~vue-upload-component/dist/vue-upload-component.part.css";\n\n或\n\n\n */\n.file-uploads {\n  overflow: hidden;\n  position: relative;\n  text-align: center;\n  display: inline-block;\n}\n.file-uploads.file-uploads-html4 input[type="file"] {\n  opacity: 0;\n  font-size: 20em;\n  z-index: 1;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  position: absolute;\n  width: 100%;\n  height: 100%;\n}\n.file-uploads.file-uploads-html5 input[type="file"] {\n  overflow: hidden;\n  position: fixed;\n  width: 1px;\n  height: 1px;\n  z-index: -1;\n  opacity: 0;\n}\n</style>\n<script>\nimport FileUpload from \'vue-upload-component/dist/vue-upload-component.part.js\'\nexport default {\n  components: {\n    FileUpload,\n  },\n  data() {\n    return {\n      files: []\n    }\n  },\n}\n<\/script>\n```\n\n\n** 或者 **\n\n\n```js\nimport FileUpload from \'vue-upload-component/src\'\n```\n\nwebpack.config.js\n\n```js\nconst nodeExternals = require(\'webpack-node-externals\');\n{\n  //...\n  externals: [\n    nodeExternals({whitelist:[/^vue-upload-component\\/src/]})\n  ]\n  //...\n}\n```\n\n* [https://github.com/liady/webpack-node-externals](https://github.com/liady/webpack-node-externals)  \n\n* [**`vue-hackernews` 演示**](https://github.com/lian-yue/vue-hackernews-2.0/)  \n\n* [**浏览修改文件**](https://github.com/lian-yue/vue-hackernews-2.0/commit/bd6c58a30cc6b8ba6c0148e737b3ce9336b99cf8)\n\n\n\n\n## 选项 / 属性\n\n\n### input-id\n\ninput 标签的 `id` 属性\n\n* **类型:** `String`\n\n* **默认值:** `this.name`\n\n* **示例:**\n  ```html\n  <file-upload input-id="file2"></file-upload>\n  \x3c!--输出--\x3e\n  <input id="file2" />\n  ```\n\n\n\n\n\n### name\n\ninput标签的 `name` 属性\n\n* **类型:** `String`\n\n* **默认值:** `file`\n\n* **示例:**\n  ```html\n  <file-upload name="file"></file-upload>\n  \x3c!--输出--\x3e\n  <input name="file" />\n  ```\n\n\n\n\n\n### post-action\n\n`POST` 请求的上传URL\n\n* **类型:** `String`\n\n* **默认值:** `undefined`\n\n* **示例:**\n  ```html\n  <file-upload post-action="/upload/post.php"></file-upload>\n  ```\n\n\n\n\n\n### put-action\n\n`PUT` 请求的上传URL\n\n* **类型:** `String`\n\n* **默认值:** `undefined`\n\n* **浏览器:** `> IE9`\n\n* **详细:**  \n\n  `put-action` 不为空请优先 `PUT` 请求  \n\n* **示例:**\n  ```html\n  <file-upload put-action="/upload/put.php"></file-upload>\n  ```\n\n\n\n### custom-action\n\n自定义上传方法\n\n* **类型:** `async Function`\n\n* **默认值:** `undefined`\n\n* **详细:**  \n\n  `custom-action` 优先级高于 `put-action, post-action`\n\n* **示例:**\n  ```html\n  <file-upload :custom-action="customAction"></file-upload>\n  ```\n  ```js\n  async function customAction(file, component) {\n    // return await component.uploadPut(file)\n    return await component.uploadHtml4(file)\n  }\n  ```\n\n\n\n### headers\n\n自定义上传请求 `header` 数据\n\n* **类型:** `Object`\n\n* **默认值:** `{}`\n\n* **浏览器:** `> IE9`\n\n* **示例:**\n  ```html\n  <file-upload :headers="{\'X-Token-CSRF\': \'code\'}"></file-upload>\n  ```\n\n\n\n\n\n### data\n\n`POST 请求`: 附加请求的 body  \n`PUT 请求`: 附加请求的 query  \n\n* **类型:** `Object`\n\n* **默认值:** `{}`\n\n* **示例:**\n  ```html\n  <file-upload :data="{access_token: \'access_token\'}"></file-upload>\n  ```\n\n\n\n\n### value, v-model\n\n文件列表\n\n* **类型:** `Array<File | Object>`\n\n* **默认值:** `[]`\n\n* **详细:**  \n\n  浏览 **[`File`](#file)** 详细信息  \n  > 为了防止不可预知的错误，不可直接修改 `files`，请使用 [`add`](#实例-方法-add), [`update`](#实例-方法-update), [`remove`](#实例-方法-remove) 方法修改\n\n* **示例:**\n  ```html\n  <file-upload :value="files" @input="updatetValue"></file-upload>\n  \x3c!--或--\x3e\n  <file-upload v-model="files"></file-upload>\n  ```\n\n\n\n\n\n### accept\n\n表单的`accept`属性, MIME type  \n\n* **类型:** `String`\n\n* **默认值:** `undefined`\n\n* **浏览器:** `> IE9`\n\n* **示例:**\n  ```html\n  <file-upload accept="image/png,image/gif,image/jpeg,image/webp"></file-upload>\n  \x3c!--或--\x3e\n  <file-upload accept="image/*"></file-upload>\n  ```\n\n\n\n\n\n### multiple\n\n文件表单的 `multiple` 属性  \n是否允许选择多个文件  \n\n* **类型:** `Boolean`\n\n* **默认值:** `false`\n\n* **详细:**  \n\n  如果是 `false` `files` 里面最多只有一个文件 多的会自动删除  \n\n* **示例:**\n  ```html\n  <file-upload :multiple="true"></file-upload>\n  ```\n\n\n\n### directory\n\n文件表单的 `directory` 属性  \n是否是上传文件夹  \n\n* **类型:** `Boolean`\n\n* **默认值:** `false`\n\n* **浏览器:** [http://caniuse.com/#feat=input-file-directory](http://caniuse.com/#feat=input-file-directory)\n\n* **示例:**\n  ```html\n  <file-upload :directory="true" :multiple="true"></file-upload>\n  ```\n\n\n\n\n\n### extensions\n\n允许上传的文件后缀\n\n* **类型:** `Array | String | RegExp`\n\n* **默认值:** `undefined`\n\n* **示例:**\n  ```html\n  <file-upload extensions="jpg,gif,png,webp"></file-upload>\n  \x3c!--或--\x3e\n  <file-upload :extensions="[\'jpg\', \'gif\', \'png\', \'webp\']"></file-upload>\n  \x3c!--或--\x3e\n  <file-upload :extensions="/\\.(gif|jpe?g|png|webp)$/i"></file-upload>\n  ```\n\n\n\n\n### size\n\n允许上传的最大字节\n\n* **类型:** `Number`\n\n* **默认值:** `0`\n\n* **浏览器:** `> IE9`\n\n* **详细:**\n\n  `0` 等于不限制\n\n* **示例:**\n  ```html\n  <file-upload :size="1024 * 1024"></file-upload>\n  ```\n\n\n\n\n### timeout\n\n上传超时时间毫秒\n\n* **类型:** `Number`\n\n* **默认值:** `0`\n\n* **浏览器:** `> IE9`\n\n* **示例:**\n  ```html\n  <file-upload :timeout="600 * 1000"></file-upload>\n  ```\n\n\n### maximum\n\n列表最大文件数\n\n* **类型:** `Number`\n\n* **默认值:** `props.multiple ? 0 : 1`\n\n* **示例:**\n  ```html\n  <file-upload :maximum="10"></file-upload>\n  ```\n\n\n\n\n### thread\n\n同时并发上传的文件数量 线程数  \n\n* **类型:** `Number`\n\n* **默认值:** `1`\n\n* **浏览器:** `> IE9`\n\n* **示例:**\n  ```html\n  <file-upload :thread="3"></file-upload>\n  ```\n\n\n\n\n\n### drop\n\n拖拽上传  \n\n* **类型:** `Boolean | Element | CSS selector`\n\n* **默认值:** `false`\n\n* **浏览器:** [http://caniuse.com/#feat=dragndrop](http://caniuse.com/#feat=dragndrop)\n\n* **详细:**\n\n  如果设置成 `true` 则读取父组件作为容器  \n\n* **示例:**\n  ```html\n  <file-upload :drop="true"></file-upload>\n  ```\n\n\n\n\n\n### drop-directory\n\n是否开启拖拽目录  \n\n* **类型:** `Boolean`\n\n* **默认值:** `true`\n\n* **详细:**\n\n  如果设置成 `false` 则过滤掉目录\n\n* **示例:**\n  ```html\n  <file-upload :drop-directory="false"></file-upload>\n  ```\n\n\n### add-index\n\n* **类型:** `Boolean, Number`\n\n* **默认值:** `undefined`\n\n* **版本:** `>= 2.6.1`\n\n* **详细:**\n\n  [`add()`](#实例-方法-add) 方法 `index` 参数的默认值\n\n* **示例:**\n  ```html\n  <file-upload :add-index="true"></file-upload>\n  ```\n\n\n\n## 选项 / 事件\n\n文件被改变触发的方法  \n默认用于`v-model`绑定\n\n### @input\n* **参数:**\n\n  * `files: Array<File | Object>`\n\n\n* **示例:**\n  ```html\n  <template>\n    <file-upload :value="files" @input="updatetValue"></file-upload>\n    \x3c!--或者--\x3e\n    <file-upload v-model="files"></file-upload>\n  </template>\n  <script>\n  export default {\n    data() {\n      return {\n        files: []\n      }\n    },\n    methods: {\n      updatetValue(value) {\n        this.files = value\n      }\n    }\n  }\n  <\/script>\n  ```\n\n\n\n### @input-filter\n\nAdd, update, remove pre-filter  \n\n* **参数:**\n\n  * `newFile: File | Object | undefined`  `读写`\n  * `oldFile: File | Object | undefined`  `只读`\n  * `prevent: Function`   调用该方法 阻止修改\n\n\n* **详细:**\n\n  如果 `newFile` 值为 `undefined` 则是删除  \n  如果 `oldFile` 值为 `undefined` 则是添加  \n  如果 `newFile`, `oldFile` 都存在则是更新\n\n  > 事件内同步处理请直接修改 `newFile`  \n  > 事件内异步处理请使用 `update`, `add`, `remove`, `clear` 方法  \n  > 异步请先设置一个错误以防止被上传\n\n  > 同步不能使用 `update`, `add`, `remove`, `clear` 方法  \n  > 异步不能修改 `newFile`\n\n\n* **示例:**  \n  ```html\n  <template>\n    <ul>\n      <li v-for="file in files">\n        <img :src="file.blob" width="50" height="50" />\n      </li>\n    </ul>\n    <file-upload :value="files" @input-filter="inputFilter"></file-upload>\n  </template>\n  <script>\n  export default {\n    data() {\n      return {\n        files: []\n      }\n    },\n    methods: {\n      inputFilter(newFile, oldFile, prevent) {\n        if (newFile && !oldFile) {\n          // 添加文件\n\n          // 过滤非图片文件\n          // 不会添加到 files 去\n          if (!/\\.(jpeg|jpe|jpg|gif|png|webp)$/i.test(newFile.name)) {\n            return prevent()\n          }\n\n          // 创建 `blob` 字段 用于缩略图预览\n          newFile.blob = \'\'\n          let URL = window.URL || window.webkitURL\n          if (URL && URL.createObjectURL) {\n            newFile.blob = URL.createObjectURL(newFile.file)\n          }\n        }\n\n        if (newFile && oldFile) {\n          // 更新文件\n\n          // 增加版本号\n          if (!newFile.version) {\n            newFile.version = 0\n          }\n          newFile.version++\n        }\n\n        if (!newFile && oldFile) {\n          // 移除文件\n\n          // 拒绝删除文件\n          // return prevent()\n        }\n      }\n    }\n  }\n  <\/script>\n  ```\n\n### @input-file\n\n添加，更新，移除 后\n\n* **参数:**\n\n  * `newFile: File | Object | undefined` `只读`\n  * `oldFile: File | Object | undefined` `只读`\n\n\n* **详细:**\n\n  如果 `newFile` 值为 `undefined` 则是删除  \n  如果 `oldFile` 值为 `undefined` 则是添加  \n  如果 `newFile`, `oldFile` 都存在则是更新\n\n  >事件内可使用 `update`, `add`, `remove`, `clear` 方法  \n  >事件内不可修改 `newFile` 对象  \n  >事件内不可修改 `oldFile` 对象\n\n* **示例:**\n  ```html\n  <template>\n    <file-upload ref="upload" v-model="files" @input-file="inputFile"></file-upload>\n  </template>\n  <script>\n  export default {\n    data() {\n      return {\n        files: []\n      }\n    },\n    methods: {\n      inputFile(newFile, oldFile) {\n        if (newFile && !oldFile) {\n          // 添加文件\n        }\n\n        if (newFile && oldFile) {\n          // 更新文件\n\n          // 开始上传\n          if (newFile.active !== oldFile.active) {\n            console.log(\'Start upload\', newFile.active, newFile)\n\n            // 限定最小字节\n            if (newFile.size >= 0 && newFile.size < 100 * 1024) {\n              newFile = this.$refs.upload.update(newFile, {error: \'size\'})\n            }\n          }\n\n          // 上传进度\n          if (newFile.progress !== oldFile.progress) {\n            console.log(\'progress\', newFile.progress, newFile)\n          }\n\n          // 上传错误\n          if (newFile.error !== oldFile.error) {\n            console.log(\'error\', newFile.error, newFile)\n          }\n\n          // 上传成功\n          if (newFile.success !== oldFile.success) {\n            console.log(\'success\', newFile.success, newFile)\n          }\n        }\n\n        if (!newFile && oldFile) {\n          // 删除文件\n\n          // 自动删除 服务器上的文件\n          if (oldFile.success && oldFile.response.id) {\n            // $.ajax({\n            //   type: \'DELETE\',\n            //   url: \'/file/delete?id=\' + oldFile.response.id,\n            // });\n          }\n        }\n\n        // 自动上传\n        if (Boolean(newFile) !== Boolean(oldFile) || oldFile.error !== newFile.error) {\n          if (!this.$refs.upload.active) {\n            this.$refs.upload.active = true\n          }\n        }\n      }\n    }\n  }\n  <\/script>\n  ```\n\n\n\n## 实例 / 数据\n\n### features\n\n用于判断浏览器支持的特性\n\n* **类型:** `Object`\n\n* **只读:** `true`\n\n* **默认值:** `{ html5: true, directory: false, drop: false }`\n\n* **示例:**\n  ```html\n  <app>\n    <file-upload ref="upload"></file-upload>\n    <span v-show="$refs.upload && $refs.upload.features.drop">支持拖拽上传</span>\n    <span v-show="$refs.upload && $refs.upload.features.directory">支持文件夹上传</span>\n    <span v-show="$refs.upload && $refs.upload.features.html5">支持HTML5</span>\n  </app>\n  ```\n\n\n\n### active\n\n激活或停止上传\n\n* **类型:** `Boolean`\n\n* **只读:** `false`\n\n* **默认值:** `false`\n\n* **示例:**\n  ```html\n  <app>\n    <file-upload ref="upload"></file-upload>\n    <span v-if="!$refs.upload || !$refs.upload.active" @click="$refs.upload.active = true">开始上传</span>\n    <span v-else @click="$refs.upload.active = false">停止上传</span>\n  </app>\n  ```\n\n\n\n### dropActive\n\n是否正在拖拽\n\n* **类型:** `Boolean`\n\n* **只读:** `true`\n\n* **默认值:** `false`\n\n* **示例:**\n  ```html\n  <app>\n    <file-upload ref="upload" :drop="true"></file-upload>\n    <span v-show="$refs.upload && $refs.upload.dropActive">拖拽到这里上传</span>\n  </app>\n  ```\n\n\n\n\n\n### uploaded\n\n是否全部已上传\n\n* **类型:** `Boolean`\n\n* **只读:** `true`\n\n* **默认值:** `true`\n\n* **示例:**\n  ```html\n  <app>\n    <file-upload ref="upload"></file-upload>\n    <span v-show="$refs.upload && $refs.upload.uploaded">全部文件已上传完毕</span>\n  </app>\n  ```\n\n\n\n\n\n## 实例 / 方法\n\n\n\n### get()\n\n使用`id`获得某个对象\n\n* **参数:**\n\n  * `id: File | Object | String`\n\n\n* **结果:** `File | Object | Boolean` 存在返回文件对象否则返回 `false`\n\n\n\n### add()\n\n添加一个或多个文件\n\n* **参数:**\n\n  * `files: Array<File | window.File | Object> | File | window.File | Object`     如果它是一个数组的响应将是一个数组\n  * `index: Number | Boolean` = [`props.add-index`](#选项-属性-add-index)   `true = ` 开始位置, `false = ` 结束位置, `Number = ` 下标位置\n\n\n* **结果:** `Object | Array<File | Object> | Boolean`     传入的是数组返回数组否则对象或`false`\n\n* **示例:**\n  ```html\n  <template>\n    <ul>\n      <li v-for="file in files">\n        <span>{{file.name}}</span>\n      </li>\n    </ul>\n    <file-upload v-model="files"></file-upload>\n    <button type="button" @click.prevent="addText">添加文件</button>\n  </template>\n  <script>\n  export default {\n    data() {\n      return {\n        files: []\n      }\n    },\n    methods: {\n      addText() {\n        let file = new window.File([\'foo\'], \'foo.txt\', {\n          type: "text/plain",\n        })\n        this.$refs.upload.add(file)\n      }\n    }\n  }\n  <\/script>\n  ```\n\n\n###  addInputFile()\n\n把`<input type="file">`选择的文件添加进上传列表  \n\n* **参数:**\n\n  * `el: HTMLInputElement`     文件元素\n\n\n* **结果:** `Array<File>`  返回已添加的文件列表\n\n* **版本:** : `>=2.5.1`\n\n\n\n###  addDataTransfer()\n\n把拖拽或者粘贴的数据的文件添加进上传列表  \n\n* **参数:**\n\n  * `dataTransfer: DataTransfer`  拖拽或者粘贴的数据\n\n\n* **结果:** `Promise<Array<File>>`   返回已添加的文件列表\n\n\n* **版本:** : `>=2.5.1`\n\n\n\n### update()\n\n更新某个对象\n\n* **参数:**\n\n  * `id: File | Object | String`\n  * `data: Object`                    更新的数据对象\n\n\n* **结果:**  `Object | Boolean`  成功返回 `newFile` 失败返回 `false`\n\n\n* **示例:**\n  ```html\n  <template>\n    <ul>\n      <li v-for="file in files">\n        <span>{{file.name}}</span>\n        <button v-show="file.active" type="button" @click.prevent="abort(file)">停止</button>\n      </li>\n    </ul>\n    <file-upload v-model="files"></file-upload>\n  </template>\n  <script>\n  export default {\n    data() {\n      return {\n        files: []\n      }\n    },\n    methods: {\n      abort(file) {\n        this.$refs.upload.update(file, {active: false})\n        // 或\n        // this.$refs.upload.update(file, {error: \'abort\'})\n      }\n    }\n  }\n  <\/script>\n  ```\n\n### remove()\n\n移除某个文件对象\n\n* **参数:**\n\n  * `id: File | Object | String`\n\n\n* **结果:**  `Object | Boolean`  成功返回 `oldFile` 失败返回 `false`\n\n* **示例:**\n  ```html\n  <template>\n    <ul>\n      <li v-for="file in files">\n        <span>{{file.name}}</span>\n        <button type="button" @click.prevent="remove(file)">移除</button>\n      </li>\n    </ul>\n    <file-upload v-model="files"></file-upload>\n  </template>\n  <script>\n  export default {\n    data() {\n      return {\n        files: []\n      }\n    },\n    methods: {\n      remove(file) {\n        this.$refs.upload.remove(file)\n      }\n    }\n  }\n  <\/script>\n  ```\n\n\n### replace()\n  替换两个文件的位置\n\n* **参数:**\n\n  * `id1: File | Object | String`\n  * `id2: File | Object | String`\n\n\n* **结果:**  `Boolean`\n\n\n\n### clear()\n\n清空文件列表\n\n* **结果:**  `Boolean`  总是返回 `true`\n\n\n\n## 实例 / File\n\n\n> **文件对象在`input-filter`事件外修改请使用 [`update`](#实例-方法-update) 方法**\n\n\n### fileObject\n\n* **类型:** `Boolean`\n\n* **只读:** `true`\n\n* **Required:** `true`\n\n* **默认值:** `true`\n\n* **版本:** : `>=2.6.0`\n\n* **详细:**\n\n  如果属性不存在，则不会在内部处理该对象  \n  如果属性不存在，它不是 `File` 而是 `Object`\n\n\n\n### id\n\n文件id\n\n* **类型:** `String | Number`\n\n* **只读:** `false`\n\n* **默认值:** `Math.random().toString(36).substr(2)`\n\n* **详细:**\n\n  >`id` can not be repeated  \n  >Upload can not modify `id`\n\n\n### size\n\n文件大小\n\n* **类型:** `Number`\n\n* **只读:** `false`\n\n* **默认值:** `-1`\n\n* **浏览器:** `> IE9`\n\n\n### name\n\n文件名  \n\n* **类型:** `String`\n\n* **只读:** `false`\n\n* **默认值:** ` `\n\n* **详细:**\n\n  格式:  `directory/filename.gif`  `filename.gif`  \n\n\n\n### type\n\nMIME类型\n\n* **类型:** `String`\n\n* **只读:** `false`\n\n* **默认值:** ` `\n\n* **浏览器:** `> IE9`\n\n* **详细:**\n\n  格式:  `image/gif`   `image/png`  `text/html`\n\n\n\n\n### active\n\n激活或终止上传\n\n* **类型:** `Boolean`\n\n* **只读:** `false`\n\n* **默认值:** `false`\n\n* **详细:**\n\n  `true` = 上传  \n  `false` = 停止  \n\n\n\n\n\n\n### error\n\n上传失败错误代码\n\n* **类型:** `String`\n\n* **只读:** `false`\n\n* **默认值:** ` `\n\n* **详细:**\n\n  内置\n  `size`, `extension`, `timeout`, `abort`, `network`, `server`, `denied`\n\n\n\n\n### success\n\n是否上传成功\n\n* **类型:** `Boolean`\n\n* **只读:** `false`\n\n* **默认值:** `false`\n\n\n### putAction\n\n自定义当前文件 `PUT` 地址\n\n* **类型:** `String`\n\n* **只读:** `false`\n\n* **默认值:** `this.putAction`\n\n\n\n### postAction\n\n自定义当前文件 `POST` 地址\n\n* **类型:** `String`\n\n* **只读:** `false`\n\n* **默认值:** `this.postAction`\n\n\n\n\n### headers\n\n自定义当前文件 `HTTP` Header\n\n* **类型:** `Object`\n\n* **只读:** `false`\n\n* **默认值:** `this.headers`\n\n\n### data\n\n自定义当前文件 `body` 或 `query` 附加内容\n\n* **类型:** `Object`\n\n* **只读:** `false`\n\n* **默认值:** `this.data`\n\n\n### timeout\n\n自定义当前单个文件的上传超时时间\n\n* **类型:** `Number`\n\n* **只读:** `false`\n\n* **默认值:** `this.timeout`\n\n\n### response\n\n响应的数据\n\n* **类型:** `Object | String`\n\n* **只读:** `false`\n\n* **默认值:** `{}`\n\n\n\n\n### progress\n\n上传进度\n\n* **类型:** `String`\n\n* **只读:** `false`\n\n* **默认值:** `0.00`\n\n* **浏览器:** `> IE9`\n\n\n\n### speed\n\n每秒的上传速度\n\n* **类型:** `Number`\n\n* **只读:** `true`\n\n* **默认值:** `0`\n\n* **浏览器:** `> IE9`\n\n\n\n\n### xhr\n\n`HTML5` 上传 `XMLHttpRequest` 对象\n\n* **类型:** `XMLHttpRequest`\n\n* **只读:** `true`\n\n* **默认值:** `undefined`\n\n* **浏览器:** `> IE9`\n\n\n\n\n### iframe\n\n`HTML4` 上传 `iframe` 元素\n\n* **类型:** `Element`\n\n* **只读:** `true`\n\n* **默认值:** `undefined`\n\n* **浏览器:** `= IE9`\n'},function(e,n,t){var i=t(29);"string"==typeof i&&(i=[[e.i,i,""]]),i.locals&&(e.exports=i.locals);(0,t(3).default)("200c6690",i,!0,{})},function(e,n,t){var i=t(31);"string"==typeof i&&(i=[[e.i,i,""]]),i.locals&&(e.exports=i.locals);(0,t(3).default)("5d737307",i,!0,{})},function(e,n,t){var i=t(33);"string"==typeof i&&(i=[[e.i,i,""]]),i.locals&&(e.exports=i.locals);(0,t(3).default)("5d077551",i,!0,{})},function(e,n,t){var i=t(35);"string"==typeof i&&(i=[[e.i,i,""]]),i.locals&&(e.exports=i.locals);(0,t(3).default)("721515d7",i,!0,{})},function(e,n,t){var i=t(37);"string"==typeof i&&(i=[[e.i,i,""]]),i.locals&&(e.exports=i.locals);(0,t(3).default)("115b2ce5",i,!0,{})},function(e,n,t){var i=t(39);"string"==typeof i&&(i=[[e.i,i,""]]),i.locals&&(e.exports=i.locals);(0,t(3).default)("9390d9ca",i,!0,{})},function(e,n,t){var i=t(41);"string"==typeof i&&(i=[[e.i,i,""]]),i.locals&&(e.exports=i.locals);(0,t(3).default)("29759953",i,!0,{})},function(e,n,t){var i=t(43);"string"==typeof i&&(i=[[e.i,i,""]]),i.locals&&(e.exports=i.locals);(0,t(3).default)("0478ff66",i,!0,{})},function(e,n,t){var i=t(45);"string"==typeof i&&(i=[[e.i,i,""]]),i.locals&&(e.exports=i.locals);(0,t(3).default)("104c49fc",i,!0,{})},function(e,n,t){var i=t(47);"string"==typeof i&&(i=[[e.i,i,""]]),i.locals&&(e.exports=i.locals);(0,t(3).default)("e68769d2",i,!0,{})},function(e,n,t){var i=t(49);"string"==typeof i&&(i=[[e.i,i,""]]),i.locals&&(e.exports=i.locals);(0,t(3).default)("2a9d85d8",i,!0,{})},function(e,n){e.exports=VueRouter},function(e,n){e.exports=VueI18n},function(e,n){e.exports=ImageCompressor},function(e,n,t){e.exports=t(50)},function(e,n,t){var i={"./en":10,"./en.md":10,"./zh-cn":11,"./zh-cn.md":11};function a(e){var n=o(e);return t(n)}function o(e){if(!t.o(i,e)){var n=new Error("Cannot find module '"+e+"'");throw n.code="MODULE_NOT_FOUND",n}return i[e]}a.keys=function(){return Object.keys(i)},a.resolve=o,e.exports=a,a.id=27},function(e,n,t){"use strict";t(12)},function(e,n,t){(e.exports=t(2)(!1)).push([e.i,"\n.document-title {\n  margin-bottom: 2rem;\n  padding-bottom: 1rem;\n  border-bottom: 1px solid #ddd;\n}\n.document-content h2 {\n  padding-top: 1rem;\n  padding-bottom: 1rem;\n  margin-top: 4rem;\n  border-bottom: 1px solid #eaecef;\n}\n.document-content h2:first-child {\n  margin-top: 0;\n}\n.document-content h2 + h3 {\n  margin-top: 0rem;\n}\n.document-content h3 {\n  margin-top: 1.5rem;\n  padding-top: 1rem;\n  margin-bottom: 1rem;\n}\n\n",""])},function(e,n,t){"use strict";t(13)},function(e,n,t){(e.exports=t(2)(!1)).push([e.i,"\n.file-uploads {\n  overflow: hidden;\n  position: relative;\n  text-align: center;\n  display: inline-block;\n}\n.file-uploads.file-uploads-html4 input, .file-uploads.file-uploads-html5 label {\n  /* background fix ie  click */\n  background: #fff;\n  opacity: 0;\n  font-size: 20em;\n  z-index: 1;\n  top: 0;\n  left: 0;\n  right: 0;\n  bottom: 0;\n  position: absolute;\n  width: 100%;\n  height: 100%;\n}\n.file-uploads.file-uploads-html5 input, .file-uploads.file-uploads-html4 label {\n  /* background fix ie  click */\n  background: rgba(255, 255, 255, 0);\n  overflow: hidden;\n  position: fixed;\n  width: 1px;\n  height: 1px;\n  z-index: -1;\n  opacity: 0;\n}\n",""])},function(e,n,t){"use strict";t(14)},function(e,n,t){(e.exports=t(2)(!1)).push([e.i,"\n.example-full .btn-group .dropdown-menu {\n  display: block;\n  visibility: hidden;\n  transition: all .2s\n}\n.example-full .btn-group:hover > .dropdown-menu {\n  visibility: visible;\n}\n.example-full label.dropdown-item {\n  margin-bottom: 0;\n}\n.example-full .btn-group .dropdown-toggle {\n  margin-right: .6rem\n}\n.example-full .filename {\n  margin-bottom: .3rem\n}\n.example-full .btn-is-option {\n  margin-top: 0.25rem;\n}\n.example-full .example-foorer {\n  padding: .5rem 0;\n  border-top: 1px solid #e9ecef;\n  border-bottom: 1px solid #e9ecef;\n}\n.example-full .edit-image img {\n  max-width: 100%;\n}\n.example-full .edit-image-tool {\n  margin-top: .6rem;\n}\n.example-full .edit-image-tool .btn-group{\n  margin-right: .6rem;\n}\n.example-full .footer-status {\n  padding-top: .4rem;\n}\n.example-full .drop-active {\n  top: 0;\n  bottom: 0;\n  right: 0;\n  left: 0;\n  position: fixed;\n  z-index: 9999;\n  opacity: .6;\n  text-align: center;\n  background: #000;\n}\n.example-full .drop-active h3 {\n  margin: -.5em 0 0;\n  position: absolute;\n  top: 50%;\n  left: 0;\n  right: 0;\n  -webkit-transform: translateY(-50%);\n  -ms-transform: translateY(-50%);\n  transform: translateY(-50%);\n  font-size: 40px;\n  color: #fff;\n  padding: 0;\n}\n",""])},function(e,n,t){"use strict";t(15)},function(e,n,t){(e.exports=t(2)(!1)).push([e.i,"\n.example-simple label.btn {\n  margin-bottom: 0;\n  margin-right: 1rem;\n}\n",""])},function(e,n,t){"use strict";t(16)},function(e,n,t){(e.exports=t(2)(!1)).push([e.i,"\n.example-avatar .avatar-upload .rounded-circle {\n  width: 200px;\n  height: 200px;\n}\n.example-avatar .text-center .btn {\n  margin: 0 .5rem\n}\n.example-avatar .avatar-edit-image {\n  max-width: 100%\n}\n.example-avatar .drop-active {\n  top: 0;\n  bottom: 0;\n  right: 0;\n  left: 0;\n  position: fixed;\n  z-index: 9999;\n  opacity: .6;\n  text-align: center;\n  background: #000;\n}\n.example-avatar .drop-active h3 {\n  margin: -.5em 0 0;\n  position: absolute;\n  top: 50%;\n  left: 0;\n  right: 0;\n  -webkit-transform: translateY(-50%);\n  -ms-transform: translateY(-50%);\n  transform: translateY(-50%);\n  font-size: 40px;\n  color: #fff;\n  padding: 0;\n}\n",""])},function(e,n,t){"use strict";t(17)},function(e,n,t){(e.exports=t(2)(!1)).push([e.i,"\n.example-drag label.btn {\n  margin-bottom: 0;\n  margin-right: 1rem;\n}\n.example-drag .drop-active {\n  top: 0;\n  bottom: 0;\n  right: 0;\n  left: 0;\n  position: fixed;\n  z-index: 9999;\n  opacity: .6;\n  text-align: center;\n  background: #000;\n}\n.example-drag .drop-active h3 {\n  margin: -.5em 0 0;\n  position: absolute;\n  top: 50%;\n  left: 0;\n  right: 0;\n  -webkit-transform: translateY(-50%);\n  -ms-transform: translateY(-50%);\n  transform: translateY(-50%);\n  font-size: 40px;\n  color: #fff;\n  padding: 0;\n}\n",""])},function(e,n,t){"use strict";t(18)},function(e,n,t){(e.exports=t(2)(!1)).push([e.i,"\n.example-multiple label.btn {\n  margin-bottom: 0;\n  margin-right: 1rem;\n}\n.example-multiple .upload {\n  margin-bottom: 1rem;\n}\n",""])},function(e,n,t){"use strict";t(19)},function(e,n,t){(e.exports=t(2)(!1)).push([e.i,"\n.example-simple label.btn {\n  margin-bottom: 0;\n  margin-right: 1rem;\n}\n",""])},function(e,n,t){"use strict";t(20)},function(e,n,t){(e.exports=t(2)(!1)).push([e.i,"\n.chunk-loading[data-v-c205936e] {\n  margin: -12px;\n  display: flex;\n  width: calc(100% + 24px);\n}\n.chunk-loading .chunk-loading-part[data-v-c205936e] {\n  height: 25px;\n  line-height: 25px;\n  flex: 1;\n  background: #ccc;\n  font-size: 14px;\n  color: white;\n  text-align: center;\n}\n.chunk-loading .chunk-loading-part.chunk-loading-part__uploaded[data-v-c205936e] {\n  background: #28A745;\n}\n",""])},function(e,n,t){"use strict";t(21)},function(e,n,t){(e.exports=t(2)(!1)).push([e.i,"\n.example-vuex label.btn {\n  margin-bottom: 0;\n  margin-right: 1rem;\n}\n",""])},function(e,n,t){"use strict";t(22)},function(e,n,t){(e.exports=t(2)(!1)).push([e.i,"\n#header {\n  position: -webkit-sticky;\n  position: sticky;\n  top: 0;\n  z-index: 1071;\n}\n#sidebar {\n  background: #fff;\n  border-right: 1px solid #e5e5e5;\n  border-bottom: 1px solid #e5e5e5;\n}\n@media (min-width: 768px) {\n#sidebar {\n    position: -webkit-sticky;\n    position: sticky;\n    top: 3.5rem;\n    z-index: 1000;\n    max-height: calc(100vh - 3.5rem);\n    border-right: 1px solid #e5e5e5;\n    border-bottom: 1px solid #e5e5e5;\n}\n}\n#sidebar-nav {\n  padding-top: 1rem;\n  padding-bottom: 1rem;\n  margin-right: -15px;\n  margin-left: -15px;\n  max-height: 100%;\n  overflow-y: auto;\n}\n#sidebar-nav .nav {\n  display: block;\n}\n#sidebar-nav .nav .nav-item .nav {\n  display: none;\n  margin-bottom: 1rem;\n}\n#sidebar-nav .nav .nav-item .nav {\n  display: none;\n  margin-bottom: 1rem;\n}\n#sidebar-nav .nav .nav-item.active .nav, #sidebar-nav .nav .active + .nav {\n  display: block;\n}\n@media (min-width: 768px) {\n#sidebar-nav .nav .nav-item .nav {\n    display: block;\n}\n}\n#sidebar-nav .nav .nav-link.active, #sidebar-nav .nav .active > .nav-link{\n  color: #262626;\n  font-weight: 500;\n}\n#sidebar-nav .nav-item .nav-link {\n  padding: .25rem 1rem;\n  font-weight: 500;\n  color: #666\n}\n#sidebar-nav .nav-item .nav-item .nav-link {\n  font-weight: 400;\n  font-size: 85%;\n  margin-left: 1rem\n}\n#main {\n  padding-top: 1rem;\n  margin-bottom: 2rem\n}\nblockquote {\n  margin-bottom: 1rem;\n  font-size: 1.25rem;\n  padding: 0 1em;\n  color: #6a737d;\n  border-left: 0.25em solid #dfe2e5;\n}\npre {\n  padding: 16px;\n  overflow: auto;\n  font-size: 85%;\n  line-height: 1.45;\n  background-color: #f6f8fa;\n  border-radius: 3px;\n}\n.modal-backdrop.fade {\n  visibility: hidden;\n}\n.modal-backdrop.fade.show {\n  visibility: visible;\n}\n.fade.show {\n  display: block;\n  z-index: 1072;\n}\n",""])},function(e,n,t){"use strict";t.r(n);var i=t(4),a=t.n(i),o=t(5),s=t.n(o),r=t(8),l=t.n(r),u=t(6),d=new(t.n(u).a.Store)({strict:!0,state:{files:[]},mutations:{updateFiles:function(e,n){e.files=n}}}),p=t(23),c=t.n(p),f=t(24),m=new(t.n(f).a)({locale:"en",messages:{"zh-cn":{header:{logo:"Vuejs",home:"首页",examples:"演示",documents:"文档",blog:"Blog",locale:"Language(语言)",issues:"Issues",github:"Github"},locale:{en:"English","zh-cn":"中文(简体)"},document:{title:"文档"},example:{full:"完整例子",simple:"简单例子",avatar:"上传头像",drag:"拖拽上传",multiple:"多个实例",vuex:"Vuex"}},en:{header:{logo:"Vuejs",home:"Home",examples:"Examples",documents:"Documentation",blog:"Blog",locale:"Language(语言)",issues:"Issues",github:"Github"},locale:{en:"English","zh-cn":"中文(简体)"},document:{title:"Documentation"},example:{full:"Full Example",simple:"Simple",avatar:"Upload avatar",drag:"Drag and drop",multiple:"Multiple instances",chunk:"Chunk upload",vuex:"Vuex"}}}}),h=t(0),v=Object(h.a)({},(function(){var e=this.$createElement;return(this._self._c||e)("router-view")}),[],!1,null,null,null).exports,b={mounted:function(){if(this.$route.hash){var e=document.querySelector(decodeURIComponent(this.$route.hash));e&&window.scrollTo(0,e.offsetTop)}},computed:{document:function(){return t(27)("./"+this.$i18n.locale)},navs:function(){for(var e=s.a.lexer(this.document),n={name:"",children:[],level:1},t=n,i=void 0,a=0;a<e.length;a++){var o=e[a];if("heading"===o.type){var r={name:o.text,hash:o.text.toLowerCase().replace(/([\u0000-\u002F\u003A-\u0060\u007B-\u007F]+)/g,"-").replace(/^\-+|\-+$/,""),level:o.depth,children:[]};if(i&&r.level!==i.level)if(r.level>i.level)t=i;else for(;r.level<i.level&&i.parent;)t=(i=i.parent).parent;else;r.parent=t,t.children.push(r),i=r}}return n.children}}},g=(t(28),Object(h.a)(b,(function(){var e=this,n=e.$createElement,t=e._self._c||n;return t("div",{staticClass:"container-fluid"},[t("div",{staticClass:"row flex-xl-nowrap"},[t("div",{staticClass:"col-12 col-md-3 col-xl-2",attrs:{id:"sidebar"}},[t("nav",{staticClass:"collapse show",attrs:{id:"sidebar-nav"}},[t("ul",{staticClass:"nav"},e._l(e.navs,(function(n,i){return t("li",{class:{"nav-item":!0,active:!e.$route.hash&&!i||1===e.$route.hash.indexOf(n.hash)}},[t("router-link",{class:{"nav-link":!0,active:1===e.$route.hash.indexOf(n.hash)},attrs:{"active-class":"active",to:"#"+n.hash}},[e._v(e._s(n.name))]),e._v(" "),n.children.length?t("ul",{staticClass:"nav"},e._l(n.children,(function(i){return t("li",{staticClass:"nav-item"},[t("router-link",{staticClass:"nav-link",attrs:{"active-class":"active",to:"#"+n.hash+"-"+i.hash}},[e._v(e._s(i.name))])],1)})),0):e._e()],1)})),0)])]),e._v(" "),t("main",{staticClass:"col-12 col-md-9 col-xl-10 py-md-3 pr-md-5 pl-md-5",attrs:{id:"main",role:"main"}},[t("h1",{staticClass:"document-title",attrs:{id:"document-title"}},[e._v(e._s(e.$t("document.title")))]),e._v(" "),t("div",{directives:[{name:"markdown",rawName:"v-markdown"}],staticClass:"document-content"},[e._v(e._s(e.document))])])])])}),[],!1,null,null,null).exports),y=Object(h.a)({},(function(){var e=this,n=e.$createElement,t=e._self._c||n;return t("div",{staticClass:"container-fluid"},[t("div",{staticClass:"row flex-xl-nowrap"},[t("div",{staticClass:"col-12 col-md-3 col-xl-2",attrs:{id:"sidebar"}},[t("nav",{staticClass:"collapse show",attrs:{id:"sidebar-nav"}},[t("ul",{staticClass:"nav"},[t("li",{staticClass:"nav-item"},[t("router-link",{staticClass:"nav-link",attrs:{"active-class":"active",to:e._f("toLocale")("/examples/full")}},[e._v(e._s(e.$t("example.full")))])],1),e._v(" "),t("li",{staticClass:"nav-item"},[t("router-link",{staticClass:"nav-link",attrs:{"active-class":"active",to:e._f("toLocale")("/examples/simple")}},[e._v(e._s(e.$t("example.simple")))])],1),e._v(" "),t("li",{staticClass:"nav-item"},[t("router-link",{staticClass:"nav-link",attrs:{"active-class":"active",to:e._f("toLocale")("/examples/avatar")}},[e._v(e._s(e.$t("example.avatar")))])],1),e._v(" "),t("li",{staticClass:"nav-item"},[t("router-link",{staticClass:"nav-link",attrs:{"active-class":"active",to:e._f("toLocale")("/examples/drag")}},[e._v(e._s(e.$t("example.drag")))])],1),e._v(" "),t("li",{staticClass:"nav-item"},[t("router-link",{staticClass:"nav-link",attrs:{"active-class":"active",to:e._f("toLocale")("/examples/multiple")}},[e._v(e._s(e.$t("example.multiple")))])],1),e._v(" "),t("li",{staticClass:"nav-item"},[t("router-link",{staticClass:"nav-link",attrs:{"active-class":"active",to:e._f("toLocale")("/examples/chunk")}},[e._v(e._s(e.$t("example.chunk")))])],1),e._v(" "),t("li",{staticClass:"nav-item"},[t("router-link",{staticClass:"nav-link",attrs:{"active-class":"active",to:e._f("toLocale")("/examples/vuex")}},[e._v(e._s(e.$t("example.vuex")))])],1)])])]),e._v(" "),t("main",{staticClass:"col-12 col-md-9 col-xl-10 py-md-3 pr-md-5 pl-md-5",attrs:{id:"main",role:"main"}},[t("router-view")],1)])])}),[],!1,null,null,null).exports,_=t(7),x=t.n(_),w=t(25),k=t.n(w),C=t(1),F=t.n(C),j=Object.assign||function(e){for(var n=1;n<arguments.length;n++){var t=arguments[n];for(var i in t)Object.prototype.hasOwnProperty.call(t,i)&&(e[i]=t[i])}return e},$={components:{FileUpload:F.a},data:function(){return{files:[],accept:"image/png,image/gif,image/jpeg,image/webp",extensions:"gif,jpg,jpeg,png,webp",minSize:1024,size:10485760,multiple:!0,directory:!1,drop:!0,dropDirectory:!0,addIndex:!1,thread:3,name:"file",postAction:"/upload/post",putAction:"/upload/put",headers:{"X-Csrf-Token":"xxxx"},data:{_csrf_token:"xxxxxx"},autoCompress:1048576,uploadAuto:!1,isOption:!1,addData:{show:!1,name:"",type:"",content:""},editFile:{show:!1,name:""}}},watch:{"editFile.show":function(e,n){!e&&n&&this.$refs.upload.update(this.editFile.id,{error:this.editFile.error||""}),e&&this.$nextTick((function(){if(this.$refs.editImage){var e=new x.a(this.$refs.editImage,{autoCrop:!1});this.editFile=j({},this.editFile,{cropper:e})}}))},"addData.show":function(e){e&&(this.addData.name="",this.addData.type="",this.addData.content="")}},methods:{inputFilter:function(e,n,t){var i=this;if(e&&!n){if(/(\/|^)(Thumbs\.db|desktop\.ini|\..+)$/.test(e.name))return t();if(/\.(php5?|html?|jsx?)$/i.test(e.name))return t();if(e.file&&"image/"===e.type.substr(0,6)&&this.autoCompress>0&&this.autoCompress<e.size)e.error="compressing",new k.a(null,{convertSize:1/0,maxWidth:512,maxHeight:512}).compress(e.file).then((function(n){i.$refs.upload.update(e,{error:"",file:n,size:n.size,type:n.type})})).catch((function(n){i.$refs.upload.update(e,{error:n.message||"compress"})}))}if(e&&(!n||e.file!==n.file)){e.blob="";var a=window.URL||window.webkitURL;a&&a.createObjectURL&&(e.blob=a.createObjectURL(e.file)),e.thumb="",e.blob&&"image/"===e.type.substr(0,6)&&(e.thumb=e.blob)}},inputFile:function(e,n){e&&n&&(e.active&&!n.active&&e.size>=0&&this.minSize>0&&e.size<this.minSize&&this.$refs.upload.update(e,{error:"size"}),e.progress,n.progress,e.error&&n.error,e.success&&n.success),!e&&n&&n.success&&n.response.id,Boolean(e)===Boolean(n)&&n.error===e.error||this.uploadAuto&&!this.$refs.upload.active&&(this.$refs.upload.active=!0)},alert:function(e){function n(n){return e.apply(this,arguments)}return n.toString=function(){return e.toString()},n}((function(e){alert(e)})),onEditFileShow:function(e){this.editFile=j({},e,{show:!0}),this.$refs.upload.update(e,{error:"edit"})},onEditorFile:function(){if(!this.$refs.upload.features.html5)return this.alert("Your browser does not support"),void(this.editFile.show=!1);var e={name:this.editFile.name};if(this.editFile.cropper){for(var n=atob(this.editFile.cropper.getCroppedCanvas().toDataURL(this.editFile.type).split(",")[1]),t=new Uint8Array(n.length),i=0;i<n.length;i++)t[i]=n.charCodeAt(i);e.file=new File([t],e.name,{type:this.editFile.type}),e.size=e.file.size}this.$refs.upload.update(this.editFile.id,e),this.editFile.error="",this.editFile.show=!1},onAddFolder:function(){var e=this;if(this.$refs.upload.features.directory){var n=this.$refs.upload.$el.querySelector("input");n.directory=!0,n.webkitdirectory=!0,this.directory=!0,n.onclick=null,n.click(),n.onclick=function(t){e.directory=!1,n.directory=!1,n.webkitdirectory=!1}}else this.alert("Your browser does not support")},onAddData:function(){if(this.addData.show=!1,this.$refs.upload.features.html5){var e=new window.File([this.addData.content],this.addData.name,{type:this.addData.type});this.$refs.upload.add(e)}else this.alert("Your browser does not support")}}},S=(t(32),Object(h.a)($,(function(){var e=this,n=e.$createElement,t=e._self._c||n;return t("div",{staticClass:"example-full"},[t("button",{staticClass:"btn btn-danger float-right btn-is-option",attrs:{type:"button"},on:{click:function(n){n.preventDefault(),e.isOption=!e.isOption}}},[t("i",{staticClass:"fa fa-cog",attrs:{"aria-hidden":"true"}}),e._v("\n    Options\n  ")]),e._v(" "),t("h1",{staticClass:"example-title",attrs:{id:"example-title"}},[e._v("Full Example")]),e._v(" "),t("div",{directives:[{name:"show",rawName:"v-show",value:e.$refs.upload&&e.$refs.upload.dropActive,expression:"$refs.upload && $refs.upload.dropActive"}],staticClass:"drop-active"},[t("h3",[e._v("Drop files to upload")])]),e._v(" "),t("div",{directives:[{name:"show",rawName:"v-show",value:!e.isOption,expression:"!isOption"}],staticClass:"upload"},[t("div",{staticClass:"table-responsive"},[t("table",{staticClass:"table table-hover"},[e._m(0),e._v(" "),t("tbody",[e.files.length?e._e():t("tr",[t("td",{attrs:{colspan:"7"}},[t("div",{staticClass:"text-center p-5"},[e._m(1),e._v(" "),t("label",{staticClass:"btn btn-lg btn-primary",attrs:{for:e.name}},[e._v("Select Files")])])])]),e._v(" "),e._l(e.files,(function(n,i){return t("tr",{key:n.id},[t("td",[e._v(e._s(i))]),e._v(" "),t("td",[n.thumb?t("img",{attrs:{src:n.thumb,width:"40",height:"auto"}}):t("span",[e._v("No Image")])]),e._v(" "),t("td",[t("div",{staticClass:"filename"},[e._v("\n                "+e._s(n.name)+"\n              ")]),e._v(" "),n.active||"0.00"!==n.progress?t("div",{staticClass:"progress"},[t("div",{class:{"progress-bar":!0,"progress-bar-striped":!0,"bg-danger":n.error,"progress-bar-animated":n.active},style:{width:n.progress+"%"},attrs:{role:"progressbar"}},[e._v(e._s(n.progress)+"%")])]):e._e()]),e._v(" "),t("td",[e._v(e._s(e._f("formatSize")(n.size)))]),e._v(" "),t("td",[e._v(e._s(e._f("formatSize")(n.speed)))]),e._v(" "),n.error?t("td",[e._v(e._s(n.error))]):n.success?t("td",[e._v("success")]):n.active?t("td",[e._v("active")]):t("td"),e._v(" "),t("td",[t("div",{staticClass:"btn-group"},[t("button",{staticClass:"btn btn-secondary btn-sm dropdown-toggle",attrs:{type:"button"}},[e._v("\n                  Action\n                ")]),e._v(" "),t("div",{staticClass:"dropdown-menu"},[t("a",{class:{"dropdown-item":!0,disabled:n.active||n.success||"compressing"===n.error},attrs:{href:"#"},on:{click:function(t){t.preventDefault(),!n.active&&!n.success&&"compressing"!==n.error&&e.onEditFileShow(n)}}},[e._v("Edit")]),e._v(" "),t("a",{class:{"dropdown-item":!0,disabled:!n.active},attrs:{href:"#"},on:{click:function(t){t.preventDefault(),n.active&&e.$refs.upload.update(n,{error:"cancel"})}}},[e._v("Cancel")]),e._v(" "),n.active?t("a",{staticClass:"dropdown-item",attrs:{href:"#"},on:{click:function(t){return t.preventDefault(),e.$refs.upload.update(n,{active:!1})}}},[e._v("Abort")]):n.error&&"compressing"!==n.error&&e.$refs.upload.features.html5?t("a",{staticClass:"dropdown-item",attrs:{href:"#"},on:{click:function(t){return t.preventDefault(),e.$refs.upload.update(n,{active:!0,error:"",progress:"0.00"})}}},[e._v("Retry upload")]):t("a",{class:{"dropdown-item":!0,disabled:n.success||"compressing"===n.error},attrs:{href:"#"},on:{click:function(t){t.preventDefault(),!n.success&&"compressing"!==n.error&&e.$refs.upload.update(n,{active:!0})}}},[e._v("Upload")]),e._v(" "),t("div",{staticClass:"dropdown-divider"}),e._v(" "),t("a",{staticClass:"dropdown-item",attrs:{href:"#"},on:{click:function(t){return t.preventDefault(),e.$refs.upload.remove(n)}}},[e._v("Remove")])])])])])}))],2)])]),e._v(" "),t("div",{staticClass:"example-foorer"},[t("div",{staticClass:"footer-status float-right"},[e._v("\n        Drop: "+e._s(!!e.$refs.upload&&e.$refs.upload.drop)+",\n        Active: "+e._s(!!e.$refs.upload&&e.$refs.upload.active)+",\n        Uploaded: "+e._s(!e.$refs.upload||e.$refs.upload.uploaded)+",\n        Drop active: "+e._s(!!e.$refs.upload&&e.$refs.upload.dropActive)+"\n      ")]),e._v(" "),t("div",{staticClass:"btn-group"},[t("file-upload",{ref:"upload",staticClass:"btn btn-primary dropdown-toggle",attrs:{"post-action":e.postAction,"put-action":e.putAction,extensions:e.extensions,accept:e.accept,multiple:e.multiple,directory:e.directory,size:e.size||0,thread:e.thread<1?1:e.thread>5?5:e.thread,headers:e.headers,data:e.data,drop:e.drop,"drop-directory":e.dropDirectory,"add-index":e.addIndex},on:{"input-filter":e.inputFilter,"input-file":e.inputFile},model:{value:e.files,callback:function(n){e.files=n},expression:"files"}},[t("i",{staticClass:"fa fa-plus"}),e._v("\n          Select\n        ")]),e._v(" "),t("div",{staticClass:"dropdown-menu"},[t("label",{staticClass:"dropdown-item",attrs:{for:e.name}},[e._v("Add files")]),e._v(" "),t("a",{staticClass:"dropdown-item",attrs:{href:"#"},on:{click:e.onAddFolder}},[e._v("Add folder")]),e._v(" "),t("a",{staticClass:"dropdown-item",attrs:{href:"#"},on:{click:function(n){n.preventDefault(),e.addData.show=!0}}},[e._v("Add data")])])],1),e._v(" "),e.$refs.upload&&e.$refs.upload.active?t("button",{staticClass:"btn btn-danger",attrs:{type:"button"},on:{click:function(n){n.preventDefault(),e.$refs.upload.active=!1}}},[t("i",{staticClass:"fa fa-stop",attrs:{"aria-hidden":"true"}}),e._v("\n        Stop Upload\n      ")]):t("button",{staticClass:"btn btn-success",attrs:{type:"button"},on:{click:function(n){n.preventDefault(),e.$refs.upload.active=!0}}},[t("i",{staticClass:"fa fa-arrow-up",attrs:{"aria-hidden":"true"}}),e._v("\n        Start Upload\n      ")])])]),e._v(" "),t("div",{directives:[{name:"show",rawName:"v-show",value:e.isOption,expression:"isOption"}],staticClass:"option"},[t("div",{staticClass:"form-group"},[t("label",{attrs:{for:"accept"}},[e._v("Accept:")]),e._v(" "),t("input",{directives:[{name:"model",rawName:"v-model",value:e.accept,expression:"accept"}],staticClass:"form-control",attrs:{type:"text",id:"accept"},domProps:{value:e.accept},on:{input:function(n){n.target.composing||(e.accept=n.target.value)}}}),e._v(" "),t("small",{staticClass:"form-text text-muted"},[e._v("Allow upload mime type")])]),e._v(" "),t("div",{staticClass:"form-group"},[t("label",{attrs:{for:"extensions"}},[e._v("Extensions:")]),e._v(" "),t("input",{directives:[{name:"model",rawName:"v-model",value:e.extensions,expression:"extensions"}],staticClass:"form-control",attrs:{type:"text",id:"extensions"},domProps:{value:e.extensions},on:{input:function(n){n.target.composing||(e.extensions=n.target.value)}}}),e._v(" "),t("small",{staticClass:"form-text text-muted"},[e._v("Allow upload file extension")])]),e._v(" "),t("div",{staticClass:"form-group"},[t("label",[e._v("PUT Upload:")]),e._v(" "),t("div",{staticClass:"form-check"},[t("label",{staticClass:"form-check-label"},[t("input",{directives:[{name:"model",rawName:"v-model",value:e.putAction,expression:"putAction"}],staticClass:"form-check-input",attrs:{type:"radio",name:"put-action",id:"put-action",value:""},domProps:{checked:e._q(e.putAction,"")},on:{change:function(n){e.putAction=""}}}),e._v(" Off\n        ")])]),e._v(" "),t("div",{staticClass:"form-check"},[t("label",{staticClass:"form-check-label"},[t("input",{directives:[{name:"model",rawName:"v-model",value:e.putAction,expression:"putAction"}],staticClass:"form-check-input",attrs:{type:"radio",name:"put-action",id:"put-action",value:"/upload/put"},domProps:{checked:e._q(e.putAction,"/upload/put")},on:{change:function(n){e.putAction="/upload/put"}}}),e._v(" On\n        ")])]),e._v(" "),t("small",{staticClass:"form-text text-muted"},[e._v("After the shutdown, use the POST method to upload")])]),e._v(" "),t("div",{staticClass:"form-group"},[t("label",{attrs:{for:"thread"}},[e._v("Thread:")]),e._v(" "),t("input",{directives:[{name:"model",rawName:"v-model.number",value:e.thread,expression:"thread",modifiers:{number:!0}}],staticClass:"form-control",attrs:{type:"number",max:"5",min:"1",id:"thread"},domProps:{value:e.thread},on:{input:function(n){n.target.composing||(e.thread=e._n(n.target.value))},blur:function(n){return e.$forceUpdate()}}}),e._v(" "),t("small",{staticClass:"form-text text-muted"},[e._v("Also upload the number of files at the same time (number of threads)")])]),e._v(" "),t("div",{staticClass:"form-group"},[t("label",{attrs:{for:"size"}},[e._v("Max size:")]),e._v(" "),t("input",{directives:[{name:"model",rawName:"v-model.number",value:e.size,expression:"size",modifiers:{number:!0}}],staticClass:"form-control",attrs:{type:"number",min:"0",id:"size"},domProps:{value:e.size},on:{input:function(n){n.target.composing||(e.size=e._n(n.target.value))},blur:function(n){return e.$forceUpdate()}}})]),e._v(" "),t("div",{staticClass:"form-group"},[t("label",{attrs:{for:"minSize"}},[e._v("Min size:")]),e._v(" "),t("input",{directives:[{name:"model",rawName:"v-model.number",value:e.minSize,expression:"minSize",modifiers:{number:!0}}],staticClass:"form-control",attrs:{type:"number",min:"0",id:"minSize"},domProps:{value:e.minSize},on:{input:function(n){n.target.composing||(e.minSize=e._n(n.target.value))},blur:function(n){return e.$forceUpdate()}}})]),e._v(" "),t("div",{staticClass:"form-group"},[t("label",{attrs:{for:"autoCompress"}},[e._v("Automatically compress:")]),e._v(" "),t("input",{directives:[{name:"model",rawName:"v-model.number",value:e.autoCompress,expression:"autoCompress",modifiers:{number:!0}}],staticClass:"form-control",attrs:{type:"number",min:"0",id:"autoCompress"},domProps:{value:e.autoCompress},on:{input:function(n){n.target.composing||(e.autoCompress=e._n(n.target.value))},blur:function(n){return e.$forceUpdate()}}}),e._v(" "),e.autoCompress>0?t("small",{staticClass:"form-text text-muted"},[e._v("More than "+e._s(e._f("formatSize")(e.autoCompress))+" files are automatically compressed")]):t("small",{staticClass:"form-text text-muted"},[e._v("Set up automatic compression")])]),e._v(" "),t("div",{staticClass:"form-group"},[t("div",{staticClass:"form-check"},[t("label",{staticClass:"form-check-label"},[t("input",{directives:[{name:"model",rawName:"v-model",value:e.addIndex,expression:"addIndex"}],staticClass:"form-check-input",attrs:{type:"checkbox",id:"add-index"},domProps:{checked:Array.isArray(e.addIndex)?e._i(e.addIndex,null)>-1:e.addIndex},on:{change:function(n){var t=e.addIndex,i=n.target,a=!!i.checked;if(Array.isArray(t)){var o=e._i(t,null);i.checked?o<0&&(e.addIndex=t.concat([null])):o>-1&&(e.addIndex=t.slice(0,o).concat(t.slice(o+1)))}else e.addIndex=a}}}),e._v(" Start position to add\n        ")])]),e._v(" "),t("small",{staticClass:"form-text text-muted"},[e._v("Add a file list to start the location to add")])]),e._v(" "),t("div",{staticClass:"form-group"},[t("div",{staticClass:"form-check"},[t("label",{staticClass:"form-check-label"},[t("input",{directives:[{name:"model",rawName:"v-model",value:e.drop,expression:"drop"}],staticClass:"form-check-input",attrs:{type:"checkbox",id:"drop"},domProps:{checked:Array.isArray(e.drop)?e._i(e.drop,null)>-1:e.drop},on:{change:function(n){var t=e.drop,i=n.target,a=!!i.checked;if(Array.isArray(t)){var o=e._i(t,null);i.checked?o<0&&(e.drop=t.concat([null])):o>-1&&(e.drop=t.slice(0,o).concat(t.slice(o+1)))}else e.drop=a}}}),e._v(" Drop\n        ")])]),e._v(" "),t("small",{staticClass:"form-text text-muted"},[e._v("Drag and drop upload")])]),e._v(" "),t("div",{staticClass:"form-group"},[t("div",{staticClass:"form-check"},[t("label",{staticClass:"form-check-label"},[t("input",{directives:[{name:"model",rawName:"v-model",value:e.dropDirectory,expression:"dropDirectory"}],staticClass:"form-check-input",attrs:{type:"checkbox",id:"drop-directory"},domProps:{checked:Array.isArray(e.dropDirectory)?e._i(e.dropDirectory,null)>-1:e.dropDirectory},on:{change:function(n){var t=e.dropDirectory,i=n.target,a=!!i.checked;if(Array.isArray(t)){var o=e._i(t,null);i.checked?o<0&&(e.dropDirectory=t.concat([null])):o>-1&&(e.dropDirectory=t.slice(0,o).concat(t.slice(o+1)))}else e.dropDirectory=a}}}),e._v(" Drop directory\n        ")])]),e._v(" "),t("small",{staticClass:"form-text text-muted"},[e._v("Not checked, filter the dragged folder")])]),e._v(" "),t("div",{staticClass:"form-group"},[t("div",{staticClass:"form-check"},[t("label",{staticClass:"form-check-label"},[t("input",{directives:[{name:"model",rawName:"v-model",value:e.uploadAuto,expression:"uploadAuto"}],staticClass:"form-check-input",attrs:{type:"checkbox",id:"upload-auto"},domProps:{checked:Array.isArray(e.uploadAuto)?e._i(e.uploadAuto,null)>-1:e.uploadAuto},on:{change:function(n){var t=e.uploadAuto,i=n.target,a=!!i.checked;if(Array.isArray(t)){var o=e._i(t,null);i.checked?o<0&&(e.uploadAuto=t.concat([null])):o>-1&&(e.uploadAuto=t.slice(0,o).concat(t.slice(o+1)))}else e.uploadAuto=a}}}),e._v(" Auto start\n        ")])]),e._v(" "),t("small",{staticClass:"form-text text-muted"},[e._v("Automatically activate upload")])]),e._v(" "),t("div",{staticClass:"form-group"},[t("button",{staticClass:"btn btn-primary btn-lg btn-block",attrs:{type:"button"},on:{click:function(n){n.preventDefault(),e.isOption=!e.isOption}}},[e._v("Confirm")])])]),e._v(" "),t("div",{class:{"modal-backdrop":!0,fade:!0,show:e.addData.show}}),e._v(" "),t("div",{class:{modal:!0,fade:!0,show:e.addData.show},attrs:{id:"modal-add-data",tabindex:"-1",role:"dialog"}},[t("div",{staticClass:"modal-dialog",attrs:{role:"document"}},[t("div",{staticClass:"modal-content"},[t("div",{staticClass:"modal-header"},[t("h5",{staticClass:"modal-title"},[e._v("Add data")]),e._v(" "),t("button",{staticClass:"close",attrs:{type:"button"},on:{click:function(n){n.preventDefault(),e.addData.show=!1}}},[t("span",[e._v("×")])])]),e._v(" "),t("form",{on:{submit:function(n){return n.preventDefault(),e.onAddData(n)}}},[t("div",{staticClass:"modal-body"},[t("div",{staticClass:"form-group"},[t("label",{attrs:{for:"name"}},[e._v("Name:")]),e._v(" "),t("input",{directives:[{name:"model",rawName:"v-model",value:e.addData.name,expression:"addData.name"}],staticClass:"form-control",attrs:{type:"text",required:"",id:"name",placeholder:"Please enter a file name"},domProps:{value:e.addData.name},on:{input:function(n){n.target.composing||e.$set(e.addData,"name",n.target.value)}}}),e._v(" "),e._m(2)]),e._v(" "),t("div",{staticClass:"form-group"},[t("label",{attrs:{for:"type"}},[e._v("Type:")]),e._v(" "),t("input",{directives:[{name:"model",rawName:"v-model",value:e.addData.type,expression:"addData.type"}],staticClass:"form-control",attrs:{type:"text",required:"",id:"type",placeholder:"Please enter the MIME type"},domProps:{value:e.addData.type},on:{input:function(n){n.target.composing||e.$set(e.addData,"type",n.target.value)}}}),e._v(" "),e._m(3)]),e._v(" "),t("div",{staticClass:"form-group"},[t("label",{attrs:{for:"content"}},[e._v("Content:")]),e._v(" "),t("textarea",{directives:[{name:"model",rawName:"v-model",value:e.addData.content,expression:"addData.content"}],staticClass:"form-control",attrs:{required:"",id:"content",rows:"3",placeholder:"Please enter the file contents"},domProps:{value:e.addData.content},on:{input:function(n){n.target.composing||e.$set(e.addData,"content",n.target.value)}}})])]),e._v(" "),t("div",{staticClass:"modal-footer"},[t("button",{staticClass:"btn btn-secondary",attrs:{type:"button"},on:{click:function(n){n.preventDefault(),e.addData.show=!1}}},[e._v("Close")]),e._v(" "),t("button",{staticClass:"btn btn-primary",attrs:{type:"submit"}},[e._v("Save")])])])])])]),e._v(" "),t("div",{class:{"modal-backdrop":!0,fade:!0,show:e.editFile.show}}),e._v(" "),t("div",{class:{modal:!0,fade:!0,show:e.editFile.show},attrs:{id:"modal-edit-file",tabindex:"-1",role:"dialog"}},[t("div",{staticClass:"modal-dialog modal-lg",attrs:{role:"document"}},[t("div",{staticClass:"modal-content"},[t("div",{staticClass:"modal-header"},[t("h5",{staticClass:"modal-title"},[e._v("Edit file")]),e._v(" "),t("button",{staticClass:"close",attrs:{type:"button"},on:{click:function(n){n.preventDefault(),e.editFile.show=!1}}},[t("span",[e._v("×")])])]),e._v(" "),t("form",{on:{submit:function(n){return n.preventDefault(),e.onEditorFile(n)}}},[t("div",{staticClass:"modal-body"},[t("div",{staticClass:"form-group"},[t("label",{attrs:{for:"name"}},[e._v("Name:")]),e._v(" "),t("input",{directives:[{name:"model",rawName:"v-model",value:e.editFile.name,expression:"editFile.name"}],staticClass:"form-control",attrs:{type:"text",required:"",id:"name",placeholder:"Please enter a file name"},domProps:{value:e.editFile.name},on:{input:function(n){n.target.composing||e.$set(e.editFile,"name",n.target.value)}}})]),e._v(" "),e.editFile.show&&e.editFile.blob&&e.editFile.type&&"image/"===e.editFile.type.substr(0,6)?t("div",{staticClass:"form-group"},[t("label",[e._v("Image: ")]),e._v(" "),t("div",{staticClass:"edit-image"},[t("img",{ref:"editImage",attrs:{src:e.editFile.blob}})]),e._v(" "),t("div",{staticClass:"edit-image-tool"},[t("div",{staticClass:"btn-group",attrs:{role:"group"}},[t("button",{staticClass:"btn btn-primary",attrs:{type:"button",title:"cropper.rotate(-90)"},on:{click:function(n){return e.editFile.cropper.rotate(-90)}}},[t("i",{staticClass:"fa fa-undo",attrs:{"aria-hidden":"true"}})]),e._v(" "),t("button",{staticClass:"btn btn-primary",attrs:{type:"button",title:"cropper.rotate(90)"},on:{click:function(n){return e.editFile.cropper.rotate(90)}}},[t("i",{staticClass:"fa fa-repeat",attrs:{"aria-hidden":"true"}})])]),e._v(" "),t("div",{staticClass:"btn-group",attrs:{role:"group"}},[t("button",{staticClass:"btn btn-primary",attrs:{type:"button",title:"cropper.crop()"},on:{click:function(n){return e.editFile.cropper.crop()}}},[t("i",{staticClass:"fa fa-check",attrs:{"aria-hidden":"true"}})]),e._v(" "),t("button",{staticClass:"btn btn-primary",attrs:{type:"button",title:"cropper.clear()"},on:{click:function(n){return e.editFile.cropper.clear()}}},[t("i",{staticClass:"fa fa-remove",attrs:{"aria-hidden":"true"}})])])])]):e._e()]),e._v(" "),t("div",{staticClass:"modal-footer"},[t("button",{staticClass:"btn btn-secondary",attrs:{type:"button"},on:{click:function(n){n.preventDefault(),e.editFile.show=!1}}},[e._v("Close")]),e._v(" "),t("button",{staticClass:"btn btn-primary",attrs:{type:"submit"}},[e._v("Save")])])])])])]),e._v(" "),e._m(4)])}),[function(){var e=this,n=e.$createElement,t=e._self._c||n;return t("thead",[t("tr",[t("th",[e._v("#")]),e._v(" "),t("th",[e._v("Thumb")]),e._v(" "),t("th",[e._v("Name")]),e._v(" "),t("th",[e._v("Size")]),e._v(" "),t("th",[e._v("Speed")]),e._v(" "),t("th",[e._v("Status")]),e._v(" "),t("th",[e._v("Action")])])])},function(){var e=this.$createElement,n=this._self._c||e;return n("h4",[this._v("Drop files anywhere to upload"),n("br"),this._v("or")])},function(){var e=this.$createElement,n=this._self._c||e;return n("small",{staticClass:"form-text text-muted"},[this._v("Such as "),n("code",[this._v("filename.txt")])])},function(){var e=this.$createElement,n=this._self._c||e;return n("small",{staticClass:"form-text text-muted"},[this._v("Such as "),n("code",[this._v("text/plain")])])},function(){var e=this.$createElement,n=this._self._c||e;return n("div",{staticClass:"pt-5"},[this._v("\n    Source code: "),n("a",{attrs:{href:"https://github.com/lian-yue/vue-upload-component/blob/master/docs/views/examples/Full.vue"}},[this._v("/docs/views/examples/Full.vue")])])}],!1,null,null,null).exports),D={components:{FileUpload:F.a},data:function(){return{files:[]}},methods:{inputFilter:function(e,n,t){if(e&&!n){if(/(\/|^)(Thumbs\.db|desktop\.ini|\..+)$/.test(e.name))return t();if(/\.(php5?|html?|jsx?)$/i.test(e.name))return t()}},inputFile:function(e,n){e&&!n&&console.log("add",e),e&&n&&console.log("update",e),!e&&n&&console.log("remove",n)}}},A=(t(34),Object(h.a)(D,(function(){var e=this,n=e.$createElement,t=e._self._c||n;return t("div",{staticClass:"example-simple"},[t("h1",{staticClass:"example-title",attrs:{id:"example-title"}},[e._v("Simple Example")]),e._v(" "),t("div",{staticClass:"upload"},[t("ul",e._l(e.files,(function(n,i){return t("li",{key:n.id},[t("span",[e._v(e._s(n.name))]),e._v(" -\n        "),t("span",[e._v(e._s(e._f("formatSize")(n.size)))]),e._v(" -\n        "),n.error?t("span",[e._v(e._s(n.error))]):n.success?t("span",[e._v("success")]):n.active||n.active?t("span",[e._v("active")]):t("span")])})),0),e._v(" "),t("div",{staticClass:"example-btn"},[t("file-upload",{ref:"upload",staticClass:"btn btn-primary",attrs:{"post-action":"/upload/post",extensions:"gif,jpg,jpeg,png,webp",accept:"image/png,image/gif,image/jpeg,image/webp",multiple:!0,size:10485760},on:{"input-filter":e.inputFilter,"input-file":e.inputFile},model:{value:e.files,callback:function(n){e.files=n},expression:"files"}},[t("i",{staticClass:"fa fa-plus"}),e._v("\n        Select files\n      ")]),e._v(" "),e.$refs.upload&&e.$refs.upload.active?t("button",{staticClass:"btn btn-danger",attrs:{type:"button"},on:{click:function(n){n.preventDefault(),e.$refs.upload.active=!1}}},[t("i",{staticClass:"fa fa-stop",attrs:{"aria-hidden":"true"}}),e._v("\n        Stop Upload\n      ")]):t("button",{staticClass:"btn btn-success",attrs:{type:"button"},on:{click:function(n){n.preventDefault(),e.$refs.upload.active=!0}}},[t("i",{staticClass:"fa fa-arrow-up",attrs:{"aria-hidden":"true"}}),e._v("\n        Start Upload\n      ")])],1)]),e._v(" "),e._m(0)])}),[function(){var e=this.$createElement,n=this._self._c||e;return n("div",{staticClass:"pt-5"},[this._v("\n    Source code: "),n("a",{attrs:{href:"https://github.com/lian-yue/vue-upload-component/blob/master/docs/views/examples/Simple.vue"}},[this._v("/docs/views/examples/Simple.vue")])])}],!1,null,null,null).exports),O={components:{FileUpload:F.a},data:function(){return{files:[],edit:!1,cropper:!1}},watch:{edit:function(e){e?this.$nextTick((function(){if(this.$refs.editImage){var e=new x.a(this.$refs.editImage,{aspectRatio:1,viewMode:1});this.cropper=e}})):this.cropper&&(this.cropper.destroy(),this.cropper=!1)}},methods:{editSave:function(){this.edit=!1;for(var e=this.files[0],n=atob(this.cropper.getCroppedCanvas().toDataURL(e.type).split(",")[1]),t=new Uint8Array(n.length),i=0;i<n.length;i++)t[i]=n.charCodeAt(i);var a=new File([t],e.name,{type:e.type});this.$refs.upload.update(e.id,{file:a,type:a.type,size:a.size,active:!0})},alert:function(e){function n(n){return e.apply(this,arguments)}return n.toString=function(){return e.toString()},n}((function(e){alert(e)})),inputFile:function(e,n,t){e&&!n&&this.$nextTick((function(){this.edit=!0})),!e&&n&&(this.edit=!1)},inputFilter:function(e,n,t){if(e&&!n&&!/\.(gif|jpg|jpeg|png|webp)$/i.test(e.name))return this.alert("Your choice is not a picture"),t();if(e&&(!n||e.file!==n.file)){e.url="";var i=window.URL||window.webkitURL;i&&i.createObjectURL&&(e.url=i.createObjectURL(e.file))}}}},U=(t(36),Object(h.a)(O,(function(){var e=this,n=e.$createElement,t=e._self._c||n;return t("div",{staticClass:"example-avatar"},[t("div",{directives:[{name:"show",rawName:"v-show",value:e.$refs.upload&&e.$refs.upload.dropActive,expression:"$refs.upload && $refs.upload.dropActive"}],staticClass:"drop-active"},[t("h3",[e._v("Drop files to upload")])]),e._v(" "),t("div",{directives:[{name:"show",rawName:"v-show",value:!e.edit,expression:"!edit"}],staticClass:"avatar-upload"},[t("div",{staticClass:"text-center p-2"},[t("label",{attrs:{for:"avatar"}},[t("img",{staticClass:"rounded-circle",attrs:{src:e.files.length?e.files[0].url:"https://www.gravatar.com/avatar/default?s=200&r=pg&d=mm"}}),e._v(" "),e._m(0)])]),e._v(" "),t("div",{staticClass:"text-center p-2"},[t("file-upload",{ref:"upload",staticClass:"btn btn-primary",attrs:{extensions:"gif,jpg,jpeg,png,webp",accept:"image/png,image/gif,image/jpeg,image/webp",name:"avatar","post-action":"/upload/post",drop:!e.edit},on:{"input-filter":e.inputFilter,"input-file":e.inputFile},model:{value:e.files,callback:function(n){e.files=n},expression:"files"}},[e._v("\n        Upload avatar\n      ")])],1)]),e._v(" "),t("div",{directives:[{name:"show",rawName:"v-show",value:e.files.length&&e.edit,expression:"files.length && edit"}],staticClass:"avatar-edit"},[e.files.length?t("div",{staticClass:"avatar-edit-image"},[t("img",{ref:"editImage",attrs:{src:e.files[0].url}})]):e._e(),e._v(" "),t("div",{staticClass:"text-center p-4"},[t("button",{staticClass:"btn btn-secondary",attrs:{type:"button"},on:{click:function(n){return n.preventDefault(),e.$refs.upload.clear(n)}}},[e._v("Cancel")]),e._v(" "),t("button",{staticClass:"btn btn-primary",attrs:{type:"submit"},on:{click:function(n){return n.preventDefault(),e.editSave(n)}}},[e._v("Save")])])]),e._v(" "),e._m(1)])}),[function(){var e=this.$createElement,n=this._self._c||e;return n("h4",{staticClass:"pt-2"},[this._v("or"),n("br"),this._v("Drop files anywhere to upload")])},function(){var e=this.$createElement,n=this._self._c||e;return n("div",{staticClass:"pt-5"},[this._v("\n    Source code: "),n("a",{attrs:{href:"https://github.com/lian-yue/vue-upload-component/blob/master/docs/views/examples/Avatar.vue"}},[this._v("/docs/views/examples/Avatar.vue")])])}],!1,null,null,null).exports),T={components:{FileUpload:F.a},data:function(){return{files:[]}}},R=(t(38),Object(h.a)(T,(function(){var e=this,n=e.$createElement,t=e._self._c||n;return t("div",{staticClass:"example-drag"},[t("div",{staticClass:"upload"},[e.files.length?t("ul",e._l(e.files,(function(n,i){return t("li",{key:n.id},[t("span",[e._v(e._s(n.name))]),e._v(" -\n        "),t("span",[e._v(e._s(e._f("formatSize")(n.size)))]),e._v(" -\n        "),n.error?t("span",[e._v(e._s(n.error))]):n.success?t("span",[e._v("success")]):n.active?t("span",[e._v("active")]):t("span")])})),0):t("ul",[e._m(0)]),e._v(" "),t("div",{directives:[{name:"show",rawName:"v-show",value:e.$refs.upload&&e.$refs.upload.dropActive,expression:"$refs.upload && $refs.upload.dropActive"}],staticClass:"drop-active"},[t("h3",[e._v("Drop files to upload")])]),e._v(" "),t("div",{staticClass:"example-btn"},[t("file-upload",{ref:"upload",staticClass:"btn btn-primary",attrs:{"post-action":"/upload/post",multiple:!0,drop:!0,"drop-directory":!0},model:{value:e.files,callback:function(n){e.files=n},expression:"files"}},[t("i",{staticClass:"fa fa-plus"}),e._v("\n        Select files\n      ")]),e._v(" "),e.$refs.upload&&e.$refs.upload.active?t("button",{staticClass:"btn btn-danger",attrs:{type:"button"},on:{click:function(n){n.preventDefault(),e.$refs.upload.active=!1}}},[t("i",{staticClass:"fa fa-stop",attrs:{"aria-hidden":"true"}}),e._v("\n        Stop Upload\n      ")]):t("button",{staticClass:"btn btn-success",attrs:{type:"button"},on:{click:function(n){n.preventDefault(),e.$refs.upload.active=!0}}},[t("i",{staticClass:"fa fa-arrow-up",attrs:{"aria-hidden":"true"}}),e._v("\n        Start Upload\n      ")])],1)]),e._v(" "),e._m(1)])}),[function(){var e=this.$createElement,n=this._self._c||e;return n("td",{attrs:{colspan:"7"}},[n("div",{staticClass:"text-center p-5"},[n("h4",[this._v("Drop files anywhere to upload"),n("br"),this._v("or")]),this._v(" "),n("label",{staticClass:"btn btn-lg btn-primary",attrs:{for:"file"}},[this._v("Select Files")])])])},function(){var e=this.$createElement,n=this._self._c||e;return n("div",{staticClass:"pt-5"},[this._v("\n    Source code: "),n("a",{attrs:{href:"https://github.com/lian-yue/vue-upload-component/blob/master/docs/views/examples/Drag.vue"}},[this._v("/docs/views/examples/Drag.vue")])])}],!1,null,null,null).exports),E={components:{FileUpload:F.a},data:function(){return{files1:[],files2:[]}}},z=(t(40),Object(h.a)(E,(function(){var e=this,n=e.$createElement,t=e._self._c||n;return t("div",{staticClass:"example-multiple"},[t("h1",{staticClass:"example-title",attrs:{id:"example-title"}},[e._v("Multiple instances")]),e._v(" "),t("div",{staticClass:"upload"},[t("ul",e._l(e.files1,(function(n,i){return t("li",{key:n.id},[t("span",[e._v(e._s(n.name))]),e._v(" -\n        "),t("span",[e._v(e._s(e._f("formatSize")(n.size)))]),e._v(" -\n        "),n.error?t("span",[e._v(e._s(n.error))]):n.success?t("span",[e._v("success")]):n.active||n.active?t("span",[e._v("active")]):t("span")])})),0),e._v(" "),t("div",{staticClass:"example-btn"},[t("file-upload",{ref:"upload1",staticClass:"btn btn-primary",attrs:{"input-id":"file1","post-action":"/upload/post"},model:{value:e.files1,callback:function(n){e.files1=n},expression:"files1"}},[t("i",{staticClass:"fa fa-plus"}),e._v("\n        Select files\n      ")]),e._v(" "),t("label",{staticClass:"btn btn-primary",attrs:{for:"file1"}},[e._v("Label Select files")]),e._v(" "),e.$refs.upload1&&e.$refs.upload1.active?t("button",{staticClass:"btn btn-danger",attrs:{type:"button"},on:{click:function(n){n.preventDefault(),e.$refs.upload1.active=!1}}},[t("i",{staticClass:"fa fa-stop",attrs:{"aria-hidden":"true"}}),e._v("\n        Stop Upload\n      ")]):t("button",{staticClass:"btn btn-success",attrs:{type:"button"},on:{click:function(n){n.preventDefault(),e.$refs.upload1.active=!0}}},[t("i",{staticClass:"fa fa-arrow-up",attrs:{"aria-hidden":"true"}}),e._v("\n        Start Upload\n      ")])],1)]),e._v(" "),t("div",{staticClass:"upload"},[t("ul",e._l(e.files2,(function(n,i){return t("li",{key:n.id},[t("span",[e._v(e._s(n.name))]),e._v(" -\n        "),t("span",[e._v(e._s(e._f("formatSize")(n.size)))]),e._v(" -\n        "),n.error?t("span",[e._v(e._s(n.error))]):n.success?t("span",[e._v("success")]):n.active||n.active?t("span",[e._v("active")]):t("span")])})),0),e._v(" "),t("div",{staticClass:"example-btn"},[t("file-upload",{ref:"upload2",staticClass:"btn btn-primary",attrs:{"input-id":"file2","post-action":"/upload/post"},model:{value:e.files2,callback:function(n){e.files2=n},expression:"files2"}},[t("i",{staticClass:"fa fa-plus"}),e._v("\n        Select files\n      ")]),e._v(" "),t("label",{staticClass:"btn btn-primary",attrs:{for:"file2"}},[e._v("Label Select files")]),e._v(" "),e.$refs.upload2&&e.$refs.upload2.active?t("button",{staticClass:"btn btn-danger",attrs:{type:"button"},on:{click:function(n){n.preventDefault(),e.$refs.upload2.active=!1}}},[t("i",{staticClass:"fa fa-stop",attrs:{"aria-hidden":"true"}}),e._v("\n        Stop Upload\n      ")]):t("button",{staticClass:"btn btn-success",attrs:{type:"button"},on:{click:function(n){n.preventDefault(),e.$refs.upload2.active=!0}}},[t("i",{staticClass:"fa fa-arrow-up",attrs:{"aria-hidden":"true"}}),e._v("\n        Start Upload\n      ")])],1)]),e._v(" "),e._m(0)])}),[function(){var e=this.$createElement,n=this._self._c||e;return n("div",{staticClass:"pt-5"},[this._v("\n    Source code: "),n("a",{attrs:{href:"https://github.com/lian-yue/vue-upload-component/blob/master/docs/views/examples/Multiple.vue"}},[this._v("/docs/views/examples/Multiple.vue")])])}],!1,null,null,null).exports),B={components:{FileUpload:F.a},data:function(){return{files:[],chunkEnabled:!0,chunkMinSize:1,chunkMaxActive:3,chunkMaxRetries:5}},methods:{inputFilter:function(e,n,t){if(e&&!n){if(/(\/|^)(Thumbs\.db|desktop\.ini|\..+)$/.test(e.name))return t();if(/\.(php5?|html?|jsx?)$/i.test(e.name))return t()}},inputFile:function(e,n){e&&!n&&(console.log("add",e),this.$refs.upload.active=!0),e&&n&&console.log("update",e),!e&&n&&console.log("remove",n)}}},I=(t(42),t(44),Object(h.a)(B,(function(){var e=this,n=e.$createElement,t=e._self._c||n;return t("div",{staticClass:"example-simple"},[t("h1",{staticClass:"example-title",attrs:{id:"example-title"}},[e._v("Chunk Upload Example")]),e._v(" "),t("p",[e._v("When using chunk uploads, the file will be uploaded in different parts (or chunks). All the files with a size higher than the set in the input will be uploaded using this method.")]),e._v(" "),e._m(0),e._v(" "),t("p",[e._v("You can also pause / resume the upload process.")]),e._v(" "),t("div",{staticClass:"upload"},[t("div",{staticClass:"form-horizontal"},[t("div",{staticClass:"form-group"},[t("div",{staticClass:"col-sm-offset-2 col-sm-10"},[t("div",{staticClass:"checkbox"},[t("label",[t("input",{directives:[{name:"model",rawName:"v-model",value:e.chunkEnabled,expression:"chunkEnabled"}],attrs:{type:"checkbox"},domProps:{checked:Array.isArray(e.chunkEnabled)?e._i(e.chunkEnabled,null)>-1:e.chunkEnabled},on:{change:function(n){var t=e.chunkEnabled,i=n.target,a=!!i.checked;if(Array.isArray(t)){var o=e._i(t,null);i.checked?o<0&&(e.chunkEnabled=t.concat([null])):o>-1&&(e.chunkEnabled=t.slice(0,o).concat(t.slice(o+1)))}else e.chunkEnabled=a}}}),e._v(" Use chunk upload\n            ")])])])]),e._v(" "),t("div",{staticClass:"form-group"},[t("label",{staticClass:"col-sm-2 control-label",attrs:{for:"inputMinSize"}},[e._v("Min Size")]),e._v(" "),t("div",{staticClass:"col-sm-10"},[t("div",{staticClass:"input-group"},[t("input",{directives:[{name:"model",rawName:"v-model",value:e.chunkMinSize,expression:"chunkMinSize"}],staticClass:"form-control",attrs:{id:"inputMinSize",type:"number"},domProps:{value:e.chunkMinSize},on:{input:function(n){n.target.composing||(e.chunkMinSize=n.target.value)}}}),e._v(" "),t("span",{staticClass:"input-group-addon"},[e._v("MB")])])])]),e._v(" "),t("div",{staticClass:"form-group"},[t("label",{staticClass:"col-sm-2 control-label",attrs:{for:"inputMaxActive"}},[e._v("Max Active Chunks")]),e._v(" "),t("div",{staticClass:"col-sm-10"},[t("input",{directives:[{name:"model",rawName:"v-model",value:e.chunkMaxActive,expression:"chunkMaxActive"}],staticClass:"form-control",attrs:{id:"inputMaxActive",type:"number"},domProps:{value:e.chunkMaxActive},on:{input:function(n){n.target.composing||(e.chunkMaxActive=n.target.value)}}})])]),e._v(" "),t("div",{staticClass:"form-group"},[t("label",{staticClass:"col-sm-2 control-label",attrs:{for:"inputMaxRetries"}},[e._v("Max Chunk Retries")]),e._v(" "),t("div",{staticClass:"col-sm-10"},[t("input",{directives:[{name:"model",rawName:"v-model",value:e.chunkMaxRetries,expression:"chunkMaxRetries"}],staticClass:"form-control",attrs:{id:"inputMaxRetries",type:"number"},domProps:{value:e.chunkMaxRetries},on:{input:function(n){n.target.composing||(e.chunkMaxRetries=n.target.value)}}})])])]),e._v(" "),t("table",{staticClass:"table table-striped table-condensed"},[e._m(1),e._v(" "),t("tbody",[e._l(e.files,(function(n){return[t("tr",{key:n.id+"-info"},[t("td",[e._v(e._s(n.name))]),e._v(" "),t("td",{staticClass:"text-right"},[e._v(e._s(e._f("formatSize")(n.size)))]),e._v(" "),t("td",{staticClass:"text-right"},[e._v(e._s(n.progress)+"%")]),e._v(" "),n.error?t("td",[e._v(e._s(n.error))]):n.success?t("td",[e._v("Success")]):n.active?t("td",[e._v("Active")]):t("td",[e._v(" - ")]),e._v(" "),t("td",[n.chunk?[n.active?t("button",{staticClass:"btn btn-sm btn-danger",on:{click:function(e){return n.chunk.pause()}}},[t("i",{staticClass:"fa fa-pause"})]):e._e(),e._v(" "),!n.active&&n.chunk.hasChunksToUpload?t("button",{staticClass:"btn btn-sm btn-primary",on:{click:function(e){return n.chunk.resume()}}},[t("i",{staticClass:"fa fa-play"})]):e._e()]:e._e()],2),e._v(" "),n.chunk?[t("td",{staticClass:"text-right"},[e._v(e._s(n.chunk.chunks.length))]),e._v(" "),t("td",{staticClass:"text-right"},[e._v(e._s(n.chunk.chunksUploading.length))]),e._v(" "),t("td",{staticClass:"text-right"},[e._v(e._s(n.chunk.chunksUploaded.length))])]:[t("td",{staticClass:"text-right"},[e._v(" - ")]),e._v(" "),t("td",{staticClass:"text-right"},[e._v(" - ")]),e._v(" "),t("td",{staticClass:"text-right"},[e._v(" - ")])]],2),e._v(" "),t("tr",{key:n.id+"-loading"},[t("td",{attrs:{colspan:"8"}},[n.chunk?t("div",{staticClass:"chunk-loading"},e._l(n.chunk.chunks,(function(i,a){return t("span",{key:a,staticClass:"chunk-loading-part",class:{"chunk-loading-part__uploaded":i.uploaded}},[i.retries!=n.chunk.maxRetries?[e._v("\n                    "+e._s(n.chunk.maxRetries-i.retries)+" error(s)\n                  ")]:e._e()],2)})),0):e._e()])])]}))],2)]),e._v(" "),t("div",{staticClass:"example-btn"},[t("file-upload",{ref:"upload",staticClass:"btn btn-primary",attrs:{"post-action":"/upload/post","chunk-enabled":e.chunkEnabled,chunk:{action:"/upload/chunk",minSize:1048576*e.chunkMinSize,maxActive:e.chunkMaxActive,maxRetries:e.chunkMaxRetries},extensions:"gif,jpg,jpeg,png,webp",accept:"image/png,image/gif,image/jpeg,image/webp",multiple:!0,size:10485760},on:{"input-filter":e.inputFilter,"input-file":e.inputFile},model:{value:e.files,callback:function(n){e.files=n},expression:"files"}},[t("i",{staticClass:"fa fa-plus"}),e._v("\n        Select files\n      ")])],1)]),e._v(" "),e._m(2)])}),[function(){var e=this.$createElement,n=this._self._c||e;return n("p",[this._v("You will be able to see the different parts being uploaded individually. Some parts might fail, and the package is prepared to "),n("em",[this._v("retry")]),this._v(" up to a certain amount of times.")])},function(){var e=this,n=e.$createElement,t=e._self._c||n;return t("thead",{staticClass:"thead-dark"},[t("tr",[t("th",[e._v("Name")]),e._v(" "),t("th",{staticClass:"text-right"},[e._v("Size")]),e._v(" "),t("th",{staticClass:"text-right"},[e._v("Progress")]),e._v(" "),t("th",[e._v("Status")]),e._v(" "),t("th",[e._v("Pause")]),e._v(" "),t("th",{staticClass:"text-center",attrs:{colspan:"3"}},[e._v("Chunks")])]),e._v(" "),t("tr",[t("th",{attrs:{colspan:"5"}}),e._v(" "),t("th",{staticClass:"text-right"},[e._v("Total")]),e._v(" "),t("th",{staticClass:"text-right"},[e._v("Active")]),e._v(" "),t("th",{staticClass:"text-right"},[e._v("Completed")])])])},function(){var e=this.$createElement,n=this._self._c||e;return n("div",{staticClass:"pt-5"},[this._v("\n    Source code: "),n("a",{attrs:{href:"https://github.com/lian-yue/vue-upload-component/blob/master/docs/views/examples/Chunk.vue"}},[this._v("/docs/views/examples/Chunk.vue")])])}],!1,null,"c205936e",null).exports),L=Object.assign||function(e){for(var n=1;n<arguments.length;n++){var t=arguments[n];for(var i in t)Object.prototype.hasOwnProperty.call(t,i)&&(e[i]=t[i])}return e},P={components:{FileUpload:F.a},computed:L({},Object(u.mapState)(["files"])),methods:{inputUpdate:function(e){this.$store.commit("updateFiles",e)}}},N=(t(46),[{path:"",component:S},{path:"full",component:S},{path:"simple",component:A},{path:"avatar",component:U},{path:"drag",component:R},{path:"multiple",component:z},{path:"chunk",component:I},{path:"vuex",component:Object(h.a)(P,(function(){var e=this,n=e.$createElement,t=e._self._c||n;return t("div",{staticClass:"example-vuex"},[t("h1",{staticClass:"example-title",attrs:{id:"example-title"}},[e._v("Vuex Example")]),e._v(" "),t("div",{staticClass:"upload"},[t("ul",e._l(e.files,(function(n,i){return t("li",{key:n.id},[t("span",[e._v(e._s(n.name))]),e._v(" -\n        "),t("span",[e._v(e._s(e._f("formatSize")(n.size)))]),e._v(" -\n        "),n.error?t("span",[e._v(e._s(n.error))]):n.success?t("span",[e._v("success")]):n.active||n.active?t("span",[e._v("active")]):t("span")])})),0),e._v(" "),t("div",{staticClass:"example-btn"},[t("file-upload",{ref:"upload",staticClass:"btn btn-primary",attrs:{"post-action":"/upload/post",extensions:"gif,jpg,jpeg,png,webp",accept:"image/png,image/gif,image/jpeg,image/webp",multiple:!0,size:10485760,value:e.files},on:{input:e.inputUpdate}},[t("i",{staticClass:"fa fa-plus"}),e._v("\n        Select files\n      ")]),e._v(" "),e.$refs.upload&&e.$refs.upload.active?t("button",{staticClass:"btn btn-danger",attrs:{type:"button"},on:{click:function(n){n.preventDefault(),e.$refs.upload.active=!1}}},[t("i",{staticClass:"fa fa-stop",attrs:{"aria-hidden":"true"}}),e._v("\n        Stop Upload\n      ")]):t("button",{staticClass:"btn btn-success",attrs:{type:"button"},on:{click:function(n){n.preventDefault(),e.$refs.upload.active=!0}}},[t("i",{staticClass:"fa fa-arrow-up",attrs:{"aria-hidden":"true"}}),e._v("\n        Start Upload\n      ")])],1)]),e._v(" "),e._m(0)])}),[function(){var e=this.$createElement,n=this._self._c||e;return n("div",{staticClass:"pt-5"},[this._v("\n    Source code: "),n("a",{attrs:{href:"https://github.com/lian-yue/vue-upload-component/blob/master/docs/views/examples/Vuex.vue"}},[this._v("/docs/views/examples/Vuex.vue")]),this._v(", "),n("a",{attrs:{href:"https://github.com/lian-yue/vue-upload-component/blob/master/docs/store.js"}},[this._v("/docs/store.js")])])}],!1,null,null,null).exports}]),M=new c.a({mode:"hash",fallback:!1,scrollBehavior:function(e,n,t){if(t)return t;if(e.hash){var i=document.querySelector(e.hash);return{x:0,y:i?i.offsetTop:0}}return{x:0,y:0}},routes:[{path:"/:locale("+Object.keys(m.messages).join("|")+")?",component:v,children:[{path:"documents",component:g},{path:"examples",component:y,children:N},{path:"",component:y,children:N}]}]}),q={data:function(){return{showLocale:!1,showNav:!1}},beforeCreate:function(){this.$route.params.locale&&this.$route.params.locale!==this.$i18n.locale&&(this.$i18n.locale=this.$route.params.locale)},beforeUpdate:function(){this.$route.params.locale&&this.$route.params.locale!==this.$i18n.locale&&(this.$i18n.locale=this.$route.params.locale)},computed:{locale:function(){var e=this.$i18n;return e.messages[e.locale].locale}},methods:{onLocale:function(e){var n=this;e?this.showLocale=e:setTimeout((function(){n.showLocale=e}),128)}}},H=(t(48),Object(h.a)(q,(function(){var e=this,n=e.$createElement,t=e._self._c||n;return t("div",[t("header",{staticClass:"navbar navbar-expand-lg navbar-dark bg-dark",attrs:{id:"header"}},[t("router-link",{staticClass:"navbar-brand",attrs:{exact:!0,to:e._f("toLocale")("/")}},[e._v(e._s(e.$t("header.logo")))]),e._v(" "),t("button",{staticClass:"navbar-toggler",attrs:{type:"button"},on:{click:function(n){n.preventDefault(),e.showNav=!e.showNav}}},[t("span",{staticClass:"navbar-toggler-icon"})]),e._v(" "),t("nav",{class:{collapse:!0,"navbar-collapse":!0,show:e.showNav},attrs:{id:"navbar"}},[t("ul",{staticClass:"navbar-nav"},[t("li",{staticClass:"nav-item"},[t("router-link",{class:"nav-link"+("/"===e.$route.path?" active":""),attrs:{"active-class":"active",exact:!0,to:e._f("toLocale")("/")}},[e._v(e._s(e.$t("header.home")))])],1),e._v(" "),t("li",{staticClass:"nav-item"},[t("router-link",{staticClass:"nav-link",attrs:{"active-class":"active",to:e._f("toLocale")("/documents")}},[e._v(e._s(e.$t("header.documents")))])],1),e._v(" "),t("li",{staticClass:"nav-item"},[t("router-link",{staticClass:"nav-link",attrs:{"active-class":"active",to:e._f("toLocale")("/examples")}},[e._v(e._s(e.$t("header.examples")))])],1),e._v(" "),t("li",{staticClass:"nav-item"},[t("a",{staticClass:"nav-link",attrs:{rel:"license noopener",href:"https://www.lianyue.org",target:"_blank"}},[e._v(e._s(e.$t("header.blog")))])])]),e._v(" "),t("ul",{staticClass:"navbar-nav ml-md-auto"},[t("li",{staticClass:"nav-item dropdown"},[t("a",{staticClass:"nav-link dropdown-toggle",attrs:{href:"#"},on:{click:function(n){return n.preventDefault(),e.onLocale(!0)},focus:function(n){return e.onLocale(!0)},blur:function(n){return e.onLocale(!1)}}},[e._v("\n            "+e._s(e.$t("header.locale"))+"\n          ")]),e._v(" "),t("div",{class:{"dropdown-menu":!0,show:e.showLocale},on:{blur:function(n){return e.onLocale(!1)}}},e._l(e.locale,(function(n,i){return t("router-link",{key:i,staticClass:"dropdown-item",attrs:{to:"/"+i+(e.$route.params.locale?e.$route.fullPath.substr(e.$route.params.locale.length+1):e.$route.fullPath)}},[e._v(e._s(n))])})),1)]),e._v(" "),t("li",{staticClass:"nav-item"},[t("a",{staticClass:"nav-link",attrs:{href:"https://github.com/lian-yue/vue-upload-component/issues"}},[e._v("\n            "+e._s(e.$t("header.issues"))+"\n          ")])]),e._v(" "),t("li",{staticClass:"nav-item"},[t("a",{staticClass:"nav-link",attrs:{href:"https://github.com/lian-yue/vue-upload-component"}},[e._v("\n            "+e._s(e.$t("header.github"))+"\n          ")])])])])],1),e._v(" "),t("router-view")],1)}),[],!1,null,null,null).exports),V=Object.assign||function(e){for(var n=1;n<arguments.length;n++){var t=arguments[n];for(var i in t)Object.prototype.hasOwnProperty.call(t,i)&&(e[i]=t[i])}return e},W=function(){function e(e,n){for(var t=0;t<n.length;t++){var i=n[t];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,i.key,i)}}return function(n,t,i){return t&&e(n.prototype,t),i&&e(n,i),n}}();function Y(e,n){if(!(e instanceof n))throw new TypeError("Cannot call a class as a function")}function K(e,n){if(!e)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return!n||"object"!=typeof n&&"function"!=typeof n?e:n}a.a.config.silent=!1,a.a.config.devtools=!0;var X=function(e){function n(){return Y(this,n),K(this,(n.__proto__||Object.getPrototypeOf(n)).apply(this,arguments))}return function(e,n){if("function"!=typeof n&&null!==n)throw new TypeError("Super expression must either be null or a function, not "+typeof n);e.prototype=Object.create(n&&n.prototype,{constructor:{value:e,enumerable:!1,writable:!0,configurable:!0}}),n&&(Object.setPrototypeOf?Object.setPrototypeOf(e,n):e.__proto__=n)}(n,e),W(n,[{key:"heading",value:function(e,n,t){var i=t.toLowerCase().replace(/([\u0000-\u002F\u003A-\u0060\u007B-\u007F]+)/g,"-").replace(/^\-+|\-+$/,"");for(this.options.headers||(this.options.headers=[]);this.options.headers.length>=n;)this.options.headers.pop();var a=this.options.headers.filter((function(e){return!!e})).join("-");for(a&&(a+="-");this.options.headers.length<n-1;)this.options.headers.push("");return this.options.headers.push(i),"<h"+n+' id="'+this.options.headerPrefix+a+i+'">'+e+"</h"+n+">\n"}}]),n}(s.a.Renderer);s.a.setOptions({renderer:new X,gfm:!0,tables:!0,breaks:!1,pedantic:!1,sanitize:!1,smartLists:!0,smartypants:!1,highlight:function(e,n){return n?l.a.highlight(n,e).value:l.a.highlightAuto(e).value}}),a.a.directive("markdown",(function(e,n,t){e.className&&/vue-markdown/.test(e.className)||(e.className+=" vue-markdown");for(var i="",a=0;a<t.children.length;a++)i+=t.children[a].text||"";if(e.markdown!==i){e.markdown=i,e.innerHTML=s()(i);for(var o=e.querySelectorAll("a"),r=0;r<o.length;r++)o[r].onclick=function(e){if(!(e.metaKey||e.ctrlKey||e.shiftKey||e.defaultPrevented||void 0!==e.button&&0!==e.button||this.host!==window.location.host)){var n=this.getAttribute("href");n&&"#"===n.charAt(0)&&(e.preventDefault(),M.push(n))}}}})),a.a.filter("formatSize",(function(e){return e>1099511627776?(e/1024/1024/1024/1024).toFixed(2)+" TB":e>1073741824?(e/1024/1024/1024).toFixed(2)+" GB":e>1048576?(e/1024/1024).toFixed(2)+" MB":e>1024?(e/1024).toFixed(2)+" KB":e.toString()+" B"})),a.a.filter("toLocale",(function(e){return"/"+m.locale+e})),new a.a(V({store:d,router:M,i18n:m},H)).$mount("#app")},function(e,n,t){"use strict";t.r(n);var i=function(e){var n=new XMLHttpRequest;return n.open(e.method||"GET",e.url),n.responseType="json",e.headers&&Object.keys(e.headers).forEach((function(t){n.setRequestHeader(t,e.headers[t])})),n},a=function(e){return function(e,n){return new Promise((function(t,i){e.onload=function(){if(e.status>=200&&e.status<300){var n;try{n=JSON.parse(e.response)}catch(t){n=e.response}t(n)}else i(e.response)},e.onerror=function(){return i(e.response)},e.send(JSON.stringify(n))}))}(i(e),e.body)},o=function(){function e(e,n){for(var t=0;t<n.length;t++){var i=n[t];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,i.key,i)}}return function(n,t,i){return t&&e(n.prototype,t),i&&e(n,i),n}}();var s=function(){function e(n,t){!function(e,n){if(!(e instanceof n))throw new TypeError("Cannot call a class as a function")}(this,e),this.file=n,this.options=t,this.chunks=[],this.sessionId=null,this.chunkSize=null,this.speedInterval=null}return o(e,[{key:"createChunks",value:function(){this.chunks=[];for(var e=0,n=this.chunkSize;e<this.fileSize;)this.chunks.push({blob:this.file.file.slice(e,n),startOffset:e,active:!1,retries:this.maxRetries}),n=(e=n)+this.chunkSize}},{key:"updateFileProgress",value:function(){this.file.progress=this.progress}},{key:"pause",value:function(){this.file.active=!1,this.stopChunks()}},{key:"stopChunks",value:function(){this.chunksUploading.forEach((function(e){e.xhr.abort(),e.active=!1})),this.stopSpeedCalc()}},{key:"resume",value:function(){this.file.active=!0,this.startChunking()}},{key:"upload",value:function(){var e=this;return this.promise=new Promise((function(n,t){e.resolve=n,e.reject=t})),this.start(),this.promise}},{key:"start",value:function(){var e=this;a({method:"POST",headers:Object.assign({},this.headers,{"Content-Type":"application/json"}),url:this.action,body:Object.assign(this.startBody,{phase:"start",mime_type:this.fileType,size:this.fileSize,name:this.fileName})}).then((function(n){if("success"!==n.status)return e.file.response=n,e.reject("server");e.sessionId=n.data.session_id,e.chunkSize=n.data.end_offset,e.createChunks(),e.startChunking()})).catch((function(n){e.file.response=n,e.reject("server")}))}},{key:"startChunking",value:function(){for(var e=0;e<this.maxActiveChunks;e++)this.uploadNextChunk();this.startSpeedCalc()}},{key:"uploadNextChunk",value:function(){if(this.file.active){if(this.hasChunksToUpload)return this.uploadChunk(this.chunksToUpload[0]);if(0===this.chunksUploading.length)return this.finish()}}},{key:"uploadChunk",value:function(e){var n=this;e.progress=0,e.active=!0,this.updateFileProgress(),e.xhr=i({method:"POST",headers:this.headers,url:this.action}),e.xhr.upload.addEventListener("progress",(function(n){n.lengthComputable&&(e.progress=Math.round(n.loaded/n.total*100))}),!1),function(e,n){var t=new FormData;for(var i in n)t.append(i,n[i]);return new Promise((function(n,i){e.onload=function(){if(e.status>=200&&e.status<300){var t;try{t=JSON.parse(e.response)}catch(n){t=e.response}n(t)}else i(e.response)},e.onerror=function(){return i(e.response)},e.send(t)}))}(e.xhr,Object.assign(this.uploadBody,{phase:"upload",session_id:this.sessionId,start_offset:e.startOffset,chunk:e.blob})).then((function(t){if(e.active=!1,"success"===t.status)e.uploaded=!0;else if(e.retries--<=0)return n.stopChunks(),n.reject("upload");n.uploadNextChunk()})).catch((function(){if(e.active=!1,e.retries--<=0)return n.stopChunks(),n.reject("upload");n.uploadNextChunk()}))}},{key:"finish",value:function(){var e=this;this.updateFileProgress(),this.stopSpeedCalc(),a({method:"POST",headers:Object.assign({},this.headers,{"Content-Type":"application/json"}),url:this.action,body:Object.assign(this.finishBody,{phase:"finish",session_id:this.sessionId})}).then((function(n){if(e.file.response=n,"success"!==n.status)return e.reject("server");e.resolve(n)})).catch((function(n){e.file.response=n,e.reject("server")}))}},{key:"startSpeedCalc",value:function(){var e=this;this.file.speed=0;var n=0;this.speedInterval||(this.speedInterval=window.setInterval((function(){var t=e.progress/100*e.fileSize;e.file.speed=t-n,n=t}),1e3))}},{key:"stopSpeedCalc",value:function(){this.speedInterval&&window.clearInterval(this.speedInterval),this.speedInterval=null,this.file.speed=0}},{key:"maxRetries",get:function(){return parseInt(this.options.maxRetries,10)}},{key:"maxActiveChunks",get:function(){return parseInt(this.options.maxActive,10)}},{key:"fileType",get:function(){return this.file.type}},{key:"fileSize",get:function(){return this.file.size}},{key:"fileName",get:function(){return this.file.name}},{key:"action",get:function(){return this.options.action||null}},{key:"startBody",get:function(){return this.options.startBody||{}}},{key:"uploadBody",get:function(){return this.options.uploadBody||{}}},{key:"finishBody",get:function(){return this.options.finishBody||{}}},{key:"headers",get:function(){return this.options.headers||{}}},{key:"readyToUpload",get:function(){return!!this.chunks}},{key:"progress",get:function(){var e=this,n=this.chunksUploaded.length/this.chunks.length*100,t=this.chunksUploading.reduce((function(n,t){return n+(0|t.progress)/e.chunks.length}),0);return Math.min(n+t,100)}},{key:"chunksToUpload",get:function(){return this.chunks.filter((function(e){return!e.active&&!e.uploaded}))}},{key:"hasChunksToUpload",get:function(){return this.chunksToUpload.length>0}},{key:"chunksUploading",get:function(){return this.chunks.filter((function(e){return!!e.xhr&&!!e.active}))}},{key:"chunksUploaded",get:function(){return this.chunks.filter((function(e){return!!e.uploaded}))}}]),e}(),r={methods:{change:function(e){this.$parent.addInputFile(e.target),e.target.files?(e.target.value="",e.target.files.length&&!/safari/i.test(navigator.userAgent)&&(e.target.type="",e.target.type="file")):(this.$destroy(),new this.constructor({parent:this.$parent,el:this.$el}))}}},l=t(0),u=Object(l.a)(r,(function(){var e=this,n=e.$createElement;return(e._self._c||n)("input",{attrs:{type:"file",name:e.$parent.name,id:e.$parent.inputId||e.$parent.name,accept:e.$parent.accept,capture:e.$parent.capture,disabled:e.$parent.disabled,webkitdirectory:e.$parent.directory&&e.$parent.features.directory,directory:e.$parent.directory&&e.$parent.features.directory,multiple:e.$parent.multiple&&e.$parent.features.html5},on:{change:e.change}})}),[],!1,null,null,null).exports,d=Object.assign||function(e){for(var n=1;n<arguments.length;n++){var t=arguments[n];for(var i in t)Object.prototype.hasOwnProperty.call(t,i)&&(e[i]=t[i])}return e},p="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e};function c(e){if(Array.isArray(e)){for(var n=0,t=Array(e.length);n<e.length;n++)t[n]=e[n];return t}return Array.from(e)}var f={headers:{},action:"",minSize:1048576,maxActive:3,maxRetries:5,handler:s},m={components:{InputFile:u},props:{inputId:{type:String},name:{type:String,default:"file"},accept:{type:String},capture:{},disabled:{},multiple:{type:Boolean},maximum:{type:Number,default:function(){return this.multiple?0:1}},addIndex:{type:[Boolean,Number]},directory:{type:Boolean},postAction:{type:String},putAction:{type:String},customAction:{type:Function},headers:{type:Object,default:Object},data:{type:Object,default:Object},timeout:{type:Number,default:0},drop:{default:!1},dropDirectory:{type:Boolean,default:!0},size:{type:Number,default:0},extensions:{default:Array},value:{type:Array,default:Array},thread:{type:Number,default:1},chunkEnabled:{type:Boolean,default:!1},chunk:{type:Object,default:function(){return f}}},data:function(){return{files:this.value,features:{html5:!0,directory:!1,drop:!1},active:!1,dropActive:!1,uploading:0,destroy:!1}},mounted:function(){var e=document.createElement("input");if(e.type="file",e.multiple=!0,window.FormData&&e.files?("boolean"!=typeof e.webkitdirectory&&"boolean"!=typeof e.directory||(this.features.directory=!0),this.features.html5&&void 0!==e.ondrop&&(this.features.drop=!0)):this.features.html5=!1,this.maps={},this.files)for(var n=0;n<this.files.length;n++){var t=this.files[n];this.maps[t.id]=t}this.$nextTick((function(){var e=this;this.$parent?(this.$parent.$forceUpdate(),this.$parent.$nextTick((function(){e.watchDrop(e.drop)}))):this.watchDrop(this.drop)}))},beforeDestroy:function(){this.destroy=!0,this.active=!1,this.watchDrop(!1)},computed:{uploaded:function(){for(var e=void 0,n=0;n<this.files.length;n++)if((e=this.files[n]).fileObject&&!e.error&&!e.success)return!1;return!0},chunkOptions:function(){return Object.assign(f,this.chunk)},className:function(){return["file-uploads",this.features.html5?"file-uploads-html5":"file-uploads-html4",this.features.directory&&this.directory?"file-uploads-directory":void 0,this.features.drop&&this.drop?"file-uploads-drop":void 0,this.disabled?"file-uploads-disabled":void 0]}},watch:{active:function(e){this.watchActive(e)},dropActive:function(){this.$parent&&this.$parent.$forceUpdate()},drop:function(e){this.watchDrop(e)},value:function(e){if(this.files!==e){this.files=e;var n=this.maps;this.maps={};for(var t=0;t<this.files.length;t++){var i=this.files[t];this.maps[i.id]=i}for(var a in this.maps){var o=this.maps[a],s=n[a];o!==s&&this.emitFile(o,s)}for(var r in n)this.maps[r]||this.emitFile(void 0,n[r])}}},methods:{clear:function(){if(this.files.length){var e=this.files;this.files=[],this.maps={},this.emitInput();for(var n=0;n<e.length;n++)this.emitFile(void 0,e[n])}return!0},get:function(e){return!!e&&("object"===(void 0===e?"undefined":p(e))?this.maps[e.id]||!1:this.maps[e]||!1)},add:function(e){var n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:this.addIndex,t=e,i=t instanceof Array;i||(t=[t]);for(var a=[],o=0;o<t.length;o++){var s=t[o];this.features.html5&&s instanceof Blob&&(s={file:s,size:s.size,name:s.webkitRelativePath||s.relativePath||s.name||"unknown",type:s.type});var r=!1;if(!1===s.fileObject||(s.fileObject||"undefined"!=typeof Element&&s.el instanceof Element||"undefined"!=typeof Blob&&s.file instanceof Blob)&&(r=!0),r&&((s=d({fileObject:!0,size:-1,name:"Filename",type:"",active:!1,error:"",success:!1,putAction:this.putAction,postAction:this.postAction,timeout:this.timeout},s,{response:{},progress:"0.00",speed:0})).data=d({},this.data,s.data?s.data:{}),s.headers=d({},this.headers,s.headers?s.headers:{})),s.id||(s.id=Math.random().toString(36).substr(2)),!this.emitFilter(s,void 0)){if(this.maximum>1&&a.length+this.files.length>=this.maximum)break;if(a.push(s),1===this.maximum)break}}if(!a.length)return!1;1===this.maximum&&this.clear();var l=void 0;if(!0===n||0===n)l=a.concat(this.files);else if(n){var u;(u=l=this.files.concat([])).splice.apply(u,[n,0].concat(a))}else l=this.files.concat(a);this.files=l;for(var p=0;p<a.length;p++){var c=a[p];this.maps[c.id]=c}this.emitInput();for(var f=0;f<a.length;f++)this.emitFile(a[f],void 0);return i?a:a[0]},addInputFile:function(e){var n=[];if(e.files)for(var t=0;t<e.files.length;t++){var i=e.files[t];n.push({size:i.size,name:i.webkitRelativePath||i.relativePath||i.name,type:i.type,file:i})}else{var a=e.value.replace(/\\/g,"/").split("/");delete e.__vuex__,n.push({name:a[a.length-1],el:e})}return this.add(n)},addDataTransfer:function(e){var n=this,t=[];if(e.items&&e.items.length){for(var i=[],a=0;a<e.items.length;a++){var o=e.items[a];(o=o.getAsEntry?o.getAsEntry()||o.getAsFile():o.webkitGetAsEntry&&o.webkitGetAsEntry()||o.getAsFile())&&i.push(o)}return new Promise((function(e,a){!function a(o){var s=i[o];if(!s||n.maximum>0&&t.length>=n.maximum)return e(n.add(t));n.getEntry(s).then((function(e){t.push.apply(t,c(e)),a(o+1)}))}(0)}))}if(e.files.length){for(var s=0;s<e.files.length&&(t.push(e.files[s]),!(this.maximum>0&&t.length>=this.maximum));s++);return Promise.resolve(this.add(t))}return Promise.resolve([])},getEntry:function(e){var n=this,t=arguments.length>1&&void 0!==arguments[1]?arguments[1]:"";return new Promise((function(i,a){if(e.isFile)e.file((function(e){i([{size:e.size,name:t+e.name,type:e.type,file:e}])}));else if(e.isDirectory&&n.dropDirectory){var o=[],s=e.createReader();!function a(){s.readEntries((function(s){!function r(l){return!s[l]&&0===l||n.maximum>0&&o.length>=n.maximum?i(o):s[l]?void n.getEntry(s[l],t+e.name+"/").then((function(e){o.push.apply(o,c(e)),r(l+1)})):a()}(0)}))}()}else i([])}))},replace:function(e,n){var t=this.get(e),i=this.get(n);if(!t||!i||t===i)return!1;var a=this.files.concat([]),o=a.indexOf(t),s=a.indexOf(i);return-1!==o&&-1!==s&&(a[o]=i,a[s]=t,this.files=a,this.emitInput(),!0)},remove:function(e){var n=this.get(e);if(n){if(this.emitFilter(void 0,n))return!1;var t=this.files.concat([]),i=t.indexOf(n);if(-1===i)return console.error("remove",n),!1;t.splice(i,1),this.files=t,delete this.maps[n.id],this.emitInput(),this.emitFile(void 0,n)}return n},update:function(e,n){var t=this.get(e);if(t){var i=d({},t,n);if(!t.fileObject||!t.active||i.active||i.error||i.success||(i.error="abort"),this.emitFilter(i,t))return!1;var a=this.files.concat([]),o=a.indexOf(t);return-1===o?(console.error("update",t),!1):(a.splice(o,1,i),this.files=a,delete this.maps[t.id],this.maps[i.id]=i,this.emitInput(),this.emitFile(i,t),i)}return!1},emitFilter:function(e,n){var t=!1;return this.$emit("input-filter",e,n,(function(){return t=!0})),t},emitFile:function(e,n){this.$emit("input-file",e,n),!(e&&e.fileObject&&e.active)||n&&n.active?e&&e.fileObject&&e.active||!n||!n.fileObject||!n.active||this.uploading--:(this.uploading++,this.$nextTick((function(){var n=this;setTimeout((function(){n.upload(e).then((function(){(e=n.get(e))&&e.fileObject&&n.update(e,{active:!1,success:!e.error})})).catch((function(t){n.update(e,{active:!1,success:!1,error:t.code||t.error||t.message||t})}))}),parseInt(50*Math.random()+50,10))}))),!this.active||Boolean(e)===Boolean(n)&&e.active===n.active||this.watchActive(!0)},emitInput:function(){this.$emit("input",this.files)},upload:function(e){var n=this.get(e);if(!n)return Promise.reject("not_exists");if(!n.fileObject)return Promise.reject("file_object");if(n.error)return Promise.reject(n.error);if(n.success)return Promise.resolve(n);var t=this.extensions;if(t&&(t.length||void 0===t.length)&&("object"===(void 0===t?"undefined":p(t))&&t instanceof RegExp||("string"==typeof t&&(t=t.split(",").map((function(e){return e.trim()})).filter((function(e){return e}))),t=new RegExp("\\.("+t.join("|").replace(/\./g,"\\.")+")$","i")),-1===n.name.search(t)))return Promise.reject("extension");if(this.size>0&&n.size>=0&&n.size>this.size)return Promise.reject("size");if(this.customAction)return this.customAction(n,this);if(this.features.html5){if(this.shouldUseChunkUpload(n))return this.uploadChunk(n);if(n.putAction)return this.uploadPut(n);if(n.postAction)return this.uploadHtml5(n)}return n.postAction?this.uploadHtml4(n):Promise.reject("No action configured")},shouldUseChunkUpload:function(e){return this.chunkEnabled&&!!this.chunkOptions.handler&&e.size>this.chunkOptions.minSize},uploadChunk:function(e){var n=this.chunkOptions.handler;return e.chunk=new n(e,this.chunkOptions),e.chunk.upload()},uploadPut:function(e){var n=[],t=void 0;for(var i in e.data)null!=(t=e.data[i])&&n.push(encodeURIComponent(i)+"="+encodeURIComponent(t));var a=n.length?(-1===e.putAction.indexOf("?")?"?":"&")+n.join("&"):"",o=new XMLHttpRequest;return o.open("PUT",e.putAction+a),this.uploadXhr(o,e,e.file)},uploadHtml5:function(e){var n=new window.FormData,t=void 0;for(var i in e.data)(t=e.data[i])&&"object"===(void 0===t?"undefined":p(t))&&"function"!=typeof t.toString?t instanceof File?n.append(i,t,t.name):n.append(i,JSON.stringify(t)):null!=t&&n.append(i,t);n.append(this.name,e.file,e.file.filename||e.name);var a=new XMLHttpRequest;return a.open("POST",e.postAction),this.uploadXhr(a,e,n)},uploadXhr:function(e,n,t){var i=this,a=n,o=0,s=0;e.upload.onprogress=function(e){if(a=i.get(a),e.lengthComputable&&a&&a.fileObject&&a.active){var n=Math.round(Date.now()/1e3);n!==o&&(o=n,a=i.update(a,{progress:(e.loaded/e.total*100).toFixed(2),speed:e.loaded-s}),s=e.loaded)}};var r=setInterval((function(){if(!(a=i.get(a))||!a.fileObject||a.success||a.error||!a.active){r&&(clearInterval(r),r=!1);try{e.abort(),e.timeout=1}catch(e){}}}),100);return new Promise((function(n,o){var s=void 0,l=function(t){if(!s){if(s=!0,r&&(clearInterval(r),r=!1),!(a=i.get(a)))return o("not_exists");if(!a.fileObject)return o("file_object");if(a.error)return o(a.error);if(!a.active)return o("abort");if(a.success)return n(a);var l={};switch(t.type){case"timeout":case"abort":l.error=t.type;break;case"error":e.status?e.status>=500?l.error="server":e.status>=400&&(l.error="denied"):l.error="network";break;default:e.status>=500?l.error="server":e.status>=400?l.error="denied":l.progress="100.00"}if(e.responseText){var u=e.getResponseHeader("Content-Type");u&&-1!==u.indexOf("/json")?l.response=JSON.parse(e.responseText):l.response=e.responseText}return(a=i.update(a,l)).error?o(a.error):n(a)}};for(var u in e.onload=l,e.onerror=l,e.onabort=l,e.ontimeout=l,a.timeout&&(e.timeout=a.timeout),a.headers)e.setRequestHeader(u,a.headers[u]);a=i.update(a,{xhr:e}),e.send(t)}))},uploadHtml4:function(e){var n=this,t=e,i=function(e){27===e.keyCode&&e.preventDefault()},a=document.createElement("iframe");a.id="upload-iframe-"+t.id,a.name="upload-iframe-"+t.id,a.src="about:blank",a.setAttribute("style","width:1px;height:1px;top:-999em;position:absolute; margin-top:-999em;");var o=document.createElement("form");o.action=t.postAction,o.name="upload-form-"+t.id,o.setAttribute("method","POST"),o.setAttribute("target","upload-iframe-"+t.id),o.setAttribute("enctype","multipart/form-data");var s=void 0,r=void 0;for(var l in t.data)(s=t.data[l])&&"object"===(void 0===s?"undefined":p(s))&&"function"!=typeof s.toString&&(s=JSON.stringify(s)),null!=s&&((r=document.createElement("input")).type="hidden",r.name=l,r.value=s,o.appendChild(r));o.appendChild(t.el),document.body.appendChild(a).appendChild(o);return new Promise((function(e,s){setTimeout((function(){if(!(t=n.update(t,{iframe:a})))return s("not_exists");var r=setInterval((function(){(t=n.get(t))&&t.fileObject&&!t.success&&!t.error&&t.active||(r&&(clearInterval(r),r=!1),a.onabort({type:t?"abort":"not_exists"}))}),100),l=void 0,u=function(o){if(!l){if(l=!0,r&&(clearInterval(r),r=!1),document.body.removeEventListener("keydown",i),!(t=n.get(t)))return s("not_exists");if(!t.fileObject)return s("file_object");if(t.error)return s(t.error);if(!t.active)return s("abort");if(t.success)return e(t);var u=function(){var e=void 0;try{a.contentWindow&&(e=a.contentWindow.document)}catch(e){}if(!e)try{e=a.contentDocument?a.contentDocument:a.document}catch(n){e=a.document}return e&&e.body?e.body.innerHTML:null}(),d={};switch(o.type){case"abort":d.error="abort";break;case"error":t.error?d.error=t.error:d.error=null===u?"network":"denied";break;default:t.error?d.error=t.error:null===d?d.error="network":d.progress="100.00"}if(null!==u){if(u&&"{"===u.substr(0,1)&&"}"===u.substr(u.length-1,1))try{u=JSON.parse(u)}catch(e){}d.response=u}return(t=n.update(t,d)).error?s(t.error):e(t)}};a.onload=u,a.onerror=u,a.onabort=u,document.body.addEventListener("keydown",i),o.submit()}),50)})).then((function(e){return a.parentNode&&a.parentNode.removeChild(a),e})).catch((function(e){return a.parentNode&&a.parentNode.removeChild(a),e}))},watchActive:function(e){for(var n=void 0,t=0;n=this.files[t];)if(t++,n.fileObject)if(e&&!this.destroy){if(this.uploading>=this.thread||this.uploading&&!this.features.html5)break;n.active||n.error||n.success||this.update(n,{active:!0})}else n.active&&this.update(n,{active:!1});else;0===this.uploading&&(this.active=!1)},watchDrop:function(e){var n=e;if(this.features.drop){if(this.dropElement)try{document.removeEventListener("dragenter",this.onDragenter,!1),document.removeEventListener("dragleave",this.onDragleave,!1),document.removeEventListener("drop",this.onDocumentDrop,!1),this.dropElement.removeEventListener("dragover",this.onDragover,!1),this.dropElement.removeEventListener("drop",this.onDrop,!1)}catch(e){}n?"string"==typeof n?n=document.querySelector(n)||this.$root.$el.querySelector(n):!0===n&&(n=this.$parent.$el):n=!1,this.dropElement=n,this.dropElement&&(document.addEventListener("dragenter",this.onDragenter,!1),document.addEventListener("dragleave",this.onDragleave,!1),document.addEventListener("drop",this.onDocumentDrop,!1),this.dropElement.addEventListener("dragover",this.onDragover,!1),this.dropElement.addEventListener("drop",this.onDrop,!1))}},onDragenter:function(e){if(e.preventDefault(),!this.dropActive&&e.dataTransfer){var n=e.dataTransfer;n.files&&n.files.length?this.dropActive=!0:n.types?(n.types.indexOf&&-1!==n.types.indexOf("Files")||n.types.contains&&n.types.contains("Files"))&&(this.dropActive=!0):this.dropActive=!0}},onDragleave:function(e){e.preventDefault(),this.dropActive&&("HTML"===e.target.nodeName||e.target===e.explicitOriginalTarget||!e.fromElement&&(e.clientX<=0||e.clientY<=0||e.clientX>=window.innerWidth||e.clientY>=window.innerHeight))&&(this.dropActive=!1)},onDragover:function(e){e.preventDefault()},onDocumentDrop:function(){this.dropActive=!1},onDrop:function(e){e.preventDefault(),this.addDataTransfer(e.dataTransfer)}}},h=(t(30),Object(l.a)(m,(function(){var e=this.$createElement,n=this._self._c||e;return n("span",{class:this.className},[this._t("default"),this._v(" "),n("label",{attrs:{for:this.inputId||this.name}}),this._v(" "),n("input-file")],2)}),[],!1,null,null,null));n.default=h.exports}]);
//# sourceMappingURL=index.js.map