/* @flow */

import ValidationClass from '../validation'

export default function (Vue: GlobalAPI): Object {
  const Validation = ValidationClass(Vue)

  return {
    functional: true,
    props: {
      name: {
        type: String,
        default: 'validation'
      }
    },
    render (
      h: Function,
      { props, data, parent, children, slots }
    ): Array<VNode> {
      if (!parent._validations) {
        parent._validations = {}
      }
      const validation = parent._validations[props.name] ||
        (parent._validations[props.name] = new Validation({ host: parent }))
      console.log('validation#render', parent, props, validation, children)
      walkChildren(validation, children)
      return children
    }
  }
}

function walkChildren (validation: Validation, children: Array<VNode>): void {
  children.forEach((child: VNode) => {
    /*
    console.log('walkChildren', child, child.componentOptions, child.componentOptions && child.componentOptions.tag, child.child, child.componentOptions && child.componentOptions.propsData)
    */
    if (child &&
        child.componentOptions &&
        child.componentOptions.propsData && child.componentOptions.tag === 'validity-control') {
      child.componentOptions.propsData.validation = validation
    }
    child.children && walkChildren(validation, child.children)
  })
}
