/* @flow */

export default function (Vue: any) {
  class Validation {
    _vm: any // TODO:
    _committing: boolean
    _validities: Object
    _watchers: Object
    _host: any

    constructor (options: Object = {}) {
      const result: Object = {}

      this._host = options.host
      this._committing = false
      this._validities = Object.create(null)
      this._watchers = Object.create(null)
      this._resetResultVM(result)
    }

    get result (): Object {
      return this._vm.result
    }

    registerField (field: string, validity: ?ValidityComponent): void {
      if (this._validities[field]) { return }

      this._validities[field] = validity
      Vue.set(this.result, field, {})
      this._watchValidity(field)

      this._resetResultVM(this.result)
    }

    unregisterField (field: string, validity: ?ValidityComponent): void {
      if (!this._validities[field]) { return }

      this._unwatchValidity(field)
      this._validities[field] = null
      delete this._validities[field]
      this._withCommit(() => {
        Vue.delete(this.result, field)
      })

      this._resetResultVM(this.result)
    }

    _watchValidity (field: string): void {
      const validity: ValidityComponent = this._validities[field]
      this._watchers[field] = validity.$watch('result', (val: Object) => {
        console.log(`${field}.$watch: ${JSON.stringify(val)}`, this.result)
        Vue.set(this.result, field, val)
        this._host.$forceUpdate()
      }, { deep: true, immediate: true })
    }

    _unwatchValidity (field: string): void {
      this._watchers[field]()
      this._watchers[field] = null
      delete this._watchers[field]
    }

    _resetResultVM (result: Object): void {
      const oldVm = this._vm

      const silent = Vue.config.silent
      Vue.config.silent = true
      this._vm = new Vue({
        data: { result }
      })
      Vue.config.silent = silent

      if (oldVm) {
        this._withCommit(() => {
          oldVm.result = null
        })
        Vue.nextTick(() => oldVm.$destroy())
      }
    }

    _withCommit (fn: Function): void {
      const committing = this._committing
      this._committing = true
      fn()
      this._committing = committing
    }
  }

  return Validation
}
