import { parseJSON } from './util';
var listeners = {};
var Events = /** @class */ (function () {
    function Events() {
        window.addEventListener('storage', this.onChange, false);
    }
    Events.prototype.onChange = function (event) {
        var _this = this;
        // According to specs the key can be `null`
        if (!event.key)
            return;
        // Notice: `this` refers to `window` inside this method
        var methods = listeners[event.key];
        /*istanbul ignore else*/
        if (methods) {
            var newValue_1 = parseJSON(event.newValue);
            var oldValue_1 = parseJSON(event.oldValue);
            methods.map(function (method) {
                method.call(_this, newValue_1, oldValue_1, event.url);
            });
        }
    };
    Events.prototype.on = function (key, fn) {
        if (listeners[key]) {
            listeners[key].push(fn);
        }
        else {
            listeners[key] = [fn];
        }
    };
    Events.prototype.off = function (key, fn) {
        var methods = listeners[key];
        if (methods && methods.length > 1) {
            methods.splice(methods.indexOf(fn), 1);
        }
        else {
            delete listeners[key];
        }
    };
    Events.prototype.clear = function (key) {
        if (key) {
            delete listeners[key];
        }
        else {
            listeners = {};
        }
    };
    Events.prototype.listeners = function () {
        return listeners;
    };
    return Events;
}());
export default Events;
