import WebStorage from './webStorage';
import StorageWithEvents from './storageWithEvents';
import { arrayify } from './util';
var registerInstance = function (Vue, driver, prefix) {
    var instance = new StorageWithEvents(prefix, driver);
    var apiName = '$' + String(driver) + 'Storage';
    Vue[apiName] = instance;
    Vue.prototype[apiName] = instance;
};
var Plugin = function (Vue, options) {
    if (options === void 0) { options = {}; }
    var safeOptions = Object.assign({}, {
        prefix: 'app_',
        drivers: 'local'
    }, options);
    arrayify(safeOptions.drivers).map(function (driver) {
        registerInstance(Vue, driver, safeOptions.prefix);
    });
};
export default Plugin;
export { WebStorage, StorageWithEvents, Plugin };
