var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import WebStorage from './webStorage';
import Events from './events';
var StorageWithEvents = /** @class */ (function (_super) {
    __extends(StorageWithEvents, _super);
    function StorageWithEvents(prefix, driver) {
        if (prefix === void 0) { prefix = 'app_'; }
        if (driver === void 0) { driver = 'local'; }
        var _this = _super.call(this, prefix, driver) || this;
        _this.events = new Events();
        return _this;
    }
    StorageWithEvents.prototype.on = function (key, fn) {
        this.events.on(this.prefixKey(key), fn);
        return this;
    };
    StorageWithEvents.prototype.off = function (key, fn) {
        this.events.off(this.prefixKey(key), fn);
        return this;
    };
    StorageWithEvents.prototype.clearEvents = function (key) {
        var mayBeKey = key ? this.prefixKey(key) : false;
        this.events.clear(mayBeKey);
        return this;
    };
    return StorageWithEvents;
}(WebStorage));
export default StorageWithEvents;
