import { parseJSON } from './util';
var WebStorage = /** @class */ (function () {
    function WebStorage(prefix, driver) {
        if (prefix === void 0) { prefix = 'app_'; }
        if (driver === void 0) { driver = 'local'; }
        this.prefix = prefix;
        this.storage = this.resolveDriver(driver);
    }
    WebStorage.prototype.prefixKey = function (key) {
        return this.prefix + String(key);
    };
    WebStorage.prototype.set = function (key, value) {
        return this.storage.setItem(this.prefixKey(key), JSON.stringify(value));
    };
    WebStorage.prototype.get = function (key, defaultValue) {
        if (defaultValue === void 0) { defaultValue = null; }
        var storedValue = null;
        var item = this.storage.getItem(this.prefixKey(key));
        if (!!item) {
            storedValue = parseJSON(item);
        }
        return storedValue === null ? defaultValue : storedValue;
    };
    WebStorage.prototype.remove = function (key) {
        return this.storage.removeItem(this.prefixKey(key));
    };
    WebStorage.prototype.clear = function (force) {
        var _this = this;
        if (force === void 0) { force = false; }
        if (force) {
            this.storage.clear();
        }
        else {
            this.keys(true).map(function (key) {
                _this.storage.removeItem(key);
            });
        }
    };
    WebStorage.prototype.keys = function (withPrefix) {
        var _this = this;
        if (withPrefix === void 0) { withPrefix = false; }
        var keys = [];
        // Loop through all storage keys
        Object.keys(this.storage).forEach(function (keyName) {
            /* istanbul ignore else */
            if (keyName.substr(0, _this.prefix.length) === _this.prefix) {
                keys.push(withPrefix ? keyName : keyName.substring(_this.prefix.length));
            }
        });
        return keys;
    };
    WebStorage.prototype.hasKey = function (key) {
        return this.keys().indexOf(key) !== -1;
    };
    WebStorage.prototype.length = function () {
        return this.keys().length;
    };
    WebStorage.prototype.resolveDriver = function (driver) {
        switch (driver) {
            case 'local':
                return window.localStorage;
            case 'session':
                return window.sessionStorage;
            default:
                throw new Error("Unknown driver supplied: " + driver);
        }
    };
    return WebStorage;
}());
export default WebStorage;
