(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define("VueWebStorage", [], factory);
	else if(typeof exports === 'object')
		exports["VueWebStorage"] = factory();
	else
		root["VueWebStorage"] = factory();
})(typeof self !== 'undefined' ? self : this, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 0);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, "WebStorage", function() { return /* reexport */ webStorage; });
__webpack_require__.d(__webpack_exports__, "StorageWithEvents", function() { return /* reexport */ storageWithEvents; });
__webpack_require__.d(__webpack_exports__, "Plugin", function() { return /* binding */ Plugin; });

// CONCATENATED MODULE: ./src/util.ts
var parseJSON = function (value) {
    if (value === null) {
        return value;
    }
    return JSON.parse(value);
};
var arrayify = function (item) {
    return item instanceof Array ? item : [item];
};


// CONCATENATED MODULE: ./src/webStorage.ts

var webStorage_WebStorage = /** @class */ (function () {
    function WebStorage(prefix, driver) {
        if (prefix === void 0) { prefix = 'app_'; }
        if (driver === void 0) { driver = 'local'; }
        this.prefix = prefix;
        this.storage = this.resolveDriver(driver);
    }
    WebStorage.prototype.prefixKey = function (key) {
        return this.prefix + String(key);
    };
    WebStorage.prototype.set = function (key, value) {
        return this.storage.setItem(this.prefixKey(key), JSON.stringify(value));
    };
    WebStorage.prototype.get = function (key, defaultValue) {
        if (defaultValue === void 0) { defaultValue = null; }
        var storedValue = null;
        var item = this.storage.getItem(this.prefixKey(key));
        if (!!item) {
            storedValue = parseJSON(item);
        }
        return storedValue === null ? defaultValue : storedValue;
    };
    WebStorage.prototype.remove = function (key) {
        return this.storage.removeItem(this.prefixKey(key));
    };
    WebStorage.prototype.clear = function (force) {
        var _this = this;
        if (force === void 0) { force = false; }
        if (force) {
            this.storage.clear();
        }
        else {
            this.keys(true).map(function (key) {
                _this.storage.removeItem(key);
            });
        }
    };
    WebStorage.prototype.keys = function (withPrefix) {
        var _this = this;
        if (withPrefix === void 0) { withPrefix = false; }
        var keys = [];
        // Loop through all storage keys
        Object.keys(this.storage).forEach(function (keyName) {
            /* istanbul ignore else */
            if (keyName.substr(0, _this.prefix.length) === _this.prefix) {
                keys.push(withPrefix ? keyName : keyName.substring(_this.prefix.length));
            }
        });
        return keys;
    };
    WebStorage.prototype.hasKey = function (key) {
        return this.keys().indexOf(key) !== -1;
    };
    WebStorage.prototype.length = function () {
        return this.keys().length;
    };
    WebStorage.prototype.resolveDriver = function (driver) {
        switch (driver) {
            case 'local':
                return window.localStorage;
            case 'session':
                return window.sessionStorage;
            default:
                throw new Error("Unknown driver supplied: " + driver);
        }
    };
    return WebStorage;
}());
/* harmony default export */ var webStorage = (webStorage_WebStorage);

// CONCATENATED MODULE: ./src/events.ts

var listeners = {};
var events_Events = /** @class */ (function () {
    function Events() {
        window.addEventListener('storage', this.onChange, false);
    }
    Events.prototype.onChange = function (event) {
        var _this = this;
        // According to specs the key can be `null`
        if (!event.key)
            return;
        // Notice: `this` refers to `window` inside this method
        var methods = listeners[event.key];
        /*istanbul ignore else*/
        if (methods) {
            var newValue_1 = parseJSON(event.newValue);
            var oldValue_1 = parseJSON(event.oldValue);
            methods.map(function (method) {
                method.call(_this, newValue_1, oldValue_1, event.url);
            });
        }
    };
    Events.prototype.on = function (key, fn) {
        if (listeners[key]) {
            listeners[key].push(fn);
        }
        else {
            listeners[key] = [fn];
        }
    };
    Events.prototype.off = function (key, fn) {
        var methods = listeners[key];
        if (methods && methods.length > 1) {
            methods.splice(methods.indexOf(fn), 1);
        }
        else {
            delete listeners[key];
        }
    };
    Events.prototype.clear = function (key) {
        if (key) {
            delete listeners[key];
        }
        else {
            listeners = {};
        }
    };
    Events.prototype.listeners = function () {
        return listeners;
    };
    return Events;
}());
/* harmony default export */ var events = (events_Events);

// CONCATENATED MODULE: ./src/storageWithEvents.ts
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();


var storageWithEvents_StorageWithEvents = /** @class */ (function (_super) {
    __extends(StorageWithEvents, _super);
    function StorageWithEvents(prefix, driver) {
        if (prefix === void 0) { prefix = 'app_'; }
        if (driver === void 0) { driver = 'local'; }
        var _this = _super.call(this, prefix, driver) || this;
        _this.events = new events();
        return _this;
    }
    StorageWithEvents.prototype.on = function (key, fn) {
        this.events.on(this.prefixKey(key), fn);
        return this;
    };
    StorageWithEvents.prototype.off = function (key, fn) {
        this.events.off(this.prefixKey(key), fn);
        return this;
    };
    StorageWithEvents.prototype.clearEvents = function (key) {
        var mayBeKey = key ? this.prefixKey(key) : false;
        this.events.clear(mayBeKey);
        return this;
    };
    return StorageWithEvents;
}(webStorage));
/* harmony default export */ var storageWithEvents = (storageWithEvents_StorageWithEvents);

// CONCATENATED MODULE: ./src/index.ts



var registerInstance = function (Vue, driver, prefix) {
    var instance = new storageWithEvents(prefix, driver);
    var apiName = '$' + String(driver) + 'Storage';
    Vue[apiName] = instance;
    Vue.prototype[apiName] = instance;
};
var Plugin = function (Vue, options) {
    if (options === void 0) { options = {}; }
    var safeOptions = Object.assign({}, {
        prefix: 'app_',
        drivers: 'local'
    }, options);
    arrayify(safeOptions.drivers).map(function (driver) {
        registerInstance(Vue, driver, safeOptions.prefix);
    });
};
/* harmony default export */ var src = __webpack_exports__["default"] = (Plugin);



/***/ })
/******/ ]);
});