import WebStorage from './webStorage';
import StorageWithEvents from './storageWithEvents';
import { driverType } from "./interfaces";
import { PluginFunction, PluginObject } from 'vue';
export interface PluginOptions {
    prefix?: string;
    drivers?: driverType[];
}
declare const Plugin: PluginFunction<PluginOptions>;
export interface VueWebStoragePlugin extends PluginObject<PluginOptions> {
    install: PluginFunction<PluginOptions>;
}
declare module 'vue/types/vue' {
    interface Vue {
        readonly $sessionStorage: StorageWithEvents;
        readonly $localStorage: StorageWithEvents;
    }
    interface VueConstructor {
        readonly $sessionStorage: StorageWithEvents;
        readonly $localStorage: StorageWithEvents;
    }
}
export default Plugin;
export { WebStorage, StorageWithEvents, Plugin };
