import { driverType } from "./interfaces";
export default class WebStorage {
    readonly prefix: string;
    readonly storage: Storage;
    constructor(prefix?: string, driver?: driverType);
    prefixKey(key: string): string;
    set(key: string, value: any): void;
    get<T extends any>(key: string, defaultValue?: string | any): T;
    remove(key: string): void;
    clear(force?: boolean): void;
    keys(withPrefix?: boolean): string[];
    hasKey(key: string): boolean;
    length(): number;
    private resolveDriver;
}
