'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _omit = require('lodash/omit');

var _omit2 = _interopRequireDefault(_omit);

var _manager = require('../manager.js');

var _deferredReady = require('../utils/deferredReady.js');

var _eventsBinder = require('../utils/eventsBinder.js');

var _eventsBinder2 = _interopRequireDefault(_eventsBinder);

var _propsBinder = require('../utils/propsBinder.js');

var _propsBinder2 = _interopRequireDefault(_propsBinder);

var _getPropsValuesMixin = require('../utils/getPropsValuesMixin.js');

var _getPropsValuesMixin2 = _interopRequireDefault(_getPropsValuesMixin);

var _mountableMixin = require('../utils/mountableMixin.js');

var _mountableMixin2 = _interopRequireDefault(_mountableMixin);

var _TwoWayBindingWrapper = require('../utils/TwoWayBindingWrapper.js');

var _TwoWayBindingWrapper2 = _interopRequireDefault(_TwoWayBindingWrapper);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

var props = {
  zoom: {
    twoWay: true,
    type: Number
  },
  pov: {
    twoWay: true,
    type: Object,
    trackProperties: ['pitch', 'heading']
  },
  position: {
    twoWay: true,
    type: Object
  },
  pano: {
    twoWay: true,
    type: String
  },
  motionTracking: {
    twoWay: false,
    type: Boolean
  },
  visible: {
    twoWay: true,
    type: Boolean,
    default: true
  },
  options: {
    twoWay: false,
    type: Object,
    default: function _default() {
      return {};
    }
  }
};

var events = ['closeclick', 'status_changed'];

// Other convenience methods exposed by Vue Google Maps
var customMethods = {
  resize: function resize() {
    if (this.$panoObject) {
      google.maps.event.trigger(this.$panoObject, 'resize');
    }
  }
};

// Methods is a combination of customMethods and linkedMethods
var methods = Object.assign({}, customMethods);

exports.default = {
  mixins: [_getPropsValuesMixin2.default, _deferredReady.DeferredReadyMixin, _mountableMixin2.default],
  props: props,
  replace: false, // necessary for css styles
  methods: methods,

  created: function created() {
    var _this = this;

    this.$panoCreated = new Promise(function (resolve, reject) {
      _this.$panoCreatedDeferred = { resolve: resolve, reject: reject };
    });

    var updateCenter = function updateCenter() {
      if (!_this.panoObject) return;

      _this.$panoObject.setPosition({
        lat: _this.finalLat,
        lng: _this.finalLng
      });
    };
    this.$watch('finalLat', updateCenter);
    this.$watch('finalLng', updateCenter);
  },


  computed: {
    finalLat: function finalLat() {
      return this.position && typeof this.position.lat === 'function' ? this.position.lat() : this.position.lat;
    },
    finalLng: function finalLng() {
      return this.position && typeof this.position.lng === 'function' ? this.position.lng() : this.position.lng;
    },
    finalLatLng: function finalLatLng() {
      return {
        lat: this.finalLat,
        lng: this.finalLng
      };
    }
  },

  watch: {
    zoom: function zoom(_zoom) {
      if (this.$panoObject) {
        this.$panoObject.setZoom(_zoom);
      }
    }
  },

  deferredReady: function deferredReady() {
    var _this2 = this;

    return _manager.loaded.then(function () {
      // getting the DOM element where to create the map
      var element = _this2.$refs['vue-street-view-pano'];

      // creating the map
      var options = Object.assign({}, _this2.options, (0, _omit2.default)(_this2.getPropsValues(), ['options']));

      _this2.$panoObject = new google.maps.StreetViewPanorama(element, options);

      // binding properties (two and one way)
      (0, _propsBinder2.default)(_this2, _this2.$panoObject, (0, _omit2.default)(props, ['position']));

      // manually trigger position
      (0, _TwoWayBindingWrapper2.default)(function (increment, decrement, shouldUpdate) {
        // Panos take a while to load
        increment();

        _this2.$panoObject.addListener('position_changed', function () {
          if (shouldUpdate()) {
            _this2.$emit('position_changed', _this2.$panoObject.getPosition());
          }
          decrement();
        });

        _this2.$watch('finalLatLng', function () {
          increment();
          _this2.$panoObject.setPosition(_this2.finalLatLng);
        });
      });

      // binding events
      (0, _eventsBinder2.default)(_this2, _this2.$panoObject, events);

      _this2.$panoCreatedDeferred.resolve(_this2.$panoObject);

      return _this2.$panoCreated;
    }).catch(function (error) {
      throw error;
    });
  }
};