export interface SetterOptions {
    ttl?: number;
}
export declare enum StorageDriver {
    LOCAL = "local",
    SESSION = "session",
    MEMORY = "memory"
}
export interface StorageOptions {
    prefix?: string;
    driver?: StorageDriver;
    ttl?: number;
    replacer?: (key: string, value: any) => any;
}
export default class Vue2Storage {
    private options;
    constructor(config?: StorageOptions);
    readonly length: number;
    readonly prefix: string;
    private readonly name;
    private readonly version;
    private readonly driver;
    setOptions(config?: StorageOptions): void;
    get(key: string, fallback?: any): any;
    pull(key: string, fallback?: any): any;
    set(key: string, val: any, options?: SetterOptions): void;
    remember<T = any>(key: string, closure: () => Promise<T>, options?: SetterOptions): Promise<T>;
    remove(key: string): void;
    clear(force?: boolean): void;
    has(key: string): boolean;
    key(index: number): any;
    keys(): string[];
    private checkConfig;
    private addPrefix;
    private removePrefix;
    private toJSON;
    private fromJSON;
    private removeExpiredValuesByKeys;
    private throwError;
}
