import { RendererElement } from 'vue';
import { FileWithPath } from 'file-selector';
declare type FileAccept = string | string[];
declare type FileHandler = (evt: Event) => void;
declare type FileErrorCode = 'file-invalid-type' | 'file-too-large' | 'file-too-small' | 'too-many-files' | string;
declare type FileRejectionError = {
    code: FileErrorCode;
    message: string;
} | null | boolean;
declare type InputFile = (FileWithPath | DataTransferItem) & {
    size?: number;
};
export declare type FileRejectReason = {
    file: InputFile;
    errors: FileRejectionError[];
};
export interface FileUploadOptions {
    accept: FileAccept;
    disabled: boolean;
    getFilesFromEvent: (evt: Event | any) => Promise<InputFile[]>;
    maxSize: number;
    minSize: number;
    multiple: boolean;
    maxFiles: number;
    onDragEnter: FileHandler;
    onDragLeave: FileHandler;
    onDragOver: FileHandler;
    onDrop: (acceptedFiles: any[], rejectReasons: FileRejectReason[], event: Event) => void;
    onDropAccepted: (acceptedFiles: InputFile[], event: Event) => void;
    onDropRejected: (rejectReasons: FileRejectReason[], event: Event) => void;
    onFileDialogCancel: () => void;
    preventDropOnDocument: boolean;
    noClick: boolean;
    noKeyboard: boolean;
    noDrag: boolean;
    noDragEventsBubbling: boolean;
}
declare type ComposeFunction = () => void;
export declare function isIeOrEdge(userAgent?: string): boolean;
export declare function onDocumentDragOver(event: Event): void;
export declare function isEvtWithFiles(event: Event & {
    dataTransfer?: {
        types: string;
    };
    target?: EventTarget & {
        files: InputFile[];
    };
} | any): boolean;
export declare function isPropagationStopped(event: Event & {
    isPropagationStopped?: () => boolean;
}): boolean;
export declare const FILE_INVALID_TYPE = "file-invalid-type";
export declare const FILE_TOO_LARGE = "file-too-large";
export declare const FILE_TOO_SMALL = "file-too-small";
export declare const TOO_MANY_FILES = "too-many-files";
export declare const TOO_MANY_FILES_REJECTION: FileRejectionError;
export declare const getInvalidTypeRejectionErr: (accept: FileAccept) => FileRejectionError;
export declare function fileAccepted(file: InputFile, accept: FileAccept): [boolean, null | FileRejectionError];
export declare const getTooLargeRejectionErr: (maxSize: number) => FileRejectionError;
export declare const getTooSmallRejectionErr: (minSize: number) => FileRejectionError;
export declare function fileMatchSize(file: InputFile, minSize: number, maxSize: number): FileRejectionError[];
export declare function composeEventHandlers(...fns: any): any;
export declare function allFilesAccepted({ files, accept, minSize, maxSize, multiple, maxFiles, }: any): any;
export declare function useDropzone(options?: Partial<FileUploadOptions>): {
    isDragAccept: import("vue").ComputedRef<any>;
    isDragReject: import("vue").ComputedRef<boolean>;
    isFocused: import("vue").ComputedRef<boolean>;
    getRootProps: ({ onKeyDown, onFocus, onBlur, onClick, onDragEnter, onDragenter, onDragOver, onDragover, onDragLeave, onDragleave, onDrop, ...rest }?: {
        [key: string]: any;
    }) => {
        tabIndex?: number | undefined;
        onKeyDown: ComposeFunction | undefined;
        onFocus: ComposeFunction | undefined;
        onBlur: ComposeFunction | undefined;
        onClick: ComposeFunction | undefined;
        onDragenter: ComposeFunction | undefined;
        onDragover: ComposeFunction | undefined;
        onDragleave: ComposeFunction | undefined;
        onDrop: ComposeFunction | undefined;
        ref: import("vue").Ref<RendererElement | undefined>;
    };
    getInputProps: ({ onChange, onClick, ...rest }?: {
        onChange?: (() => void) | undefined;
        onClick?: (() => void) | undefined;
    }) => {
        accept: string;
        multiple: boolean | undefined;
        style: string;
        type: string;
        onChange: ComposeFunction | undefined;
        onClick: ComposeFunction | undefined;
        autoComplete: string;
        tabIndex: number;
        ref: import("vue").Ref<RendererElement | undefined>;
    };
    rootRef: import("vue").Ref<RendererElement | undefined>;
    inputRef: import("vue").Ref<RendererElement | undefined>;
    open: ComposeFunction | undefined;
    isFileDialogActive: import("vue").Ref<boolean>;
    isDragActive: import("vue").Ref<boolean>;
    draggedFiles: import("vue").Ref<readonly ({
        readonly path?: string | undefined;
        readonly lastModified: number;
        readonly name: string;
        readonly size: number;
        readonly type: string;
        arrayBuffer: () => Promise<ArrayBuffer>;
        slice: (start?: number | undefined, end?: number | undefined, contentType?: string | undefined) => Blob;
        stream: () => ReadableStream<any>;
        text: () => Promise<string>;
    } | {
        readonly kind: string;
        readonly type: string;
        getAsFile: () => File | null;
        getAsString: (callback: FunctionStringCallback | null) => void;
        webkitGetAsEntry: () => any;
        size?: number | undefined;
    })[] & {
        [Symbol.iterator]: () => IterableIterator<InputFile>;
    }>;
    acceptedFiles: import("vue").Ref<readonly ({
        readonly path?: string | undefined;
        readonly lastModified: number;
        readonly name: string;
        readonly size: number;
        readonly type: string;
        arrayBuffer: () => Promise<ArrayBuffer>;
        slice: (start?: number | undefined, end?: number | undefined, contentType?: string | undefined) => Blob;
        stream: () => ReadableStream<any>;
        text: () => Promise<string>;
    } | {
        readonly kind: string;
        readonly type: string;
        getAsFile: () => File | null;
        getAsString: (callback: FunctionStringCallback | null) => void;
        webkitGetAsEntry: () => any;
        size?: number | undefined;
    })[] & {
        [Symbol.iterator]: () => IterableIterator<InputFile>;
    }>;
    fileRejections: import("vue").Ref<readonly {
        readonly file: {
            readonly path?: string | undefined;
            readonly lastModified: number;
            readonly name: string;
            readonly size: number;
            readonly type: string;
            arrayBuffer: () => Promise<ArrayBuffer>;
            slice: (start?: number | undefined, end?: number | undefined, contentType?: string | undefined) => Blob;
            stream: () => ReadableStream<any>;
            text: () => Promise<string>;
        } | {
            readonly kind: string;
            readonly type: string;
            getAsFile: () => File | null;
            getAsString: (callback: FunctionStringCallback | null) => void;
            webkitGetAsEntry: () => any;
            size?: number | undefined;
        };
        readonly errors: readonly (boolean | {
            readonly code: string;
            readonly message: string;
        } | null)[] & {
            [Symbol.iterator]: () => IterableIterator<import("./useReducer").DeepReadonly<FileRejectionError>>;
        };
    }[] & {
        [Symbol.iterator]: () => IterableIterator<import("./useReducer").DeepReadonly<FileRejectReason>>;
    }>;
};
export {};
