declare type Unwrap<T> = T extends {
    [k: string]: infer U;
} ? U : T extends (infer U)[] ? U : T;
declare type isPrimitive<T> = T extends Unwrap<T> ? T : never;
export declare type DeepReadonly<T> = {
    readonly [P in keyof T]: T[P] extends isPrimitive<T[P]> ? T[P] : DeepReadonly<T[P]>;
};
declare type State = Record<string, unknown>;
declare type Action = {
    type: string;
};
export declare type ReducerState = State;
export declare type ReducerAction = Action;
export declare type Dispatch<A extends Action> = (action: A) => void;
export declare type Reducer<S extends State, A extends Action> = (state: S, action: A) => S;
export declare type ReturnValue<S extends State, A extends Action> = [
    DeepReadonly<S>,
    Dispatch<A>
];
export declare const useReducer: <S extends State, A extends Action>(reducer: Reducer<S, A>, initialState: S, initialAction?: A | undefined) => ReturnValue<S, A>;
export {};
