'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var CompilerDOM = require('@vue/compiler-dom');
var require$$0$1 = require('source-map');
var MagicString = require('magic-string');
var parser$2 = require('@babel/parser');
var shared = require('@vue/shared');
var estreeWalker = require('estree-walker');
var path$2 = require('path');
var compilerCore = require('@vue/compiler-core');
var url = require('url');
var CompilerSSR = require('@vue/compiler-ssr');
var require$$2 = require('util');
var require$$0 = require('fs');
var reactivityTransform = require('@vue/reactivity-transform');
var require$$0$2 = require('postcss');

function _interopNamespaceDefault(e) {
	var n = Object.create(null);
	if (e) {
		for (var k in e) {
			n[k] = e[k];
		}
	}
	n.default = e;
	return Object.freeze(n);
}

var CompilerDOM__namespace = /*#__PURE__*/_interopNamespaceDefault(CompilerDOM);
var CompilerSSR__namespace = /*#__PURE__*/_interopNamespaceDefault(CompilerSSR);

var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

function getDefaultExportFromCjs (x) {
	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
}

function pad (hash, len) {
  while (hash.length < len) {
    hash = '0' + hash;
  }
  return hash;
}

function fold (hash, text) {
  var i;
  var chr;
  var len;
  if (text.length === 0) {
    return hash;
  }
  for (i = 0, len = text.length; i < len; i++) {
    chr = text.charCodeAt(i);
    hash = ((hash << 5) - hash) + chr;
    hash |= 0;
  }
  return hash < 0 ? hash * -2 : hash;
}

function foldObject (hash, o, seen) {
  return Object.keys(o).sort().reduce(foldKey, hash);
  function foldKey (hash, key) {
    return foldValue(hash, o[key], key, seen);
  }
}

function foldValue (input, value, key, seen) {
  var hash = fold(fold(fold(input, key), toString$1(value)), typeof value);
  if (value === null) {
    return fold(hash, 'null');
  }
  if (value === undefined) {
    return fold(hash, 'undefined');
  }
  if (typeof value === 'object' || typeof value === 'function') {
    if (seen.indexOf(value) !== -1) {
      return fold(hash, '[Circular]' + key);
    }
    seen.push(value);

    var objHash = foldObject(hash, value, seen);

    if (!('valueOf' in value) || typeof value.valueOf !== 'function') {
      return objHash;
    }

    try {
      return fold(objHash, String(value.valueOf()))
    } catch (err) {
      return fold(objHash, '[valueOf exception]' + (err.stack || err.message))
    }
  }
  return fold(hash, value.toString());
}

function toString$1 (o) {
  return Object.prototype.toString.call(o);
}

function sum (o) {
  return pad(foldValue(0, o, '', []).toString(16), 8);
}

var hashSum = sum;

var hash$1 = hashSum;

const CSS_VARS_HELPER = `useCssVars`;
function genCssVarsFromList(vars, id, isProd, isSSR = false) {
  return `{
  ${vars.map(
    (key) => `"${isSSR ? `--` : ``}${genVarName(id, key, isProd)}": (${key})`
  ).join(",\n  ")}
}`;
}
function genVarName(id, raw, isProd) {
  if (isProd) {
    return hash$1(id + raw);
  } else {
    return `${id}-${raw.replace(
      /[ !"#$%&'()*+,./:;<=>?@[\\\]^`{|}~]/g,
      (s) => `\\${s}`
    )}`;
  }
}
function normalizeExpression(exp) {
  exp = exp.trim();
  if (exp[0] === `'` && exp[exp.length - 1] === `'` || exp[0] === `"` && exp[exp.length - 1] === `"`) {
    return exp.slice(1, -1);
  }
  return exp;
}
const vBindRE = /v-bind\s*\(/g;
function parseCssVars(sfc) {
  const vars = [];
  sfc.styles.forEach((style) => {
    let match;
    const content = style.content.replace(/\/\*([\s\S]*?)\*\//g, "");
    while (match = vBindRE.exec(content)) {
      const start = match.index + match[0].length;
      const end = lexBinding(content, start);
      if (end !== null) {
        const variable = normalizeExpression(content.slice(start, end));
        if (!vars.includes(variable)) {
          vars.push(variable);
        }
      }
    }
  });
  return vars;
}
function lexBinding(content, start) {
  let state = 0 /* inParens */;
  let parenDepth = 0;
  for (let i = start; i < content.length; i++) {
    const char = content.charAt(i);
    switch (state) {
      case 0 /* inParens */:
        if (char === `'`) {
          state = 1 /* inSingleQuoteString */;
        } else if (char === `"`) {
          state = 2 /* inDoubleQuoteString */;
        } else if (char === `(`) {
          parenDepth++;
        } else if (char === `)`) {
          if (parenDepth > 0) {
            parenDepth--;
          } else {
            return i;
          }
        }
        break;
      case 1 /* inSingleQuoteString */:
        if (char === `'`) {
          state = 0 /* inParens */;
        }
        break;
      case 2 /* inDoubleQuoteString */:
        if (char === `"`) {
          state = 0 /* inParens */;
        }
        break;
    }
  }
  return null;
}
const cssVarsPlugin = (opts) => {
  const { id, isProd } = opts;
  return {
    postcssPlugin: "vue-sfc-vars",
    Declaration(decl) {
      const value = decl.value;
      if (vBindRE.test(value)) {
        vBindRE.lastIndex = 0;
        let transformed = "";
        let lastIndex = 0;
        let match;
        while (match = vBindRE.exec(value)) {
          const start = match.index + match[0].length;
          const end = lexBinding(value, start);
          if (end !== null) {
            const variable = normalizeExpression(value.slice(start, end));
            transformed += value.slice(lastIndex, match.index) + `var(--${genVarName(id, variable, isProd)})`;
            lastIndex = end + 1;
          }
        }
        decl.value = transformed + value.slice(lastIndex);
      }
    }
  };
};
cssVarsPlugin.postcss = true;
function genCssVarsCode(vars, bindings, id, isProd) {
  const varsExp = genCssVarsFromList(vars, id, isProd);
  const exp = CompilerDOM.createSimpleExpression(varsExp, false);
  const context = CompilerDOM.createTransformContext(CompilerDOM.createRoot([]), {
    prefixIdentifiers: true,
    inline: true,
    bindingMetadata: bindings.__isScriptSetup === false ? void 0 : bindings
  });
  const transformed = CompilerDOM.processExpression(exp, context);
  const transformedString = transformed.type === 4 ? transformed.content : transformed.children.map((c) => {
    return typeof c === "string" ? c : c.content;
  }).join("");
  return `_${CSS_VARS_HELPER}(_ctx => (${transformedString}))`;
}
function genNormalScriptCssVarsCode(cssVars, bindings, id, isProd) {
  return `
import { ${CSS_VARS_HELPER} as _${CSS_VARS_HELPER} } from 'vue'
const __injectCSSVars__ = () => {
${genCssVarsCode(
    cssVars,
    bindings,
    id,
    isProd
  )}}
const __setup__ = __default__.setup
__default__.setup = __setup__
  ? (props, ctx) => { __injectCSSVars__();return __setup__(props, ctx) }
  : __injectCSSVars__
`;
}

var iterator;
var hasRequiredIterator;

function requireIterator () {
	if (hasRequiredIterator) return iterator;
	hasRequiredIterator = 1;
	iterator = function (Yallist) {
	  Yallist.prototype[Symbol.iterator] = function* () {
	    for (let walker = this.head; walker; walker = walker.next) {
	      yield walker.value;
	    }
	  };
	};
	return iterator;
}

var yallist = Yallist$1;

Yallist$1.Node = Node;
Yallist$1.create = Yallist$1;

function Yallist$1 (list) {
  var self = this;
  if (!(self instanceof Yallist$1)) {
    self = new Yallist$1();
  }

  self.tail = null;
  self.head = null;
  self.length = 0;

  if (list && typeof list.forEach === 'function') {
    list.forEach(function (item) {
      self.push(item);
    });
  } else if (arguments.length > 0) {
    for (var i = 0, l = arguments.length; i < l; i++) {
      self.push(arguments[i]);
    }
  }

  return self
}

Yallist$1.prototype.removeNode = function (node) {
  if (node.list !== this) {
    throw new Error('removing node which does not belong to this list')
  }

  var next = node.next;
  var prev = node.prev;

  if (next) {
    next.prev = prev;
  }

  if (prev) {
    prev.next = next;
  }

  if (node === this.head) {
    this.head = next;
  }
  if (node === this.tail) {
    this.tail = prev;
  }

  node.list.length--;
  node.next = null;
  node.prev = null;
  node.list = null;

  return next
};

Yallist$1.prototype.unshiftNode = function (node) {
  if (node === this.head) {
    return
  }

  if (node.list) {
    node.list.removeNode(node);
  }

  var head = this.head;
  node.list = this;
  node.next = head;
  if (head) {
    head.prev = node;
  }

  this.head = node;
  if (!this.tail) {
    this.tail = node;
  }
  this.length++;
};

Yallist$1.prototype.pushNode = function (node) {
  if (node === this.tail) {
    return
  }

  if (node.list) {
    node.list.removeNode(node);
  }

  var tail = this.tail;
  node.list = this;
  node.prev = tail;
  if (tail) {
    tail.next = node;
  }

  this.tail = node;
  if (!this.head) {
    this.head = node;
  }
  this.length++;
};

Yallist$1.prototype.push = function () {
  for (var i = 0, l = arguments.length; i < l; i++) {
    push(this, arguments[i]);
  }
  return this.length
};

Yallist$1.prototype.unshift = function () {
  for (var i = 0, l = arguments.length; i < l; i++) {
    unshift(this, arguments[i]);
  }
  return this.length
};

Yallist$1.prototype.pop = function () {
  if (!this.tail) {
    return undefined
  }

  var res = this.tail.value;
  this.tail = this.tail.prev;
  if (this.tail) {
    this.tail.next = null;
  } else {
    this.head = null;
  }
  this.length--;
  return res
};

Yallist$1.prototype.shift = function () {
  if (!this.head) {
    return undefined
  }

  var res = this.head.value;
  this.head = this.head.next;
  if (this.head) {
    this.head.prev = null;
  } else {
    this.tail = null;
  }
  this.length--;
  return res
};

Yallist$1.prototype.forEach = function (fn, thisp) {
  thisp = thisp || this;
  for (var walker = this.head, i = 0; walker !== null; i++) {
    fn.call(thisp, walker.value, i, this);
    walker = walker.next;
  }
};

Yallist$1.prototype.forEachReverse = function (fn, thisp) {
  thisp = thisp || this;
  for (var walker = this.tail, i = this.length - 1; walker !== null; i--) {
    fn.call(thisp, walker.value, i, this);
    walker = walker.prev;
  }
};

Yallist$1.prototype.get = function (n) {
  for (var i = 0, walker = this.head; walker !== null && i < n; i++) {
    // abort out of the list early if we hit a cycle
    walker = walker.next;
  }
  if (i === n && walker !== null) {
    return walker.value
  }
};

Yallist$1.prototype.getReverse = function (n) {
  for (var i = 0, walker = this.tail; walker !== null && i < n; i++) {
    // abort out of the list early if we hit a cycle
    walker = walker.prev;
  }
  if (i === n && walker !== null) {
    return walker.value
  }
};

Yallist$1.prototype.map = function (fn, thisp) {
  thisp = thisp || this;
  var res = new Yallist$1();
  for (var walker = this.head; walker !== null;) {
    res.push(fn.call(thisp, walker.value, this));
    walker = walker.next;
  }
  return res
};

Yallist$1.prototype.mapReverse = function (fn, thisp) {
  thisp = thisp || this;
  var res = new Yallist$1();
  for (var walker = this.tail; walker !== null;) {
    res.push(fn.call(thisp, walker.value, this));
    walker = walker.prev;
  }
  return res
};

Yallist$1.prototype.reduce = function (fn, initial) {
  var acc;
  var walker = this.head;
  if (arguments.length > 1) {
    acc = initial;
  } else if (this.head) {
    walker = this.head.next;
    acc = this.head.value;
  } else {
    throw new TypeError('Reduce of empty list with no initial value')
  }

  for (var i = 0; walker !== null; i++) {
    acc = fn(acc, walker.value, i);
    walker = walker.next;
  }

  return acc
};

Yallist$1.prototype.reduceReverse = function (fn, initial) {
  var acc;
  var walker = this.tail;
  if (arguments.length > 1) {
    acc = initial;
  } else if (this.tail) {
    walker = this.tail.prev;
    acc = this.tail.value;
  } else {
    throw new TypeError('Reduce of empty list with no initial value')
  }

  for (var i = this.length - 1; walker !== null; i--) {
    acc = fn(acc, walker.value, i);
    walker = walker.prev;
  }

  return acc
};

Yallist$1.prototype.toArray = function () {
  var arr = new Array(this.length);
  for (var i = 0, walker = this.head; walker !== null; i++) {
    arr[i] = walker.value;
    walker = walker.next;
  }
  return arr
};

Yallist$1.prototype.toArrayReverse = function () {
  var arr = new Array(this.length);
  for (var i = 0, walker = this.tail; walker !== null; i++) {
    arr[i] = walker.value;
    walker = walker.prev;
  }
  return arr
};

Yallist$1.prototype.slice = function (from, to) {
  to = to || this.length;
  if (to < 0) {
    to += this.length;
  }
  from = from || 0;
  if (from < 0) {
    from += this.length;
  }
  var ret = new Yallist$1();
  if (to < from || to < 0) {
    return ret
  }
  if (from < 0) {
    from = 0;
  }
  if (to > this.length) {
    to = this.length;
  }
  for (var i = 0, walker = this.head; walker !== null && i < from; i++) {
    walker = walker.next;
  }
  for (; walker !== null && i < to; i++, walker = walker.next) {
    ret.push(walker.value);
  }
  return ret
};

Yallist$1.prototype.sliceReverse = function (from, to) {
  to = to || this.length;
  if (to < 0) {
    to += this.length;
  }
  from = from || 0;
  if (from < 0) {
    from += this.length;
  }
  var ret = new Yallist$1();
  if (to < from || to < 0) {
    return ret
  }
  if (from < 0) {
    from = 0;
  }
  if (to > this.length) {
    to = this.length;
  }
  for (var i = this.length, walker = this.tail; walker !== null && i > to; i--) {
    walker = walker.prev;
  }
  for (; walker !== null && i > from; i--, walker = walker.prev) {
    ret.push(walker.value);
  }
  return ret
};

Yallist$1.prototype.splice = function (start, deleteCount /*, ...nodes */) {
  if (start > this.length) {
    start = this.length - 1;
  }
  if (start < 0) {
    start = this.length + start;
  }

  for (var i = 0, walker = this.head; walker !== null && i < start; i++) {
    walker = walker.next;
  }

  var ret = [];
  for (var i = 0; walker && i < deleteCount; i++) {
    ret.push(walker.value);
    walker = this.removeNode(walker);
  }
  if (walker === null) {
    walker = this.tail;
  }

  if (walker !== this.head && walker !== this.tail) {
    walker = walker.prev;
  }

  for (var i = 2; i < arguments.length; i++) {
    walker = insert(this, walker, arguments[i]);
  }
  return ret;
};

Yallist$1.prototype.reverse = function () {
  var head = this.head;
  var tail = this.tail;
  for (var walker = head; walker !== null; walker = walker.prev) {
    var p = walker.prev;
    walker.prev = walker.next;
    walker.next = p;
  }
  this.head = tail;
  this.tail = head;
  return this
};

function insert (self, node, value) {
  var inserted = node === self.head ?
    new Node(value, null, node, self) :
    new Node(value, node, node.next, self);

  if (inserted.next === null) {
    self.tail = inserted;
  }
  if (inserted.prev === null) {
    self.head = inserted;
  }

  self.length++;

  return inserted
}

function push (self, item) {
  self.tail = new Node(item, self.tail, null, self);
  if (!self.head) {
    self.head = self.tail;
  }
  self.length++;
}

function unshift (self, item) {
  self.head = new Node(item, null, self.head, self);
  if (!self.tail) {
    self.tail = self.head;
  }
  self.length++;
}

function Node (value, prev, next, list) {
  if (!(this instanceof Node)) {
    return new Node(value, prev, next, list)
  }

  this.list = list;
  this.value = value;

  if (prev) {
    prev.next = this;
    this.prev = prev;
  } else {
    this.prev = null;
  }

  if (next) {
    next.prev = this;
    this.next = next;
  } else {
    this.next = null;
  }
}

try {
  // add if support for Symbol.iterator is present
  requireIterator()(Yallist$1);
} catch (er) {}

// A linked list to keep track of recently-used-ness
const Yallist = yallist;

const MAX = Symbol('max');
const LENGTH = Symbol('length');
const LENGTH_CALCULATOR = Symbol('lengthCalculator');
const ALLOW_STALE = Symbol('allowStale');
const MAX_AGE = Symbol('maxAge');
const DISPOSE = Symbol('dispose');
const NO_DISPOSE_ON_SET = Symbol('noDisposeOnSet');
const LRU_LIST = Symbol('lruList');
const CACHE = Symbol('cache');
const UPDATE_AGE_ON_GET = Symbol('updateAgeOnGet');

const naiveLength = () => 1;

// lruList is a yallist where the head is the youngest
// item, and the tail is the oldest.  the list contains the Hit
// objects as the entries.
// Each Hit object has a reference to its Yallist.Node.  This
// never changes.
//
// cache is a Map (or PseudoMap) that matches the keys to
// the Yallist.Node object.
class LRUCache {
  constructor (options) {
    if (typeof options === 'number')
      options = { max: options };

    if (!options)
      options = {};

    if (options.max && (typeof options.max !== 'number' || options.max < 0))
      throw new TypeError('max must be a non-negative number')
    // Kind of weird to have a default max of Infinity, but oh well.
    this[MAX] = options.max || Infinity;

    const lc = options.length || naiveLength;
    this[LENGTH_CALCULATOR] = (typeof lc !== 'function') ? naiveLength : lc;
    this[ALLOW_STALE] = options.stale || false;
    if (options.maxAge && typeof options.maxAge !== 'number')
      throw new TypeError('maxAge must be a number')
    this[MAX_AGE] = options.maxAge || 0;
    this[DISPOSE] = options.dispose;
    this[NO_DISPOSE_ON_SET] = options.noDisposeOnSet || false;
    this[UPDATE_AGE_ON_GET] = options.updateAgeOnGet || false;
    this.reset();
  }

  // resize the cache when the max changes.
  set max (mL) {
    if (typeof mL !== 'number' || mL < 0)
      throw new TypeError('max must be a non-negative number')

    this[MAX] = mL || Infinity;
    trim(this);
  }
  get max () {
    return this[MAX]
  }

  set allowStale (allowStale) {
    this[ALLOW_STALE] = !!allowStale;
  }
  get allowStale () {
    return this[ALLOW_STALE]
  }

  set maxAge (mA) {
    if (typeof mA !== 'number')
      throw new TypeError('maxAge must be a non-negative number')

    this[MAX_AGE] = mA;
    trim(this);
  }
  get maxAge () {
    return this[MAX_AGE]
  }

  // resize the cache when the lengthCalculator changes.
  set lengthCalculator (lC) {
    if (typeof lC !== 'function')
      lC = naiveLength;

    if (lC !== this[LENGTH_CALCULATOR]) {
      this[LENGTH_CALCULATOR] = lC;
      this[LENGTH] = 0;
      this[LRU_LIST].forEach(hit => {
        hit.length = this[LENGTH_CALCULATOR](hit.value, hit.key);
        this[LENGTH] += hit.length;
      });
    }
    trim(this);
  }
  get lengthCalculator () { return this[LENGTH_CALCULATOR] }

  get length () { return this[LENGTH] }
  get itemCount () { return this[LRU_LIST].length }

  rforEach (fn, thisp) {
    thisp = thisp || this;
    for (let walker = this[LRU_LIST].tail; walker !== null;) {
      const prev = walker.prev;
      forEachStep(this, fn, walker, thisp);
      walker = prev;
    }
  }

  forEach (fn, thisp) {
    thisp = thisp || this;
    for (let walker = this[LRU_LIST].head; walker !== null;) {
      const next = walker.next;
      forEachStep(this, fn, walker, thisp);
      walker = next;
    }
  }

  keys () {
    return this[LRU_LIST].toArray().map(k => k.key)
  }

  values () {
    return this[LRU_LIST].toArray().map(k => k.value)
  }

  reset () {
    if (this[DISPOSE] &&
        this[LRU_LIST] &&
        this[LRU_LIST].length) {
      this[LRU_LIST].forEach(hit => this[DISPOSE](hit.key, hit.value));
    }

    this[CACHE] = new Map(); // hash of items by key
    this[LRU_LIST] = new Yallist(); // list of items in order of use recency
    this[LENGTH] = 0; // length of items in the list
  }

  dump () {
    return this[LRU_LIST].map(hit =>
      isStale(this, hit) ? false : {
        k: hit.key,
        v: hit.value,
        e: hit.now + (hit.maxAge || 0)
      }).toArray().filter(h => h)
  }

  dumpLru () {
    return this[LRU_LIST]
  }

  set (key, value, maxAge) {
    maxAge = maxAge || this[MAX_AGE];

    if (maxAge && typeof maxAge !== 'number')
      throw new TypeError('maxAge must be a number')

    const now = maxAge ? Date.now() : 0;
    const len = this[LENGTH_CALCULATOR](value, key);

    if (this[CACHE].has(key)) {
      if (len > this[MAX]) {
        del(this, this[CACHE].get(key));
        return false
      }

      const node = this[CACHE].get(key);
      const item = node.value;

      // dispose of the old one before overwriting
      // split out into 2 ifs for better coverage tracking
      if (this[DISPOSE]) {
        if (!this[NO_DISPOSE_ON_SET])
          this[DISPOSE](key, item.value);
      }

      item.now = now;
      item.maxAge = maxAge;
      item.value = value;
      this[LENGTH] += len - item.length;
      item.length = len;
      this.get(key);
      trim(this);
      return true
    }

    const hit = new Entry(key, value, len, now, maxAge);

    // oversized objects fall out of cache automatically.
    if (hit.length > this[MAX]) {
      if (this[DISPOSE])
        this[DISPOSE](key, value);

      return false
    }

    this[LENGTH] += hit.length;
    this[LRU_LIST].unshift(hit);
    this[CACHE].set(key, this[LRU_LIST].head);
    trim(this);
    return true
  }

  has (key) {
    if (!this[CACHE].has(key)) return false
    const hit = this[CACHE].get(key).value;
    return !isStale(this, hit)
  }

  get (key) {
    return get(this, key, true)
  }

  peek (key) {
    return get(this, key, false)
  }

  pop () {
    const node = this[LRU_LIST].tail;
    if (!node)
      return null

    del(this, node);
    return node.value
  }

  del (key) {
    del(this, this[CACHE].get(key));
  }

  load (arr) {
    // reset the cache
    this.reset();

    const now = Date.now();
    // A previous serialized cache has the most recent items first
    for (let l = arr.length - 1; l >= 0; l--) {
      const hit = arr[l];
      const expiresAt = hit.e || 0;
      if (expiresAt === 0)
        // the item was created without expiration in a non aged cache
        this.set(hit.k, hit.v);
      else {
        const maxAge = expiresAt - now;
        // dont add already expired items
        if (maxAge > 0) {
          this.set(hit.k, hit.v, maxAge);
        }
      }
    }
  }

  prune () {
    this[CACHE].forEach((value, key) => get(this, key, false));
  }
}

const get = (self, key, doUse) => {
  const node = self[CACHE].get(key);
  if (node) {
    const hit = node.value;
    if (isStale(self, hit)) {
      del(self, node);
      if (!self[ALLOW_STALE])
        return undefined
    } else {
      if (doUse) {
        if (self[UPDATE_AGE_ON_GET])
          node.value.now = Date.now();
        self[LRU_LIST].unshiftNode(node);
      }
    }
    return hit.value
  }
};

const isStale = (self, hit) => {
  if (!hit || (!hit.maxAge && !self[MAX_AGE]))
    return false

  const diff = Date.now() - hit.now;
  return hit.maxAge ? diff > hit.maxAge
    : self[MAX_AGE] && (diff > self[MAX_AGE])
};

const trim = self => {
  if (self[LENGTH] > self[MAX]) {
    for (let walker = self[LRU_LIST].tail;
      self[LENGTH] > self[MAX] && walker !== null;) {
      // We know that we're about to delete this one, and also
      // what the next least recently used key will be, so just
      // go ahead and set it now.
      const prev = walker.prev;
      del(self, walker);
      walker = prev;
    }
  }
};

const del = (self, node) => {
  if (node) {
    const hit = node.value;
    if (self[DISPOSE])
      self[DISPOSE](hit.key, hit.value);

    self[LENGTH] -= hit.length;
    self[CACHE].delete(hit.key);
    self[LRU_LIST].removeNode(node);
  }
};

class Entry {
  constructor (key, value, length, now, maxAge) {
    this.key = key;
    this.value = value;
    this.length = length;
    this.now = now;
    this.maxAge = maxAge || 0;
  }
}

const forEachStep = (self, fn, node, thisp) => {
  let hit = node.value;
  if (isStale(self, hit)) {
    del(self, node);
    if (!self[ALLOW_STALE])
      hit = undefined;
  }
  if (hit)
    fn.call(thisp, hit.value, hit.key, self);
};

var lruCache = LRUCache;

var LRU = lruCache;

function createCache(size = 500) {
  return new LRU(size);
}

function isRelativeUrl(url) {
  const firstChar = url.charAt(0);
  return firstChar === "." || firstChar === "~" || firstChar === "@";
}
const externalRE = /^(https?:)?\/\//;
function isExternalUrl(url) {
  return externalRE.test(url);
}
const dataUrlRE = /^\s*data:/i;
function isDataUrl(url) {
  return dataUrlRE.test(url);
}
function parseUrl(url) {
  const firstChar = url.charAt(0);
  if (firstChar === "~") {
    const secondChar = url.charAt(1);
    url = url.slice(secondChar === "/" ? 2 : 1);
  }
  return parseUriParts(url);
}
function parseUriParts(urlString) {
  return url.parse(shared.isString(urlString) ? urlString : "", false, true);
}

const defaultAssetUrlOptions = {
  base: null,
  includeAbsolute: false,
  tags: {
    video: ["src", "poster"],
    source: ["src"],
    img: ["src"],
    image: ["xlink:href", "href"],
    use: ["xlink:href", "href"]
  }
};
const normalizeOptions = (options) => {
  if (Object.keys(options).some((key) => shared.isArray(options[key]))) {
    return {
      ...defaultAssetUrlOptions,
      tags: options
    };
  }
  return {
    ...defaultAssetUrlOptions,
    ...options
  };
};
const createAssetUrlTransformWithOptions = (options) => {
  return (node, context) => transformAssetUrl(node, context, options);
};
const transformAssetUrl = (node, context, options = defaultAssetUrlOptions) => {
  if (node.type === 1) {
    if (!node.props.length) {
      return;
    }
    const tags = options.tags || defaultAssetUrlOptions.tags;
    const attrs = tags[node.tag];
    const wildCardAttrs = tags["*"];
    if (!attrs && !wildCardAttrs) {
      return;
    }
    const assetAttrs = (attrs || []).concat(wildCardAttrs || []);
    node.props.forEach((attr, index) => {
      if (attr.type !== 6 || !assetAttrs.includes(attr.name) || !attr.value || isExternalUrl(attr.value.content) || isDataUrl(attr.value.content) || attr.value.content[0] === "#" || !options.includeAbsolute && !isRelativeUrl(attr.value.content)) {
        return;
      }
      const url = parseUrl(attr.value.content);
      if (options.base && attr.value.content[0] === ".") {
        const base = parseUrl(options.base);
        const protocol = base.protocol || "";
        const host = base.host ? protocol + "//" + base.host : "";
        const basePath = base.path || "/";
        attr.value.content = host + (path$2.posix || path$2).join(basePath, url.path + (url.hash || ""));
        return;
      }
      const exp = getImportsExpressionExp(url.path, url.hash, attr.loc, context);
      node.props[index] = {
        type: 7,
        name: "bind",
        arg: compilerCore.createSimpleExpression(attr.name, true, attr.loc),
        exp,
        modifiers: [],
        loc: attr.loc
      };
    });
  }
};
function getImportsExpressionExp(path2, hash, loc, context) {
  if (path2) {
    let name;
    let exp;
    const existingIndex = context.imports.findIndex((i) => i.path === path2);
    if (existingIndex > -1) {
      name = `_imports_${existingIndex}`;
      exp = context.imports[existingIndex].exp;
    } else {
      name = `_imports_${context.imports.length}`;
      exp = compilerCore.createSimpleExpression(
        name,
        false,
        loc,
        3
      );
      context.imports.push({ exp, path: path2 });
    }
    if (!hash) {
      return exp;
    }
    const hashExp = `${name} + '${hash}'`;
    const finalExp = compilerCore.createSimpleExpression(
      hashExp,
      false,
      loc,
      3
    );
    if (!context.hoistStatic) {
      return finalExp;
    }
    const existingHoistIndex = context.hoists.findIndex((h) => {
      return h && h.type === 4 && !h.isStatic && h.content === hashExp;
    });
    if (existingHoistIndex > -1) {
      return compilerCore.createSimpleExpression(
        `_hoisted_${existingHoistIndex + 1}`,
        false,
        loc,
        3
      );
    }
    return context.hoist(finalExp);
  } else {
    return compilerCore.createSimpleExpression(`''`, false, loc, 3);
  }
}

const srcsetTags = ["img", "source"];
const escapedSpaceCharacters = /( |\\t|\\n|\\f|\\r)+/g;
const createSrcsetTransformWithOptions = (options) => {
  return (node, context) => transformSrcset(node, context, options);
};
const transformSrcset = (node, context, options = defaultAssetUrlOptions) => {
  if (node.type === 1) {
    if (srcsetTags.includes(node.tag) && node.props.length) {
      node.props.forEach((attr, index) => {
        if (attr.name === "srcset" && attr.type === 6) {
          if (!attr.value)
            return;
          const value = attr.value.content;
          if (!value)
            return;
          const imageCandidates = value.split(",").map((s) => {
            const [url, descriptor] = s.replace(escapedSpaceCharacters, " ").trim().split(" ", 2);
            return { url, descriptor };
          });
          for (let i = 0; i < imageCandidates.length; i++) {
            const { url } = imageCandidates[i];
            if (isDataUrl(url)) {
              imageCandidates[i + 1].url = url + "," + imageCandidates[i + 1].url;
              imageCandidates.splice(i, 1);
            }
          }
          const shouldProcessUrl = (url) => {
            return !isExternalUrl(url) && !isDataUrl(url) && (options.includeAbsolute || isRelativeUrl(url));
          };
          if (!imageCandidates.some(({ url }) => shouldProcessUrl(url))) {
            return;
          }
          if (options.base) {
            const base = options.base;
            const set = [];
            let needImportTransform = false;
            imageCandidates.forEach((candidate) => {
              let { url, descriptor } = candidate;
              descriptor = descriptor ? ` ${descriptor}` : ``;
              if (url[0] === ".") {
                candidate.url = (path$2.posix || path$2).join(base, url);
                set.push(candidate.url + descriptor);
              } else if (shouldProcessUrl(url)) {
                needImportTransform = true;
              } else {
                set.push(url + descriptor);
              }
            });
            if (!needImportTransform) {
              attr.value.content = set.join(", ");
              return;
            }
          }
          const compoundExpression = compilerCore.createCompoundExpression([], attr.loc);
          imageCandidates.forEach(({ url, descriptor }, index2) => {
            if (shouldProcessUrl(url)) {
              const { path: path2 } = parseUrl(url);
              let exp2;
              if (path2) {
                const existingImportsIndex = context.imports.findIndex(
                  (i) => i.path === path2
                );
                if (existingImportsIndex > -1) {
                  exp2 = compilerCore.createSimpleExpression(
                    `_imports_${existingImportsIndex}`,
                    false,
                    attr.loc,
                    3
                  );
                } else {
                  exp2 = compilerCore.createSimpleExpression(
                    `_imports_${context.imports.length}`,
                    false,
                    attr.loc,
                    3
                  );
                  context.imports.push({ exp: exp2, path: path2 });
                }
                compoundExpression.children.push(exp2);
              }
            } else {
              const exp2 = compilerCore.createSimpleExpression(
                `"${url}"`,
                false,
                attr.loc,
                3
              );
              compoundExpression.children.push(exp2);
            }
            const isNotLast = imageCandidates.length - 1 > index2;
            if (descriptor && isNotLast) {
              compoundExpression.children.push(` + ' ${descriptor}, ' + `);
            } else if (descriptor) {
              compoundExpression.children.push(` + ' ${descriptor}'`);
            } else if (isNotLast) {
              compoundExpression.children.push(` + ', ' + `);
            }
          });
          let exp = compoundExpression;
          if (context.hoistStatic) {
            exp = context.hoist(compoundExpression);
            exp.constType = 3;
          }
          node.props[index] = {
            type: 7,
            name: "bind",
            arg: compilerCore.createSimpleExpression("srcset", true, attr.loc),
            exp,
            modifiers: [],
            loc: attr.loc
          };
        }
      });
    }
  }
};

var consolidateExports$1 = {};
var consolidate$2 = {
  get exports(){ return consolidateExports$1; },
  set exports(v){ consolidateExports$1 = v; },
};

function commonjsRequire(path) {
	throw new Error('Could not dynamically require "' + path + '". Please configure the dynamicRequireTargets or/and ignoreDynamicRequires option of @rollup/plugin-commonjs appropriately for this require call to work.');
}

var consolidateExports = {};
var consolidate$1 = {
  get exports(){ return consolidateExports; },
  set exports(v){ consolidateExports = v; },
};

(function (module, exports) {
	/*
	 * Engines which do not support caching of their file contents
	 * should use the `read()` function defined in consolidate.js
	 * On top of this, when an engine compiles to a `Function`,
	 * these functions should either be cached within consolidate.js
	 * or the engine itself via `options.cache`. This will allow
	 * users and frameworks to pass `options.cache = true` for
	 * `NODE_ENV=production`, however edit the file(s) without
	 * re-loading the application in development.
	 */

	/**
	 * Module dependencies.
	 */

	var fs = require$$0;
	var path = path$2;
	var util = require$$2;

	var join = path.join;
	var resolve = path.resolve;
	var extname = path.extname;
	var dirname = path.dirname;
	var isAbsolute = path.isAbsolute;

	var readCache = {};

	/**
	 * Require cache.
	 */

	var cacheStore = {};

	/**
	 * Require cache.
	 */

	var requires = {};

	/**
	 * Clear the cache.
	 *
	 * @api public
	 */

	exports.clearCache = function() {
	  readCache = {};
	  cacheStore = {};
	};

	/**
	 * Conditionally cache `compiled` template based
	 * on the `options` filename and `.cache` boolean.
	 *
	 * @param {Object} options
	 * @param {Function} compiled
	 * @return {Function}
	 * @api private
	 */

	function cache(options, compiled) {
	  // cachable
	  if (compiled && options.filename && options.cache) {
	    delete readCache[options.filename];
	    cacheStore[options.filename] = compiled;
	    return compiled;
	  }

	  // check cache
	  if (options.filename && options.cache) {
	    return cacheStore[options.filename];
	  }

	  return compiled;
	}

	/**
	 * Read `path` with `options` with
	 * callback `(err, str)`. When `options.cache`
	 * is true the template string will be cached.
	 *
	 * @param {String} options
	 * @param {Function} cb
	 * @api private
	 */

	function read(path, options, cb) {
	  var str = readCache[path];
	  var cached = options.cache && str && typeof str === 'string';

	  // cached (only if cached is a string and not a compiled template function)
	  if (cached) return cb(null, str);

	  // read
	  fs.readFile(path, 'utf8', function(err, str) {
	    if (err) return cb(err);
	    // remove extraneous utf8 BOM marker
	    str = str.replace(/^\uFEFF/, '');
	    if (options.cache) readCache[path] = str;
	    cb(null, str);
	  });
	}

	/**
	 * Read `path` with `options` with
	 * callback `(err, str)`. When `options.cache`
	 * is true the partial string will be cached.
	 *
	 * @param {String} options
	 * @param {Function} fn
	 * @api private
	 */

	function readPartials(path, options, cb) {
	  if (!options.partials) return cb();
	  var keys = Object.keys(options.partials);
	  var partials = {};

	  function next(index) {
	    if (index === keys.length) return cb(null, partials);
	    var key = keys[index];
	    var partialPath = options.partials[key];

	    if (partialPath === undefined || partialPath === null || partialPath === false) {
	      return next(++index);
	    }

	    var file;
	    if (isAbsolute(partialPath)) {
	      if (extname(partialPath) !== '') {
	        file = partialPath;
	      } else {
	        file = join(partialPath + extname(path));
	      }
	    } else {
	      file = join(dirname(path), partialPath + extname(path));
	    }

	    read(file, options, function(err, str) {
	      if (err) return cb(err);
	      partials[key] = str;
	      next(++index);
	    });
	  }

	  next(0);
	}

	/**
	 * promisify
	 */
	function promisify(cb, fn) {
	  return new Promise(function(resolve, reject) {
	    cb = cb || function(err, html) {
	      if (err) {
	        return reject(err);
	      }
	      resolve(html);
	    };
	    fn(cb);
	  });
	}

	/**
	 * fromStringRenderer
	 */

	function fromStringRenderer(name) {
	  return function(path, options, cb) {
	    options.filename = path;

	    return promisify(cb, function(cb) {
	      readPartials(path, options, function(err, partials) {
	        var extend = (requires.extend || (requires.extend = require$$2._extend));
	        var opts = extend({}, options);
	        opts.partials = partials;
	        if (err) return cb(err);
	        if (cache(opts)) {
	          exports[name].render('', opts, cb);
	        } else {
	          read(path, opts, function(err, str) {
	            if (err) return cb(err);
	            exports[name].render(str, opts, cb);
	          });
	        }
	      });
	    });
	  };
	}

	/**
	 * velocity support.
	 */

	exports.velocityjs = fromStringRenderer('velocityjs');

	/**
	 * velocity string support.
	 */

	exports.velocityjs.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.velocityjs || (requires.velocityjs = require('velocityjs'));
	    try {
	      options.locals = options;
	      cb(null, engine.render(str, options).trimLeft());
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * Liquid support.
	 */

	exports.liquid = fromStringRenderer('liquid');

	/**
	 * Liquid string support.
	 */

	/**
	 * Note that in order to get filters and custom tags we've had to push
	 * all user-defined locals down into @locals. However, just to make things
	 * backwards-compatible, any property of `options` that is left after
	 * processing and removing `locals`, `meta`, `filters`, `customTags` and
	 * `includeDir` will also become a local.
	 */

	function _renderTinyliquid(engine, str, options, cb) {
	  var context = engine.newContext();
	  var k;

	  /**
	   * Note that there's a bug in the library that doesn't allow us to pass
	   * the locals to newContext(), hence looping through the keys:
	   */

	  if (options.locals) {
	    for (k in options.locals) {
	      context.setLocals(k, options.locals[k]);
	    }
	    delete options.locals;
	  }

	  if (options.meta) {
	    context.setLocals('page', options.meta);
	    delete options.meta;
	  }

	  /**
	   * Add any defined filters:
	   */

	  if (options.filters) {
	    for (k in options.filters) {
	      context.setFilter(k, options.filters[k]);
	    }
	    delete options.filters;
	  }

	  /**
	   * Set up a callback for the include directory:
	   */

	  var includeDir = options.includeDir || process.cwd();

	  context.onInclude(function(name, callback) {
	    var extname = path.extname(name) ? '' : '.liquid';
	    var filename = path.resolve(includeDir, name + extname);

	    fs.readFile(filename, {encoding: 'utf8'}, function(err, data) {
	      if (err) return callback(err);
	      callback(null, engine.parse(data));
	    });
	  });
	  delete options.includeDir;

	  /**
	   * The custom tag functions need to have their results pushed back
	   * through the parser, so set up a shim before calling the provided
	   * callback:
	   */

	  var compileOptions = {
	    customTags: {}
	  };

	  if (options.customTags) {
	    var tagFunctions = options.customTags;

	    for (k in options.customTags) {
	      /*Tell jshint there's no problem with having this function in the loop */
	      /*jshint -W083 */
	      compileOptions.customTags[k] = function(context, name, body) {
	        var tpl = tagFunctions[name](body.trim());
	        context.astStack.push(engine.parse(tpl));
	      };
	      /*jshint +W083 */
	    }
	    delete options.customTags;
	  }

	  /**
	   * Now anything left in `options` becomes a local:
	   */

	  for (k in options) {
	    context.setLocals(k, options[k]);
	  }

	  /**
	   * Finally, execute the template:
	   */

	  var tmpl = cache(context) || cache(context, engine.compile(str, compileOptions));
	  tmpl(context, cb);
	}

	exports.liquid.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.liquid;
	    var Liquid;

	    try {
	      // set up tinyliquid engine
	      engine = requires.liquid = require('tinyliquid');

	      // use tinyliquid engine
	      _renderTinyliquid(engine, str, options, cb);

	      return;

	    } catch (err) {

	      // set up liquid-node engine
	      try {
	        Liquid = requires.liquid = require('liquid-node');
	        engine = new Liquid.Engine();
	      } catch (err) {
	        throw err;
	      }

	    }

	    // use liquid-node engine
	    try {
	      var locals = options.locals || {};

	      if (options.meta) {
	        locals.pages = options.meta;
	        delete options.meta;
	      }

	      /**
	       * Add any defined filters:
	       */

	      if (options.filters) {
	        engine.registerFilters(options.filters);
	        delete options.filters;
	      }

	      /**
	       * Set up a callback for the include directory:
	       */

	      var includeDir = options.includeDir || process.cwd();
	      engine.fileSystem = new Liquid.LocalFileSystem(includeDir, 'liquid');
	      delete options.includeDir;

	      /**
	       * The custom tag functions need to have their results pushed back
	       * through the parser, so set up a shim before calling the provided
	       * callback:
	       */

	      if (options.customTags) {
	        var tagFunctions = options.customTags;

	        for (k in options.customTags) {
	          engine.registerTag(k, tagFunctions[k]);
	        }
	        delete options.customTags;
	      }

	      /**
	       * Now anything left in `options` becomes a local:
	       */

	      for (var k in options) {
	        locals[k] = options[k];
	      }

	      /**
	       * Finally, execute the template:
	       */

	      return engine
	        .parseAndRender(str, locals)
	        .nodeify(function(err, result) {
	          if (err) {
	            throw new Error(err);
	          } else {
	            return cb(null, result);
	          }
	        });

	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * Jade support.
	 */

	exports.jade = function(path, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.jade;
	    if (!engine) {
	      try {
	        engine = requires.jade = require('jade');
	      } catch (err) {
	        try {
	          engine = requires.jade = require('then-jade');
	        } catch (otherError) {
	          throw err;
	        }
	      }
	    }

	    try {
	      var tmpl = cache(options) || cache(options, engine.compileFile(path, options));
	      cb(null, tmpl(options));
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * Jade string support.
	 */

	exports.jade.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.jade;
	    if (!engine) {
	      try {
	        engine = requires.jade = require('jade');
	      } catch (err) {
	        try {
	          engine = requires.jade = require('then-jade');
	        } catch (otherError) {
	          throw err;
	        }
	      }
	    }

	    try {
	      var tmpl = cache(options) || cache(options, engine.compile(str, options));
	      cb(null, tmpl(options));
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * Dust support.
	 */

	exports.dust = fromStringRenderer('dust');

	/**
	 * Dust string support.
	 */

	exports.dust.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.dust;
	    if (!engine) {
	      try {
	        engine = requires.dust = require('dust');
	      } catch (err) {
	        try {
	          engine = requires.dust = require('dustjs-helpers');
	        } catch (err) {
	          engine = requires.dust = require('dustjs-linkedin');
	        }
	      }
	    }

	    var ext = 'dust';
	    var views = '.';

	    if (options) {
	      if (options.ext) ext = options.ext;
	      if (options.views) views = options.views;
	      if (options.settings && options.settings.views) views = options.settings.views;
	    }
	    if (!options || (options && !options.cache)) engine.cache = {};

	    engine.onLoad = function(path, callback) {
	      if (extname(path) === '') path += '.' + ext;
	      if (path[0] !== '/') path = views + '/' + path;
	      read(path, options, callback);
	    };

	    try {
	      var templateName;
	      if (options.filename) {
	        templateName = options.filename.replace(new RegExp('^' + views + '/'), '').replace(new RegExp('\\.' + ext), '');
	      }

	      var tmpl = cache(options) || cache(options, engine.compileFn(str, templateName));
	      tmpl(options, cb);
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * Swig support.
	 */

	exports.swig = fromStringRenderer('swig');

	/**
	 * Swig string support.
	 */

	exports.swig.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.swig;
	    if (!engine) {
	      try {
	        engine = requires.swig = require('swig');
	      } catch (err) {
	        try {
	          engine = requires.swig = require('swig-templates');
	        } catch (otherError) {
	          throw err;
	        }
	      }
	    }

	    try {
	      if (options.cache === true) options.cache = 'memory';
	      engine.setDefaults({ cache: options.cache });
	      var tmpl = cache(options) || cache(options, engine.compile(str, options));
	      cb(null, tmpl(options));
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * Razor support.
	 */

	exports.razor = function(path, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.razor;
	    if (!engine) {
	      try {
	        engine = requires.razor = require('razor-tmpl');

	      } catch (err) {

	        throw err;

	      }
	    }
	    try {

	      var tmpl = cache(options) || cache(options, (locals) => {
	        console.log('Rendering razor file', path);
	        return engine.renderFileSync(path, locals);
	      });
	      cb(null, tmpl(options));
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * razor string support.
	 */

	exports.razor.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {

	    try {
	      var engine = requires.razor = require('razor-tmpl');
	    } catch (err) {
	      throw err;
	    }

	    try {
	      var tf = engine.compile(str);
	      var tmpl = cache(options) || cache(options, tf);
	      cb(null, tmpl(options));
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * Atpl support.
	 */

	exports.atpl = fromStringRenderer('atpl');

	/**
	 * Atpl string support.
	 */

	exports.atpl.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.atpl || (requires.atpl = require('atpl'));
	    try {
	      var tmpl = cache(options) || cache(options, engine.compile(str, options));
	      cb(null, tmpl(options));
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * Liquor support,
	 */

	exports.liquor = fromStringRenderer('liquor');

	/**
	 * Liquor string support.
	 */

	exports.liquor.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.liquor || (requires.liquor = require('liquor'));
	    try {
	      var tmpl = cache(options) || cache(options, engine.compile(str, options));
	      cb(null, tmpl(options));
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * Twig support.
	 */

	exports.twig = fromStringRenderer('twig');

	/**
	 * Twig string support.
	 */

	exports.twig.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.twig || (requires.twig = require('twig').twig);
	    var templateData = {
	      data: str,
	      allowInlineIncludes: options.allowInlineIncludes,
	      namespaces: options.namespaces,
	      path: options.path
	    };
	    try {
	      var tmpl = cache(templateData) || cache(templateData, engine(templateData));
	      cb(null, tmpl.render(options));
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * EJS support.
	 */

	exports.ejs = fromStringRenderer('ejs');

	/**
	 * EJS string support.
	 */

	exports.ejs.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.ejs || (requires.ejs = require('ejs'));
	    try {
	      var tmpl = cache(options) || cache(options, engine.compile(str, options));
	      cb(null, tmpl(options));
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * Eco support.
	 */

	exports.eco = fromStringRenderer('eco');

	/**
	 * Eco string support.
	 */

	exports.eco.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.eco || (requires.eco = require('eco'));
	    try {
	      cb(null, engine.render(str, options));
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * Jazz support.
	 */

	exports.jazz = fromStringRenderer('jazz');

	/**
	 * Jazz string support.
	 */

	exports.jazz.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.jazz || (requires.jazz = require('jazz'));
	    try {
	      var tmpl = cache(options) || cache(options, engine.compile(str, options));
	      tmpl.eval(options, function(str) {
	        cb(null, str);
	      });
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * JQTPL support.
	 */

	exports.jqtpl = fromStringRenderer('jqtpl');

	/**
	 * JQTPL string support.
	 */

	exports.jqtpl.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.jqtpl || (requires.jqtpl = require('jqtpl'));
	    try {
	      engine.template(str, str);
	      cb(null, engine.tmpl(str, options));
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * Haml support.
	 */

	exports.haml = fromStringRenderer('haml');

	/**
	 * Haml string support.
	 */

	exports.haml.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.haml || (requires.haml = require('hamljs'));
	    try {
	      options.locals = options;
	      cb(null, engine.render(str, options).trimLeft());
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * Hamlet support.
	 */

	exports.hamlet = fromStringRenderer('hamlet');

	/**
	 * Hamlet string support.
	 */

	exports.hamlet.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.hamlet || (requires.hamlet = require('hamlet'));
	    try {
	      options.locals = options;
	      cb(null, engine.render(str, options).trimLeft());
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * Whiskers support.
	 */

	exports.whiskers = function(path, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.whiskers || (requires.whiskers = require('whiskers'));
	    engine.__express(path, options, cb);
	  });
	};

	/**
	 * Whiskers string support.
	 */

	exports.whiskers.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.whiskers || (requires.whiskers = require('whiskers'));
	    try {
	      cb(null, engine.render(str, options));
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * Coffee-HAML support.
	 */

	exports['haml-coffee'] = fromStringRenderer('haml-coffee');

	/**
	 * Coffee-HAML string support.
	 */

	exports['haml-coffee'].render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires['haml-coffee'] || (requires['haml-coffee'] = require('haml-coffee'));
	    try {
	      var tmpl = cache(options) || cache(options, engine.compile(str, options));
	      cb(null, tmpl(options));
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * Hogan support.
	 */

	exports.hogan = fromStringRenderer('hogan');

	/**
	 * Hogan string support.
	 */

	exports.hogan.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.hogan || (requires.hogan = require('hogan.js'));
	    try {
	      var tmpl = cache(options) || cache(options, engine.compile(str, options));
	      cb(null, tmpl.render(options, options.partials));
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * templayed.js support.
	 */

	exports.templayed = fromStringRenderer('templayed');

	/**
	 * templayed.js string support.
	 */

	exports.templayed.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.templayed || (requires.templayed = require('templayed'));
	    try {
	      var tmpl = cache(options) || cache(options, engine(str));
	      cb(null, tmpl(options));
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * Handlebars support.
	 */

	exports.handlebars = fromStringRenderer('handlebars');

	/**
	 * Handlebars string support.
	 */

	exports.handlebars.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.handlebars || (requires.handlebars = require('handlebars'));
	    try {
	      for (var partial in options.partials) {
	        engine.registerPartial(partial, options.partials[partial]);
	      }
	      for (var helper in options.helpers) {
	        engine.registerHelper(helper, options.helpers[helper]);
	      }
	      var tmpl = cache(options) || cache(options, engine.compile(str, options));
	      cb(null, tmpl(options));
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * Underscore support.
	 */

	exports.underscore = fromStringRenderer('underscore');

	/**
	 * Underscore string support.
	 */

	exports.underscore.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.underscore || (requires.underscore = require('underscore'));
	    try {
	      const partials = {};
	      for (var partial in options.partials) {
	        partials[partial] = engine.template(options.partials[partial]);
	      }
	      options.partials = partials;
	      var tmpl = cache(options) || cache(options, engine.template(str, null, options));
	      cb(null, tmpl(options).replace(/\n$/, ''));
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * Lodash support.
	 */

	exports.lodash = fromStringRenderer('lodash');

	/**
	 * Lodash string support.
	 */

	exports.lodash.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.lodash || (requires.lodash = require('lodash'));
	    try {
	      var tmpl = cache(options) || cache(options, engine.template(str, options));
	      cb(null, tmpl(options).replace(/\n$/, ''));
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * Pug support. (formerly Jade)
	 */

	exports.pug = function(path, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.pug;
	    if (!engine) {
	      try {
	        engine = requires.pug = require('pug');
	      } catch (err) {
	        try {
	          engine = requires.pug = require('then-pug');
	        } catch (otherError) {
	          throw err;
	        }
	      }
	    }

	    try {
	      var tmpl = cache(options) || cache(options, engine.compileFile(path, options));
	      cb(null, tmpl(options));
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * Pug string support.
	 */

	exports.pug.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.pug;
	    if (!engine) {
	      try {
	        engine = requires.pug = require('pug');
	      } catch (err) {
	        try {
	          engine = requires.pug = require('then-pug');
	        } catch (otherError) {
	          throw err;
	        }
	      }
	    }

	    try {
	      var tmpl = cache(options) || cache(options, engine.compile(str, options));
	      cb(null, tmpl(options));
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * QEJS support.
	 */

	exports.qejs = fromStringRenderer('qejs');

	/**
	 * QEJS string support.
	 */

	exports.qejs.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    try {
	      var engine = requires.qejs || (requires.qejs = require('qejs'));
	      engine.render(str, options).then(function(result) {
	        cb(null, result);
	      }, function(err) {
	        cb(err);
	      }).done();
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * Walrus support.
	 */

	exports.walrus = fromStringRenderer('walrus');

	/**
	 * Walrus string support.
	 */

	exports.walrus.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.walrus || (requires.walrus = require('walrus'));
	    try {
	      var tmpl = cache(options) || cache(options, engine.parse(str));
	      cb(null, tmpl.compile(options));
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * Mustache support.
	 */

	exports.mustache = fromStringRenderer('mustache');

	/**
	 * Mustache string support.
	 */

	exports.mustache.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.mustache || (requires.mustache = require('mustache'));
	    try {
	      cb(null, engine.render(str, options, options.partials));
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * Just support.
	 */

	exports.just = function(path, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.just;
	    if (!engine) {
	      var JUST = require('just');
	      engine = requires.just = new JUST();
	    }
	    engine.configure({ useCache: options.cache });
	    engine.render(path, options, cb);
	  });
	};

	/**
	 * Just string support.
	 */

	exports.just.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var JUST = require('just');
	    var engine = new JUST({ root: { page: str }});
	    engine.render('page', options, cb);
	  });
	};

	/**
	 * ECT support.
	 */

	exports.ect = function(path, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.ect;
	    if (!engine) {
	      var ECT = require('ect');
	      engine = requires.ect = new ECT(options);
	    }
	    engine.configure({ cache: options.cache });
	    engine.render(path, options, cb);
	  });
	};

	/**
	 * ECT string support.
	 */

	exports.ect.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var ECT = require('ect');
	    var engine = new ECT({ root: { page: str }});
	    engine.render('page', options, cb);
	  });
	};

	/**
	 * mote support.
	 */

	exports.mote = fromStringRenderer('mote');

	/**
	 * mote string support.
	 */

	exports.mote.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.mote || (requires.mote = require('mote'));
	    try {
	      var tmpl = cache(options) || cache(options, engine.compile(str));
	      cb(null, tmpl(options));
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * Toffee support.
	 */

	exports.toffee = function(path, options, cb) {
	  return promisify(cb, function(cb) {
	    var toffee = requires.toffee || (requires.toffee = require('toffee'));
	    toffee.__consolidate_engine_render(path, options, cb);
	  });
	};

	/**
	 * Toffee string support.
	 */

	exports.toffee.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.toffee || (requires.toffee = require('toffee'));
	    try {
	      engine.str_render(str, options, cb);
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * doT support.
	 */

	exports.dot = fromStringRenderer('dot');

	/**
	 * doT string support.
	 */

	exports.dot.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.dot || (requires.dot = require('dot'));
	    var extend = (requires.extend || (requires.extend = require$$2._extend));
	    try {
	      var settings = {};
	      settings = extend(settings, engine.templateSettings);
	      settings = extend(settings, options ? options.dot : {});
	      var tmpl = cache(options) || cache(options, engine.template(str, settings, options));
	      cb(null, tmpl(options));
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * bracket support.
	 */

	exports.bracket = fromStringRenderer('bracket');

	/**
	 * bracket string support.
	 */

	exports.bracket.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.bracket || (requires.bracket = require('bracket-template'));
	    try {
	      var tmpl = cache(options) || cache(options, engine.default.compile(str, options));
	      cb(null, tmpl(options));
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * Ractive support.
	 */

	exports.ractive = fromStringRenderer('ractive');

	/**
	 * Ractive string support.
	 */

	exports.ractive.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var Engine = requires.ractive || (requires.ractive = require('ractive'));

	    var template = cache(options) || cache(options, Engine.parse(str));
	    options.template = template;

	    if (options.data === null || options.data === undefined) {
	      var extend = (requires.extend || (requires.extend = require$$2._extend));

	      // Shallow clone the options object
	      options.data = extend({}, options);

	      // Remove consolidate-specific properties from the clone
	      var i;
	      var length;
	      var properties = ['template', 'filename', 'cache', 'partials'];
	      for (i = 0, length = properties.length; i < length; i++) {
	        var property = properties[i];
	        delete options.data[property];
	      }
	    }

	    try {
	      cb(null, new Engine(options).toHTML());
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * Nunjucks support.
	 */

	exports.nunjucks = fromStringRenderer('nunjucks');

	/**
	 * Nunjucks string support.
	 */

	exports.nunjucks.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {

	    try {

	      var engine = options.nunjucksEnv || requires.nunjucks || (requires.nunjucks = require('nunjucks'));

	      var env = engine;

	      // deprecated fallback support for express
	      // <https://github.com/tj/consolidate.js/pull/152>
	      // <https://github.com/tj/consolidate.js/pull/224>
	      if (options.settings && options.settings.views) {
	        env = engine.configure(options.settings.views);
	      } else if (options.nunjucks && options.nunjucks.configure) {
	        env = engine.configure.apply(engine, options.nunjucks.configure);
	      }

	      //
	      // because `renderString` does not initiate loaders
	      // we must manually create a loader for it based off
	      // either `options.settings.views` or `options.nunjucks` or `options.nunjucks.root`
	      //
	      // <https://github.com/mozilla/nunjucks/issues/730>
	      // <https://github.com/crocodilejs/node-email-templates/issues/182>
	      //

	      // so instead we simply check if we passed a custom loader
	      // otherwise we create a simple file based loader
	      if (options.loader) {
	        env = new engine.Environment(options.loader);
	      } else if (options.settings && options.settings.views) {
	        env = new engine.Environment(
	          new engine.FileSystemLoader(options.settings.views)
	        );
	      } else if (options.nunjucks && options.nunjucks.loader) {
	        if (typeof options.nunjucks.loader === 'string') {
	          env = new engine.Environment(new engine.FileSystemLoader(options.nunjucks.loader));
	        } else {
	          env = new engine.Environment(
	            new engine.FileSystemLoader(
	              options.nunjucks.loader[0],
	              options.nunjucks.loader[1]
	            )
	          );
	        }
	      }

	      env.renderString(str, options, cb);
	    } catch (err) {
	      throw cb(err);
	    }
	  });
	};

	/**
	 * HTMLing support.
	 */

	exports.htmling = fromStringRenderer('htmling');

	/**
	 * HTMLing string support.
	 */

	exports.htmling.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.htmling || (requires.htmling = require('htmling'));
	    try {
	      var tmpl = cache(options) || cache(options, engine.string(str));
	      cb(null, tmpl.render(options));
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 *  Rendering function
	 */
	function requireReact(module, filename) {
	  var babel = requires.babel || (requires.babel = require('babel-core'));

	  var compiled = babel.transformFileSync(filename, { presets: [ 'react' ] }).code;

	  return module._compile(compiled, filename);
	}

	exports.requireReact = requireReact;

	/**
	 *  Converting a string into a node module.
	 */
	function requireReactString(src, filename) {
	  var babel = requires.babel || (requires.babel = require('babel-core'));

	  if (!filename) filename = '';
	  var m = new module.constructor();
	  filename = filename || '';

	  // Compile Using React
	  var compiled = babel.transform(src, { presets: [ 'react' ] }).code;

	  // Compile as a module
	  m.paths = module.paths;
	  m._compile(compiled, filename);

	  return m.exports;
	}

	/**
	 * A naive helper to replace {{tags}} with options.tags content
	 */
	function reactBaseTmpl(data, options) {

	  var exp;
	  var regex;

	  // Iterates through the keys in file object
	  // and interpolate / replace {{key}} with it's value
	  for (var k in options) {
	    if (options.hasOwnProperty(k)) {
	      exp = '{{' + k + '}}';
	      regex = new RegExp(exp, 'g');
	      if (data.match(regex)) {
	        data = data.replace(regex, options[k]);
	      }
	    }
	  }

	  return data;
	}

	/**
	* Plates Support.
	*/

	exports.plates = fromStringRenderer('plates');

	/**
	* Plates string support.
	*/

	exports.plates.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.plates || (requires.plates = require('plates'));
	    var map = options.map || undefined;
	    try {
	      var tmpl = engine.bind(str, options, map);
	      cb(null, tmpl);
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 *  The main render parser for React bsaed templates
	 */
	function reactRenderer(type) {

	  if (commonjsRequire.extensions) {

	    // Ensure JSX is transformed on require
	    if (!commonjsRequire.extensions['.jsx']) {
	      commonjsRequire.extensions['.jsx'] = requireReact;
	    }

	    // Supporting .react extension as well as test cases
	    // Using .react extension is not recommended.
	    if (!commonjsRequire.extensions['.react']) {
	      commonjsRequire.extensions['.react'] = requireReact;
	    }

	  }

	  // Return rendering fx
	  return function(str, options, cb) {
	    return promisify(cb, function(cb) {
	      // React Import
	      var ReactDOM = requires.ReactDOM || (requires.ReactDOM = require('react-dom/server'));
	      var react = requires.react || (requires.react = require('react'));

	      // Assign HTML Base
	      var base = options.base;
	      delete options.base;

	      var enableCache = options.cache;
	      delete options.cache;

	      var isNonStatic = options.isNonStatic;
	      delete options.isNonStatic;

	      // Start Conversion
	      try {

	        var Code;
	        var Factory;

	        var baseStr;
	        var content;
	        var parsed;

	        if (!cache(options)) {
	          // Parsing
	          if (type === 'path') {
	            var path = resolve(str);
	            delete require.cache[path];
	            Code = commonjsRequire(path);
	          } else {
	            Code = requireReactString(str);
	          }
	          Factory = cache(options, react.createFactory(Code));

	        } else {
	          Factory = cache(options);
	        }

	        parsed = new Factory(options);
	        content = (isNonStatic) ? ReactDOM.renderToString(parsed) : ReactDOM.renderToStaticMarkup(parsed);

	        if (base) {
	          baseStr = readCache[str] || fs.readFileSync(resolve(base), 'utf8');

	          if (enableCache) {
	            readCache[str] = baseStr;
	          }

	          options.content = content;
	          content = reactBaseTmpl(baseStr, options);
	        }

	        cb(null, content);

	      } catch (err) {
	        cb(err);
	      }
	    });
	  };
	}

	/**
	 * React JS Support
	 */
	exports.react = reactRenderer('path');

	/**
	 * React JS string support.
	 */
	exports.react.render = reactRenderer('string');

	/**
	 * ARC-templates support.
	 */

	exports['arc-templates'] = fromStringRenderer('arc-templates');

	/**
	 * ARC-templates string support.
	 */

	exports['arc-templates'].render = function(str, options, cb) {
	  var readFileWithOptions = util.promisify(read);
	  var consolidateFileSystem = {};
	  consolidateFileSystem.readFile = function(path) {
	    return readFileWithOptions(path, options);
	  };

	  return promisify(cb, function(cb) {
	    try {
	      var engine = requires['arc-templates'];
	      if (!engine) {
	        var Engine = require('arc-templates/dist/es5');
	        engine = requires['arc-templates'] = new Engine({ filesystem: consolidateFileSystem });
	      }

	      var compiler = cache(options) || cache(options, engine.compileString(str, options.filename));
	      compiler.then(function(func) { return func(options); })
	        .then(function(result) { cb(null, result.content); })
	        .catch(cb);
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * Vash support
	 */
	exports.vash = fromStringRenderer('vash');

	/**
	 * Vash string support
	 */
	exports.vash.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.vash || (requires.vash = require('vash'));

	    try {
	      // helper system : https://github.com/kirbysayshi/vash#helper-system
	      if (options.helpers) {
	        for (var key in options.helpers) {
	          if (!options.helpers.hasOwnProperty(key) || typeof options.helpers[key] !== 'function') {
	            continue;
	          }
	          engine.helpers[key] = options.helpers[key];
	        }
	      }

	      var tmpl = cache(options) || cache(options, engine.compile(str, options));
	      tmpl(options, function sealLayout(err, ctx) {
	        if (err) cb(err);
	        ctx.finishLayout();
	        cb(null, ctx.toString().replace(/\n$/, ''));
	      });
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * Slm support.
	 */

	exports.slm = fromStringRenderer('slm');

	/**
	 * Slm string support.
	 */

	exports.slm.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.slm || (requires.slm = require('slm'));

	    try {
	      var tmpl = cache(options) || cache(options, engine.compile(str, options));
	      cb(null, tmpl(options));
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * Marko support.
	 */

	exports.marko = function(path, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.marko || (requires.marko = require('marko'));
	    options.writeToDisk = !!options.cache;

	    try {
	      var tmpl = cache(options) || cache(options, engine.load(path, options));
	      tmpl.renderToString(options, cb);
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * Marko string support.
	 */

	exports.marko.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.marko || (requires.marko = require('marko'));
	    options.writeToDisk = !!options.cache;
	    options.filename = options.filename || 'string.marko';

	    try {
	      var tmpl = cache(options) || cache(options, engine.load(options.filename, str, options));
	      tmpl.renderToString(options, cb);
	    } catch (err) {
	      cb(err);
	    }
	  });
	};

	/**
	 * Teacup support.
	 */
	exports.teacup = function(path, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.teacup || (requires.teacup = require('teacup/lib/express'));
	    commonjsRequire.extensions['.teacup'] = commonjsRequire.extensions['.coffee'];
	    if (path[0] !== '/') {
	      path = join(process.cwd(), path);
	    }
	    if (!options.cache) {
	      var callback = cb;
	      cb = function() {
	        delete require.cache[path];
	        callback.apply(this, arguments);
	      };
	    }
	    engine.renderFile(path, options, cb);
	  });
	};

	/**
	 * Teacup string support.
	 */
	exports.teacup.render = function(str, options, cb) {
	  var coffee = require('coffee-script');
	  var vm = require('vm');
	  var sandbox = {
	    module: {exports: {}},
	    require: commonjsRequire
	  };
	  return promisify(cb, function(cb) {
	    vm.runInNewContext(coffee.compile(str), sandbox);
	    var tmpl = sandbox.module.exports;
	    cb(null, tmpl(options));
	  });
	};

	/**
	 * Squirrelly support.
	 */

	exports.squirrelly = fromStringRenderer('squirrelly');

	/**
	 * Squirrelly string support.
	 */

	exports.squirrelly.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.squirrelly || (requires.squirrelly = require('squirrelly'));
	    try {
	      for (var partial in options.partials) {
	        engine.definePartial(partial, options.partials[partial]);
	      }
	      for (var helper in options.helpers) {
	        engine.defineHelper(helper, options.helpers[helper]);
	      }
	      var tmpl = cache(options) || cache(options, engine.Compile(str, options));
	      cb(null, tmpl(options, engine));
	    } catch (err) {
	      cb(err);
	    }
	  });
	};
	/**
	 * Twing support.
	 */

	exports.twing = fromStringRenderer('twing');

	/**
	 * Twing string support.
	 */ 

	exports.twing.render = function(str, options, cb) {
	  return promisify(cb, function(cb) {
	    var engine = requires.twing || (requires.twing = require('twing'));
	    try {
	      new engine.TwingEnvironment(new engine.TwingLoaderNull()).createTemplate(str).then((twingTemplate) => {
	        twingTemplate.render(options).then((rendTmpl) => {
	          var tmpl = cache(options) || cache(options, rendTmpl);
	          cb(null, tmpl);
	        });
	      });
	    } catch (err) {
	      cb(err);
	    }
	  });
	};
	/**
	 * expose the instance of the engine
	 */
	exports.requires = requires;
} (consolidate$1, consolidateExports));

(function (module) {
	module.exports = consolidateExports;
} (consolidate$2));

var consolidate = /*@__PURE__*/getDefaultExportFromCjs(consolidateExports$1);

const hasWarned = {};
function warnOnce(msg) {
  const isNodeProd = typeof process !== "undefined" && process.env.NODE_ENV === "production";
  if (!isNodeProd && true && !hasWarned[msg]) {
    hasWarned[msg] = true;
    warn(msg);
  }
}
function warn(msg) {
  console.warn(
    `\x1B[1m\x1B[33m[@vue/compiler-sfc]\x1B[0m\x1B[33m ${msg}\x1B[0m
`
  );
}

function preprocess$1({ source, filename, preprocessOptions }, preprocessor) {
  let res = "";
  let err = null;
  preprocessor.render(
    source,
    { filename, ...preprocessOptions },
    (_err, _res) => {
      if (_err)
        err = _err;
      res = _res;
    }
  );
  if (err)
    throw err;
  return res;
}
function compileTemplate(options) {
  const { preprocessLang, preprocessCustomRequire } = options;
  const preprocessor = preprocessLang ? preprocessCustomRequire ? preprocessCustomRequire(preprocessLang) : consolidate[preprocessLang] : false;
  if (preprocessor) {
    try {
      return doCompileTemplate({
        ...options,
        source: preprocess$1(options, preprocessor)
      });
    } catch (e) {
      return {
        code: `export default function render() {}`,
        source: options.source,
        tips: [],
        errors: [e]
      };
    }
  } else if (preprocessLang) {
    return {
      code: `export default function render() {}`,
      source: options.source,
      tips: [
        `Component ${options.filename} uses lang ${preprocessLang} for template. Please install the language preprocessor.`
      ],
      errors: [
        `Component ${options.filename} uses lang ${preprocessLang} for template, however it is not installed.`
      ]
    };
  } else {
    return doCompileTemplate(options);
  }
}
function doCompileTemplate({
  filename,
  id,
  scoped,
  slotted,
  inMap,
  source,
  ssr = false,
  ssrCssVars,
  isProd = false,
  compiler = ssr ? CompilerSSR__namespace : CompilerDOM__namespace,
  compilerOptions = {},
  transformAssetUrls
}) {
  const errors = [];
  const warnings = [];
  let nodeTransforms = [];
  if (shared.isObject(transformAssetUrls)) {
    const assetOptions = normalizeOptions(transformAssetUrls);
    nodeTransforms = [
      createAssetUrlTransformWithOptions(assetOptions),
      createSrcsetTransformWithOptions(assetOptions)
    ];
  } else if (transformAssetUrls !== false) {
    nodeTransforms = [transformAssetUrl, transformSrcset];
  }
  if (ssr && !ssrCssVars) {
    warnOnce(
      `compileTemplate is called with \`ssr: true\` but no corresponding \`cssVars\` option.\`.`
    );
  }
  if (!id) {
    warnOnce(`compileTemplate now requires the \`id\` option.\`.`);
    id = "";
  }
  const shortId = id.replace(/^data-v-/, "");
  const longId = `data-v-${shortId}`;
  let { code, ast, preamble, map } = compiler.compile(source, {
    mode: "module",
    prefixIdentifiers: true,
    hoistStatic: true,
    cacheHandlers: true,
    ssrCssVars: ssr && ssrCssVars && ssrCssVars.length ? genCssVarsFromList(ssrCssVars, shortId, isProd, true) : "",
    scopeId: scoped ? longId : void 0,
    slotted,
    sourceMap: true,
    ...compilerOptions,
    nodeTransforms: nodeTransforms.concat(compilerOptions.nodeTransforms || []),
    filename,
    onError: (e) => errors.push(e),
    onWarn: (w) => warnings.push(w)
  });
  if (inMap) {
    if (map) {
      map = mapLines(inMap, map);
    }
    if (errors.length) {
      patchErrors(errors, source, inMap);
    }
  }
  const tips = warnings.map((w) => {
    let msg = w.message;
    if (w.loc) {
      msg += `
${shared.generateCodeFrame(
        source,
        w.loc.start.offset,
        w.loc.end.offset
      )}`;
    }
    return msg;
  });
  return { code, ast, preamble, source, errors, tips, map };
}
function mapLines(oldMap, newMap) {
  if (!oldMap)
    return newMap;
  if (!newMap)
    return oldMap;
  const oldMapConsumer = new require$$0$1.SourceMapConsumer(oldMap);
  const newMapConsumer = new require$$0$1.SourceMapConsumer(newMap);
  const mergedMapGenerator = new require$$0$1.SourceMapGenerator();
  newMapConsumer.eachMapping((m) => {
    if (m.originalLine == null) {
      return;
    }
    const origPosInOldMap = oldMapConsumer.originalPositionFor({
      line: m.originalLine,
      column: m.originalColumn
    });
    if (origPosInOldMap.source == null) {
      return;
    }
    mergedMapGenerator.addMapping({
      generated: {
        line: m.generatedLine,
        column: m.generatedColumn
      },
      original: {
        line: origPosInOldMap.line,
        // map line
        // use current column, since the oldMap produced by @vue/compiler-sfc
        // does not
        column: m.originalColumn
      },
      source: origPosInOldMap.source,
      name: origPosInOldMap.name
    });
  });
  const generator = mergedMapGenerator;
  oldMapConsumer.sources.forEach((sourceFile) => {
    generator._sources.add(sourceFile);
    const sourceContent = oldMapConsumer.sourceContentFor(sourceFile);
    if (sourceContent != null) {
      mergedMapGenerator.setSourceContent(sourceFile, sourceContent);
    }
  });
  generator._sourceRoot = oldMap.sourceRoot;
  generator._file = oldMap.file;
  return generator.toJSON();
}
function patchErrors(errors, source, inMap) {
  const originalSource = inMap.sourcesContent[0];
  const offset = originalSource.indexOf(source);
  const lineOffset = originalSource.slice(0, offset).split(/\r?\n/).length - 1;
  errors.forEach((err) => {
    if (err.loc) {
      err.loc.start.line += lineOffset;
      err.loc.start.offset += offset;
      if (err.loc.end !== err.loc.start) {
        err.loc.end.line += lineOffset;
        err.loc.end.offset += offset;
      }
    }
  });
}

const defaultExportRE = /((?:^|\n|;)\s*)export(\s*)default/;
const namedDefaultExportRE = /((?:^|\n|;)\s*)export(.+)(?:as)?(\s*)default/s;
const exportDefaultClassRE = /((?:^|\n|;)\s*)export\s+default\s+class\s+([\w$]+)/;
function rewriteDefault(input, as, parserPlugins) {
  if (!hasDefaultExport(input)) {
    return input + `
const ${as} = {}`;
  }
  let replaced;
  const classMatch = input.match(exportDefaultClassRE);
  if (classMatch) {
    replaced = input.replace(exportDefaultClassRE, "$1class $2") + `
const ${as} = ${classMatch[2]}`;
  } else {
    replaced = input.replace(defaultExportRE, `$1const ${as} =`);
  }
  if (!hasDefaultExport(replaced)) {
    return replaced;
  }
  const s = new MagicString(input);
  const ast = parser$2.parse(input, {
    sourceType: "module",
    plugins: parserPlugins
  }).program.body;
  ast.forEach((node) => {
    if (node.type === "ExportDefaultDeclaration") {
      if (node.declaration.type === "ClassDeclaration") {
        s.overwrite(node.start, node.declaration.id.start, `class `);
        s.append(`
const ${as} = ${node.declaration.id.name}`);
      } else {
        s.overwrite(node.start, node.declaration.start, `const ${as} = `);
      }
    }
    if (node.type === "ExportNamedDeclaration") {
      for (const specifier of node.specifiers) {
        if (specifier.type === "ExportSpecifier" && specifier.exported.type === "Identifier" && specifier.exported.name === "default") {
          if (node.source) {
            if (specifier.local.name === "default") {
              const end2 = specifierEnd(input, specifier.local.end, node.end);
              s.prepend(
                `import { default as __VUE_DEFAULT__ } from '${node.source.value}'
`
              );
              s.overwrite(specifier.start, end2, ``);
              s.append(`
const ${as} = __VUE_DEFAULT__`);
              continue;
            } else {
              const end2 = specifierEnd(
                input,
                specifier.exported.end,
                node.end
              );
              s.prepend(
                `import { ${input.slice(
                  specifier.local.start,
                  specifier.local.end
                )} } from '${node.source.value}'
`
              );
              s.overwrite(specifier.start, end2, ``);
              s.append(`
const ${as} = ${specifier.local.name}`);
              continue;
            }
          }
          const end = specifierEnd(input, specifier.end, node.end);
          s.overwrite(specifier.start, end, ``);
          s.append(`
const ${as} = ${specifier.local.name}`);
        }
      }
    }
  });
  return s.toString();
}
function hasDefaultExport(input) {
  return defaultExportRE.test(input) || namedDefaultExportRE.test(input);
}
function specifierEnd(input, end, nodeEnd) {
  let hasCommas = false;
  let oldEnd = end;
  while (end < nodeEnd) {
    if (/\s/.test(input.charAt(end))) {
      end++;
    } else if (input.charAt(end) === ",") {
      end++;
      hasCommas = true;
      break;
    } else if (input.charAt(end) === "}") {
      break;
    }
  }
  return hasCommas ? end : oldEnd;
}

const DEFINE_PROPS = "defineProps";
const DEFINE_EMITS = "defineEmits";
const DEFINE_EXPOSE = "defineExpose";
const WITH_DEFAULTS = "withDefaults";
const DEFAULT_VAR = `__default__`;
const isBuiltInDir = shared.makeMap(
  `once,memo,if,for,else,else-if,slot,text,html,on,bind,model,show,cloak,is`
);
function compileScript(sfc, options) {
  var _a;
  let { script, scriptSetup, source, filename } = sfc;
  const enableReactivityTransform = !!options.reactivityTransform || !!options.refSugar || !!options.refTransform;
  const enablePropsTransform = !!options.reactivityTransform || !!options.propsDestructureTransform;
  const isProd = !!options.isProd;
  const genSourceMap = options.sourceMap !== false;
  let refBindings;
  if (!options.id) {
    warnOnce(
      `compileScript now requires passing the \`id\` option.
Upgrade your vite or vue-loader version for compatibility with the latest experimental proposals.`
    );
  }
  const scopeId = options.id ? options.id.replace(/^data-v-/, "") : "";
  const cssVars = sfc.cssVars;
  const scriptLang = script && script.lang;
  const scriptSetupLang = scriptSetup && scriptSetup.lang;
  const isTS = scriptLang === "ts" || scriptLang === "tsx" || scriptSetupLang === "ts" || scriptSetupLang === "tsx";
  const plugins = [];
  if (!isTS || scriptLang === "tsx" || scriptSetupLang === "tsx") {
    plugins.push("jsx");
  } else {
    if (options.babelParserPlugins)
      options.babelParserPlugins = options.babelParserPlugins.filter(
        (n) => n !== "jsx"
      );
  }
  if (options.babelParserPlugins)
    plugins.push(...options.babelParserPlugins);
  if (isTS) {
    plugins.push("typescript");
    if (!plugins.includes("decorators")) {
      plugins.push("decorators-legacy");
    }
  }
  if (!scriptSetup) {
    if (!script) {
      throw new Error(`[@vue/compiler-sfc] SFC contains no <script> tags.`);
    }
    if (scriptLang && !isTS && scriptLang !== "jsx") {
      return script;
    }
    try {
      let content = script.content;
      let map = script.map;
      const scriptAst2 = parser$2.parse(content, {
        plugins,
        sourceType: "module"
      }).program;
      const bindings = analyzeScriptBindings(scriptAst2.body);
      if (enableReactivityTransform && reactivityTransform.shouldTransform(content)) {
        const s2 = new MagicString(source);
        const startOffset2 = script.loc.start.offset;
        const endOffset2 = script.loc.end.offset;
        const { importedHelpers } = reactivityTransform.transformAST(scriptAst2, s2, startOffset2);
        if (importedHelpers.length) {
          s2.prepend(
            `import { ${importedHelpers.map((h) => `${h} as _${h}`).join(", ")} } from 'vue'
`
          );
        }
        s2.remove(0, startOffset2);
        s2.remove(endOffset2, source.length);
        content = s2.toString();
        if (genSourceMap) {
          map = s2.generateMap({
            source: filename,
            hires: true,
            includeContent: true
          });
        }
      }
      if (cssVars.length) {
        content = rewriteDefault(content, DEFAULT_VAR, plugins);
        content += genNormalScriptCssVarsCode(
          cssVars,
          bindings,
          scopeId,
          isProd
        );
        content += `
export default ${DEFAULT_VAR}`;
      }
      return {
        ...script,
        content,
        map,
        bindings,
        scriptAst: scriptAst2.body
      };
    } catch (e) {
      return script;
    }
  }
  if (script && scriptLang !== scriptSetupLang) {
    throw new Error(
      `[@vue/compiler-sfc] <script> and <script setup> must have the same language type.`
    );
  }
  if (scriptSetupLang && !isTS && scriptSetupLang !== "jsx") {
    return scriptSetup;
  }
  const bindingMetadata = {};
  const helperImports = /* @__PURE__ */ new Set();
  const userImports = /* @__PURE__ */ Object.create(null);
  const scriptBindings = /* @__PURE__ */ Object.create(null);
  const setupBindings = /* @__PURE__ */ Object.create(null);
  let defaultExport;
  let hasDefinePropsCall = false;
  let hasDefineEmitCall = false;
  let hasDefineExposeCall = false;
  let hasDefaultExportName = false;
  let hasDefaultExportRender = false;
  let propsRuntimeDecl;
  let propsRuntimeDefaults;
  let propsDestructureDecl;
  let propsDestructureRestId;
  let propsTypeDecl;
  let propsTypeDeclRaw;
  let propsIdentifier;
  let emitsRuntimeDecl;
  let emitsTypeDecl;
  let emitsTypeDeclRaw;
  let emitIdentifier;
  let hasAwait = false;
  let hasInlinedSsrRenderFn = false;
  const typeDeclaredProps = {};
  const typeDeclaredEmits = /* @__PURE__ */ new Set();
  const declaredTypes = {};
  const propsDestructuredBindings = /* @__PURE__ */ Object.create(null);
  const s = new MagicString(source);
  const startOffset = scriptSetup.loc.start.offset;
  const endOffset = scriptSetup.loc.end.offset;
  const scriptStartOffset = script && script.loc.start.offset;
  const scriptEndOffset = script && script.loc.end.offset;
  function helper(key) {
    helperImports.add(key);
    return `_${key}`;
  }
  function parse(input, options2, offset) {
    try {
      return parser$2.parse(input, options2).program;
    } catch (e) {
      e.message = `[@vue/compiler-sfc] ${e.message}

${sfc.filename}
${shared.generateCodeFrame(source, e.pos + offset, e.pos + offset + 1)}`;
      throw e;
    }
  }
  function error(msg, node, end = node.end + startOffset) {
    throw new Error(
      `[@vue/compiler-sfc] ${msg}

${sfc.filename}
${shared.generateCodeFrame(
        source,
        node.start + startOffset,
        end
      )}`
    );
  }
  function hoistNode(node) {
    const start = node.start + startOffset;
    let end = node.end + startOffset;
    if (node.trailingComments && node.trailingComments.length > 0) {
      const lastCommentNode = node.trailingComments[node.trailingComments.length - 1];
      end = lastCommentNode.end + startOffset;
    }
    while (end <= source.length) {
      if (!/\s/.test(source.charAt(end))) {
        break;
      }
      end++;
    }
    s.move(start, end, 0);
  }
  function registerUserImport(source2, local, imported, isType, isFromSetup, needTemplateUsageCheck) {
    let isUsedInTemplate = needTemplateUsageCheck;
    if (needTemplateUsageCheck && isTS && sfc.template && !sfc.template.src && !sfc.template.lang) {
      isUsedInTemplate = isImportUsed(local, sfc);
    }
    userImports[local] = {
      isType,
      imported: imported || "default",
      local,
      source: source2,
      isFromSetup,
      isUsedInTemplate
    };
  }
  function processDefineProps(node, declId, declKind) {
    if (!isCallOf(node, DEFINE_PROPS)) {
      return false;
    }
    if (hasDefinePropsCall) {
      error(`duplicate ${DEFINE_PROPS}() call`, node);
    }
    hasDefinePropsCall = true;
    propsRuntimeDecl = node.arguments[0];
    if (node.typeParameters) {
      if (propsRuntimeDecl) {
        error(
          `${DEFINE_PROPS}() cannot accept both type and non-type arguments at the same time. Use one or the other.`,
          node
        );
      }
      propsTypeDeclRaw = node.typeParameters.params[0];
      propsTypeDecl = resolveQualifiedType(
        propsTypeDeclRaw,
        (node2) => node2.type === "TSTypeLiteral"
      );
      if (!propsTypeDecl) {
        error(
          `type argument passed to ${DEFINE_PROPS}() must be a literal type, or a reference to an interface or literal type.`,
          propsTypeDeclRaw
        );
      }
    }
    if (declId) {
      const isConst = declKind === "const";
      if (enablePropsTransform && declId.type === "ObjectPattern") {
        propsDestructureDecl = declId;
        for (const prop of declId.properties) {
          if (prop.type === "ObjectProperty") {
            const propKey = resolveObjectKey(prop.key, prop.computed);
            if (!propKey) {
              error(
                `${DEFINE_PROPS}() destructure cannot use computed key.`,
                prop.key
              );
            }
            if (prop.value.type === "AssignmentPattern") {
              const { left, right } = prop.value;
              if (left.type !== "Identifier") {
                error(
                  `${DEFINE_PROPS}() destructure does not support nested patterns.`,
                  left
                );
              }
              propsDestructuredBindings[propKey] = {
                local: left.name,
                default: right,
                isConst
              };
            } else if (prop.value.type === "Identifier") {
              propsDestructuredBindings[propKey] = {
                local: prop.value.name,
                isConst
              };
            } else {
              error(
                `${DEFINE_PROPS}() destructure does not support nested patterns.`,
                prop.value
              );
            }
          } else {
            propsDestructureRestId = prop.argument.name;
          }
        }
      } else {
        propsIdentifier = scriptSetup.content.slice(declId.start, declId.end);
      }
    }
    return true;
  }
  function processWithDefaults(node, declId, declKind) {
    if (!isCallOf(node, WITH_DEFAULTS)) {
      return false;
    }
    if (processDefineProps(node.arguments[0], declId, declKind)) {
      if (propsRuntimeDecl) {
        error(
          `${WITH_DEFAULTS} can only be used with type-based ${DEFINE_PROPS} declaration.`,
          node
        );
      }
      if (propsDestructureDecl) {
        error(
          `${WITH_DEFAULTS}() is unnecessary when using destructure with ${DEFINE_PROPS}().
Prefer using destructure default values, e.g. const { foo = 1 } = defineProps(...).`,
          node.callee
        );
      }
      propsRuntimeDefaults = node.arguments[1];
      if (!propsRuntimeDefaults || propsRuntimeDefaults.type !== "ObjectExpression") {
        error(
          `The 2nd argument of ${WITH_DEFAULTS} must be an object literal.`,
          propsRuntimeDefaults || node
        );
      }
    } else {
      error(
        `${WITH_DEFAULTS}' first argument must be a ${DEFINE_PROPS} call.`,
        node.arguments[0] || node
      );
    }
    return true;
  }
  function processDefineEmits(node, declId) {
    if (!isCallOf(node, DEFINE_EMITS)) {
      return false;
    }
    if (hasDefineEmitCall) {
      error(`duplicate ${DEFINE_EMITS}() call`, node);
    }
    hasDefineEmitCall = true;
    emitsRuntimeDecl = node.arguments[0];
    if (node.typeParameters) {
      if (emitsRuntimeDecl) {
        error(
          `${DEFINE_EMITS}() cannot accept both type and non-type arguments at the same time. Use one or the other.`,
          node
        );
      }
      emitsTypeDeclRaw = node.typeParameters.params[0];
      emitsTypeDecl = resolveQualifiedType(
        emitsTypeDeclRaw,
        (node2) => node2.type === "TSFunctionType" || node2.type === "TSTypeLiteral"
      );
      if (!emitsTypeDecl) {
        error(
          `type argument passed to ${DEFINE_EMITS}() must be a function type, a literal type with call signatures, or a reference to the above types.`,
          emitsTypeDeclRaw
        );
      }
    }
    if (declId) {
      emitIdentifier = declId.type === "Identifier" ? declId.name : scriptSetup.content.slice(declId.start, declId.end);
    }
    return true;
  }
  function getAstBody() {
    return scriptAst ? [...scriptSetupAst.body, ...scriptAst.body] : scriptSetupAst.body;
  }
  function resolveExtendsType(node, qualifier, cache = []) {
    if (node.type === "TSInterfaceDeclaration" && node.extends) {
      node.extends.forEach((extend) => {
        if (extend.type === "TSExpressionWithTypeArguments" && extend.expression.type === "Identifier") {
          const body = getAstBody();
          for (const node2 of body) {
            const qualified = isQualifiedType(
              node2,
              qualifier,
              extend.expression.name
            );
            if (qualified) {
              cache.push(qualified);
              resolveExtendsType(node2, qualifier, cache);
              return cache;
            }
          }
        }
      });
    }
    return cache;
  }
  function isQualifiedType(node, qualifier, refName) {
    if (node.type === "TSInterfaceDeclaration" && node.id.name === refName) {
      return node.body;
    } else if (node.type === "TSTypeAliasDeclaration" && node.id.name === refName && qualifier(node.typeAnnotation)) {
      return node.typeAnnotation;
    } else if (node.type === "ExportNamedDeclaration" && node.declaration) {
      return isQualifiedType(node.declaration, qualifier, refName);
    }
  }
  function filterExtendsType(extendsTypes, bodies) {
    extendsTypes.forEach((extend) => {
      const body = extend.body;
      body.forEach((newBody) => {
        if (newBody.type === "TSPropertySignature" && newBody.key.type === "Identifier") {
          const name = newBody.key.name;
          const hasOverride = bodies.some(
            (seenBody) => seenBody.type === "TSPropertySignature" && seenBody.key.type === "Identifier" && seenBody.key.name === name
          );
          if (!hasOverride)
            bodies.push(newBody);
        }
      });
    });
  }
  function resolveQualifiedType(node, qualifier) {
    if (qualifier(node)) {
      return node;
    }
    if (node.type === "TSTypeReference" && node.typeName.type === "Identifier") {
      const refName = node.typeName.name;
      const body = getAstBody();
      for (let i = 0; i < body.length; i++) {
        const node2 = body[i];
        let qualified = isQualifiedType(
          node2,
          qualifier,
          refName
        );
        if (qualified) {
          const extendsTypes = resolveExtendsType(node2, qualifier);
          if (extendsTypes.length) {
            const bodies = [...qualified.body];
            filterExtendsType(extendsTypes, bodies);
            qualified.body = bodies;
          }
          qualified.__fromNormalScript = scriptAst && i >= scriptSetupAst.body.length;
          return qualified;
        }
      }
    }
  }
  function processDefineExpose(node) {
    if (isCallOf(node, DEFINE_EXPOSE)) {
      if (hasDefineExposeCall) {
        error(`duplicate ${DEFINE_EXPOSE}() call`, node);
      }
      hasDefineExposeCall = true;
      return true;
    }
    return false;
  }
  function checkInvalidScopeReference(node, method) {
    if (!node)
      return;
    CompilerDOM.walkIdentifiers(node, (id) => {
      if (setupBindings[id.name]) {
        error(
          `\`${method}()\` in <script setup> cannot reference locally declared variables because it will be hoisted outside of the setup() function. If your component options require initialization in the module scope, use a separate normal <script> to export the options instead.`,
          id
        );
      }
    });
  }
  function processAwait(node, needSemi, isStatement) {
    const argumentStart = node.argument.extra && node.argument.extra.parenthesized ? node.argument.extra.parenStart : node.argument.start;
    const argumentStr = source.slice(
      argumentStart + startOffset,
      node.argument.end + startOffset
    );
    const containsNestedAwait = /\bawait\b/.test(argumentStr);
    s.overwrite(
      node.start + startOffset,
      argumentStart + startOffset,
      `${needSemi ? `;` : ``}(
  ([__temp,__restore] = ${helper(
        `withAsyncContext`
      )}(${containsNestedAwait ? `async ` : ``}() => `
    );
    s.appendLeft(
      node.end + startOffset,
      `)),
  ${isStatement ? `` : `__temp = `}await __temp,
  __restore()${isStatement ? `` : `,
  __temp`}
)`
    );
  }
  function hasStaticWithDefaults() {
    return propsRuntimeDefaults && propsRuntimeDefaults.type === "ObjectExpression" && propsRuntimeDefaults.properties.every(
      (node) => node.type === "ObjectProperty" && (!node.computed || node.key.type.endsWith("Literal")) || node.type === "ObjectMethod"
    );
  }
  function genRuntimeProps(props) {
    const keys = Object.keys(props);
    if (!keys.length) {
      return ``;
    }
    const hasStaticDefaults = hasStaticWithDefaults();
    const scriptSetupSource = scriptSetup.content;
    let propsDecls = `{
    ${keys.map((key) => {
      let defaultString;
      const destructured = genDestructuredDefaultValue(key);
      if (destructured) {
        defaultString = `default: ${destructured}`;
      } else if (hasStaticDefaults) {
        const prop = propsRuntimeDefaults.properties.find((node) => {
          if (node.type === "SpreadElement")
            return false;
          return resolveObjectKey(node.key, node.computed) === key;
        });
        if (prop) {
          if (prop.type === "ObjectProperty") {
            defaultString = `default: ${scriptSetupSource.slice(
              prop.value.start,
              prop.value.end
            )}`;
          } else {
            defaultString = `${prop.async ? "async " : ""}${prop.kind !== "method" ? `${prop.kind} ` : ""}default() ${scriptSetupSource.slice(
              prop.body.start,
              prop.body.end
            )}`;
          }
        }
      }
      const { type, required } = props[key];
      if (!isProd) {
        return `${key}: { type: ${toRuntimeTypeString(
          type
        )}, required: ${required}${defaultString ? `, ${defaultString}` : ``} }`;
      } else if (type.some(
        (el) => el === "Boolean" || (!hasStaticDefaults || defaultString) && el === "Function"
      )) {
        return `${key}: { type: ${toRuntimeTypeString(type)}${defaultString ? `, ${defaultString}` : ``} }`;
      } else {
        return `${key}: ${defaultString ? `{ ${defaultString} }` : "null"}`;
      }
    }).join(",\n    ")}
  }`;
    if (propsRuntimeDefaults && !hasStaticDefaults) {
      propsDecls = `${helper("mergeDefaults")}(${propsDecls}, ${source.slice(
        propsRuntimeDefaults.start + startOffset,
        propsRuntimeDefaults.end + startOffset
      )})`;
    }
    return `
  props: ${propsDecls},`;
  }
  function genDestructuredDefaultValue(key) {
    const destructured = propsDestructuredBindings[key];
    if (destructured && destructured.default) {
      const value = scriptSetup.content.slice(
        destructured.default.start,
        destructured.default.end
      );
      const isLiteral = destructured.default.type.endsWith("Literal");
      return isLiteral ? value : `() => (${value})`;
    }
  }
  function genSetupPropsType(node) {
    const scriptSource = node.__fromNormalScript ? script.content : scriptSetup.content;
    if (hasStaticWithDefaults()) {
      let res = `{ `;
      const members = node.type === "TSTypeLiteral" ? node.members : node.body;
      for (const m of members) {
        if ((m.type === "TSPropertySignature" || m.type === "TSMethodSignature") && m.typeAnnotation && m.key.type === "Identifier") {
          if (propsRuntimeDefaults.properties.some((p) => {
            if (p.type === "SpreadElement")
              return false;
            return resolveObjectKey(p.key, p.computed) === m.key.name;
          })) {
            res += m.key.name + (m.type === "TSMethodSignature" ? "()" : "") + scriptSource.slice(
              m.typeAnnotation.start,
              m.typeAnnotation.end
            ) + ", ";
          } else {
            res += scriptSource.slice(m.start, m.typeAnnotation.end) + `, `;
          }
        }
      }
      return (res.length ? res.slice(0, -2) : res) + ` }`;
    } else {
      return scriptSource.slice(node.start, node.end);
    }
  }
  const scriptAst = script && parse(
    script.content,
    {
      plugins,
      sourceType: "module"
    },
    scriptStartOffset
  );
  const scriptSetupAst = parse(
    scriptSetup.content,
    {
      plugins: [
        ...plugins,
        // allow top level await but only inside <script setup>
        "topLevelAwait"
      ],
      sourceType: "module"
    },
    startOffset
  );
  if (scriptAst) {
    for (const node of scriptAst.body) {
      if (node.type === "ImportDeclaration") {
        for (const specifier of node.specifiers) {
          const imported = specifier.type === "ImportSpecifier" && specifier.imported.type === "Identifier" && specifier.imported.name;
          registerUserImport(
            node.source.value,
            specifier.local.name,
            imported,
            node.importKind === "type" || specifier.type === "ImportSpecifier" && specifier.importKind === "type",
            false,
            !options.inlineTemplate
          );
        }
      }
    }
  }
  for (const node of scriptSetupAst.body) {
    if (node.type === "ImportDeclaration") {
      hoistNode(node);
      let removed = 0;
      const removeSpecifier = (i) => {
        const removeLeft = i > removed;
        removed++;
        const current = node.specifiers[i];
        const next = node.specifiers[i + 1];
        s.remove(
          removeLeft ? node.specifiers[i - 1].end + startOffset : current.start + startOffset,
          next && !removeLeft ? next.start + startOffset : current.end + startOffset
        );
      };
      for (let i = 0; i < node.specifiers.length; i++) {
        const specifier = node.specifiers[i];
        const local = specifier.local.name;
        let imported = specifier.type === "ImportSpecifier" && specifier.imported.type === "Identifier" && specifier.imported.name;
        if (specifier.type === "ImportNamespaceSpecifier") {
          imported = "*";
        }
        const source2 = node.source.value;
        const existing = userImports[local];
        if (source2 === "vue" && (imported === DEFINE_PROPS || imported === DEFINE_EMITS || imported === DEFINE_EXPOSE)) {
          warnOnce(
            `\`${imported}\` is a compiler macro and no longer needs to be imported.`
          );
          removeSpecifier(i);
        } else if (existing) {
          if (existing.source === source2 && existing.imported === imported) {
            removeSpecifier(i);
          } else {
            error(`different imports aliased to same local name.`, specifier);
          }
        } else {
          registerUserImport(
            source2,
            local,
            imported,
            node.importKind === "type" || specifier.type === "ImportSpecifier" && specifier.importKind === "type",
            true,
            !options.inlineTemplate
          );
        }
      }
      if (node.specifiers.length && removed === node.specifiers.length) {
        s.remove(node.start + startOffset, node.end + startOffset);
      }
    }
  }
  const vueImportAliases = {};
  for (const key in userImports) {
    const { source: source2, imported, local } = userImports[key];
    if (source2 === "vue")
      vueImportAliases[imported] = local;
  }
  if (script && scriptAst) {
    for (const node of scriptAst.body) {
      if (node.type === "ExportDefaultDeclaration") {
        defaultExport = node;
        let optionProperties;
        if (defaultExport.declaration.type === "ObjectExpression") {
          optionProperties = defaultExport.declaration.properties;
        } else if (defaultExport.declaration.type === "CallExpression" && defaultExport.declaration.arguments[0].type === "ObjectExpression") {
          optionProperties = defaultExport.declaration.arguments[0].properties;
        }
        if (optionProperties) {
          for (const s2 of optionProperties) {
            if (s2.type === "ObjectProperty" && s2.key.type === "Identifier" && s2.key.name === "name") {
              hasDefaultExportName = true;
            }
            if ((s2.type === "ObjectMethod" || s2.type === "ObjectProperty") && s2.key.type === "Identifier" && s2.key.name === "render") {
              hasDefaultExportRender = true;
            }
          }
        }
        const start = node.start + scriptStartOffset;
        const end = node.declaration.start + scriptStartOffset;
        s.overwrite(start, end, `const ${DEFAULT_VAR} = `);
      } else if (node.type === "ExportNamedDeclaration") {
        const defaultSpecifier = node.specifiers.find(
          (s2) => s2.exported.type === "Identifier" && s2.exported.name === "default"
        );
        if (defaultSpecifier) {
          defaultExport = node;
          if (node.specifiers.length > 1) {
            s.remove(
              defaultSpecifier.start + scriptStartOffset,
              defaultSpecifier.end + scriptStartOffset
            );
          } else {
            s.remove(
              node.start + scriptStartOffset,
              node.end + scriptStartOffset
            );
          }
          if (node.source) {
            s.prepend(
              `import { ${defaultSpecifier.local.name} as ${DEFAULT_VAR} } from '${node.source.value}'
`
            );
          } else {
            s.appendLeft(
              scriptEndOffset,
              `
const ${DEFAULT_VAR} = ${defaultSpecifier.local.name}
`
            );
          }
        }
        if (node.declaration) {
          walkDeclaration(node.declaration, scriptBindings, vueImportAliases);
        }
      } else if ((node.type === "VariableDeclaration" || node.type === "FunctionDeclaration" || node.type === "ClassDeclaration" || node.type === "TSEnumDeclaration") && !node.declare) {
        walkDeclaration(node, scriptBindings, vueImportAliases);
      }
    }
    if (enableReactivityTransform && reactivityTransform.shouldTransform(script.content)) {
      const { rootRefs, importedHelpers } = reactivityTransform.transformAST(
        scriptAst,
        s,
        scriptStartOffset
      );
      refBindings = rootRefs;
      for (const h of importedHelpers) {
        helperImports.add(h);
      }
    }
    if (scriptStartOffset > startOffset) {
      if (!/\n$/.test(script.content.trim())) {
        s.appendLeft(scriptEndOffset, `
`);
      }
      s.move(scriptStartOffset, scriptEndOffset, 0);
    }
  }
  for (const node of scriptSetupAst.body) {
    if (node.type === "LabeledStatement" && node.label.name === "ref" && node.body.type === "ExpressionStatement") {
      error(
        `ref sugar using the label syntax was an experimental proposal and has been dropped based on community feedback. Please check out the new proposal at https://github.com/vuejs/rfcs/discussions/369`,
        node
      );
    }
    if (node.type === "ExpressionStatement") {
      if (processDefineProps(node.expression) || processDefineEmits(node.expression) || processWithDefaults(node.expression)) {
        s.remove(node.start + startOffset, node.end + startOffset);
      } else if (processDefineExpose(node.expression)) {
        const callee = node.expression.callee;
        s.overwrite(
          callee.start + startOffset,
          callee.end + startOffset,
          "expose"
        );
      }
    }
    if (node.type === "VariableDeclaration" && !node.declare) {
      const total = node.declarations.length;
      let left = total;
      for (let i = 0; i < total; i++) {
        const decl = node.declarations[i];
        if (decl.init) {
          const isDefineProps = processDefineProps(decl.init, decl.id, node.kind) || processWithDefaults(decl.init, decl.id, node.kind);
          const isDefineEmits = processDefineEmits(decl.init, decl.id);
          if (isDefineProps || isDefineEmits) {
            if (left === 1) {
              s.remove(node.start + startOffset, node.end + startOffset);
            } else {
              let start = decl.start + startOffset;
              let end = decl.end + startOffset;
              if (i === 0) {
                end = node.declarations[i + 1].start + startOffset;
              } else {
                start = node.declarations[i - 1].end + startOffset;
              }
              s.remove(start, end);
              left--;
            }
          }
        }
      }
    }
    if ((node.type === "VariableDeclaration" || node.type === "FunctionDeclaration" || node.type === "ClassDeclaration") && !node.declare) {
      walkDeclaration(node, setupBindings, vueImportAliases);
    }
    if (node.type === "VariableDeclaration" && !node.declare || node.type.endsWith("Statement")) {
      const scope = [scriptSetupAst.body];
      estreeWalker.walk(node, {
        enter(child, parent) {
          if (CompilerDOM.isFunctionType(child)) {
            this.skip();
          }
          if (child.type === "BlockStatement") {
            scope.push(child.body);
          }
          if (child.type === "AwaitExpression") {
            hasAwait = true;
            const currentScope = scope[scope.length - 1];
            const needsSemi = currentScope.some((n, i) => {
              return (scope.length === 1 || i > 0) && n.type === "ExpressionStatement" && n.start === child.start;
            });
            processAwait(
              child,
              needsSemi,
              parent.type === "ExpressionStatement"
            );
          }
        },
        exit(node2) {
          if (node2.type === "BlockStatement")
            scope.pop();
        }
      });
    }
    if (node.type === "ExportNamedDeclaration" && node.exportKind !== "type" || node.type === "ExportAllDeclaration" || node.type === "ExportDefaultDeclaration") {
      error(
        `<script setup> cannot contain ES module exports. If you are using a previous version of <script setup>, please consult the updated RFC at https://github.com/vuejs/rfcs/pull/227.`,
        node
      );
    }
    if (isTS) {
      if (node.type === "TSEnumDeclaration") {
        registerBinding(setupBindings, node.id, "setup-const");
      }
      if (node.type.startsWith("TS") || node.type === "ExportNamedDeclaration" && node.exportKind === "type" || node.type === "VariableDeclaration" && node.declare) {
        recordType(node, declaredTypes);
        hoistNode(node);
      }
    }
  }
  if (enableReactivityTransform && // normal <script> had ref bindings that maybe used in <script setup>
  (refBindings || reactivityTransform.shouldTransform(scriptSetup.content)) || propsDestructureDecl) {
    const { rootRefs, importedHelpers } = reactivityTransform.transformAST(
      scriptSetupAst,
      s,
      startOffset,
      refBindings,
      propsDestructuredBindings
    );
    refBindings = refBindings ? [...refBindings, ...rootRefs] : rootRefs;
    for (const h of importedHelpers) {
      helperImports.add(h);
    }
  }
  if (propsTypeDecl) {
    extractRuntimeProps(propsTypeDecl, typeDeclaredProps, declaredTypes);
  }
  if (emitsTypeDecl) {
    extractRuntimeEmits(emitsTypeDecl, typeDeclaredEmits);
  }
  checkInvalidScopeReference(propsRuntimeDecl, DEFINE_PROPS);
  checkInvalidScopeReference(propsRuntimeDefaults, DEFINE_PROPS);
  checkInvalidScopeReference(propsDestructureDecl, DEFINE_PROPS);
  checkInvalidScopeReference(emitsRuntimeDecl, DEFINE_EMITS);
  if (script) {
    if (startOffset < scriptStartOffset) {
      s.remove(0, startOffset);
      s.remove(endOffset, scriptStartOffset);
      s.remove(scriptEndOffset, source.length);
    } else {
      s.remove(0, scriptStartOffset);
      s.remove(scriptEndOffset, startOffset);
      s.remove(endOffset, source.length);
    }
  } else {
    s.remove(0, startOffset);
    s.remove(endOffset, source.length);
  }
  if (scriptAst) {
    Object.assign(bindingMetadata, analyzeScriptBindings(scriptAst.body));
  }
  if (propsRuntimeDecl) {
    for (const key of getObjectOrArrayExpressionKeys(propsRuntimeDecl)) {
      bindingMetadata[key] = "props";
    }
  }
  for (const key in typeDeclaredProps) {
    bindingMetadata[key] = "props";
  }
  if (propsDestructureDecl) {
    if (propsDestructureRestId) {
      bindingMetadata[propsDestructureRestId] = "setup-reactive-const";
    }
    for (const key in propsDestructuredBindings) {
      const { local } = propsDestructuredBindings[key];
      if (local !== key) {
        bindingMetadata[local] = "props-aliased";
        (bindingMetadata.__propsAliases || (bindingMetadata.__propsAliases = {}))[local] = key;
      }
    }
  }
  for (const [key, { isType, imported, source: source2 }] of Object.entries(
    userImports
  )) {
    if (isType)
      continue;
    bindingMetadata[key] = imported === "*" || imported === "default" && source2.endsWith(".vue") || source2 === "vue" ? "setup-const" : "setup-maybe-ref";
  }
  for (const key in scriptBindings) {
    bindingMetadata[key] = scriptBindings[key];
  }
  for (const key in setupBindings) {
    bindingMetadata[key] = setupBindings[key];
  }
  if (refBindings) {
    for (const key of refBindings) {
      bindingMetadata[key] = "setup-ref";
    }
  }
  if (cssVars.length && // no need to do this when targeting SSR
  !(options.inlineTemplate && ((_a = options.templateOptions) == null ? void 0 : _a.ssr))) {
    helperImports.add(CSS_VARS_HELPER);
    helperImports.add("unref");
    s.prependRight(
      startOffset,
      `
${genCssVarsCode(cssVars, bindingMetadata, scopeId, isProd)}
`
    );
  }
  let args = `__props`;
  if (propsTypeDecl) {
    args += `: any`;
  }
  if (propsIdentifier) {
    s.prependLeft(
      startOffset,
      `
const ${propsIdentifier} = __props${propsTypeDecl ? ` as ${genSetupPropsType(propsTypeDecl)}` : ``};
`
    );
  }
  if (propsDestructureRestId) {
    s.prependLeft(
      startOffset,
      `
const ${propsDestructureRestId} = ${helper(
        `createPropsRestProxy`
      )}(__props, ${JSON.stringify(Object.keys(propsDestructuredBindings))});
`
    );
  }
  if (hasAwait) {
    const any = isTS ? `: any` : ``;
    s.prependLeft(startOffset, `
let __temp${any}, __restore${any}
`);
  }
  const destructureElements = hasDefineExposeCall || !options.inlineTemplate ? [`expose`] : [];
  if (emitIdentifier) {
    destructureElements.push(
      emitIdentifier === `emit` ? `emit` : `emit: ${emitIdentifier}`
    );
  }
  if (destructureElements.length) {
    args += `, { ${destructureElements.join(", ")} }`;
    if (emitsTypeDecl) {
      const content = emitsTypeDecl.__fromNormalScript ? script.content : scriptSetup.content;
      args += `: { emit: (${content.slice(
        emitsTypeDecl.start,
        emitsTypeDecl.end
      )}), expose: any, slots: any, attrs: any }`;
    }
  }
  let returned;
  if (!options.inlineTemplate || !sfc.template && hasDefaultExportRender) {
    const allBindings = {
      ...scriptBindings,
      ...setupBindings
    };
    for (const key in userImports) {
      if (!userImports[key].isType && userImports[key].isUsedInTemplate) {
        allBindings[key] = true;
      }
    }
    returned = `{ `;
    for (const key in allBindings) {
      if (allBindings[key] === true && userImports[key].source !== "vue" && !userImports[key].source.endsWith(".vue")) {
        returned += `get ${key}() { return ${key} }, `;
      } else if (bindingMetadata[key] === "setup-let") {
        const setArg = key === "v" ? `_v` : `v`;
        returned += `get ${key}() { return ${key} }, set ${key}(${setArg}) { ${key} = ${setArg} }, `;
      } else {
        returned += `${key}, `;
      }
    }
    returned = returned.replace(/, $/, "") + ` }`;
  } else {
    if (sfc.template && !sfc.template.src) {
      if (options.templateOptions && options.templateOptions.ssr) {
        hasInlinedSsrRenderFn = true;
      }
      const { code, ast, preamble, tips, errors } = compileTemplate({
        filename,
        source: sfc.template.content,
        inMap: sfc.template.map,
        ...options.templateOptions,
        id: scopeId,
        scoped: sfc.styles.some((s2) => s2.scoped),
        isProd: options.isProd,
        ssrCssVars: sfc.cssVars,
        compilerOptions: {
          ...options.templateOptions && options.templateOptions.compilerOptions,
          inline: true,
          isTS,
          bindingMetadata
        }
      });
      if (tips.length) {
        tips.forEach(warnOnce);
      }
      const err = errors[0];
      if (typeof err === "string") {
        throw new Error(err);
      } else if (err) {
        if (err.loc) {
          err.message += `

` + sfc.filename + "\n" + shared.generateCodeFrame(
            source,
            err.loc.start.offset,
            err.loc.end.offset
          ) + `
`;
        }
        throw err;
      }
      if (preamble) {
        s.prepend(preamble);
      }
      if (ast && ast.helpers.has(CompilerDOM.UNREF)) {
        helperImports.delete("unref");
      }
      returned = code;
    } else {
      returned = `() => {}`;
    }
  }
  if (!options.inlineTemplate && true) {
    s.appendRight(
      endOffset,
      `
const __returned__ = ${returned}
Object.defineProperty(__returned__, '__isScriptSetup', { enumerable: false, value: true })
return __returned__
}

`
    );
  } else {
    s.appendRight(endOffset, `
return ${returned}
}

`);
  }
  let runtimeOptions = ``;
  if (!hasDefaultExportName && filename && filename !== DEFAULT_FILENAME) {
    const match = filename.match(/([^/\\]+)\.\w+$/);
    if (match) {
      runtimeOptions += `
  __name: '${match[1]}',`;
    }
  }
  if (hasInlinedSsrRenderFn) {
    runtimeOptions += `
  __ssrInlineRender: true,`;
  }
  if (propsRuntimeDecl) {
    let declCode = scriptSetup.content.slice(propsRuntimeDecl.start, propsRuntimeDecl.end).trim();
    if (propsDestructureDecl) {
      const defaults = [];
      for (const key in propsDestructuredBindings) {
        const d = genDestructuredDefaultValue(key);
        if (d)
          defaults.push(`${key}: ${d}`);
      }
      if (defaults.length) {
        declCode = `${helper(
          `mergeDefaults`
        )}(${declCode}, {
  ${defaults.join(",\n  ")}
})`;
      }
    }
    runtimeOptions += `
  props: ${declCode},`;
  } else if (propsTypeDecl) {
    runtimeOptions += genRuntimeProps(typeDeclaredProps);
  }
  if (emitsRuntimeDecl) {
    runtimeOptions += `
  emits: ${scriptSetup.content.slice(emitsRuntimeDecl.start, emitsRuntimeDecl.end).trim()},`;
  } else if (emitsTypeDecl) {
    runtimeOptions += genRuntimeEmits(typeDeclaredEmits);
  }
  const exposeCall = hasDefineExposeCall || options.inlineTemplate ? `` : `  expose();
`;
  if (isTS) {
    const def = defaultExport ? `
  ...${DEFAULT_VAR},` : ``;
    s.prependLeft(
      startOffset,
      `
export default /*#__PURE__*/${helper(
        `defineComponent`
      )}({${def}${runtimeOptions}
  ${hasAwait ? `async ` : ``}setup(${args}) {
${exposeCall}`
    );
    s.appendRight(endOffset, `})`);
  } else {
    if (defaultExport) {
      s.prependLeft(
        startOffset,
        `
export default /*#__PURE__*/Object.assign(${DEFAULT_VAR}, {${runtimeOptions}
  ${hasAwait ? `async ` : ``}setup(${args}) {
${exposeCall}`
      );
      s.appendRight(endOffset, `})`);
    } else {
      s.prependLeft(
        startOffset,
        `
export default {${runtimeOptions}
  ${hasAwait ? `async ` : ``}setup(${args}) {
${exposeCall}`
      );
      s.appendRight(endOffset, `}`);
    }
  }
  if (helperImports.size > 0) {
    s.prepend(
      `import { ${[...helperImports].map((h) => `${h} as _${h}`).join(", ")} } from 'vue'
`
    );
  }
  s.trim();
  return {
    ...scriptSetup,
    bindings: bindingMetadata,
    imports: userImports,
    content: s.toString(),
    map: genSourceMap ? s.generateMap({
      source: filename,
      hires: true,
      includeContent: true
    }) : void 0,
    scriptAst: scriptAst == null ? void 0 : scriptAst.body,
    scriptSetupAst: scriptSetupAst == null ? void 0 : scriptSetupAst.body
  };
}
function registerBinding(bindings, node, type) {
  bindings[node.name] = type;
}
function walkDeclaration(node, bindings, userImportAliases) {
  if (node.type === "VariableDeclaration") {
    const isConst = node.kind === "const";
    for (const { id, init } of node.declarations) {
      const isDefineCall = !!(isConst && isCallOf(
        init,
        (c) => c === DEFINE_PROPS || c === DEFINE_EMITS || c === WITH_DEFAULTS
      ));
      if (id.type === "Identifier") {
        let bindingType;
        const userReactiveBinding = userImportAliases["reactive"];
        if (isCallOf(init, userReactiveBinding)) {
          bindingType = isConst ? "setup-reactive-const" : "setup-let";
        } else if (
          // if a declaration is a const literal, we can mark it so that
          // the generated render fn code doesn't need to unref() it
          isDefineCall || isConst && canNeverBeRef(init, userReactiveBinding)
        ) {
          bindingType = isCallOf(init, DEFINE_PROPS) ? "setup-reactive-const" : "setup-const";
        } else if (isConst) {
          if (isCallOf(init, userImportAliases["ref"])) {
            bindingType = "setup-ref";
          } else {
            bindingType = "setup-maybe-ref";
          }
        } else {
          bindingType = "setup-let";
        }
        registerBinding(bindings, id, bindingType);
      } else {
        if (isCallOf(init, DEFINE_PROPS)) {
          continue;
        }
        if (id.type === "ObjectPattern") {
          walkObjectPattern(id, bindings, isConst, isDefineCall);
        } else if (id.type === "ArrayPattern") {
          walkArrayPattern(id, bindings, isConst, isDefineCall);
        }
      }
    }
  } else if (node.type === "TSEnumDeclaration" || node.type === "FunctionDeclaration" || node.type === "ClassDeclaration") {
    bindings[node.id.name] = "setup-const";
  }
}
function walkObjectPattern(node, bindings, isConst, isDefineCall = false) {
  for (const p of node.properties) {
    if (p.type === "ObjectProperty") {
      if (p.key.type === "Identifier" && p.key === p.value) {
        const type = isDefineCall ? "setup-const" : isConst ? "setup-maybe-ref" : "setup-let";
        registerBinding(bindings, p.key, type);
      } else {
        walkPattern(p.value, bindings, isConst, isDefineCall);
      }
    } else {
      const type = isConst ? "setup-const" : "setup-let";
      registerBinding(bindings, p.argument, type);
    }
  }
}
function walkArrayPattern(node, bindings, isConst, isDefineCall = false) {
  for (const e of node.elements) {
    e && walkPattern(e, bindings, isConst, isDefineCall);
  }
}
function walkPattern(node, bindings, isConst, isDefineCall = false) {
  if (node.type === "Identifier") {
    const type = isDefineCall ? "setup-const" : isConst ? "setup-maybe-ref" : "setup-let";
    registerBinding(bindings, node, type);
  } else if (node.type === "RestElement") {
    const type = isConst ? "setup-const" : "setup-let";
    registerBinding(bindings, node.argument, type);
  } else if (node.type === "ObjectPattern") {
    walkObjectPattern(node, bindings, isConst);
  } else if (node.type === "ArrayPattern") {
    walkArrayPattern(node, bindings, isConst);
  } else if (node.type === "AssignmentPattern") {
    if (node.left.type === "Identifier") {
      const type = isDefineCall ? "setup-const" : isConst ? "setup-maybe-ref" : "setup-let";
      registerBinding(bindings, node.left, type);
    } else {
      walkPattern(node.left, bindings, isConst);
    }
  }
}
function recordType(node, declaredTypes) {
  if (node.type === "TSInterfaceDeclaration") {
    declaredTypes[node.id.name] = [`Object`];
  } else if (node.type === "TSTypeAliasDeclaration") {
    declaredTypes[node.id.name] = inferRuntimeType(
      node.typeAnnotation,
      declaredTypes
    );
  } else if (node.type === "ExportNamedDeclaration" && node.declaration) {
    recordType(node.declaration, declaredTypes);
  }
}
function extractRuntimeProps(node, props, declaredTypes, isProd) {
  const members = node.type === "TSTypeLiteral" ? node.members : node.body;
  for (const m of members) {
    if ((m.type === "TSPropertySignature" || m.type === "TSMethodSignature") && m.key.type === "Identifier") {
      let type;
      if (m.type === "TSMethodSignature") {
        type = ["Function"];
      } else if (m.typeAnnotation) {
        type = inferRuntimeType(m.typeAnnotation.typeAnnotation, declaredTypes);
      }
      props[m.key.name] = {
        key: m.key.name,
        required: !m.optional,
        type: type || [`null`]
      };
    }
  }
}
function inferRuntimeType(node, declaredTypes) {
  switch (node.type) {
    case "TSStringKeyword":
      return ["String"];
    case "TSNumberKeyword":
      return ["Number"];
    case "TSBooleanKeyword":
      return ["Boolean"];
    case "TSObjectKeyword":
      return ["Object"];
    case "TSTypeLiteral":
      return ["Object"];
    case "TSFunctionType":
      return ["Function"];
    case "TSArrayType":
    case "TSTupleType":
      return ["Array"];
    case "TSLiteralType":
      switch (node.literal.type) {
        case "StringLiteral":
          return ["String"];
        case "BooleanLiteral":
          return ["Boolean"];
        case "NumericLiteral":
        case "BigIntLiteral":
          return ["Number"];
        default:
          return [`null`];
      }
    case "TSTypeReference":
      if (node.typeName.type === "Identifier") {
        if (declaredTypes[node.typeName.name]) {
          return declaredTypes[node.typeName.name];
        }
        switch (node.typeName.name) {
          case "Array":
          case "Function":
          case "Object":
          case "Set":
          case "Map":
          case "WeakSet":
          case "WeakMap":
          case "Date":
          case "Promise":
            return [node.typeName.name];
          case "Record":
          case "Partial":
          case "Readonly":
          case "Pick":
          case "Omit":
          case "Exclude":
          case "Extract":
          case "Required":
          case "InstanceType":
            return ["Object"];
        }
      }
      return [`null`];
    case "TSParenthesizedType":
      return inferRuntimeType(node.typeAnnotation, declaredTypes);
    case "TSUnionType":
      return [
        ...new Set(
          [].concat(
            ...node.types.map((t) => inferRuntimeType(t, declaredTypes))
          )
        )
      ];
    case "TSIntersectionType":
      return ["Object"];
    case "TSSymbolKeyword":
      return ["Symbol"];
    default:
      return [`null`];
  }
}
function toRuntimeTypeString(types) {
  return types.length > 1 ? `[${types.join(", ")}]` : types[0];
}
function extractRuntimeEmits(node, emits) {
  if (node.type === "TSTypeLiteral" || node.type === "TSInterfaceBody") {
    const members = node.type === "TSTypeLiteral" ? node.members : node.body;
    for (let t of members) {
      if (t.type === "TSCallSignatureDeclaration") {
        extractEventNames(t.parameters[0], emits);
      }
    }
    return;
  } else {
    extractEventNames(node.parameters[0], emits);
  }
}
function extractEventNames(eventName, emits) {
  if (eventName.type === "Identifier" && eventName.typeAnnotation && eventName.typeAnnotation.type === "TSTypeAnnotation") {
    const typeNode = eventName.typeAnnotation.typeAnnotation;
    if (typeNode.type === "TSLiteralType") {
      if (typeNode.literal.type !== "UnaryExpression" && typeNode.literal.type !== "TemplateLiteral") {
        emits.add(String(typeNode.literal.value));
      }
    } else if (typeNode.type === "TSUnionType") {
      for (const t of typeNode.types) {
        if (t.type === "TSLiteralType" && t.literal.type !== "UnaryExpression" && t.literal.type !== "TemplateLiteral") {
          emits.add(String(t.literal.value));
        }
      }
    }
  }
}
function genRuntimeEmits(emits) {
  return emits.size ? `
  emits: [${Array.from(emits).map((p) => JSON.stringify(p)).join(", ")}],` : ``;
}
function isCallOf(node, test) {
  return !!(node && test && node.type === "CallExpression" && node.callee.type === "Identifier" && (typeof test === "string" ? node.callee.name === test : test(node.callee.name)));
}
function canNeverBeRef(node, userReactiveImport) {
  if (isCallOf(node, userReactiveImport)) {
    return true;
  }
  switch (node.type) {
    case "UnaryExpression":
    case "BinaryExpression":
    case "ArrayExpression":
    case "ObjectExpression":
    case "FunctionExpression":
    case "ArrowFunctionExpression":
    case "UpdateExpression":
    case "ClassExpression":
    case "TaggedTemplateExpression":
      return true;
    case "SequenceExpression":
      return canNeverBeRef(
        node.expressions[node.expressions.length - 1],
        userReactiveImport
      );
    default:
      if (node.type.endsWith("Literal")) {
        return true;
      }
      return false;
  }
}
function analyzeScriptBindings(ast) {
  for (const node of ast) {
    if (node.type === "ExportDefaultDeclaration" && node.declaration.type === "ObjectExpression") {
      return analyzeBindingsFromOptions(node.declaration);
    }
  }
  return {};
}
function analyzeBindingsFromOptions(node) {
  const bindings = {};
  Object.defineProperty(bindings, "__isScriptSetup", {
    enumerable: false,
    value: false
  });
  for (const property of node.properties) {
    if (property.type === "ObjectProperty" && !property.computed && property.key.type === "Identifier") {
      if (property.key.name === "props") {
        for (const key of getObjectOrArrayExpressionKeys(property.value)) {
          bindings[key] = "props";
        }
      } else if (property.key.name === "inject") {
        for (const key of getObjectOrArrayExpressionKeys(property.value)) {
          bindings[key] = "options";
        }
      } else if (property.value.type === "ObjectExpression" && (property.key.name === "computed" || property.key.name === "methods")) {
        for (const key of getObjectExpressionKeys(property.value)) {
          bindings[key] = "options";
        }
      }
    } else if (property.type === "ObjectMethod" && property.key.type === "Identifier" && (property.key.name === "setup" || property.key.name === "data")) {
      for (const bodyItem of property.body.body) {
        if (bodyItem.type === "ReturnStatement" && bodyItem.argument && bodyItem.argument.type === "ObjectExpression") {
          for (const key of getObjectExpressionKeys(bodyItem.argument)) {
            bindings[key] = property.key.name === "setup" ? "setup-maybe-ref" : "data";
          }
        }
      }
    }
  }
  return bindings;
}
function getObjectExpressionKeys(node) {
  const keys = [];
  for (const prop of node.properties) {
    if (prop.type === "SpreadElement")
      continue;
    const key = resolveObjectKey(prop.key, prop.computed);
    if (key)
      keys.push(String(key));
  }
  return keys;
}
function getArrayExpressionKeys(node) {
  const keys = [];
  for (const element of node.elements) {
    if (element && element.type === "StringLiteral") {
      keys.push(element.value);
    }
  }
  return keys;
}
function getObjectOrArrayExpressionKeys(value) {
  if (value.type === "ArrayExpression") {
    return getArrayExpressionKeys(value);
  }
  if (value.type === "ObjectExpression") {
    return getObjectExpressionKeys(value);
  }
  return [];
}
const templateUsageCheckCache = createCache();
function resolveTemplateUsageCheckString(sfc) {
  const { content, ast } = sfc.template;
  const cached = templateUsageCheckCache.get(content);
  if (cached) {
    return cached;
  }
  let code = "";
  CompilerDOM.transform(CompilerDOM.createRoot([ast]), {
    nodeTransforms: [
      (node) => {
        if (node.type === 1) {
          if (!CompilerDOM.parserOptions.isNativeTag(node.tag) && !CompilerDOM.parserOptions.isBuiltInComponent(node.tag)) {
            code += `,${shared.camelize(node.tag)},${shared.capitalize(shared.camelize(node.tag))}`;
          }
          for (let i = 0; i < node.props.length; i++) {
            const prop = node.props[i];
            if (prop.type === 7) {
              if (!isBuiltInDir(prop.name)) {
                code += `,v${shared.capitalize(shared.camelize(prop.name))}`;
              }
              if (prop.exp) {
                code += `,${processExp(
                  prop.exp.content,
                  prop.name
                )}`;
              }
            }
          }
        } else if (node.type === 5) {
          code += `,${processExp(
            node.content.content
          )}`;
        }
      }
    ]
  });
  code += ";";
  templateUsageCheckCache.set(content, code);
  return code;
}
const forAliasRE = /([\s\S]*?)\s+(?:in|of)\s+([\s\S]*)/;
function processExp(exp, dir) {
  if (/ as\s+\w|<.*>|:/.test(exp)) {
    if (dir === "slot") {
      exp = `(${exp})=>{}`;
    } else if (dir === "on") {
      exp = `()=>{return ${exp}}`;
    } else if (dir === "for") {
      const inMatch = exp.match(forAliasRE);
      if (inMatch) {
        const [, LHS, RHS] = inMatch;
        return processExp(`(${LHS})=>{}`) + processExp(RHS);
      }
    }
    let ret = "";
    const ast = parser$2.parseExpression(exp, { plugins: ["typescript"] });
    CompilerDOM.walkIdentifiers(ast, (node) => {
      ret += `,` + node.name;
    });
    return ret;
  }
  return stripStrings(exp);
}
function stripStrings(exp) {
  return exp.replace(/'[^']*'|"[^"]*"/g, "").replace(/`[^`]+`/g, stripTemplateString);
}
function stripTemplateString(str) {
  const interpMatch = str.match(/\${[^}]+}/g);
  if (interpMatch) {
    return interpMatch.map((m) => m.slice(2, -1)).join(",");
  }
  return "";
}
function isImportUsed(local, sfc) {
  return new RegExp(
    // #4274 escape $ since it's a special char in regex
    // (and is the only regex special char that is valid in identifiers)
    `[^\\w$_]${local.replace(/\$/g, "\\$")}[^\\w$_]`
  ).test(resolveTemplateUsageCheckString(sfc));
}
function hmrShouldReload(prevImports, next) {
  if (!next.scriptSetup || next.scriptSetup.lang !== "ts" && next.scriptSetup.lang !== "tsx") {
    return false;
  }
  for (const key in prevImports) {
    if (!prevImports[key].isUsedInTemplate && isImportUsed(key, next)) {
      return true;
    }
  }
  return false;
}
function resolveObjectKey(node, computed) {
  switch (node.type) {
    case "StringLiteral":
    case "NumericLiteral":
      return node.value;
    case "Identifier":
      if (!computed)
        return node.name;
  }
  return void 0;
}

const DEFAULT_FILENAME = "anonymous.vue";
const sourceToSFC = createCache();
function parse$2(source, {
  sourceMap = true,
  filename = DEFAULT_FILENAME,
  sourceRoot = "",
  pad = false,
  ignoreEmpty = true,
  compiler = CompilerDOM__namespace
} = {}) {
  const sourceKey = source + sourceMap + filename + sourceRoot + pad + compiler.parse;
  const cache = sourceToSFC.get(sourceKey);
  if (cache) {
    return cache;
  }
  const descriptor = {
    filename,
    source,
    template: null,
    script: null,
    scriptSetup: null,
    styles: [],
    customBlocks: [],
    cssVars: [],
    slotted: false,
    shouldForceReload: (prevImports) => hmrShouldReload(prevImports, descriptor)
  };
  const errors = [];
  const ast = compiler.parse(source, {
    // there are no components at SFC parsing level
    isNativeTag: () => true,
    // preserve all whitespaces
    isPreTag: () => true,
    getTextMode: ({ tag, props }, parent) => {
      if (!parent && tag !== "template" || // <template lang="xxx"> should also be treated as raw text
      tag === "template" && props.some(
        (p) => p.type === 6 && p.name === "lang" && p.value && p.value.content && p.value.content !== "html"
      )) {
        return 2;
      } else {
        return 0;
      }
    },
    onError: (e) => {
      errors.push(e);
    }
  });
  ast.children.forEach((node) => {
    if (node.type !== 1) {
      return;
    }
    if (ignoreEmpty && node.tag !== "template" && isEmpty(node) && !hasSrc(node)) {
      return;
    }
    switch (node.tag) {
      case "template":
        if (!descriptor.template) {
          const templateBlock = descriptor.template = createBlock(
            node,
            source,
            false
          );
          templateBlock.ast = node;
          if (templateBlock.attrs.functional) {
            const err = new SyntaxError(
              `<template functional> is no longer supported in Vue 3, since functional components no longer have significant performance difference from stateful ones. Just use a normal <template> instead.`
            );
            err.loc = node.props.find((p) => p.name === "functional").loc;
            errors.push(err);
          }
        } else {
          errors.push(createDuplicateBlockError(node));
        }
        break;
      case "script":
        const scriptBlock = createBlock(node, source, pad);
        const isSetup = !!scriptBlock.attrs.setup;
        if (isSetup && !descriptor.scriptSetup) {
          descriptor.scriptSetup = scriptBlock;
          break;
        }
        if (!isSetup && !descriptor.script) {
          descriptor.script = scriptBlock;
          break;
        }
        errors.push(createDuplicateBlockError(node, isSetup));
        break;
      case "style":
        const styleBlock = createBlock(node, source, pad);
        if (styleBlock.attrs.vars) {
          errors.push(
            new SyntaxError(
              `<style vars> has been replaced by a new proposal: https://github.com/vuejs/rfcs/pull/231`
            )
          );
        }
        descriptor.styles.push(styleBlock);
        break;
      default:
        descriptor.customBlocks.push(createBlock(node, source, pad));
        break;
    }
  });
  if (!descriptor.template && !descriptor.script && !descriptor.scriptSetup) {
    errors.push(
      new SyntaxError(
        `At least one <template> or <script> is required in a single file component.`
      )
    );
  }
  if (descriptor.scriptSetup) {
    if (descriptor.scriptSetup.src) {
      errors.push(
        new SyntaxError(
          `<script setup> cannot use the "src" attribute because its syntax will be ambiguous outside of the component.`
        )
      );
      descriptor.scriptSetup = null;
    }
    if (descriptor.script && descriptor.script.src) {
      errors.push(
        new SyntaxError(
          `<script> cannot use the "src" attribute when <script setup> is also present because they must be processed together.`
        )
      );
      descriptor.script = null;
    }
  }
  if (sourceMap) {
    const genMap = (block) => {
      if (block && !block.src) {
        block.map = generateSourceMap(
          filename,
          source,
          block.content,
          sourceRoot,
          !pad || block.type === "template" ? block.loc.start.line - 1 : 0
        );
      }
    };
    genMap(descriptor.template);
    genMap(descriptor.script);
    descriptor.styles.forEach(genMap);
    descriptor.customBlocks.forEach(genMap);
  }
  descriptor.cssVars = parseCssVars(descriptor);
  const slottedRE = /(?:::v-|:)slotted\(/;
  descriptor.slotted = descriptor.styles.some(
    (s) => s.scoped && slottedRE.test(s.content)
  );
  const result = {
    descriptor,
    errors
  };
  sourceToSFC.set(sourceKey, result);
  return result;
}
function createDuplicateBlockError(node, isScriptSetup = false) {
  const err = new SyntaxError(
    `Single file component can contain only one <${node.tag}${isScriptSetup ? ` setup` : ``}> element`
  );
  err.loc = node.loc;
  return err;
}
function createBlock(node, source, pad) {
  const type = node.tag;
  let { start, end } = node.loc;
  let content = "";
  if (node.children.length) {
    start = node.children[0].loc.start;
    end = node.children[node.children.length - 1].loc.end;
    content = source.slice(start.offset, end.offset);
  } else {
    const offset = node.loc.source.indexOf(`</`);
    if (offset > -1) {
      start = {
        line: start.line,
        column: start.column + offset,
        offset: start.offset + offset
      };
    }
    end = { ...start };
  }
  const loc = {
    source: content,
    start,
    end
  };
  const attrs = {};
  const block = {
    type,
    content,
    loc,
    attrs
  };
  if (pad) {
    block.content = padContent(source, block, pad) + block.content;
  }
  node.props.forEach((p) => {
    if (p.type === 6) {
      attrs[p.name] = p.value ? p.value.content || true : true;
      if (p.name === "lang") {
        block.lang = p.value && p.value.content;
      } else if (p.name === "src") {
        block.src = p.value && p.value.content;
      } else if (type === "style") {
        if (p.name === "scoped") {
          block.scoped = true;
        } else if (p.name === "module") {
          block.module = attrs[p.name];
        }
      } else if (type === "script" && p.name === "setup") {
        block.setup = attrs.setup;
      }
    }
  });
  return block;
}
const splitRE = /\r?\n/g;
const emptyRE = /^(?:\/\/)?\s*$/;
const replaceRE = /./g;
function generateSourceMap(filename, source, generated, sourceRoot, lineOffset) {
  const map = new require$$0$1.SourceMapGenerator({
    file: filename.replace(/\\/g, "/"),
    sourceRoot: sourceRoot.replace(/\\/g, "/")
  });
  map.setSourceContent(filename, source);
  generated.split(splitRE).forEach((line, index) => {
    if (!emptyRE.test(line)) {
      const originalLine = index + 1 + lineOffset;
      const generatedLine = index + 1;
      for (let i = 0; i < line.length; i++) {
        if (!/\s/.test(line[i])) {
          map.addMapping({
            source: filename,
            original: {
              line: originalLine,
              column: i
            },
            generated: {
              line: generatedLine,
              column: i
            }
          });
        }
      }
    }
  });
  return JSON.parse(map.toString());
}
function padContent(content, block, pad) {
  content = content.slice(0, block.loc.start.offset);
  if (pad === "space") {
    return content.replace(replaceRE, " ");
  } else {
    const offset = content.split(splitRE).length;
    const padChar = block.type === "script" && !block.lang ? "//\n" : "\n";
    return Array(offset).join(padChar);
  }
}
function hasSrc(node) {
  return node.props.some((p) => {
    if (p.type !== 6) {
      return false;
    }
    return p.name === "src";
  });
}
function isEmpty(node) {
  for (let i = 0; i < node.children.length; i++) {
    const child = node.children[i];
    if (child.type !== 2 || child.content.trim() !== "") {
      return false;
    }
  }
  return true;
}

const trimPlugin = () => {
  return {
    postcssPlugin: "vue-sfc-trim",
    Once(root) {
      root.walk(({ type, raws }) => {
        if (type === "rule" || type === "atrule") {
          if (raws.before)
            raws.before = "\n";
          if ("after" in raws && raws.after)
            raws.after = "\n";
        }
      });
    }
  };
};
trimPlugin.postcss = true;
var trimPlugin$1 = trimPlugin;

var distExports = {};
var dist = {
  get exports(){ return distExports; },
  set exports(v){ distExports = v; },
};

var processorExports = {};
var processor = {
  get exports(){ return processorExports; },
  set exports(v){ processorExports = v; },
};

var parserExports = {};
var parser$1 = {
  get exports(){ return parserExports; },
  set exports(v){ parserExports = v; },
};

var rootExports = {};
var root$2 = {
  get exports(){ return rootExports; },
  set exports(v){ rootExports = v; },
};

var containerExports = {};
var container = {
  get exports(){ return containerExports; },
  set exports(v){ containerExports = v; },
};

var nodeExports = {};
var node$1 = {
  get exports(){ return nodeExports; },
  set exports(v){ nodeExports = v; },
};

var util = {};

var unescExports = {};
var unesc = {
  get exports(){ return unescExports; },
  set exports(v){ unescExports = v; },
};

(function (module, exports) {

	exports.__esModule = true;
	exports["default"] = unesc;

	// Many thanks for this post which made this migration much easier.
	// https://mathiasbynens.be/notes/css-escapes

	/**
	 * 
	 * @param {string} str 
	 * @returns {[string, number]|undefined}
	 */
	function gobbleHex(str) {
	  var lower = str.toLowerCase();
	  var hex = '';
	  var spaceTerminated = false;

	  for (var i = 0; i < 6 && lower[i] !== undefined; i++) {
	    var code = lower.charCodeAt(i); // check to see if we are dealing with a valid hex char [a-f|0-9]

	    var valid = code >= 97 && code <= 102 || code >= 48 && code <= 57; // https://drafts.csswg.org/css-syntax/#consume-escaped-code-point

	    spaceTerminated = code === 32;

	    if (!valid) {
	      break;
	    }

	    hex += lower[i];
	  }

	  if (hex.length === 0) {
	    return undefined;
	  }

	  var codePoint = parseInt(hex, 16);
	  var isSurrogate = codePoint >= 0xD800 && codePoint <= 0xDFFF; // Add special case for
	  // "If this number is zero, or is for a surrogate, or is greater than the maximum allowed code point"
	  // https://drafts.csswg.org/css-syntax/#maximum-allowed-code-point

	  if (isSurrogate || codePoint === 0x0000 || codePoint > 0x10FFFF) {
	    return ["\uFFFD", hex.length + (spaceTerminated ? 1 : 0)];
	  }

	  return [String.fromCodePoint(codePoint), hex.length + (spaceTerminated ? 1 : 0)];
	}

	var CONTAINS_ESCAPE = /\\/;

	function unesc(str) {
	  var needToProcess = CONTAINS_ESCAPE.test(str);

	  if (!needToProcess) {
	    return str;
	  }

	  var ret = "";

	  for (var i = 0; i < str.length; i++) {
	    if (str[i] === "\\") {
	      var gobbled = gobbleHex(str.slice(i + 1, i + 7));

	      if (gobbled !== undefined) {
	        ret += gobbled[0];
	        i += gobbled[1];
	        continue;
	      } // Retain a pair of \\ if double escaped `\\\\`
	      // https://github.com/postcss/postcss-selector-parser/commit/268c9a7656fb53f543dc620aa5b73a30ec3ff20e


	      if (str[i + 1] === "\\") {
	        ret += "\\";
	        i++;
	        continue;
	      } // if \\ is at the end of the string retain it
	      // https://github.com/postcss/postcss-selector-parser/commit/01a6b346e3612ce1ab20219acc26abdc259ccefb


	      if (str.length === i + 1) {
	        ret += str[i];
	      }

	      continue;
	    }

	    ret += str[i];
	  }

	  return ret;
	}

	module.exports = exports.default;
} (unesc, unescExports));

var getPropExports = {};
var getProp = {
  get exports(){ return getPropExports; },
  set exports(v){ getPropExports = v; },
};

(function (module, exports) {

	exports.__esModule = true;
	exports["default"] = getProp;

	function getProp(obj) {
	  for (var _len = arguments.length, props = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
	    props[_key - 1] = arguments[_key];
	  }

	  while (props.length > 0) {
	    var prop = props.shift();

	    if (!obj[prop]) {
	      return undefined;
	    }

	    obj = obj[prop];
	  }

	  return obj;
	}

	module.exports = exports.default;
} (getProp, getPropExports));

var ensureObjectExports = {};
var ensureObject = {
  get exports(){ return ensureObjectExports; },
  set exports(v){ ensureObjectExports = v; },
};

(function (module, exports) {

	exports.__esModule = true;
	exports["default"] = ensureObject;

	function ensureObject(obj) {
	  for (var _len = arguments.length, props = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
	    props[_key - 1] = arguments[_key];
	  }

	  while (props.length > 0) {
	    var prop = props.shift();

	    if (!obj[prop]) {
	      obj[prop] = {};
	    }

	    obj = obj[prop];
	  }
	}

	module.exports = exports.default;
} (ensureObject, ensureObjectExports));

var stripCommentsExports = {};
var stripComments = {
  get exports(){ return stripCommentsExports; },
  set exports(v){ stripCommentsExports = v; },
};

(function (module, exports) {

	exports.__esModule = true;
	exports["default"] = stripComments;

	function stripComments(str) {
	  var s = "";
	  var commentStart = str.indexOf("/*");
	  var lastEnd = 0;

	  while (commentStart >= 0) {
	    s = s + str.slice(lastEnd, commentStart);
	    var commentEnd = str.indexOf("*/", commentStart + 2);

	    if (commentEnd < 0) {
	      return s;
	    }

	    lastEnd = commentEnd + 2;
	    commentStart = str.indexOf("/*", lastEnd);
	  }

	  s = s + str.slice(lastEnd);
	  return s;
	}

	module.exports = exports.default;
} (stripComments, stripCommentsExports));

util.__esModule = true;
util.stripComments = util.ensureObject = util.getProp = util.unesc = void 0;

var _unesc = _interopRequireDefault$6(unescExports);

util.unesc = _unesc["default"];

var _getProp = _interopRequireDefault$6(getPropExports);

util.getProp = _getProp["default"];

var _ensureObject = _interopRequireDefault$6(ensureObjectExports);

util.ensureObject = _ensureObject["default"];

var _stripComments = _interopRequireDefault$6(stripCommentsExports);

util.stripComments = _stripComments["default"];

function _interopRequireDefault$6(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

(function (module, exports) {

	exports.__esModule = true;
	exports["default"] = void 0;

	var _util = util;

	function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

	function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

	var cloneNode = function cloneNode(obj, parent) {
	  if (typeof obj !== 'object' || obj === null) {
	    return obj;
	  }

	  var cloned = new obj.constructor();

	  for (var i in obj) {
	    if (!obj.hasOwnProperty(i)) {
	      continue;
	    }

	    var value = obj[i];
	    var type = typeof value;

	    if (i === 'parent' && type === 'object') {
	      if (parent) {
	        cloned[i] = parent;
	      }
	    } else if (value instanceof Array) {
	      cloned[i] = value.map(function (j) {
	        return cloneNode(j, cloned);
	      });
	    } else {
	      cloned[i] = cloneNode(value, cloned);
	    }
	  }

	  return cloned;
	};

	var Node = /*#__PURE__*/function () {
	  function Node(opts) {
	    if (opts === void 0) {
	      opts = {};
	    }

	    Object.assign(this, opts);
	    this.spaces = this.spaces || {};
	    this.spaces.before = this.spaces.before || '';
	    this.spaces.after = this.spaces.after || '';
	  }

	  var _proto = Node.prototype;

	  _proto.remove = function remove() {
	    if (this.parent) {
	      this.parent.removeChild(this);
	    }

	    this.parent = undefined;
	    return this;
	  };

	  _proto.replaceWith = function replaceWith() {
	    if (this.parent) {
	      for (var index in arguments) {
	        this.parent.insertBefore(this, arguments[index]);
	      }

	      this.remove();
	    }

	    return this;
	  };

	  _proto.next = function next() {
	    return this.parent.at(this.parent.index(this) + 1);
	  };

	  _proto.prev = function prev() {
	    return this.parent.at(this.parent.index(this) - 1);
	  };

	  _proto.clone = function clone(overrides) {
	    if (overrides === void 0) {
	      overrides = {};
	    }

	    var cloned = cloneNode(this);

	    for (var name in overrides) {
	      cloned[name] = overrides[name];
	    }

	    return cloned;
	  }
	  /**
	   * Some non-standard syntax doesn't follow normal escaping rules for css.
	   * This allows non standard syntax to be appended to an existing property
	   * by specifying the escaped value. By specifying the escaped value,
	   * illegal characters are allowed to be directly inserted into css output.
	   * @param {string} name the property to set
	   * @param {any} value the unescaped value of the property
	   * @param {string} valueEscaped optional. the escaped value of the property.
	   */
	  ;

	  _proto.appendToPropertyAndEscape = function appendToPropertyAndEscape(name, value, valueEscaped) {
	    if (!this.raws) {
	      this.raws = {};
	    }

	    var originalValue = this[name];
	    var originalEscaped = this.raws[name];
	    this[name] = originalValue + value; // this may trigger a setter that updates raws, so it has to be set first.

	    if (originalEscaped || valueEscaped !== value) {
	      this.raws[name] = (originalEscaped || originalValue) + valueEscaped;
	    } else {
	      delete this.raws[name]; // delete any escaped value that was created by the setter.
	    }
	  }
	  /**
	   * Some non-standard syntax doesn't follow normal escaping rules for css.
	   * This allows the escaped value to be specified directly, allowing illegal
	   * characters to be directly inserted into css output.
	   * @param {string} name the property to set
	   * @param {any} value the unescaped value of the property
	   * @param {string} valueEscaped the escaped value of the property.
	   */
	  ;

	  _proto.setPropertyAndEscape = function setPropertyAndEscape(name, value, valueEscaped) {
	    if (!this.raws) {
	      this.raws = {};
	    }

	    this[name] = value; // this may trigger a setter that updates raws, so it has to be set first.

	    this.raws[name] = valueEscaped;
	  }
	  /**
	   * When you want a value to passed through to CSS directly. This method
	   * deletes the corresponding raw value causing the stringifier to fallback
	   * to the unescaped value.
	   * @param {string} name the property to set.
	   * @param {any} value The value that is both escaped and unescaped.
	   */
	  ;

	  _proto.setPropertyWithoutEscape = function setPropertyWithoutEscape(name, value) {
	    this[name] = value; // this may trigger a setter that updates raws, so it has to be set first.

	    if (this.raws) {
	      delete this.raws[name];
	    }
	  }
	  /**
	   *
	   * @param {number} line The number (starting with 1)
	   * @param {number} column The column number (starting with 1)
	   */
	  ;

	  _proto.isAtPosition = function isAtPosition(line, column) {
	    if (this.source && this.source.start && this.source.end) {
	      if (this.source.start.line > line) {
	        return false;
	      }

	      if (this.source.end.line < line) {
	        return false;
	      }

	      if (this.source.start.line === line && this.source.start.column > column) {
	        return false;
	      }

	      if (this.source.end.line === line && this.source.end.column < column) {
	        return false;
	      }

	      return true;
	    }

	    return undefined;
	  };

	  _proto.stringifyProperty = function stringifyProperty(name) {
	    return this.raws && this.raws[name] || this[name];
	  };

	  _proto.valueToString = function valueToString() {
	    return String(this.stringifyProperty("value"));
	  };

	  _proto.toString = function toString() {
	    return [this.rawSpaceBefore, this.valueToString(), this.rawSpaceAfter].join('');
	  };

	  _createClass(Node, [{
	    key: "rawSpaceBefore",
	    get: function get() {
	      var rawSpace = this.raws && this.raws.spaces && this.raws.spaces.before;

	      if (rawSpace === undefined) {
	        rawSpace = this.spaces && this.spaces.before;
	      }

	      return rawSpace || "";
	    },
	    set: function set(raw) {
	      (0, _util.ensureObject)(this, "raws", "spaces");
	      this.raws.spaces.before = raw;
	    }
	  }, {
	    key: "rawSpaceAfter",
	    get: function get() {
	      var rawSpace = this.raws && this.raws.spaces && this.raws.spaces.after;

	      if (rawSpace === undefined) {
	        rawSpace = this.spaces.after;
	      }

	      return rawSpace || "";
	    },
	    set: function set(raw) {
	      (0, _util.ensureObject)(this, "raws", "spaces");
	      this.raws.spaces.after = raw;
	    }
	  }]);

	  return Node;
	}();

	exports["default"] = Node;
	module.exports = exports.default;
} (node$1, nodeExports));

var types = {};

types.__esModule = true;
types.UNIVERSAL = types.ATTRIBUTE = types.CLASS = types.COMBINATOR = types.COMMENT = types.ID = types.NESTING = types.PSEUDO = types.ROOT = types.SELECTOR = types.STRING = types.TAG = void 0;
var TAG = 'tag';
types.TAG = TAG;
var STRING = 'string';
types.STRING = STRING;
var SELECTOR = 'selector';
types.SELECTOR = SELECTOR;
var ROOT = 'root';
types.ROOT = ROOT;
var PSEUDO = 'pseudo';
types.PSEUDO = PSEUDO;
var NESTING = 'nesting';
types.NESTING = NESTING;
var ID = 'id';
types.ID = ID;
var COMMENT = 'comment';
types.COMMENT = COMMENT;
var COMBINATOR = 'combinator';
types.COMBINATOR = COMBINATOR;
var CLASS = 'class';
types.CLASS = CLASS;
var ATTRIBUTE = 'attribute';
types.ATTRIBUTE = ATTRIBUTE;
var UNIVERSAL = 'universal';
types.UNIVERSAL = UNIVERSAL;

(function (module, exports) {

	exports.__esModule = true;
	exports["default"] = void 0;

	var _node = _interopRequireDefault(nodeExports);

	var types$1 = _interopRequireWildcard(types);

	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

	function _createForOfIteratorHelperLoose(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; return function () { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } it = o[Symbol.iterator](); return it.next.bind(it); }

	function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

	function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

	function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

	function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

	function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

	function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

	var Container = /*#__PURE__*/function (_Node) {
	  _inheritsLoose(Container, _Node);

	  function Container(opts) {
	    var _this;

	    _this = _Node.call(this, opts) || this;

	    if (!_this.nodes) {
	      _this.nodes = [];
	    }

	    return _this;
	  }

	  var _proto = Container.prototype;

	  _proto.append = function append(selector) {
	    selector.parent = this;
	    this.nodes.push(selector);
	    return this;
	  };

	  _proto.prepend = function prepend(selector) {
	    selector.parent = this;
	    this.nodes.unshift(selector);
	    return this;
	  };

	  _proto.at = function at(index) {
	    return this.nodes[index];
	  };

	  _proto.index = function index(child) {
	    if (typeof child === 'number') {
	      return child;
	    }

	    return this.nodes.indexOf(child);
	  };

	  _proto.removeChild = function removeChild(child) {
	    child = this.index(child);
	    this.at(child).parent = undefined;
	    this.nodes.splice(child, 1);
	    var index;

	    for (var id in this.indexes) {
	      index = this.indexes[id];

	      if (index >= child) {
	        this.indexes[id] = index - 1;
	      }
	    }

	    return this;
	  };

	  _proto.removeAll = function removeAll() {
	    for (var _iterator = _createForOfIteratorHelperLoose(this.nodes), _step; !(_step = _iterator()).done;) {
	      var node = _step.value;
	      node.parent = undefined;
	    }

	    this.nodes = [];
	    return this;
	  };

	  _proto.empty = function empty() {
	    return this.removeAll();
	  };

	  _proto.insertAfter = function insertAfter(oldNode, newNode) {
	    newNode.parent = this;
	    var oldIndex = this.index(oldNode);
	    this.nodes.splice(oldIndex + 1, 0, newNode);
	    newNode.parent = this;
	    var index;

	    for (var id in this.indexes) {
	      index = this.indexes[id];

	      if (oldIndex <= index) {
	        this.indexes[id] = index + 1;
	      }
	    }

	    return this;
	  };

	  _proto.insertBefore = function insertBefore(oldNode, newNode) {
	    newNode.parent = this;
	    var oldIndex = this.index(oldNode);
	    this.nodes.splice(oldIndex, 0, newNode);
	    newNode.parent = this;
	    var index;

	    for (var id in this.indexes) {
	      index = this.indexes[id];

	      if (index <= oldIndex) {
	        this.indexes[id] = index + 1;
	      }
	    }

	    return this;
	  };

	  _proto._findChildAtPosition = function _findChildAtPosition(line, col) {
	    var found = undefined;
	    this.each(function (node) {
	      if (node.atPosition) {
	        var foundChild = node.atPosition(line, col);

	        if (foundChild) {
	          found = foundChild;
	          return false;
	        }
	      } else if (node.isAtPosition(line, col)) {
	        found = node;
	        return false;
	      }
	    });
	    return found;
	  }
	  /**
	   * Return the most specific node at the line and column number given.
	   * The source location is based on the original parsed location, locations aren't
	   * updated as selector nodes are mutated.
	   * 
	   * Note that this location is relative to the location of the first character
	   * of the selector, and not the location of the selector in the overall document
	   * when used in conjunction with postcss.
	   *
	   * If not found, returns undefined.
	   * @param {number} line The line number of the node to find. (1-based index)
	   * @param {number} col  The column number of the node to find. (1-based index)
	   */
	  ;

	  _proto.atPosition = function atPosition(line, col) {
	    if (this.isAtPosition(line, col)) {
	      return this._findChildAtPosition(line, col) || this;
	    } else {
	      return undefined;
	    }
	  };

	  _proto._inferEndPosition = function _inferEndPosition() {
	    if (this.last && this.last.source && this.last.source.end) {
	      this.source = this.source || {};
	      this.source.end = this.source.end || {};
	      Object.assign(this.source.end, this.last.source.end);
	    }
	  };

	  _proto.each = function each(callback) {
	    if (!this.lastEach) {
	      this.lastEach = 0;
	    }

	    if (!this.indexes) {
	      this.indexes = {};
	    }

	    this.lastEach++;
	    var id = this.lastEach;
	    this.indexes[id] = 0;

	    if (!this.length) {
	      return undefined;
	    }

	    var index, result;

	    while (this.indexes[id] < this.length) {
	      index = this.indexes[id];
	      result = callback(this.at(index), index);

	      if (result === false) {
	        break;
	      }

	      this.indexes[id] += 1;
	    }

	    delete this.indexes[id];

	    if (result === false) {
	      return false;
	    }
	  };

	  _proto.walk = function walk(callback) {
	    return this.each(function (node, i) {
	      var result = callback(node, i);

	      if (result !== false && node.length) {
	        result = node.walk(callback);
	      }

	      if (result === false) {
	        return false;
	      }
	    });
	  };

	  _proto.walkAttributes = function walkAttributes(callback) {
	    var _this2 = this;

	    return this.walk(function (selector) {
	      if (selector.type === types$1.ATTRIBUTE) {
	        return callback.call(_this2, selector);
	      }
	    });
	  };

	  _proto.walkClasses = function walkClasses(callback) {
	    var _this3 = this;

	    return this.walk(function (selector) {
	      if (selector.type === types$1.CLASS) {
	        return callback.call(_this3, selector);
	      }
	    });
	  };

	  _proto.walkCombinators = function walkCombinators(callback) {
	    var _this4 = this;

	    return this.walk(function (selector) {
	      if (selector.type === types$1.COMBINATOR) {
	        return callback.call(_this4, selector);
	      }
	    });
	  };

	  _proto.walkComments = function walkComments(callback) {
	    var _this5 = this;

	    return this.walk(function (selector) {
	      if (selector.type === types$1.COMMENT) {
	        return callback.call(_this5, selector);
	      }
	    });
	  };

	  _proto.walkIds = function walkIds(callback) {
	    var _this6 = this;

	    return this.walk(function (selector) {
	      if (selector.type === types$1.ID) {
	        return callback.call(_this6, selector);
	      }
	    });
	  };

	  _proto.walkNesting = function walkNesting(callback) {
	    var _this7 = this;

	    return this.walk(function (selector) {
	      if (selector.type === types$1.NESTING) {
	        return callback.call(_this7, selector);
	      }
	    });
	  };

	  _proto.walkPseudos = function walkPseudos(callback) {
	    var _this8 = this;

	    return this.walk(function (selector) {
	      if (selector.type === types$1.PSEUDO) {
	        return callback.call(_this8, selector);
	      }
	    });
	  };

	  _proto.walkTags = function walkTags(callback) {
	    var _this9 = this;

	    return this.walk(function (selector) {
	      if (selector.type === types$1.TAG) {
	        return callback.call(_this9, selector);
	      }
	    });
	  };

	  _proto.walkUniversals = function walkUniversals(callback) {
	    var _this10 = this;

	    return this.walk(function (selector) {
	      if (selector.type === types$1.UNIVERSAL) {
	        return callback.call(_this10, selector);
	      }
	    });
	  };

	  _proto.split = function split(callback) {
	    var _this11 = this;

	    var current = [];
	    return this.reduce(function (memo, node, index) {
	      var split = callback.call(_this11, node);
	      current.push(node);

	      if (split) {
	        memo.push(current);
	        current = [];
	      } else if (index === _this11.length - 1) {
	        memo.push(current);
	      }

	      return memo;
	    }, []);
	  };

	  _proto.map = function map(callback) {
	    return this.nodes.map(callback);
	  };

	  _proto.reduce = function reduce(callback, memo) {
	    return this.nodes.reduce(callback, memo);
	  };

	  _proto.every = function every(callback) {
	    return this.nodes.every(callback);
	  };

	  _proto.some = function some(callback) {
	    return this.nodes.some(callback);
	  };

	  _proto.filter = function filter(callback) {
	    return this.nodes.filter(callback);
	  };

	  _proto.sort = function sort(callback) {
	    return this.nodes.sort(callback);
	  };

	  _proto.toString = function toString() {
	    return this.map(String).join('');
	  };

	  _createClass(Container, [{
	    key: "first",
	    get: function get() {
	      return this.at(0);
	    }
	  }, {
	    key: "last",
	    get: function get() {
	      return this.at(this.length - 1);
	    }
	  }, {
	    key: "length",
	    get: function get() {
	      return this.nodes.length;
	    }
	  }]);

	  return Container;
	}(_node["default"]);

	exports["default"] = Container;
	module.exports = exports.default;
} (container, containerExports));

(function (module, exports) {

	exports.__esModule = true;
	exports["default"] = void 0;

	var _container = _interopRequireDefault(containerExports);

	var _types = types;

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

	function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

	function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

	function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

	function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

	var Root = /*#__PURE__*/function (_Container) {
	  _inheritsLoose(Root, _Container);

	  function Root(opts) {
	    var _this;

	    _this = _Container.call(this, opts) || this;
	    _this.type = _types.ROOT;
	    return _this;
	  }

	  var _proto = Root.prototype;

	  _proto.toString = function toString() {
	    var str = this.reduce(function (memo, selector) {
	      memo.push(String(selector));
	      return memo;
	    }, []).join(',');
	    return this.trailingComma ? str + ',' : str;
	  };

	  _proto.error = function error(message, options) {
	    if (this._error) {
	      return this._error(message, options);
	    } else {
	      return new Error(message);
	    }
	  };

	  _createClass(Root, [{
	    key: "errorGenerator",
	    set: function set(handler) {
	      this._error = handler;
	    }
	  }]);

	  return Root;
	}(_container["default"]);

	exports["default"] = Root;
	module.exports = exports.default;
} (root$2, rootExports));

var selectorExports = {};
var selector$1 = {
  get exports(){ return selectorExports; },
  set exports(v){ selectorExports = v; },
};

(function (module, exports) {

	exports.__esModule = true;
	exports["default"] = void 0;

	var _container = _interopRequireDefault(containerExports);

	var _types = types;

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

	function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

	function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

	var Selector = /*#__PURE__*/function (_Container) {
	  _inheritsLoose(Selector, _Container);

	  function Selector(opts) {
	    var _this;

	    _this = _Container.call(this, opts) || this;
	    _this.type = _types.SELECTOR;
	    return _this;
	  }

	  return Selector;
	}(_container["default"]);

	exports["default"] = Selector;
	module.exports = exports.default;
} (selector$1, selectorExports));

var classNameExports = {};
var className$1 = {
  get exports(){ return classNameExports; },
  set exports(v){ classNameExports = v; },
};

/*! https://mths.be/cssesc v3.0.0 by @mathias */

var object = {};
var hasOwnProperty$1 = object.hasOwnProperty;
var merge$2 = function merge(options, defaults) {
	if (!options) {
		return defaults;
	}
	var result = {};
	for (var key in defaults) {
		// `if (defaults.hasOwnProperty(key) { … }` is not needed here, since
		// only recognized option names are used.
		result[key] = hasOwnProperty$1.call(options, key) ? options[key] : defaults[key];
	}
	return result;
};

var regexAnySingleEscape = /[ -,\.\/:-@\[-\^`\{-~]/;
var regexSingleEscape = /[ -,\.\/:-@\[\]\^`\{-~]/;
var regexExcessiveSpaces = /(^|\\+)?(\\[A-F0-9]{1,6})\x20(?![a-fA-F0-9\x20])/g;

// https://mathiasbynens.be/notes/css-escapes#css
var cssesc = function cssesc(string, options) {
	options = merge$2(options, cssesc.options);
	if (options.quotes != 'single' && options.quotes != 'double') {
		options.quotes = 'single';
	}
	var quote = options.quotes == 'double' ? '"' : '\'';
	var isIdentifier = options.isIdentifier;

	var firstChar = string.charAt(0);
	var output = '';
	var counter = 0;
	var length = string.length;
	while (counter < length) {
		var character = string.charAt(counter++);
		var codePoint = character.charCodeAt();
		var value = void 0;
		// If it’s not a printable ASCII character…
		if (codePoint < 0x20 || codePoint > 0x7E) {
			if (codePoint >= 0xD800 && codePoint <= 0xDBFF && counter < length) {
				// It’s a high surrogate, and there is a next character.
				var extra = string.charCodeAt(counter++);
				if ((extra & 0xFC00) == 0xDC00) {
					// next character is low surrogate
					codePoint = ((codePoint & 0x3FF) << 10) + (extra & 0x3FF) + 0x10000;
				} else {
					// It’s an unmatched surrogate; only append this code unit, in case
					// the next code unit is the high surrogate of a surrogate pair.
					counter--;
				}
			}
			value = '\\' + codePoint.toString(16).toUpperCase() + ' ';
		} else {
			if (options.escapeEverything) {
				if (regexAnySingleEscape.test(character)) {
					value = '\\' + character;
				} else {
					value = '\\' + codePoint.toString(16).toUpperCase() + ' ';
				}
			} else if (/[\t\n\f\r\x0B]/.test(character)) {
				value = '\\' + codePoint.toString(16).toUpperCase() + ' ';
			} else if (character == '\\' || !isIdentifier && (character == '"' && quote == character || character == '\'' && quote == character) || isIdentifier && regexSingleEscape.test(character)) {
				value = '\\' + character;
			} else {
				value = character;
			}
		}
		output += value;
	}

	if (isIdentifier) {
		if (/^-[-\d]/.test(output)) {
			output = '\\-' + output.slice(1);
		} else if (/\d/.test(firstChar)) {
			output = '\\3' + firstChar + ' ' + output.slice(1);
		}
	}

	// Remove spaces after `\HEX` escapes that are not followed by a hex digit,
	// since they’re redundant. Note that this is only possible if the escape
	// sequence isn’t preceded by an odd number of backslashes.
	output = output.replace(regexExcessiveSpaces, function ($0, $1, $2) {
		if ($1 && $1.length % 2) {
			// It’s not safe to remove the space, so don’t.
			return $0;
		}
		// Strip the space.
		return ($1 || '') + $2;
	});

	if (!isIdentifier && options.wrap) {
		return quote + output + quote;
	}
	return output;
};

// Expose default options (so they can be overridden globally).
cssesc.options = {
	'escapeEverything': false,
	'isIdentifier': false,
	'quotes': 'single',
	'wrap': false
};

cssesc.version = '3.0.0';

var cssesc_1 = cssesc;

(function (module, exports) {

	exports.__esModule = true;
	exports["default"] = void 0;

	var _cssesc = _interopRequireDefault(cssesc_1);

	var _util = util;

	var _node = _interopRequireDefault(nodeExports);

	var _types = types;

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

	function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

	function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

	function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

	function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

	var ClassName = /*#__PURE__*/function (_Node) {
	  _inheritsLoose(ClassName, _Node);

	  function ClassName(opts) {
	    var _this;

	    _this = _Node.call(this, opts) || this;
	    _this.type = _types.CLASS;
	    _this._constructed = true;
	    return _this;
	  }

	  var _proto = ClassName.prototype;

	  _proto.valueToString = function valueToString() {
	    return '.' + _Node.prototype.valueToString.call(this);
	  };

	  _createClass(ClassName, [{
	    key: "value",
	    get: function get() {
	      return this._value;
	    },
	    set: function set(v) {
	      if (this._constructed) {
	        var escaped = (0, _cssesc["default"])(v, {
	          isIdentifier: true
	        });

	        if (escaped !== v) {
	          (0, _util.ensureObject)(this, "raws");
	          this.raws.value = escaped;
	        } else if (this.raws) {
	          delete this.raws.value;
	        }
	      }

	      this._value = v;
	    }
	  }]);

	  return ClassName;
	}(_node["default"]);

	exports["default"] = ClassName;
	module.exports = exports.default;
} (className$1, classNameExports));

var commentExports = {};
var comment$2 = {
  get exports(){ return commentExports; },
  set exports(v){ commentExports = v; },
};

(function (module, exports) {

	exports.__esModule = true;
	exports["default"] = void 0;

	var _node = _interopRequireDefault(nodeExports);

	var _types = types;

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

	function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

	function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

	var Comment = /*#__PURE__*/function (_Node) {
	  _inheritsLoose(Comment, _Node);

	  function Comment(opts) {
	    var _this;

	    _this = _Node.call(this, opts) || this;
	    _this.type = _types.COMMENT;
	    return _this;
	  }

	  return Comment;
	}(_node["default"]);

	exports["default"] = Comment;
	module.exports = exports.default;
} (comment$2, commentExports));

var idExports = {};
var id$1 = {
  get exports(){ return idExports; },
  set exports(v){ idExports = v; },
};

(function (module, exports) {

	exports.__esModule = true;
	exports["default"] = void 0;

	var _node = _interopRequireDefault(nodeExports);

	var _types = types;

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

	function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

	function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

	var ID = /*#__PURE__*/function (_Node) {
	  _inheritsLoose(ID, _Node);

	  function ID(opts) {
	    var _this;

	    _this = _Node.call(this, opts) || this;
	    _this.type = _types.ID;
	    return _this;
	  }

	  var _proto = ID.prototype;

	  _proto.valueToString = function valueToString() {
	    return '#' + _Node.prototype.valueToString.call(this);
	  };

	  return ID;
	}(_node["default"]);

	exports["default"] = ID;
	module.exports = exports.default;
} (id$1, idExports));

var tagExports = {};
var tag$1 = {
  get exports(){ return tagExports; },
  set exports(v){ tagExports = v; },
};

var namespaceExports = {};
var namespace = {
  get exports(){ return namespaceExports; },
  set exports(v){ namespaceExports = v; },
};

(function (module, exports) {

	exports.__esModule = true;
	exports["default"] = void 0;

	var _cssesc = _interopRequireDefault(cssesc_1);

	var _util = util;

	var _node = _interopRequireDefault(nodeExports);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

	function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

	function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

	function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

	function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

	var Namespace = /*#__PURE__*/function (_Node) {
	  _inheritsLoose(Namespace, _Node);

	  function Namespace() {
	    return _Node.apply(this, arguments) || this;
	  }

	  var _proto = Namespace.prototype;

	  _proto.qualifiedName = function qualifiedName(value) {
	    if (this.namespace) {
	      return this.namespaceString + "|" + value;
	    } else {
	      return value;
	    }
	  };

	  _proto.valueToString = function valueToString() {
	    return this.qualifiedName(_Node.prototype.valueToString.call(this));
	  };

	  _createClass(Namespace, [{
	    key: "namespace",
	    get: function get() {
	      return this._namespace;
	    },
	    set: function set(namespace) {
	      if (namespace === true || namespace === "*" || namespace === "&") {
	        this._namespace = namespace;

	        if (this.raws) {
	          delete this.raws.namespace;
	        }

	        return;
	      }

	      var escaped = (0, _cssesc["default"])(namespace, {
	        isIdentifier: true
	      });
	      this._namespace = namespace;

	      if (escaped !== namespace) {
	        (0, _util.ensureObject)(this, "raws");
	        this.raws.namespace = escaped;
	      } else if (this.raws) {
	        delete this.raws.namespace;
	      }
	    }
	  }, {
	    key: "ns",
	    get: function get() {
	      return this._namespace;
	    },
	    set: function set(namespace) {
	      this.namespace = namespace;
	    }
	  }, {
	    key: "namespaceString",
	    get: function get() {
	      if (this.namespace) {
	        var ns = this.stringifyProperty("namespace");

	        if (ns === true) {
	          return '';
	        } else {
	          return ns;
	        }
	      } else {
	        return '';
	      }
	    }
	  }]);

	  return Namespace;
	}(_node["default"]);

	exports["default"] = Namespace;
	module.exports = exports.default;
} (namespace, namespaceExports));

(function (module, exports) {

	exports.__esModule = true;
	exports["default"] = void 0;

	var _namespace = _interopRequireDefault(namespaceExports);

	var _types = types;

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

	function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

	function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

	var Tag = /*#__PURE__*/function (_Namespace) {
	  _inheritsLoose(Tag, _Namespace);

	  function Tag(opts) {
	    var _this;

	    _this = _Namespace.call(this, opts) || this;
	    _this.type = _types.TAG;
	    return _this;
	  }

	  return Tag;
	}(_namespace["default"]);

	exports["default"] = Tag;
	module.exports = exports.default;
} (tag$1, tagExports));

var stringExports = {};
var string$1 = {
  get exports(){ return stringExports; },
  set exports(v){ stringExports = v; },
};

(function (module, exports) {

	exports.__esModule = true;
	exports["default"] = void 0;

	var _node = _interopRequireDefault(nodeExports);

	var _types = types;

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

	function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

	function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

	var String = /*#__PURE__*/function (_Node) {
	  _inheritsLoose(String, _Node);

	  function String(opts) {
	    var _this;

	    _this = _Node.call(this, opts) || this;
	    _this.type = _types.STRING;
	    return _this;
	  }

	  return String;
	}(_node["default"]);

	exports["default"] = String;
	module.exports = exports.default;
} (string$1, stringExports));

var pseudoExports = {};
var pseudo$1 = {
  get exports(){ return pseudoExports; },
  set exports(v){ pseudoExports = v; },
};

(function (module, exports) {

	exports.__esModule = true;
	exports["default"] = void 0;

	var _container = _interopRequireDefault(containerExports);

	var _types = types;

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

	function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

	function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

	var Pseudo = /*#__PURE__*/function (_Container) {
	  _inheritsLoose(Pseudo, _Container);

	  function Pseudo(opts) {
	    var _this;

	    _this = _Container.call(this, opts) || this;
	    _this.type = _types.PSEUDO;
	    return _this;
	  }

	  var _proto = Pseudo.prototype;

	  _proto.toString = function toString() {
	    var params = this.length ? '(' + this.map(String).join(',') + ')' : '';
	    return [this.rawSpaceBefore, this.stringifyProperty("value"), params, this.rawSpaceAfter].join('');
	  };

	  return Pseudo;
	}(_container["default"]);

	exports["default"] = Pseudo;
	module.exports = exports.default;
} (pseudo$1, pseudoExports));

var attribute$1 = {};

/**
 * For Node.js, simply re-export the core `util.deprecate` function.
 */

var node = require$$2.deprecate;

(function (exports) {

	exports.__esModule = true;
	exports.unescapeValue = unescapeValue;
	exports["default"] = void 0;

	var _cssesc = _interopRequireDefault(cssesc_1);

	var _unesc = _interopRequireDefault(unescExports);

	var _namespace = _interopRequireDefault(namespaceExports);

	var _types = types;

	var _CSSESC_QUOTE_OPTIONS;

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

	function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

	function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

	function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

	function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

	var deprecate = node;

	var WRAPPED_IN_QUOTES = /^('|")([^]*)\1$/;
	var warnOfDeprecatedValueAssignment = deprecate(function () {}, "Assigning an attribute a value containing characters that might need to be escaped is deprecated. " + "Call attribute.setValue() instead.");
	var warnOfDeprecatedQuotedAssignment = deprecate(function () {}, "Assigning attr.quoted is deprecated and has no effect. Assign to attr.quoteMark instead.");
	var warnOfDeprecatedConstructor = deprecate(function () {}, "Constructing an Attribute selector with a value without specifying quoteMark is deprecated. Note: The value should be unescaped now.");

	function unescapeValue(value) {
	  var deprecatedUsage = false;
	  var quoteMark = null;
	  var unescaped = value;
	  var m = unescaped.match(WRAPPED_IN_QUOTES);

	  if (m) {
	    quoteMark = m[1];
	    unescaped = m[2];
	  }

	  unescaped = (0, _unesc["default"])(unescaped);

	  if (unescaped !== value) {
	    deprecatedUsage = true;
	  }

	  return {
	    deprecatedUsage: deprecatedUsage,
	    unescaped: unescaped,
	    quoteMark: quoteMark
	  };
	}

	function handleDeprecatedContructorOpts(opts) {
	  if (opts.quoteMark !== undefined) {
	    return opts;
	  }

	  if (opts.value === undefined) {
	    return opts;
	  }

	  warnOfDeprecatedConstructor();

	  var _unescapeValue = unescapeValue(opts.value),
	      quoteMark = _unescapeValue.quoteMark,
	      unescaped = _unescapeValue.unescaped;

	  if (!opts.raws) {
	    opts.raws = {};
	  }

	  if (opts.raws.value === undefined) {
	    opts.raws.value = opts.value;
	  }

	  opts.value = unescaped;
	  opts.quoteMark = quoteMark;
	  return opts;
	}

	var Attribute = /*#__PURE__*/function (_Namespace) {
	  _inheritsLoose(Attribute, _Namespace);

	  function Attribute(opts) {
	    var _this;

	    if (opts === void 0) {
	      opts = {};
	    }

	    _this = _Namespace.call(this, handleDeprecatedContructorOpts(opts)) || this;
	    _this.type = _types.ATTRIBUTE;
	    _this.raws = _this.raws || {};
	    Object.defineProperty(_this.raws, 'unquoted', {
	      get: deprecate(function () {
	        return _this.value;
	      }, "attr.raws.unquoted is deprecated. Call attr.value instead."),
	      set: deprecate(function () {
	        return _this.value;
	      }, "Setting attr.raws.unquoted is deprecated and has no effect. attr.value is unescaped by default now.")
	    });
	    _this._constructed = true;
	    return _this;
	  }
	  /**
	   * Returns the Attribute's value quoted such that it would be legal to use
	   * in the value of a css file. The original value's quotation setting
	   * used for stringification is left unchanged. See `setValue(value, options)`
	   * if you want to control the quote settings of a new value for the attribute.
	   *
	   * You can also change the quotation used for the current value by setting quoteMark.
	   *
	   * Options:
	   *   * quoteMark {'"' | "'" | null} - Use this value to quote the value. If this
	   *     option is not set, the original value for quoteMark will be used. If
	   *     indeterminate, a double quote is used. The legal values are:
	   *     * `null` - the value will be unquoted and characters will be escaped as necessary.
	   *     * `'` - the value will be quoted with a single quote and single quotes are escaped.
	   *     * `"` - the value will be quoted with a double quote and double quotes are escaped.
	   *   * preferCurrentQuoteMark {boolean} - if true, prefer the source quote mark
	   *     over the quoteMark option value.
	   *   * smart {boolean} - if true, will select a quote mark based on the value
	   *     and the other options specified here. See the `smartQuoteMark()`
	   *     method.
	   **/


	  var _proto = Attribute.prototype;

	  _proto.getQuotedValue = function getQuotedValue(options) {
	    if (options === void 0) {
	      options = {};
	    }

	    var quoteMark = this._determineQuoteMark(options);

	    var cssescopts = CSSESC_QUOTE_OPTIONS[quoteMark];
	    var escaped = (0, _cssesc["default"])(this._value, cssescopts);
	    return escaped;
	  };

	  _proto._determineQuoteMark = function _determineQuoteMark(options) {
	    return options.smart ? this.smartQuoteMark(options) : this.preferredQuoteMark(options);
	  }
	  /**
	   * Set the unescaped value with the specified quotation options. The value
	   * provided must not include any wrapping quote marks -- those quotes will
	   * be interpreted as part of the value and escaped accordingly.
	   */
	  ;

	  _proto.setValue = function setValue(value, options) {
	    if (options === void 0) {
	      options = {};
	    }

	    this._value = value;
	    this._quoteMark = this._determineQuoteMark(options);

	    this._syncRawValue();
	  }
	  /**
	   * Intelligently select a quoteMark value based on the value's contents. If
	   * the value is a legal CSS ident, it will not be quoted. Otherwise a quote
	   * mark will be picked that minimizes the number of escapes.
	   *
	   * If there's no clear winner, the quote mark from these options is used,
	   * then the source quote mark (this is inverted if `preferCurrentQuoteMark` is
	   * true). If the quoteMark is unspecified, a double quote is used.
	   *
	   * @param options This takes the quoteMark and preferCurrentQuoteMark options
	   * from the quoteValue method.
	   */
	  ;

	  _proto.smartQuoteMark = function smartQuoteMark(options) {
	    var v = this.value;
	    var numSingleQuotes = v.replace(/[^']/g, '').length;
	    var numDoubleQuotes = v.replace(/[^"]/g, '').length;

	    if (numSingleQuotes + numDoubleQuotes === 0) {
	      var escaped = (0, _cssesc["default"])(v, {
	        isIdentifier: true
	      });

	      if (escaped === v) {
	        return Attribute.NO_QUOTE;
	      } else {
	        var pref = this.preferredQuoteMark(options);

	        if (pref === Attribute.NO_QUOTE) {
	          // pick a quote mark that isn't none and see if it's smaller
	          var quote = this.quoteMark || options.quoteMark || Attribute.DOUBLE_QUOTE;
	          var opts = CSSESC_QUOTE_OPTIONS[quote];
	          var quoteValue = (0, _cssesc["default"])(v, opts);

	          if (quoteValue.length < escaped.length) {
	            return quote;
	          }
	        }

	        return pref;
	      }
	    } else if (numDoubleQuotes === numSingleQuotes) {
	      return this.preferredQuoteMark(options);
	    } else if (numDoubleQuotes < numSingleQuotes) {
	      return Attribute.DOUBLE_QUOTE;
	    } else {
	      return Attribute.SINGLE_QUOTE;
	    }
	  }
	  /**
	   * Selects the preferred quote mark based on the options and the current quote mark value.
	   * If you want the quote mark to depend on the attribute value, call `smartQuoteMark(opts)`
	   * instead.
	   */
	  ;

	  _proto.preferredQuoteMark = function preferredQuoteMark(options) {
	    var quoteMark = options.preferCurrentQuoteMark ? this.quoteMark : options.quoteMark;

	    if (quoteMark === undefined) {
	      quoteMark = options.preferCurrentQuoteMark ? options.quoteMark : this.quoteMark;
	    }

	    if (quoteMark === undefined) {
	      quoteMark = Attribute.DOUBLE_QUOTE;
	    }

	    return quoteMark;
	  };

	  _proto._syncRawValue = function _syncRawValue() {
	    var rawValue = (0, _cssesc["default"])(this._value, CSSESC_QUOTE_OPTIONS[this.quoteMark]);

	    if (rawValue === this._value) {
	      if (this.raws) {
	        delete this.raws.value;
	      }
	    } else {
	      this.raws.value = rawValue;
	    }
	  };

	  _proto._handleEscapes = function _handleEscapes(prop, value) {
	    if (this._constructed) {
	      var escaped = (0, _cssesc["default"])(value, {
	        isIdentifier: true
	      });

	      if (escaped !== value) {
	        this.raws[prop] = escaped;
	      } else {
	        delete this.raws[prop];
	      }
	    }
	  };

	  _proto._spacesFor = function _spacesFor(name) {
	    var attrSpaces = {
	      before: '',
	      after: ''
	    };
	    var spaces = this.spaces[name] || {};
	    var rawSpaces = this.raws.spaces && this.raws.spaces[name] || {};
	    return Object.assign(attrSpaces, spaces, rawSpaces);
	  };

	  _proto._stringFor = function _stringFor(name, spaceName, concat) {
	    if (spaceName === void 0) {
	      spaceName = name;
	    }

	    if (concat === void 0) {
	      concat = defaultAttrConcat;
	    }

	    var attrSpaces = this._spacesFor(spaceName);

	    return concat(this.stringifyProperty(name), attrSpaces);
	  }
	  /**
	   * returns the offset of the attribute part specified relative to the
	   * start of the node of the output string.
	   *
	   * * "ns" - alias for "namespace"
	   * * "namespace" - the namespace if it exists.
	   * * "attribute" - the attribute name
	   * * "attributeNS" - the start of the attribute or its namespace
	   * * "operator" - the match operator of the attribute
	   * * "value" - The value (string or identifier)
	   * * "insensitive" - the case insensitivity flag;
	   * @param part One of the possible values inside an attribute.
	   * @returns -1 if the name is invalid or the value doesn't exist in this attribute.
	   */
	  ;

	  _proto.offsetOf = function offsetOf(name) {
	    var count = 1;

	    var attributeSpaces = this._spacesFor("attribute");

	    count += attributeSpaces.before.length;

	    if (name === "namespace" || name === "ns") {
	      return this.namespace ? count : -1;
	    }

	    if (name === "attributeNS") {
	      return count;
	    }

	    count += this.namespaceString.length;

	    if (this.namespace) {
	      count += 1;
	    }

	    if (name === "attribute") {
	      return count;
	    }

	    count += this.stringifyProperty("attribute").length;
	    count += attributeSpaces.after.length;

	    var operatorSpaces = this._spacesFor("operator");

	    count += operatorSpaces.before.length;
	    var operator = this.stringifyProperty("operator");

	    if (name === "operator") {
	      return operator ? count : -1;
	    }

	    count += operator.length;
	    count += operatorSpaces.after.length;

	    var valueSpaces = this._spacesFor("value");

	    count += valueSpaces.before.length;
	    var value = this.stringifyProperty("value");

	    if (name === "value") {
	      return value ? count : -1;
	    }

	    count += value.length;
	    count += valueSpaces.after.length;

	    var insensitiveSpaces = this._spacesFor("insensitive");

	    count += insensitiveSpaces.before.length;

	    if (name === "insensitive") {
	      return this.insensitive ? count : -1;
	    }

	    return -1;
	  };

	  _proto.toString = function toString() {
	    var _this2 = this;

	    var selector = [this.rawSpaceBefore, '['];
	    selector.push(this._stringFor('qualifiedAttribute', 'attribute'));

	    if (this.operator && (this.value || this.value === '')) {
	      selector.push(this._stringFor('operator'));
	      selector.push(this._stringFor('value'));
	      selector.push(this._stringFor('insensitiveFlag', 'insensitive', function (attrValue, attrSpaces) {
	        if (attrValue.length > 0 && !_this2.quoted && attrSpaces.before.length === 0 && !(_this2.spaces.value && _this2.spaces.value.after)) {
	          attrSpaces.before = " ";
	        }

	        return defaultAttrConcat(attrValue, attrSpaces);
	      }));
	    }

	    selector.push(']');
	    selector.push(this.rawSpaceAfter);
	    return selector.join('');
	  };

	  _createClass(Attribute, [{
	    key: "quoted",
	    get: function get() {
	      var qm = this.quoteMark;
	      return qm === "'" || qm === '"';
	    },
	    set: function set(value) {
	      warnOfDeprecatedQuotedAssignment();
	    }
	    /**
	     * returns a single (`'`) or double (`"`) quote character if the value is quoted.
	     * returns `null` if the value is not quoted.
	     * returns `undefined` if the quotation state is unknown (this can happen when
	     * the attribute is constructed without specifying a quote mark.)
	     */

	  }, {
	    key: "quoteMark",
	    get: function get() {
	      return this._quoteMark;
	    }
	    /**
	     * Set the quote mark to be used by this attribute's value.
	     * If the quote mark changes, the raw (escaped) value at `attr.raws.value` of the attribute
	     * value is updated accordingly.
	     *
	     * @param {"'" | '"' | null} quoteMark The quote mark or `null` if the value should be unquoted.
	     */
	    ,
	    set: function set(quoteMark) {
	      if (!this._constructed) {
	        this._quoteMark = quoteMark;
	        return;
	      }

	      if (this._quoteMark !== quoteMark) {
	        this._quoteMark = quoteMark;

	        this._syncRawValue();
	      }
	    }
	  }, {
	    key: "qualifiedAttribute",
	    get: function get() {
	      return this.qualifiedName(this.raws.attribute || this.attribute);
	    }
	  }, {
	    key: "insensitiveFlag",
	    get: function get() {
	      return this.insensitive ? 'i' : '';
	    }
	  }, {
	    key: "value",
	    get: function get() {
	      return this._value;
	    },
	    set:
	    /**
	     * Before 3.0, the value had to be set to an escaped value including any wrapped
	     * quote marks. In 3.0, the semantics of `Attribute.value` changed so that the value
	     * is unescaped during parsing and any quote marks are removed.
	     *
	     * Because the ambiguity of this semantic change, if you set `attr.value = newValue`,
	     * a deprecation warning is raised when the new value contains any characters that would
	     * require escaping (including if it contains wrapped quotes).
	     *
	     * Instead, you should call `attr.setValue(newValue, opts)` and pass options that describe
	     * how the new value is quoted.
	     */
	    function set(v) {
	      if (this._constructed) {
	        var _unescapeValue2 = unescapeValue(v),
	            deprecatedUsage = _unescapeValue2.deprecatedUsage,
	            unescaped = _unescapeValue2.unescaped,
	            quoteMark = _unescapeValue2.quoteMark;

	        if (deprecatedUsage) {
	          warnOfDeprecatedValueAssignment();
	        }

	        if (unescaped === this._value && quoteMark === this._quoteMark) {
	          return;
	        }

	        this._value = unescaped;
	        this._quoteMark = quoteMark;

	        this._syncRawValue();
	      } else {
	        this._value = v;
	      }
	    }
	  }, {
	    key: "insensitive",
	    get: function get() {
	      return this._insensitive;
	    }
	    /**
	     * Set the case insensitive flag.
	     * If the case insensitive flag changes, the raw (escaped) value at `attr.raws.insensitiveFlag`
	     * of the attribute is updated accordingly.
	     *
	     * @param {true | false} insensitive true if the attribute should match case-insensitively.
	     */
	    ,
	    set: function set(insensitive) {
	      if (!insensitive) {
	        this._insensitive = false; // "i" and "I" can be used in "this.raws.insensitiveFlag" to store the original notation.
	        // When setting `attr.insensitive = false` both should be erased to ensure correct serialization.

	        if (this.raws && (this.raws.insensitiveFlag === 'I' || this.raws.insensitiveFlag === 'i')) {
	          this.raws.insensitiveFlag = undefined;
	        }
	      }

	      this._insensitive = insensitive;
	    }
	  }, {
	    key: "attribute",
	    get: function get() {
	      return this._attribute;
	    },
	    set: function set(name) {
	      this._handleEscapes("attribute", name);

	      this._attribute = name;
	    }
	  }]);

	  return Attribute;
	}(_namespace["default"]);

	exports["default"] = Attribute;
	Attribute.NO_QUOTE = null;
	Attribute.SINGLE_QUOTE = "'";
	Attribute.DOUBLE_QUOTE = '"';
	var CSSESC_QUOTE_OPTIONS = (_CSSESC_QUOTE_OPTIONS = {
	  "'": {
	    quotes: 'single',
	    wrap: true
	  },
	  '"': {
	    quotes: 'double',
	    wrap: true
	  }
	}, _CSSESC_QUOTE_OPTIONS[null] = {
	  isIdentifier: true
	}, _CSSESC_QUOTE_OPTIONS);

	function defaultAttrConcat(attrValue, attrSpaces) {
	  return "" + attrSpaces.before + attrValue + attrSpaces.after;
	}
} (attribute$1));

var universalExports = {};
var universal$1 = {
  get exports(){ return universalExports; },
  set exports(v){ universalExports = v; },
};

(function (module, exports) {

	exports.__esModule = true;
	exports["default"] = void 0;

	var _namespace = _interopRequireDefault(namespaceExports);

	var _types = types;

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

	function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

	function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

	var Universal = /*#__PURE__*/function (_Namespace) {
	  _inheritsLoose(Universal, _Namespace);

	  function Universal(opts) {
	    var _this;

	    _this = _Namespace.call(this, opts) || this;
	    _this.type = _types.UNIVERSAL;
	    _this.value = '*';
	    return _this;
	  }

	  return Universal;
	}(_namespace["default"]);

	exports["default"] = Universal;
	module.exports = exports.default;
} (universal$1, universalExports));

var combinatorExports = {};
var combinator$2 = {
  get exports(){ return combinatorExports; },
  set exports(v){ combinatorExports = v; },
};

(function (module, exports) {

	exports.__esModule = true;
	exports["default"] = void 0;

	var _node = _interopRequireDefault(nodeExports);

	var _types = types;

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

	function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

	function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

	var Combinator = /*#__PURE__*/function (_Node) {
	  _inheritsLoose(Combinator, _Node);

	  function Combinator(opts) {
	    var _this;

	    _this = _Node.call(this, opts) || this;
	    _this.type = _types.COMBINATOR;
	    return _this;
	  }

	  return Combinator;
	}(_node["default"]);

	exports["default"] = Combinator;
	module.exports = exports.default;
} (combinator$2, combinatorExports));

var nestingExports = {};
var nesting$1 = {
  get exports(){ return nestingExports; },
  set exports(v){ nestingExports = v; },
};

(function (module, exports) {

	exports.__esModule = true;
	exports["default"] = void 0;

	var _node = _interopRequireDefault(nodeExports);

	var _types = types;

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

	function _inheritsLoose(subClass, superClass) { subClass.prototype = Object.create(superClass.prototype); subClass.prototype.constructor = subClass; _setPrototypeOf(subClass, superClass); }

	function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

	var Nesting = /*#__PURE__*/function (_Node) {
	  _inheritsLoose(Nesting, _Node);

	  function Nesting(opts) {
	    var _this;

	    _this = _Node.call(this, opts) || this;
	    _this.type = _types.NESTING;
	    _this.value = '&';
	    return _this;
	  }

	  return Nesting;
	}(_node["default"]);

	exports["default"] = Nesting;
	module.exports = exports.default;
} (nesting$1, nestingExports));

var sortAscendingExports = {};
var sortAscending = {
  get exports(){ return sortAscendingExports; },
  set exports(v){ sortAscendingExports = v; },
};

(function (module, exports) {

	exports.__esModule = true;
	exports["default"] = sortAscending;

	function sortAscending(list) {
	  return list.sort(function (a, b) {
	    return a - b;
	  });
	}
	module.exports = exports.default;
} (sortAscending, sortAscendingExports));

var tokenize = {};

var tokenTypes = {};

tokenTypes.__esModule = true;
tokenTypes.combinator = tokenTypes.word = tokenTypes.comment = tokenTypes.str = tokenTypes.tab = tokenTypes.newline = tokenTypes.feed = tokenTypes.cr = tokenTypes.backslash = tokenTypes.bang = tokenTypes.slash = tokenTypes.doubleQuote = tokenTypes.singleQuote = tokenTypes.space = tokenTypes.greaterThan = tokenTypes.pipe = tokenTypes.equals = tokenTypes.plus = tokenTypes.caret = tokenTypes.tilde = tokenTypes.dollar = tokenTypes.closeSquare = tokenTypes.openSquare = tokenTypes.closeParenthesis = tokenTypes.openParenthesis = tokenTypes.semicolon = tokenTypes.colon = tokenTypes.comma = tokenTypes.at = tokenTypes.asterisk = tokenTypes.ampersand = void 0;
var ampersand = 38; // `&`.charCodeAt(0);

tokenTypes.ampersand = ampersand;
var asterisk = 42; // `*`.charCodeAt(0);

tokenTypes.asterisk = asterisk;
var at = 64; // `@`.charCodeAt(0);

tokenTypes.at = at;
var comma$1 = 44; // `,`.charCodeAt(0);

tokenTypes.comma = comma$1;
var colon$1 = 58; // `:`.charCodeAt(0);

tokenTypes.colon = colon$1;
var semicolon = 59; // `;`.charCodeAt(0);

tokenTypes.semicolon = semicolon;
var openParenthesis = 40; // `(`.charCodeAt(0);

tokenTypes.openParenthesis = openParenthesis;
var closeParenthesis = 41; // `)`.charCodeAt(0);

tokenTypes.closeParenthesis = closeParenthesis;
var openSquare = 91; // `[`.charCodeAt(0);

tokenTypes.openSquare = openSquare;
var closeSquare = 93; // `]`.charCodeAt(0);

tokenTypes.closeSquare = closeSquare;
var dollar = 36; // `$`.charCodeAt(0);

tokenTypes.dollar = dollar;
var tilde = 126; // `~`.charCodeAt(0);

tokenTypes.tilde = tilde;
var caret = 94; // `^`.charCodeAt(0);

tokenTypes.caret = caret;
var plus$1 = 43; // `+`.charCodeAt(0);

tokenTypes.plus = plus$1;
var equals = 61; // `=`.charCodeAt(0);

tokenTypes.equals = equals;
var pipe = 124; // `|`.charCodeAt(0);

tokenTypes.pipe = pipe;
var greaterThan = 62; // `>`.charCodeAt(0);

tokenTypes.greaterThan = greaterThan;
var space = 32; // ` `.charCodeAt(0);

tokenTypes.space = space;
var singleQuote$1 = 39; // `'`.charCodeAt(0);

tokenTypes.singleQuote = singleQuote$1;
var doubleQuote$1 = 34; // `"`.charCodeAt(0);

tokenTypes.doubleQuote = doubleQuote$1;
var slash$1 = 47; // `/`.charCodeAt(0);

tokenTypes.slash = slash$1;
var bang = 33; // `!`.charCodeAt(0);

tokenTypes.bang = bang;
var backslash$1 = 92; // '\\'.charCodeAt(0);

tokenTypes.backslash = backslash$1;
var cr = 13; // '\r'.charCodeAt(0);

tokenTypes.cr = cr;
var feed = 12; // '\f'.charCodeAt(0);

tokenTypes.feed = feed;
var newline = 10; // '\n'.charCodeAt(0);

tokenTypes.newline = newline;
var tab = 9; // '\t'.charCodeAt(0);
// Expose aliases primarily for readability.

tokenTypes.tab = tab;
var str = singleQuote$1; // No good single character representation!

tokenTypes.str = str;
var comment$1 = -1;
tokenTypes.comment = comment$1;
var word = -2;
tokenTypes.word = word;
var combinator$1 = -3;
tokenTypes.combinator = combinator$1;

(function (exports) {

	exports.__esModule = true;
	exports["default"] = tokenize;
	exports.FIELDS = void 0;

	var t = _interopRequireWildcard(tokenTypes);

	var _unescapable, _wordDelimiters;

	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

	var unescapable = (_unescapable = {}, _unescapable[t.tab] = true, _unescapable[t.newline] = true, _unescapable[t.cr] = true, _unescapable[t.feed] = true, _unescapable);
	var wordDelimiters = (_wordDelimiters = {}, _wordDelimiters[t.space] = true, _wordDelimiters[t.tab] = true, _wordDelimiters[t.newline] = true, _wordDelimiters[t.cr] = true, _wordDelimiters[t.feed] = true, _wordDelimiters[t.ampersand] = true, _wordDelimiters[t.asterisk] = true, _wordDelimiters[t.bang] = true, _wordDelimiters[t.comma] = true, _wordDelimiters[t.colon] = true, _wordDelimiters[t.semicolon] = true, _wordDelimiters[t.openParenthesis] = true, _wordDelimiters[t.closeParenthesis] = true, _wordDelimiters[t.openSquare] = true, _wordDelimiters[t.closeSquare] = true, _wordDelimiters[t.singleQuote] = true, _wordDelimiters[t.doubleQuote] = true, _wordDelimiters[t.plus] = true, _wordDelimiters[t.pipe] = true, _wordDelimiters[t.tilde] = true, _wordDelimiters[t.greaterThan] = true, _wordDelimiters[t.equals] = true, _wordDelimiters[t.dollar] = true, _wordDelimiters[t.caret] = true, _wordDelimiters[t.slash] = true, _wordDelimiters);
	var hex = {};
	var hexChars = "0123456789abcdefABCDEF";

	for (var i = 0; i < hexChars.length; i++) {
	  hex[hexChars.charCodeAt(i)] = true;
	}
	/**
	 *  Returns the last index of the bar css word
	 * @param {string} css The string in which the word begins
	 * @param {number} start The index into the string where word's first letter occurs
	 */


	function consumeWord(css, start) {
	  var next = start;
	  var code;

	  do {
	    code = css.charCodeAt(next);

	    if (wordDelimiters[code]) {
	      return next - 1;
	    } else if (code === t.backslash) {
	      next = consumeEscape(css, next) + 1;
	    } else {
	      // All other characters are part of the word
	      next++;
	    }
	  } while (next < css.length);

	  return next - 1;
	}
	/**
	 *  Returns the last index of the escape sequence
	 * @param {string} css The string in which the sequence begins
	 * @param {number} start The index into the string where escape character (`\`) occurs.
	 */


	function consumeEscape(css, start) {
	  var next = start;
	  var code = css.charCodeAt(next + 1);

	  if (unescapable[code]) ; else if (hex[code]) {
	    var hexDigits = 0; // consume up to 6 hex chars

	    do {
	      next++;
	      hexDigits++;
	      code = css.charCodeAt(next + 1);
	    } while (hex[code] && hexDigits < 6); // if fewer than 6 hex chars, a trailing space ends the escape


	    if (hexDigits < 6 && code === t.space) {
	      next++;
	    }
	  } else {
	    // the next char is part of the current word
	    next++;
	  }

	  return next;
	}

	var FIELDS = {
	  TYPE: 0,
	  START_LINE: 1,
	  START_COL: 2,
	  END_LINE: 3,
	  END_COL: 4,
	  START_POS: 5,
	  END_POS: 6
	};
	exports.FIELDS = FIELDS;

	function tokenize(input) {
	  var tokens = [];
	  var css = input.css.valueOf();
	  var _css = css,
	      length = _css.length;
	  var offset = -1;
	  var line = 1;
	  var start = 0;
	  var end = 0;
	  var code, content, endColumn, endLine, escaped, escapePos, last, lines, next, nextLine, nextOffset, quote, tokenType;

	  function unclosed(what, fix) {
	    if (input.safe) {
	      // fyi: this is never set to true.
	      css += fix;
	      next = css.length - 1;
	    } else {
	      throw input.error('Unclosed ' + what, line, start - offset, start);
	    }
	  }

	  while (start < length) {
	    code = css.charCodeAt(start);

	    if (code === t.newline) {
	      offset = start;
	      line += 1;
	    }

	    switch (code) {
	      case t.space:
	      case t.tab:
	      case t.newline:
	      case t.cr:
	      case t.feed:
	        next = start;

	        do {
	          next += 1;
	          code = css.charCodeAt(next);

	          if (code === t.newline) {
	            offset = next;
	            line += 1;
	          }
	        } while (code === t.space || code === t.newline || code === t.tab || code === t.cr || code === t.feed);

	        tokenType = t.space;
	        endLine = line;
	        endColumn = next - offset - 1;
	        end = next;
	        break;

	      case t.plus:
	      case t.greaterThan:
	      case t.tilde:
	      case t.pipe:
	        next = start;

	        do {
	          next += 1;
	          code = css.charCodeAt(next);
	        } while (code === t.plus || code === t.greaterThan || code === t.tilde || code === t.pipe);

	        tokenType = t.combinator;
	        endLine = line;
	        endColumn = start - offset;
	        end = next;
	        break;
	      // Consume these characters as single tokens.

	      case t.asterisk:
	      case t.ampersand:
	      case t.bang:
	      case t.comma:
	      case t.equals:
	      case t.dollar:
	      case t.caret:
	      case t.openSquare:
	      case t.closeSquare:
	      case t.colon:
	      case t.semicolon:
	      case t.openParenthesis:
	      case t.closeParenthesis:
	        next = start;
	        tokenType = code;
	        endLine = line;
	        endColumn = start - offset;
	        end = next + 1;
	        break;

	      case t.singleQuote:
	      case t.doubleQuote:
	        quote = code === t.singleQuote ? "'" : '"';
	        next = start;

	        do {
	          escaped = false;
	          next = css.indexOf(quote, next + 1);

	          if (next === -1) {
	            unclosed('quote', quote);
	          }

	          escapePos = next;

	          while (css.charCodeAt(escapePos - 1) === t.backslash) {
	            escapePos -= 1;
	            escaped = !escaped;
	          }
	        } while (escaped);

	        tokenType = t.str;
	        endLine = line;
	        endColumn = start - offset;
	        end = next + 1;
	        break;

	      default:
	        if (code === t.slash && css.charCodeAt(start + 1) === t.asterisk) {
	          next = css.indexOf('*/', start + 2) + 1;

	          if (next === 0) {
	            unclosed('comment', '*/');
	          }

	          content = css.slice(start, next + 1);
	          lines = content.split('\n');
	          last = lines.length - 1;

	          if (last > 0) {
	            nextLine = line + last;
	            nextOffset = next - lines[last].length;
	          } else {
	            nextLine = line;
	            nextOffset = offset;
	          }

	          tokenType = t.comment;
	          line = nextLine;
	          endLine = nextLine;
	          endColumn = next - nextOffset;
	        } else if (code === t.slash) {
	          next = start;
	          tokenType = code;
	          endLine = line;
	          endColumn = start - offset;
	          end = next + 1;
	        } else {
	          next = consumeWord(css, start);
	          tokenType = t.word;
	          endLine = line;
	          endColumn = next - offset;
	        }

	        end = next + 1;
	        break;
	    } // Ensure that the token structure remains consistent


	    tokens.push([tokenType, // [0] Token type
	    line, // [1] Starting line
	    start - offset, // [2] Starting column
	    endLine, // [3] Ending line
	    endColumn, // [4] Ending column
	    start, // [5] Start position / Source index
	    end // [6] End position
	    ]); // Reset offset for the next token

	    if (nextOffset) {
	      offset = nextOffset;
	      nextOffset = null;
	    }

	    start = end;
	  }

	  return tokens;
	}
} (tokenize));

(function (module, exports) {

	exports.__esModule = true;
	exports["default"] = void 0;

	var _root = _interopRequireDefault(rootExports);

	var _selector = _interopRequireDefault(selectorExports);

	var _className = _interopRequireDefault(classNameExports);

	var _comment = _interopRequireDefault(commentExports);

	var _id = _interopRequireDefault(idExports);

	var _tag = _interopRequireDefault(tagExports);

	var _string = _interopRequireDefault(stringExports);

	var _pseudo = _interopRequireDefault(pseudoExports);

	var _attribute = _interopRequireWildcard(attribute$1);

	var _universal = _interopRequireDefault(universalExports);

	var _combinator = _interopRequireDefault(combinatorExports);

	var _nesting = _interopRequireDefault(nestingExports);

	var _sortAscending = _interopRequireDefault(sortAscendingExports);

	var _tokenize = _interopRequireWildcard(tokenize);

	var tokens = _interopRequireWildcard(tokenTypes);

	var types$1 = _interopRequireWildcard(types);

	var _util = util;

	var _WHITESPACE_TOKENS, _Object$assign;

	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

	function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

	function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

	var WHITESPACE_TOKENS = (_WHITESPACE_TOKENS = {}, _WHITESPACE_TOKENS[tokens.space] = true, _WHITESPACE_TOKENS[tokens.cr] = true, _WHITESPACE_TOKENS[tokens.feed] = true, _WHITESPACE_TOKENS[tokens.newline] = true, _WHITESPACE_TOKENS[tokens.tab] = true, _WHITESPACE_TOKENS);
	var WHITESPACE_EQUIV_TOKENS = Object.assign({}, WHITESPACE_TOKENS, (_Object$assign = {}, _Object$assign[tokens.comment] = true, _Object$assign));

	function tokenStart(token) {
	  return {
	    line: token[_tokenize.FIELDS.START_LINE],
	    column: token[_tokenize.FIELDS.START_COL]
	  };
	}

	function tokenEnd(token) {
	  return {
	    line: token[_tokenize.FIELDS.END_LINE],
	    column: token[_tokenize.FIELDS.END_COL]
	  };
	}

	function getSource(startLine, startColumn, endLine, endColumn) {
	  return {
	    start: {
	      line: startLine,
	      column: startColumn
	    },
	    end: {
	      line: endLine,
	      column: endColumn
	    }
	  };
	}

	function getTokenSource(token) {
	  return getSource(token[_tokenize.FIELDS.START_LINE], token[_tokenize.FIELDS.START_COL], token[_tokenize.FIELDS.END_LINE], token[_tokenize.FIELDS.END_COL]);
	}

	function getTokenSourceSpan(startToken, endToken) {
	  if (!startToken) {
	    return undefined;
	  }

	  return getSource(startToken[_tokenize.FIELDS.START_LINE], startToken[_tokenize.FIELDS.START_COL], endToken[_tokenize.FIELDS.END_LINE], endToken[_tokenize.FIELDS.END_COL]);
	}

	function unescapeProp(node, prop) {
	  var value = node[prop];

	  if (typeof value !== "string") {
	    return;
	  }

	  if (value.indexOf("\\") !== -1) {
	    (0, _util.ensureObject)(node, 'raws');
	    node[prop] = (0, _util.unesc)(value);

	    if (node.raws[prop] === undefined) {
	      node.raws[prop] = value;
	    }
	  }

	  return node;
	}

	function indexesOf(array, item) {
	  var i = -1;
	  var indexes = [];

	  while ((i = array.indexOf(item, i + 1)) !== -1) {
	    indexes.push(i);
	  }

	  return indexes;
	}

	function uniqs() {
	  var list = Array.prototype.concat.apply([], arguments);
	  return list.filter(function (item, i) {
	    return i === list.indexOf(item);
	  });
	}

	var Parser = /*#__PURE__*/function () {
	  function Parser(rule, options) {
	    if (options === void 0) {
	      options = {};
	    }

	    this.rule = rule;
	    this.options = Object.assign({
	      lossy: false,
	      safe: false
	    }, options);
	    this.position = 0;
	    this.css = typeof this.rule === 'string' ? this.rule : this.rule.selector;
	    this.tokens = (0, _tokenize["default"])({
	      css: this.css,
	      error: this._errorGenerator(),
	      safe: this.options.safe
	    });
	    var rootSource = getTokenSourceSpan(this.tokens[0], this.tokens[this.tokens.length - 1]);
	    this.root = new _root["default"]({
	      source: rootSource
	    });
	    this.root.errorGenerator = this._errorGenerator();
	    var selector = new _selector["default"]({
	      source: {
	        start: {
	          line: 1,
	          column: 1
	        }
	      }
	    });
	    this.root.append(selector);
	    this.current = selector;
	    this.loop();
	  }

	  var _proto = Parser.prototype;

	  _proto._errorGenerator = function _errorGenerator() {
	    var _this = this;

	    return function (message, errorOptions) {
	      if (typeof _this.rule === 'string') {
	        return new Error(message);
	      }

	      return _this.rule.error(message, errorOptions);
	    };
	  };

	  _proto.attribute = function attribute() {
	    var attr = [];
	    var startingToken = this.currToken;
	    this.position++;

	    while (this.position < this.tokens.length && this.currToken[_tokenize.FIELDS.TYPE] !== tokens.closeSquare) {
	      attr.push(this.currToken);
	      this.position++;
	    }

	    if (this.currToken[_tokenize.FIELDS.TYPE] !== tokens.closeSquare) {
	      return this.expected('closing square bracket', this.currToken[_tokenize.FIELDS.START_POS]);
	    }

	    var len = attr.length;
	    var node = {
	      source: getSource(startingToken[1], startingToken[2], this.currToken[3], this.currToken[4]),
	      sourceIndex: startingToken[_tokenize.FIELDS.START_POS]
	    };

	    if (len === 1 && !~[tokens.word].indexOf(attr[0][_tokenize.FIELDS.TYPE])) {
	      return this.expected('attribute', attr[0][_tokenize.FIELDS.START_POS]);
	    }

	    var pos = 0;
	    var spaceBefore = '';
	    var commentBefore = '';
	    var lastAdded = null;
	    var spaceAfterMeaningfulToken = false;

	    while (pos < len) {
	      var token = attr[pos];
	      var content = this.content(token);
	      var next = attr[pos + 1];

	      switch (token[_tokenize.FIELDS.TYPE]) {
	        case tokens.space:
	          // if (
	          //     len === 1 ||
	          //     pos === 0 && this.content(next) === '|'
	          // ) {
	          //     return this.expected('attribute', token[TOKEN.START_POS], content);
	          // }
	          spaceAfterMeaningfulToken = true;

	          if (this.options.lossy) {
	            break;
	          }

	          if (lastAdded) {
	            (0, _util.ensureObject)(node, 'spaces', lastAdded);
	            var prevContent = node.spaces[lastAdded].after || '';
	            node.spaces[lastAdded].after = prevContent + content;
	            var existingComment = (0, _util.getProp)(node, 'raws', 'spaces', lastAdded, 'after') || null;

	            if (existingComment) {
	              node.raws.spaces[lastAdded].after = existingComment + content;
	            }
	          } else {
	            spaceBefore = spaceBefore + content;
	            commentBefore = commentBefore + content;
	          }

	          break;

	        case tokens.asterisk:
	          if (next[_tokenize.FIELDS.TYPE] === tokens.equals) {
	            node.operator = content;
	            lastAdded = 'operator';
	          } else if ((!node.namespace || lastAdded === "namespace" && !spaceAfterMeaningfulToken) && next) {
	            if (spaceBefore) {
	              (0, _util.ensureObject)(node, 'spaces', 'attribute');
	              node.spaces.attribute.before = spaceBefore;
	              spaceBefore = '';
	            }

	            if (commentBefore) {
	              (0, _util.ensureObject)(node, 'raws', 'spaces', 'attribute');
	              node.raws.spaces.attribute.before = spaceBefore;
	              commentBefore = '';
	            }

	            node.namespace = (node.namespace || "") + content;
	            var rawValue = (0, _util.getProp)(node, 'raws', 'namespace') || null;

	            if (rawValue) {
	              node.raws.namespace += content;
	            }

	            lastAdded = 'namespace';
	          }

	          spaceAfterMeaningfulToken = false;
	          break;

	        case tokens.dollar:
	          if (lastAdded === "value") {
	            var oldRawValue = (0, _util.getProp)(node, 'raws', 'value');
	            node.value += "$";

	            if (oldRawValue) {
	              node.raws.value = oldRawValue + "$";
	            }

	            break;
	          }

	        // Falls through

	        case tokens.caret:
	          if (next[_tokenize.FIELDS.TYPE] === tokens.equals) {
	            node.operator = content;
	            lastAdded = 'operator';
	          }

	          spaceAfterMeaningfulToken = false;
	          break;

	        case tokens.combinator:
	          if (content === '~' && next[_tokenize.FIELDS.TYPE] === tokens.equals) {
	            node.operator = content;
	            lastAdded = 'operator';
	          }

	          if (content !== '|') {
	            spaceAfterMeaningfulToken = false;
	            break;
	          }

	          if (next[_tokenize.FIELDS.TYPE] === tokens.equals) {
	            node.operator = content;
	            lastAdded = 'operator';
	          } else if (!node.namespace && !node.attribute) {
	            node.namespace = true;
	          }

	          spaceAfterMeaningfulToken = false;
	          break;

	        case tokens.word:
	          if (next && this.content(next) === '|' && attr[pos + 2] && attr[pos + 2][_tokenize.FIELDS.TYPE] !== tokens.equals && // this look-ahead probably fails with comment nodes involved.
	          !node.operator && !node.namespace) {
	            node.namespace = content;
	            lastAdded = 'namespace';
	          } else if (!node.attribute || lastAdded === "attribute" && !spaceAfterMeaningfulToken) {
	            if (spaceBefore) {
	              (0, _util.ensureObject)(node, 'spaces', 'attribute');
	              node.spaces.attribute.before = spaceBefore;
	              spaceBefore = '';
	            }

	            if (commentBefore) {
	              (0, _util.ensureObject)(node, 'raws', 'spaces', 'attribute');
	              node.raws.spaces.attribute.before = commentBefore;
	              commentBefore = '';
	            }

	            node.attribute = (node.attribute || "") + content;

	            var _rawValue = (0, _util.getProp)(node, 'raws', 'attribute') || null;

	            if (_rawValue) {
	              node.raws.attribute += content;
	            }

	            lastAdded = 'attribute';
	          } else if (!node.value && node.value !== "" || lastAdded === "value" && !(spaceAfterMeaningfulToken || node.quoteMark)) {
	            var _unescaped = (0, _util.unesc)(content);

	            var _oldRawValue = (0, _util.getProp)(node, 'raws', 'value') || '';

	            var oldValue = node.value || '';
	            node.value = oldValue + _unescaped;
	            node.quoteMark = null;

	            if (_unescaped !== content || _oldRawValue) {
	              (0, _util.ensureObject)(node, 'raws');
	              node.raws.value = (_oldRawValue || oldValue) + content;
	            }

	            lastAdded = 'value';
	          } else {
	            var insensitive = content === 'i' || content === "I";

	            if ((node.value || node.value === '') && (node.quoteMark || spaceAfterMeaningfulToken)) {
	              node.insensitive = insensitive;

	              if (!insensitive || content === "I") {
	                (0, _util.ensureObject)(node, 'raws');
	                node.raws.insensitiveFlag = content;
	              }

	              lastAdded = 'insensitive';

	              if (spaceBefore) {
	                (0, _util.ensureObject)(node, 'spaces', 'insensitive');
	                node.spaces.insensitive.before = spaceBefore;
	                spaceBefore = '';
	              }

	              if (commentBefore) {
	                (0, _util.ensureObject)(node, 'raws', 'spaces', 'insensitive');
	                node.raws.spaces.insensitive.before = commentBefore;
	                commentBefore = '';
	              }
	            } else if (node.value || node.value === '') {
	              lastAdded = 'value';
	              node.value += content;

	              if (node.raws.value) {
	                node.raws.value += content;
	              }
	            }
	          }

	          spaceAfterMeaningfulToken = false;
	          break;

	        case tokens.str:
	          if (!node.attribute || !node.operator) {
	            return this.error("Expected an attribute followed by an operator preceding the string.", {
	              index: token[_tokenize.FIELDS.START_POS]
	            });
	          }

	          var _unescapeValue = (0, _attribute.unescapeValue)(content),
	              unescaped = _unescapeValue.unescaped,
	              quoteMark = _unescapeValue.quoteMark;

	          node.value = unescaped;
	          node.quoteMark = quoteMark;
	          lastAdded = 'value';
	          (0, _util.ensureObject)(node, 'raws');
	          node.raws.value = content;
	          spaceAfterMeaningfulToken = false;
	          break;

	        case tokens.equals:
	          if (!node.attribute) {
	            return this.expected('attribute', token[_tokenize.FIELDS.START_POS], content);
	          }

	          if (node.value) {
	            return this.error('Unexpected "=" found; an operator was already defined.', {
	              index: token[_tokenize.FIELDS.START_POS]
	            });
	          }

	          node.operator = node.operator ? node.operator + content : content;
	          lastAdded = 'operator';
	          spaceAfterMeaningfulToken = false;
	          break;

	        case tokens.comment:
	          if (lastAdded) {
	            if (spaceAfterMeaningfulToken || next && next[_tokenize.FIELDS.TYPE] === tokens.space || lastAdded === 'insensitive') {
	              var lastComment = (0, _util.getProp)(node, 'spaces', lastAdded, 'after') || '';
	              var rawLastComment = (0, _util.getProp)(node, 'raws', 'spaces', lastAdded, 'after') || lastComment;
	              (0, _util.ensureObject)(node, 'raws', 'spaces', lastAdded);
	              node.raws.spaces[lastAdded].after = rawLastComment + content;
	            } else {
	              var lastValue = node[lastAdded] || '';
	              var rawLastValue = (0, _util.getProp)(node, 'raws', lastAdded) || lastValue;
	              (0, _util.ensureObject)(node, 'raws');
	              node.raws[lastAdded] = rawLastValue + content;
	            }
	          } else {
	            commentBefore = commentBefore + content;
	          }

	          break;

	        default:
	          return this.error("Unexpected \"" + content + "\" found.", {
	            index: token[_tokenize.FIELDS.START_POS]
	          });
	      }

	      pos++;
	    }

	    unescapeProp(node, "attribute");
	    unescapeProp(node, "namespace");
	    this.newNode(new _attribute["default"](node));
	    this.position++;
	  }
	  /**
	   * return a node containing meaningless garbage up to (but not including) the specified token position.
	   * if the token position is negative, all remaining tokens are consumed.
	   *
	   * This returns an array containing a single string node if all whitespace,
	   * otherwise an array of comment nodes with space before and after.
	   *
	   * These tokens are not added to the current selector, the caller can add them or use them to amend
	   * a previous node's space metadata.
	   *
	   * In lossy mode, this returns only comments.
	   */
	  ;

	  _proto.parseWhitespaceEquivalentTokens = function parseWhitespaceEquivalentTokens(stopPosition) {
	    if (stopPosition < 0) {
	      stopPosition = this.tokens.length;
	    }

	    var startPosition = this.position;
	    var nodes = [];
	    var space = "";
	    var lastComment = undefined;

	    do {
	      if (WHITESPACE_TOKENS[this.currToken[_tokenize.FIELDS.TYPE]]) {
	        if (!this.options.lossy) {
	          space += this.content();
	        }
	      } else if (this.currToken[_tokenize.FIELDS.TYPE] === tokens.comment) {
	        var spaces = {};

	        if (space) {
	          spaces.before = space;
	          space = "";
	        }

	        lastComment = new _comment["default"]({
	          value: this.content(),
	          source: getTokenSource(this.currToken),
	          sourceIndex: this.currToken[_tokenize.FIELDS.START_POS],
	          spaces: spaces
	        });
	        nodes.push(lastComment);
	      }
	    } while (++this.position < stopPosition);

	    if (space) {
	      if (lastComment) {
	        lastComment.spaces.after = space;
	      } else if (!this.options.lossy) {
	        var firstToken = this.tokens[startPosition];
	        var lastToken = this.tokens[this.position - 1];
	        nodes.push(new _string["default"]({
	          value: '',
	          source: getSource(firstToken[_tokenize.FIELDS.START_LINE], firstToken[_tokenize.FIELDS.START_COL], lastToken[_tokenize.FIELDS.END_LINE], lastToken[_tokenize.FIELDS.END_COL]),
	          sourceIndex: firstToken[_tokenize.FIELDS.START_POS],
	          spaces: {
	            before: space,
	            after: ''
	          }
	        }));
	      }
	    }

	    return nodes;
	  }
	  /**
	   *
	   * @param {*} nodes
	   */
	  ;

	  _proto.convertWhitespaceNodesToSpace = function convertWhitespaceNodesToSpace(nodes, requiredSpace) {
	    var _this2 = this;

	    if (requiredSpace === void 0) {
	      requiredSpace = false;
	    }

	    var space = "";
	    var rawSpace = "";
	    nodes.forEach(function (n) {
	      var spaceBefore = _this2.lossySpace(n.spaces.before, requiredSpace);

	      var rawSpaceBefore = _this2.lossySpace(n.rawSpaceBefore, requiredSpace);

	      space += spaceBefore + _this2.lossySpace(n.spaces.after, requiredSpace && spaceBefore.length === 0);
	      rawSpace += spaceBefore + n.value + _this2.lossySpace(n.rawSpaceAfter, requiredSpace && rawSpaceBefore.length === 0);
	    });

	    if (rawSpace === space) {
	      rawSpace = undefined;
	    }

	    var result = {
	      space: space,
	      rawSpace: rawSpace
	    };
	    return result;
	  };

	  _proto.isNamedCombinator = function isNamedCombinator(position) {
	    if (position === void 0) {
	      position = this.position;
	    }

	    return this.tokens[position + 0] && this.tokens[position + 0][_tokenize.FIELDS.TYPE] === tokens.slash && this.tokens[position + 1] && this.tokens[position + 1][_tokenize.FIELDS.TYPE] === tokens.word && this.tokens[position + 2] && this.tokens[position + 2][_tokenize.FIELDS.TYPE] === tokens.slash;
	  };

	  _proto.namedCombinator = function namedCombinator() {
	    if (this.isNamedCombinator()) {
	      var nameRaw = this.content(this.tokens[this.position + 1]);
	      var name = (0, _util.unesc)(nameRaw).toLowerCase();
	      var raws = {};

	      if (name !== nameRaw) {
	        raws.value = "/" + nameRaw + "/";
	      }

	      var node = new _combinator["default"]({
	        value: "/" + name + "/",
	        source: getSource(this.currToken[_tokenize.FIELDS.START_LINE], this.currToken[_tokenize.FIELDS.START_COL], this.tokens[this.position + 2][_tokenize.FIELDS.END_LINE], this.tokens[this.position + 2][_tokenize.FIELDS.END_COL]),
	        sourceIndex: this.currToken[_tokenize.FIELDS.START_POS],
	        raws: raws
	      });
	      this.position = this.position + 3;
	      return node;
	    } else {
	      this.unexpected();
	    }
	  };

	  _proto.combinator = function combinator() {
	    var _this3 = this;

	    if (this.content() === '|') {
	      return this.namespace();
	    } // We need to decide between a space that's a descendant combinator and meaningless whitespace at the end of a selector.


	    var nextSigTokenPos = this.locateNextMeaningfulToken(this.position);

	    if (nextSigTokenPos < 0 || this.tokens[nextSigTokenPos][_tokenize.FIELDS.TYPE] === tokens.comma) {
	      var nodes = this.parseWhitespaceEquivalentTokens(nextSigTokenPos);

	      if (nodes.length > 0) {
	        var last = this.current.last;

	        if (last) {
	          var _this$convertWhitespa = this.convertWhitespaceNodesToSpace(nodes),
	              space = _this$convertWhitespa.space,
	              rawSpace = _this$convertWhitespa.rawSpace;

	          if (rawSpace !== undefined) {
	            last.rawSpaceAfter += rawSpace;
	          }

	          last.spaces.after += space;
	        } else {
	          nodes.forEach(function (n) {
	            return _this3.newNode(n);
	          });
	        }
	      }

	      return;
	    }

	    var firstToken = this.currToken;
	    var spaceOrDescendantSelectorNodes = undefined;

	    if (nextSigTokenPos > this.position) {
	      spaceOrDescendantSelectorNodes = this.parseWhitespaceEquivalentTokens(nextSigTokenPos);
	    }

	    var node;

	    if (this.isNamedCombinator()) {
	      node = this.namedCombinator();
	    } else if (this.currToken[_tokenize.FIELDS.TYPE] === tokens.combinator) {
	      node = new _combinator["default"]({
	        value: this.content(),
	        source: getTokenSource(this.currToken),
	        sourceIndex: this.currToken[_tokenize.FIELDS.START_POS]
	      });
	      this.position++;
	    } else if (WHITESPACE_TOKENS[this.currToken[_tokenize.FIELDS.TYPE]]) ; else if (!spaceOrDescendantSelectorNodes) {
	      this.unexpected();
	    }

	    if (node) {
	      if (spaceOrDescendantSelectorNodes) {
	        var _this$convertWhitespa2 = this.convertWhitespaceNodesToSpace(spaceOrDescendantSelectorNodes),
	            _space = _this$convertWhitespa2.space,
	            _rawSpace = _this$convertWhitespa2.rawSpace;

	        node.spaces.before = _space;
	        node.rawSpaceBefore = _rawSpace;
	      }
	    } else {
	      // descendant combinator
	      var _this$convertWhitespa3 = this.convertWhitespaceNodesToSpace(spaceOrDescendantSelectorNodes, true),
	          _space2 = _this$convertWhitespa3.space,
	          _rawSpace2 = _this$convertWhitespa3.rawSpace;

	      if (!_rawSpace2) {
	        _rawSpace2 = _space2;
	      }

	      var spaces = {};
	      var raws = {
	        spaces: {}
	      };

	      if (_space2.endsWith(' ') && _rawSpace2.endsWith(' ')) {
	        spaces.before = _space2.slice(0, _space2.length - 1);
	        raws.spaces.before = _rawSpace2.slice(0, _rawSpace2.length - 1);
	      } else if (_space2.startsWith(' ') && _rawSpace2.startsWith(' ')) {
	        spaces.after = _space2.slice(1);
	        raws.spaces.after = _rawSpace2.slice(1);
	      } else {
	        raws.value = _rawSpace2;
	      }

	      node = new _combinator["default"]({
	        value: ' ',
	        source: getTokenSourceSpan(firstToken, this.tokens[this.position - 1]),
	        sourceIndex: firstToken[_tokenize.FIELDS.START_POS],
	        spaces: spaces,
	        raws: raws
	      });
	    }

	    if (this.currToken && this.currToken[_tokenize.FIELDS.TYPE] === tokens.space) {
	      node.spaces.after = this.optionalSpace(this.content());
	      this.position++;
	    }

	    return this.newNode(node);
	  };

	  _proto.comma = function comma() {
	    if (this.position === this.tokens.length - 1) {
	      this.root.trailingComma = true;
	      this.position++;
	      return;
	    }

	    this.current._inferEndPosition();

	    var selector = new _selector["default"]({
	      source: {
	        start: tokenStart(this.tokens[this.position + 1])
	      }
	    });
	    this.current.parent.append(selector);
	    this.current = selector;
	    this.position++;
	  };

	  _proto.comment = function comment() {
	    var current = this.currToken;
	    this.newNode(new _comment["default"]({
	      value: this.content(),
	      source: getTokenSource(current),
	      sourceIndex: current[_tokenize.FIELDS.START_POS]
	    }));
	    this.position++;
	  };

	  _proto.error = function error(message, opts) {
	    throw this.root.error(message, opts);
	  };

	  _proto.missingBackslash = function missingBackslash() {
	    return this.error('Expected a backslash preceding the semicolon.', {
	      index: this.currToken[_tokenize.FIELDS.START_POS]
	    });
	  };

	  _proto.missingParenthesis = function missingParenthesis() {
	    return this.expected('opening parenthesis', this.currToken[_tokenize.FIELDS.START_POS]);
	  };

	  _proto.missingSquareBracket = function missingSquareBracket() {
	    return this.expected('opening square bracket', this.currToken[_tokenize.FIELDS.START_POS]);
	  };

	  _proto.unexpected = function unexpected() {
	    return this.error("Unexpected '" + this.content() + "'. Escaping special characters with \\ may help.", this.currToken[_tokenize.FIELDS.START_POS]);
	  };

	  _proto.namespace = function namespace() {
	    var before = this.prevToken && this.content(this.prevToken) || true;

	    if (this.nextToken[_tokenize.FIELDS.TYPE] === tokens.word) {
	      this.position++;
	      return this.word(before);
	    } else if (this.nextToken[_tokenize.FIELDS.TYPE] === tokens.asterisk) {
	      this.position++;
	      return this.universal(before);
	    }
	  };

	  _proto.nesting = function nesting() {
	    if (this.nextToken) {
	      var nextContent = this.content(this.nextToken);

	      if (nextContent === "|") {
	        this.position++;
	        return;
	      }
	    }

	    var current = this.currToken;
	    this.newNode(new _nesting["default"]({
	      value: this.content(),
	      source: getTokenSource(current),
	      sourceIndex: current[_tokenize.FIELDS.START_POS]
	    }));
	    this.position++;
	  };

	  _proto.parentheses = function parentheses() {
	    var last = this.current.last;
	    var unbalanced = 1;
	    this.position++;

	    if (last && last.type === types$1.PSEUDO) {
	      var selector = new _selector["default"]({
	        source: {
	          start: tokenStart(this.tokens[this.position - 1])
	        }
	      });
	      var cache = this.current;
	      last.append(selector);
	      this.current = selector;

	      while (this.position < this.tokens.length && unbalanced) {
	        if (this.currToken[_tokenize.FIELDS.TYPE] === tokens.openParenthesis) {
	          unbalanced++;
	        }

	        if (this.currToken[_tokenize.FIELDS.TYPE] === tokens.closeParenthesis) {
	          unbalanced--;
	        }

	        if (unbalanced) {
	          this.parse();
	        } else {
	          this.current.source.end = tokenEnd(this.currToken);
	          this.current.parent.source.end = tokenEnd(this.currToken);
	          this.position++;
	        }
	      }

	      this.current = cache;
	    } else {
	      // I think this case should be an error. It's used to implement a basic parse of media queries
	      // but I don't think it's a good idea.
	      var parenStart = this.currToken;
	      var parenValue = "(";
	      var parenEnd;

	      while (this.position < this.tokens.length && unbalanced) {
	        if (this.currToken[_tokenize.FIELDS.TYPE] === tokens.openParenthesis) {
	          unbalanced++;
	        }

	        if (this.currToken[_tokenize.FIELDS.TYPE] === tokens.closeParenthesis) {
	          unbalanced--;
	        }

	        parenEnd = this.currToken;
	        parenValue += this.parseParenthesisToken(this.currToken);
	        this.position++;
	      }

	      if (last) {
	        last.appendToPropertyAndEscape("value", parenValue, parenValue);
	      } else {
	        this.newNode(new _string["default"]({
	          value: parenValue,
	          source: getSource(parenStart[_tokenize.FIELDS.START_LINE], parenStart[_tokenize.FIELDS.START_COL], parenEnd[_tokenize.FIELDS.END_LINE], parenEnd[_tokenize.FIELDS.END_COL]),
	          sourceIndex: parenStart[_tokenize.FIELDS.START_POS]
	        }));
	      }
	    }

	    if (unbalanced) {
	      return this.expected('closing parenthesis', this.currToken[_tokenize.FIELDS.START_POS]);
	    }
	  };

	  _proto.pseudo = function pseudo() {
	    var _this4 = this;

	    var pseudoStr = '';
	    var startingToken = this.currToken;

	    while (this.currToken && this.currToken[_tokenize.FIELDS.TYPE] === tokens.colon) {
	      pseudoStr += this.content();
	      this.position++;
	    }

	    if (!this.currToken) {
	      return this.expected(['pseudo-class', 'pseudo-element'], this.position - 1);
	    }

	    if (this.currToken[_tokenize.FIELDS.TYPE] === tokens.word) {
	      this.splitWord(false, function (first, length) {
	        pseudoStr += first;

	        _this4.newNode(new _pseudo["default"]({
	          value: pseudoStr,
	          source: getTokenSourceSpan(startingToken, _this4.currToken),
	          sourceIndex: startingToken[_tokenize.FIELDS.START_POS]
	        }));

	        if (length > 1 && _this4.nextToken && _this4.nextToken[_tokenize.FIELDS.TYPE] === tokens.openParenthesis) {
	          _this4.error('Misplaced parenthesis.', {
	            index: _this4.nextToken[_tokenize.FIELDS.START_POS]
	          });
	        }
	      });
	    } else {
	      return this.expected(['pseudo-class', 'pseudo-element'], this.currToken[_tokenize.FIELDS.START_POS]);
	    }
	  };

	  _proto.space = function space() {
	    var content = this.content(); // Handle space before and after the selector

	    if (this.position === 0 || this.prevToken[_tokenize.FIELDS.TYPE] === tokens.comma || this.prevToken[_tokenize.FIELDS.TYPE] === tokens.openParenthesis || this.current.nodes.every(function (node) {
	      return node.type === 'comment';
	    })) {
	      this.spaces = this.optionalSpace(content);
	      this.position++;
	    } else if (this.position === this.tokens.length - 1 || this.nextToken[_tokenize.FIELDS.TYPE] === tokens.comma || this.nextToken[_tokenize.FIELDS.TYPE] === tokens.closeParenthesis) {
	      this.current.last.spaces.after = this.optionalSpace(content);
	      this.position++;
	    } else {
	      this.combinator();
	    }
	  };

	  _proto.string = function string() {
	    var current = this.currToken;
	    this.newNode(new _string["default"]({
	      value: this.content(),
	      source: getTokenSource(current),
	      sourceIndex: current[_tokenize.FIELDS.START_POS]
	    }));
	    this.position++;
	  };

	  _proto.universal = function universal(namespace) {
	    var nextToken = this.nextToken;

	    if (nextToken && this.content(nextToken) === '|') {
	      this.position++;
	      return this.namespace();
	    }

	    var current = this.currToken;
	    this.newNode(new _universal["default"]({
	      value: this.content(),
	      source: getTokenSource(current),
	      sourceIndex: current[_tokenize.FIELDS.START_POS]
	    }), namespace);
	    this.position++;
	  };

	  _proto.splitWord = function splitWord(namespace, firstCallback) {
	    var _this5 = this;

	    var nextToken = this.nextToken;
	    var word = this.content();

	    while (nextToken && ~[tokens.dollar, tokens.caret, tokens.equals, tokens.word].indexOf(nextToken[_tokenize.FIELDS.TYPE])) {
	      this.position++;
	      var current = this.content();
	      word += current;

	      if (current.lastIndexOf('\\') === current.length - 1) {
	        var next = this.nextToken;

	        if (next && next[_tokenize.FIELDS.TYPE] === tokens.space) {
	          word += this.requiredSpace(this.content(next));
	          this.position++;
	        }
	      }

	      nextToken = this.nextToken;
	    }

	    var hasClass = indexesOf(word, '.').filter(function (i) {
	      // Allow escaped dot within class name
	      var escapedDot = word[i - 1] === '\\'; // Allow decimal numbers percent in @keyframes

	      var isKeyframesPercent = /^\d+\.\d+%$/.test(word);
	      return !escapedDot && !isKeyframesPercent;
	    });
	    var hasId = indexesOf(word, '#').filter(function (i) {
	      return word[i - 1] !== '\\';
	    }); // Eliminate Sass interpolations from the list of id indexes

	    var interpolations = indexesOf(word, '#{');

	    if (interpolations.length) {
	      hasId = hasId.filter(function (hashIndex) {
	        return !~interpolations.indexOf(hashIndex);
	      });
	    }

	    var indices = (0, _sortAscending["default"])(uniqs([0].concat(hasClass, hasId)));
	    indices.forEach(function (ind, i) {
	      var index = indices[i + 1] || word.length;
	      var value = word.slice(ind, index);

	      if (i === 0 && firstCallback) {
	        return firstCallback.call(_this5, value, indices.length);
	      }

	      var node;
	      var current = _this5.currToken;
	      var sourceIndex = current[_tokenize.FIELDS.START_POS] + indices[i];
	      var source = getSource(current[1], current[2] + ind, current[3], current[2] + (index - 1));

	      if (~hasClass.indexOf(ind)) {
	        var classNameOpts = {
	          value: value.slice(1),
	          source: source,
	          sourceIndex: sourceIndex
	        };
	        node = new _className["default"](unescapeProp(classNameOpts, "value"));
	      } else if (~hasId.indexOf(ind)) {
	        var idOpts = {
	          value: value.slice(1),
	          source: source,
	          sourceIndex: sourceIndex
	        };
	        node = new _id["default"](unescapeProp(idOpts, "value"));
	      } else {
	        var tagOpts = {
	          value: value,
	          source: source,
	          sourceIndex: sourceIndex
	        };
	        unescapeProp(tagOpts, "value");
	        node = new _tag["default"](tagOpts);
	      }

	      _this5.newNode(node, namespace); // Ensure that the namespace is used only once


	      namespace = null;
	    });
	    this.position++;
	  };

	  _proto.word = function word(namespace) {
	    var nextToken = this.nextToken;

	    if (nextToken && this.content(nextToken) === '|') {
	      this.position++;
	      return this.namespace();
	    }

	    return this.splitWord(namespace);
	  };

	  _proto.loop = function loop() {
	    while (this.position < this.tokens.length) {
	      this.parse(true);
	    }

	    this.current._inferEndPosition();

	    return this.root;
	  };

	  _proto.parse = function parse(throwOnParenthesis) {
	    switch (this.currToken[_tokenize.FIELDS.TYPE]) {
	      case tokens.space:
	        this.space();
	        break;

	      case tokens.comment:
	        this.comment();
	        break;

	      case tokens.openParenthesis:
	        this.parentheses();
	        break;

	      case tokens.closeParenthesis:
	        if (throwOnParenthesis) {
	          this.missingParenthesis();
	        }

	        break;

	      case tokens.openSquare:
	        this.attribute();
	        break;

	      case tokens.dollar:
	      case tokens.caret:
	      case tokens.equals:
	      case tokens.word:
	        this.word();
	        break;

	      case tokens.colon:
	        this.pseudo();
	        break;

	      case tokens.comma:
	        this.comma();
	        break;

	      case tokens.asterisk:
	        this.universal();
	        break;

	      case tokens.ampersand:
	        this.nesting();
	        break;

	      case tokens.slash:
	      case tokens.combinator:
	        this.combinator();
	        break;

	      case tokens.str:
	        this.string();
	        break;
	      // These cases throw; no break needed.

	      case tokens.closeSquare:
	        this.missingSquareBracket();

	      case tokens.semicolon:
	        this.missingBackslash();

	      default:
	        this.unexpected();
	    }
	  }
	  /**
	   * Helpers
	   */
	  ;

	  _proto.expected = function expected(description, index, found) {
	    if (Array.isArray(description)) {
	      var last = description.pop();
	      description = description.join(', ') + " or " + last;
	    }

	    var an = /^[aeiou]/.test(description[0]) ? 'an' : 'a';

	    if (!found) {
	      return this.error("Expected " + an + " " + description + ".", {
	        index: index
	      });
	    }

	    return this.error("Expected " + an + " " + description + ", found \"" + found + "\" instead.", {
	      index: index
	    });
	  };

	  _proto.requiredSpace = function requiredSpace(space) {
	    return this.options.lossy ? ' ' : space;
	  };

	  _proto.optionalSpace = function optionalSpace(space) {
	    return this.options.lossy ? '' : space;
	  };

	  _proto.lossySpace = function lossySpace(space, required) {
	    if (this.options.lossy) {
	      return required ? ' ' : '';
	    } else {
	      return space;
	    }
	  };

	  _proto.parseParenthesisToken = function parseParenthesisToken(token) {
	    var content = this.content(token);

	    if (token[_tokenize.FIELDS.TYPE] === tokens.space) {
	      return this.requiredSpace(content);
	    } else {
	      return content;
	    }
	  };

	  _proto.newNode = function newNode(node, namespace) {
	    if (namespace) {
	      if (/^ +$/.test(namespace)) {
	        if (!this.options.lossy) {
	          this.spaces = (this.spaces || '') + namespace;
	        }

	        namespace = true;
	      }

	      node.namespace = namespace;
	      unescapeProp(node, "namespace");
	    }

	    if (this.spaces) {
	      node.spaces.before = this.spaces;
	      this.spaces = '';
	    }

	    return this.current.append(node);
	  };

	  _proto.content = function content(token) {
	    if (token === void 0) {
	      token = this.currToken;
	    }

	    return this.css.slice(token[_tokenize.FIELDS.START_POS], token[_tokenize.FIELDS.END_POS]);
	  };

	  /**
	   * returns the index of the next non-whitespace, non-comment token.
	   * returns -1 if no meaningful token is found.
	   */
	  _proto.locateNextMeaningfulToken = function locateNextMeaningfulToken(startPosition) {
	    if (startPosition === void 0) {
	      startPosition = this.position + 1;
	    }

	    var searchPosition = startPosition;

	    while (searchPosition < this.tokens.length) {
	      if (WHITESPACE_EQUIV_TOKENS[this.tokens[searchPosition][_tokenize.FIELDS.TYPE]]) {
	        searchPosition++;
	        continue;
	      } else {
	        return searchPosition;
	      }
	    }

	    return -1;
	  };

	  _createClass(Parser, [{
	    key: "currToken",
	    get: function get() {
	      return this.tokens[this.position];
	    }
	  }, {
	    key: "nextToken",
	    get: function get() {
	      return this.tokens[this.position + 1];
	    }
	  }, {
	    key: "prevToken",
	    get: function get() {
	      return this.tokens[this.position - 1];
	    }
	  }]);

	  return Parser;
	}();

	exports["default"] = Parser;
	module.exports = exports.default;
} (parser$1, parserExports));

(function (module, exports) {

	exports.__esModule = true;
	exports["default"] = void 0;

	var _parser = _interopRequireDefault(parserExports);

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

	var Processor = /*#__PURE__*/function () {
	  function Processor(func, options) {
	    this.func = func || function noop() {};

	    this.funcRes = null;
	    this.options = options;
	  }

	  var _proto = Processor.prototype;

	  _proto._shouldUpdateSelector = function _shouldUpdateSelector(rule, options) {
	    if (options === void 0) {
	      options = {};
	    }

	    var merged = Object.assign({}, this.options, options);

	    if (merged.updateSelector === false) {
	      return false;
	    } else {
	      return typeof rule !== "string";
	    }
	  };

	  _proto._isLossy = function _isLossy(options) {
	    if (options === void 0) {
	      options = {};
	    }

	    var merged = Object.assign({}, this.options, options);

	    if (merged.lossless === false) {
	      return true;
	    } else {
	      return false;
	    }
	  };

	  _proto._root = function _root(rule, options) {
	    if (options === void 0) {
	      options = {};
	    }

	    var parser = new _parser["default"](rule, this._parseOptions(options));
	    return parser.root;
	  };

	  _proto._parseOptions = function _parseOptions(options) {
	    return {
	      lossy: this._isLossy(options)
	    };
	  };

	  _proto._run = function _run(rule, options) {
	    var _this = this;

	    if (options === void 0) {
	      options = {};
	    }

	    return new Promise(function (resolve, reject) {
	      try {
	        var root = _this._root(rule, options);

	        Promise.resolve(_this.func(root)).then(function (transform) {
	          var string = undefined;

	          if (_this._shouldUpdateSelector(rule, options)) {
	            string = root.toString();
	            rule.selector = string;
	          }

	          return {
	            transform: transform,
	            root: root,
	            string: string
	          };
	        }).then(resolve, reject);
	      } catch (e) {
	        reject(e);
	        return;
	      }
	    });
	  };

	  _proto._runSync = function _runSync(rule, options) {
	    if (options === void 0) {
	      options = {};
	    }

	    var root = this._root(rule, options);

	    var transform = this.func(root);

	    if (transform && typeof transform.then === "function") {
	      throw new Error("Selector processor returned a promise to a synchronous call.");
	    }

	    var string = undefined;

	    if (options.updateSelector && typeof rule !== "string") {
	      string = root.toString();
	      rule.selector = string;
	    }

	    return {
	      transform: transform,
	      root: root,
	      string: string
	    };
	  }
	  /**
	   * Process rule into a selector AST.
	   *
	   * @param rule {postcss.Rule | string} The css selector to be processed
	   * @param options The options for processing
	   * @returns {Promise<parser.Root>} The AST of the selector after processing it.
	   */
	  ;

	  _proto.ast = function ast(rule, options) {
	    return this._run(rule, options).then(function (result) {
	      return result.root;
	    });
	  }
	  /**
	   * Process rule into a selector AST synchronously.
	   *
	   * @param rule {postcss.Rule | string} The css selector to be processed
	   * @param options The options for processing
	   * @returns {parser.Root} The AST of the selector after processing it.
	   */
	  ;

	  _proto.astSync = function astSync(rule, options) {
	    return this._runSync(rule, options).root;
	  }
	  /**
	   * Process a selector into a transformed value asynchronously
	   *
	   * @param rule {postcss.Rule | string} The css selector to be processed
	   * @param options The options for processing
	   * @returns {Promise<any>} The value returned by the processor.
	   */
	  ;

	  _proto.transform = function transform(rule, options) {
	    return this._run(rule, options).then(function (result) {
	      return result.transform;
	    });
	  }
	  /**
	   * Process a selector into a transformed value synchronously.
	   *
	   * @param rule {postcss.Rule | string} The css selector to be processed
	   * @param options The options for processing
	   * @returns {any} The value returned by the processor.
	   */
	  ;

	  _proto.transformSync = function transformSync(rule, options) {
	    return this._runSync(rule, options).transform;
	  }
	  /**
	   * Process a selector into a new selector string asynchronously.
	   *
	   * @param rule {postcss.Rule | string} The css selector to be processed
	   * @param options The options for processing
	   * @returns {string} the selector after processing.
	   */
	  ;

	  _proto.process = function process(rule, options) {
	    return this._run(rule, options).then(function (result) {
	      return result.string || result.root.toString();
	    });
	  }
	  /**
	   * Process a selector into a new selector string synchronously.
	   *
	   * @param rule {postcss.Rule | string} The css selector to be processed
	   * @param options The options for processing
	   * @returns {string} the selector after processing.
	   */
	  ;

	  _proto.processSync = function processSync(rule, options) {
	    var result = this._runSync(rule, options);

	    return result.string || result.root.toString();
	  };

	  return Processor;
	}();

	exports["default"] = Processor;
	module.exports = exports.default;
} (processor, processorExports));

var selectors = {};

var constructors = {};

constructors.__esModule = true;
constructors.universal = constructors.tag = constructors.string = constructors.selector = constructors.root = constructors.pseudo = constructors.nesting = constructors.id = constructors.comment = constructors.combinator = constructors.className = constructors.attribute = void 0;

var _attribute = _interopRequireDefault$5(attribute$1);

var _className = _interopRequireDefault$5(classNameExports);

var _combinator = _interopRequireDefault$5(combinatorExports);

var _comment = _interopRequireDefault$5(commentExports);

var _id = _interopRequireDefault$5(idExports);

var _nesting = _interopRequireDefault$5(nestingExports);

var _pseudo = _interopRequireDefault$5(pseudoExports);

var _root = _interopRequireDefault$5(rootExports);

var _selector = _interopRequireDefault$5(selectorExports);

var _string = _interopRequireDefault$5(stringExports);

var _tag = _interopRequireDefault$5(tagExports);

var _universal = _interopRequireDefault$5(universalExports);

function _interopRequireDefault$5(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var attribute = function attribute(opts) {
  return new _attribute["default"](opts);
};

constructors.attribute = attribute;

var className = function className(opts) {
  return new _className["default"](opts);
};

constructors.className = className;

var combinator = function combinator(opts) {
  return new _combinator["default"](opts);
};

constructors.combinator = combinator;

var comment = function comment(opts) {
  return new _comment["default"](opts);
};

constructors.comment = comment;

var id = function id(opts) {
  return new _id["default"](opts);
};

constructors.id = id;

var nesting = function nesting(opts) {
  return new _nesting["default"](opts);
};

constructors.nesting = nesting;

var pseudo = function pseudo(opts) {
  return new _pseudo["default"](opts);
};

constructors.pseudo = pseudo;

var root$1 = function root(opts) {
  return new _root["default"](opts);
};

constructors.root = root$1;

var selector = function selector(opts) {
  return new _selector["default"](opts);
};

constructors.selector = selector;

var string = function string(opts) {
  return new _string["default"](opts);
};

constructors.string = string;

var tag = function tag(opts) {
  return new _tag["default"](opts);
};

constructors.tag = tag;

var universal = function universal(opts) {
  return new _universal["default"](opts);
};

constructors.universal = universal;

var guards = {};

guards.__esModule = true;
guards.isNode = isNode;
guards.isPseudoElement = isPseudoElement;
guards.isPseudoClass = isPseudoClass;
guards.isContainer = isContainer;
guards.isNamespace = isNamespace;
guards.isUniversal = guards.isTag = guards.isString = guards.isSelector = guards.isRoot = guards.isPseudo = guards.isNesting = guards.isIdentifier = guards.isComment = guards.isCombinator = guards.isClassName = guards.isAttribute = void 0;

var _types = types;

var _IS_TYPE;

var IS_TYPE = (_IS_TYPE = {}, _IS_TYPE[_types.ATTRIBUTE] = true, _IS_TYPE[_types.CLASS] = true, _IS_TYPE[_types.COMBINATOR] = true, _IS_TYPE[_types.COMMENT] = true, _IS_TYPE[_types.ID] = true, _IS_TYPE[_types.NESTING] = true, _IS_TYPE[_types.PSEUDO] = true, _IS_TYPE[_types.ROOT] = true, _IS_TYPE[_types.SELECTOR] = true, _IS_TYPE[_types.STRING] = true, _IS_TYPE[_types.TAG] = true, _IS_TYPE[_types.UNIVERSAL] = true, _IS_TYPE);

function isNode(node) {
  return typeof node === "object" && IS_TYPE[node.type];
}

function isNodeType(type, node) {
  return isNode(node) && node.type === type;
}

var isAttribute = isNodeType.bind(null, _types.ATTRIBUTE);
guards.isAttribute = isAttribute;
var isClassName = isNodeType.bind(null, _types.CLASS);
guards.isClassName = isClassName;
var isCombinator = isNodeType.bind(null, _types.COMBINATOR);
guards.isCombinator = isCombinator;
var isComment = isNodeType.bind(null, _types.COMMENT);
guards.isComment = isComment;
var isIdentifier = isNodeType.bind(null, _types.ID);
guards.isIdentifier = isIdentifier;
var isNesting = isNodeType.bind(null, _types.NESTING);
guards.isNesting = isNesting;
var isPseudo = isNodeType.bind(null, _types.PSEUDO);
guards.isPseudo = isPseudo;
var isRoot = isNodeType.bind(null, _types.ROOT);
guards.isRoot = isRoot;
var isSelector = isNodeType.bind(null, _types.SELECTOR);
guards.isSelector = isSelector;
var isString = isNodeType.bind(null, _types.STRING);
guards.isString = isString;
var isTag = isNodeType.bind(null, _types.TAG);
guards.isTag = isTag;
var isUniversal = isNodeType.bind(null, _types.UNIVERSAL);
guards.isUniversal = isUniversal;

function isPseudoElement(node) {
  return isPseudo(node) && node.value && (node.value.startsWith("::") || node.value.toLowerCase() === ":before" || node.value.toLowerCase() === ":after" || node.value.toLowerCase() === ":first-letter" || node.value.toLowerCase() === ":first-line");
}

function isPseudoClass(node) {
  return isPseudo(node) && !isPseudoElement(node);
}

function isContainer(node) {
  return !!(isNode(node) && node.walk);
}

function isNamespace(node) {
  return isAttribute(node) || isTag(node);
}

(function (exports) {

	exports.__esModule = true;

	var _types = types;

	Object.keys(_types).forEach(function (key) {
	  if (key === "default" || key === "__esModule") return;
	  if (key in exports && exports[key] === _types[key]) return;
	  exports[key] = _types[key];
	});

	var _constructors = constructors;

	Object.keys(_constructors).forEach(function (key) {
	  if (key === "default" || key === "__esModule") return;
	  if (key in exports && exports[key] === _constructors[key]) return;
	  exports[key] = _constructors[key];
	});

	var _guards = guards;

	Object.keys(_guards).forEach(function (key) {
	  if (key === "default" || key === "__esModule") return;
	  if (key in exports && exports[key] === _guards[key]) return;
	  exports[key] = _guards[key];
	});
} (selectors));

(function (module, exports) {

	exports.__esModule = true;
	exports["default"] = void 0;

	var _processor = _interopRequireDefault(processorExports);

	var selectors$1 = _interopRequireWildcard(selectors);

	function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

	function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

	function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

	var parser = function parser(processor) {
	  return new _processor["default"](processor);
	};

	Object.assign(parser, selectors$1);
	delete parser.__esModule;
	var _default = parser;
	exports["default"] = _default;
	module.exports = exports.default;
} (dist, distExports));

var selectorParser$2 = /*@__PURE__*/getDefaultExportFromCjs(distExports);

const animationNameRE = /^(-\w+-)?animation-name$/;
const animationRE = /^(-\w+-)?animation$/;
const scopedPlugin = (id = "") => {
  const keyframes = /* @__PURE__ */ Object.create(null);
  const shortId = id.replace(/^data-v-/, "");
  return {
    postcssPlugin: "vue-sfc-scoped",
    Rule(rule) {
      processRule(id, rule);
    },
    AtRule(node) {
      if (/-?keyframes$/.test(node.name) && !node.params.endsWith(`-${shortId}`)) {
        keyframes[node.params] = node.params = node.params + "-" + shortId;
      }
    },
    OnceExit(root) {
      if (Object.keys(keyframes).length) {
        root.walkDecls((decl) => {
          if (animationNameRE.test(decl.prop)) {
            decl.value = decl.value.split(",").map((v) => keyframes[v.trim()] || v.trim()).join(",");
          }
          if (animationRE.test(decl.prop)) {
            decl.value = decl.value.split(",").map((v) => {
              const vals = v.trim().split(/\s+/);
              const i = vals.findIndex((val) => keyframes[val]);
              if (i !== -1) {
                vals.splice(i, 1, keyframes[vals[i]]);
                return vals.join(" ");
              } else {
                return v;
              }
            }).join(",");
          }
        });
      }
    }
  };
};
const processedRules = /* @__PURE__ */ new WeakSet();
function processRule(id, rule) {
  if (processedRules.has(rule) || rule.parent && rule.parent.type === "atrule" && /-?keyframes$/.test(rule.parent.name)) {
    return;
  }
  processedRules.add(rule);
  rule.selector = selectorParser$2((selectorRoot) => {
    selectorRoot.each((selector) => {
      rewriteSelector(id, selector, selectorRoot);
    });
  }).processSync(rule.selector);
}
function rewriteSelector(id, selector, selectorRoot, slotted = false) {
  let node = null;
  let shouldInject = true;
  selector.each((n) => {
    if (n.type === "combinator" && (n.value === ">>>" || n.value === "/deep/")) {
      n.value = " ";
      n.spaces.before = n.spaces.after = "";
      warn(
        `the >>> and /deep/ combinators have been deprecated. Use :deep() instead.`
      );
      return false;
    }
    if (n.type === "pseudo") {
      const { value } = n;
      if (value === ":deep" || value === "::v-deep") {
        if (n.nodes.length) {
          let last = n;
          n.nodes[0].each((ss) => {
            selector.insertAfter(last, ss);
            last = ss;
          });
          const prev = selector.at(selector.index(n) - 1);
          if (!prev || !isSpaceCombinator(prev)) {
            selector.insertAfter(
              n,
              selectorParser$2.combinator({
                value: " "
              })
            );
          }
          selector.removeChild(n);
        } else {
          warn(
            `::v-deep usage as a combinator has been deprecated. Use :deep(<inner-selector>) instead.`
          );
          const prev = selector.at(selector.index(n) - 1);
          if (prev && isSpaceCombinator(prev)) {
            selector.removeChild(prev);
          }
          selector.removeChild(n);
        }
        return false;
      }
      if (value === ":slotted" || value === "::v-slotted") {
        rewriteSelector(
          id,
          n.nodes[0],
          selectorRoot,
          true
          /* slotted */
        );
        let last = n;
        n.nodes[0].each((ss) => {
          selector.insertAfter(last, ss);
          last = ss;
        });
        selector.removeChild(n);
        shouldInject = false;
        return false;
      }
      if (value === ":global" || value === "::v-global") {
        selectorRoot.insertAfter(selector, n.nodes[0]);
        selectorRoot.removeChild(selector);
        return false;
      }
    }
    if (n.type !== "pseudo" && n.type !== "combinator") {
      node = n;
    }
  });
  if (node) {
    node.spaces.after = "";
  } else {
    selector.first.spaces.before = "";
  }
  if (shouldInject) {
    const idToAdd = slotted ? id + "-s" : id;
    selector.insertAfter(
      // If node is null it means we need to inject [id] at the start
      // insertAfter can handle `null` here
      node,
      selectorParser$2.attribute({
        attribute: idToAdd,
        value: idToAdd,
        raws: {},
        quoteMark: `"`
      })
    );
  }
}
function isSpaceCombinator(node) {
  return node.type === "combinator" && /^\s+$/.test(node.value);
}
scopedPlugin.postcss = true;
var scopedPlugin$1 = scopedPlugin;

var sourceMap = require$$0$1;
var SourceMapConsumer = sourceMap.SourceMapConsumer;
var SourceMapGenerator = sourceMap.SourceMapGenerator;

var mergeSourceMap = merge;

/**
 * Merge old source map and new source map and return merged.
 * If old or new source map value is falsy, return another one as it is.
 *
 * @param {object|string} [oldMap] old source map object
 * @param {object|string} [newmap] new source map object
 * @return {object|undefined} merged source map object, or undefined when both old and new source map are undefined
 */
function merge(oldMap, newMap) {
  if (!oldMap) return newMap
  if (!newMap) return oldMap

  var oldMapConsumer = new SourceMapConsumer(oldMap);
  var newMapConsumer = new SourceMapConsumer(newMap);
  var mergedMapGenerator = new SourceMapGenerator();

  // iterate on new map and overwrite original position of new map with one of old map
  newMapConsumer.eachMapping(function(m) {
    // pass when `originalLine` is null.
    // It occurs in case that the node does not have origin in original code.
    if (m.originalLine == null) return

    var origPosInOldMap = oldMapConsumer.originalPositionFor({
      line: m.originalLine,
      column: m.originalColumn
    });

    if (origPosInOldMap.source == null) return

    mergedMapGenerator.addMapping({
      original: {
        line: origPosInOldMap.line,
        column: origPosInOldMap.column
      },
      generated: {
        line: m.generatedLine,
        column: m.generatedColumn
      },
      source: origPosInOldMap.source,
      name: origPosInOldMap.name
    });
  });

  var consumers = [oldMapConsumer, newMapConsumer];
  consumers.forEach(function(consumer) {
    consumer.sources.forEach(function(sourceFile) {
      mergedMapGenerator._sources.add(sourceFile);
      var sourceContent = consumer.sourceContentFor(sourceFile);
      if (sourceContent != null) {
        mergedMapGenerator.setSourceContent(sourceFile, sourceContent);
      }
    });
  });

  mergedMapGenerator._sourceRoot = oldMap.sourceRoot;
  mergedMapGenerator._file = oldMap.file;

  return JSON.parse(mergedMapGenerator.toString())
}

var merge$1 = mergeSourceMap;

const scss = (source, map, options, load = require) => {
  const nodeSass = load("sass");
  const finalOptions = {
    ...options,
    data: getSource(source, options.filename, options.additionalData),
    file: options.filename,
    outFile: options.filename,
    sourceMap: !!map
  };
  try {
    const result = nodeSass.renderSync(finalOptions);
    const dependencies = result.stats.includedFiles;
    if (map) {
      return {
        code: result.css.toString(),
        map: merge$1(map, JSON.parse(result.map.toString())),
        errors: [],
        dependencies
      };
    }
    return { code: result.css.toString(), errors: [], dependencies };
  } catch (e) {
    return { code: "", errors: [e], dependencies: [] };
  }
};
const sass = (source, map, options, load) => scss(
  source,
  map,
  {
    ...options,
    indentedSyntax: true
  },
  load
);
const less = (source, map, options, load = require) => {
  const nodeLess = load("less");
  let result;
  let error = null;
  nodeLess.render(
    getSource(source, options.filename, options.additionalData),
    { ...options, syncImport: true },
    (err, output) => {
      error = err;
      result = output;
    }
  );
  if (error)
    return { code: "", errors: [error], dependencies: [] };
  const dependencies = result.imports;
  if (map) {
    return {
      code: result.css.toString(),
      map: merge$1(map, result.map),
      errors: [],
      dependencies
    };
  }
  return {
    code: result.css.toString(),
    errors: [],
    dependencies
  };
};
const styl = (source, map, options, load = require) => {
  const nodeStylus = load("stylus");
  try {
    const ref = nodeStylus(source);
    Object.keys(options).forEach((key) => ref.set(key, options[key]));
    if (map)
      ref.set("sourcemap", { inline: false, comment: false });
    const result = ref.render();
    const dependencies = ref.deps();
    if (map) {
      return {
        code: result,
        map: merge$1(map, ref.sourcemap),
        errors: [],
        dependencies
      };
    }
    return { code: result, errors: [], dependencies };
  } catch (e) {
    return { code: "", errors: [e], dependencies: [] };
  }
};
function getSource(source, filename, additionalData) {
  if (!additionalData)
    return source;
  if (shared.isFunction(additionalData)) {
    return additionalData(source, filename);
  }
  return additionalData + source;
}
const processors = {
  less,
  sass,
  scss,
  styl,
  stylus: styl
};

var buildExports = {};
var build = {
  get exports(){ return buildExports; },
  set exports(v){ buildExports = v; },
};

/**
 * lodash (Custom Build) <https://lodash.com/>
 * Build: `lodash modularize exports="npm" -o ./`
 * Copyright jQuery Foundation and other contributors <https://jquery.org/>
 * Released under MIT license <https://lodash.com/license>
 * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>
 * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors
 */

/** Used as references for various `Number` constants. */
var INFINITY = 1 / 0;

/** `Object#toString` result references. */
var symbolTag = '[object Symbol]';

/** Used to match words composed of alphanumeric characters. */
var reAsciiWord = /[^\x00-\x2f\x3a-\x40\x5b-\x60\x7b-\x7f]+/g;

/** Used to match Latin Unicode letters (excluding mathematical operators). */
var reLatin = /[\xc0-\xd6\xd8-\xf6\xf8-\xff\u0100-\u017f]/g;

/** Used to compose unicode character classes. */
var rsAstralRange = '\\ud800-\\udfff',
    rsComboMarksRange = '\\u0300-\\u036f\\ufe20-\\ufe23',
    rsComboSymbolsRange = '\\u20d0-\\u20f0',
    rsDingbatRange = '\\u2700-\\u27bf',
    rsLowerRange = 'a-z\\xdf-\\xf6\\xf8-\\xff',
    rsMathOpRange = '\\xac\\xb1\\xd7\\xf7',
    rsNonCharRange = '\\x00-\\x2f\\x3a-\\x40\\x5b-\\x60\\x7b-\\xbf',
    rsPunctuationRange = '\\u2000-\\u206f',
    rsSpaceRange = ' \\t\\x0b\\f\\xa0\\ufeff\\n\\r\\u2028\\u2029\\u1680\\u180e\\u2000\\u2001\\u2002\\u2003\\u2004\\u2005\\u2006\\u2007\\u2008\\u2009\\u200a\\u202f\\u205f\\u3000',
    rsUpperRange = 'A-Z\\xc0-\\xd6\\xd8-\\xde',
    rsVarRange = '\\ufe0e\\ufe0f',
    rsBreakRange = rsMathOpRange + rsNonCharRange + rsPunctuationRange + rsSpaceRange;

/** Used to compose unicode capture groups. */
var rsApos = "['\u2019]",
    rsAstral = '[' + rsAstralRange + ']',
    rsBreak = '[' + rsBreakRange + ']',
    rsCombo = '[' + rsComboMarksRange + rsComboSymbolsRange + ']',
    rsDigits = '\\d+',
    rsDingbat = '[' + rsDingbatRange + ']',
    rsLower = '[' + rsLowerRange + ']',
    rsMisc = '[^' + rsAstralRange + rsBreakRange + rsDigits + rsDingbatRange + rsLowerRange + rsUpperRange + ']',
    rsFitz = '\\ud83c[\\udffb-\\udfff]',
    rsModifier = '(?:' + rsCombo + '|' + rsFitz + ')',
    rsNonAstral = '[^' + rsAstralRange + ']',
    rsRegional = '(?:\\ud83c[\\udde6-\\uddff]){2}',
    rsSurrPair = '[\\ud800-\\udbff][\\udc00-\\udfff]',
    rsUpper = '[' + rsUpperRange + ']',
    rsZWJ = '\\u200d';

/** Used to compose unicode regexes. */
var rsLowerMisc = '(?:' + rsLower + '|' + rsMisc + ')',
    rsUpperMisc = '(?:' + rsUpper + '|' + rsMisc + ')',
    rsOptLowerContr = '(?:' + rsApos + '(?:d|ll|m|re|s|t|ve))?',
    rsOptUpperContr = '(?:' + rsApos + '(?:D|LL|M|RE|S|T|VE))?',
    reOptMod = rsModifier + '?',
    rsOptVar = '[' + rsVarRange + ']?',
    rsOptJoin = '(?:' + rsZWJ + '(?:' + [rsNonAstral, rsRegional, rsSurrPair].join('|') + ')' + rsOptVar + reOptMod + ')*',
    rsSeq = rsOptVar + reOptMod + rsOptJoin,
    rsEmoji = '(?:' + [rsDingbat, rsRegional, rsSurrPair].join('|') + ')' + rsSeq,
    rsSymbol = '(?:' + [rsNonAstral + rsCombo + '?', rsCombo, rsRegional, rsSurrPair, rsAstral].join('|') + ')';

/** Used to match apostrophes. */
var reApos = RegExp(rsApos, 'g');

/**
 * Used to match [combining diacritical marks](https://en.wikipedia.org/wiki/Combining_Diacritical_Marks) and
 * [combining diacritical marks for symbols](https://en.wikipedia.org/wiki/Combining_Diacritical_Marks_for_Symbols).
 */
var reComboMark = RegExp(rsCombo, 'g');

/** Used to match [string symbols](https://mathiasbynens.be/notes/javascript-unicode). */
var reUnicode = RegExp(rsFitz + '(?=' + rsFitz + ')|' + rsSymbol + rsSeq, 'g');

/** Used to match complex or compound words. */
var reUnicodeWord = RegExp([
  rsUpper + '?' + rsLower + '+' + rsOptLowerContr + '(?=' + [rsBreak, rsUpper, '$'].join('|') + ')',
  rsUpperMisc + '+' + rsOptUpperContr + '(?=' + [rsBreak, rsUpper + rsLowerMisc, '$'].join('|') + ')',
  rsUpper + '?' + rsLowerMisc + '+' + rsOptLowerContr,
  rsUpper + '+' + rsOptUpperContr,
  rsDigits,
  rsEmoji
].join('|'), 'g');

/** Used to detect strings with [zero-width joiners or code points from the astral planes](http://eev.ee/blog/2015/09/12/dark-corners-of-unicode/). */
var reHasUnicode = RegExp('[' + rsZWJ + rsAstralRange  + rsComboMarksRange + rsComboSymbolsRange + rsVarRange + ']');

/** Used to detect strings that need a more robust regexp to match words. */
var reHasUnicodeWord = /[a-z][A-Z]|[A-Z]{2,}[a-z]|[0-9][a-zA-Z]|[a-zA-Z][0-9]|[^a-zA-Z0-9 ]/;

/** Used to map Latin Unicode letters to basic Latin letters. */
var deburredLetters = {
  // Latin-1 Supplement block.
  '\xc0': 'A',  '\xc1': 'A', '\xc2': 'A', '\xc3': 'A', '\xc4': 'A', '\xc5': 'A',
  '\xe0': 'a',  '\xe1': 'a', '\xe2': 'a', '\xe3': 'a', '\xe4': 'a', '\xe5': 'a',
  '\xc7': 'C',  '\xe7': 'c',
  '\xd0': 'D',  '\xf0': 'd',
  '\xc8': 'E',  '\xc9': 'E', '\xca': 'E', '\xcb': 'E',
  '\xe8': 'e',  '\xe9': 'e', '\xea': 'e', '\xeb': 'e',
  '\xcc': 'I',  '\xcd': 'I', '\xce': 'I', '\xcf': 'I',
  '\xec': 'i',  '\xed': 'i', '\xee': 'i', '\xef': 'i',
  '\xd1': 'N',  '\xf1': 'n',
  '\xd2': 'O',  '\xd3': 'O', '\xd4': 'O', '\xd5': 'O', '\xd6': 'O', '\xd8': 'O',
  '\xf2': 'o',  '\xf3': 'o', '\xf4': 'o', '\xf5': 'o', '\xf6': 'o', '\xf8': 'o',
  '\xd9': 'U',  '\xda': 'U', '\xdb': 'U', '\xdc': 'U',
  '\xf9': 'u',  '\xfa': 'u', '\xfb': 'u', '\xfc': 'u',
  '\xdd': 'Y',  '\xfd': 'y', '\xff': 'y',
  '\xc6': 'Ae', '\xe6': 'ae',
  '\xde': 'Th', '\xfe': 'th',
  '\xdf': 'ss',
  // Latin Extended-A block.
  '\u0100': 'A',  '\u0102': 'A', '\u0104': 'A',
  '\u0101': 'a',  '\u0103': 'a', '\u0105': 'a',
  '\u0106': 'C',  '\u0108': 'C', '\u010a': 'C', '\u010c': 'C',
  '\u0107': 'c',  '\u0109': 'c', '\u010b': 'c', '\u010d': 'c',
  '\u010e': 'D',  '\u0110': 'D', '\u010f': 'd', '\u0111': 'd',
  '\u0112': 'E',  '\u0114': 'E', '\u0116': 'E', '\u0118': 'E', '\u011a': 'E',
  '\u0113': 'e',  '\u0115': 'e', '\u0117': 'e', '\u0119': 'e', '\u011b': 'e',
  '\u011c': 'G',  '\u011e': 'G', '\u0120': 'G', '\u0122': 'G',
  '\u011d': 'g',  '\u011f': 'g', '\u0121': 'g', '\u0123': 'g',
  '\u0124': 'H',  '\u0126': 'H', '\u0125': 'h', '\u0127': 'h',
  '\u0128': 'I',  '\u012a': 'I', '\u012c': 'I', '\u012e': 'I', '\u0130': 'I',
  '\u0129': 'i',  '\u012b': 'i', '\u012d': 'i', '\u012f': 'i', '\u0131': 'i',
  '\u0134': 'J',  '\u0135': 'j',
  '\u0136': 'K',  '\u0137': 'k', '\u0138': 'k',
  '\u0139': 'L',  '\u013b': 'L', '\u013d': 'L', '\u013f': 'L', '\u0141': 'L',
  '\u013a': 'l',  '\u013c': 'l', '\u013e': 'l', '\u0140': 'l', '\u0142': 'l',
  '\u0143': 'N',  '\u0145': 'N', '\u0147': 'N', '\u014a': 'N',
  '\u0144': 'n',  '\u0146': 'n', '\u0148': 'n', '\u014b': 'n',
  '\u014c': 'O',  '\u014e': 'O', '\u0150': 'O',
  '\u014d': 'o',  '\u014f': 'o', '\u0151': 'o',
  '\u0154': 'R',  '\u0156': 'R', '\u0158': 'R',
  '\u0155': 'r',  '\u0157': 'r', '\u0159': 'r',
  '\u015a': 'S',  '\u015c': 'S', '\u015e': 'S', '\u0160': 'S',
  '\u015b': 's',  '\u015d': 's', '\u015f': 's', '\u0161': 's',
  '\u0162': 'T',  '\u0164': 'T', '\u0166': 'T',
  '\u0163': 't',  '\u0165': 't', '\u0167': 't',
  '\u0168': 'U',  '\u016a': 'U', '\u016c': 'U', '\u016e': 'U', '\u0170': 'U', '\u0172': 'U',
  '\u0169': 'u',  '\u016b': 'u', '\u016d': 'u', '\u016f': 'u', '\u0171': 'u', '\u0173': 'u',
  '\u0174': 'W',  '\u0175': 'w',
  '\u0176': 'Y',  '\u0177': 'y', '\u0178': 'Y',
  '\u0179': 'Z',  '\u017b': 'Z', '\u017d': 'Z',
  '\u017a': 'z',  '\u017c': 'z', '\u017e': 'z',
  '\u0132': 'IJ', '\u0133': 'ij',
  '\u0152': 'Oe', '\u0153': 'oe',
  '\u0149': "'n", '\u017f': 'ss'
};

/** Detect free variable `global` from Node.js. */
var freeGlobal = typeof commonjsGlobal == 'object' && commonjsGlobal && commonjsGlobal.Object === Object && commonjsGlobal;

/** Detect free variable `self`. */
var freeSelf = typeof self == 'object' && self && self.Object === Object && self;

/** Used as a reference to the global object. */
var root = freeGlobal || freeSelf || Function('return this')();

/**
 * A specialized version of `_.reduce` for arrays without support for
 * iteratee shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @param {*} [accumulator] The initial value.
 * @param {boolean} [initAccum] Specify using the first element of `array` as
 *  the initial value.
 * @returns {*} Returns the accumulated value.
 */
function arrayReduce(array, iteratee, accumulator, initAccum) {
  var index = -1,
      length = array ? array.length : 0;

  if (initAccum && length) {
    accumulator = array[++index];
  }
  while (++index < length) {
    accumulator = iteratee(accumulator, array[index], index, array);
  }
  return accumulator;
}

/**
 * Converts an ASCII `string` to an array.
 *
 * @private
 * @param {string} string The string to convert.
 * @returns {Array} Returns the converted array.
 */
function asciiToArray(string) {
  return string.split('');
}

/**
 * Splits an ASCII `string` into an array of its words.
 *
 * @private
 * @param {string} The string to inspect.
 * @returns {Array} Returns the words of `string`.
 */
function asciiWords(string) {
  return string.match(reAsciiWord) || [];
}

/**
 * The base implementation of `_.propertyOf` without support for deep paths.
 *
 * @private
 * @param {Object} object The object to query.
 * @returns {Function} Returns the new accessor function.
 */
function basePropertyOf(object) {
  return function(key) {
    return object == null ? undefined : object[key];
  };
}

/**
 * Used by `_.deburr` to convert Latin-1 Supplement and Latin Extended-A
 * letters to basic Latin letters.
 *
 * @private
 * @param {string} letter The matched letter to deburr.
 * @returns {string} Returns the deburred letter.
 */
var deburrLetter = basePropertyOf(deburredLetters);

/**
 * Checks if `string` contains Unicode symbols.
 *
 * @private
 * @param {string} string The string to inspect.
 * @returns {boolean} Returns `true` if a symbol is found, else `false`.
 */
function hasUnicode(string) {
  return reHasUnicode.test(string);
}

/**
 * Checks if `string` contains a word composed of Unicode symbols.
 *
 * @private
 * @param {string} string The string to inspect.
 * @returns {boolean} Returns `true` if a word is found, else `false`.
 */
function hasUnicodeWord(string) {
  return reHasUnicodeWord.test(string);
}

/**
 * Converts `string` to an array.
 *
 * @private
 * @param {string} string The string to convert.
 * @returns {Array} Returns the converted array.
 */
function stringToArray(string) {
  return hasUnicode(string)
    ? unicodeToArray(string)
    : asciiToArray(string);
}

/**
 * Converts a Unicode `string` to an array.
 *
 * @private
 * @param {string} string The string to convert.
 * @returns {Array} Returns the converted array.
 */
function unicodeToArray(string) {
  return string.match(reUnicode) || [];
}

/**
 * Splits a Unicode `string` into an array of its words.
 *
 * @private
 * @param {string} The string to inspect.
 * @returns {Array} Returns the words of `string`.
 */
function unicodeWords(string) {
  return string.match(reUnicodeWord) || [];
}

/** Used for built-in method references. */
var objectProto = Object.prototype;

/**
 * Used to resolve the
 * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)
 * of values.
 */
var objectToString = objectProto.toString;

/** Built-in value references. */
var Symbol$1 = root.Symbol;

/** Used to convert symbols to primitives and strings. */
var symbolProto = Symbol$1 ? Symbol$1.prototype : undefined,
    symbolToString = symbolProto ? symbolProto.toString : undefined;

/**
 * The base implementation of `_.slice` without an iteratee call guard.
 *
 * @private
 * @param {Array} array The array to slice.
 * @param {number} [start=0] The start position.
 * @param {number} [end=array.length] The end position.
 * @returns {Array} Returns the slice of `array`.
 */
function baseSlice(array, start, end) {
  var index = -1,
      length = array.length;

  if (start < 0) {
    start = -start > length ? 0 : (length + start);
  }
  end = end > length ? length : end;
  if (end < 0) {
    end += length;
  }
  length = start > end ? 0 : ((end - start) >>> 0);
  start >>>= 0;

  var result = Array(length);
  while (++index < length) {
    result[index] = array[index + start];
  }
  return result;
}

/**
 * The base implementation of `_.toString` which doesn't convert nullish
 * values to empty strings.
 *
 * @private
 * @param {*} value The value to process.
 * @returns {string} Returns the string.
 */
function baseToString(value) {
  // Exit early for strings to avoid a performance hit in some environments.
  if (typeof value == 'string') {
    return value;
  }
  if (isSymbol(value)) {
    return symbolToString ? symbolToString.call(value) : '';
  }
  var result = (value + '');
  return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
}

/**
 * Casts `array` to a slice if it's needed.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {number} start The start position.
 * @param {number} [end=array.length] The end position.
 * @returns {Array} Returns the cast slice.
 */
function castSlice(array, start, end) {
  var length = array.length;
  end = end === undefined ? length : end;
  return (!start && end >= length) ? array : baseSlice(array, start, end);
}

/**
 * Creates a function like `_.lowerFirst`.
 *
 * @private
 * @param {string} methodName The name of the `String` case method to use.
 * @returns {Function} Returns the new case function.
 */
function createCaseFirst(methodName) {
  return function(string) {
    string = toString(string);

    var strSymbols = hasUnicode(string)
      ? stringToArray(string)
      : undefined;

    var chr = strSymbols
      ? strSymbols[0]
      : string.charAt(0);

    var trailing = strSymbols
      ? castSlice(strSymbols, 1).join('')
      : string.slice(1);

    return chr[methodName]() + trailing;
  };
}

/**
 * Creates a function like `_.camelCase`.
 *
 * @private
 * @param {Function} callback The function to combine each word.
 * @returns {Function} Returns the new compounder function.
 */
function createCompounder(callback) {
  return function(string) {
    return arrayReduce(words(deburr(string).replace(reApos, '')), callback, '');
  };
}

/**
 * Checks if `value` is object-like. A value is object-like if it's not `null`
 * and has a `typeof` result of "object".
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is object-like, else `false`.
 * @example
 *
 * _.isObjectLike({});
 * // => true
 *
 * _.isObjectLike([1, 2, 3]);
 * // => true
 *
 * _.isObjectLike(_.noop);
 * // => false
 *
 * _.isObjectLike(null);
 * // => false
 */
function isObjectLike(value) {
  return !!value && typeof value == 'object';
}

/**
 * Checks if `value` is classified as a `Symbol` primitive or object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
 * @example
 *
 * _.isSymbol(Symbol.iterator);
 * // => true
 *
 * _.isSymbol('abc');
 * // => false
 */
function isSymbol(value) {
  return typeof value == 'symbol' ||
    (isObjectLike(value) && objectToString.call(value) == symbolTag);
}

/**
 * Converts `value` to a string. An empty string is returned for `null`
 * and `undefined` values. The sign of `-0` is preserved.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to process.
 * @returns {string} Returns the string.
 * @example
 *
 * _.toString(null);
 * // => ''
 *
 * _.toString(-0);
 * // => '-0'
 *
 * _.toString([1, 2, 3]);
 * // => '1,2,3'
 */
function toString(value) {
  return value == null ? '' : baseToString(value);
}

/**
 * Converts `string` to [camel case](https://en.wikipedia.org/wiki/CamelCase).
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category String
 * @param {string} [string=''] The string to convert.
 * @returns {string} Returns the camel cased string.
 * @example
 *
 * _.camelCase('Foo Bar');
 * // => 'fooBar'
 *
 * _.camelCase('--foo-bar--');
 * // => 'fooBar'
 *
 * _.camelCase('__FOO_BAR__');
 * // => 'fooBar'
 */
var camelCase = createCompounder(function(result, word, index) {
  word = word.toLowerCase();
  return result + (index ? capitalize(word) : word);
});

/**
 * Converts the first character of `string` to upper case and the remaining
 * to lower case.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category String
 * @param {string} [string=''] The string to capitalize.
 * @returns {string} Returns the capitalized string.
 * @example
 *
 * _.capitalize('FRED');
 * // => 'Fred'
 */
function capitalize(string) {
  return upperFirst(toString(string).toLowerCase());
}

/**
 * Deburrs `string` by converting
 * [Latin-1 Supplement](https://en.wikipedia.org/wiki/Latin-1_Supplement_(Unicode_block)#Character_table)
 * and [Latin Extended-A](https://en.wikipedia.org/wiki/Latin_Extended-A)
 * letters to basic Latin letters and removing
 * [combining diacritical marks](https://en.wikipedia.org/wiki/Combining_Diacritical_Marks).
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category String
 * @param {string} [string=''] The string to deburr.
 * @returns {string} Returns the deburred string.
 * @example
 *
 * _.deburr('déjà vu');
 * // => 'deja vu'
 */
function deburr(string) {
  string = toString(string);
  return string && string.replace(reLatin, deburrLetter).replace(reComboMark, '');
}

/**
 * Converts the first character of `string` to upper case.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category String
 * @param {string} [string=''] The string to convert.
 * @returns {string} Returns the converted string.
 * @example
 *
 * _.upperFirst('fred');
 * // => 'Fred'
 *
 * _.upperFirst('FRED');
 * // => 'FRED'
 */
var upperFirst = createCaseFirst('toUpperCase');

/**
 * Splits `string` into an array of its words.
 *
 * @static
 * @memberOf _
 * @since 3.0.0
 * @category String
 * @param {string} [string=''] The string to inspect.
 * @param {RegExp|string} [pattern] The pattern to match words.
 * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
 * @returns {Array} Returns the words of `string`.
 * @example
 *
 * _.words('fred, barney, & pebbles');
 * // => ['fred', 'barney', 'pebbles']
 *
 * _.words('fred, barney, & pebbles', /[^, ]+/g);
 * // => ['fred', 'barney', '&', 'pebbles']
 */
function words(string, pattern, guard) {
  string = toString(string);
  pattern = guard ? undefined : pattern;

  if (pattern === undefined) {
    return hasUnicodeWord(string) ? unicodeWords(string) : asciiWords(string);
  }
  return string.match(pattern) || [];
}

var lodash_camelcase = camelCase;

var wasmHashExports = {};
var wasmHash = {
  get exports(){ return wasmHashExports; },
  set exports(v){ wasmHashExports = v; },
};

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/

var hasRequiredWasmHash;

function requireWasmHash () {
	if (hasRequiredWasmHash) return wasmHashExports;
	hasRequiredWasmHash = 1;

	// 65536 is the size of a wasm memory page
	// 64 is the maximum chunk size for every possible wasm hash implementation
	// 4 is the maximum number of bytes per char for string encoding (max is utf-8)
	// ~3 makes sure that it's always a block of 4 chars, so avoid partially encoded bytes for base64
	const MAX_SHORT_STRING = Math.floor((65536 - 64) / 4) & ~3;

	class WasmHash {
	  /**
	   * @param {WebAssembly.Instance} instance wasm instance
	   * @param {WebAssembly.Instance[]} instancesPool pool of instances
	   * @param {number} chunkSize size of data chunks passed to wasm
	   * @param {number} digestSize size of digest returned by wasm
	   */
	  constructor(instance, instancesPool, chunkSize, digestSize) {
	    const exports = /** @type {any} */ (instance.exports);

	    exports.init();

	    this.exports = exports;
	    this.mem = Buffer.from(exports.memory.buffer, 0, 65536);
	    this.buffered = 0;
	    this.instancesPool = instancesPool;
	    this.chunkSize = chunkSize;
	    this.digestSize = digestSize;
	  }

	  reset() {
	    this.buffered = 0;
	    this.exports.init();
	  }

	  /**
	   * @param {Buffer | string} data data
	   * @param {BufferEncoding=} encoding encoding
	   * @returns {this} itself
	   */
	  update(data, encoding) {
	    if (typeof data === "string") {
	      while (data.length > MAX_SHORT_STRING) {
	        this._updateWithShortString(data.slice(0, MAX_SHORT_STRING), encoding);
	        data = data.slice(MAX_SHORT_STRING);
	      }

	      this._updateWithShortString(data, encoding);

	      return this;
	    }

	    this._updateWithBuffer(data);

	    return this;
	  }

	  /**
	   * @param {string} data data
	   * @param {BufferEncoding=} encoding encoding
	   * @returns {void}
	   */
	  _updateWithShortString(data, encoding) {
	    const { exports, buffered, mem, chunkSize } = this;

	    let endPos;

	    if (data.length < 70) {
	      if (!encoding || encoding === "utf-8" || encoding === "utf8") {
	        endPos = buffered;
	        for (let i = 0; i < data.length; i++) {
	          const cc = data.charCodeAt(i);

	          if (cc < 0x80) {
	            mem[endPos++] = cc;
	          } else if (cc < 0x800) {
	            mem[endPos] = (cc >> 6) | 0xc0;
	            mem[endPos + 1] = (cc & 0x3f) | 0x80;
	            endPos += 2;
	          } else {
	            // bail-out for weird chars
	            endPos += mem.write(data.slice(i), endPos, encoding);
	            break;
	          }
	        }
	      } else if (encoding === "latin1") {
	        endPos = buffered;

	        for (let i = 0; i < data.length; i++) {
	          const cc = data.charCodeAt(i);

	          mem[endPos++] = cc;
	        }
	      } else {
	        endPos = buffered + mem.write(data, buffered, encoding);
	      }
	    } else {
	      endPos = buffered + mem.write(data, buffered, encoding);
	    }

	    if (endPos < chunkSize) {
	      this.buffered = endPos;
	    } else {
	      const l = endPos & ~(this.chunkSize - 1);

	      exports.update(l);

	      const newBuffered = endPos - l;

	      this.buffered = newBuffered;

	      if (newBuffered > 0) {
	        mem.copyWithin(0, l, endPos);
	      }
	    }
	  }

	  /**
	   * @param {Buffer} data data
	   * @returns {void}
	   */
	  _updateWithBuffer(data) {
	    const { exports, buffered, mem } = this;
	    const length = data.length;

	    if (buffered + length < this.chunkSize) {
	      data.copy(mem, buffered, 0, length);

	      this.buffered += length;
	    } else {
	      const l = (buffered + length) & ~(this.chunkSize - 1);

	      if (l > 65536) {
	        let i = 65536 - buffered;

	        data.copy(mem, buffered, 0, i);
	        exports.update(65536);

	        const stop = l - buffered - 65536;

	        while (i < stop) {
	          data.copy(mem, 0, i, i + 65536);
	          exports.update(65536);
	          i += 65536;
	        }

	        data.copy(mem, 0, i, l - buffered);

	        exports.update(l - buffered - i);
	      } else {
	        data.copy(mem, buffered, 0, l - buffered);

	        exports.update(l);
	      }

	      const newBuffered = length + buffered - l;

	      this.buffered = newBuffered;

	      if (newBuffered > 0) {
	        data.copy(mem, 0, length - newBuffered, length);
	      }
	    }
	  }

	  digest(type) {
	    const { exports, buffered, mem, digestSize } = this;

	    exports.final(buffered);

	    this.instancesPool.push(this);

	    const hex = mem.toString("latin1", 0, digestSize);

	    if (type === "hex") {
	      return hex;
	    }

	    if (type === "binary" || !type) {
	      return Buffer.from(hex, "hex");
	    }

	    return Buffer.from(hex, "hex").toString(type);
	  }
	}

	const create = (wasmModule, instancesPool, chunkSize, digestSize) => {
	  if (instancesPool.length > 0) {
	    const old = instancesPool.pop();

	    old.reset();

	    return old;
	  } else {
	    return new WasmHash(
	      new WebAssembly.Instance(wasmModule),
	      instancesPool,
	      chunkSize,
	      digestSize
	    );
	  }
	};

	wasmHash.exports = create;
	wasmHashExports.MAX_SHORT_STRING = MAX_SHORT_STRING;
	return wasmHashExports;
}

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/

var xxhash64_1;
var hasRequiredXxhash64;

function requireXxhash64 () {
	if (hasRequiredXxhash64) return xxhash64_1;
	hasRequiredXxhash64 = 1;

	const create = requireWasmHash();

	//#region wasm code: xxhash64 (../../../assembly/hash/xxhash64.asm.ts) --initialMemory 1
	const xxhash64 = new WebAssembly.Module(
	  Buffer.from(
	    // 1173 bytes
	    "AGFzbQEAAAABCAJgAX8AYAAAAwQDAQAABQMBAAEGGgV+AUIAC34BQgALfgFCAAt+AUIAC34BQgALByIEBGluaXQAAAZ1cGRhdGUAAQVmaW5hbAACBm1lbW9yeQIACrUIAzAAQtbrgu7q/Yn14AAkAELP1tO+0ser2UIkAUIAJAJC+erQ0OfJoeThACQDQgAkBAvUAQIBfwR+IABFBEAPCyMEIACtfCQEIwAhAiMBIQMjAiEEIwMhBQNAIAIgASkDAELP1tO+0ser2UJ+fEIfiUKHla+vmLbem55/fiECIAMgASkDCELP1tO+0ser2UJ+fEIfiUKHla+vmLbem55/fiEDIAQgASkDEELP1tO+0ser2UJ+fEIfiUKHla+vmLbem55/fiEEIAUgASkDGELP1tO+0ser2UJ+fEIfiUKHla+vmLbem55/fiEFIAAgAUEgaiIBSw0ACyACJAAgAyQBIAQkAiAFJAMLqwYCAX8EfiMEQgBSBH4jACICQgGJIwEiA0IHiXwjAiIEQgyJfCMDIgVCEol8IAJCz9bTvtLHq9lCfkIfiUKHla+vmLbem55/foVCh5Wvr5i23puef35CnaO16oOxjYr6AH0gA0LP1tO+0ser2UJ+Qh+JQoeVr6+Ytt6bnn9+hUKHla+vmLbem55/fkKdo7Xqg7GNivoAfSAEQs/W077Sx6vZQn5CH4lCh5Wvr5i23puef36FQoeVr6+Ytt6bnn9+Qp2jteqDsY2K+gB9IAVCz9bTvtLHq9lCfkIfiUKHla+vmLbem55/foVCh5Wvr5i23puef35CnaO16oOxjYr6AH0FQsXP2bLx5brqJwsjBCAArXx8IQIDQCABQQhqIABNBEAgAiABKQMAQs/W077Sx6vZQn5CH4lCh5Wvr5i23puef36FQhuJQoeVr6+Ytt6bnn9+Qp2jteqDsY2K+gB9IQIgAUEIaiEBDAELCyABQQRqIABNBEACfyACIAE1AgBCh5Wvr5i23puef36FQheJQs/W077Sx6vZQn5C+fPd8Zn2masWfCECIAFBBGoLIQELA0AgACABRwRAIAIgATEAAELFz9my8eW66id+hUILiUKHla+vmLbem55/fiECIAFBAWohAQwBCwtBACACIAJCIYiFQs/W077Sx6vZQn4iAiACQh2IhUL5893xmfaZqxZ+IgIgAkIgiIUiAkIgiCIDQv//A4NCIIYgA0KAgPz/D4NCEIiEIgNC/4GAgPAfg0IQhiADQoD+g4CA4D+DQgiIhCIDQo+AvIDwgcAHg0IIhiADQvCBwIeAnoD4AINCBIiEIgNChoyYsODAgYMGfEIEiEKBgoSIkKDAgAGDQid+IANCsODAgYOGjJgwhHw3AwBBCCACQv////8PgyICQv//A4NCIIYgAkKAgPz/D4NCEIiEIgJC/4GAgPAfg0IQhiACQoD+g4CA4D+DQgiIhCICQo+AvIDwgcAHg0IIhiACQvCBwIeAnoD4AINCBIiEIgJChoyYsODAgYMGfEIEiEKBgoSIkKDAgAGDQid+IAJCsODAgYOGjJgwhHw3AwAL",
	    "base64"
	  )
	);
	//#endregion

	xxhash64_1 = create.bind(null, xxhash64, [], 32, 16);
	return xxhash64_1;
}

var BatchedHash_1;
var hasRequiredBatchedHash;

function requireBatchedHash () {
	if (hasRequiredBatchedHash) return BatchedHash_1;
	hasRequiredBatchedHash = 1;
	const MAX_SHORT_STRING = requireWasmHash().MAX_SHORT_STRING;

	class BatchedHash {
	  constructor(hash) {
	    this.string = undefined;
	    this.encoding = undefined;
	    this.hash = hash;
	  }

	  /**
	   * Update hash {@link https://nodejs.org/api/crypto.html#crypto_hash_update_data_inputencoding}
	   * @param {string|Buffer} data data
	   * @param {string=} inputEncoding data encoding
	   * @returns {this} updated hash
	   */
	  update(data, inputEncoding) {
	    if (this.string !== undefined) {
	      if (
	        typeof data === "string" &&
	        inputEncoding === this.encoding &&
	        this.string.length + data.length < MAX_SHORT_STRING
	      ) {
	        this.string += data;

	        return this;
	      }

	      this.hash.update(this.string, this.encoding);
	      this.string = undefined;
	    }

	    if (typeof data === "string") {
	      if (
	        data.length < MAX_SHORT_STRING &&
	        // base64 encoding is not valid since it may contain padding chars
	        (!inputEncoding || !inputEncoding.startsWith("ba"))
	      ) {
	        this.string = data;
	        this.encoding = inputEncoding;
	      } else {
	        this.hash.update(data, inputEncoding);
	      }
	    } else {
	      this.hash.update(data);
	    }

	    return this;
	  }

	  /**
	   * Calculates the digest {@link https://nodejs.org/api/crypto.html#crypto_hash_digest_encoding}
	   * @param {string=} encoding encoding of the return value
	   * @returns {string|Buffer} digest
	   */
	  digest(encoding) {
	    if (this.string !== undefined) {
	      this.hash.update(this.string, this.encoding);
	    }

	    return this.hash.digest(encoding);
	  }
	}

	BatchedHash_1 = BatchedHash;
	return BatchedHash_1;
}

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/

var md4_1;
var hasRequiredMd4;

function requireMd4 () {
	if (hasRequiredMd4) return md4_1;
	hasRequiredMd4 = 1;

	const create = requireWasmHash();

	//#region wasm code: md4 (../../../assembly/hash/md4.asm.ts) --initialMemory 1
	const md4 = new WebAssembly.Module(
	  Buffer.from(
	    // 2150 bytes
	    "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",
	    "base64"
	  )
	);
	//#endregion

	md4_1 = create.bind(null, md4, [], 64, 32);
	return md4_1;
}

var BulkUpdateDecorator_1;
var hasRequiredBulkUpdateDecorator;

function requireBulkUpdateDecorator () {
	if (hasRequiredBulkUpdateDecorator) return BulkUpdateDecorator_1;
	hasRequiredBulkUpdateDecorator = 1;
	const BULK_SIZE = 2000;

	// We are using an object instead of a Map as this will stay static during the runtime
	// so access to it can be optimized by v8
	const digestCaches = {};

	class BulkUpdateDecorator {
	  /**
	   * @param {Hash | function(): Hash} hashOrFactory function to create a hash
	   * @param {string=} hashKey key for caching
	   */
	  constructor(hashOrFactory, hashKey) {
	    this.hashKey = hashKey;

	    if (typeof hashOrFactory === "function") {
	      this.hashFactory = hashOrFactory;
	      this.hash = undefined;
	    } else {
	      this.hashFactory = undefined;
	      this.hash = hashOrFactory;
	    }

	    this.buffer = "";
	  }

	  /**
	   * Update hash {@link https://nodejs.org/api/crypto.html#crypto_hash_update_data_inputencoding}
	   * @param {string|Buffer} data data
	   * @param {string=} inputEncoding data encoding
	   * @returns {this} updated hash
	   */
	  update(data, inputEncoding) {
	    if (
	      inputEncoding !== undefined ||
	      typeof data !== "string" ||
	      data.length > BULK_SIZE
	    ) {
	      if (this.hash === undefined) {
	        this.hash = this.hashFactory();
	      }

	      if (this.buffer.length > 0) {
	        this.hash.update(this.buffer);
	        this.buffer = "";
	      }

	      this.hash.update(data, inputEncoding);
	    } else {
	      this.buffer += data;

	      if (this.buffer.length > BULK_SIZE) {
	        if (this.hash === undefined) {
	          this.hash = this.hashFactory();
	        }

	        this.hash.update(this.buffer);
	        this.buffer = "";
	      }
	    }

	    return this;
	  }

	  /**
	   * Calculates the digest {@link https://nodejs.org/api/crypto.html#crypto_hash_digest_encoding}
	   * @param {string=} encoding encoding of the return value
	   * @returns {string|Buffer} digest
	   */
	  digest(encoding) {
	    let digestCache;

	    const buffer = this.buffer;

	    if (this.hash === undefined) {
	      // short data for hash, we can use caching
	      const cacheKey = `${this.hashKey}-${encoding}`;

	      digestCache = digestCaches[cacheKey];

	      if (digestCache === undefined) {
	        digestCache = digestCaches[cacheKey] = new Map();
	      }

	      const cacheEntry = digestCache.get(buffer);

	      if (cacheEntry !== undefined) {
	        return cacheEntry;
	      }

	      this.hash = this.hashFactory();
	    }

	    if (buffer.length > 0) {
	      this.hash.update(buffer);
	    }

	    const digestResult = this.hash.digest(encoding);

	    if (digestCache !== undefined) {
	      digestCache.set(buffer, digestResult);
	    }

	    return digestResult;
	  }
	}

	BulkUpdateDecorator_1 = BulkUpdateDecorator;
	return BulkUpdateDecorator_1;
}

const baseEncodeTables = {
  26: "abcdefghijklmnopqrstuvwxyz",
  32: "123456789abcdefghjkmnpqrstuvwxyz", // no 0lio
  36: "0123456789abcdefghijklmnopqrstuvwxyz",
  49: "abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ", // no lIO
  52: "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ",
  58: "123456789abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ", // no 0lIO
  62: "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ",
  64: "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ-_",
};

/**
 * @param {Uint32Array} uint32Array Treated as a long base-0x100000000 number, little endian
 * @param {number} divisor The divisor
 * @return {number} Modulo (remainder) of the division
 */
function divmod32(uint32Array, divisor) {
  let carry = 0;
  for (let i = uint32Array.length - 1; i >= 0; i--) {
    const value = carry * 0x100000000 + uint32Array[i];
    carry = value % divisor;
    uint32Array[i] = Math.floor(value / divisor);
  }
  return carry;
}

function encodeBufferToBase(buffer, base, length) {
  const encodeTable = baseEncodeTables[base];

  if (!encodeTable) {
    throw new Error("Unknown encoding base" + base);
  }

  // Input bits are only enough to generate this many characters
  const limit = Math.ceil((buffer.length * 8) / Math.log2(base));
  length = Math.min(length, limit);

  // Most of the crypto digests (if not all) has length a multiple of 4 bytes.
  // Fewer numbers in the array means faster math.
  const uint32Array = new Uint32Array(Math.ceil(buffer.length / 4));

  // Make sure the input buffer data is copied and is not mutated by reference.
  // divmod32() would corrupt the BulkUpdateDecorator cache otherwise.
  buffer.copy(Buffer.from(uint32Array.buffer));

  let output = "";

  for (let i = 0; i < length; i++) {
    output = encodeTable[divmod32(uint32Array, base)] + output;
  }

  return output;
}

let crypto = undefined;
let createXXHash64 = undefined;
let createMd4 = undefined;
let BatchedHash = undefined;
let BulkUpdateDecorator = undefined;

function getHashDigest$1(buffer, algorithm, digestType, maxLength) {
  algorithm = algorithm || "xxhash64";
  maxLength = maxLength || 9999;

  let hash;

  if (algorithm === "xxhash64") {
    if (createXXHash64 === undefined) {
      createXXHash64 = requireXxhash64();

      if (BatchedHash === undefined) {
        BatchedHash = requireBatchedHash();
      }
    }

    hash = new BatchedHash(createXXHash64());
  } else if (algorithm === "md4") {
    if (createMd4 === undefined) {
      createMd4 = requireMd4();

      if (BatchedHash === undefined) {
        BatchedHash = requireBatchedHash();
      }
    }

    hash = new BatchedHash(createMd4());
  } else if (algorithm === "native-md4") {
    if (typeof crypto === "undefined") {
      crypto = require("crypto");

      if (BulkUpdateDecorator === undefined) {
        BulkUpdateDecorator = requireBulkUpdateDecorator();
      }
    }

    hash = new BulkUpdateDecorator(() => crypto.createHash("md4"), "md4");
  } else {
    if (typeof crypto === "undefined") {
      crypto = require("crypto");

      if (BulkUpdateDecorator === undefined) {
        BulkUpdateDecorator = requireBulkUpdateDecorator();
      }
    }

    hash = new BulkUpdateDecorator(
      () => crypto.createHash(algorithm),
      algorithm
    );
  }

  hash.update(buffer);

  if (
    digestType === "base26" ||
    digestType === "base32" ||
    digestType === "base36" ||
    digestType === "base49" ||
    digestType === "base52" ||
    digestType === "base58" ||
    digestType === "base62"
  ) {
    return encodeBufferToBase(hash.digest(), digestType.substr(4), maxLength);
  } else {
    return hash.digest(digestType || "hex").substr(0, maxLength);
  }
}

var getHashDigest_1 = getHashDigest$1;

const path$1 = path$2;
const getHashDigest = getHashDigest_1;

function interpolateName$1(loaderContext, name, options = {}) {
  let filename;

  const hasQuery =
    loaderContext.resourceQuery && loaderContext.resourceQuery.length > 1;

  if (typeof name === "function") {
    filename = name(
      loaderContext.resourcePath,
      hasQuery ? loaderContext.resourceQuery : undefined
    );
  } else {
    filename = name || "[hash].[ext]";
  }

  const context = options.context;
  const content = options.content;
  const regExp = options.regExp;

  let ext = "bin";
  let basename = "file";
  let directory = "";
  let folder = "";
  let query = "";

  if (loaderContext.resourcePath) {
    const parsed = path$1.parse(loaderContext.resourcePath);
    let resourcePath = loaderContext.resourcePath;

    if (parsed.ext) {
      ext = parsed.ext.substr(1);
    }

    if (parsed.dir) {
      basename = parsed.name;
      resourcePath = parsed.dir + path$1.sep;
    }

    if (typeof context !== "undefined") {
      directory = path$1
        .relative(context, resourcePath + "_")
        .replace(/\\/g, "/")
        .replace(/\.\.(\/)?/g, "_$1");
      directory = directory.substr(0, directory.length - 1);
    } else {
      directory = resourcePath.replace(/\\/g, "/").replace(/\.\.(\/)?/g, "_$1");
    }

    if (directory.length === 1) {
      directory = "";
    } else if (directory.length > 1) {
      folder = path$1.basename(directory);
    }
  }

  if (loaderContext.resourceQuery && loaderContext.resourceQuery.length > 1) {
    query = loaderContext.resourceQuery;

    const hashIdx = query.indexOf("#");

    if (hashIdx >= 0) {
      query = query.substr(0, hashIdx);
    }
  }

  let url = filename;

  if (content) {
    // Match hash template
    url = url
      // `hash` and `contenthash` are same in `loader-utils` context
      // let's keep `hash` for backward compatibility
      .replace(
        /\[(?:([^[:\]]+):)?(?:hash|contenthash)(?::([a-z]+\d*))?(?::(\d+))?\]/gi,
        (all, hashType, digestType, maxLength) =>
          getHashDigest(content, hashType, digestType, parseInt(maxLength, 10))
      );
  }

  url = url
    .replace(/\[ext\]/gi, () => ext)
    .replace(/\[name\]/gi, () => basename)
    .replace(/\[path\]/gi, () => directory)
    .replace(/\[folder\]/gi, () => folder)
    .replace(/\[query\]/gi, () => query);

  if (regExp && loaderContext.resourcePath) {
    const match = loaderContext.resourcePath.match(new RegExp(regExp));

    match &&
      match.forEach((matched, i) => {
        url = url.replace(new RegExp("\\[" + i + "\\]", "ig"), matched);
      });
  }

  if (
    typeof loaderContext.options === "object" &&
    typeof loaderContext.options.customInterpolateName === "function"
  ) {
    url = loaderContext.options.customInterpolateName.call(
      loaderContext,
      url,
      name,
      options
    );
  }

  return url;
}

var interpolateName_1 = interpolateName$1;

var interpolateName = interpolateName_1;
var path = path$2;

/**
 * @param  {string} pattern
 * @param  {object} options
 * @param  {string} options.context
 * @param  {string} options.hashPrefix
 * @return {function}
 */
var genericNames = function createGenerator(pattern, options) {
  options = options || {};
  var context =
    options && typeof options.context === "string"
      ? options.context
      : process.cwd();
  var hashPrefix =
    options && typeof options.hashPrefix === "string" ? options.hashPrefix : "";

  /**
   * @param  {string} localName Usually a class name
   * @param  {string} filepath  Absolute path
   * @return {string}
   */
  return function generate(localName, filepath) {
    var name = pattern.replace(/\[local\]/gi, localName);
    var loaderContext = {
      resourcePath: filepath,
    };

    var loaderOptions = {
      content:
        hashPrefix +
        path.relative(context, filepath).replace(/\\/g, "/") +
        "\x00" +
        localName,
      context: context,
    };

    var genericName = interpolateName(loaderContext, name, loaderOptions);
    return genericName
      .replace(new RegExp("[^a-zA-Z0-9\\-_\u00A0-\uFFFF]", "g"), "-")
      .replace(/^((-?[0-9])|--)/, "_$1");
  };
};

var unquote$1 = {};

Object.defineProperty(unquote$1, "__esModule", {
  value: true
});
unquote$1.default = unquote;
// copied from https://github.com/lakenen/node-unquote

var reg = /['"]/;

function unquote(str) {
  if (!str) {
    return "";
  }
  if (reg.test(str.charAt(0))) {
    str = str.substr(1);
  }
  if (reg.test(str.charAt(str.length - 1))) {
    str = str.substr(0, str.length - 1);
  }
  return str;
}

var parser = {};

var lib$1 = {};

Object.defineProperty(lib$1, "__esModule", {
  value: true
});
lib$1.replaceAll = replaceAll;
var matchConstName = /[$#]?[\w-\.]+/g;

function replaceAll(replacements, text) {
  var matches = void 0;
  while (matches = matchConstName.exec(text)) {
    var replacement = replacements[matches[0]];
    if (replacement) {
      text = text.slice(0, matches.index) + replacement + text.slice(matchConstName.lastIndex);
      matchConstName.lastIndex -= matches[0].length - replacement.length;
    }
  }
  return text;
}

lib$1.default = function (css, translations) {
  css.walkDecls(function (decl) {
    return decl.value = replaceAll(translations, decl.value);
  });
  css.walkAtRules('media', function (atRule) {
    return atRule.params = replaceAll(translations, atRule.params);
  });
};

Object.defineProperty(parser, "__esModule", {
  value: true
});

var _icssReplaceSymbols = lib$1;

var _icssReplaceSymbols2 = _interopRequireDefault$4(_icssReplaceSymbols);

function _interopRequireDefault$4(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Copied from https://github.com/css-modules/css-modules-loader-core

const importRegexp = /^:import\((.+)\)$/;
class Parser {
  constructor(pathFetcher, trace) {
    this.pathFetcher = pathFetcher;
    this.plugin = this.plugin.bind(this);
    this.exportTokens = {};
    this.translations = {};
    this.trace = trace;
  }

  plugin() {
    const parser = this;
    return {
      postcssPlugin: "css-modules-parser",
      OnceExit(css) {
        return Promise.all(parser.fetchAllImports(css)).then(() => parser.linkImportedSymbols(css)).then(() => parser.extractExports(css));
      }
    };
  }

  fetchAllImports(css) {
    let imports = [];
    css.each(node => {
      if (node.type == "rule" && node.selector.match(importRegexp)) {
        imports.push(this.fetchImport(node, css.source.input.from, imports.length));
      }
    });
    return imports;
  }

  linkImportedSymbols(css) {
    (0, _icssReplaceSymbols2.default)(css, this.translations);
  }

  extractExports(css) {
    css.each(node => {
      if (node.type == "rule" && node.selector == ":export") this.handleExport(node);
    });
  }

  handleExport(exportNode) {
    exportNode.each(decl => {
      if (decl.type == "decl") {
        Object.keys(this.translations).forEach(translation => {
          decl.value = decl.value.replace(translation, this.translations[translation]);
        });
        this.exportTokens[decl.prop] = decl.value;
      }
    });
    exportNode.remove();
  }

  fetchImport(importNode, relativeTo, depNr) {
    let file = importNode.selector.match(importRegexp)[1],
        depTrace = this.trace + String.fromCharCode(depNr);
    return this.pathFetcher(file, relativeTo, depTrace).then(exports => {
      importNode.each(decl => {
        if (decl.type == "decl") {
          this.translations[decl.prop] = exports[decl.value];
        }
      });
      importNode.remove();
    }, err => console.log(err));
  }
}
parser.default = Parser;

var loader = {};

Object.defineProperty(loader, "__esModule", {
  value: true
});

var _postcss$1 = require$$0$2;

var _postcss2$1 = _interopRequireDefault$3(_postcss$1);

var _fs$1 = require$$0;

var _fs2 = _interopRequireDefault$3(_fs$1);

var _path = path$2;

var _path2 = _interopRequireDefault$3(_path);

var _parser$1 = parser;

var _parser2$1 = _interopRequireDefault$3(_parser$1);

function _interopRequireDefault$3(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// Copied from https://github.com/css-modules/css-modules-loader-core

class Core {
  constructor(plugins) {
    this.plugins = plugins || Core.defaultPlugins;
  }

  load(sourceString, sourcePath, trace, pathFetcher) {
    let parser = new _parser2$1.default(pathFetcher, trace);

    return (0, _postcss2$1.default)(this.plugins.concat([parser.plugin()])).process(sourceString, { from: "/" + sourcePath }).then(result => {
      return {
        injectableSource: result.css,
        exportTokens: parser.exportTokens
      };
    });
  }
}

// Sorts dependencies in the following way:
// AAA comes before AA and A
// AB comes after AA and before A
// All Bs come after all As
// This ensures that the files are always returned in the following order:
// - In the order they were required, except
// - After all their dependencies
const traceKeySorter = (a, b) => {
  if (a.length < b.length) {
    return a < b.substring(0, a.length) ? -1 : 1;
  } else if (a.length > b.length) {
    return a.substring(0, b.length) <= b ? -1 : 1;
  } else {
    return a < b ? -1 : 1;
  }
};

class FileSystemLoader {
  constructor(root, plugins) {
    this.root = root;
    this.sources = {};
    this.traces = {};
    this.importNr = 0;
    this.core = new Core(plugins);
    this.tokensByFile = {};
  }

  fetch(_newPath, relativeTo, _trace) {
    let newPath = _newPath.replace(/^["']|["']$/g, ""),
        trace = _trace || String.fromCharCode(this.importNr++);
    return new Promise((resolve, reject) => {
      let relativeDir = _path2.default.dirname(relativeTo),
          rootRelativePath = _path2.default.resolve(relativeDir, newPath),
          fileRelativePath = _path2.default.resolve(_path2.default.join(this.root, relativeDir), newPath);

      // if the path is not relative or absolute, try to resolve it in node_modules
      if (newPath[0] !== "." && newPath[0] !== "/") {
        try {
          fileRelativePath = require.resolve(newPath);
        } catch (e) {
          // noop
        }
      }

      const tokens = this.tokensByFile[fileRelativePath];
      if (tokens) {
        return resolve(tokens);
      }

      _fs2.default.readFile(fileRelativePath, "utf-8", (err, source) => {
        if (err) reject(err);
        this.core.load(source, rootRelativePath, trace, this.fetch.bind(this)).then(({ injectableSource, exportTokens }) => {
          this.sources[fileRelativePath] = injectableSource;
          this.traces[trace] = fileRelativePath;
          this.tokensByFile[fileRelativePath] = exportTokens;
          resolve(exportTokens);
        }, reject);
      });
    });
  }

  get finalSource() {
    const traces = this.traces;
    const sources = this.sources;
    let written = new Set();

    return Object.keys(traces).sort(traceKeySorter).map(key => {
      const filename = traces[key];
      if (written.has(filename)) {
        return null;
      }
      written.add(filename);

      return sources[filename];
    }).join("");
  }
}
loader.default = FileSystemLoader;

var generateScopedName$1 = {};

function hash(str) {
  var hash = 5381,
      i    = str.length;

  while(i) {
    hash = (hash * 33) ^ str.charCodeAt(--i);
  }

  /* JavaScript does bitwise operations (like XOR, above) on 32-bit signed
   * integers. Since we want the results to be always positive, convert the
   * signed int to an unsigned by doing an unsigned bitshift. */
  return hash >>> 0;
}

var stringHash = hash;

Object.defineProperty(generateScopedName$1, "__esModule", {
  value: true
});
generateScopedName$1.default = generateScopedName;

var _stringHash = stringHash;

var _stringHash2 = _interopRequireDefault$2(_stringHash);

function _interopRequireDefault$2(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function generateScopedName(name, filename, css) {
  const i = css.indexOf(`.${name}`);
  const lineNumber = css.substr(0, i).split(/[\r\n]/).length;
  const hash = (0, _stringHash2.default)(css).toString(36).substr(0, 5);

  return `_${name}_${hash}_${lineNumber}`;
}

var saveJSON$1 = {};

Object.defineProperty(saveJSON$1, "__esModule", {
  value: true
});
saveJSON$1.default = saveJSON;

var _fs = require$$0;

function saveJSON(cssFile, json) {
  return new Promise((resolve, reject) => {
    (0, _fs.writeFile)(`${cssFile}.json`, JSON.stringify(json), e => e ? reject(e) : resolve(json));
  });
}

var behaviours$1 = {};

var srcExports$2 = {};
var src$4 = {
  get exports(){ return srcExports$2; },
  set exports(v){ srcExports$2 = v; },
};

var openParentheses = "(".charCodeAt(0);
var closeParentheses = ")".charCodeAt(0);
var singleQuote = "'".charCodeAt(0);
var doubleQuote = '"'.charCodeAt(0);
var backslash = "\\".charCodeAt(0);
var slash = "/".charCodeAt(0);
var comma = ",".charCodeAt(0);
var colon = ":".charCodeAt(0);
var star = "*".charCodeAt(0);
var uLower = "u".charCodeAt(0);
var uUpper = "U".charCodeAt(0);
var plus = "+".charCodeAt(0);
var isUnicodeRange = /^[a-f0-9?-]+$/i;

var parse$1 = function(input) {
  var tokens = [];
  var value = input;

  var next,
    quote,
    prev,
    token,
    escape,
    escapePos,
    whitespacePos,
    parenthesesOpenPos;
  var pos = 0;
  var code = value.charCodeAt(pos);
  var max = value.length;
  var stack = [{ nodes: tokens }];
  var balanced = 0;
  var parent;

  var name = "";
  var before = "";
  var after = "";

  while (pos < max) {
    // Whitespaces
    if (code <= 32) {
      next = pos;
      do {
        next += 1;
        code = value.charCodeAt(next);
      } while (code <= 32);
      token = value.slice(pos, next);

      prev = tokens[tokens.length - 1];
      if (code === closeParentheses && balanced) {
        after = token;
      } else if (prev && prev.type === "div") {
        prev.after = token;
        prev.sourceEndIndex += token.length;
      } else if (
        code === comma ||
        code === colon ||
        (code === slash &&
          value.charCodeAt(next + 1) !== star &&
          (!parent ||
            (parent && parent.type === "function" && parent.value !== "calc")))
      ) {
        before = token;
      } else {
        tokens.push({
          type: "space",
          sourceIndex: pos,
          sourceEndIndex: next,
          value: token
        });
      }

      pos = next;

      // Quotes
    } else if (code === singleQuote || code === doubleQuote) {
      next = pos;
      quote = code === singleQuote ? "'" : '"';
      token = {
        type: "string",
        sourceIndex: pos,
        quote: quote
      };
      do {
        escape = false;
        next = value.indexOf(quote, next + 1);
        if (~next) {
          escapePos = next;
          while (value.charCodeAt(escapePos - 1) === backslash) {
            escapePos -= 1;
            escape = !escape;
          }
        } else {
          value += quote;
          next = value.length - 1;
          token.unclosed = true;
        }
      } while (escape);
      token.value = value.slice(pos + 1, next);
      token.sourceEndIndex = token.unclosed ? next : next + 1;
      tokens.push(token);
      pos = next + 1;
      code = value.charCodeAt(pos);

      // Comments
    } else if (code === slash && value.charCodeAt(pos + 1) === star) {
      next = value.indexOf("*/", pos);

      token = {
        type: "comment",
        sourceIndex: pos,
        sourceEndIndex: next + 2
      };

      if (next === -1) {
        token.unclosed = true;
        next = value.length;
        token.sourceEndIndex = next;
      }

      token.value = value.slice(pos + 2, next);
      tokens.push(token);

      pos = next + 2;
      code = value.charCodeAt(pos);

      // Operation within calc
    } else if (
      (code === slash || code === star) &&
      parent &&
      parent.type === "function" &&
      parent.value === "calc"
    ) {
      token = value[pos];
      tokens.push({
        type: "word",
        sourceIndex: pos - before.length,
        sourceEndIndex: pos + token.length,
        value: token
      });
      pos += 1;
      code = value.charCodeAt(pos);

      // Dividers
    } else if (code === slash || code === comma || code === colon) {
      token = value[pos];

      tokens.push({
        type: "div",
        sourceIndex: pos - before.length,
        sourceEndIndex: pos + token.length,
        value: token,
        before: before,
        after: ""
      });
      before = "";

      pos += 1;
      code = value.charCodeAt(pos);

      // Open parentheses
    } else if (openParentheses === code) {
      // Whitespaces after open parentheses
      next = pos;
      do {
        next += 1;
        code = value.charCodeAt(next);
      } while (code <= 32);
      parenthesesOpenPos = pos;
      token = {
        type: "function",
        sourceIndex: pos - name.length,
        value: name,
        before: value.slice(parenthesesOpenPos + 1, next)
      };
      pos = next;

      if (name === "url" && code !== singleQuote && code !== doubleQuote) {
        next -= 1;
        do {
          escape = false;
          next = value.indexOf(")", next + 1);
          if (~next) {
            escapePos = next;
            while (value.charCodeAt(escapePos - 1) === backslash) {
              escapePos -= 1;
              escape = !escape;
            }
          } else {
            value += ")";
            next = value.length - 1;
            token.unclosed = true;
          }
        } while (escape);
        // Whitespaces before closed
        whitespacePos = next;
        do {
          whitespacePos -= 1;
          code = value.charCodeAt(whitespacePos);
        } while (code <= 32);
        if (parenthesesOpenPos < whitespacePos) {
          if (pos !== whitespacePos + 1) {
            token.nodes = [
              {
                type: "word",
                sourceIndex: pos,
                sourceEndIndex: whitespacePos + 1,
                value: value.slice(pos, whitespacePos + 1)
              }
            ];
          } else {
            token.nodes = [];
          }
          if (token.unclosed && whitespacePos + 1 !== next) {
            token.after = "";
            token.nodes.push({
              type: "space",
              sourceIndex: whitespacePos + 1,
              sourceEndIndex: next,
              value: value.slice(whitespacePos + 1, next)
            });
          } else {
            token.after = value.slice(whitespacePos + 1, next);
            token.sourceEndIndex = next;
          }
        } else {
          token.after = "";
          token.nodes = [];
        }
        pos = next + 1;
        token.sourceEndIndex = token.unclosed ? next : pos;
        code = value.charCodeAt(pos);
        tokens.push(token);
      } else {
        balanced += 1;
        token.after = "";
        token.sourceEndIndex = pos + 1;
        tokens.push(token);
        stack.push(token);
        tokens = token.nodes = [];
        parent = token;
      }
      name = "";

      // Close parentheses
    } else if (closeParentheses === code && balanced) {
      pos += 1;
      code = value.charCodeAt(pos);

      parent.after = after;
      parent.sourceEndIndex += after.length;
      after = "";
      balanced -= 1;
      stack[stack.length - 1].sourceEndIndex = pos;
      stack.pop();
      parent = stack[balanced];
      tokens = parent.nodes;

      // Words
    } else {
      next = pos;
      do {
        if (code === backslash) {
          next += 1;
        }
        next += 1;
        code = value.charCodeAt(next);
      } while (
        next < max &&
        !(
          code <= 32 ||
          code === singleQuote ||
          code === doubleQuote ||
          code === comma ||
          code === colon ||
          code === slash ||
          code === openParentheses ||
          (code === star &&
            parent &&
            parent.type === "function" &&
            parent.value === "calc") ||
          (code === slash &&
            parent.type === "function" &&
            parent.value === "calc") ||
          (code === closeParentheses && balanced)
        )
      );
      token = value.slice(pos, next);

      if (openParentheses === code) {
        name = token;
      } else if (
        (uLower === token.charCodeAt(0) || uUpper === token.charCodeAt(0)) &&
        plus === token.charCodeAt(1) &&
        isUnicodeRange.test(token.slice(2))
      ) {
        tokens.push({
          type: "unicode-range",
          sourceIndex: pos,
          sourceEndIndex: next,
          value: token
        });
      } else {
        tokens.push({
          type: "word",
          sourceIndex: pos,
          sourceEndIndex: next,
          value: token
        });
      }

      pos = next;
    }
  }

  for (pos = stack.length - 1; pos; pos -= 1) {
    stack[pos].unclosed = true;
    stack[pos].sourceEndIndex = value.length;
  }

  return stack[0].nodes;
};

var walk$2 = function walk(nodes, cb, bubble) {
  var i, max, node, result;

  for (i = 0, max = nodes.length; i < max; i += 1) {
    node = nodes[i];
    if (!bubble) {
      result = cb(node, i, nodes);
    }

    if (
      result !== false &&
      node.type === "function" &&
      Array.isArray(node.nodes)
    ) {
      walk(node.nodes, cb, bubble);
    }

    if (bubble) {
      cb(node, i, nodes);
    }
  }
};

function stringifyNode(node, custom) {
  var type = node.type;
  var value = node.value;
  var buf;
  var customResult;

  if (custom && (customResult = custom(node)) !== undefined) {
    return customResult;
  } else if (type === "word" || type === "space") {
    return value;
  } else if (type === "string") {
    buf = node.quote || "";
    return buf + value + (node.unclosed ? "" : buf);
  } else if (type === "comment") {
    return "/*" + value + (node.unclosed ? "" : "*/");
  } else if (type === "div") {
    return (node.before || "") + value + (node.after || "");
  } else if (Array.isArray(node.nodes)) {
    buf = stringify$1(node.nodes, custom);
    if (type !== "function") {
      return buf;
    }
    return (
      value +
      "(" +
      (node.before || "") +
      buf +
      (node.after || "") +
      (node.unclosed ? "" : ")")
    );
  }
  return value;
}

function stringify$1(nodes, custom) {
  var result, i;

  if (Array.isArray(nodes)) {
    result = "";
    for (i = nodes.length - 1; ~i; i -= 1) {
      result = stringifyNode(nodes[i], custom) + result;
    }
    return result;
  }
  return stringifyNode(nodes, custom);
}

var stringify_1 = stringify$1;

var unit;
var hasRequiredUnit;

function requireUnit () {
	if (hasRequiredUnit) return unit;
	hasRequiredUnit = 1;
	var minus = "-".charCodeAt(0);
	var plus = "+".charCodeAt(0);
	var dot = ".".charCodeAt(0);
	var exp = "e".charCodeAt(0);
	var EXP = "E".charCodeAt(0);

	// Check if three code points would start a number
	// https://www.w3.org/TR/css-syntax-3/#starts-with-a-number
	function likeNumber(value) {
	  var code = value.charCodeAt(0);
	  var nextCode;

	  if (code === plus || code === minus) {
	    nextCode = value.charCodeAt(1);

	    if (nextCode >= 48 && nextCode <= 57) {
	      return true;
	    }

	    var nextNextCode = value.charCodeAt(2);

	    if (nextCode === dot && nextNextCode >= 48 && nextNextCode <= 57) {
	      return true;
	    }

	    return false;
	  }

	  if (code === dot) {
	    nextCode = value.charCodeAt(1);

	    if (nextCode >= 48 && nextCode <= 57) {
	      return true;
	    }

	    return false;
	  }

	  if (code >= 48 && code <= 57) {
	    return true;
	  }

	  return false;
	}

	// Consume a number
	// https://www.w3.org/TR/css-syntax-3/#consume-number
	unit = function(value) {
	  var pos = 0;
	  var length = value.length;
	  var code;
	  var nextCode;
	  var nextNextCode;

	  if (length === 0 || !likeNumber(value)) {
	    return false;
	  }

	  code = value.charCodeAt(pos);

	  if (code === plus || code === minus) {
	    pos++;
	  }

	  while (pos < length) {
	    code = value.charCodeAt(pos);

	    if (code < 48 || code > 57) {
	      break;
	    }

	    pos += 1;
	  }

	  code = value.charCodeAt(pos);
	  nextCode = value.charCodeAt(pos + 1);

	  if (code === dot && nextCode >= 48 && nextCode <= 57) {
	    pos += 2;

	    while (pos < length) {
	      code = value.charCodeAt(pos);

	      if (code < 48 || code > 57) {
	        break;
	      }

	      pos += 1;
	    }
	  }

	  code = value.charCodeAt(pos);
	  nextCode = value.charCodeAt(pos + 1);
	  nextNextCode = value.charCodeAt(pos + 2);

	  if (
	    (code === exp || code === EXP) &&
	    ((nextCode >= 48 && nextCode <= 57) ||
	      ((nextCode === plus || nextCode === minus) &&
	        nextNextCode >= 48 &&
	        nextNextCode <= 57))
	  ) {
	    pos += nextCode === plus || nextCode === minus ? 3 : 2;

	    while (pos < length) {
	      code = value.charCodeAt(pos);

	      if (code < 48 || code > 57) {
	        break;
	      }

	      pos += 1;
	    }
	  }

	  return {
	    number: value.slice(0, pos),
	    unit: value.slice(pos)
	  };
	};
	return unit;
}

var parse = parse$1;
var walk$1 = walk$2;
var stringify = stringify_1;

function ValueParser(value) {
  if (this instanceof ValueParser) {
    this.nodes = parse(value);
    return this;
  }
  return new ValueParser(value);
}

ValueParser.prototype.toString = function() {
  return Array.isArray(this.nodes) ? stringify(this.nodes) : "";
};

ValueParser.prototype.walk = function(cb, bubble) {
  walk$1(this.nodes, cb, bubble);
  return this;
};

ValueParser.unit = requireUnit();

ValueParser.walk = walk$1;

ValueParser.stringify = stringify;

var lib = ValueParser;

const matchValueName = /[$]?[\w-]+/g;

const replaceValueSymbols$2 = (value, replacements) => {
  let matches;

  while ((matches = matchValueName.exec(value))) {
    const replacement = replacements[matches[0]];

    if (replacement) {
      value =
        value.slice(0, matches.index) +
        replacement +
        value.slice(matchValueName.lastIndex);

      matchValueName.lastIndex -= matches[0].length - replacement.length;
    }
  }

  return value;
};

var replaceValueSymbols_1 = replaceValueSymbols$2;

const replaceValueSymbols$1 = replaceValueSymbols_1;

const replaceSymbols$1 = (css, replacements) => {
  css.walk((node) => {
    if (node.type === "decl" && node.value) {
      node.value = replaceValueSymbols$1(node.value.toString(), replacements);
    } else if (node.type === "rule" && node.selector) {
      node.selector = replaceValueSymbols$1(
        node.selector.toString(),
        replacements
      );
    } else if (node.type === "atrule" && node.params) {
      node.params = replaceValueSymbols$1(node.params.toString(), replacements);
    }
  });
};

var replaceSymbols_1 = replaceSymbols$1;

const importPattern = /^:import\(("[^"]*"|'[^']*'|[^"']+)\)$/;
const balancedQuotes = /^("[^"]*"|'[^']*'|[^"']+)$/;

const getDeclsObject = (rule) => {
  const object = {};

  rule.walkDecls((decl) => {
    const before = decl.raws.before ? decl.raws.before.trim() : "";

    object[before + decl.prop] = decl.value;
  });

  return object;
};
/**
 *
 * @param {string} css
 * @param {boolean} removeRules
 * @param {'auto' | 'rule' | 'at-rule'} mode
 */
const extractICSS$2 = (css, removeRules = true, mode = "auto") => {
  const icssImports = {};
  const icssExports = {};

  function addImports(node, path) {
    const unquoted = path.replace(/'|"/g, "");
    icssImports[unquoted] = Object.assign(
      icssImports[unquoted] || {},
      getDeclsObject(node)
    );

    if (removeRules) {
      node.remove();
    }
  }

  function addExports(node) {
    Object.assign(icssExports, getDeclsObject(node));
    if (removeRules) {
      node.remove();
    }
  }

  css.each((node) => {
    if (node.type === "rule" && mode !== "at-rule") {
      if (node.selector.slice(0, 7) === ":import") {
        const matches = importPattern.exec(node.selector);

        if (matches) {
          addImports(node, matches[1]);
        }
      }

      if (node.selector === ":export") {
        addExports(node);
      }
    }

    if (node.type === "atrule" && mode !== "rule") {
      if (node.name === "icss-import") {
        const matches = balancedQuotes.exec(node.params);

        if (matches) {
          addImports(node, matches[1]);
        }
      }
      if (node.name === "icss-export") {
        addExports(node);
      }
    }
  });

  return { icssImports, icssExports };
};

var extractICSS_1 = extractICSS$2;

const createImports = (imports, postcss, mode = "rule") => {
  return Object.keys(imports).map((path) => {
    const aliases = imports[path];
    const declarations = Object.keys(aliases).map((key) =>
      postcss.decl({
        prop: key,
        value: aliases[key],
        raws: { before: "\n  " },
      })
    );

    const hasDeclarations = declarations.length > 0;

    const rule =
      mode === "rule"
        ? postcss.rule({
            selector: `:import('${path}')`,
            raws: { after: hasDeclarations ? "\n" : "" },
          })
        : postcss.atRule({
            name: "icss-import",
            params: `'${path}'`,
            raws: { after: hasDeclarations ? "\n" : "" },
          });

    if (hasDeclarations) {
      rule.append(declarations);
    }

    return rule;
  });
};

const createExports = (exports, postcss, mode = "rule") => {
  const declarations = Object.keys(exports).map((key) =>
    postcss.decl({
      prop: key,
      value: exports[key],
      raws: { before: "\n  " },
    })
  );

  if (declarations.length === 0) {
    return [];
  }
  const rule =
    mode === "rule"
      ? postcss.rule({
          selector: `:export`,
          raws: { after: "\n" },
        })
      : postcss.atRule({
          name: "icss-export",
          raws: { after: "\n" },
        });

  rule.append(declarations);

  return [rule];
};

const createICSSRules$1 = (imports, exports, postcss, mode) => [
  ...createImports(imports, postcss, mode),
  ...createExports(exports, postcss, mode),
];

var createICSSRules_1 = createICSSRules$1;

const replaceValueSymbols = replaceValueSymbols_1;
const replaceSymbols = replaceSymbols_1;
const extractICSS$1 = extractICSS_1;
const createICSSRules = createICSSRules_1;

var src$3 = {
  replaceValueSymbols,
  replaceSymbols,
  extractICSS: extractICSS$1,
  createICSSRules,
};

const selectorParser$1 = distExports;
const valueParser = lib;
const { extractICSS } = src$3;

const isSpacing = (node) => node.type === "combinator" && node.value === " ";

function normalizeNodeArray(nodes) {
  const array = [];

  nodes.forEach((x) => {
    if (Array.isArray(x)) {
      normalizeNodeArray(x).forEach((item) => {
        array.push(item);
      });
    } else if (x) {
      array.push(x);
    }
  });

  if (array.length > 0 && isSpacing(array[array.length - 1])) {
    array.pop();
  }
  return array;
}

function localizeNode(rule, mode, localAliasMap) {
  const transform = (node, context) => {
    if (context.ignoreNextSpacing && !isSpacing(node)) {
      throw new Error("Missing whitespace after " + context.ignoreNextSpacing);
    }

    if (context.enforceNoSpacing && isSpacing(node)) {
      throw new Error("Missing whitespace before " + context.enforceNoSpacing);
    }

    let newNodes;

    switch (node.type) {
      case "root": {
        let resultingGlobal;

        context.hasPureGlobals = false;

        newNodes = node.nodes.map((n) => {
          const nContext = {
            global: context.global,
            lastWasSpacing: true,
            hasLocals: false,
            explicit: false,
          };

          n = transform(n, nContext);

          if (typeof resultingGlobal === "undefined") {
            resultingGlobal = nContext.global;
          } else if (resultingGlobal !== nContext.global) {
            throw new Error(
              'Inconsistent rule global/local result in rule "' +
                node +
                '" (multiple selectors must result in the same mode for the rule)'
            );
          }

          if (!nContext.hasLocals) {
            context.hasPureGlobals = true;
          }

          return n;
        });

        context.global = resultingGlobal;

        node.nodes = normalizeNodeArray(newNodes);
        break;
      }
      case "selector": {
        newNodes = node.map((childNode) => transform(childNode, context));

        node = node.clone();
        node.nodes = normalizeNodeArray(newNodes);
        break;
      }
      case "combinator": {
        if (isSpacing(node)) {
          if (context.ignoreNextSpacing) {
            context.ignoreNextSpacing = false;
            context.lastWasSpacing = false;
            context.enforceNoSpacing = false;
            return null;
          }
          context.lastWasSpacing = true;
          return node;
        }
        break;
      }
      case "pseudo": {
        let childContext;
        const isNested = !!node.length;
        const isScoped = node.value === ":local" || node.value === ":global";
        const isImportExport =
          node.value === ":import" || node.value === ":export";

        if (isImportExport) {
          context.hasLocals = true;
          // :local(.foo)
        } else if (isNested) {
          if (isScoped) {
            if (node.nodes.length === 0) {
              throw new Error(`${node.value}() can't be empty`);
            }

            if (context.inside) {
              throw new Error(
                `A ${node.value} is not allowed inside of a ${context.inside}(...)`
              );
            }

            childContext = {
              global: node.value === ":global",
              inside: node.value,
              hasLocals: false,
              explicit: true,
            };

            newNodes = node
              .map((childNode) => transform(childNode, childContext))
              .reduce((acc, next) => acc.concat(next.nodes), []);

            if (newNodes.length) {
              const { before, after } = node.spaces;

              const first = newNodes[0];
              const last = newNodes[newNodes.length - 1];

              first.spaces = { before, after: first.spaces.after };
              last.spaces = { before: last.spaces.before, after };
            }

            node = newNodes;

            break;
          } else {
            childContext = {
              global: context.global,
              inside: context.inside,
              lastWasSpacing: true,
              hasLocals: false,
              explicit: context.explicit,
            };
            newNodes = node.map((childNode) =>
              transform(childNode, childContext)
            );

            node = node.clone();
            node.nodes = normalizeNodeArray(newNodes);

            if (childContext.hasLocals) {
              context.hasLocals = true;
            }
          }
          break;

          //:local .foo .bar
        } else if (isScoped) {
          if (context.inside) {
            throw new Error(
              `A ${node.value} is not allowed inside of a ${context.inside}(...)`
            );
          }

          const addBackSpacing = !!node.spaces.before;

          context.ignoreNextSpacing = context.lastWasSpacing
            ? node.value
            : false;

          context.enforceNoSpacing = context.lastWasSpacing
            ? false
            : node.value;

          context.global = node.value === ":global";
          context.explicit = true;

          // because this node has spacing that is lost when we remove it
          // we make up for it by adding an extra combinator in since adding
          // spacing on the parent selector doesn't work
          return addBackSpacing
            ? selectorParser$1.combinator({ value: " " })
            : null;
        }
        break;
      }
      case "id":
      case "class": {
        if (!node.value) {
          throw new Error("Invalid class or id selector syntax");
        }

        if (context.global) {
          break;
        }

        const isImportedValue = localAliasMap.has(node.value);
        const isImportedWithExplicitScope = isImportedValue && context.explicit;

        if (!isImportedValue || isImportedWithExplicitScope) {
          const innerNode = node.clone();
          innerNode.spaces = { before: "", after: "" };

          node = selectorParser$1.pseudo({
            value: ":local",
            nodes: [innerNode],
            spaces: node.spaces,
          });

          context.hasLocals = true;
        }

        break;
      }
    }

    context.lastWasSpacing = false;
    context.ignoreNextSpacing = false;
    context.enforceNoSpacing = false;

    return node;
  };

  const rootContext = {
    global: mode === "global",
    hasPureGlobals: false,
  };

  rootContext.selector = selectorParser$1((root) => {
    transform(root, rootContext);
  }).processSync(rule, { updateSelector: false, lossless: true });

  return rootContext;
}

function localizeDeclNode(node, context) {
  switch (node.type) {
    case "word":
      if (context.localizeNextItem) {
        if (!context.localAliasMap.has(node.value)) {
          node.value = ":local(" + node.value + ")";
          context.localizeNextItem = false;
        }
      }
      break;

    case "function":
      if (
        context.options &&
        context.options.rewriteUrl &&
        node.value.toLowerCase() === "url"
      ) {
        node.nodes.map((nestedNode) => {
          if (nestedNode.type !== "string" && nestedNode.type !== "word") {
            return;
          }

          let newUrl = context.options.rewriteUrl(
            context.global,
            nestedNode.value
          );

          switch (nestedNode.type) {
            case "string":
              if (nestedNode.quote === "'") {
                newUrl = newUrl.replace(/(\\)/g, "\\$1").replace(/'/g, "\\'");
              }

              if (nestedNode.quote === '"') {
                newUrl = newUrl.replace(/(\\)/g, "\\$1").replace(/"/g, '\\"');
              }

              break;
            case "word":
              newUrl = newUrl.replace(/("|'|\)|\\)/g, "\\$1");
              break;
          }

          nestedNode.value = newUrl;
        });
      }
      break;
  }
  return node;
}

function isWordAFunctionArgument(wordNode, functionNode) {
  return functionNode
    ? functionNode.nodes.some(
        (functionNodeChild) =>
          functionNodeChild.sourceIndex === wordNode.sourceIndex
      )
    : false;
}

function localizeDeclarationValues(localize, declaration, context) {
  const valueNodes = valueParser(declaration.value);

  valueNodes.walk((node, index, nodes) => {
    const subContext = {
      options: context.options,
      global: context.global,
      localizeNextItem: localize && !context.global,
      localAliasMap: context.localAliasMap,
    };
    nodes[index] = localizeDeclNode(node, subContext);
  });

  declaration.value = valueNodes.toString();
}

function localizeDeclaration(declaration, context) {
  const isAnimation = /animation$/i.test(declaration.prop);

  if (isAnimation) {
    const validIdent = /^-?[_a-z][_a-z0-9-]*$/i;

    /*
    The spec defines some keywords that you can use to describe properties such as the timing
    function. These are still valid animation names, so as long as there is a property that accepts
    a keyword, it is given priority. Only when all the properties that can take a keyword are
    exhausted can the animation name be set to the keyword. I.e.
  
    animation: infinite infinite;
  
    The animation will repeat an infinite number of times from the first argument, and will have an
    animation name of infinite from the second.
    */
    const animationKeywords = {
      $alternate: 1,
      "$alternate-reverse": 1,
      $backwards: 1,
      $both: 1,
      $ease: 1,
      "$ease-in": 1,
      "$ease-in-out": 1,
      "$ease-out": 1,
      $forwards: 1,
      $infinite: 1,
      $linear: 1,
      $none: Infinity, // No matter how many times you write none, it will never be an animation name
      $normal: 1,
      $paused: 1,
      $reverse: 1,
      $running: 1,
      "$step-end": 1,
      "$step-start": 1,
      $initial: Infinity,
      $inherit: Infinity,
      $unset: Infinity,
    };
    let parsedAnimationKeywords = {};
    let stepsFunctionNode = null;
    const valueNodes = valueParser(declaration.value).walk((node) => {
      /* If div-token appeared (represents as comma ','), a possibility of an animation-keywords should be reflesh. */
      if (node.type === "div") {
        parsedAnimationKeywords = {};
      }
      if (node.type === "function" && node.value.toLowerCase() === "steps") {
        stepsFunctionNode = node;
      }
      const value =
        node.type === "word" &&
        !isWordAFunctionArgument(node, stepsFunctionNode)
          ? node.value.toLowerCase()
          : null;

      let shouldParseAnimationName = false;

      if (value && validIdent.test(value)) {
        if ("$" + value in animationKeywords) {
          parsedAnimationKeywords["$" + value] =
            "$" + value in parsedAnimationKeywords
              ? parsedAnimationKeywords["$" + value] + 1
              : 0;

          shouldParseAnimationName =
            parsedAnimationKeywords["$" + value] >=
            animationKeywords["$" + value];
        } else {
          shouldParseAnimationName = true;
        }
      }

      const subContext = {
        options: context.options,
        global: context.global,
        localizeNextItem: shouldParseAnimationName && !context.global,
        localAliasMap: context.localAliasMap,
      };
      return localizeDeclNode(node, subContext);
    });

    declaration.value = valueNodes.toString();

    return;
  }

  const isAnimationName = /animation(-name)?$/i.test(declaration.prop);

  if (isAnimationName) {
    return localizeDeclarationValues(true, declaration, context);
  }

  const hasUrl = /url\(/i.test(declaration.value);

  if (hasUrl) {
    return localizeDeclarationValues(false, declaration, context);
  }
}

src$4.exports = (options = {}) => {
  if (
    options &&
    options.mode &&
    options.mode !== "global" &&
    options.mode !== "local" &&
    options.mode !== "pure"
  ) {
    throw new Error(
      'options.mode must be either "global", "local" or "pure" (default "local")'
    );
  }

  const pureMode = options && options.mode === "pure";
  const globalMode = options && options.mode === "global";

  return {
    postcssPlugin: "postcss-modules-local-by-default",
    prepare() {
      const localAliasMap = new Map();

      return {
        Once(root) {
          const { icssImports } = extractICSS(root, false);

          Object.keys(icssImports).forEach((key) => {
            Object.keys(icssImports[key]).forEach((prop) => {
              localAliasMap.set(prop, icssImports[key][prop]);
            });
          });

          root.walkAtRules((atRule) => {
            if (/keyframes$/i.test(atRule.name)) {
              const globalMatch = /^\s*:global\s*\((.+)\)\s*$/.exec(
                atRule.params
              );
              const localMatch = /^\s*:local\s*\((.+)\)\s*$/.exec(
                atRule.params
              );

              let globalKeyframes = globalMode;

              if (globalMatch) {
                if (pureMode) {
                  throw atRule.error(
                    "@keyframes :global(...) is not allowed in pure mode"
                  );
                }
                atRule.params = globalMatch[1];
                globalKeyframes = true;
              } else if (localMatch) {
                atRule.params = localMatch[0];
                globalKeyframes = false;
              } else if (!globalMode) {
                if (atRule.params && !localAliasMap.has(atRule.params)) {
                  atRule.params = ":local(" + atRule.params + ")";
                }
              }

              atRule.walkDecls((declaration) => {
                localizeDeclaration(declaration, {
                  localAliasMap,
                  options: options,
                  global: globalKeyframes,
                });
              });
            } else if (atRule.nodes) {
              atRule.nodes.forEach((declaration) => {
                if (declaration.type === "decl") {
                  localizeDeclaration(declaration, {
                    localAliasMap,
                    options: options,
                    global: globalMode,
                  });
                }
              });
            }
          });

          root.walkRules((rule) => {
            if (
              rule.parent &&
              rule.parent.type === "atrule" &&
              /keyframes$/i.test(rule.parent.name)
            ) {
              // ignore keyframe rules
              return;
            }

            const context = localizeNode(rule, options.mode, localAliasMap);

            context.options = options;
            context.localAliasMap = localAliasMap;

            if (pureMode && context.hasPureGlobals) {
              throw rule.error(
                'Selector "' +
                  rule.selector +
                  '" is not pure ' +
                  "(pure selectors must contain at least one local class or id)"
              );
            }

            rule.selector = context.selector;

            // Less-syntax mixins parse as rules with no nodes
            if (rule.nodes) {
              rule.nodes.forEach((declaration) =>
                localizeDeclaration(declaration, context)
              );
            }
          });
        },
      };
    },
  };
};
srcExports$2.postcss = true;

var srcExports$1 = {};
var src$2 = {
  get exports(){ return srcExports$1; },
  set exports(v){ srcExports$1 = v; },
};

const PERMANENT_MARKER = 2;
const TEMPORARY_MARKER = 1;

function createError(node, graph) {
  const er = new Error("Nondeterministic import's order");

  const related = graph[node];
  const relatedNode = related.find(
    (relatedNode) => graph[relatedNode].indexOf(node) > -1
  );

  er.nodes = [node, relatedNode];

  return er;
}

function walkGraph(node, graph, state, result, strict) {
  if (state[node] === PERMANENT_MARKER) {
    return;
  }

  if (state[node] === TEMPORARY_MARKER) {
    if (strict) {
      return createError(node, graph);
    }

    return;
  }

  state[node] = TEMPORARY_MARKER;

  const children = graph[node];
  const length = children.length;

  for (let i = 0; i < length; ++i) {
    const error = walkGraph(children[i], graph, state, result, strict);

    if (error instanceof Error) {
      return error;
    }
  }

  state[node] = PERMANENT_MARKER;

  result.push(node);
}

function topologicalSort$1(graph, strict) {
  const result = [];
  const state = {};

  const nodes = Object.keys(graph);
  const length = nodes.length;

  for (let i = 0; i < length; ++i) {
    const er = walkGraph(nodes[i], graph, state, result, strict);

    if (er instanceof Error) {
      return er;
    }
  }

  return result;
}

var topologicalSort_1 = topologicalSort$1;

const topologicalSort = topologicalSort_1;

const matchImports$1 = /^(.+?)\s+from\s+(?:"([^"]+)"|'([^']+)'|(global))$/;
const icssImport = /^:import\((?:"([^"]+)"|'([^']+)')\)/;

const VISITED_MARKER = 1;

/**
 * :import('G') {}
 *
 * Rule
 *   composes: ... from 'A'
 *   composes: ... from 'B'

 * Rule
 *   composes: ... from 'A'
 *   composes: ... from 'A'
 *   composes: ... from 'C'
 *
 * Results in:
 *
 * graph: {
 *   G: [],
 *   A: [],
 *   B: ['A'],
 *   C: ['A'],
 * }
 */
function addImportToGraph(importId, parentId, graph, visited) {
  const siblingsId = parentId + "_" + "siblings";
  const visitedId = parentId + "_" + importId;

  if (visited[visitedId] !== VISITED_MARKER) {
    if (!Array.isArray(visited[siblingsId])) {
      visited[siblingsId] = [];
    }

    const siblings = visited[siblingsId];

    if (Array.isArray(graph[importId])) {
      graph[importId] = graph[importId].concat(siblings);
    } else {
      graph[importId] = siblings.slice();
    }

    visited[visitedId] = VISITED_MARKER;

    siblings.push(importId);
  }
}

src$2.exports = (options = {}) => {
  let importIndex = 0;
  const createImportedName =
    typeof options.createImportedName !== "function"
      ? (importName /*, path*/) =>
          `i__imported_${importName.replace(/\W/g, "_")}_${importIndex++}`
      : options.createImportedName;
  const failOnWrongOrder = options.failOnWrongOrder;

  return {
    postcssPlugin: "postcss-modules-extract-imports",
    prepare() {
      const graph = {};
      const visited = {};
      const existingImports = {};
      const importDecls = {};
      const imports = {};

      return {
        Once(root, postcss) {
          // Check the existing imports order and save refs
          root.walkRules((rule) => {
            const matches = icssImport.exec(rule.selector);

            if (matches) {
              const [, /*match*/ doubleQuotePath, singleQuotePath] = matches;
              const importPath = doubleQuotePath || singleQuotePath;

              addImportToGraph(importPath, "root", graph, visited);

              existingImports[importPath] = rule;
            }
          });

          root.walkDecls(/^composes$/, (declaration) => {
            const matches = declaration.value.match(matchImports$1);

            if (!matches) {
              return;
            }

            let tmpSymbols;
            let [
              ,
              /*match*/ symbols,
              doubleQuotePath,
              singleQuotePath,
              global,
            ] = matches;

            if (global) {
              // Composing globals simply means changing these classes to wrap them in global(name)
              tmpSymbols = symbols.split(/\s+/).map((s) => `global(${s})`);
            } else {
              const importPath = doubleQuotePath || singleQuotePath;

              let parent = declaration.parent;
              let parentIndexes = "";

              while (parent.type !== "root") {
                parentIndexes =
                  parent.parent.index(parent) + "_" + parentIndexes;
                parent = parent.parent;
              }

              const { selector } = declaration.parent;
              const parentRule = `_${parentIndexes}${selector}`;

              addImportToGraph(importPath, parentRule, graph, visited);

              importDecls[importPath] = declaration;
              imports[importPath] = imports[importPath] || {};

              tmpSymbols = symbols.split(/\s+/).map((s) => {
                if (!imports[importPath][s]) {
                  imports[importPath][s] = createImportedName(s, importPath);
                }

                return imports[importPath][s];
              });
            }

            declaration.value = tmpSymbols.join(" ");
          });

          const importsOrder = topologicalSort(graph, failOnWrongOrder);

          if (importsOrder instanceof Error) {
            const importPath = importsOrder.nodes.find((importPath) =>
              // eslint-disable-next-line no-prototype-builtins
              importDecls.hasOwnProperty(importPath)
            );
            const decl = importDecls[importPath];

            throw decl.error(
              "Failed to resolve order of composed modules " +
                importsOrder.nodes
                  .map((importPath) => "`" + importPath + "`")
                  .join(", ") +
                ".",
              {
                plugin: "postcss-modules-extract-imports",
                word: "composes",
              }
            );
          }

          let lastImportRule;

          importsOrder.forEach((path) => {
            const importedSymbols = imports[path];
            let rule = existingImports[path];

            if (!rule && importedSymbols) {
              rule = postcss.rule({
                selector: `:import("${path}")`,
                raws: { after: "\n" },
              });

              if (lastImportRule) {
                root.insertAfter(lastImportRule, rule);
              } else {
                root.prepend(rule);
              }
            }

            lastImportRule = rule;

            if (!importedSymbols) {
              return;
            }

            Object.keys(importedSymbols).forEach((importedSymbol) => {
              rule.append(
                postcss.decl({
                  value: importedSymbol,
                  prop: importedSymbols[importedSymbol],
                  raws: { before: "\n  " },
                })
              );
            });
          });
        },
      };
    },
  };
};

srcExports$1.postcss = true;

const selectorParser = distExports;

const hasOwnProperty = Object.prototype.hasOwnProperty;

function getSingleLocalNamesForComposes(root) {
  return root.nodes.map((node) => {
    if (node.type !== "selector" || node.nodes.length !== 1) {
      throw new Error(
        `composition is only allowed when selector is single :local class name not in "${root}"`
      );
    }

    node = node.nodes[0];

    if (
      node.type !== "pseudo" ||
      node.value !== ":local" ||
      node.nodes.length !== 1
    ) {
      throw new Error(
        'composition is only allowed when selector is single :local class name not in "' +
          root +
          '", "' +
          node +
          '" is weird'
      );
    }

    node = node.first;

    if (node.type !== "selector" || node.length !== 1) {
      throw new Error(
        'composition is only allowed when selector is single :local class name not in "' +
          root +
          '", "' +
          node +
          '" is weird'
      );
    }

    node = node.first;

    if (node.type !== "class") {
      // 'id' is not possible, because you can't compose ids
      throw new Error(
        'composition is only allowed when selector is single :local class name not in "' +
          root +
          '", "' +
          node +
          '" is weird'
      );
    }

    return node.value;
  });
}

const whitespace = "[\\x20\\t\\r\\n\\f]";
const unescapeRegExp = new RegExp(
  "\\\\([\\da-f]{1,6}" + whitespace + "?|(" + whitespace + ")|.)",
  "ig"
);

function unescape(str) {
  return str.replace(unescapeRegExp, (_, escaped, escapedWhitespace) => {
    const high = "0x" + escaped - 0x10000;

    // NaN means non-codepoint
    // Workaround erroneous numeric interpretation of +"0x"
    return high !== high || escapedWhitespace
      ? escaped
      : high < 0
      ? // BMP codepoint
        String.fromCharCode(high + 0x10000)
      : // Supplemental Plane codepoint (surrogate pair)
        String.fromCharCode((high >> 10) | 0xd800, (high & 0x3ff) | 0xdc00);
  });
}

const plugin = (options = {}) => {
  const generateScopedName =
    (options && options.generateScopedName) || plugin.generateScopedName;
  const generateExportEntry =
    (options && options.generateExportEntry) || plugin.generateExportEntry;
  const exportGlobals = options && options.exportGlobals;

  return {
    postcssPlugin: "postcss-modules-scope",
    Once(root, { rule }) {
      const exports = Object.create(null);

      function exportScopedName(name, rawName) {
        const scopedName = generateScopedName(
          rawName ? rawName : name,
          root.source.input.from,
          root.source.input.css
        );
        const exportEntry = generateExportEntry(
          rawName ? rawName : name,
          scopedName,
          root.source.input.from,
          root.source.input.css
        );
        const { key, value } = exportEntry;

        exports[key] = exports[key] || [];

        if (exports[key].indexOf(value) < 0) {
          exports[key].push(value);
        }

        return scopedName;
      }

      function localizeNode(node) {
        switch (node.type) {
          case "selector":
            node.nodes = node.map(localizeNode);
            return node;
          case "class":
            return selectorParser.className({
              value: exportScopedName(
                node.value,
                node.raws && node.raws.value ? node.raws.value : null
              ),
            });
          case "id": {
            return selectorParser.id({
              value: exportScopedName(
                node.value,
                node.raws && node.raws.value ? node.raws.value : null
              ),
            });
          }
        }

        throw new Error(
          `${node.type} ("${node}") is not allowed in a :local block`
        );
      }

      function traverseNode(node) {
        switch (node.type) {
          case "pseudo":
            if (node.value === ":local") {
              if (node.nodes.length !== 1) {
                throw new Error('Unexpected comma (",") in :local block');
              }

              const selector = localizeNode(node.first, node.spaces);
              // move the spaces that were around the psuedo selector to the first
              // non-container node
              selector.first.spaces = node.spaces;

              const nextNode = node.next();

              if (
                nextNode &&
                nextNode.type === "combinator" &&
                nextNode.value === " " &&
                /\\[A-F0-9]{1,6}$/.test(selector.last.value)
              ) {
                selector.last.spaces.after = " ";
              }

              node.replaceWith(selector);

              return;
            }
          /* falls through */
          case "root":
          case "selector": {
            node.each(traverseNode);
            break;
          }
          case "id":
          case "class":
            if (exportGlobals) {
              exports[node.value] = [node.value];
            }
            break;
        }
        return node;
      }

      // Find any :import and remember imported names
      const importedNames = {};

      root.walkRules(/^:import\(.+\)$/, (rule) => {
        rule.walkDecls((decl) => {
          importedNames[decl.prop] = true;
        });
      });

      // Find any :local selectors
      root.walkRules((rule) => {
        let parsedSelector = selectorParser().astSync(rule);

        rule.selector = traverseNode(parsedSelector.clone()).toString();

        rule.walkDecls(/composes|compose-with/i, (decl) => {
          const localNames = getSingleLocalNamesForComposes(parsedSelector);
          const classes = decl.value.split(/\s+/);

          classes.forEach((className) => {
            const global = /^global\(([^)]+)\)$/.exec(className);

            if (global) {
              localNames.forEach((exportedName) => {
                exports[exportedName].push(global[1]);
              });
            } else if (hasOwnProperty.call(importedNames, className)) {
              localNames.forEach((exportedName) => {
                exports[exportedName].push(className);
              });
            } else if (hasOwnProperty.call(exports, className)) {
              localNames.forEach((exportedName) => {
                exports[className].forEach((item) => {
                  exports[exportedName].push(item);
                });
              });
            } else {
              throw decl.error(
                `referenced class name "${className}" in ${decl.prop} not found`
              );
            }
          });

          decl.remove();
        });

        // Find any :local values
        rule.walkDecls((decl) => {
          if (!/:local\s*\((.+?)\)/.test(decl.value)) {
            return;
          }

          let tokens = decl.value.split(/(,|'[^']*'|"[^"]*")/);

          tokens = tokens.map((token, idx) => {
            if (idx === 0 || tokens[idx - 1] === ",") {
              let result = token;

              const localMatch = /:local\s*\((.+?)\)/.exec(token);

              if (localMatch) {
                const input = localMatch.input;
                const matchPattern = localMatch[0];
                const matchVal = localMatch[1];
                const newVal = exportScopedName(matchVal);

                result = input.replace(matchPattern, newVal);
              } else {
                return token;
              }

              return result;
            } else {
              return token;
            }
          });

          decl.value = tokens.join("");
        });
      });

      // Find any :local keyframes
      root.walkAtRules(/keyframes$/i, (atRule) => {
        const localMatch = /^\s*:local\s*\((.+?)\)\s*$/.exec(atRule.params);

        if (!localMatch) {
          return;
        }

        atRule.params = exportScopedName(localMatch[1]);
      });

      // If we found any :locals, insert an :export rule
      const exportedNames = Object.keys(exports);

      if (exportedNames.length > 0) {
        const exportRule = rule({ selector: ":export" });

        exportedNames.forEach((exportedName) =>
          exportRule.append({
            prop: exportedName,
            value: exports[exportedName].join(" "),
            raws: { before: "\n  " },
          })
        );

        root.append(exportRule);
      }
    },
  };
};

plugin.postcss = true;

plugin.generateScopedName = function (name, path) {
  const sanitisedPath = path
    .replace(/\.[^./\\]+$/, "")
    .replace(/[\W_]+/g, "_")
    .replace(/^_|_$/g, "");

  return `_${sanitisedPath}__${name}`.trim();
};

plugin.generateExportEntry = function (name, scopedName) {
  return {
    key: unescape(name),
    value: unescape(scopedName),
  };
};

var src$1 = plugin;

var srcExports = {};
var src = {
  get exports(){ return srcExports; },
  set exports(v){ srcExports = v; },
};

const ICSSUtils = src$3;

const matchImports = /^(.+?|\([\s\S]+?\))\s+from\s+("[^"]*"|'[^']*'|[\w-]+)$/;
const matchValueDefinition = /(?:\s+|^)([\w-]+):?(.*?)$/;
const matchImport = /^([\w-]+)(?:\s+as\s+([\w-]+))?/;

src.exports = (options) => {
  let importIndex = 0;
  const createImportedName =
    (options && options.createImportedName) ||
    ((importName /*, path*/) =>
      `i__const_${importName.replace(/\W/g, "_")}_${importIndex++}`);

  return {
    postcssPlugin: "postcss-modules-values",
    prepare(result) {
      const importAliases = [];
      const definitions = {};

      return {
        Once(root, postcss) {
          root.walkAtRules(/value/i, (atRule) => {
            const matches = atRule.params.match(matchImports);

            if (matches) {
              let [, /*match*/ aliases, path] = matches;

              // We can use constants for path names
              if (definitions[path]) {
                path = definitions[path];
              }

              const imports = aliases
                .replace(/^\(\s*([\s\S]+)\s*\)$/, "$1")
                .split(/\s*,\s*/)
                .map((alias) => {
                  const tokens = matchImport.exec(alias);

                  if (tokens) {
                    const [, /*match*/ theirName, myName = theirName] = tokens;
                    const importedName = createImportedName(myName);
                    definitions[myName] = importedName;
                    return { theirName, importedName };
                  } else {
                    throw new Error(`@import statement "${alias}" is invalid!`);
                  }
                });

              importAliases.push({ path, imports });

              atRule.remove();

              return;
            }

            if (atRule.params.indexOf("@value") !== -1) {
              result.warn("Invalid value definition: " + atRule.params);
            }

            let [, key, value] = `${atRule.params}${atRule.raws.between}`.match(
              matchValueDefinition
            );

            const normalizedValue = value.replace(/\/\*((?!\*\/).*?)\*\//g, "");

            if (normalizedValue.length === 0) {
              result.warn("Invalid value definition: " + atRule.params);
              atRule.remove();

              return;
            }

            let isOnlySpace = /^\s+$/.test(normalizedValue);

            if (!isOnlySpace) {
              value = value.trim();
            }

            // Add to the definitions, knowing that values can refer to each other
            definitions[key] = ICSSUtils.replaceValueSymbols(
              value,
              definitions
            );

            atRule.remove();
          });

          /* If we have no definitions, don't continue */
          if (!Object.keys(definitions).length) {
            return;
          }

          /* Perform replacements */
          ICSSUtils.replaceSymbols(root, definitions);

          /* We want to export anything defined by now, but don't add it to the CSS yet or it well get picked up by the replacement stuff */
          const exportDeclarations = Object.keys(definitions).map((key) =>
            postcss.decl({
              value: definitions[key],
              prop: key,
              raws: { before: "\n  " },
            })
          );

          /* Add export rules if any */
          if (exportDeclarations.length > 0) {
            const exportRule = postcss.rule({
              selector: ":export",
              raws: { after: "\n" },
            });

            exportRule.append(exportDeclarations);

            root.prepend(exportRule);
          }

          /* Add import rules */
          importAliases.reverse().forEach(({ path, imports }) => {
            const importRule = postcss.rule({
              selector: `:import(${path})`,
              raws: { after: "\n" },
            });

            imports.forEach(({ theirName, importedName }) => {
              importRule.append({
                value: theirName,
                prop: importedName,
                raws: { before: "\n  " },
              });
            });

            root.prepend(importRule);
          });
        },
      };
    },
  };
};

srcExports.postcss = true;

Object.defineProperty(behaviours$1, "__esModule", {
  value: true
});
behaviours$1.behaviours = undefined;
behaviours$1.getDefaultPlugins = getDefaultPlugins;
behaviours$1.isValidBehaviour = isValidBehaviour;

var _postcssModulesLocalByDefault = srcExports$2;

var _postcssModulesLocalByDefault2 = _interopRequireDefault$1(_postcssModulesLocalByDefault);

var _postcssModulesExtractImports = srcExports$1;

var _postcssModulesExtractImports2 = _interopRequireDefault$1(_postcssModulesExtractImports);

var _postcssModulesScope = src$1;

var _postcssModulesScope2 = _interopRequireDefault$1(_postcssModulesScope);

var _postcssModulesValues = srcExports;

var _postcssModulesValues2 = _interopRequireDefault$1(_postcssModulesValues);

function _interopRequireDefault$1(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const behaviours = behaviours$1.behaviours = {
  LOCAL: "local",
  GLOBAL: "global"
};

function getDefaultPlugins({
  behaviour,
  generateScopedName,
  exportGlobals
}) {
  const scope = (0, _postcssModulesScope2.default)({ generateScopedName, exportGlobals });

  const plugins = {
    [behaviours.LOCAL]: [_postcssModulesValues2.default, (0, _postcssModulesLocalByDefault2.default)({ mode: 'local' }), _postcssModulesExtractImports2.default, scope],
    [behaviours.GLOBAL]: [_postcssModulesValues2.default, (0, _postcssModulesLocalByDefault2.default)({ mode: 'global' }), _postcssModulesExtractImports2.default, scope]
  };

  return plugins[behaviour];
}

function isValidBehaviour(behaviour) {
  return Object.keys(behaviours).map(key => behaviours[key]).indexOf(behaviour) > -1;
}

var _postcss = require$$0$2;

var _postcss2 = _interopRequireDefault(_postcss);

var _lodash = lodash_camelcase;

var _lodash2 = _interopRequireDefault(_lodash);

var _genericNames = genericNames;

var _genericNames2 = _interopRequireDefault(_genericNames);

var _unquote = unquote$1;

var _unquote2 = _interopRequireDefault(_unquote);

var _parser = parser;

var _parser2 = _interopRequireDefault(_parser);

var _loader = loader;

var _loader2 = _interopRequireDefault(_loader);

var _generateScopedName = generateScopedName$1;

var _generateScopedName2 = _interopRequireDefault(_generateScopedName);

var _saveJSON = saveJSON$1;

var _saveJSON2 = _interopRequireDefault(_saveJSON);

var _behaviours = behaviours$1;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

const PLUGIN_NAME = "postcss-modules";

function getDefaultScopeBehaviour(opts) {
  if (opts.scopeBehaviour && (0, _behaviours.isValidBehaviour)(opts.scopeBehaviour)) {
    return opts.scopeBehaviour;
  }

  return _behaviours.behaviours.LOCAL;
}

function getScopedNameGenerator(opts) {
  const scopedNameGenerator = opts.generateScopedName || _generateScopedName2.default;

  if (typeof scopedNameGenerator === "function") return scopedNameGenerator;
  return (0, _genericNames2.default)(scopedNameGenerator, {
    context: process.cwd(),
    hashPrefix: opts.hashPrefix
  });
}

function getLoader(opts, plugins) {
  const root = typeof opts.root === "undefined" ? "/" : opts.root;
  return typeof opts.Loader === "function" ? new opts.Loader(root, plugins) : new _loader2.default(root, plugins);
}

function isGlobalModule(globalModules, inputFile) {
  return globalModules.some(regex => inputFile.match(regex));
}

function getDefaultPluginsList(opts, inputFile) {
  const globalModulesList = opts.globalModulePaths || null;
  const exportGlobals = opts.exportGlobals || false;
  const defaultBehaviour = getDefaultScopeBehaviour(opts);
  const generateScopedName = getScopedNameGenerator(opts);

  if (globalModulesList && isGlobalModule(globalModulesList, inputFile)) {
    return (0, _behaviours.getDefaultPlugins)({
      behaviour: _behaviours.behaviours.GLOBAL,
      generateScopedName,
      exportGlobals
    });
  }

  return (0, _behaviours.getDefaultPlugins)({
    behaviour: defaultBehaviour,
    generateScopedName,
    exportGlobals
  });
}

function isOurPlugin(plugin) {
  return plugin.postcssPlugin === PLUGIN_NAME;
}

function dashesCamelCase(string) {
  return string.replace(/-+(\w)/g, (_, firstLetter) => firstLetter.toUpperCase());
}

build.exports = (opts = {}) => {
  return {
    postcssPlugin: PLUGIN_NAME,
    OnceExit(css, { result }) {
      return _asyncToGenerator(function* () {
        const getJSON = opts.getJSON || _saveJSON2.default;
        const inputFile = css.source.input.file;
        const pluginList = getDefaultPluginsList(opts, inputFile);
        const resultPluginIndex = result.processor.plugins.findIndex(function (plugin) {
          return isOurPlugin(plugin);
        });
        if (resultPluginIndex === -1) {
          throw new Error('Plugin missing from options.');
        }
        const earlierPlugins = result.processor.plugins.slice(0, resultPluginIndex);
        const loaderPlugins = [...earlierPlugins, ...pluginList];
        const loader = getLoader(opts, loaderPlugins);
        const fetcher = function fetcher(file, relativeTo, depTrace) {
          const unquoteFile = (0, _unquote2.default)(file);
          const resolvedResult = typeof opts.resolve === 'function' && opts.resolve(unquoteFile);
          const resolvedFile = resolvedResult instanceof Promise ? resolvedResult : Promise.resolve(resolvedResult);

          return resolvedFile.then(function (f) {
            return loader.fetch.call(loader, `"${f || unquoteFile}"`, relativeTo, depTrace);
          });
        };
        const parser = new _parser2.default(fetcher);

        yield (0, _postcss2.default)([...pluginList, parser.plugin()]).process(css, {
          from: inputFile
        });

        const out = loader.finalSource;
        if (out) css.prepend(out);

        if (opts.localsConvention) {
          const isFunc = typeof opts.localsConvention === "function";

          parser.exportTokens = Object.entries(parser.exportTokens).reduce(function (tokens, [className, value]) {
            if (isFunc) {
              tokens[opts.localsConvention(className, value, inputFile)] = value;

              return tokens;
            }

            switch (opts.localsConvention) {
              case "camelCase":
                tokens[className] = value;
                tokens[(0, _lodash2.default)(className)] = value;

                break;
              case "camelCaseOnly":
                tokens[(0, _lodash2.default)(className)] = value;

                break;
              case "dashes":
                tokens[className] = value;
                tokens[dashesCamelCase(className)] = value;

                break;
              case "dashesOnly":
                tokens[dashesCamelCase(className)] = value;

                break;
            }

            return tokens;
          }, {});
        }

        result.messages.push({
          type: "export",
          plugin: "postcss-modules",
          exportTokens: parser.exportTokens
        });

        // getJSON may return a promise
        return getJSON(css.source.input.file, parser.exportTokens, result.opts.to);
      })();
    }
  };
};

buildExports.postcss = true;

function compileStyle(options) {
  return doCompileStyle({
    ...options,
    isAsync: false
  });
}
function compileStyleAsync(options) {
  return doCompileStyle({
    ...options,
    isAsync: true
  });
}
function doCompileStyle(options) {
  const {
    filename,
    id,
    scoped = false,
    trim = true,
    isProd = false,
    modules = false,
    modulesOptions = {},
    preprocessLang,
    postcssOptions,
    postcssPlugins
  } = options;
  const preprocessor = preprocessLang && processors[preprocessLang];
  const preProcessedSource = preprocessor && preprocess(options, preprocessor);
  const map = preProcessedSource ? preProcessedSource.map : options.inMap || options.map;
  const source = preProcessedSource ? preProcessedSource.code : options.source;
  const shortId = id.replace(/^data-v-/, "");
  const longId = `data-v-${shortId}`;
  const plugins = (postcssPlugins || []).slice();
  plugins.unshift(cssVarsPlugin({ id: shortId, isProd }));
  if (trim) {
    plugins.push(trimPlugin$1());
  }
  if (scoped) {
    plugins.push(scopedPlugin$1(longId));
  }
  let cssModules;
  if (modules) {
    if (!options.isAsync) {
      throw new Error(
        "[@vue/compiler-sfc] `modules` option can only be used with compileStyleAsync()."
      );
    }
    plugins.push(
      buildExports({
        ...modulesOptions,
        getJSON: (_cssFileName, json) => {
          cssModules = json;
        }
      })
    );
  }
  const postCSSOptions = {
    ...postcssOptions,
    to: filename,
    from: filename
  };
  if (map) {
    postCSSOptions.map = {
      inline: false,
      annotation: false,
      prev: map
    };
  }
  let result;
  let code;
  let outMap;
  const dependencies = new Set(
    preProcessedSource ? preProcessedSource.dependencies : []
  );
  dependencies.delete(filename);
  const errors = [];
  if (preProcessedSource && preProcessedSource.errors.length) {
    errors.push(...preProcessedSource.errors);
  }
  const recordPlainCssDependencies = (messages) => {
    messages.forEach((msg) => {
      if (msg.type === "dependency") {
        dependencies.add(msg.file);
      }
    });
    return dependencies;
  };
  try {
    result = require$$0$2(plugins).process(source, postCSSOptions);
    if (options.isAsync) {
      return result.then((result2) => ({
        code: result2.css || "",
        map: result2.map && result2.map.toJSON(),
        errors,
        modules: cssModules,
        rawResult: result2,
        dependencies: recordPlainCssDependencies(result2.messages)
      })).catch((error) => ({
        code: "",
        map: void 0,
        errors: [...errors, error],
        rawResult: void 0,
        dependencies
      }));
    }
    recordPlainCssDependencies(result.messages);
    code = result.css;
    outMap = result.map;
  } catch (e) {
    errors.push(e);
  }
  return {
    code: code || ``,
    map: outMap && outMap.toJSON(),
    errors,
    rawResult: result,
    dependencies
  };
}
function preprocess(options, preprocessor) {
  return preprocessor(
    options.source,
    options.inMap || options.map,
    {
      filename: options.filename,
      ...options.preprocessOptions
    },
    options.preprocessCustomRequire
  );
}

const walk = estreeWalker.walk;

exports.MagicString = MagicString;
exports.babelParse = parser$2.parse;
exports.extractIdentifiers = compilerCore.extractIdentifiers;
exports.generateCodeFrame = compilerCore.generateCodeFrame;
exports.isInDestructureAssignment = compilerCore.isInDestructureAssignment;
exports.isStaticProperty = compilerCore.isStaticProperty;
exports.walkIdentifiers = compilerCore.walkIdentifiers;
exports.shouldTransformRef = reactivityTransform.shouldTransform;
exports.transformRef = reactivityTransform.transform;
exports.transformRefAST = reactivityTransform.transformAST;
exports.compileScript = compileScript;
exports.compileStyle = compileStyle;
exports.compileStyleAsync = compileStyleAsync;
exports.compileTemplate = compileTemplate;
exports.parse = parse$2;
exports.rewriteDefault = rewriteDefault;
exports.walk = walk;
