/// <reference types="node" />
import { VNode, ComponentInternalInstance, App, Slots, Component } from 'vue';
import { Readable, Writable } from 'stream';
import { ComponentPublicInstance, Directive } from '@vue/runtime-core';
export { includeBooleanAttr as ssrIncludeBooleanAttr } from '@vue/shared';

export type SSRBuffer = SSRBufferItem[] & {
    hasAsync?: boolean;
};
export type SSRBufferItem = string | SSRBuffer | Promise<SSRBuffer>;
export type PushFn = (item: SSRBufferItem) => void;
export type Props = Record<string, unknown>;
export type SSRContext = {
    [key: string]: any;
    teleports?: Record<string, string>;
    /* removed internal: __teleportBuffers */
    /* removed internal: __watcherHandles */
};
declare function renderVNode(push: PushFn, vnode: VNode, parentComponent: ComponentInternalInstance, slotScopeId?: string): void;

declare function renderToString(input: App | VNode, context?: SSRContext): Promise<string>;

export interface SimpleReadable {
    push(chunk: string | null): void;
    destroy(err: any): void;
}
declare function renderToSimpleStream<T extends SimpleReadable>(input: App | VNode, context: SSRContext, stream: T): T;
/**
 * @deprecated
 */
declare function renderToStream(input: App | VNode, context?: SSRContext): Readable;
declare function renderToNodeStream(input: App | VNode, context?: SSRContext): Readable;
declare function pipeToNodeWritable(input: App | VNode, context: SSRContext | undefined, writable: Writable): void;
declare function renderToWebStream(input: App | VNode, context?: SSRContext): ReadableStream;
declare function pipeToWebWritable(input: App | VNode, context: SSRContext | undefined, writable: WritableStream): void;

export type SSRSlots = Record<string, SSRSlot>;
export type SSRSlot = (props: Props, push: PushFn, parentComponent: ComponentInternalInstance | null, scopeId: string | null) => void;
declare function ssrRenderSlot(slots: Slots | SSRSlots, slotName: string, slotProps: Props, fallbackRenderFn: (() => void) | null, push: PushFn, parentComponent: ComponentInternalInstance, slotScopeId?: string): void;
declare function ssrRenderSlotInner(slots: Slots | SSRSlots, slotName: string, slotProps: Props, fallbackRenderFn: (() => void) | null, push: PushFn, parentComponent: ComponentInternalInstance, slotScopeId?: string, transition?: boolean): void;

declare function ssrRenderComponent(comp: Component, props?: Props | null, children?: Slots | SSRSlots | null, parentComponent?: ComponentInternalInstance | null, slotScopeId?: string): SSRBuffer | Promise<SSRBuffer>;

declare function ssrRenderTeleport(parentPush: PushFn, contentRenderFn: (push: PushFn) => void, target: string, disabled: boolean, parentComponent: ComponentInternalInstance): void;

declare function ssrRenderAttrs(props: Record<string, unknown>, tag?: string): string;
declare function ssrRenderDynamicAttr(key: string, value: unknown, tag?: string): string;
declare function ssrRenderAttr(key: string, value: unknown): string;
declare function ssrRenderClass(raw: unknown): string;
declare function ssrRenderStyle(raw: unknown): string;

declare function ssrInterpolate(value: unknown): string;

declare function ssrRenderList(source: unknown, renderItem: (value: unknown, key: string | number, index?: number) => void): void;

declare function ssrRenderSuspense(push: PushFn, { default: renderContent }: Record<string, (() => void) | undefined>): Promise<void>;

declare function ssrGetDirectiveProps(instance: ComponentPublicInstance, dir: Directive, value?: any, arg?: string, modifiers?: Record<string, boolean>): Record<string, any>;

declare const ssrLooseEqual: (a: unknown, b: unknown) => boolean;
declare function ssrLooseContain(arr: unknown[], value: unknown): boolean;
declare function ssrRenderDynamicModel(type: unknown, model: unknown, value: unknown): string;
declare function ssrGetDynamicModelProps(existingProps: any, model: unknown): {
    checked: boolean;
    value?: undefined;
} | {
    value: unknown;
    checked?: undefined;
} | null;

export { pipeToNodeWritable, pipeToWebWritable, renderToNodeStream, renderToSimpleStream, renderToStream, renderToString, renderToWebStream, ssrGetDirectiveProps, ssrGetDynamicModelProps, ssrInterpolate, ssrLooseContain, ssrLooseEqual, ssrRenderAttr, ssrRenderAttrs, ssrRenderClass, ssrRenderComponent, ssrRenderDynamicAttr, ssrRenderDynamicModel, ssrRenderList, ssrRenderSlot, ssrRenderSlotInner, ssrRenderStyle, ssrRenderSuspense, ssrRenderTeleport, renderVNode as ssrRenderVNode };
