
export declare const camelize: (str: string) => string;

export declare const capitalize: (str: string) => string;

export declare const EMPTY_ARR: [];

export declare const EMPTY_OBJ: {
    readonly [key: string]: any;
};

export declare function escapeHtml(string: unknown): string;

export declare const extend: <T extends object, U extends object>(a: T, b: U) => T & U;

export declare function generateCodeFrame(source: string, start?: number, end?: number): string;

export declare const hasChanged: (value: any, oldValue: any) => boolean;

export declare const hasOwn: (val: object, key: string | symbol) => key is never;

export declare const hyphenate: (str: string) => string;

export declare const isArray: (arg: any) => arg is any[];

export declare const isBooleanAttr: (key: string) => boolean;

export declare const isFunction: (val: unknown) => val is Function;

export declare const isGloballyWhitelisted: (key: string) => boolean;

export declare const isHTMLTag: (key: string) => boolean;

export declare const isNoUnitNumericStyleProp: (key: string) => boolean;

export declare const isObject: (val: unknown) => val is Record<any, any>;

export declare const isOn: (key: string) => boolean;

export declare const isPlainObject: (val: unknown) => val is object;

export declare const isPromise: <T = any>(val: unknown) => val is Promise<T>;

export declare const isReservedProp: (key: string) => boolean;

export declare const isSpecialBooleanAttr: (key: string) => boolean;

export declare function isSSRSafeAttrName(name: string): boolean;

export declare const isString: (val: unknown) => val is string;

export declare const isSVGTag: (key: string) => boolean;

export declare const isSymbol: (val: unknown) => val is symbol;

export declare const isVoidTag: (key: string) => boolean;

export declare function looseEqual(a: any, b: any): boolean;

export declare function looseIndexOf(arr: any[], val: any): number;

export declare function makeMap(str: string, expectsLowerCase?: boolean): (key: string) => boolean;

export declare function mockWarn(): void;

/**
 * Always return false.
 */
export declare const NO: () => boolean;

export declare const NOOP: () => void;

export declare function normalizeClass(value: unknown): string;

export declare function normalizeStyle(value: unknown): Record<string, string | number> | undefined;

export declare const objectToString: () => string;

export declare const PatchFlagNames: {
    [x: number]: string;
};

export declare const enum PatchFlags {
    TEXT = 1,
    CLASS = 2,
    STYLE = 4,
    PROPS = 8,
    FULL_PROPS = 16,
    HYDRATE_EVENTS = 32,
    STABLE_FRAGMENT = 64,
    KEYED_FRAGMENT = 128,
    UNKEYED_FRAGMENT = 256,
    NEED_PATCH = 512,
    DYNAMIC_SLOTS = 1024,
    HOISTED = -1,
    BAIL = -2
}

export declare const propsToAttrMap: Record<string, string | undefined>;

export declare const remove: <T>(arr: T[], el: T) => void;

export declare const enum ShapeFlags {
    ELEMENT = 1,
    FUNCTIONAL_COMPONENT = 2,
    STATEFUL_COMPONENT = 4,
    TEXT_CHILDREN = 8,
    ARRAY_CHILDREN = 16,
    SLOTS_CHILDREN = 32,
    PORTAL = 64,
    SUSPENSE = 128,
    COMPONENT_SHOULD_KEEP_ALIVE = 256,
    COMPONENT_KEPT_ALIVE = 512,
    COMPONENT = 6
}

export declare function stringifyStyle(styles: Record<string, string | number> | undefined): string;

export declare const toDisplayString: (val: unknown) => string;

export declare const toRawType: (value: unknown) => string;

export declare const toTypeString: (value: unknown) => string;

export { }
