var assign = require('object-assign')
var path = require('path')
var ensureRequire = require('../ensure-require.js')

module.exports = function (raw, cb, compiler, filePath) {
  ensureRequire('sass', 'node-sass')
  var sass = require('node-sass')

  var sassOptions = assign({
    data: raw,
    success: function (res) {
      if (typeof res === 'object') {
        cb(null, res.css)
      } else {
        cb(null, res) // compat for node-sass < 2.0.0
      }
    },
    error: function (err) {
      cb(err)
    }
  }, compiler.options.sass || {
    sourceComments: true
  })

  var dir = path.dirname(filePath)
  var paths = [dir, process.cwd()]
  sassOptions.includePaths = sassOptions.includePaths
    ? sassOptions.includePaths.concat(paths)
    : paths

  sass.render(
    sassOptions,
    // callback for node-sass > 3.0.0
    function (err, res) {
      if (err) {
        cb(err)
      } else {
        res.stats.includedFiles.forEach(function (file) {
          compiler.emit('dependency', file)
        })
        cb(null, res.css.toString())
      }
    }
  )
}
