export default
    `<ul class="pagination">
        <li role="menu" v-if="boundaryLinks" :class="{ disabled: isNoPreviousOrDisabled }" class="pagination-first">
            <a href @click="selectPage(1, $event)" :disabled="isNoPreviousOrDisabled" v-uib-tabindex-toggle="isNoPreviousOrDisabled">{{ getText('first') }}</a>
        </li>
        <li role="menu" v-if="directionLinks" :class="{ disabled: isNoPreviousOrDisabled }" class="pagination-prev">
            <a href @click="selectPage(currentPage - 1, $event)" :disabled="isNoPreviousOrDisabled" v-uib-tabindex-toggle="isNoPreviousOrDisabled">{{ getText('previous') }}</a>
        </li>
        <li role="menu" v-for="(page, index) in pages" :key="index" :class="{ active: page.active, disabled: disabled && !page.active }" class="pagination-page">
            <a href @click="selectPage(page.number, $event)" :disabled="disabled && !page.active" v-uib-tabindex-toggle="disabled && !page.active">{{ page.text }}</a>
        </li>
        <li role="menu" v-if="directionLinks" :class="{ disabled: isNoNextOrDisabled }" class="pagination-next">
            <a href @click="selectPage(currentPage + 1, $event)" :disabled="isNoNextOrDisabled" v-uib-tabindex-toggle="isNoNextOrDisabled">{{ getText('next') }}</a>
        </li>
        <li role="menu" v-if="boundaryLinks" :class="{ disabled: isNoNextOrDisabled }" class="pagination-last">
            <a href @click="selectPage(totalPages, $event)" :disabled="isNoNextOrDisabled" v-uib-tabindex-toggle="isNoNextOrDisabled">{{ getText('last') }}</a>
        </li>
    </ul>`;