'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var constant = function constant(c) {
  return function () {
    return c;
  };
};
var buildFromKeys = function buildFromKeys(keys, fn, keyFn) {
  return keys.reduce(function (build, key) {
    build[keyFn ? keyFn(key) : key] = fn(key);
    return build;
  }, {});
};

function isObject(val) {
  return val !== null && (typeof val === 'undefined' ? 'undefined' : _typeof(val)) === 'object';
}

function isPromise(object) {
  return ((typeof object === 'undefined' ? 'undefined' : _typeof(object)) === 'object' || typeof object === 'function') && typeof object.then === 'function';
}

function RuleOut($v, $p) {
  this.$v = $v;
  this.$p = $p;
}

function isNested(ruleset) {
  return isObject(ruleset) && !(ruleset instanceof RuleOut) && !ruleset.__isVuelidateAsyncVm;
}

var _cachedVue = null;
function getVue(rootVm) {
  if (_cachedVue) return _cachedVue;
  var Vue = rootVm.constructor;
  while (Vue.super) {
    Vue = Vue.super;
  }_cachedVue = Vue;
  return Vue;
}

var getPath = function getPath(ctx, obj, path, fallback) {
  if (typeof path === 'function') {
    return path.call(ctx, obj, fallback);
  }

  path = Array.isArray(path) ? path : path.split('.');
  for (var i = 0; i < path.length; i++) {
    if (isObject(obj)) {
      obj = obj[path[i]];
    } else {
      return fallback;
    }
  }

  return typeof obj === 'undefined' ? fallback : obj;
};

function setDirtyRecursive(newState) {
  this.dirty = newState;
  var method = newState ? '$touch' : '$reset';
  var keys = this.dynamicKeys;
  for (var i = 0; i < keys.length; i++) {
    var ruleOrNested = keys[i];
    var val = this[ruleOrNested];
    if (isNested(val)) {
      val[method]();
    }
  }
}

var defaultMethods = {
  $touch: function $touch() {
    setDirtyRecursive.call(this, true);
  },
  $reset: function $reset() {
    setDirtyRecursive.call(this, false);
  },
  $flattenParams: function $flattenParams() {
    var params = [];
    for (var key in this.$params) {
      var val = this[mapDynamicKeyName(key)];
      if (isNested(val)) {
        var childParams = val.$flattenParams();
        for (var j = 0; j < childParams.length; j++) {
          childParams[j].path.unshift(key);
        }
        params = params.concat(childParams);
      } else {
        params.push({ path: [], name: key, params: this.$params[key] });
      }
    }
    return params;
  }
};

var defaultComputed = {
  $invalid: function $invalid() {
    var _this = this;

    return this.dynamicKeys.some(function (ruleOrNested) {
      var val = unwrapMaybeAsync(_this, ruleOrNested);
      return isObject(val) ? val.$invalid : !val;
    });
  },
  $dirty: function $dirty() {
    if (this.dirty) {
      return true;
    }
    var keys = this.dynamicKeys;

    var foundNested = false;
    for (var i = 0; i < keys.length; i++) {
      var ruleOrNested = keys[i];
      var val = this[ruleOrNested];
      var nested = isNested(val);
      foundNested = foundNested || nested;
      if (nested && !val.$dirty) {
        return false;
      }
    }
    return foundNested;
  },
  $error: function $error() {
    return !!(!this.$pending && this.$dirty && this.$invalid);
  },
  $pending: function $pending() {
    var _this2 = this;

    return this.dynamicKeys.some(function (ruleOrNested) {
      var raw = _this2[ruleOrNested];
      if (isNested(raw)) {
        return raw.$pending;
      }
      var val = raw.$v;
      if (val.__isVuelidateAsyncVm) {
        return val.pending;
      }
      return false;
    });
  },
  $params: function $params() {
    var _this3 = this;

    return buildFromKeys(this.dynamicKeys.map(function (k) {
      return k.substr(3);
    }), function (ruleOrNested) {
      var raw = _this3[mapDynamicKeyName(ruleOrNested)];
      if (isNested(raw)) {
        return null;
      }
      return raw.$p;
    });
  }
};

var defaultMethodKeys = Object.keys(defaultMethods);
var defaultComputedKeys = Object.keys(defaultComputed);
var mapDynamicKeyName = function mapDynamicKeyName(k) {
  return 'v$$' + k;
};

function isSingleRule(ruleset) {
  return typeof ruleset === 'function';
}

function makePendingAsyncVm(Vue, promise) {
  var asyncVm = new Vue({
    data: {
      pending: true,
      value: false
    }
  });

  promise.then(function (value) {
    asyncVm.pending = false;
    asyncVm.value = value;
  }, function (error) {
    asyncVm.pending = false;
    asyncVm.value = false;
    throw error;
  });

  asyncVm.__isVuelidateAsyncVm = true;
  return asyncVm;
}

function makeValidationVm(validations, parentVm) {
  var rootVm = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : parentVm;
  var parentProp = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : null;

  var validationKeys = Object.keys(validations).filter(function (key) {
    return !!validations[key];
  });
  var dynamicKeys = validationKeys.map(mapDynamicKeyName);

  var computedRules = buildFromKeys(validationKeys, function (key) {
    var rule = validations[key];
    return mapValidator(rootVm, rule, key, parentVm, parentProp);
  }, mapDynamicKeyName);

  var Vue = getVue(rootVm);

  var validationVm = new Vue({
    data: {
      dirty: false,
      dynamicKeys: dynamicKeys
    },
    methods: defaultMethods,
    computed: _extends({}, computedRules, defaultComputed)
  });
  return proxyVm(validationVm, validationKeys);
}

function mapValidator(rootVm, rule, ruleKey, vm, vmProp) {
  if (isSingleRule(rule)) {
    return mapRule(rootVm, rule, ruleKey, vm, vmProp);
  } else if (Array.isArray(rule)) {
    return mapGroup(rootVm, rule, ruleKey, vm, vmProp);
  } else {
    return mapChild(rootVm, rule, ruleKey, vm, vmProp);
  }
}

function unwrapMaybeAsync(vm, dynamicKey) {
  var raw = vm[dynamicKey];
  if (isNested(raw)) {
    return raw;
  }
  var val = raw.$v;
  if ((typeof val === 'undefined' ? 'undefined' : _typeof(val)) === 'object' && val.__isVuelidateAsyncVm) {
    return val.value;
  }
  return val;
}

function mapRule(rootVm, rule, ruleKey, parentVm, prop) {
  var indirectWatcher = null;

  var runRule = function runRule() {
    pushParams();
    var validatorOutput = rule.call(rootVm, parentVm[prop], parentVm);
    var params = popParams();
    var $p = params && params.$sub ? params.$sub.length > 1 ? params : params.$sub[0] : null;

    var $v = null;
    if (isPromise(validatorOutput)) {
      $v = makePendingAsyncVm(getVue(rootVm), validatorOutput);
    } else if (isObject(validatorOutput) && !!validatorOutput.__isVuelidateVm) {
      $v = validatorOutput;
    } else {
      $v = !!validatorOutput;
    }

    return new RuleOut($v, $p);
  };
  var lastInputVal = {};
  return function () {
    var isArrayDependant = prop !== null && Array.isArray(parentVm) && parentVm.__ob__;

    if (isArrayDependant) {
      var arrayDep = parentVm.__ob__.dep;
      arrayDep.depend();

      var target = arrayDep.constructor.target;

      if (!indirectWatcher) {
        var Watcher = target.constructor;
        indirectWatcher = new Watcher(rootVm, runRule, null, { lazy: true });
      }

      if (!indirectWatcher.dirty && lastInputVal === parentVm[prop]) {
        indirectWatcher.depend();
        return target.value;
      }

      lastInputVal = parentVm[prop];
      indirectWatcher.evaluate();
      indirectWatcher.depend();
    }

    return indirectWatcher ? indirectWatcher.value : runRule();
  };
}

function mapChild(rootVm, rules, ruleKey, parentVm, prop) {
  if (ruleKey === '$each') {
    return trackCollection(rootVm, rules, parentVm, prop);
  }
  var childVm = typeof prop === 'string' ? parentVm[prop] : parentVm;
  var vm = makeValidationVm(rules, childVm, rootVm, ruleKey);
  return constant(vm);
}

function trackCollection(rootVm, eachRule, parentVm, prop) {
  var vmList = {};
  var strippedRule = _extends({}, eachRule, {
    $trackBy: undefined
  });

  return function () {
    var childVm = typeof prop === 'string' ? parentVm[prop] : parentVm;
    var newKeys = Object.keys(childVm);
    var keyToTrack = typeof eachRule.$trackBy !== 'undefined' ? buildFromKeys(newKeys, function (key) {
      return getPath(rootVm, childVm[key], eachRule.$trackBy);
    }) : null;

    var vmByKey = {};
    vmList = newKeys.reduce(function (newList, key) {
      var track = keyToTrack ? keyToTrack[key] : key;
      vmByKey[key] = newList[track] = newList[track] || vmList[track] || mapValidator(rootVm, strippedRule, key, childVm);
      return newList;
    }, {});

    return makeValidationVm(vmByKey, childVm, rootVm);
  };
}

function mapGroup(rootVm, group, prop, parentVm) {
  var rules = buildFromKeys(group, function (path) {
    return function () {
      return getPath(this, this.$v, path);
    };
  });

  var vm = makeValidationVm(rules, parentVm, rootVm, prop);
  return constant(vm);
}

function proxyVm(vm, originalKeys, extras) {
  var redirectDef = _extends({}, buildFromKeys(originalKeys, function (key) {
    var dynKey = mapDynamicKeyName(key);
    return {
      enumerable: true,
      get: function get() {
        return unwrapMaybeAsync(vm, dynKey);
      }
    };
  }), buildFromKeys(defaultComputedKeys, function (key) {
    return {
      enumerable: true,
      get: function get() {
        return vm[key];
      }
    };
  }), buildFromKeys(defaultMethodKeys, function (key) {
    return {
      value: vm[key].bind(vm)
    };
  }), {
    __isVuelidateVm: {
      configurable: false,
      enumerable: false,
      value: true
    }
  });

  return Object.defineProperties({}, redirectDef);
}

var validationMixin = {
  beforeCreate: function beforeCreate() {
    var _this4 = this;

    var options = this.$options;
    if (!options.validations) return;
    var validations = options.validations;

    if (typeof options.computed === 'undefined') {
      options.computed = {};
    }

    if (typeof validations === 'function') {
      var getV = function getV() {
        return validateModel(_this4, validations.call(_this4));
      };
      options.computed.$v = getV;
    } else {
      options.computed.$v = function () {
        return validateModel(_this4, validations);
      };
    }
  }
};

var validateModel = function validateModel(model, validations) {
  return makeValidationVm(validations, model);
};

function Vuelidate(Vue) {
  Vue.mixin(validationMixin);
}

function withParams(paramsOrClosure, maybeValidator) {
  if ((typeof paramsOrClosure === 'undefined' ? 'undefined' : _typeof(paramsOrClosure)) === 'object' && maybeValidator !== undefined) {
    return withParamsDirect(paramsOrClosure, maybeValidator);
  }
  return withParamsClosure(paramsOrClosure);
}

var stack = [];
withParams.target = null;

function pushParams() {
  if (withParams.target !== null) {
    stack.push(withParams.target);
  }
  withParams.target = {};
}

function popParams() {
  var lastTarget = withParams.target;
  var newTarget = withParams.target = stack.pop() || null;
  if (newTarget) {
    if (!Array.isArray(newTarget.$sub)) {
      newTarget.$sub = [];
    }
    newTarget.$sub.push(lastTarget);
  }
  return lastTarget;
}

function addParams(params) {
  if ((typeof params === 'undefined' ? 'undefined' : _typeof(params)) === 'object' && !Array.isArray(params)) {
    withParams.target = _extends({}, withParams.target, params);
  } else {
    throw new Error('params must be an object');
  }
}

function withParamsDirect(params, validator) {
  return withParamsClosure(function (add) {
    return function () {
      add(params);

      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      return validator.apply(this, args);
    };
  });
}

function withParamsClosure(closure) {
  var validator = closure(addParams);
  return function () {
    pushParams();
    try {
      for (var _len2 = arguments.length, args = Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }

      return validator.apply(this, args);
    } finally {
      popParams();
    }
  };
}

exports.Vuelidate = Vuelidate;
exports.validationMixin = validationMixin;
exports.validateModel = validateModel;
exports.withParams = withParams;
exports.default = Vuelidate;