'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withParams = exports.validationMixin = exports.Vuelidate = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _vval = require('./vval');

var _params = require('./params');

var buildFromKeys = function buildFromKeys(keys, fn, keyFn) {
  return keys.reduce(function (build, key) {
    build[keyFn ? keyFn(key) : key] = fn(key);
    return build;
  }, {});
};

function isPromise(object) {
  return (typeof object === 'object' || typeof object === 'function') && typeof object.then === 'function';
}

var getPath = function getPath(ctx, obj, path, fallback) {
  if (typeof path === 'function') {
    return path.call(ctx, obj, fallback);
  }

  path = Array.isArray(path) ? path : path.split('.');
  for (var i = 0; i < path.length; i++) {
    if (obj && typeof obj === 'object') {
      obj = obj[path[i]];
    } else {
      return fallback;
    }
  }

  return typeof obj === 'undefined' ? fallback : obj;
};

var __isVuelidateAsyncVm = '__isVuelidateAsyncVm';
function makePendingAsyncVm(Vue, promise) {
  var asyncVm = new Vue({
    data: {
      p: true, // pending
      v: false // value
    }
  });

  promise.then(function (value) {
    asyncVm.p = false;
    asyncVm.v = value;
  }, function (error) {
    asyncVm.p = false;
    asyncVm.v = false;
    throw error;
  });

  asyncVm[__isVuelidateAsyncVm] = true;
  return asyncVm;
}

var validationGetters = {
  $invalid: function $invalid() {
    var proxy = this.proxy;
    return this.nestedKeys.some(function (nested) {
      return proxy[nested].$invalid;
    }) || this.ruleKeys.some(function (rule) {
      return !proxy[rule];
    });
  },
  $dirty: function $dirty() {
    if (this.dirty) {
      return true;
    }
    if (this.nestedKeys.length === 0) {
      return false;
    }

    var proxy = this.proxy;
    return this.nestedKeys.every(function (key) {
      return proxy[key].$dirty;
    });
  },
  $error: function $error() {
    return this.$dirty && !this.$pending && this.$invalid;
  },
  $pending: function $pending() {
    var _this = this;

    var proxy = this.proxy;
    return this.nestedKeys.some(function (key) {
      return proxy[key].$pending;
    }) || this.ruleKeys.some(function (key) {
      return _this.getRef(key).$pending;
    });
  },
  $params: function $params() {
    var _this2 = this;

    var vals = this.validations;
    return _extends({}, buildFromKeys(this.nestedKeys, function (key) {
      return vals[key] && vals[key].$params || null;
    }), buildFromKeys(this.ruleKeys, function (key) {
      return _this2.getRef(key).$params;
    }));
  }
};

function setDirtyRecursive(newState) {
  this.dirty = newState;
  var proxy = this.proxy;
  var method = newState ? '$touch' : '$reset';
  this.nestedKeys.forEach(function (key) {
    proxy[key][method]();
  });
}

var validationMethods = {
  $touch: function $touch() {
    setDirtyRecursive.call(this, true);
  },
  $reset: function $reset() {
    setDirtyRecursive.call(this, false);
  },
  $flattenParams: function $flattenParams() {
    var proxy = this.proxy;
    var params = [];
    for (var key in this.$params) {
      if (this.isNested(key)) {
        var childParams = proxy[key].$flattenParams();
        for (var j = 0; j < childParams.length; j++) {
          childParams[j].path.unshift(key);
        }
        params = params.concat(childParams);
      } else {
        params.push({ path: [], name: key, params: this.$params[key] });
      }
    }
    return params;
  }
};

var getterNames = Object.keys(validationGetters);
var methodNames = Object.keys(validationMethods);

var _cachedComponent = null;
var getComponent = function getComponent(Vue) {
  if (_cachedComponent) {
    return _cachedComponent;
  }

  var VBase = Vue.extend({
    beforeCreate: function beforeCreate() {
      this._vval = null;
    },
    beforeDestroy: function beforeDestroy() {
      if (this._vval) {
        (0, _vval.patchChildren)(this._vval);
      }
    },

    computed: {
      refs: function refs() {
        var oldVval = this._vval;
        this._vval = this.children;
        (0, _vval.patchChildren)(oldVval, this._vval);
        var refs = {};
        this._vval.forEach(function (c) {
          refs[c.key] = c.vm;
        });
        return refs;
      }
    }
  });

  var ValidationRule = VBase.extend({
    data: function data() {
      return {
        rule: null,
        model: null,
        parentModel: null,
        rootModel: null
      };
    },

    methods: {
      runRule: function runRule(parent) {
        // Avoid using this.parentModel to not get dependent on it.
        // Passed as an argument for workaround
        (0, _params.pushParams)();
        var rawOutput = this.rule.call(this.rootModel, this.model, parent);
        var output = isPromise(rawOutput) ? makePendingAsyncVm(Vue, rawOutput) : rawOutput;

        var rawParams = (0, _params.popParams)();
        var params = rawParams && rawParams.$sub ? rawParams.$sub.length > 1 ? rawParams : rawParams.$sub[0] : null;

        return { output: output, params: params };
      }
    },
    computed: {
      run: function run() {
        var _this3 = this;

        var parent = this.parentModel;
        var isArrayDependant = Array.isArray(parent) && parent.__ob__;

        if (isArrayDependant) {
          // force depend on the array
          var arrayDep = parent.__ob__.dep;
          arrayDep.depend();

          var target = arrayDep.constructor.target;

          if (!this._indirectWatcher) {
            var Watcher = target.constructor;
            this._indirectWatcher = new Watcher(this.rootModel, function () {
              return _this3.runRule(parent);
            }, null, { lazy: true });
          }

          // if the update cause is only the array update
          // and value stays the same, don't recalculate
          if (!this._indirectWatcher.dirty && this._lastModel === this.model) {
            this._indirectWatcher.depend();
            return target.value;
          }

          this._lastModel = this.model;
          this._indirectWatcher.evaluate();
          this._indirectWatcher.depend();
        }

        return this._indirectWatcher ? this._indirectWatcher.value : this.runRule(parent);
      },
      $params: function $params() {
        return this.run.params;
      },
      proxy: function proxy() {
        var output = this.run.output;
        if (output[__isVuelidateAsyncVm]) {
          return !!output.v;
        }
        return !!output;
      },
      $pending: function $pending() {
        var output = this.run.output;
        if (output[__isVuelidateAsyncVm]) {
          return output.p;
        }
        return false;
      }
    }
  });

  var Validation = VBase.extend({
    data: function data() {
      return {
        dirty: false,
        validations: null,
        model: null,
        prop: null,
        parentModel: null,
        rootModel: null
      };
    },

    methods: _extends({}, validationMethods, {
      getRef: function getRef(key) {
        return this.refs[key];
      },
      isNested: function isNested(key) {
        return typeof this.validations[key] !== 'function';
      }
    }),
    computed: _extends({}, validationGetters, {
      nestedKeys: function nestedKeys() {
        return this.keys.filter(this.isNested);
      },
      ruleKeys: function ruleKeys() {
        var _this4 = this;

        return this.keys.filter(function (k) {
          return !_this4.isNested(k);
        });
      },
      keys: function keys() {
        return Object.keys(this.validations).filter(function (k) {
          return k !== '$params';
        });
      },
      proxy: function proxy() {
        var _this5 = this;

        var keyDefs = buildFromKeys(this.keys, function (key) {
          return {
            enumerable: true,
            configurable: false,
            get: function get() {
              return _this5.getRef(key).proxy;
            }
          };
        });

        var getterDefs = buildFromKeys(getterNames, function (key) {
          return {
            enumerable: true,
            configurable: false,
            get: function get() {
              return _this5[key];
            }
          };
        });

        var methodDefs = buildFromKeys(methodNames, function (key) {
          return {
            enumerable: false,
            configurable: false,
            get: function get() {
              return _this5[key];
            }
          };
        });

        return Object.defineProperties({}, _extends({}, keyDefs, getterDefs, methodDefs));
      },
      children: function children() {
        var _this6 = this;

        return [].concat(this.nestedKeys.map(function (key) {
          return renderNested(_this6, key);
        }), this.ruleKeys.map(function (key) {
          return renderRule(_this6, key);
        })).filter(Boolean);
      }
    })
  });

  var GroupValidation = Validation.extend({
    methods: {
      isNested: function isNested(key) {
        return typeof this.validations[key]() !== 'undefined';
      },
      getRef: function getRef(key) {
        var vm = this;
        return {
          get proxy() {
            // default to invalid
            return vm.validations[key]() || false;
          }
        };
      }
    }
  });

  var EachValidation = Validation.extend({
    computed: {
      keys: function keys() {
        return Object.keys(this.model);
      },
      tracker: function tracker() {
        var _this7 = this;

        var trackBy = this.validations.$trackBy;
        return trackBy ? function (key) {
          return '' + getPath(_this7.rootModel, _this7.model[key], trackBy);
        } : function (x) {
          return '' + x;
        };
      },
      children: function children() {
        var _this8 = this;

        var def = this.validations;

        var validations = _extends({}, def);
        delete validations['$trackBy'];

        var usedTracks = {};

        return this.keys.map(function (key) {
          var track = _this8.tracker(key);
          if (usedTracks.hasOwnProperty(track)) {
            return null;
          }
          usedTracks[track] = true;
          return (0, _vval.h)(Validation, track, {
            validations: validations,
            prop: key,
            parentModel: _this8.model,
            model: _this8.model[key],
            rootModel: _this8.rootModel
          });
        }).filter(Boolean);
      }
    },
    methods: {
      isNested: function isNested() {
        return true;
      },
      getRef: function getRef(key) {
        return this.refs[this.tracker(key)];
      }
    }
  });

  var renderNested = function renderNested(vm, key) {
    if (key === '$each') {
      return (0, _vval.h)(EachValidation, key, {
        validations: vm.validations[key],
        parentModel: vm.parentModel,
        prop: key,
        model: vm.model,
        rootModel: vm.rootModel
      });
    }
    var validations = vm.validations[key];
    if (Array.isArray(validations)) {
      var root = vm.rootModel;
      var refVals = buildFromKeys(validations, function (path) {
        return function () {
          return getPath(root, root.$v, path);
        };
      }, function (v) {
        return Array.isArray(v) ? v.join('.') : v;
      });
      return (0, _vval.h)(GroupValidation, key, {
        validations: refVals,
        parentModel: null,
        prop: key,
        model: null,
        rootModel: root
      });
    }
    return (0, _vval.h)(Validation, key, {
      validations: validations,
      parentModel: vm.model,
      prop: key,
      model: vm.model[key],
      rootModel: vm.rootModel
    });
  };

  var renderRule = function renderRule(vm, key) {
    return (0, _vval.h)(ValidationRule, key, {
      rule: vm.validations[key],
      parentModel: vm.parentModel,
      model: vm.model,
      rootModel: vm.rootModel
    });
  };

  _cachedComponent = { VBase: VBase, Validation: Validation };
  return _cachedComponent;
};

var _cachedVue = null;
function getVue(rootVm) {
  if (_cachedVue) return _cachedVue;
  var Vue = rootVm.constructor;
  /* istanbul ignore next */
  while (Vue.super) {
    Vue = Vue.super;
  }_cachedVue = Vue;
  return Vue;
}

var validateModel = function validateModel(model, validations) {
  var Vue = getVue(model);

  var _getComponent = getComponent(Vue),
      Validation = _getComponent.Validation,
      VBase = _getComponent.VBase;

  var root = new VBase({
    computed: {
      children: function children() {
        var vals = typeof validations === 'function' ? validations.call(model) : validations;

        return [(0, _vval.h)(Validation, '$v', {
          validations: vals,
          parentModel: null,
          prop: '$v',
          model: model,
          rootModel: model
        })];
      }
    }
  });
  return root;
};

var validationMixin = {
  data: function data() {
    var vals = this.$options.validations;
    if (vals) {
      this._vuelidate = validateModel(this, vals);
    }
    return {};
  },
  beforeCreate: function beforeCreate() {
    var _this9 = this;

    var options = this.$options;
    var vals = options.validations;
    if (!vals) return;
    if (!options.computed) options.computed = {};
    options.computed.$v = function () {
      return _this9._vuelidate.refs.$v.proxy;
    };
  },
  beforeDestroy: function beforeDestroy() {
    if (this._vuelidate) {
      this._vuelidate.$destroy();
      this._vuelidate = null;
    }
  }
};

function Vuelidate(Vue) {
  Vue.mixin(validationMixin);
}

exports.Vuelidate = Vuelidate;
exports.validationMixin = validationMixin;
exports.withParams = _params.withParams;
exports.default = Vuelidate;