import { HeadTag, MergeHead, MaybeComputedRef, ReactiveHead, VueHeadClient } from '@unhead/vue';
export { ActiveHeadEntry, HeadEntryOptions, HeadTag, MaybeComputedRef, MergeHead, ReactiveHead, Unhead, UseHeadInput, Vue2ProvideUnheadPlugin, VueHeadMixin, createHeadCore, injectHead, unheadVueComposablesImports, useBodyAttrs, useHead, useHtmlAttrs, useSeoMeta, useServerBodyAttrs, useServerHead, useServerHtmlAttrs, useServerTagBase, useServerTagLink, useServerTagMeta, useServerTagMetaFlat, useServerTagNoscript, useServerTagScript, useServerTagStyle, useServerTagTitle, useServerTitleTemplate, useTagBase, useTagLink, useTagMeta, useTagMetaFlat, useTagNoscript, useTagScript, useTagStyle, useTagTitle, useTitleTemplate } from '@unhead/vue';
import * as _unhead_schema from '@unhead/schema';
import { HeadEntry, HeadPlugin, HeadEntryOptions, ActiveHeadEntry, Unhead, Head as Head$1 } from '@unhead/schema';
import * as vue from 'vue';
import { App, Plugin } from 'vue';

type HookBeforeDomUpdate = (() => Promise<void | boolean> | void | boolean);
type HookTagsResolved = ((tags: HeadTag[]) => Promise<void> | void);
type HookEntriesResolved = ((entries: HeadEntry<any>[]) => Promise<void> | void);
interface LegacyHeadOptions {
    /**
     * @deprecated
     */
    resolved?: boolean;
    /**
     * @deprecated
     */
    raw?: boolean;
}
interface HeadClient<T extends MergeHead = {}> {
    install: (app: App) => void;
    resolveTags: () => Promise<HeadTag[]>;
    use: (plugin: HeadPlugin) => void;
    headEntries: () => HeadEntry<MaybeComputedRef<ReactiveHead<T>>>[];
    push: (entry: MaybeComputedRef<ReactiveHead<T>>, options?: HeadEntryOptions) => ActiveHeadEntry<MaybeComputedRef<ReactiveHead<T>>>;
    /**
     * @deprecated use `push`
     */
    addEntry: (entry: MaybeComputedRef<ReactiveHead<T>>, options?: HeadEntryOptions & LegacyHeadOptions) => ActiveHeadEntry<MaybeComputedRef<ReactiveHead<T>>>;
    /**
     * @deprecated use `push`
     */
    addReactiveEntry: (objs: MaybeComputedRef<ReactiveHead<T>>, options?: HeadEntryOptions & LegacyHeadOptions) => () => void;
    /**
     * @deprecated use `@unhead/dom`
     */
    updateDOM: (document?: Document, force?: boolean) => void;
    internalHooks: Unhead['hooks'];
    /**
     * @deprecated
     */
    hooks: 
    /**
     * Array of user provided functions to hook into before the DOM is updated.
     *
     * When returning false from this function, it will block DOM updates, this can be useful when stopping dom updates
     * between page transitions.
     *
     * You are able to modify the payload of hook using this.
     */
    Record<'before:dom', HookBeforeDomUpdate[]> & Record<'resolved:entries', HookEntriesResolved[]> & 
    /**
       * Array of user provided functions to hook into after the tags have been resolved (deduped and sorted).
       */
    Record<'resolved:tags', HookTagsResolved[]>;
    /**
     * Backwards compatibility function to fetch the headTags.
     *
     * This function forces reactivity resolving and is not performant.
     *
     * @deprecated Use `unhead.resolveTags()`.
     */
    headTags: () => Promise<HeadTag[]>;
    /**
     * Backwards compatibility function to add a head obj.
     *
     * Note: This will not support reactivity. Use `addReactiveEntry` instead.
     *
     * @deprecated Use addEntry
     */
    addHeadObjs: (entry: MaybeComputedRef<ReactiveHead<T>>, options?: HeadEntryOptions) => ActiveHeadEntry<MaybeComputedRef<ReactiveHead<T>>>;
    /**
     * @deprecated Does not do anything
     */
    removeHeadObjs: (entry: MaybeComputedRef<ReactiveHead<T>>) => void;
    /**
     * Access the underlying unhead instance.
     */
    unhead: VueHeadClient<T>;
}
declare function createHead<T extends MergeHead = {}>(initHeadObject?: Head$1<T>): HeadClient<T>;

declare const HeadVuePlugin: Plugin;
declare const renderHeadToString: <T extends MergeHead = {}>(head: HeadClient<T>) => Promise<_unhead_schema.SSRHeadPayload>;
type HeadObjectPlain = Head$1;
type HeadObject = ReactiveHead;

declare const Head: vue.DefineComponent<{}, () => null, {}, {}, {}, vue.ComponentOptionsMixin, vue.ComponentOptionsMixin, {}, string, vue.VNodeProps & vue.AllowedComponentProps & vue.ComponentCustomProps, Readonly<vue.ExtractPropTypes<{}>>, {}>;

export { Head, HeadClient, HeadObject, HeadObjectPlain, HeadVuePlugin, HookBeforeDomUpdate, HookEntriesResolved, HookTagsResolved, LegacyHeadOptions, createHead, renderHeadToString };
