'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var packages$1 = {
	shared: {
		name: "shared",
		display: "Shared utilities",
		dir: "packages/shared"
	},
	core: {
		name: "core",
		display: "VueUse",
		description: "Collection of essential Vue Composition Utilities",
		dir: "packages/core"
	},
	components: {
		name: "components",
		display: "Components",
		description: "Renderless components for VueUse",
		author: "Jacob Clevenger<https://github.com/wheatjs>",
		external: [
			"@vueuse/core",
			"@vueuse/shared"
		],
		dir: "packages/components"
	},
	router: {
		name: "router",
		display: "Router",
		description: "Utilities for vue-router",
		addon: true,
		external: [
			"vue-router"
		],
		globals: {
			"vue-router": "VueRouter"
		},
		dir: "packages/router",
		docs: "https://vueuse.org/router/README.html"
	},
	integrations: {
		name: "integrations",
		display: "Integrations",
		description: "Integration wrappers for utility libraries",
		addon: true,
		submodules: true,
		external: [
			"axios",
			"universal-cookie",
			"qrcode",
			"http",
			"nprogress",
			"jwt-decode",
			"focus-trap",
			"change-case",
			"drauu",
			"@vueuse/core",
			"@vueuse/shared",
			"fuse.js"
		],
		globals: {
			axios: "axios",
			"universal-cookie": "UniversalCookie",
			qrcode: "QRCode",
			nprogress: "nprogress",
			"jwt-decode": "jwt_decode",
			"focus-trap": "focusTrap",
			drauu: "Drauu",
			"fuse.js": "Fuse",
			"change-case": "changeCase"
		},
		dir: "packages/integrations",
		docs: "https://vueuse.org/integrations/README.html"
	},
	rxjs: {
		name: "rxjs",
		display: "RxJS",
		description: "Enables RxJS reactive functions in Vue",
		addon: true,
		external: [
			"rxjs",
			"rxjs/operators"
		],
		globals: {
			rxjs: "rxjs",
			"rxjs/operators": "rxjs.operator"
		},
		dir: "packages/rxjs",
		docs: "https://vueuse.org/rxjs/README.html"
	},
	firebase: {
		name: "firebase",
		display: "Firebase",
		description: "Enables realtime bindings for Firebase",
		addon: true,
		submodules: true,
		external: [
			"firebase",
			"firebase/app"
		],
		globals: {
			firebase: "firebase",
			"firebase/app": "firebase"
		},
		dir: "packages/firebase",
		docs: "https://vueuse.org/firebase/README.html"
	},
	electron: {
		name: "electron",
		display: "Electron",
		description: "Electron renderer process modules for VueUse",
		author: "Archer Gu<https://github.com/ArcherGu>",
		addon: true,
		external: [
			"electron"
		],
		iife: false,
		dir: "packages/electron",
		docs: "https://vueuse.org/electron/README.html"
	}
};
var categories$1 = [
	"Animation",
	"Browser",
	"Component",
	"Elements",
	"Misc",
	"Network",
	"Sensors",
	"State",
	"Utilities",
	"Watch",
	"@Electron",
	"@Firebase",
	"@Head",
	"@Integrations",
	"@Motion",
	"@Router",
	"@RxJS",
	"@SchemaOrg",
	"@Sound"
];
var functions$1 = [
	{
		name: "computedAsync",
		"package": "core",
		lastUpdated: 1651597361000,
		docs: "https://vueuse.org/core/computedAsync/",
		category: "Utilities",
		description: "computed for async functions",
		alias: [
			"asyncComputed"
		]
	},
	{
		name: "computedEager",
		"package": "shared",
		lastUpdated: 1645956777000,
		docs: "https://vueuse.org/shared/computedEager/",
		category: "Utilities",
		description: "eager computed without lazy evaluation",
		alias: [
			"eagerComputed"
		]
	},
	{
		name: "computedInject",
		"package": "core",
		lastUpdated: 1639442454000,
		docs: "https://vueuse.org/core/computedInject/",
		category: "Component",
		description: "combine computed and inject"
	},
	{
		name: "computedWithControl",
		"package": "shared",
		lastUpdated: 1657102664000,
		docs: "https://vueuse.org/shared/computedWithControl/",
		category: "Utilities",
		description: "explicitly define the dependencies of computed",
		alias: [
			"controlledComputed"
		],
		related: [
			"refWithControl"
		]
	},
	{
		name: "createEventHook",
		"package": "shared",
		lastUpdated: 1621876156000,
		docs: "https://vueuse.org/shared/createEventHook/",
		category: "Utilities",
		description: "utility for creating event hooks"
	},
	{
		name: "createGlobalState",
		"package": "shared",
		lastUpdated: 1625749207000,
		docs: "https://vueuse.org/shared/createGlobalState/",
		category: "State",
		description: "keep states in the global scope to be reusable across Vue instances"
	},
	{
		name: "createHead",
		"package": "head",
		description: "create the head manager instance.",
		category: "@Head",
		external: "https://github.com/vueuse/head#api"
	},
	{
		name: "createInjectionState",
		"package": "shared",
		lastUpdated: 1648221687000,
		docs: "https://vueuse.org/shared/createInjectionState/",
		category: "State",
		description: "create global state that can be injected into components"
	},
	{
		name: "createSchemaOrg",
		"package": "schema-org",
		description: "create the schema.org manager instance.",
		category: "@SchemaOrg",
		external: "https://vue-schema-org.netlify.app/api/core/create-schema-org.html"
	},
	{
		name: "createSharedComposable",
		"package": "shared",
		lastUpdated: 1639442454000,
		docs: "https://vueuse.org/shared/createSharedComposable/",
		category: "State",
		description: "make a composable function usable with multiple Vue instances"
	},
	{
		name: "createUnrefFn",
		"package": "core",
		lastUpdated: 1651597361000,
		docs: "https://vueuse.org/core/createUnrefFn/",
		category: "Utilities",
		description: "make a plain function accepting ref and raw values as arguments",
		related: [
			"reactify"
		]
	},
	{
		name: "extendRef",
		"package": "shared",
		lastUpdated: 1639442454000,
		docs: "https://vueuse.org/shared/extendRef/",
		category: "Utilities",
		description: "add extra attributes to Ref"
	},
	{
		name: "from",
		"package": "rxjs",
		lastUpdated: 1640930012000,
		docs: "https://vueuse.org/rxjs/from/",
		category: "@RxJS",
		description: "/ fromEvent"
	},
	{
		name: "get",
		"package": "shared",
		lastUpdated: 1639442454000,
		docs: "https://vueuse.org/shared/get/",
		category: "Utilities",
		description: "shorthand for accessing `ref.value`"
	},
	{
		name: "isDefined",
		"package": "shared",
		lastUpdated: 1639442454000,
		docs: "https://vueuse.org/shared/isDefined/",
		category: "Utilities",
		description: "non-nullish checking type guard for Ref"
	},
	{
		name: "logicAnd",
		"package": "shared",
		lastUpdated: 1646037429000,
		docs: "https://vueuse.org/shared/logicAnd/",
		category: "Utilities",
		description: "`AND` condition for refs",
		alias: [
			"and"
		],
		related: [
			"logicNot",
			"logicOr"
		]
	},
	{
		name: "logicNot",
		"package": "shared",
		lastUpdated: 1646037429000,
		docs: "https://vueuse.org/shared/logicNot/",
		category: "Utilities",
		description: "`NOT` condition for ref",
		alias: [
			"not"
		],
		related: [
			"logicAnd",
			"logicOr"
		]
	},
	{
		name: "logicOr",
		"package": "shared",
		lastUpdated: 1646037429000,
		docs: "https://vueuse.org/shared/logicOr/",
		category: "Utilities",
		description: "`OR` conditions for refs",
		alias: [
			"or"
		],
		related: [
			"logicAnd",
			"logicNot"
		]
	},
	{
		name: "makeDestructurable",
		"package": "shared",
		lastUpdated: 1642756441000,
		docs: "https://vueuse.org/shared/makeDestructurable/",
		category: "Utilities",
		description: "make isomorphic destructurable for object and array at the same time"
	},
	{
		name: "onClickOutside",
		"package": "core",
		lastUpdated: 1657430765000,
		component: true,
		directive: true,
		docs: "https://vueuse.org/core/onClickOutside/",
		category: "Sensors",
		description: "listen for clicks outside of an element"
	},
	{
		name: "onKeyStroke",
		"package": "core",
		lastUpdated: 1642756441000,
		directive: true,
		docs: "https://vueuse.org/core/onKeyStroke/",
		category: "Sensors",
		description: "listen for keyboard key being stroked"
	},
	{
		name: "onLongPress",
		"package": "core",
		lastUpdated: 1657076519000,
		component: true,
		directive: true,
		docs: "https://vueuse.org/core/onLongPress/",
		category: "Sensors",
		description: "listen for a long press on an element"
	},
	{
		name: "onStartTyping",
		"package": "core",
		lastUpdated: 1639442454000,
		docs: "https://vueuse.org/core/onStartTyping/",
		category: "Sensors",
		description: "fires when users start typing on non-editable elements"
	},
	{
		name: "reactify",
		"package": "shared",
		lastUpdated: 1651597361000,
		docs: "https://vueuse.org/shared/reactify/",
		category: "Utilities",
		description: "converts plain functions into reactive functions",
		alias: [
			"createReactiveFn"
		],
		related: [
			"createUnrefFn"
		]
	},
	{
		name: "reactifyObject",
		"package": "shared",
		lastUpdated: 1642756441000,
		docs: "https://vueuse.org/shared/reactifyObject/",
		category: "Utilities",
		description: "apply `reactify` to an object"
	},
	{
		name: "reactiveComputed",
		"package": "shared",
		lastUpdated: 1645876129000,
		docs: "https://vueuse.org/shared/reactiveComputed/",
		category: "Utilities",
		description: "computed reactive object"
	},
	{
		name: "reactiveOmit",
		"package": "shared",
		lastUpdated: 1657076758000,
		docs: "https://vueuse.org/shared/reactiveOmit/",
		category: "Utilities",
		description: "reactively omit fields from a reactive object"
	},
	{
		name: "reactivePick",
		"package": "shared",
		lastUpdated: 1657076758000,
		docs: "https://vueuse.org/shared/reactivePick/",
		category: "Utilities",
		description: "reactively pick fields from a reactive object"
	},
	{
		name: "refAutoReset",
		"package": "shared",
		lastUpdated: 1650438204000,
		docs: "https://vueuse.org/shared/refAutoReset/",
		category: "Utilities",
		description: "a ref which will be reset to the default value after some time",
		alias: [
			"autoResetRef"
		]
	},
	{
		name: "refDebounced",
		"package": "shared",
		lastUpdated: 1645956777000,
		docs: "https://vueuse.org/shared/refDebounced/",
		category: "Utilities",
		description: "debounce execution of a ref value",
		alias: [
			"useDebounce",
			"debouncedRef"
		]
	},
	{
		name: "refDefault",
		"package": "shared",
		lastUpdated: 1639442454000,
		docs: "https://vueuse.org/shared/refDefault/",
		category: "Utilities",
		description: "apply default value to a ref"
	},
	{
		name: "refThrottled",
		"package": "shared",
		lastUpdated: 1645956777000,
		docs: "https://vueuse.org/shared/refThrottled/",
		category: "Utilities",
		description: "throttle changing of a ref value",
		alias: [
			"useThrottle",
			"throttledRef"
		]
	},
	{
		name: "refWithControl",
		"package": "shared",
		lastUpdated: 1645956154000,
		docs: "https://vueuse.org/shared/refWithControl/",
		category: "Utilities",
		description: "fine-grained controls over ref and its reactivity",
		alias: [
			"controlledRef"
		],
		related: [
			"computedWithControl"
		]
	},
	{
		name: "resolveRef",
		"package": "shared",
		lastUpdated: 1657075685000,
		docs: "https://vueuse.org/shared/resolveRef/",
		category: "Utilities",
		description: "normalize value/ref/getter to `ref` or `computed`",
		related: [
			"resolveUnref"
		]
	},
	{
		name: "resolveUnref",
		"package": "shared",
		lastUpdated: 1657075685000,
		docs: "https://vueuse.org/shared/resolveUnref/",
		category: "Utilities",
		description: "get the value of value/ref/getter",
		related: [
			"resolveRef"
		]
	},
	{
		name: "set",
		"package": "shared",
		lastUpdated: 1642756441000,
		docs: "https://vueuse.org/shared/set/",
		category: "Utilities",
		description: "shorthand for `ref.value = x`"
	},
	{
		name: "syncRef",
		"package": "shared",
		lastUpdated: 1645952177000,
		docs: "https://vueuse.org/shared/syncRef/",
		category: "Utilities",
		description: "two-way refs synchronization",
		related: [
			"syncRefs"
		]
	},
	{
		name: "syncRefs",
		"package": "shared",
		lastUpdated: 1645952177000,
		docs: "https://vueuse.org/shared/syncRefs/",
		category: "Utilities",
		description: "keep target refs in sync with a source ref",
		related: [
			"syncRef"
		]
	},
	{
		name: "templateRef",
		"package": "core",
		lastUpdated: 1640933217000,
		docs: "https://vueuse.org/core/templateRef/",
		category: "Component",
		description: "shorthand for binding ref to template element"
	},
	{
		name: "toObserver",
		"package": "rxjs",
		lastUpdated: 1631130736000,
		docs: "https://vueuse.org/rxjs/toObserver/",
		category: "@RxJS",
		description: "sugar function to convert a ref in an observer"
	},
	{
		name: "toReactive",
		"package": "shared",
		lastUpdated: 1645878866000,
		docs: "https://vueuse.org/shared/toReactive/",
		category: "Utilities",
		description: "converts ref to reactive"
	},
	{
		name: "toRefs",
		"package": "shared",
		lastUpdated: 1655284952000,
		docs: "https://vueuse.org/shared/toRefs/",
		category: "Utilities",
		description: "extended [`toRefs`](https://v3.vuejs.org/api/refs-api.html#torefs) that also accepts refs of an object"
	},
	{
		name: "tryOnBeforeMount",
		"package": "shared",
		lastUpdated: 1655284952000,
		docs: "https://vueuse.org/shared/tryOnBeforeMount/",
		category: "Component",
		description: "safe `onBeforeMount`"
	},
	{
		name: "tryOnBeforeUnmount",
		"package": "shared",
		lastUpdated: 1639442454000,
		docs: "https://vueuse.org/shared/tryOnBeforeUnmount/",
		category: "Component",
		description: "safe `onBeforeUnmount`"
	},
	{
		name: "tryOnMounted",
		"package": "shared",
		lastUpdated: 1640933217000,
		docs: "https://vueuse.org/shared/tryOnMounted/",
		category: "Component",
		description: "safe `onMounted`"
	},
	{
		name: "tryOnScopeDispose",
		"package": "shared",
		lastUpdated: 1639442454000,
		docs: "https://vueuse.org/shared/tryOnScopeDispose/",
		category: "Component",
		description: "safe `onScopeDispose`"
	},
	{
		name: "tryOnUnmounted",
		"package": "shared",
		lastUpdated: 1640933217000,
		docs: "https://vueuse.org/shared/tryOnUnmounted/",
		category: "Component",
		description: "safe `onUnmounted`"
	},
	{
		name: "unrefElement",
		"package": "core",
		lastUpdated: 1655551027000,
		docs: "https://vueuse.org/core/unrefElement/",
		category: "Component",
		description: "unref for dom element"
	},
	{
		name: "until",
		"package": "shared",
		lastUpdated: 1655391355000,
		docs: "https://vueuse.org/shared/until/",
		category: "Watch",
		description: "promised one-time watch for changes"
	},
	{
		name: "useActiveElement",
		"package": "core",
		lastUpdated: 1639442454000,
		component: true,
		docs: "https://vueuse.org/core/useActiveElement/",
		category: "Elements",
		description: "reactive `document.activeElement`"
	},
	{
		name: "useAsyncQueue",
		"package": "core",
		lastUpdated: 1639818708000,
		docs: "https://vueuse.org/core/useAsyncQueue/",
		category: "Utilities",
		description: "executes each asynchronous task sequentially and passed the current task result to the next task"
	},
	{
		name: "useAsyncState",
		"package": "core",
		lastUpdated: 1650677704000,
		docs: "https://vueuse.org/core/useAsyncState/",
		category: "State",
		description: "reactive async state"
	},
	{
		name: "useAsyncValidator",
		"package": "integrations",
		lastUpdated: 1655449097000,
		component: true,
		docs: "https://vueuse.org/integrations/useAsyncValidator/",
		category: "@Integrations",
		description: "wrapper for [`async-validator`](https://github.com/yiminghe/async-validator)"
	},
	{
		name: "useAuth",
		"package": "firebase",
		lastUpdated: 1639442454000,
		docs: "https://vueuse.org/firebase/useAuth/",
		category: "@Firebase",
		description: "reactive [Firebase Auth](https://firebase.google.com/docs/auth) binding"
	},
	{
		name: "useAxios",
		"package": "integrations",
		lastUpdated: 1657076506000,
		docs: "https://vueuse.org/integrations/useAxios/",
		category: "@Integrations",
		description: "wrapper for [`axios`](https://github.com/axios/axios)"
	},
	{
		name: "useBase64",
		"package": "core",
		lastUpdated: 1657077425000,
		docs: "https://vueuse.org/core/useBase64/",
		category: "Utilities",
		description: "reactive base64 transforming"
	},
	{
		name: "useBattery",
		"package": "core",
		lastUpdated: 1639442454000,
		component: true,
		docs: "https://vueuse.org/core/useBattery/",
		category: "Sensors",
		description: "reactive [Battery Status API](https://developer.mozilla.org/en-US/docs/Web/API/Battery_Status_API)"
	},
	{
		name: "useBluetooth",
		"package": "core",
		lastUpdated: 1655394576000,
		docs: "https://vueuse.org/core/useBluetooth/",
		category: "Browser",
		description: "reactive [Web Bluetooth API](https://developer.mozilla.org/en-US/docs/Web/API/Web_Bluetooth_API)"
	},
	{
		name: "useBreakpoints",
		"package": "core",
		lastUpdated: 1645877163000,
		docs: "https://vueuse.org/core/useBreakpoints/",
		category: "Browser",
		description: "reactive viewport breakpoints"
	},
	{
		name: "useBroadcastChannel",
		"package": "core",
		lastUpdated: 1640932168000,
		docs: "https://vueuse.org/core/useBroadcastChannel/",
		category: "Browser",
		description: "reactive [BroadcastChannel API](https://developer.mozilla.org/en-US/docs/Web/API/BroadcastChannel)"
	},
	{
		name: "useBrowserLocation",
		"package": "core",
		lastUpdated: 1639442454000,
		component: true,
		docs: "https://vueuse.org/core/useBrowserLocation/",
		category: "Browser",
		description: "reactive browser location"
	},
	{
		name: "useCached",
		"package": "core",
		lastUpdated: 1644284136000,
		docs: "https://vueuse.org/core/useCached/",
		category: "Utilities",
		description: "cache a ref with a custom comparator"
	},
	{
		name: "useChangeCase",
		"package": "integrations",
		lastUpdated: 1646640858000,
		docs: "https://vueuse.org/integrations/useChangeCase/",
		category: "@Integrations",
		description: "wrapper for [`change-case`](https://github.com/blakeembrey/change-case)"
	},
	{
		name: "useClamp",
		"package": "core",
		lastUpdated: 1645872829000,
		docs: "https://vueuse.org/core/useClamp/",
		category: "Utilities",
		description: "reactively clamp a value between two other values"
	},
	{
		name: "useClipboard",
		"package": "core",
		lastUpdated: 1647220329000,
		docs: "https://vueuse.org/core/useClipboard/",
		category: "Browser",
		description: "reactive [Clipboard API](https://developer.mozilla.org/en-US/docs/Web/API/Clipboard_API)"
	},
	{
		name: "useColorMode",
		"package": "core",
		lastUpdated: 1657132668000,
		component: true,
		docs: "https://vueuse.org/core/useColorMode/",
		category: "Browser",
		description: "reactive color mode (dark / light / customs) with auto data persistence",
		related: [
			"useDark",
			"usePreferredDark",
			"useStorage"
		]
	},
	{
		name: "useConfirmDialog",
		"package": "core",
		lastUpdated: 1642756441000,
		docs: "https://vueuse.org/core/useConfirmDialog/",
		category: "Utilities",
		description: "creates event hooks to support modals and confirmation dialog chains"
	},
	{
		name: "useCookies",
		"package": "integrations",
		lastUpdated: 1642756753000,
		docs: "https://vueuse.org/integrations/useCookies/",
		category: "@Integrations",
		description: "wrapper for [`universal-cookie`](https://www.npmjs.com/package/universal-cookie)"
	},
	{
		name: "useCounter",
		"package": "shared",
		lastUpdated: 1637326497000,
		docs: "https://vueuse.org/shared/useCounter/",
		category: "Utilities",
		description: "basic counter with utility functions"
	},
	{
		name: "useCssVar",
		"package": "core",
		lastUpdated: 1657076529000,
		docs: "https://vueuse.org/core/useCssVar/",
		category: "Browser",
		description: "manipulate CSS variables"
	},
	{
		name: "useCurrentElement",
		"package": "core",
		lastUpdated: 1651308670000,
		docs: "https://vueuse.org/core/useCurrentElement/",
		category: "Component",
		description: "get the DOM element of current component as a ref"
	},
	{
		name: "useCycleList",
		"package": "core",
		lastUpdated: 1645016530000,
		docs: "https://vueuse.org/core/useCycleList/",
		category: "Utilities",
		description: "cycle through a list of items"
	},
	{
		name: "useDark",
		"package": "core",
		lastUpdated: 1639442454000,
		component: true,
		docs: "https://vueuse.org/core/useDark/",
		category: "Browser",
		description: "reactive dark mode with auto data persistence",
		related: [
			"useColorMode",
			"usePreferredDark",
			"useStorage"
		]
	},
	{
		name: "useDateFormat",
		"package": "shared",
		lastUpdated: 1651597361000,
		docs: "https://vueuse.org/shared/useDateFormat/",
		category: "Utilities",
		description: "get the formatted date according to the string of tokens passed in"
	},
	{
		name: "useDebouncedRefHistory",
		"package": "core",
		lastUpdated: 1639442454000,
		docs: "https://vueuse.org/core/useDebouncedRefHistory/",
		category: "State",
		description: "shorthand for `useRefHistory` with debounced filter",
		related: [
			"useRefHistory",
			"useThrottledRefHistory"
		]
	},
	{
		name: "useDebounceFn",
		"package": "shared",
		lastUpdated: 1639818708000,
		docs: "https://vueuse.org/shared/useDebounceFn/",
		category: "Utilities",
		description: "debounce execution of a function"
	},
	{
		name: "useDeviceMotion",
		"package": "core",
		lastUpdated: 1639442454000,
		component: true,
		docs: "https://vueuse.org/core/useDeviceMotion/",
		category: "Sensors",
		description: "reactive [DeviceMotionEvent](https://developer.mozilla.org/en-US/docs/Web/API/DeviceMotionEvent)"
	},
	{
		name: "useDeviceOrientation",
		"package": "core",
		lastUpdated: 1639442454000,
		component: true,
		docs: "https://vueuse.org/core/useDeviceOrientation/",
		category: "Sensors",
		description: "reactive [DeviceOrientationEvent](https://developer.mozilla.org/en-US/docs/Web/API/DeviceOrientationEvent)"
	},
	{
		name: "useDevicePixelRatio",
		"package": "core",
		lastUpdated: 1639442454000,
		component: true,
		docs: "https://vueuse.org/core/useDevicePixelRatio/",
		category: "Sensors",
		description: "reactively track [`window.devicePixelRatio`](https://developer.mozilla.org/ru/docs/Web/API/Window/devicePixelRatio)"
	},
	{
		name: "useDevicesList",
		"package": "core",
		lastUpdated: 1639442454000,
		component: true,
		docs: "https://vueuse.org/core/useDevicesList/",
		category: "Sensors",
		description: "reactive [enumerateDevices](https://developer.mozilla.org/en-US/docs/Web/API/MediaDevices/enumerateDevices) listing avaliable input/output devices"
	},
	{
		name: "useDisplayMedia",
		"package": "core",
		lastUpdated: 1649251191000,
		docs: "https://vueuse.org/core/useDisplayMedia/",
		category: "Sensors",
		description: "reactive [`mediaDevices.getDisplayMedia`](https://developer.mozilla.org/en-US/docs/Web/API/MediaDevices/getDisplayMedia) streaming",
		related: [
			"useUserMedia"
		]
	},
	{
		name: "useDocumentVisibility",
		"package": "core",
		lastUpdated: 1646168589000,
		component: true,
		docs: "https://vueuse.org/core/useDocumentVisibility/",
		category: "Elements",
		description: "reactively track [`document.visibilityState`](https://developer.mozilla.org/en-US/docs/Web/API/Document/visibilityState)"
	},
	{
		name: "useDraggable",
		"package": "core",
		lastUpdated: 1650371782000,
		component: true,
		docs: "https://vueuse.org/core/useDraggable/",
		category: "Elements",
		description: "make elements draggable"
	},
	{
		name: "useDrauu",
		"package": "integrations",
		lastUpdated: 1657076024000,
		docs: "https://vueuse.org/integrations/useDrauu/",
		category: "@Integrations",
		description: "reactive instance for [drauu](https://github.com/antfu/drauu)"
	},
	{
		name: "useDropZone",
		"package": "core",
		lastUpdated: 1654000449000,
		docs: "https://vueuse.org/core/useDropZone/",
		category: "Elements",
		description: "create an zone where files can be dropped"
	},
	{
		name: "useElementBounding",
		"package": "core",
		lastUpdated: 1651595186000,
		component: true,
		docs: "https://vueuse.org/core/useElementBounding/",
		category: "Elements",
		description: "reactive [bounding box](https://developer.mozilla.org/en-US/docs/Web/API/Element/getBoundingClientRect) of an HTML element"
	},
	{
		name: "useElementByPoint",
		"package": "core",
		lastUpdated: 1640682127000,
		docs: "https://vueuse.org/core/useElementByPoint/",
		category: "Sensors",
		description: "reactive element by point"
	},
	{
		name: "useElementHover",
		"package": "core",
		lastUpdated: 1639442454000,
		directive: true,
		docs: "https://vueuse.org/core/useElementHover/",
		category: "Sensors",
		description: "reactive element's hover state"
	},
	{
		name: "useElementSize",
		"package": "core",
		lastUpdated: 1644734119000,
		component: true,
		directive: true,
		docs: "https://vueuse.org/core/useElementSize/",
		category: "Elements",
		description: "reactive size of an HTML element"
	},
	{
		"package": "motion",
		category: "@Motion",
		name: "useElementStyle",
		description: "sync a reactive object to a target element CSS styling",
		external: "https://motion.vueuse.org/api/use-element-style.html"
	},
	{
		"package": "motion",
		category: "@Motion",
		name: "useElementTransform",
		description: "sync a reactive object to a target element CSS transform.",
		external: "https://motion.vueuse.org/api/use-element-transform.html"
	},
	{
		name: "useElementVisibility",
		"package": "core",
		lastUpdated: 1651597361000,
		component: true,
		directive: true,
		docs: "https://vueuse.org/core/useElementVisibility/",
		category: "Elements",
		description: "tracks the visibility of an element within the viewport"
	},
	{
		name: "useEventBus",
		"package": "core",
		lastUpdated: 1651597304000,
		docs: "https://vueuse.org/core/useEventBus/",
		category: "Utilities",
		description: "a basic event bus"
	},
	{
		name: "useEventListener",
		"package": "core",
		lastUpdated: 1647453655000,
		docs: "https://vueuse.org/core/useEventListener/",
		category: "Browser",
		description: "use EventListener with ease"
	},
	{
		name: "useEventSource",
		"package": "core",
		lastUpdated: 1639442454000,
		docs: "https://vueuse.org/core/useEventSource/",
		category: "Network",
		description: "an [EventSource](https://developer.mozilla.org/en-US/docs/Web/API/EventSource) or [Server-Sent-Events](https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events) instance opens a persistent connection to an HTTP server"
	},
	{
		name: "useEyeDropper",
		"package": "core",
		lastUpdated: 1637943423000,
		component: true,
		docs: "https://vueuse.org/core/useEyeDropper/",
		category: "Browser",
		description: "reactive [EyeDropper API](https://developer.mozilla.org/en-US/docs/Web/API/EyeDropper_API)"
	},
	{
		name: "useFavicon",
		"package": "core",
		lastUpdated: 1639818708000,
		docs: "https://vueuse.org/core/useFavicon/",
		category: "Browser",
		description: "reactive favicon"
	},
	{
		name: "useFetch",
		"package": "core",
		lastUpdated: 1655284505000,
		docs: "https://vueuse.org/core/useFetch/",
		category: "Network",
		description: "reactive [Fetch API](https://developer.mozilla.org/en-US/docs/Web/API/Fetch_API) provides the ability to abort requests"
	},
	{
		name: "useFileDialog",
		"package": "core",
		lastUpdated: 1657259710000,
		docs: "https://vueuse.org/core/useFileDialog/",
		category: "Browser",
		description: "open file dialog with ease"
	},
	{
		name: "useFileSystemAccess",
		"package": "core",
		lastUpdated: 1655530131000,
		docs: "https://vueuse.org/core/useFileSystemAccess/",
		category: "Browser",
		description: "create and read and write local files with [FileSystemAccessAPI](https://developer.mozilla.org/en-US/docs/Web/API/File_System_Access_API)"
	},
	{
		name: "useFirestore",
		"package": "firebase",
		lastUpdated: 1655284952000,
		docs: "https://vueuse.org/firebase/useFirestore/",
		category: "@Firebase",
		description: "reactive [Firestore](https://firebase.google.com/docs/firestore) binding"
	},
	{
		name: "useFocus",
		"package": "core",
		lastUpdated: 1652671318000,
		docs: "https://vueuse.org/core/useFocus/",
		category: "Sensors",
		description: "reactive utility to track or set the focus state of a DOM element"
	},
	{
		name: "useFocusTrap",
		"package": "integrations",
		lastUpdated: 1639818708000,
		component: true,
		docs: "https://vueuse.org/integrations/useFocusTrap/",
		category: "@Integrations",
		description: "reactive wrapper for [`focus-trap`](https://github.com/focus-trap/focus-trap)"
	},
	{
		name: "useFocusWithin",
		"package": "core",
		lastUpdated: 1639442454000,
		docs: "https://vueuse.org/core/useFocusWithin/",
		category: "Sensors",
		description: "reactive utility to track if an element or one of its decendants has focus"
	},
	{
		name: "useFps",
		"package": "core",
		lastUpdated: 1644734082000,
		docs: "https://vueuse.org/core/useFps/",
		category: "Sensors",
		description: "reactive FPS (frames per second)"
	},
	{
		name: "useFullscreen",
		"package": "core",
		lastUpdated: 1645877181000,
		component: true,
		docs: "https://vueuse.org/core/useFullscreen/",
		category: "Browser",
		description: "reactive [Fullscreen API](https://developer.mozilla.org/en-US/docs/Web/API/Fullscreen_API)"
	},
	{
		name: "useFuse",
		"package": "integrations",
		lastUpdated: 1642756441000,
		docs: "https://vueuse.org/integrations/useFuse/",
		category: "@Integrations",
		description: "easily implement fuzzy search using a composable with [Fuse.js](https://github.com/krisk/fuse)"
	},
	{
		name: "useGamepad",
		"package": "core",
		lastUpdated: 1651595032000,
		docs: "https://vueuse.org/core/useGamepad/",
		category: "Browser",
		description: "provides reactive bindings for the [Gamepad API](https://developer.mozilla.org/en-US/docs/Web/API/Gamepad_API)"
	},
	{
		name: "useGeolocation",
		"package": "core",
		lastUpdated: 1639442454000,
		component: true,
		docs: "https://vueuse.org/core/useGeolocation/",
		category: "Sensors",
		description: "reactive [Geolocation API](https://developer.mozilla.org/en-US/docs/Web/API/Geolocation_API)"
	},
	{
		name: "useHead",
		"package": "head",
		description: "update head meta tags reactively.",
		category: "@Head",
		external: "https://github.com/vueuse/head#api"
	},
	{
		name: "useIdle",
		"package": "core",
		lastUpdated: 1639442454000,
		component: true,
		docs: "https://vueuse.org/core/useIdle/",
		category: "Sensors",
		description: "tracks whether the user is being inactive"
	},
	{
		name: "useImage",
		"package": "core",
		lastUpdated: 1655391918000,
		component: true,
		docs: "https://vueuse.org/core/useImage/",
		category: "Browser",
		description: "reactive load an image in the browser"
	},
	{
		name: "useInfiniteScroll",
		"package": "core",
		lastUpdated: 1654001422000,
		directive: true,
		docs: "https://vueuse.org/core/useInfiniteScroll/",
		category: "Sensors",
		description: "infinite scrolling of the element"
	},
	{
		name: "useIntersectionObserver",
		"package": "core",
		lastUpdated: 1647220329000,
		directive: true,
		docs: "https://vueuse.org/core/useIntersectionObserver/",
		category: "Elements",
		description: "detects that a target element's visibility"
	},
	{
		name: "useInterval",
		"package": "shared",
		lastUpdated: 1644285131000,
		docs: "https://vueuse.org/shared/useInterval/",
		category: "Animation",
		description: "reactive counter increases on every interval"
	},
	{
		name: "useIntervalFn",
		"package": "shared",
		lastUpdated: 1655390255000,
		docs: "https://vueuse.org/shared/useIntervalFn/",
		category: "Animation",
		description: "wrapper for `setInterval` with controls"
	},
	{
		name: "useIpcRenderer",
		"package": "electron",
		lastUpdated: 1639442454000,
		docs: "https://vueuse.org/electron/useIpcRenderer/",
		category: "@Electron",
		description: "provides [ipcRenderer](https://www.electronjs.org/docs/api/ipc-renderer) and it's all APIs"
	},
	{
		name: "useIpcRendererInvoke",
		"package": "electron",
		lastUpdated: 1639442454000,
		docs: "https://vueuse.org/electron/useIpcRendererInvoke/",
		category: "@Electron",
		description: "reactive [ipcRenderer.invoke API](https://www.electronjs.org/docs/api/ipc-renderer#ipcrendererinvokechannel-args) result"
	},
	{
		name: "useIpcRendererOn",
		"package": "electron",
		lastUpdated: 1639442454000,
		docs: "https://vueuse.org/electron/useIpcRendererOn/",
		category: "@Electron",
		description: "use [ipcRenderer.on](https://www.electronjs.org/docs/api/ipc-renderer#ipcrendereronchannel-listener) with ease and [ipcRenderer.removeListener](https://www.electronjs.org/docs/api/ipc-renderer#ipcrendererremovelistenerchannel-listener) automatically on unmounted"
	},
	{
		name: "useJwt",
		"package": "integrations",
		lastUpdated: 1642756441000,
		docs: "https://vueuse.org/integrations/useJwt/",
		category: "@Integrations",
		description: "wrapper for [`jwt-decode`](https://github.com/auth0/jwt-decode)"
	},
	{
		name: "useKeyModifier",
		"package": "core",
		lastUpdated: 1648316929000,
		docs: "https://vueuse.org/core/useKeyModifier/",
		category: "Sensors",
		description: "reactive [Modifier State](https://developer.mozilla.org/en-US/docs/Web/API/KeyboardEvent/getModifierState)"
	},
	{
		name: "useLastChanged",
		"package": "shared",
		lastUpdated: 1642756441000,
		docs: "https://vueuse.org/shared/useLastChanged/",
		category: "Utilities",
		description: "records the timestamp of the last change"
	},
	{
		name: "useLocalStorage",
		"package": "core",
		lastUpdated: 1651597361000,
		docs: "https://vueuse.org/core/useLocalStorage/",
		category: "State",
		description: "reactive [LocalStorage](https://developer.mozilla.org/en-US/docs/Web/API/Window/localStorage)"
	},
	{
		name: "useMagicKeys",
		"package": "core",
		lastUpdated: 1657598054000,
		docs: "https://vueuse.org/core/useMagicKeys/",
		category: "Sensors",
		description: "reactive keys pressed state"
	},
	{
		name: "useManualRefHistory",
		"package": "core",
		lastUpdated: 1651597361000,
		docs: "https://vueuse.org/core/useManualRefHistory/",
		category: "State",
		description: "manually track the change history of a ref when the using calls `commit()`"
	},
	{
		name: "useMediaControls",
		"package": "core",
		lastUpdated: 1651597361000,
		docs: "https://vueuse.org/core/useMediaControls/",
		category: "Browser",
		description: "reactive media controls for both `audio` and `video` elements"
	},
	{
		name: "useMediaQuery",
		"package": "core",
		lastUpdated: 1657119939000,
		docs: "https://vueuse.org/core/useMediaQuery/",
		category: "Browser",
		description: "reactive [Media Query](https://developer.mozilla.org/en-US/docs/Web/CSS/Media_Queries/Testing_media_queries)"
	},
	{
		name: "useMemoize",
		"package": "core",
		lastUpdated: 1640929614000,
		docs: "https://vueuse.org/core/useMemoize/",
		category: "Utilities",
		description: "cache results of functions depending on arguments and keep it reactive"
	},
	{
		name: "useMemory",
		"package": "core",
		lastUpdated: 1644734082000,
		docs: "https://vueuse.org/core/useMemory/",
		category: "Browser",
		description: "reactive Memory Info"
	},
	{
		"package": "motion",
		category: "@Motion",
		name: "useMotion",
		description: "putting your components in motion.",
		external: "https://motion.vueuse.org/api/use-motion.html"
	},
	{
		"package": "motion",
		category: "@Motion",
		name: "useMotionProperties",
		description: "access Motion Properties for a target element.",
		external: "https://motion.vueuse.org/api/use-motion-properties.html"
	},
	{
		"package": "motion",
		category: "@Motion",
		name: "useMotionVariants",
		description: "handle the Variants state and selection.",
		external: "https://motion.vueuse.org/api/use-motion-variants.html"
	},
	{
		name: "useMounted",
		"package": "core",
		lastUpdated: 1640933217000,
		docs: "https://vueuse.org/core/useMounted/",
		category: "Component",
		description: "mounted state in ref"
	},
	{
		name: "useMouse",
		"package": "core",
		lastUpdated: 1644822501000,
		component: true,
		docs: "https://vueuse.org/core/useMouse/",
		category: "Sensors",
		description: "reactive mouse position"
	},
	{
		name: "useMouseInElement",
		"package": "core",
		lastUpdated: 1653249796000,
		component: true,
		docs: "https://vueuse.org/core/useMouseInElement/",
		category: "Elements",
		description: "reactive mouse position related to an element"
	},
	{
		name: "useMousePressed",
		"package": "core",
		lastUpdated: 1639818708000,
		component: true,
		docs: "https://vueuse.org/core/useMousePressed/",
		category: "Sensors",
		description: "reactive mouse pressing state"
	},
	{
		name: "useMutationObserver",
		"package": "core",
		lastUpdated: 1651595221000,
		docs: "https://vueuse.org/core/useMutationObserver/",
		category: "Elements",
		description: "watch for changes being made to the DOM tree"
	},
	{
		name: "useNavigatorLanguage",
		"package": "core",
		lastUpdated: 1639442454000,
		docs: "https://vueuse.org/core/useNavigatorLanguage/",
		category: "Sensors",
		description: "reactive [navigator.language](https://developer.mozilla.org/en-US/docs/Web/API/Navigator/language)"
	},
	{
		name: "useNetwork",
		"package": "core",
		lastUpdated: 1651595438000,
		component: true,
		docs: "https://vueuse.org/core/useNetwork/",
		category: "Sensors",
		description: "reactive [Network status](https://developer.mozilla.org/en-US/docs/Web/API/Network_Information_API)"
	},
	{
		name: "useNow",
		"package": "core",
		lastUpdated: 1639442454000,
		component: true,
		docs: "https://vueuse.org/core/useNow/",
		category: "Animation",
		description: "reactive current Date instance"
	},
	{
		name: "useNProgress",
		"package": "integrations",
		lastUpdated: 1651597361000,
		docs: "https://vueuse.org/integrations/useNProgress/",
		category: "@Integrations",
		description: "reactive wrapper for [`nprogress`](https://github.com/rstacruz/nprogress)"
	},
	{
		name: "useObjectUrl",
		"package": "core",
		lastUpdated: 1657132677000,
		component: true,
		docs: "https://vueuse.org/core/useObjectUrl/",
		category: "Browser",
		description: "reactive URL representing an object"
	},
	{
		name: "useObservable",
		"package": "rxjs",
		lastUpdated: 1651595539000,
		docs: "https://vueuse.org/rxjs/useObservable/",
		category: "@RxJS",
		description: "use an Observable"
	},
	{
		name: "useOffsetPagination",
		"package": "core",
		lastUpdated: 1651595032000,
		component: true,
		docs: "https://vueuse.org/core/useOffsetPagination/",
		category: "Utilities",
		description: "reactive offset pagination"
	},
	{
		name: "useOnline",
		"package": "core",
		lastUpdated: 1639442454000,
		component: true,
		docs: "https://vueuse.org/core/useOnline/",
		category: "Sensors",
		description: "reactive online state"
	},
	{
		name: "usePageLeave",
		"package": "core",
		lastUpdated: 1642756441000,
		component: true,
		docs: "https://vueuse.org/core/usePageLeave/",
		category: "Sensors",
		description: "reactive state to show whether the mouse leaves the page"
	},
	{
		name: "useParallax",
		"package": "core",
		lastUpdated: 1639442454000,
		docs: "https://vueuse.org/core/useParallax/",
		category: "Sensors",
		description: "create parallax effect easily"
	},
	{
		name: "usePermission",
		"package": "core",
		lastUpdated: 1651597361000,
		docs: "https://vueuse.org/core/usePermission/",
		category: "Browser",
		description: "reactive [Permissions API](https://developer.mozilla.org/en-US/docs/Web/API/Permissions_API)"
	},
	{
		name: "usePointer",
		"package": "core",
		lastUpdated: 1639442454000,
		component: true,
		docs: "https://vueuse.org/core/usePointer/",
		category: "Sensors",
		description: "reactive [pointer state](https://developer.mozilla.org/en-US/docs/Web/API/Pointer_events)"
	},
	{
		name: "usePointerSwipe",
		"package": "core",
		lastUpdated: 1639442454000,
		docs: "https://vueuse.org/core/usePointerSwipe/",
		category: "Sensors",
		description: "reactive swipe detection based on [PointerEvents](https://developer.mozilla.org/en-US/docs/Web/API/PointerEvent)"
	},
	{
		name: "usePreferredColorScheme",
		"package": "core",
		lastUpdated: 1639442454000,
		component: true,
		docs: "https://vueuse.org/core/usePreferredColorScheme/",
		category: "Browser",
		description: "reactive [prefers-color-scheme](https://developer.mozilla.org/en-US/docs/Web/CSS/@media/prefers-color-scheme) media query"
	},
	{
		name: "usePreferredDark",
		"package": "core",
		lastUpdated: 1639442454000,
		component: true,
		docs: "https://vueuse.org/core/usePreferredDark/",
		category: "Browser",
		description: "reactive dark theme preference",
		related: [
			"useColorMode",
			"useDark"
		]
	},
	{
		name: "usePreferredLanguages",
		"package": "core",
		lastUpdated: 1639442454000,
		component: true,
		docs: "https://vueuse.org/core/usePreferredLanguages/",
		category: "Browser",
		description: "reactive [Navigator Languages](https://developer.mozilla.org/en-US/docs/Web/API/NavigatorLanguage/languages)"
	},
	{
		name: "useQRCode",
		"package": "integrations",
		lastUpdated: 1651597361000,
		docs: "https://vueuse.org/integrations/useQRCode/",
		category: "@Integrations",
		description: "wrapper for [`qrcode`](https://github.com/soldair/node-qrcode)"
	},
	{
		name: "useRafFn",
		"package": "core",
		lastUpdated: 1650339134000,
		docs: "https://vueuse.org/core/useRafFn/",
		category: "Animation",
		description: "call function on every `requestAnimationFrame`"
	},
	{
		name: "useRefHistory",
		"package": "core",
		lastUpdated: 1646036662000,
		docs: "https://vueuse.org/core/useRefHistory/",
		category: "State",
		description: "track the change history of a ref",
		related: [
			"useDebouncedRefHistory"
		]
	},
	{
		name: "useResizeObserver",
		"package": "core",
		lastUpdated: 1655284952000,
		docs: "https://vueuse.org/core/useResizeObserver/",
		category: "Elements",
		description: "reports changes to the dimensions of an Element's content or the border-box"
	},
	{
		name: "useRouteHash",
		"package": "router",
		lastUpdated: 1639442454000,
		docs: "https://vueuse.org/router/useRouteHash/",
		category: "@Router",
		description: "shorthand for reactive route.hash"
	},
	{
		name: "useRouteParams",
		"package": "router",
		lastUpdated: 1657133143000,
		docs: "https://vueuse.org/router/useRouteParams/",
		category: "@Router",
		description: "shorthand for reactive route.params"
	},
	{
		name: "useRouteQuery",
		"package": "router",
		lastUpdated: 1649931974000,
		docs: "https://vueuse.org/router/useRouteQuery/",
		category: "@Router",
		description: "shorthand for reactive route.query"
	},
	{
		name: "useRTDB",
		"package": "firebase",
		lastUpdated: 1639442454000,
		docs: "https://vueuse.org/firebase/useRTDB/",
		category: "@Firebase",
		description: "reactive [Firebase Realtime Database](https://firebase.google.com/docs/database) binding"
	},
	{
		name: "useSchemaOrg",
		"package": "schema-org",
		description: "update schema.org reactively.",
		category: "@SchemaOrg",
		external: "https://vue-schema-org.netlify.app/api/core/use-schema-org.html"
	},
	{
		name: "useScreenOrientation",
		"package": "core",
		lastUpdated: 1651595705000,
		docs: "https://vueuse.org/core/useScreenOrientation/",
		category: "Browser",
		description: "reactive [Screen Orientation API](https://developer.mozilla.org/en-US/docs/Web/API/Screen_Orientation_API)"
	},
	{
		name: "useScreenSafeArea",
		"package": "core",
		lastUpdated: 1640682127000,
		component: true,
		docs: "https://vueuse.org/core/useScreenSafeArea/",
		category: "Browser",
		description: "reactive `env(safe-area-inset-*)`"
	},
	{
		name: "useScriptTag",
		"package": "core",
		lastUpdated: 1651597361000,
		docs: "https://vueuse.org/core/useScriptTag/",
		category: "Browser",
		description: "script tag injecting"
	},
	{
		name: "useScroll",
		"package": "core",
		lastUpdated: 1655390158000,
		directive: true,
		docs: "https://vueuse.org/core/useScroll/",
		category: "Sensors",
		description: "reactive scroll position and state"
	},
	{
		name: "useScrollLock",
		"package": "core",
		lastUpdated: 1652227755000,
		directive: true,
		docs: "https://vueuse.org/core/useScrollLock/",
		category: "Sensors",
		description: "lock scrolling of the element"
	},
	{
		name: "useSessionStorage",
		"package": "core",
		lastUpdated: 1651597361000,
		docs: "https://vueuse.org/core/useSessionStorage/",
		category: "State",
		description: "reactive [SessionStorage](https://developer.mozilla.org/en-US/docs/Web/API/Window/sessionStorage)"
	},
	{
		name: "useShare",
		"package": "core",
		lastUpdated: 1651597361000,
		docs: "https://vueuse.org/core/useShare/",
		category: "Browser",
		description: "reactive [Web Share API](https://developer.mozilla.org/en-US/docs/Web/API/Navigator/share)"
	},
	{
		name: "useSound",
		"package": "sound",
		description: "play sound effects reactively.",
		category: "@Sound",
		external: "https://github.com/vueuse/sound#examples"
	},
	{
		name: "useSpeechRecognition",
		"package": "core",
		lastUpdated: 1639818708000,
		docs: "https://vueuse.org/core/useSpeechRecognition/",
		category: "Sensors",
		description: "reactive [SpeechRecognition](https://developer.mozilla.org/en-US/docs/Web/API/SpeechRecognition)"
	},
	{
		name: "useSpeechSynthesis",
		"package": "core",
		lastUpdated: 1639818708000,
		docs: "https://vueuse.org/core/useSpeechSynthesis/",
		category: "Sensors",
		description: "reactive [SpeechSynthesis](https://developer.mozilla.org/en-US/docs/Web/API/SpeechSynthesis)"
	},
	{
		"package": "motion",
		category: "@Motion",
		name: "useSpring",
		description: "spring animations.",
		external: "https://motion.vueuse.org/api/use-spring.html"
	},
	{
		name: "useStepper",
		"package": "core",
		lastUpdated: 1657132687000,
		docs: "https://vueuse.org/core/useStepper/",
		category: "Utilities",
		description: "provides helpers for building a multi-step wizard interface"
	},
	{
		name: "useStorage",
		"package": "core",
		lastUpdated: 1651597361000,
		docs: "https://vueuse.org/core/useStorage/",
		category: "State",
		description: "reactive [LocalStorage](https://developer.mozilla.org/en-US/docs/Web/API/Window/localStorage)/[SessionStorage](https://developer.mozilla.org/en-US/docs/Web/API/Window/sessionStorage)",
		related: [
			"useColorMode",
			"useDark"
		]
	},
	{
		name: "useStorageAsync",
		"package": "core",
		lastUpdated: 1651597361000,
		docs: "https://vueuse.org/core/useStorageAsync/",
		category: "State",
		description: "reactive Storage in with async support"
	},
	{
		name: "useStyleTag",
		"package": "core",
		lastUpdated: 1643124348000,
		docs: "https://vueuse.org/core/useStyleTag/",
		category: "Browser",
		description: "inject reactive `style` element in head"
	},
	{
		name: "useSubject",
		"package": "rxjs",
		lastUpdated: 1651595539000,
		docs: "https://vueuse.org/rxjs/useSubject/",
		category: "@RxJS",
		description: "bind Subject to ref and propagate value changes both ways"
	},
	{
		name: "useSubscription",
		"package": "rxjs",
		lastUpdated: 1628521945000,
		docs: "https://vueuse.org/rxjs/useSubscription/",
		category: "@RxJS",
		description: "uses subscriptions without worry about unsubscribing to it or memory leaks"
	},
	{
		name: "useSwipe",
		"package": "core",
		lastUpdated: 1639442454000,
		docs: "https://vueuse.org/core/useSwipe/",
		category: "Sensors",
		description: "reactive swipe detection based on [`TouchEvents`](https://developer.mozilla.org/en-US/docs/Web/API/TouchEvent)"
	},
	{
		name: "useTemplateRefsList",
		"package": "core",
		lastUpdated: 1639442454000,
		docs: "https://vueuse.org/core/useTemplateRefsList/",
		category: "Component",
		description: "shorthand for binding refs to template elements and components inside `v-for`"
	},
	{
		name: "useTextareaAutosize",
		"package": "core",
		lastUpdated: 1657132700000,
		docs: "https://vueuse.org/core/useTextareaAutosize/",
		category: "Browser",
		description: "automatically update the height of a textarea depending on the content"
	},
	{
		name: "useTextSelection",
		"package": "core",
		lastUpdated: 1646469737000,
		docs: "https://vueuse.org/core/useTextSelection/",
		category: "Sensors",
		description: "reactively track user text selection based on [`Window.getSelection`](https://developer.mozilla.org/en-US/docs/Web/API/Window/getSelection)"
	},
	{
		name: "useThrottledRefHistory",
		"package": "core",
		lastUpdated: 1639442454000,
		docs: "https://vueuse.org/core/useThrottledRefHistory/",
		category: "State",
		description: "shorthand for `useRefHistory` with throttled filter",
		related: [
			"useDebouncedRefHistory"
		]
	},
	{
		name: "useThrottleFn",
		"package": "shared",
		lastUpdated: 1639442454000,
		docs: "https://vueuse.org/shared/useThrottleFn/",
		category: "Utilities",
		description: "throttle execution of a function"
	},
	{
		name: "useTimeAgo",
		"package": "core",
		lastUpdated: 1639442454000,
		component: true,
		docs: "https://vueuse.org/core/useTimeAgo/",
		category: "Misc",
		description: "reactive time ago"
	},
	{
		name: "useTimeout",
		"package": "shared",
		lastUpdated: 1639442454000,
		docs: "https://vueuse.org/shared/useTimeout/",
		category: "Animation",
		description: "update value after a given time with controls"
	},
	{
		name: "useTimeoutFn",
		"package": "shared",
		lastUpdated: 1655284952000,
		docs: "https://vueuse.org/shared/useTimeoutFn/",
		category: "Animation",
		description: "wrapper for `setTimeout` with controls"
	},
	{
		name: "useTimeoutPoll",
		"package": "core",
		lastUpdated: 1646467705000,
		docs: "https://vueuse.org/core/useTimeoutPoll/",
		category: "Utilities",
		description: "use timeout to poll something"
	},
	{
		name: "useTimestamp",
		"package": "core",
		lastUpdated: 1639442454000,
		component: true,
		docs: "https://vueuse.org/core/useTimestamp/",
		category: "Animation",
		description: "reactive current timestamp"
	},
	{
		name: "useTitle",
		"package": "core",
		lastUpdated: 1640175570000,
		docs: "https://vueuse.org/core/useTitle/",
		category: "Browser",
		description: "reactive document title"
	},
	{
		name: "useToggle",
		"package": "shared",
		lastUpdated: 1651595513000,
		docs: "https://vueuse.org/shared/useToggle/",
		category: "Utilities",
		description: "a boolean switcher with utility functions"
	},
	{
		name: "useTransition",
		"package": "core",
		lastUpdated: 1649251191000,
		docs: "https://vueuse.org/core/useTransition/",
		category: "Animation",
		description: "transition between values"
	},
	{
		name: "useUrlSearchParams",
		"package": "core",
		lastUpdated: 1655390581000,
		docs: "https://vueuse.org/core/useUrlSearchParams/",
		category: "Browser",
		description: "reactive [URLSearchParams](https://developer.mozilla.org/en-US/docs/Web/API/URLSearchParams)"
	},
	{
		name: "useUserMedia",
		"package": "core",
		lastUpdated: 1639818708000,
		docs: "https://vueuse.org/core/useUserMedia/",
		category: "Sensors",
		description: "reactive [`mediaDevices.getUserMedia`](https://developer.mozilla.org/en-US/docs/Web/API/MediaDevices/getUserMedia) streaming",
		related: [
			"useDisplayMedia"
		]
	},
	{
		name: "useVibrate",
		"package": "core",
		lastUpdated: 1640932230000,
		docs: "https://vueuse.org/core/useVibrate/",
		category: "Browser",
		description: "reactive [Vibration API](https://developer.mozilla.org/en-US/docs/Web/API/Vibration_API)"
	},
	{
		name: "useVirtualList",
		"package": "core",
		lastUpdated: 1642756441000,
		component: true,
		docs: "https://vueuse.org/core/useVirtualList/",
		category: "Component",
		description: "create virtual lists with ease"
	},
	{
		name: "useVModel",
		"package": "core",
		lastUpdated: 1657431438000,
		docs: "https://vueuse.org/core/useVModel/",
		category: "Component",
		description: "shorthand for v-model binding"
	},
	{
		name: "useVModels",
		"package": "core",
		lastUpdated: 1655284952000,
		docs: "https://vueuse.org/core/useVModels/",
		category: "Component",
		description: "shorthand for props v-model binding"
	},
	{
		name: "useWakeLock",
		"package": "core",
		lastUpdated: 1649251191000,
		docs: "https://vueuse.org/core/useWakeLock/",
		category: "Browser",
		description: "reactive [Screen Wake Lock API](https://developer.mozilla.org/en-US/docs/Web/API/Screen_Wake_Lock_API)"
	},
	{
		name: "useWebNotification",
		"package": "core",
		lastUpdated: 1651597361000,
		docs: "https://vueuse.org/core/useWebNotification/",
		category: "Browser",
		description: "reactive [Notification](https://developer.mozilla.org/en-US/docs/Web/API/notification)"
	},
	{
		name: "useWebSocket",
		"package": "core",
		lastUpdated: 1649251191000,
		docs: "https://vueuse.org/core/useWebSocket/",
		category: "Network",
		description: "reactive [WebSocket](https://developer.mozilla.org/en-US/docs/Web/API/WebSocket/WebSocket) client"
	},
	{
		name: "useWebWorker",
		"package": "core",
		lastUpdated: 1647220329000,
		docs: "https://vueuse.org/core/useWebWorker/",
		category: "Misc",
		description: "simple [Web Workers](https://developer.mozilla.org/en-US/docs/Web/API/Web_Workers_API/Using_web_workers) registration and communication"
	},
	{
		name: "useWebWorkerFn",
		"package": "core",
		lastUpdated: 1655284952000,
		docs: "https://vueuse.org/core/useWebWorkerFn/",
		category: "Misc",
		description: "run expensive functions without blocking the UI"
	},
	{
		name: "useWindowFocus",
		"package": "core",
		lastUpdated: 1639442454000,
		component: true,
		docs: "https://vueuse.org/core/useWindowFocus/",
		category: "Elements",
		description: "reactively track window focus with `window.onfocus` and `window.onblur` events"
	},
	{
		name: "useWindowScroll",
		"package": "core",
		lastUpdated: 1639442454000,
		docs: "https://vueuse.org/core/useWindowScroll/",
		category: "Elements",
		description: "reactive window scroll"
	},
	{
		name: "useWindowSize",
		"package": "core",
		lastUpdated: 1657078594000,
		component: true,
		docs: "https://vueuse.org/core/useWindowSize/",
		category: "Elements",
		description: "reactive window size"
	},
	{
		name: "useZoomFactor",
		"package": "electron",
		lastUpdated: 1639442454000,
		docs: "https://vueuse.org/electron/useZoomFactor/",
		category: "@Electron",
		description: "reactive [WebFrame](https://www.electronjs.org/docs/api/web-frame#webframe) zoom factor"
	},
	{
		name: "useZoomLevel",
		"package": "electron",
		lastUpdated: 1639442454000,
		docs: "https://vueuse.org/electron/useZoomLevel/",
		category: "@Electron",
		description: "reactive [WebFrame](https://www.electronjs.org/docs/api/web-frame#webframe) zoom level"
	},
	{
		name: "utils",
		"package": "shared",
		lastUpdated: 1652598461000,
		internal: true
	},
	{
		name: "watchArray",
		"package": "shared",
		lastUpdated: 1657133473000,
		docs: "https://vueuse.org/shared/watchArray/",
		category: "Watch",
		description: "watch for an array with additions and removals"
	},
	{
		name: "watchAtMost",
		"package": "shared",
		lastUpdated: 1655390134000,
		docs: "https://vueuse.org/shared/watchAtMost/",
		category: "Watch",
		description: "`watch` with the number of times triggered"
	},
	{
		name: "watchDebounced",
		"package": "shared",
		lastUpdated: 1655390134000,
		docs: "https://vueuse.org/shared/watchDebounced/",
		category: "Watch",
		description: "debounced watch",
		alias: [
			"debouncedWatch"
		]
	},
	{
		name: "watchIgnorable",
		"package": "shared",
		lastUpdated: 1655390134000,
		docs: "https://vueuse.org/shared/watchIgnorable/",
		category: "Watch",
		description: "ignorable watch",
		alias: [
			"ignorableWatch"
		]
	},
	{
		name: "watchOnce",
		"package": "shared",
		lastUpdated: 1655390134000,
		docs: "https://vueuse.org/shared/watchOnce/",
		category: "Watch",
		description: "`watch` that only triggers once"
	},
	{
		name: "watchPausable",
		"package": "shared",
		lastUpdated: 1655390134000,
		docs: "https://vueuse.org/shared/watchPausable/",
		category: "Watch",
		description: "pausable watch",
		alias: [
			"pausableWatch"
		]
	},
	{
		name: "watchThrottled",
		"package": "shared",
		lastUpdated: 1655390134000,
		docs: "https://vueuse.org/shared/watchThrottled/",
		category: "Watch",
		description: "throttled watch",
		alias: [
			"throttledWatch"
		]
	},
	{
		name: "watchTriggerable",
		"package": "shared",
		lastUpdated: 1657077213000,
		docs: "https://vueuse.org/shared/watchTriggerable/",
		category: "Watch",
		description: "watch that can be triggered manually"
	},
	{
		name: "watchWithFilter",
		"package": "shared",
		lastUpdated: 1655390134000,
		docs: "https://vueuse.org/shared/watchWithFilter/",
		category: "Watch",
		description: "`watch` with additional EventFilter control"
	},
	{
		name: "whenever",
		"package": "shared",
		lastUpdated: 1649251191000,
		docs: "https://vueuse.org/shared/whenever/",
		category: "Watch",
		description: "shorthand for watching value to be truthy"
	}
];
var _metadata = {
	packages: packages$1,
	categories: categories$1,
	functions: functions$1
};

const categoriesOrder = [
  "Browser",
  "Sensors",
  "Animation",
  "State",
  "Elements",
  "Component",
  "Watch",
  "Network",
  "Utilities",
  "Misc"
];
const metadata = _metadata;
const functions = functions$1;
const packages = packages$1;
const categories = categories$1;
const functionNames = functions.map((f) => f.name);
const categoryNames = Array.from(categories).sort((a, b) => categoriesOrder.indexOf(a) - categoriesOrder.indexOf(b)).sort((a, b) => a.startsWith("@") ? 1 : b.startsWith("@") ? -1 : 0);
const coreCategoryNames = categoryNames.filter((f) => !f.startsWith("@"));
const addonCategoryNames = categoryNames.filter((f) => f.startsWith("@"));
const getFunction = (name) => metadata.functions.find((f) => f.name === name);

function getCategories(functions) {
  return uniq(functions.filter((i) => !i.internal).map((i) => i.category).filter(Boolean)).sort((a, b) => a.startsWith("@") && !b.startsWith("@") ? 1 : b.startsWith("@") && !a.startsWith("@") ? -1 : a.localeCompare(b));
}
function uniq(a) {
  return Array.from(new Set(a));
}

exports.addonCategoryNames = addonCategoryNames;
exports.categories = categories;
exports.categoryNames = categoryNames;
exports.coreCategoryNames = coreCategoryNames;
exports.functionNames = functionNames;
exports.functions = functions;
exports.getCategories = getCategories;
exports.getFunction = getFunction;
exports.metadata = metadata;
exports.packages = packages;
exports.uniq = uniq;
