import test from 'ava'
import store from './helpers/index.cjs.js'

test('hooks', async t => {
  const modulePath = 'user/'
  const prop = 'wallet'
  const path = modulePath + prop
  let res
  t.deepEqual(store.get(path), [])
  res = await store.set(path, 1)
  t.is(res, '1!')
})

test('setters', t => {
  const path = 'locationJournal/gymData/defeated.palletTown'
  const a = store.get(path)
  store.set(path, 1)
  const b = store.get(path)
  t.is(b, 1)
  store.dispatch('locationJournal/gymData/set/defeated.palletTown', 2)
  const c = store.get(path)
  t.is(c, 2)
  store.commit(path, 3)
  const d = store.get(path)
  t.is(d, 3)
  t.is(store.state.locationJournal.gymData.defeated.palletTown, 3)
})

test('delete props', t => {
  let target
  // commit
  target = store.get('propToBeDeleted_commit')
  t.is(target, true)
  t.is(store.state.propToBeDeleted_commit, true)
  store.commit('-propToBeDeleted_commit')
  t.is(store.state.propToBeDeleted_commit, undefined)

  // dispatch
  target = store.get('propToBeDeleted_dispatch')
  t.is(target, true)
  t.is(store.state.propToBeDeleted_dispatch, true)
  store.dispatch('delete/propToBeDeleted_dispatch')
  t.is(store.state.propToBeDeleted_dispatch, undefined)

  // delete()
  target = store.get('propToBeDeleted_delete')
  t.is(target, true)
  t.is(store.state.propToBeDeleted_delete, true)
  store.delete('propToBeDeleted_delete')
  t.is(store.state.propToBeDeleted_delete, undefined)

  // submodules
  target = store.get('dex/propToBeDeleted')
  t.is(target, true)
  t.is(store.state.dex.propToBeDeleted, true)
  store.delete('dex/propToBeDeleted')
  t.is(store.state.dex.propToBeDeleted, undefined)
})

test('arraySetters', t => {
  const box = store.state.pokemonBox.waterPokemon
  // box starts as ['squirtle']
  t.deepEqual(box, ['squirtle'])

  // MUTATIONS
  // push
  store.commit('pokemonBox.waterPokemon.push', 'charmander')
  t.deepEqual(box, ['squirtle', 'charmander'])
  // pop
  store.commit('pokemonBox.waterPokemon.pop')
  t.deepEqual(box, ['squirtle'])
  // shift
  store.commit('pokemonBox.waterPokemon.shift')
  t.deepEqual(box, [])
  // splice
  store.commit('pokemonBox.waterPokemon.push', 'warturtle')
  store.commit('pokemonBox.waterPokemon.splice', [0, 0, 'blastoise'])
  t.deepEqual(box, ['blastoise', 'warturtle'])

  // ACTIONS
  // push
  store.dispatch('set/pokemonBox.waterPokemon.push', 'psyduck')
  store.dispatch('set/pokemonBox.waterPokemon.push', 'starmie')
  t.deepEqual(box, ['blastoise', 'warturtle', 'psyduck', 'starmie'])
  // splice
  store.dispatch('set/pokemonBox.waterPokemon.splice', [1, 1, 'poliwag'])
  t.deepEqual(box, ['blastoise', 'poliwag', 'psyduck', 'starmie'])
  // shift and pop
  store.dispatch('set/pokemonBox.waterPokemon.shift')
  store.dispatch('set/pokemonBox.waterPokemon.pop')
  t.deepEqual(box, ['poliwag', 'psyduck'])

  // SET()
  // push
  store.set('pokemonBox.waterPokemon.push', 'charmander')
  t.deepEqual(box, ['poliwag', 'psyduck', 'charmander'])
  // pop
  store.set('pokemonBox.waterPokemon.pop')
  t.deepEqual(box, ['poliwag', 'psyduck'])
  // shift
  store.set('pokemonBox.waterPokemon.shift')
  t.deepEqual(box, ['psyduck'])
  // splice
  store.set('pokemonBox.waterPokemon.push', 'warturtle')
  t.deepEqual(box, ['psyduck', 'warturtle'])
  store.set('pokemonBox.waterPokemon.splice', [0, 0, 'blastoise'])
  t.deepEqual(box, ['blastoise', 'psyduck', 'warturtle'])

  // SUB MODULES
  store.dispatch('dex/set/pokemonById.*', {'151': {name: 'mew', powerUps: []}})
  t.is(store.state.dex.pokemonById['151'].name, 'mew')
  t.deepEqual(store.state.dex.pokemonById['151'].powerUps, [])
  store.dispatch('dex/set/pokemonById.*.powerUps.push', ['151', 'pw1'])
  t.deepEqual(store.state.dex.pokemonById['151'].powerUps, ['pw1'])
})

test('Wildcard setters 1 (generated by \'*\')', t => {
  const _celurean = {id: 'celurean city', visited: true, gym: true}
  const _1 = {id: '1', visited: false, gym: true}
  const _2 = {id: '2', visited: true, gym: false}
  const _3 = {id: '3', visited: false, gym: false}
  const _4 = {id: '4', gym: true}
  const _5 = {id: '5', visited: true}
  const _6 = {id: '6'}
  const _7 = {id: '7', visited: true, gym: true}
  const _8 = {id: '8', visited: true, gym: true}
  const _9 = {id: '9', visited: true, gym: true}
  const _10 = {id: '10', visited: true, gym: true}
  const _11 = {id: '11', visited: true, gym: true}
  let places = store.state.locationJournal.visitedPlaces
  const initialLength = Object.keys(places).length
  t.is(Object.keys(places).length, 0 + initialLength)

  // add
  store.commit('locationJournal/visitedPlaces.*', _celurean)
  store.dispatch('locationJournal/set/visitedPlaces.*', _4)
  store.set('locationJournal/visitedPlaces.*', _6)
  t.is(Object.keys(places).length, 3 + initialLength)
  t.truthy(places[_celurean.id])
  t.is(places[_celurean.id].gym, _celurean.gym)
  t.truthy(places[_4.id])
  t.is(places[_4.id].gym, _4.gym)
  t.truthy(places[_6.id])
  t.true(places[_6.id].gym !== undefined)
  t.true(places[_6.id].visited !== undefined)

  // set sub props
  store.set('locationJournal/visitedPlaces.*', _1)
  t.is(Object.keys(places).length, 4 + initialLength)
  // sub props: commit
  t.truthy(places[_1.id])
  t.is(places[_1.id].visited, _1.visited)
  t.is(places[_1.id].gym, _1.gym)
  const bef = Object.keys(places[_1.id])
  store.commit('locationJournal/visitedPlaces.*', {[_1.id]: {visited: 'booyah!'}})
  store.commit('locationJournal/visitedPlaces.*.gym', [_1.id, 'booyah!'])
  t.is(bef.length, Object.keys(places[_1.id]).length)
  t.is(places[_1.id].visited, 'booyah!')
  t.is(places[_1.id].gym, 'booyah!')
  // sub props: dispatch
  t.is(places[_4.id].visited, false)
  t.is(places[_4.id].gym, true)
  store.dispatch('locationJournal/set/visitedPlaces.*', {id: _4.id, visited: 'booyah!'})
  store.dispatch('locationJournal/set/visitedPlaces.*.gym', [_4.id, 'booyah!'])
  t.is(places[_4.id].visited, 'booyah!')
  t.is(places[_4.id].gym, 'booyah!')
  // sub props: set
  store.set('locationJournal/visitedPlaces.*', {id: _6.id, visited: 'booyah!'})
  store.set('locationJournal/visitedPlaces.*.gym', [_6.id, 'booyah!'])
  t.is(places[_6.id].visited, 'booyah!')
  t.is(places[_6.id].gym, 'booyah!')

  // Set props not part of the item
  // store.commit('locationJournal/visitedPlaces.*.new', {id: _1.id, val: 'new prop'})
  // store.dispatch('locationJournal/set/visitedPlaces.*.new', {id: _4.id, val: 'new prop'})
  // store.set('locationJournal/visitedPlaces.*.new', {id: _6.id, val: 'new prop'})
  // t.is(places[_1.id].new, 'new prop')
  // t.is(places[_4.id].new, 'new prop')
  // t.is(places[_6.id].new, 'new prop')

  // sub props: with spaces in id
  store.commit('locationJournal/visitedPlaces.*', {id: _celurean.id, visited: 'booyah!'})
  store.commit('locationJournal/visitedPlaces.*.gym', [_celurean.id, 'booyah!'])
  t.is(places[_celurean.id].visited, 'booyah!')
  t.is(places[_celurean.id].gym, 'booyah!')

  // delete
  store.delete('locationJournal/visitedPlaces.*', _celurean.id)
  store.commit('locationJournal/-visitedPlaces.*', _6.id)
  store.dispatch('locationJournal/delete/visitedPlaces.*', _1.id)
  t.is(Object.keys(places).length, 1 + initialLength)
})

test('Wildcard setters 2 (generated by \'*\')', t => {
  // Add items
  store.set('dex/pokemonById.*', {id: '001', name: 'bulbasaur'})
  store.commit('dex/pokemonById.*', {id: '004', name: 'charmander'})
  store.dispatch('dex/set/pokemonById.*', {id: '007', name: 'squirtle'})
  // add some more to test deletions
  store.set('dex/pokemonById.*', {id: '002', name: 'ivysaur'})
  store.set('dex/pokemonById.*', {id: '003', name: 'venusaur'})
  store.set('dex/pokemonById.*', {id: '005', name: 'charmeleon'})
  store.set('dex/pokemonById.*', {id: '006', name: 'charizard'})
  store.set('dex/pokemonById.*', {id: '008', name: 'warturtle'})
  store.set('dex/pokemonById.*', {id: '009', name: 'blastoise'})
  // check amount
  let dex = store.state.dex.pokemonById

  // make deletions
  // store.delete('dex/pokemonById', '002') // now ONLY * syntax allowed
  // t.falsy(dex['002'])
  store.delete('dex/pokemonById.*', '003')
  t.falsy(dex['003'])
  // store.commit('dex/-pokemonById', '005') // now ONLY * syntax allowed
  // t.falsy(dex['005'])
  store.commit('dex/-pokemonById.*', '006')
  t.falsy(dex['006'])
  // store.dispatch('dex/delete/pokemonById', '008') // now ONLY * syntax allowed
  // t.falsy(dex['008'])
  store.dispatch('dex/delete/pokemonById.*', '009')
  t.falsy(dex['009'])
  dex = store.state.dex.pokemonById

  // check if additions are still there
  t.truthy(dex['001'])
  t.truthy(dex['004'])
  t.truthy(dex['007'])
  t.is(dex['001'].name, 'bulbasaur')
  t.is(dex['004'].name, 'charmander')
  t.is(dex['007'].name, 'squirtle')
})

test('Wildcard setters 3 (double wildcards)', t => {
  const _027 = {id: '027', name: 'Sandshrew'}
  const _043 = {id: '043', name: 'Oddish'}
  const _077 = {id: '_077_', name: 'Ponyta'}
  store.set('dex/pokemonById.*', _027)
  store.set('dex/pokemonById.*', {[_043.id]: _043})
  store.set('dex/pokemonById.*', _077)
  const dex = store.state.dex.pokemonById
  t.is(dex[_027.id].name, 'Sandshrew')
  t.is(dex[_043.id].name, 'Oddish')
  t.is(dex[_077.id].name, 'Ponyta')
  store.set('dex/pokemonById.*.tags.*', [_027.id, {'ground': true}])
  store.set('dex/pokemonById.*.tags.*', [_043.id, {'grass': true}])
  store.set('dex/pokemonById.*.tags.*', [_077.id, {'fire': true}])
  // store.set(`dex/pokemonById._007_.tags.*`, {fire: true})
  const id = 'dark'
  store.set('dex/pokemonById.*.tags.*', [_027.id, {[id]: true}])
  store.set('dex/pokemonById.*.tags.*', [_043.id, {[id]: true}])
  store.set('dex/pokemonById.*.tags.*', [_077.id, {[id]: true}])
  t.truthy(dex[_027.id].tags['dark'])
  t.truthy(dex[_043.id].tags['dark'])
  t.truthy(dex[_077.id].tags['dark'])
  t.is(dex[_027.id].tags['dark'], true)
  t.is(dex[_043.id].tags['dark'], true)
  t.is(dex[_077.id].tags['dark'], true)
  // deletes
  store.delete('dex/pokemonById.*.tags.*', [_027.id, 'dark'])
  store.dispatch('dex/delete/pokemonById.*.tags.*', [_043.id, 'dark'])
  store.commit('dex/-pokemonById.*.tags.*', [_077.id, 'dark'])
  t.is(dex[_027.id].name, 'Sandshrew')
  t.is(dex[_043.id].name, 'Oddish')
  t.is(dex[_077.id].name, 'Ponyta')
  t.truthy(dex[_027.id].tags['ground'])
  t.truthy(dex[_043.id].tags['grass'])
  t.truthy(dex[_077.id].tags['fire'])
  t.is(dex[_027.id].tags['ground'], true)
  t.is(dex[_043.id].tags['grass'], true)
  t.is(dex[_077.id].tags['fire'], true)
  t.falsy(dex[_027.id].tags['dark'])
  t.falsy(dex[_043.id].tags['dark'])
  t.falsy(dex[_077.id].tags['dark'])

  // push pop shift splice mutations
  store.commit('dex/pokemonById.*.powerUps.push', [_027.id, 'str1'])
  store.commit('dex/pokemonById.*.powerUps.push', [_027.id, 'res1'])
  t.deepEqual(dex[_027.id].powerUps, ['str1', 'res1'])
  store.commit('dex/pokemonById.*.powerUps.pop', _027.id)
  t.deepEqual(dex[_027.id].powerUps, ['str1'])
  store.commit('dex/pokemonById.*.powerUps.push', [_027.id, 'str2'])
  t.deepEqual(dex[_027.id].powerUps, ['str1', 'str2'])
  store.commit('dex/pokemonById.*.powerUps.shift', _027.id)
  t.deepEqual(dex[_027.id].powerUps, ['str2'])
  store.commit('dex/pokemonById.*.powerUps.splice', [_027.id, [0, 0, 'res3']])
  t.deepEqual(dex[_027.id].powerUps, ['res3', 'str2'])

  // push pop shift splice actions
  store.dispatch('dex/set/pokemonById.*.powerUps.push', [_027.id, 'def1'])
  t.deepEqual(dex[_027.id].powerUps, ['res3', 'str2', 'def1'])
  store.dispatch('dex/set/pokemonById.*.powerUps.pop', _027.id)
  t.deepEqual(dex[_027.id].powerUps, ['res3', 'str2'])
  store.dispatch('dex/set/pokemonById.*.powerUps.shift', _027.id)
  t.deepEqual(dex[_027.id].powerUps, ['str2'])
  store.dispatch('dex/set/pokemonById.*.powerUps.splice', [_027.id, [0, 0, 'def2']])
  t.deepEqual(dex[_027.id].powerUps, ['def2', 'str2'])
  store.dispatch('dex/set/pokemonById.*.powerUps.splice', [_027.id, [1, 0, 'def3']])
  t.deepEqual(dex[_027.id].powerUps, ['def2', 'def3', 'str2'])
  store.dispatch('dex/set/pokemonById.*.powerUps.splice', [_027.id, [1, 1]])
  t.deepEqual(dex[_027.id].powerUps, ['def2', 'str2'])
  store.dispatch('dex/set/pokemonById.*.powerUps.splice', [_027.id, [0, 1]])
  t.deepEqual(dex[_027.id].powerUps, ['str2'])
  store.dispatch('dex/set/pokemonById.*.powerUps.splice', [_027.id, [0, 1]])
  t.deepEqual(dex[_027.id].powerUps, [])
})

test('errors', t => {
  let res
  res = store.set('user/name', 'Ash')
  t.is(res, 'missingSetterMutation')
  res = store.delete('user/name')
  t.is(res, 'missingDeleteMutation')
  // can't test because commit doesn't return anything:
  // res = store.commit('dex/-pokemonById.*')
  // t.is(res, 'mutationDeleteNoId')
})

test('Set and delete wildcard props directly on state', t => {
  // Add items
  store.set('friendsList/*', {id: '001', name: 'bulbasaur'})
  store.commit('friendsList/*', {id: '004', name: 'charmander'})
  store.dispatch('friendsList/set/*', {id: '007', name: 'squirtle'})
  // add some more to test deletions
  store.set('friendsList/*', {id: '002', name: 'ivysaur'})
  store.set('friendsList/*', {id: '003', name: 'venusaur'})
  store.set('friendsList/*', {id: '005', name: 'charmeleon'})
  store.set('friendsList/*', {id: '006', name: 'charizard'})
  store.set('friendsList/*', {id: '008', name: 'warturtle'})
  store.set('friendsList/*', {id: '009', name: 'blastoise'})
  // check amount
  const fL = store.state.friendsList

  // DELETE with wildcard in path
  store.delete('friendsList/*.name', ['003'])
  t.truthy(fL['003'])
  t.is(fL['003'].name, undefined)
  store.commit('friendsList/-*.name', ['006'])
  t.truthy(fL['006'])
  t.is(fL['006'].name, undefined)
  store.dispatch('friendsList/delete/*.name', ['009'])
  t.truthy(fL['009'])
  t.is(fL['009'].name, undefined)

  // fully DELETE wildcard item
  store.delete('friendsList/*', '003')
  t.is(fL['003'], undefined)
  store.commit('friendsList/-*', '006')
  t.is(fL['006'], undefined)
  store.dispatch('friendsList/delete/*', '009')
  t.is(fL['009'], undefined)

  // check if additions are still there
  t.truthy(fL['001'])
  t.truthy(fL['004'])
  t.truthy(fL['007'])
  t.is(fL['001'].name, 'bulbasaur')
  t.is(fL['004'].name, 'charmander')
  t.is(fL['007'].name, 'squirtle')

  store.set('friendsList/*', {id: '001', name: '!'})
  store.commit('friendsList/*', {'004': {name: '?'}})
  store.dispatch('friendsList/set/*', {id: '007', name: '><'})
  t.is(fL['001'].name, '!')
  t.is(fL['004'].name, '?')
  t.is(fL['007'].name, '><')

  store.set('friendsList/*.tags.*', ['001', {guild: true}])
  store.commit('friendsList/*.tags.*', ['004', {guild: true}])
  store.dispatch('friendsList/set/*.tags.*', ['007', {guild: true}])
  t.is(fL['001'].tags.guild, true)
  t.is(fL['004'].tags.guild, true)
  t.is(fL['007'].tags.guild, true)
})
