"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.VXETablePluginMenus = void 0;

var _xeUtils = _interopRequireDefault(require("xe-utils"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var handleCopy;

function handleFixedColumn(fixed) {
  return function (params) {
    var $table = params.$table,
        column = params.column;

    _xeUtils["default"].eachTree([column], function (column) {
      column.fixed = fixed;
    });

    $table.refreshColumn();
  };
}

function handleCopyOrCut(params, isCut) {
  var $event = params.$event,
      $table = params.$table,
      row = params.row,
      column = params.column;

  if (row && column) {
    var $vxe = $table.$vxe;
    var text = '';

    if ($table.mouseConfig && $table.mouseOpts.area) {
      if (isCut) {
        $table.triggerCutCellAreaEvent($event);
      } else {
        $table.triggerCopyCellAreaEvent($event);
      }

      text = $vxe.clipboard.text;
    } else {
      text = _xeUtils["default"].toValueString(_xeUtils["default"].get(row, column.property)); // 操作内置剪贴板

      $vxe.clipboard = {
        text: text
      };
    } // 开始复制操作


    if (_xeUtils["default"].isFunction(handleCopy)) {
      handleCopy(text);
    } else {
      console.warn('Copy function does not exist, copy to clipboard failed.');
    }
  }
}

function checkCellOverlay(params, cellAreas) {
  var $table = params.$table;

  var _$table$getTableData = $table.getTableData(),
      visibleData = _$table$getTableData.visibleData;

  var _$table$getTableColum = $table.getTableColumn(),
      visibleColumn = _$table$getTableColum.visibleColumn;

  var indexMaps = {};

  for (var aIndex = 0, areaSize = cellAreas.length; aIndex < areaSize; aIndex++) {
    var areaItem = cellAreas[aIndex];
    var rows = areaItem.rows,
        cols = areaItem.cols;

    for (var rIndex = 0, rowSize = rows.length; rIndex < rowSize; rIndex++) {
      var offsetRow = rows[rIndex];
      var orIndex = visibleData.indexOf(offsetRow);

      for (var cIndex = 0, colSize = cols.length; cIndex < colSize; cIndex++) {
        var offsetColumn = cols[cIndex];
        var ocIndex = visibleColumn.indexOf(offsetColumn);
        var key = orIndex + ':' + ocIndex;

        if (indexMaps[key]) {
          return false;
        }

        indexMaps[key] = true;
      }
    }
  }

  return true;
}

function getBeenMerges(params) {
  var $table = params.$table;

  var _$table$getTableData2 = $table.getTableData(),
      visibleData = _$table$getTableData2.visibleData;

  var _$table$getTableColum2 = $table.getTableColumn(),
      visibleColumn = _$table$getTableColum2.visibleColumn;

  var cellAreas = $table.mouseConfig && $table.mouseOpts.area ? $table.getCellAreas() : [];
  var mergeList = $table.getMergeCells();
  return mergeList.filter(function (_ref) {
    var mergeRowIndex = _ref.row,
        mergeColIndex = _ref.col,
        mergeRowspan = _ref.rowspan,
        mergeColspan = _ref.colspan;
    return cellAreas.some(function (areaItem) {
      var rows = areaItem.rows,
          cols = areaItem.cols;
      var startRowIndex = visibleData.indexOf(rows[0]);
      var endRowIndex = visibleData.indexOf(rows[rows.length - 1]);
      var startColIndex = visibleColumn.indexOf(cols[0]);
      var endColIndex = visibleColumn.indexOf(cols[cols.length - 1]);
      return mergeRowIndex >= startRowIndex && mergeRowIndex + mergeRowspan - 1 <= endRowIndex && mergeColIndex >= startColIndex && mergeColIndex + mergeColspan - 1 <= endColIndex;
    });
  });
}

function handleClearMergeCells(params) {
  var $table = params.$table;
  var beenMerges = getBeenMerges(params);

  if (beenMerges.length) {
    $table.removeMergeCells(beenMerges);
  }

  return beenMerges;
}

function abandoned(code, newCode) {
  console.warn("The code \"".concat(code, "\" has been scrapped, please use \"").concat(newCode, "\""));
}

var menuMap = {
  /**
   * 清除单元格数据的值；如果启用 mouse-config.area 功能，则清除区域范围内的单元格数据
   */
  CLEAR_CELL: function CLEAR_CELL(params) {
    var $table = params.$table,
        row = params.row,
        column = params.column;

    if (row && column) {
      if ($table.mouseConfig && $table.mouseOpts.area) {
        var cellAreas = $table.getCellAreas();

        if (cellAreas && cellAreas.length) {
          cellAreas.forEach(function (areaItem) {
            var rows = areaItem.rows,
                cols = areaItem.cols;
            cols.forEach(function (column) {
              rows.forEach(function (row) {
                $table.clearData(row, column.property);
              });
            });
          });
        }
      } else {
        $table.clearData(row, column.property);
      }
    }
  },

  /**
   * 清除行数据的值
   */
  CLEAR_ROW: function CLEAR_ROW(params) {
    var $table = params.$table,
        row = params.row;

    if (row) {
      $table.clearData(row);
    }
  },
  // 已废弃
  CLEAR_SELECTED_ROW: function CLEAR_SELECTED_ROW(params) {
    abandoned('CLEAR_SELECTED_ROW', 'CLEAR_CHECKBOX_ROW');
    return menuMap.CLEAR_CHECKBOX_ROW(params);
  },

  /**
   * 清除复选框选中行数据的值
   */
  CLEAR_CHECKBOX_ROW: function CLEAR_CHECKBOX_ROW(params) {
    var $table = params.$table;
    $table.clearData($table.getCheckboxRecords());
  },

  /**
   * 清除所有数据的值
   */
  CLEAR_ALL: function CLEAR_ALL(params) {
    var $table = params.$table;
    $table.clearData();
  },

  /**
   * 还原单元格数据的值；如果启用 mouse-config.area 功能，则还原区域范围内的单元格数据
   */
  REVERT_CELL: function REVERT_CELL(params) {
    var $table = params.$table,
        row = params.row,
        column = params.column;

    if (row && column) {
      if ($table.mouseConfig && $table.mouseOpts.area) {
        var cellAreas = $table.getCellAreas();

        if (cellAreas && cellAreas.length) {
          cellAreas.forEach(function (areaItem) {
            var rows = areaItem.rows,
                cols = areaItem.cols;
            cols.forEach(function (column) {
              rows.forEach(function (row) {
                $table.revertData(row, column.property);
              });
            });
          });
        }
      } else {
        $table.revertData(row, column.property);
      }
    }
  },

  /**
   * 还原行数据的值
   */
  REVERT_ROW: function REVERT_ROW(params) {
    var $table = params.$table,
        row = params.row;

    if (row) {
      $table.revertData(row);
    }
  },
  // 已废弃
  REVERT_SELECTED_ROW: function REVERT_SELECTED_ROW(params) {
    abandoned('REVERT_SELECTED_ROW', 'REVERT_CHECKBOX_ROW');
    return menuMap.REVERT_CHECKBOX_ROW(params);
  },

  /**
   * 还原复选框选中行数据的值
   */
  REVERT_CHECKBOX_ROW: function REVERT_CHECKBOX_ROW(params) {
    var $table = params.$table;
    $table.revertData($table.getCheckboxRecords());
  },

  /**
   * 还原所有数据的值
   */
  REVERT_ALL: function REVERT_ALL(params) {
    var $table = params.$table;
    $table.revertData();
  },

  /**
   * 复制单元格数据的值；如果启用 mouse-config.area 功能，则复制区域范围内的单元格数据，支持 Excel 和 WPS
   */
  COPY_CELL: function COPY_CELL(params) {
    handleCopyOrCut(params);
  },

  /**
   * 剪贴单元格数据的值；如果启用 mouse-config.area 功能，则剪贴区域范围内的单元格数据，支持 Excel 和 WPS
   */
  CUT_CELL: function CUT_CELL(params) {
    handleCopyOrCut(params, true);
  },

  /**
   * 粘贴从表格中被复制的数据；如果启用 mouse-config.area 功能，则粘贴区域范围内的单元格数据，不支持读取剪贴板
   */
  PASTE_CELL: function PASTE_CELL(params) {
    var $event = params.$event,
        $table = params.$table,
        row = params.row,
        column = params.column;

    if ($table.mouseConfig && $table.mouseOpts.area) {
      $table.triggerPasteCellAreaEvent($event);
    } else {
      var $vxe = $table.$vxe;
      var clipboard = $vxe.clipboard; // 读取内置剪贴板

      if (clipboard && clipboard.text) {
        _xeUtils["default"].set(row, column.property, clipboard.text);
      }
    }
  },

  /**
   * 如果启用 mouse-config.area 功能，如果所选区域内已存在合并单元格，则取消临时合并，否则临时合并
   */
  MERGE_OR_CLEAR: function MERGE_OR_CLEAR(params) {
    var $event = params.$event,
        $table = params.$table;
    var cellAreas = $table.getCellAreas();
    var beenMerges = getBeenMerges(params);
    var status = false;

    if (beenMerges.length) {
      $table.removeMergeCells(beenMerges);
    } else {
      status = true;
      $table.setMergeCells(cellAreas.map(function (_ref2) {
        var rows = _ref2.rows,
            cols = _ref2.cols;
        return {
          row: rows[0],
          col: cols[0],
          rowspan: rows.length,
          colspan: cols.length
        };
      }));
    }

    var targetAreas = cellAreas.map(function (_ref3) {
      var rows = _ref3.rows,
          cols = _ref3.cols;
      return {
        rows: rows,
        cols: cols
      };
    });
    $table.emitEvent('cell-area-merge', {
      status: status,
      targetAreas: targetAreas
    }, $event);
  },

  /**
   * 如果启用 mouse-config.area 功能，临时合并区域范围内的单元格，不管是否存在已合并
   */
  MERGE_CELL: function MERGE_CELL(params) {
    var $event = params.$event,
        $table = params.$table;
    var $vxe = $table.$vxe;
    var modal = $vxe.modal;

    var _$table$getTableData3 = $table.getTableData(),
        visibleData = _$table$getTableData3.visibleData;

    var _$table$getTableColum3 = $table.getTableColumn(),
        visibleColumn = _$table$getTableColum3.visibleColumn;

    var cellAreas = $table.getCellAreas();
    handleClearMergeCells(params);

    if (cellAreas.some(function (_ref4) {
      var rows = _ref4.rows,
          cols = _ref4.cols;
      return rows.length === visibleData.length || cols.length === visibleColumn.length;
    })) {
      if (modal) {
        modal.message({
          content: $vxe.t('vxe.pro.area.mergeErr'),
          status: 'error',
          id: 'operErr'
        });
      }

      return;
    }

    $table.setMergeCells(cellAreas.map(function (_ref5) {
      var rows = _ref5.rows,
          cols = _ref5.cols;
      return {
        row: rows[0],
        col: cols[0],
        rowspan: rows.length,
        colspan: cols.length
      };
    }));
    var targetAreas = cellAreas.map(function (_ref6) {
      var rows = _ref6.rows,
          cols = _ref6.cols;
      return {
        rows: rows,
        cols: cols
      };
    });
    $table.emitEvent('cell-area-merge', {
      status: true,
      targetAreas: targetAreas
    }, $event);
  },

  /**
   * 如果启用 mouse-config.area 功能，清除区域范围内单元格的临时合并状态
   */
  CLEAR_MERGE_CELL: function CLEAR_MERGE_CELL(params) {
    var $event = params.$event,
        $table = params.$table;
    var beenMerges = handleClearMergeCells(params);

    if (beenMerges.length) {
      $table.emitEvent('clear-cell-area-merge', {
        mergeCells: beenMerges
      }, $event);
    }
  },

  /**
   * 清除所有单元格及表尾的临时合并状态
   */
  CLEAR_ALL_MERGE: function CLEAR_ALL_MERGE(params) {
    var $event = params.$event,
        $table = params.$table;
    var mergeCells = $table.getMergeCells();
    var mergeFooterItems = $table.getMergeFooterItems();
    $table.clearMergeCells();
    $table.clearMergeFooterItems();
    $table.emitEvent('clear-merge', {
      mergeCells: mergeCells,
      mergeFooterItems: mergeFooterItems
    }, $event);
  },

  /**
   * 编辑单元格
   */
  EDIT_CELL: function EDIT_CELL(params) {
    var $table = params.$table,
        row = params.row,
        column = params.column;
    $table.setActiveCell(row, column.property);
  },

  /**
   * 编辑行
   */
  EDIT_ROW: function EDIT_ROW(params) {
    var $table = params.$table,
        row = params.row;
    $table.setActiveRow(row);
  },

  /**
   * 插入数据
   */
  INSERT_ROW: function INSERT_ROW(params) {
    var $table = params.$table,
        menu = params.menu;
    $table.insert(menu.params);
  },

  /**
   * 插入数据并激活编辑状态
   */
  INSERT_ACTIVED_ROW: function INSERT_ACTIVED_ROW(params) {
    var $table = params.$table,
        menu = params.menu,
        column = params.column;
    var args = menu.params || [];
    $table.insert(args[0]).then(function (_ref7) {
      var row = _ref7.row;
      return $table.setActiveCell(row, args[1] || column.property);
    });
  },

  /**
   * 插入数据到指定位置
   */
  INSERT_AT_ROW: function INSERT_AT_ROW(params) {
    var $table = params.$table,
        menu = params.menu,
        row = params.row;

    if (row) {
      $table.insertAt(menu.params, row);
    }
  },

  /**
   * 插入数据到指定位置并激活编辑状态
   */
  INSERT_AT_ACTIVED_ROW: function INSERT_AT_ACTIVED_ROW(params) {
    var $table = params.$table,
        menu = params.menu,
        row = params.row,
        column = params.column;

    if (row) {
      var args = menu.params || [];
      $table.insertAt(args[0], row).then(function (_ref8) {
        var row = _ref8.row;
        return $table.setActiveCell(row, args[1] || column.property);
      });
    }
  },

  /**
   * 移除行数据
   */
  DELETE_ROW: function DELETE_ROW(params) {
    var $table = params.$table,
        row = params.row;

    if (row) {
      $table.remove(row);
    }
  },
  // 已废弃
  DELETE_SELECTED_ROW: function DELETE_SELECTED_ROW(params) {
    abandoned('DELETE_SELECTED_ROW', 'DELETE_CHECKBOX_ROW');
    return menuMap.DELETE_CHECKBOX_ROW(params);
  },

  /**
   * 移除复选框选中行数据
   */
  DELETE_CHECKBOX_ROW: function DELETE_CHECKBOX_ROW(params) {
    var $table = params.$table;
    $table.removeCheckboxRow();
  },

  /**
   * 移除所有行数据
   */
  DELETE_ALL: function DELETE_ALL(params) {
    var $table = params.$table;
    $table.remove();
  },

  /**
   * 清除所选列排序条件
   */
  CLEAR_SORT: function CLEAR_SORT(params) {
    var $event = params.$event,
        $table = params.$table,
        column = params.column;

    if (column) {
      $table.triggerSortEvent($event, column, null);
    }
  },

  /**
   * 清除所有排序条件
   */
  CLEAR_ALL_SORT: function CLEAR_ALL_SORT(params) {
    var $event = params.$event,
        $table = params.$table;
    var sortList = $table.getSortColumns();

    if (sortList.length) {
      $table.clearSort();
      $table.emitEvent('clear-sort', {
        sortList: sortList
      }, $event);
    }
  },

  /**
   * 按所选列的值升序
   */
  SORT_ASC: function SORT_ASC(params) {
    var $event = params.$event,
        $table = params.$table,
        column = params.column;

    if (column) {
      $table.triggerSortEvent($event, column, 'asc');
    }
  },

  /**
   * 按所选列的值倒序
   */
  SORT_DESC: function SORT_DESC(params) {
    var $event = params.$event,
        $table = params.$table,
        column = params.column;

    if (column) {
      $table.triggerSortEvent($event, column, 'desc');
    }
  },

  /**
   * 清除复选框选中列的筛选条件
   */
  CLEAR_FILTER: function CLEAR_FILTER(params) {
    var $event = params.$event,
        $table = params.$table,
        column = params.column;

    if (column) {
      $table.handleClearFilter(column);
      $table.confirmFilterEvent($event);
    }
  },

  /**
   * 清除所有列筛选条件
   */
  CLEAR_ALL_FILTER: function CLEAR_ALL_FILTER(params) {
    var $event = params.$event,
        $table = params.$table;
    var filterList = $table.getCheckedFilters();

    if (filterList.length) {
      $table.clearFilter();
      $table.dispatchEvent('clear-filter', {
        filterList: filterList
      }, $event);
    }
  },

  /**
   * 根据单元格值筛选
   */
  FILTER_CELL: function FILTER_CELL(params) {
    var $table = params.$table,
        row = params.row,
        column = params.column;

    if (row && column) {
      var property = column.property,
          filters = column.filters;

      if (filters.length) {
        var option = filters[0];
        option.data = _xeUtils["default"].get(row, property);
        option.checked = true;
        $table.updateData();
      }
    }
  },

  /**
   * 导出行数据
   */
  EXPORT_ROW: function EXPORT_ROW(params) {
    var $table = params.$table,
        menu = params.menu,
        row = params.row;

    if (row) {
      var opts = {
        data: [row]
      };
      $table.exportData(_xeUtils["default"].assign(opts, menu.params[0]));
    }
  },
  // 已废弃
  EXPORT_SELECTED_ROW: function EXPORT_SELECTED_ROW(params) {
    abandoned('EXPORT_SELECTED_ROW', 'EXPORT_CHECKBOX_ROW');
    return menuMap.EXPORT_CHECKBOX_ROW(params);
  },

  /**
   * 导出复选框选中行数据
   */
  EXPORT_CHECKBOX_ROW: function EXPORT_CHECKBOX_ROW(params) {
    var $table = params.$table,
        menu = params.menu;
    var opts = {
      data: $table.getCheckboxRecords()
    };
    $table.exportData(_xeUtils["default"].assign(opts, menu.params[0]));
  },

  /**
   * 导出所有行数据
   */
  EXPORT_ALL: function EXPORT_ALL(params) {
    var $table = params.$table,
        menu = params.menu;
    $table.exportData(menu.params);
  },

  /**
   * 打印所有行数据
   */
  PRINT_ALL: function PRINT_ALL(params) {
    var $table = params.$table,
        menu = params.menu;
    $table.print(menu.params);
  },
  // 已废弃
  PRINT_SELECTED_ROW: function PRINT_SELECTED_ROW(params) {
    abandoned('PRINT_SELECTED_ROW', 'PRINT_CHECKBOX_ROW');
    return menuMap.PRINT_CHECKBOX_ROW(params);
  },

  /**
   * 打印复选框选中行
   */
  PRINT_CHECKBOX_ROW: function PRINT_CHECKBOX_ROW(params) {
    var $table = params.$table,
        menu = params.menu;
    var opts = {
      data: $table.getCheckboxRecords()
    };
    $table.print(_xeUtils["default"].assign(opts, menu.params));
  },

  /**
   * 打开查找功能
   */
  OPEN_FIND: function OPEN_FIND(params) {
    var $event = params.$event,
        $table = params.$table;
    $table.triggerFNROpenEvent($event, 'find');
  },

  /**
   * 打开替换功能
   */
  OPEN_REPLACE: function OPEN_REPLACE(params) {
    var $event = params.$event,
        $table = params.$table;
    $table.triggerFNROpenEvent($event, 'replace');
  },

  /**
   * 隐藏当前列
   */
  HIDDEN_COLUMN: function HIDDEN_COLUMN(params) {
    var $table = params.$table,
        column = params.column;

    if (column) {
      $table.hideColumn(column);
    }
  },

  /**
   * 将列固定到左侧
   */
  FIXED_LEFT_COLUMN: handleFixedColumn('left'),

  /**
   * 将列固定到右侧
   */
  FIXED_RIGHT_COLUMN: handleFixedColumn('right'),

  /**
   * 清除固定列
   */
  CLEAR_FIXED_COLUMN: handleFixedColumn(''),

  /**
   * 重置列的可视状态
   */
  RESET_COLUMN: function RESET_COLUMN(params) {
    var $table = params.$table;
    $table.resetColumn({
      visible: true,
      resizable: false
    });
  },

  /**
   * 重置列宽状态
   */
  RESET_RESIZABLE: function RESET_RESIZABLE(params) {
    var $table = params.$table;
    $table.resetColumn({
      visible: false,
      resizable: true
    });
  },

  /**
   * 重置列的所有状态
   */
  RESET_ALL: function RESET_ALL(params) {
    var $table = params.$table;
    $table.resetColumn(true);
  }
};

function checkPrivilege(item, params) {
  var code = item.code;
  var $table = params.$table,
      columns = params.columns,
      row = params.row,
      column = params.column;
  var editConfig = $table.editConfig,
      mouseConfig = $table.mouseConfig,
      mouseOpts = $table.mouseOpts,
      fnrOpts = $table.fnrOpts;

  switch (code) {
    case 'CLEAR_ALL_SORT':
      {
        var sortList = $table.getSortColumns();
        item.disabled = !sortList.length;
        break;
      }

    case 'CLEAR_ALL_FILTER':
      {
        var filterList = $table.getCheckedFilters();
        item.disabled = !filterList.length;
        break;
      }

    case 'CLEAR_ALL_MERGE':
      {
        var mergeCells = $table.getMergeCells();
        var mergeFooterItems = $table.getMergeFooterItems();
        item.disabled = !mergeCells.length && !mergeFooterItems.length;
        break;
      }

    case 'CLEAR_MERGE_CELL':
      {
        var beenMerges = getBeenMerges(params);
        item.disabled = !beenMerges.length;
        break;
      }

    case 'EDIT_ROW':
      {
        item.disabled = !editConfig || !columns.some(function (column) {
          return column.editRender;
        });
        break;
      }

    case 'EDIT_CELL':
    case 'CLEAR_CELL':
    case 'CLEAR_ROW':
    case 'COPY_CELL':
    case 'CUT_CELL':
    case 'PASTE_CELL':
    case 'MERGE_OR_CLEAR':
    case 'MERGE_CELL':
    case 'REVERT_CELL':
    case 'REVERT_ROW':
    case 'INSERT_AT_ROW':
    case 'INSERT_AT_ACTIVED_ROW':
    case 'DELETE_ROW':
    case 'CLEAR_SORT':
    case 'SORT_ASC':
    case 'SORT_DESC':
    case 'CLEAR_FILTER':
    case 'FILTER_CELL':
    case 'EXPORT_ROW':
    case 'OPEN_FIND':
    case 'OPEN_REPLACE':
    case 'HIDDEN_COLUMN':
    case 'FIXED_LEFT_COLUMN':
    case 'FIXED_RIGHT_COLUMN':
    case 'CLEAR_FIXED_COLUMN':
      {
        item.disabled = !column;

        if (column) {
          var isChildCol = !!column.parentId;

          switch (code) {
            case 'CLEAR_SORT':
              {
                item.disabled = !column.sortable || !column.order;
                break;
              }

            case 'SORT_ASC':
            case 'SORT_DESC':
              {
                item.disabled = !column.sortable;
                break;
              }

            case 'FILTER_CELL':
            case 'CLEAR_FILTER':
              {
                item.disabled = !column.filters || !column.filters.length;

                if (!item.disabled) {
                  switch (code) {
                    case 'CLEAR_FILTER':
                      item.disabled = !column.filters.some(function (option) {
                        return option.checked;
                      });
                      break;
                  }
                }

                break;
              }

            case 'REVERT_CELL':
              {
                item.disabled = !row || !column.property || !$table.isUpdateByRow(row, column.property);
                break;
              }

            case 'REVERT_ROW':
              {
                item.disabled = !row || !column.property || !$table.isUpdateByRow(row);
                break;
              }

            case 'OPEN_FIND':
              {
                item.disabled = !(fnrOpts && mouseConfig && mouseOpts.area && fnrOpts.isFind);
                break;
              }

            case 'OPEN_REPLACE':
              {
                item.disabled = !(fnrOpts && mouseConfig && mouseOpts.area && fnrOpts.isReplace);
                break;
              }

            case 'EDIT_CELL':
              {
                item.disabled = !editConfig || !column.editRender;
                break;
              }

            case 'COPY_CELL':
            case 'CUT_CELL':
            case 'PASTE_CELL':
              {
                var cellAreas = mouseConfig && mouseOpts.area ? $table.getCellAreas() : [];
                item.disabled = cellAreas.length > 1;

                if (!item.disabled) {
                  switch (code) {
                    case 'PASTE_CELL':
                      var $vxe = $table.$vxe;
                      var clipboard = $vxe.clipboard;
                      item.disabled = !clipboard || !clipboard.text;
                      break;
                  }
                }

                break;
              }

            case 'MERGE_OR_CLEAR':
            case 'MERGE_CELL':
              {
                var _cellAreas = mouseConfig && mouseOpts.area ? $table.getCellAreas() : [];

                item.disabled = !_cellAreas.length || _cellAreas.length === 1 && _cellAreas[0].rows.length === 1 && _cellAreas[0].cols.length === 1 || !checkCellOverlay(params, _cellAreas);
                break;
              }

            case 'FIXED_LEFT_COLUMN':
              item.disabled = isChildCol || column.fixed === 'left';
              break;

            case 'FIXED_RIGHT_COLUMN':
              item.disabled = isChildCol || column.fixed === 'right';
              break;

            case 'CLEAR_FIXED_COLUMN':
              item.disabled = isChildCol || !column.fixed;
              break;
          }
        }

        break;
      }
  }
}

function handlePrivilegeEvent(params) {
  params.options.forEach(function (list) {
    list.forEach(function (item) {
      checkPrivilege(item, params);

      if (item.children) {
        item.children.forEach(function (child) {
          checkPrivilege(child, params);
        });
      }
    });
  });
  return true;
}

function setup(options) {
  if (options && options.copy) {
    handleCopy = options.copy;
  }
}
/**
 * 基于 vxe-table 表格的增强插件，提供实用的快捷菜单集
 */


var VXETablePluginMenus = {
  setup: setup,
  install: function install(_ref9, options) {
    var interceptor = _ref9.interceptor,
        menus = _ref9.menus;

    if (window.XEClipboard) {
      handleCopy = window.XEClipboard.copy;
    }

    setup(options);
    interceptor.add('event.showMenu', handlePrivilegeEvent);
    menus.mixin(menuMap);
  }
};
exports.VXETablePluginMenus = VXETablePluginMenus;

if (typeof window !== 'undefined' && window.VXETable && window.VXETable.use) {
  window.VXETable.use(VXETablePluginMenus);
}

var _default = VXETablePluginMenus;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
