"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.VXETablePluginMenus = void 0;

var _xeUtils = _interopRequireDefault(require("xe-utils"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var handleCopy;

function handleFixedColumn(fixed) {
  return function (params) {
    var $table = params.$table,
        column = params.column;

    _xeUtils["default"].eachTree([column], function (column) {
      column.fixed = fixed;
    });

    $table.refreshColumn();
  };
}

var copyElem;

function handleText(content) {
  if (!copyElem) {
    copyElem = document.createElement('textarea');
    copyElem.id = '$XECopy';
    var styles = copyElem.style;
    styles.width = '48px';
    styles.height = '24px';
    styles.position = 'fixed';
    styles.zIndex = '0';
    styles.left = '-500px';
    styles.top = '-500px';
    document.body.appendChild(copyElem);
  }

  copyElem.value = content === null || content === undefined ? '' : '' + content;
}

function copyText(content) {
  var result = false;

  try {
    handleText(content);
    copyElem.select();
    copyElem.setSelectionRange(0, copyElem.value.length);
    result = document.execCommand('copy');
    copyElem.blur();
  } catch (e) {}

  return result;
}

function handleCopyOrCut(params, isCut) {
  var $event = params.$event,
      $table = params.$table,
      row = params.row,
      column = params.column;

  if (row && column) {
    var $vxe = $table.$vxe;
    var text = '';

    if ($table.mouseConfig && $table.mouseOpts.area) {
      if (isCut) {
        $table.triggerCutCellAreaEvent($event);
      } else {
        $table.triggerCopyCellAreaEvent($event);
      }

      text = $vxe.clipboard.text;
    } else {
      text = _xeUtils["default"].toValueString(_xeUtils["default"].get(row, column.property)); // 操作内置剪贴板

      $vxe.clipboard = {
        text: text
      };
    } // 开始复制操作


    if (_xeUtils["default"].isFunction(handleCopy)) {
      handleCopy(text);
    } else {
      copyText(text);
    }
  }
}

function checkCellOverlay(params, cellAreas) {
  var $table = params.$table;

  var _$table$getTableData = $table.getTableData(),
      visibleData = _$table$getTableData.visibleData;

  var _$table$getTableColum = $table.getTableColumn(),
      visibleColumn = _$table$getTableColum.visibleColumn;

  var indexMaps = {};

  for (var aIndex = 0, areaSize = cellAreas.length; aIndex < areaSize; aIndex++) {
    var areaItem = cellAreas[aIndex];
    var rows = areaItem.rows,
        cols = areaItem.cols;

    for (var rIndex = 0, rowSize = rows.length; rIndex < rowSize; rIndex++) {
      var offsetRow = rows[rIndex];
      var orIndex = visibleData.indexOf(offsetRow);

      for (var cIndex = 0, colSize = cols.length; cIndex < colSize; cIndex++) {
        var offsetColumn = cols[cIndex];
        var ocIndex = visibleColumn.indexOf(offsetColumn);
        var key = orIndex + ':' + ocIndex;

        if (indexMaps[key]) {
          return false;
        }

        indexMaps[key] = true;
      }
    }
  }

  return true;
}

function getBeenMerges(params) {
  var $table = params.$table;

  var _$table$getTableData2 = $table.getTableData(),
      visibleData = _$table$getTableData2.visibleData;

  var _$table$getTableColum2 = $table.getTableColumn(),
      visibleColumn = _$table$getTableColum2.visibleColumn;

  var cellAreas = $table.mouseConfig && $table.mouseOpts.area ? $table.getCellAreas() : [];
  var mergeList = $table.getMergeCells();
  return mergeList.filter(function (_ref) {
    var mergeRowIndex = _ref.row,
        mergeColIndex = _ref.col,
        mergeRowspan = _ref.rowspan,
        mergeColspan = _ref.colspan;
    return cellAreas.some(function (areaItem) {
      var rows = areaItem.rows,
          cols = areaItem.cols;
      var startRowIndex = visibleData.indexOf(rows[0]);
      var endRowIndex = visibleData.indexOf(rows[rows.length - 1]);
      var startColIndex = visibleColumn.indexOf(cols[0]);
      var endColIndex = visibleColumn.indexOf(cols[cols.length - 1]);
      return mergeRowIndex >= startRowIndex && mergeRowIndex + mergeRowspan - 1 <= endRowIndex && mergeColIndex >= startColIndex && mergeColIndex + mergeColspan - 1 <= endColIndex;
    });
  });
}

function handleClearMergeCells(params) {
  var $table = params.$table;
  var beenMerges = getBeenMerges(params);

  if (beenMerges.length) {
    $table.removeMergeCells(beenMerges);
  }

  return beenMerges;
}

function abandoned(code, newCode) {
  console.warn("The code \"".concat(code, "\" has been scrapped, please use \"").concat(newCode, "\""));
}

var menuMap = {
  /**
   * 清除单元格数据的值；如果启用 mouse-config.area 功能，则清除区域范围内的单元格数据
   */
  CLEAR_CELL: function CLEAR_CELL(params) {
    var $table = params.$table,
        row = params.row,
        column = params.column;

    if (row && column) {
      if ($table.mouseConfig && $table.mouseOpts.area) {
        var cellAreas = $table.getCellAreas();

        if (cellAreas && cellAreas.length) {
          cellAreas.forEach(function (areaItem) {
            var rows = areaItem.rows,
                cols = areaItem.cols;
            cols.forEach(function (column) {
              rows.forEach(function (row) {
                $table.clearData(row, column.property);
              });
            });
          });
        }
      } else {
        $table.clearData(row, column.property);
      }
    }
  },

  /**
   * 清除行数据的值
   */
  CLEAR_ROW: function CLEAR_ROW(params) {
    var $table = params.$table,
        row = params.row;

    if (row) {
      $table.clearData(row);
    }
  },
  // 已废弃
  CLEAR_SELECTED_ROW: function CLEAR_SELECTED_ROW(params) {
    abandoned('CLEAR_SELECTED_ROW', 'CLEAR_CHECKBOX_ROW');
    return menuMap.CLEAR_CHECKBOX_ROW(params);
  },

  /**
   * 清除复选框选中行数据的值
   */
  CLEAR_CHECKBOX_ROW: function CLEAR_CHECKBOX_ROW(params) {
    var $table = params.$table;
    $table.clearData($table.getCheckboxRecords());
  },

  /**
   * 清除所有数据的值
   */
  CLEAR_ALL: function CLEAR_ALL(params) {
    var $table = params.$table;
    $table.clearData();
  },

  /**
   * 还原单元格数据的值；如果启用 mouse-config.area 功能，则还原区域范围内的单元格数据
   */
  REVERT_CELL: function REVERT_CELL(params) {
    var $table = params.$table,
        row = params.row,
        column = params.column;

    if (row && column) {
      if ($table.mouseConfig && $table.mouseOpts.area) {
        var cellAreas = $table.getCellAreas();

        if (cellAreas && cellAreas.length) {
          cellAreas.forEach(function (areaItem) {
            var rows = areaItem.rows,
                cols = areaItem.cols;
            cols.forEach(function (column) {
              rows.forEach(function (row) {
                $table.revertData(row, column.property);
              });
            });
          });
        }
      } else {
        $table.revertData(row, column.property);
      }
    }
  },

  /**
   * 还原行数据的值
   */
  REVERT_ROW: function REVERT_ROW(params) {
    var $table = params.$table,
        row = params.row;

    if (row) {
      $table.revertData(row);
    }
  },
  // 已废弃
  REVERT_SELECTED_ROW: function REVERT_SELECTED_ROW(params) {
    abandoned('REVERT_SELECTED_ROW', 'REVERT_CHECKBOX_ROW');
    return menuMap.REVERT_CHECKBOX_ROW(params);
  },

  /**
   * 还原复选框选中行数据的值
   */
  REVERT_CHECKBOX_ROW: function REVERT_CHECKBOX_ROW(params) {
    var $table = params.$table;
    $table.revertData($table.getCheckboxRecords());
  },

  /**
   * 还原所有数据的值
   */
  REVERT_ALL: function REVERT_ALL(params) {
    var $table = params.$table;
    $table.revertData();
  },

  /**
   * 复制单元格数据的值；如果启用 mouse-config.area 功能，则复制区域范围内的单元格数据，支持 Excel 和 WPS
   */
  COPY_CELL: function COPY_CELL(params) {
    handleCopyOrCut(params);
  },

  /**
   * 剪贴单元格数据的值；如果启用 mouse-config.area 功能，则剪贴区域范围内的单元格数据，支持 Excel 和 WPS
   */
  CUT_CELL: function CUT_CELL(params) {
    handleCopyOrCut(params, true);
  },

  /**
   * 粘贴从表格中被复制的数据；如果启用 mouse-config.area 功能，则粘贴区域范围内的单元格数据，不支持读取剪贴板
   */
  PASTE_CELL: function PASTE_CELL(params) {
    var $event = params.$event,
        $table = params.$table,
        row = params.row,
        column = params.column;

    if ($table.mouseConfig && $table.mouseOpts.area) {
      $table.triggerPasteCellAreaEvent($event);
    } else {
      var $vxe = $table.$vxe;
      var clipboard = $vxe.clipboard; // 读取内置剪贴板

      if (clipboard && clipboard.text) {
        _xeUtils["default"].set(row, column.property, clipboard.text);
      }
    }
  },

  /**
   * 如果启用 mouse-config.area 功能，如果所选区域内已存在合并单元格，则取消临时合并，否则临时合并
   */
  MERGE_OR_CLEAR: function MERGE_OR_CLEAR(params) {
    var $event = params.$event,
        $table = params.$table;
    var cellAreas = $table.getCellAreas();
    var beenMerges = getBeenMerges(params);
    var status = false;

    if (beenMerges.length) {
      $table.removeMergeCells(beenMerges);
    } else {
      status = true;
      $table.setMergeCells(cellAreas.map(function (_ref2) {
        var rows = _ref2.rows,
            cols = _ref2.cols;
        return {
          row: rows[0],
          col: cols[0],
          rowspan: rows.length,
          colspan: cols.length
        };
      }));
    }

    var targetAreas = cellAreas.map(function (_ref3) {
      var rows = _ref3.rows,
          cols = _ref3.cols;
      return {
        rows: rows,
        cols: cols
      };
    });
    $table.emitEvent('cell-area-merge', {
      status: status,
      targetAreas: targetAreas
    }, $event);
  },

  /**
   * 如果启用 mouse-config.area 功能，临时合并区域范围内的单元格，不管是否存在已合并
   */
  MERGE_CELL: function MERGE_CELL(params) {
    var $event = params.$event,
        $table = params.$table;
    var $vxe = $table.$vxe;
    var modal = $vxe.modal;

    var _$table$getTableData3 = $table.getTableData(),
        visibleData = _$table$getTableData3.visibleData;

    var _$table$getTableColum3 = $table.getTableColumn(),
        visibleColumn = _$table$getTableColum3.visibleColumn;

    var cellAreas = $table.getCellAreas();
    handleClearMergeCells(params);

    if (cellAreas.some(function (_ref4) {
      var rows = _ref4.rows,
          cols = _ref4.cols;
      return rows.length === visibleData.length || cols.length === visibleColumn.length;
    })) {
      if (modal) {
        modal.message({
          content: $vxe.t('vxe.pro.area.mergeErr'),
          status: 'error',
          id: 'operErr'
        });
      }

      return;
    }

    $table.setMergeCells(cellAreas.map(function (_ref5) {
      var rows = _ref5.rows,
          cols = _ref5.cols;
      return {
        row: rows[0],
        col: cols[0],
        rowspan: rows.length,
        colspan: cols.length
      };
    }));
    var targetAreas = cellAreas.map(function (_ref6) {
      var rows = _ref6.rows,
          cols = _ref6.cols;
      return {
        rows: rows,
        cols: cols
      };
    });
    $table.emitEvent('cell-area-merge', {
      status: true,
      targetAreas: targetAreas
    }, $event);
  },

  /**
   * 如果启用 mouse-config.area 功能，清除区域范围内单元格的临时合并状态
   */
  CLEAR_MERGE_CELL: function CLEAR_MERGE_CELL(params) {
    var $event = params.$event,
        $table = params.$table;
    var beenMerges = handleClearMergeCells(params);

    if (beenMerges.length) {
      $table.emitEvent('clear-cell-area-merge', {
        mergeCells: beenMerges
      }, $event);
    }
  },

  /**
   * 清除所有单元格及表尾的临时合并状态
   */
  CLEAR_ALL_MERGE: function CLEAR_ALL_MERGE(params) {
    var $event = params.$event,
        $table = params.$table;
    var mergeCells = $table.getMergeCells();
    var mergeFooterItems = $table.getMergeFooterItems();
    $table.clearMergeCells();
    $table.clearMergeFooterItems();
    $table.emitEvent('clear-merge', {
      mergeCells: mergeCells,
      mergeFooterItems: mergeFooterItems
    }, $event);
  },

  /**
   * 编辑单元格
   */
  EDIT_CELL: function EDIT_CELL(params) {
    var $table = params.$table,
        row = params.row,
        column = params.column;
    $table.setActiveCell(row, column.property);
  },

  /**
   * 编辑行
   */
  EDIT_ROW: function EDIT_ROW(params) {
    var $table = params.$table,
        row = params.row;
    $table.setActiveRow(row);
  },

  /**
   * 插入数据
   */
  INSERT_ROW: function INSERT_ROW(params) {
    var $table = params.$table,
        menu = params.menu;
    $table.insert(menu.params);
  },

  /**
   * 插入数据并激活编辑状态
   */
  INSERT_ACTIVED_ROW: function INSERT_ACTIVED_ROW(params) {
    var $table = params.$table,
        menu = params.menu,
        column = params.column;
    var args = menu.params || [];
    $table.insert(args[0]).then(function (_ref7) {
      var row = _ref7.row;
      return $table.setActiveCell(row, args[1] || column.property);
    });
  },

  /**
   * 插入数据到指定位置
   */
  INSERT_AT_ROW: function INSERT_AT_ROW(params) {
    var $table = params.$table,
        menu = params.menu,
        row = params.row;

    if (row) {
      $table.insertAt(menu.params, row);
    }
  },

  /**
   * 插入数据到指定位置并激活编辑状态
   */
  INSERT_AT_ACTIVED_ROW: function INSERT_AT_ACTIVED_ROW(params) {
    var $table = params.$table,
        menu = params.menu,
        row = params.row,
        column = params.column;

    if (row) {
      var args = menu.params || [];
      $table.insertAt(args[0], row).then(function (_ref8) {
        var row = _ref8.row;
        return $table.setActiveCell(row, args[1] || column.property);
      });
    }
  },

  /**
   * 移除行数据
   */
  DELETE_ROW: function DELETE_ROW(params) {
    var $table = params.$table,
        row = params.row;

    if (row) {
      $table.remove(row);
    }
  },
  // 已废弃
  DELETE_SELECTED_ROW: function DELETE_SELECTED_ROW(params) {
    abandoned('DELETE_SELECTED_ROW', 'DELETE_CHECKBOX_ROW');
    return menuMap.DELETE_CHECKBOX_ROW(params);
  },

  /**
   * 移除复选框选中行数据
   */
  DELETE_CHECKBOX_ROW: function DELETE_CHECKBOX_ROW(params) {
    var $table = params.$table;
    $table.removeCheckboxRow();
  },

  /**
   * 移除所有行数据
   */
  DELETE_ALL: function DELETE_ALL(params) {
    var $table = params.$table;
    $table.remove();
  },

  /**
   * 清除所选列排序条件
   */
  CLEAR_SORT: function CLEAR_SORT(params) {
    var $event = params.$event,
        $table = params.$table,
        column = params.column;

    if (column) {
      $table.triggerSortEvent($event, column, null);
    }
  },

  /**
   * 清除所有排序条件
   */
  CLEAR_ALL_SORT: function CLEAR_ALL_SORT(params) {
    var $event = params.$event,
        $table = params.$table;
    var sortList = $table.getSortColumns();

    if (sortList.length) {
      $table.clearSort();
      $table.emitEvent('clear-sort', {
        sortList: sortList
      }, $event);
    }
  },

  /**
   * 按所选列的值升序
   */
  SORT_ASC: function SORT_ASC(params) {
    var $event = params.$event,
        $table = params.$table,
        column = params.column;

    if (column) {
      $table.triggerSortEvent($event, column, 'asc');
    }
  },

  /**
   * 按所选列的值倒序
   */
  SORT_DESC: function SORT_DESC(params) {
    var $event = params.$event,
        $table = params.$table,
        column = params.column;

    if (column) {
      $table.triggerSortEvent($event, column, 'desc');
    }
  },

  /**
   * 清除复选框选中列的筛选条件
   */
  CLEAR_FILTER: function CLEAR_FILTER(params) {
    var $event = params.$event,
        $table = params.$table,
        column = params.column;

    if (column) {
      $table.handleClearFilter(column);
      $table.confirmFilterEvent($event);
    }
  },

  /**
   * 清除所有列筛选条件
   */
  CLEAR_ALL_FILTER: function CLEAR_ALL_FILTER(params) {
    var $event = params.$event,
        $table = params.$table;
    var filterList = $table.getCheckedFilters();

    if (filterList.length) {
      $table.clearFilter();
      $table.dispatchEvent('clear-filter', {
        filterList: filterList
      }, $event);
    }
  },

  /**
   * 根据单元格值筛选
   */
  FILTER_CELL: function FILTER_CELL(params) {
    var $table = params.$table,
        row = params.row,
        column = params.column;

    if (row && column) {
      var property = column.property,
          filters = column.filters;

      if (filters.length) {
        var option = filters[0];
        option.data = _xeUtils["default"].get(row, property);
        option.checked = true;
        $table.updateData();
      }
    }
  },

  /**
   * 导出行数据
   */
  EXPORT_ROW: function EXPORT_ROW(params) {
    var $table = params.$table,
        menu = params.menu,
        row = params.row;

    if (row) {
      var opts = {
        data: [row]
      };
      $table.exportData(_xeUtils["default"].assign(opts, menu.params[0]));
    }
  },
  // 已废弃
  EXPORT_SELECTED_ROW: function EXPORT_SELECTED_ROW(params) {
    abandoned('EXPORT_SELECTED_ROW', 'EXPORT_CHECKBOX_ROW');
    return menuMap.EXPORT_CHECKBOX_ROW(params);
  },

  /**
   * 导出复选框选中行数据
   */
  EXPORT_CHECKBOX_ROW: function EXPORT_CHECKBOX_ROW(params) {
    var $table = params.$table,
        menu = params.menu;
    var opts = {
      data: $table.getCheckboxRecords()
    };
    $table.exportData(_xeUtils["default"].assign(opts, menu.params[0]));
  },

  /**
   * 导出所有行数据
   */
  EXPORT_ALL: function EXPORT_ALL(params) {
    var $table = params.$table,
        menu = params.menu;
    $table.exportData(menu.params);
  },

  /**
   * 打印所有行数据
   */
  PRINT_ALL: function PRINT_ALL(params) {
    var $table = params.$table,
        menu = params.menu;
    $table.print(menu.params);
  },
  // 已废弃
  PRINT_SELECTED_ROW: function PRINT_SELECTED_ROW(params) {
    abandoned('PRINT_SELECTED_ROW', 'PRINT_CHECKBOX_ROW');
    return menuMap.PRINT_CHECKBOX_ROW(params);
  },

  /**
   * 打印复选框选中行
   */
  PRINT_CHECKBOX_ROW: function PRINT_CHECKBOX_ROW(params) {
    var $table = params.$table,
        menu = params.menu;
    var opts = {
      data: $table.getCheckboxRecords()
    };
    $table.print(_xeUtils["default"].assign(opts, menu.params));
  },

  /**
   * 打开查找功能
   */
  OPEN_FIND: function OPEN_FIND(params) {
    var $event = params.$event,
        $table = params.$table;
    $table.triggerFNROpenEvent($event, 'find');
  },

  /**
   * 打开替换功能
   */
  OPEN_REPLACE: function OPEN_REPLACE(params) {
    var $event = params.$event,
        $table = params.$table;
    $table.triggerFNROpenEvent($event, 'replace');
  },

  /**
   * 隐藏当前列
   */
  HIDDEN_COLUMN: function HIDDEN_COLUMN(params) {
    var $table = params.$table,
        column = params.column;

    if (column) {
      $table.hideColumn(column);
    }
  },

  /**
   * 将列固定到左侧
   */
  FIXED_LEFT_COLUMN: handleFixedColumn('left'),

  /**
   * 将列固定到右侧
   */
  FIXED_RIGHT_COLUMN: handleFixedColumn('right'),

  /**
   * 清除固定列
   */
  CLEAR_FIXED_COLUMN: handleFixedColumn(''),

  /**
   * 重置列的可视状态
   */
  RESET_COLUMN: function RESET_COLUMN(params) {
    var $table = params.$table;
    $table.resetColumn({
      visible: true,
      resizable: false
    });
  },

  /**
   * 重置列宽状态
   */
  RESET_RESIZABLE: function RESET_RESIZABLE(params) {
    var $table = params.$table;
    $table.resetColumn({
      visible: false,
      resizable: true
    });
  },

  /**
   * 重置列的所有状态
   */
  RESET_ALL: function RESET_ALL(params) {
    var $table = params.$table;
    $table.resetColumn(true);
  }
};

function checkPrivilege(item, params) {
  var code = item.code;
  var $table = params.$table,
      columns = params.columns,
      row = params.row,
      column = params.column;
  var editConfig = $table.editConfig,
      mouseConfig = $table.mouseConfig,
      mouseOpts = $table.mouseOpts,
      fnrOpts = $table.fnrOpts;

  switch (code) {
    case 'CLEAR_ALL_SORT':
      {
        var sortList = $table.getSortColumns();
        item.disabled = !sortList.length;
        break;
      }

    case 'CLEAR_ALL_FILTER':
      {
        var filterList = $table.getCheckedFilters();
        item.disabled = !filterList.length;
        break;
      }

    case 'CLEAR_ALL_MERGE':
      {
        var mergeCells = $table.getMergeCells();
        var mergeFooterItems = $table.getMergeFooterItems();
        item.disabled = !mergeCells.length && !mergeFooterItems.length;
        break;
      }

    case 'CLEAR_MERGE_CELL':
      {
        var beenMerges = getBeenMerges(params);
        item.disabled = !beenMerges.length;
        break;
      }

    case 'EDIT_ROW':
      {
        item.disabled = !editConfig || !columns.some(function (column) {
          return column.editRender;
        });
        break;
      }

    case 'EDIT_CELL':
    case 'CLEAR_CELL':
    case 'CLEAR_ROW':
    case 'COPY_CELL':
    case 'CUT_CELL':
    case 'PASTE_CELL':
    case 'MERGE_OR_CLEAR':
    case 'MERGE_CELL':
    case 'REVERT_CELL':
    case 'REVERT_ROW':
    case 'INSERT_AT_ROW':
    case 'INSERT_AT_ACTIVED_ROW':
    case 'DELETE_ROW':
    case 'CLEAR_SORT':
    case 'SORT_ASC':
    case 'SORT_DESC':
    case 'CLEAR_FILTER':
    case 'FILTER_CELL':
    case 'EXPORT_ROW':
    case 'OPEN_FIND':
    case 'OPEN_REPLACE':
    case 'HIDDEN_COLUMN':
    case 'FIXED_LEFT_COLUMN':
    case 'FIXED_RIGHT_COLUMN':
    case 'CLEAR_FIXED_COLUMN':
      {
        item.disabled = !column;

        if (column) {
          var isChildCol = !!column.parentId;

          switch (code) {
            case 'CLEAR_SORT':
              {
                item.disabled = !column.sortable || !column.order;
                break;
              }

            case 'SORT_ASC':
            case 'SORT_DESC':
              {
                item.disabled = !column.sortable;
                break;
              }

            case 'FILTER_CELL':
            case 'CLEAR_FILTER':
              {
                item.disabled = !column.filters || !column.filters.length;

                if (!item.disabled) {
                  switch (code) {
                    case 'CLEAR_FILTER':
                      item.disabled = !column.filters.some(function (option) {
                        return option.checked;
                      });
                      break;
                  }
                }

                break;
              }

            case 'REVERT_CELL':
              {
                item.disabled = !row || !column.property || !$table.isUpdateByRow(row, column.property);
                break;
              }

            case 'REVERT_ROW':
              {
                item.disabled = !row || !column.property || !$table.isUpdateByRow(row);
                break;
              }

            case 'OPEN_FIND':
              {
                item.disabled = !(fnrOpts && mouseConfig && mouseOpts.area && fnrOpts.isFind);
                break;
              }

            case 'OPEN_REPLACE':
              {
                item.disabled = !(fnrOpts && mouseConfig && mouseOpts.area && fnrOpts.isReplace);
                break;
              }

            case 'EDIT_CELL':
              {
                item.disabled = !editConfig || !column.editRender;
                break;
              }

            case 'COPY_CELL':
            case 'CUT_CELL':
            case 'PASTE_CELL':
              {
                var cellAreas = mouseConfig && mouseOpts.area ? $table.getCellAreas() : [];
                item.disabled = cellAreas.length > 1;

                if (!item.disabled) {
                  switch (code) {
                    case 'PASTE_CELL':
                      var $vxe = $table.$vxe;
                      var clipboard = $vxe.clipboard;
                      item.disabled = !clipboard || !clipboard.text;
                      break;
                  }
                }

                break;
              }

            case 'MERGE_OR_CLEAR':
            case 'MERGE_CELL':
              {
                var _cellAreas = mouseConfig && mouseOpts.area ? $table.getCellAreas() : [];

                item.disabled = !_cellAreas.length || _cellAreas.length === 1 && _cellAreas[0].rows.length === 1 && _cellAreas[0].cols.length === 1 || !checkCellOverlay(params, _cellAreas);
                break;
              }

            case 'FIXED_LEFT_COLUMN':
              item.disabled = isChildCol || column.fixed === 'left';
              break;

            case 'FIXED_RIGHT_COLUMN':
              item.disabled = isChildCol || column.fixed === 'right';
              break;

            case 'CLEAR_FIXED_COLUMN':
              item.disabled = isChildCol || !column.fixed;
              break;
          }
        }

        break;
      }
  }
}

function handlePrivilegeEvent(params) {
  params.options.forEach(function (list) {
    list.forEach(function (item) {
      checkPrivilege(item, params);

      if (item.children) {
        item.children.forEach(function (child) {
          checkPrivilege(child, params);
        });
      }
    });
  });
  return true;
}

function setup(options) {
  if (options && options.copy) {
    handleCopy = options.copy;
  }
}
/**
 * 基于 vxe-table 表格的增强插件，提供实用的快捷菜单集
 */


var VXETablePluginMenus = {
  setup: setup,
  install: function install(_ref9, options) {
    var interceptor = _ref9.interceptor,
        menus = _ref9.menus;
    setup(options);
    interceptor.add('event.showMenu', handlePrivilegeEvent);
    menus.mixin(menuMap);
  }
};
exports.VXETablePluginMenus = VXETablePluginMenus;

if (typeof window !== 'undefined' && window.VXETable && window.VXETable.use) {
  window.VXETable.use(VXETablePluginMenus);
}

var _default = VXETablePluginMenus;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
