(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define("vxe-table-plugin-menus", ["exports", "xe-utils"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("xe-utils"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.XEUtils);
    global.VXETablePluginMenus = mod.exports;
  }
})(typeof globalThis !== "undefined" ? globalThis : typeof self !== "undefined" ? self : this, function (_exports, _xeUtils) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports["default"] = _exports.VXETablePluginMenus = void 0;
  _xeUtils = _interopRequireDefault(_xeUtils);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

  var vxetable;
  var handleCopy;

  var columnIndexOf = function columnIndexOf(cols, column) {
    return _xeUtils["default"].findIndexOf(cols, function (item) {
      return item.id === column.id;
    });
  };

  var rowIndexOf = function rowIndexOf($table, rows, row) {
    return $table.findRowIndexOf(rows, row);
  };

  function handleFixedColumn(fixed) {
    return function (params) {
      var $table = params.$table,
          column = params.column;

      _xeUtils["default"].eachTree([column], function (column) {
        column.fixed = fixed;
      });

      $table.refreshColumn();
    };
  }

  function handleCopyOrCut(params, isCut) {
    var $event = params.$event,
        $table = params.$table,
        row = params.row,
        column = params.column;

    if (row && column) {
      var props = $table.props;
      var mouseConfig = props.mouseConfig;

      var _$table$getComputeMap = $table.getComputeMaps(),
          computeMouseOpts = _$table$getComputeMap.computeMouseOpts;

      var mouseOpts = computeMouseOpts.value;
      var text = '';

      if (mouseConfig && mouseOpts.area) {
        if (isCut) {
          $table.triggerCutCellAreaEvent($event);
        } else {
          $table.triggerCopyCellAreaEvent($event);
        }

        text = vxetable.config.clipboard.text;
      } else {
        text = _xeUtils["default"].toValueString(_xeUtils["default"].get(row, column.property)); // 操作内置剪贴板

        vxetable.config.clipboard = {
          text: text,
          html: ''
        };
      } // 开始复制操作


      if (_xeUtils["default"].isFunction(handleCopy)) {
        handleCopy(text);
      } else {
        console.warn('Copy function does not exist, copy to clipboard failed.');
      }
    }
  }

  function checkCellOverlay(params, cellAreas) {
    var $table = params.$table;

    var _$table$getTableData = $table.getTableData(),
        visibleData = _$table$getTableData.visibleData;

    var _$table$getTableColum = $table.getTableColumn(),
        visibleColumn = _$table$getTableColum.visibleColumn;

    var indexMaps = {};

    for (var aIndex = 0, areaSize = cellAreas.length; aIndex < areaSize; aIndex++) {
      var areaItem = cellAreas[aIndex];
      var rows = areaItem.rows,
          cols = areaItem.cols;

      for (var rIndex = 0, rowSize = rows.length; rIndex < rowSize; rIndex++) {
        var offsetRow = rows[rIndex];
        var orIndex = rowIndexOf($table, visibleData, offsetRow);

        for (var cIndex = 0, colSize = cols.length; cIndex < colSize; cIndex++) {
          var offsetColumn = cols[cIndex];
          var ocIndex = columnIndexOf(visibleColumn, offsetColumn);
          var key = orIndex + ':' + ocIndex;

          if (indexMaps[key]) {
            return false;
          }

          indexMaps[key] = true;
        }
      }
    }

    return true;
  }

  function getBeenMerges(params) {
    var $table = params.$table;
    var props = $table.props;
    var mouseConfig = props.mouseConfig;

    var _$table$getComputeMap2 = $table.getComputeMaps(),
        computeMouseOpts = _$table$getComputeMap2.computeMouseOpts;

    var mouseOpts = computeMouseOpts.value;

    var _$table$getTableData2 = $table.getTableData(),
        visibleData = _$table$getTableData2.visibleData;

    var _$table$getTableColum2 = $table.getTableColumn(),
        visibleColumn = _$table$getTableColum2.visibleColumn;

    var cellAreas = mouseConfig && mouseOpts.area ? $table.getCellAreas() : [];
    var mergeList = $table.getMergeCells();
    return mergeList.filter(function (_ref) {
      var mergeRowIndex = _ref.row,
          mergeColIndex = _ref.col,
          mergeRowspan = _ref.rowspan,
          mergeColspan = _ref.colspan;
      return cellAreas.some(function (areaItem) {
        var rows = areaItem.rows,
            cols = areaItem.cols;
        var startRowIndex = rowIndexOf($table, visibleData, rows[0]);
        var endRowIndex = rowIndexOf($table, visibleData, rows[rows.length - 1]);
        var startColIndex = columnIndexOf(visibleColumn, cols[0]);
        var endColIndex = columnIndexOf(visibleColumn, cols[cols.length - 1]);
        return mergeRowIndex >= startRowIndex && mergeRowIndex + mergeRowspan - 1 <= endRowIndex && mergeColIndex >= startColIndex && mergeColIndex + mergeColspan - 1 <= endColIndex;
      });
    });
  }

  function handleClearMergeCells(params) {
    var $table = params.$table;
    var beenMerges = getBeenMerges(params);

    if (beenMerges.length) {
      $table.removeMergeCells(beenMerges);
    }

    return beenMerges;
  }

  function checkPrivilege(item, params) {
    var code = item.code;
    var $table = params.$table,
        row = params.row,
        column = params.column;
    var props = $table.props;
    var editConfig = props.editConfig,
        mouseConfig = props.mouseConfig;

    switch (code) {
      case 'CLEAR_ALL_SORT':
        {
          var sortList = $table.getSortColumns();
          item.disabled = !sortList.length;
          break;
        }

      case 'CLEAR_ALL_FILTER':
        {
          var filterList = $table.getCheckedFilters();
          item.disabled = !filterList.length;
          break;
        }

      case 'CLEAR_ALL_MERGE':
        {
          var mergeCells = $table.getMergeCells();
          var mergeFooterItems = $table.getMergeFooterItems();
          item.disabled = !mergeCells.length && !mergeFooterItems.length;
          break;
        }

      case 'CLEAR_MERGE_CELL':
        {
          var beenMerges = getBeenMerges(params);
          item.disabled = !beenMerges.length;
          break;
        }

      case 'EDIT_CELL':
      case 'CLEAR_CELL':
      case 'CLEAR_ROW':
      case 'COPY_CELL':
      case 'CUT_CELL':
      case 'PASTE_CELL':
      case 'MERGE_OR_CLEAR':
      case 'MERGE_CELL':
      case 'REVERT_CELL':
      case 'REVERT_ROW':
      case 'INSERT_AT_ROW':
      case 'INSERT_AT_ACTIVED_ROW':
      case 'DELETE_ROW':
      case 'CLEAR_SORT':
      case 'SORT_ASC':
      case 'SORT_DESC':
      case 'CLEAR_FILTER':
      case 'FILTER_CELL':
      case 'EXPORT_ROW':
      case 'OPEN_FIND':
      case 'OPEN_REPLACE':
      case 'HIDDEN_COLUMN':
      case 'FIXED_LEFT_COLUMN':
      case 'FIXED_RIGHT_COLUMN':
      case 'CLEAR_FIXED_COLUMN':
        {
          item.disabled = !column;

          if (column) {
            var _$table$getComputeMap3 = $table.getComputeMaps(),
                computeMouseOpts = _$table$getComputeMap3.computeMouseOpts;

            var mouseOpts = computeMouseOpts.value;
            var isChildCol = !!column.parentId;

            switch (code) {
              case 'CLEAR_SORT':
                {
                  item.disabled = !column.sortable || !column.order;
                  break;
                }

              case 'SORT_ASC':
              case 'SORT_DESC':
                item.disabled = !column.sortable;
                break;

              case 'FILTER_CELL':
              case 'CLEAR_FILTER':
                item.disabled = !column.filters || !column.filters.length;

                if (!item.disabled) {
                  switch (code) {
                    case 'CLEAR_FILTER':
                      item.disabled = !column.filters.some(function (option) {
                        return option.checked;
                      });
                      break;
                  }
                }

                break;

              case 'REVERT_CELL':
                {
                  item.disabled = !row || !column.property || !$table.isUpdateByRow(row, column.property);
                  break;
                }

              case 'REVERT_ROW':
                {
                  item.disabled = !row || !column.property || !$table.isUpdateByRow(row);
                  break;
                }

              case 'OPEN_FIND':
              case 'OPEN_REPLACE':
                {
                  item.disabled = !(mouseConfig && mouseOpts.area);
                  break;
                }

              case 'EDIT_CELL':
                {
                  item.disabled = !editConfig || !column.editRender;
                  break;
                }

              case 'COPY_CELL':
              case 'CUT_CELL':
              case 'PASTE_CELL':
                {
                  var cellAreas = mouseConfig && mouseOpts.area ? $table.getCellAreas() : [];
                  item.disabled = cellAreas.length > 1;

                  if (!item.disabled) {
                    switch (code) {
                      case 'PASTE_CELL':
                        var clipboard = vxetable.config.clipboard;
                        item.disabled = !clipboard || !clipboard.text;
                        break;
                    }
                  }

                  break;
                }

              case 'MERGE_OR_CLEAR':
              case 'MERGE_CELL':
                {
                  var _cellAreas = mouseConfig && mouseOpts.area ? $table.getCellAreas() : [];

                  item.disabled = !_cellAreas.length || _cellAreas.length === 1 && _cellAreas[0].rows.length === 1 && _cellAreas[0].cols.length === 1 || !checkCellOverlay(params, _cellAreas);
                  break;
                }

              case 'FIXED_LEFT_COLUMN':
                item.disabled = isChildCol || column.fixed === 'left';
                break;

              case 'FIXED_RIGHT_COLUMN':
                item.disabled = isChildCol || column.fixed === 'right';
                break;

              case 'CLEAR_FIXED_COLUMN':
                item.disabled = isChildCol || !column.fixed;
                break;
            }
          }

          break;
        }
    }
  }

  function handlePrivilegeEvent(params) {
    params.options.forEach(function (list) {
      list.forEach(function (item) {
        checkPrivilege(item, params);

        if (item.children) {
          item.children.forEach(function (child) {
            checkPrivilege(child, params);
          });
        }
      });
    });
    return true;
  }

  function pluginSetup(options) {
    if (options && options.copy) {
      handleCopy = options.copy;
    }
  }
  /**
   * 基于 vxe-table 表格的增强插件，提供实用的快捷菜单集
   */


  var VXETablePluginMenus = {
    setup: pluginSetup,
    install: function install(vxetablecore, options) {
      var interceptor = vxetablecore.interceptor,
          menus = vxetablecore.menus;
      vxetable = vxetablecore;

      if (window.XEClipboard) {
        handleCopy = window.XEClipboard.copy;
      }

      pluginSetup(options);
      menus.mixin({
        /**
         * 清除单元格数据的值；如果启用 mouse-config.area 功能，则清除区域范围内的单元格数据
         */
        CLEAR_CELL: function CLEAR_CELL(params) {
          var $table = params.$table,
              row = params.row,
              column = params.column;

          if (row && column) {
            var props = $table.props;
            var mouseConfig = props.mouseConfig;

            var _$table$getComputeMap4 = $table.getComputeMaps(),
                computeMouseOpts = _$table$getComputeMap4.computeMouseOpts;

            var mouseOpts = computeMouseOpts.value;

            if (mouseConfig && mouseOpts.area) {
              var cellAreas = $table.getCellAreas();

              if (cellAreas && cellAreas.length) {
                cellAreas.forEach(function (areaItem) {
                  var rows = areaItem.rows,
                      cols = areaItem.cols;
                  cols.forEach(function (column) {
                    rows.forEach(function (row) {
                      $table.clearData(row, column.property);
                    });
                  });
                });
              }
            } else {
              $table.clearData(row, column.property);
            }
          }
        },

        /**
         * 清除行数据的值
         */
        CLEAR_ROW: function CLEAR_ROW(params) {
          var $table = params.$table,
              row = params.row;

          if (row) {
            $table.clearData(row);
          }
        },

        /**
         * 清除复选框选中行数据的值
         */
        CLEAR_CHECKBOX_ROW: function CLEAR_CHECKBOX_ROW(params) {
          var $table = params.$table;
          $table.clearData($table.getCheckboxRecords());
        },

        /**
         * 清除所有数据的值
         */
        CLEAR_ALL: function CLEAR_ALL(params) {
          var $table = params.$table;
          $table.clearData();
        },

        /**
         * 还原单元格数据的值；如果启用 mouse-config.area 功能，则还原区域范围内的单元格数据
         */
        REVERT_CELL: function REVERT_CELL(params) {
          var $table = params.$table,
              row = params.row,
              column = params.column;

          if (row && column) {
            var props = $table.props;
            var mouseConfig = props.mouseConfig;

            var _$table$getComputeMap5 = $table.getComputeMaps(),
                computeMouseOpts = _$table$getComputeMap5.computeMouseOpts;

            var mouseOpts = computeMouseOpts.value;

            if (mouseConfig && mouseOpts.area) {
              var cellAreas = $table.getCellAreas();

              if (cellAreas && cellAreas.length) {
                cellAreas.forEach(function (areaItem) {
                  var rows = areaItem.rows,
                      cols = areaItem.cols;
                  cols.forEach(function (column) {
                    rows.forEach(function (row) {
                      $table.revertData(row, column.property);
                    });
                  });
                });
              }
            } else {
              $table.revertData(row, column.property);
            }
          }
        },

        /**
         * 还原行数据的值
         */
        REVERT_ROW: function REVERT_ROW(params) {
          var $table = params.$table,
              row = params.row;

          if (row) {
            $table.revertData(row);
          }
        },

        /**
         * 还原复选框选中行数据的值
         */
        REVERT_CHECKBOX_ROW: function REVERT_CHECKBOX_ROW(params) {
          var $table = params.$table;
          $table.revertData($table.getCheckboxRecords());
        },

        /**
         * 还原所有数据的值
         */
        REVERT_ALL: function REVERT_ALL(params) {
          var $table = params.$table;
          $table.revertData();
        },

        /**
         * 复制单元格数据的值；如果启用 mouse-config.area 功能，则复制区域范围内的单元格数据，支持 Excel 和 WPS
         */
        COPY_CELL: function COPY_CELL(params) {
          handleCopyOrCut(params);
        },

        /**
         * 剪贴单元格数据的值；如果启用 mouse-config.area 功能，则剪贴区域范围内的单元格数据，支持 Excel 和 WPS
         */
        CUT_CELL: function CUT_CELL(params) {
          handleCopyOrCut(params, true);
        },

        /**
         * 粘贴从表格中被复制的数据；如果启用 mouse-config.area 功能，则粘贴区域范围内的单元格数据，不支持读取剪贴板
         */
        PASTE_CELL: function PASTE_CELL(params) {
          var $event = params.$event,
              $table = params.$table,
              row = params.row,
              column = params.column;
          var props = $table.props;
          var mouseConfig = props.mouseConfig;

          var _$table$getComputeMap6 = $table.getComputeMaps(),
              computeMouseOpts = _$table$getComputeMap6.computeMouseOpts;

          var mouseOpts = computeMouseOpts.value;

          if (mouseConfig && mouseOpts.area) {
            $table.triggerPasteCellAreaEvent($event);
          } else {
            var clipboard = vxetable.config.clipboard; // 读取内置剪贴板

            if (clipboard && clipboard.text) {
              _xeUtils["default"].set(row, column.property, clipboard.text);
            }
          }
        },

        /**
         * 如果启用 mouse-config.area 功能，如果所选区域内已存在合并单元格，则取消临时合并，否则临时合并
         */
        MERGE_OR_CLEAR: function MERGE_OR_CLEAR(params) {
          var $event = params.$event,
              $table = params.$table;
          var cellAreas = $table.getCellAreas();
          var beenMerges = getBeenMerges(params);
          var status = false;

          if (beenMerges.length) {
            $table.removeMergeCells(beenMerges);
          } else {
            status = true;
            $table.setMergeCells(cellAreas.map(function (_ref2) {
              var rows = _ref2.rows,
                  cols = _ref2.cols;
              return {
                row: rows[0],
                col: cols[0],
                rowspan: rows.length,
                colspan: cols.length
              };
            }));
          }

          var targetAreas = cellAreas.map(function (_ref3) {
            var rows = _ref3.rows,
                cols = _ref3.cols;
            return {
              rows: rows,
              cols: cols
            };
          });
          $table.dispatchEvent('cell-area-merge', {
            status: status,
            targetAreas: targetAreas
          }, $event);
        },

        /**
         * 如果启用 mouse-config.area 功能，临时合并区域范围内的单元格，不管是否存在已合并
         */
        MERGE_CELL: function MERGE_CELL(params) {
          var $event = params.$event,
              $table = params.$table;

          var _$table$getTableData3 = $table.getTableData(),
              visibleData = _$table$getTableData3.visibleData;

          var _$table$getTableColum3 = $table.getTableColumn(),
              visibleColumn = _$table$getTableColum3.visibleColumn;

          var cellAreas = $table.getCellAreas();
          handleClearMergeCells(params);

          if (cellAreas.some(function (_ref4) {
            var rows = _ref4.rows,
                cols = _ref4.cols;
            return rows.length === visibleData.length || cols.length === visibleColumn.length;
          })) {
            if (vxetable.modal) {
              vxetable.modal.message({
                content: vxetable.t('vxe.pro.area.mergeErr'),
                status: 'error',
                id: 'operErr'
              });
            }

            return;
          }

          $table.setMergeCells(cellAreas.map(function (_ref5) {
            var rows = _ref5.rows,
                cols = _ref5.cols;
            return {
              row: rows[0],
              col: cols[0],
              rowspan: rows.length,
              colspan: cols.length
            };
          }));
          var targetAreas = cellAreas.map(function (_ref6) {
            var rows = _ref6.rows,
                cols = _ref6.cols;
            return {
              rows: rows,
              cols: cols
            };
          });
          $table.dispatchEvent('cell-area-merge', {
            status: true,
            targetAreas: targetAreas
          }, $event);
        },

        /**
         * 如果启用 mouse-config.area 功能，清除区域范围内单元格的临时合并状态
         */
        CLEAR_MERGE_CELL: function CLEAR_MERGE_CELL(params) {
          var $event = params.$event,
              $table = params.$table;
          var beenMerges = handleClearMergeCells(params);

          if (beenMerges.length) {
            $table.dispatchEvent('clear-cell-area-merge', {
              mergeCells: beenMerges
            }, $event);
          }
        },

        /**
         * 清除所有单元格及表尾的临时合并状态
         */
        CLEAR_ALL_MERGE: function CLEAR_ALL_MERGE(params) {
          var $event = params.$event,
              $table = params.$table;
          var mergeCells = $table.getMergeCells();
          var mergeFooterItems = $table.getMergeFooterItems();
          $table.clearMergeCells();
          $table.clearMergeFooterItems();
          $table.dispatchEvent('clear-merge', {
            mergeCells: mergeCells,
            mergeFooterItems: mergeFooterItems
          }, $event);
        },

        /**
         * 编辑单元格
         */
        EDIT_CELL: function EDIT_CELL(params) {
          var $table = params.$table,
              row = params.row,
              column = params.column;
          $table.setActiveCell(row, column.property);
        },

        /**
         * 编辑行
         */
        EDIT_ROW: function EDIT_ROW(params) {
          var $table = params.$table,
              row = params.row;
          $table.setActiveRow(row);
        },

        /**
         * 插入数据
         */
        INSERT_ROW: function INSERT_ROW(params) {
          var $table = params.$table,
              menu = params.menu;
          $table.insert(menu.params);
        },

        /**
         * 插入数据并激活编辑状态
         */
        INSERT_ACTIVED_ROW: function INSERT_ACTIVED_ROW(params) {
          var $table = params.$table,
              menu = params.menu,
              column = params.column;
          var args = menu.params || []; // [{}, 'field']

          $table.insert(args[0]).then(function (_ref7) {
            var row = _ref7.row;
            return $table.setActiveCell(row, args[1] || column.property);
          });
        },

        /**
         * 插入数据到指定位置
         */
        INSERT_AT_ROW: function INSERT_AT_ROW(params) {
          var $table = params.$table,
              menu = params.menu,
              row = params.row;

          if (row) {
            $table.insertAt(menu.params, row);
          }
        },

        /**
         * 插入数据到指定位置并激活编辑状态
         */
        INSERT_AT_ACTIVED_ROW: function INSERT_AT_ACTIVED_ROW(params) {
          var $table = params.$table,
              menu = params.menu,
              row = params.row,
              column = params.column;

          if (row) {
            var args = menu.params || []; // [{}, 'field']

            $table.insertAt(args[0], row).then(function (_ref8) {
              var row = _ref8.row;
              return $table.setActiveCell(row, args[1] || column.property);
            });
          }
        },

        /**
         * 移除行数据
         */
        DELETE_ROW: function DELETE_ROW(params) {
          var $table = params.$table,
              row = params.row;

          if (row) {
            $table.remove(row);
          }
        },

        /**
         * 移除复选框选中行数据
         */
        DELETE_CHECKBOX_ROW: function DELETE_CHECKBOX_ROW(params) {
          var $table = params.$table;
          $table.removeCheckboxRow();
        },

        /**
         * 移除所有行数据
         */
        DELETE_ALL: function DELETE_ALL(params) {
          var $table = params.$table;
          $table.remove();
        },

        /**
         * 清除所选列排序条件
         */
        CLEAR_SORT: function CLEAR_SORT(params) {
          var $event = params.$event,
              $table = params.$table,
              column = params.column;

          if (column) {
            $table.triggerSortEvent($event, column, null);
          }
        },

        /**
         * 清除所有排序条件
         */
        CLEAR_ALL_SORT: function CLEAR_ALL_SORT(params) {
          var $event = params.$event,
              $table = params.$table;
          var sortList = $table.getSortColumns();

          if (sortList.length) {
            $table.clearSort();
            $table.dispatchEvent('clear-sort', {
              sortList: sortList
            }, $event);
          }
        },

        /**
         * 按所选列的值升序
         */
        SORT_ASC: function SORT_ASC(params) {
          var $event = params.$event,
              $table = params.$table,
              column = params.column;

          if (column) {
            $table.triggerSortEvent($event, column, 'asc');
          }
        },

        /**
         * 按所选列的值倒序
         */
        SORT_DESC: function SORT_DESC(params) {
          var $event = params.$event,
              $table = params.$table,
              column = params.column;

          if (column) {
            $table.triggerSortEvent($event, column, 'desc');
          }
        },

        /**
         * 清除复选框选中列的筛选条件
         */
        CLEAR_FILTER: function CLEAR_FILTER(params) {
          var $event = params.$event,
              $table = params.$table,
              column = params.column;

          if (column) {
            $table.handleClearFilter(column);
            $table.confirmFilterEvent($event);
          }
        },

        /**
         * 清除所有列筛选条件
         */
        CLEAR_ALL_FILTER: function CLEAR_ALL_FILTER(params) {
          var $event = params.$event,
              $table = params.$table;
          var filterList = $table.getCheckedFilters();

          if (filterList.length) {
            $table.clearFilter();
            $table.dispatchEvent('clear-filter', {
              filterList: filterList
            }, $event);
          }
        },

        /**
         * 根据单元格值筛选
         */
        FILTER_CELL: function FILTER_CELL(params) {
          var $table = params.$table,
              row = params.row,
              column = params.column;

          if (row && column) {
            var property = column.property,
                filters = column.filters;

            if (filters.length) {
              var option = filters[0];
              option.data = _xeUtils["default"].get(row, property);
              option.checked = true;
              $table.updateData();
            }
          }
        },

        /**
         * 导出行数据
         */
        EXPORT_ROW: function EXPORT_ROW(params) {
          var $table = params.$table,
              menu = params.menu,
              row = params.row;

          if (row) {
            var opts = {
              data: [row]
            };
            $table.exportData(_xeUtils["default"].assign(opts, menu.params[0]));
          }
        },

        /**
         * 导出复选框选中行数据
         */
        EXPORT_CHECKBOX_ROW: function EXPORT_CHECKBOX_ROW(params) {
          var $table = params.$table,
              menu = params.menu;
          var opts = {
            data: $table.getCheckboxRecords()
          };
          $table.exportData(_xeUtils["default"].assign(opts, menu.params[0]));
        },

        /**
         * 导出所有行数据
         */
        EXPORT_ALL: function EXPORT_ALL(params) {
          var $table = params.$table,
              menu = params.menu;
          $table.exportData(menu.params);
        },

        /**
         * 打印所有行数据
         */
        PRINT_ALL: function PRINT_ALL(params) {
          var $table = params.$table,
              menu = params.menu;
          $table.print(menu.params);
        },

        /**
         * 打印复选框选中行
         */
        PRINT_CHECKBOX_ROW: function PRINT_CHECKBOX_ROW(params) {
          var $table = params.$table,
              menu = params.menu;
          var opts = {
            data: $table.getCheckboxRecords()
          };
          $table.print(_xeUtils["default"].assign(opts, menu.params));
        },

        /**
         * 打开查找功能
         */
        OPEN_FIND: function OPEN_FIND(params) {
          var $event = params.$event,
              $table = params.$table;
          $table.triggerFNROpenEvent($event, 'find');
        },

        /**
         * 打开替换功能
         */
        OPEN_REPLACE: function OPEN_REPLACE(params) {
          var $event = params.$event,
              $table = params.$table;
          $table.triggerFNROpenEvent($event, 'replace');
        },

        /**
         * 隐藏当前列
         */
        HIDDEN_COLUMN: function HIDDEN_COLUMN(params) {
          var $table = params.$table,
              column = params.column;

          if (column) {
            $table.hideColumn(column);
          }
        },

        /**
         * 将列固定到左侧
         */
        FIXED_LEFT_COLUMN: handleFixedColumn('left'),

        /**
         * 将列固定到右侧
         */
        FIXED_RIGHT_COLUMN: handleFixedColumn('right'),

        /**
         * 清除固定列
         */
        CLEAR_FIXED_COLUMN: handleFixedColumn(null),

        /**
         * 重置列的可视状态
         */
        RESET_COLUMN: function RESET_COLUMN(params) {
          var $table = params.$table;
          $table.resetColumn({
            visible: true,
            resizable: false
          });
        },

        /**
         * 重置列宽状态
         */
        RESET_RESIZABLE: function RESET_RESIZABLE(params) {
          var $table = params.$table;
          $table.resetColumn({
            visible: false,
            resizable: true
          });
        },

        /**
         * 重置列的所有状态
         */
        RESET_ALL: function RESET_ALL(params) {
          var $table = params.$table;
          $table.resetColumn(true);
        }
      });
      interceptor.add('event.showMenu', handlePrivilegeEvent);
    }
  };
  _exports.VXETablePluginMenus = VXETablePluginMenus;

  if (typeof window !== 'undefined' && window.VXETable && window.VXETable.use) {
    window.VXETable.use(VXETablePluginMenus);
  }

  var _default = VXETablePluginMenus;
  _exports["default"] = _default;
});