(function (global, factory) {
  if (typeof define === "function" && define.amd) {
    define("vxe-table-plugin-renderer", ["exports", "xe-utils"], factory);
  } else if (typeof exports !== "undefined") {
    factory(exports, require("xe-utils"));
  } else {
    var mod = {
      exports: {}
    };
    factory(mod.exports, global.XEUtils);
    global.VXETablePluginRenderer = mod.exports.default;
  }
})(typeof globalThis !== "undefined" ? globalThis : typeof self !== "undefined" ? self : this, function (_exports, _xeUtils) {
  "use strict";

  Object.defineProperty(_exports, "__esModule", {
    value: true
  });
  _exports["default"] = _exports.VXETablePluginRenderer = void 0;
  _xeUtils = _interopRequireDefault(_xeUtils);

  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

  function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

  var defaultColors = ['#2F4554', '#C23531', '#61A0A8', '#D48265', '#91C7AE', '#749F83', '#CA8622', '#006699', '#BDA29A', '#546570'];
  var tmplOpts = {
    tmplRE: /\{([.\w[\]\s]+)\}/g
  };

  function getDefaultColor(index) {
    return defaultColors[index % 10];
  }

  function toRGBLight(color, level) {
    var rgbs = color.match(/(\d{1,3}),\s?(\d{1,3}),\s?(\d{1,3})(,\s?(\d{1,3}))?/);

    if (rgbs) {
      var r = parseInt(rgbs[1]);
      var g = parseInt(rgbs[2]);
      var b = parseInt(rgbs[3]);
      var alpha = parseInt(rgbs[5]);
      return "rgb(".concat(r + level, ",").concat(g + level, ",").concat(b + level).concat(alpha ? ",".concat(alpha) : '', ")");
    }

    return null;
  }

  function getStyleUnit(val) {
    return _xeUtils["default"].isNumber(val) ? "".concat(val, "px") : val;
  }

  function showTooltip(elem, params, formatter, value) {
    var row = params.row,
        column = params.column,
        $table = params.$table;
    var content = _xeUtils["default"].isString(formatter) ? _xeUtils["default"].template(formatter, {
      value: value,
      row: row,
      column: column
    }, tmplOpts) : null;
    $table.openTooltip(elem, content);
  }

  function hideTooltip(elem, params) {
    var $table = params.$table;

    if ($table) {
      $table.closeTooltip();
    }
  }

  function createBarVNs(h, params, renderOpts) {
    var row = params.row,
        column = params.column;
    var _renderOpts$props = renderOpts.props,
        props = _renderOpts$props === void 0 ? {} : _renderOpts$props;
    var margin = props.margin,
        _props$colors = props.colors,
        colors = _props$colors === void 0 ? [] : _props$colors,
        _props$bar = props.bar,
        bar = _props$bar === void 0 ? {} : _props$bar,
        _props$label = props.label,
        barLabel = _props$label === void 0 ? {} : _props$label,
        _props$tooltip = props.tooltip,
        tooltip = _props$tooltip === void 0 ? {} : _props$tooltip;
    var max = bar.max;
    var barHeight = getStyleUnit(bar.width);
    var cellValue = row[column.property];

    if (!_xeUtils["default"].isArray(cellValue)) {
      cellValue = [cellValue];
    }

    var numList = [];
    var maxVal = 0;
    cellValue.forEach(function (num) {
      num = _xeUtils["default"].toNumber(num);
      maxVal = Math.max(maxVal, num);
      numList.push(num);
    });
    var ratio = Math.max(_xeUtils["default"].toNumber(max), maxVal) / 100;
    var barList = numList.map(function (num) {
      return parseInt("".concat(num / ratio));
    });
    return barList.map(function (barValue, index) {
      var labelPosition;

      if (barValue < 30) {
        labelPosition = 'outer';
      } else if (barValue > 70) {
        labelPosition = 'inner';
      }

      return h('span', {
        "class": ['vxe-renderer-bar', _defineProperty({}, "label--".concat(labelPosition), labelPosition)],
        style: {
          margin: getStyleUnit(margin),
          height: barHeight,
          lineHeight: barHeight
        }
      }, [h('span', {
        "class": 'vxe-renderer-bar--chart',
        style: {
          width: "".concat(barValue, "%"),
          backgroundColor: colors[index] || getDefaultColor(index)
        },
        on: {
          mouseenter: function mouseenter(evnt) {
            var elem = evnt.currentTarget;
            var hoverColor = toRGBLight(elem.style.backgroundColor, 10);

            if (hoverColor) {
              elem.style.backgroundColor = hoverColor;
            }

            if (tooltip.formatter) {
              showTooltip(elem, params, tooltip.formatter, numList[index]);
            }
          },
          mouseleave: function mouseleave(evnt) {
            var elem = evnt.currentTarget;
            var reColor = colors[index] || getDefaultColor(index);
            elem.style.backgroundColor = reColor;
            hideTooltip(elem, params);
          }
        }
      }), h('span', {
        "class": 'vxe-renderer-bar--label',
        style: {
          color: barLabel.color
        }
      }, _xeUtils["default"].isString(barLabel.formatter) ? _xeUtils["default"].template(barLabel.formatter, {
        value: numList[index],
        row: row,
        column: column
      }, tmplOpts) : null)]);
    });
  }

  function parsePieAreas(blockList, total) {
    var prves = [];
    var nexts = [];
    var countDeg = 0;
    var ratio = total / 360;
    blockList.forEach(function (item) {
      item.deg = countDeg;
      countDeg += parseInt("".concat(item.val / ratio));

      if (countDeg > 180 && item.deg <= 180) {
        var repairItem = Object.assign({}, item);
        prves.push(repairItem);
        item.deg = 180;
      }

      if (countDeg > 180) {
        nexts.push(item);
      } else {
        prves.push(item);
      }
    });
    return {
      prves: prves,
      nexts: nexts
    };
  }

  function createPieVNs(h, params, renderOptList, cellValue) {
    if (!_xeUtils["default"].isArray(cellValue)) {
      cellValue = [cellValue];
    }

    return renderOptList.map(function (renderOpts, renderIndex) {
      var row = params.row,
          column = params.column;
      var _renderOpts$props2 = renderOpts.props,
          props = _renderOpts$props2 === void 0 ? {} : _renderOpts$props2;
      var margin = props.margin,
          _props$colors2 = props.colors,
          colors = _props$colors2 === void 0 ? [] : _props$colors2,
          _props$ring = props.ring,
          ring = _props$ring === void 0 ? {} : _props$ring,
          _props$label2 = props.label,
          ringLabel = _props$label2 === void 0 ? {} : _props$label2,
          _props$tooltip2 = props.tooltip,
          tooltip = _props$tooltip2 === void 0 ? {} : _props$tooltip2;
      var pieVals = cellValue[renderIndex];
      var pieDiameter = getStyleUnit(props.diameter);
      var ringDiameter = getStyleUnit(ring.diameter);
      var blockList = [];
      var countVal = 0;

      if (!_xeUtils["default"].isArray(pieVals)) {
        pieVals = [pieVals];
      }

      pieVals.forEach(function (val, index) {
        val = _xeUtils["default"].toNumber(val);
        countVal += val;
        blockList.push({
          val: val,
          deg: 0,
          index: index
        });
      });

      var _parsePieAreas = parsePieAreas(blockList, countVal),
          prveList = _parsePieAreas.prves,
          nextList = _parsePieAreas.nexts;

      var blockOns = {
        mouseenter: function mouseenter(evnt) {
          var elem = evnt.currentTarget;

          var index = _xeUtils["default"].toNumber(elem.getAttribute('block'));

          var hoverColor = toRGBLight(elem.style.backgroundColor, 10);

          if (hoverColor) {
            _xeUtils["default"].arrayEach(elem.parentNode.parentNode.querySelectorAll(".block-".concat(index)), function (elem) {
              elem.style.backgroundColor = hoverColor;
            });
          }

          if (tooltip.formatter) {
            showTooltip(elem, params, tooltip.formatter, blockList[index].val);
          }
        },
        mouseleave: function mouseleave(evnt) {
          var elem = evnt.currentTarget;

          var index = _xeUtils["default"].toNumber(elem.getAttribute('block'));

          var reColor = colors[index] || getDefaultColor(index);

          _xeUtils["default"].arrayEach(elem.parentNode.parentNode.querySelectorAll(".block-".concat(index)), function (elem) {
            elem.style.backgroundColor = reColor;
          });

          hideTooltip(elem, params);
        }
      };
      var pieVNs = [h('span', {
        "class": 'vxe-renderer-pie--next-half'
      }, nextList.map(function (item) {
        return h('span', {
          "class": ['vxe-renderer-pie--block', "block-".concat(item.index)],
          style: {
            backgroundColor: colors[item.index] || getDefaultColor(item.index),
            transform: "rotate(".concat(item.deg - 180, "deg)")
          },
          attrs: {
            block: item.index
          },
          on: blockOns
        });
      })), h('span', {
        "class": 'vxe-renderer-pie--prve-half'
      }, prveList.map(function (item) {
        return h('span', {
          "class": ['vxe-renderer-pie--block', "block-".concat(item.index)],
          style: {
            backgroundColor: colors[item.index] || getDefaultColor(item.index),
            transform: "rotate(".concat(item.deg, "deg)")
          },
          attrs: {
            block: item.index
          },
          on: blockOns
        });
      }))];

      if (ringDiameter) {
        pieVNs.push(h('span', {
          "class": 'vxe-renderer-pie--ring-bg',
          style: {
            width: ringDiameter,
            height: ringDiameter,
            backgroundColor: ring.color
          }
        }), h('span', {
          "class": 'vxe-renderer-pie--ring-label',
          style: {
            color: ringLabel.color
          }
        }, _xeUtils["default"].isString(ringLabel.formatter) ? _xeUtils["default"].template(ringLabel.formatter, {
          value: row[column.property] || [],
          row: row,
          column: column
        }, tmplOpts) : null));
      }

      return h('span', {
        "class": 'vxe-renderer-pie',
        style: {
          margin: getStyleUnit(margin),
          width: pieDiameter,
          height: pieDiameter
        }
      }, pieVNs);
    });
  }
  /**
   * 基于 vxe-table 表格的增强插件，提供一些常用的渲染器
   */


  var VXETablePluginRenderer = {
    install: function install(xtable) {
      xtable.renderer.mixin({
        bar: {
          renderDefault: function renderDefault(h, renderOpts, params) {
            return createBarVNs(h, params, renderOpts);
          }
        },
        pie: {
          renderDefault: function renderDefault(h, renderOpts, params) {
            var row = params.row,
                column = params.column;
            var cellValue = row[column.property];
            return createPieVNs(h, params, [renderOpts], cellValue ? [cellValue] : []);
          }
        },
        pies: {
          renderDefault: function renderDefault(h, renderOpts, params) {
            var row = params.row,
                column = params.column;
            var cellValue = row[column.property];
            return createPieVNs(h, params, renderOpts.children || [], cellValue);
          }
        },
        rate: {
          renderDefault: function renderDefault(h, renderOpts, params) {
            var row = params.row,
                column = params.column;
            var _renderOpts$props3 = renderOpts.props,
                props = _renderOpts$props3 === void 0 ? {} : _renderOpts$props3;
            var _props$colors3 = props.colors,
                colors = _props$colors3 === void 0 ? [] : _props$colors3;

            var cellValue = _xeUtils["default"].toNumber(row[column.property]);

            var rateVNs = [];
            var lastColor;

            _xeUtils["default"].range(0, _xeUtils["default"].toNumber(props.count) || 5).forEach(function (obj, index) {
              var itemIndex = index + 1;
              var isActive = cellValue >= itemIndex;
              var itemColor;

              if (isActive) {
                if (colors[itemIndex]) {
                  lastColor = colors[itemIndex];
                }

                itemColor = lastColor || '#F7BA2A';
              } else {
                itemColor = colors[0] || '#E9E9E9';
              }

              var itemOns = {
                mouseenter: function mouseenter(evnt) {
                  var elem = evnt.currentTarget;
                  var hoverColor = toRGBLight(elem.style.color, 10);

                  if (hoverColor) {
                    elem.style.color = hoverColor;
                  }
                },
                mouseleave: function mouseleave(evnt) {
                  var elem = evnt.currentTarget;
                  elem.style.color = itemColor;
                }
              };
              rateVNs.push(h('span', {
                "class": 'vxe-renderer-rate-item',
                style: {
                  color: itemColor
                },
                on: isActive ? itemOns : {}
              }));
            });

            return [h('div', {
              "class": 'vxe-renderer-rate'
            }, rateVNs)];
          }
        }
      });
    }
  };
  _exports.VXETablePluginRenderer = VXETablePluginRenderer;

  if (typeof window !== 'undefined' && window.VXETable && window.VXETable.use) {
    window.VXETable.use(VXETablePluginRenderer);
  }

  var _default = VXETablePluginRenderer;
  _exports["default"] = _default;
});