"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.VXETablePluginRenderer = void 0;

var _vue = require("vue");

var _xeUtils = _interopRequireDefault(require("xe-utils"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var defaultColors = ['#2F4554', '#C23531', '#61A0A8', '#D48265', '#91C7AE', '#749F83', '#CA8622', '#006699', '#BDA29A', '#546570'];
var tmplOpts = {
  tmplRE: /\{([.\w[\]\s]+)\}/g
};

function getDefaultColor(index) {
  return defaultColors[index % 10];
}

function toRGBLight(color, level) {
  var rgbs = color.match(/(\d{1,3}),\s?(\d{1,3}),\s?(\d{1,3})(,\s?(\d{1,3}))?/);

  if (rgbs) {
    var r = parseInt(rgbs[1]);
    var g = parseInt(rgbs[2]);
    var b = parseInt(rgbs[3]);
    var alpha = parseInt(rgbs[5]);
    return "rgb(".concat(r + level, ",").concat(g + level, ",").concat(b + level).concat(alpha ? ",".concat(alpha) : '', ")");
  }

  return null;
}

function getStyleUnit(val) {
  return _xeUtils["default"].isNumber(val) ? "".concat(val, "px") : val;
}

function showTooltip(elem, params, formatter, value) {
  var row = params.row,
      column = params.column,
      $table = params.$table;
  var content = _xeUtils["default"].isString(formatter) ? _xeUtils["default"].template(formatter, {
    value: value,
    row: row,
    column: column
  }, tmplOpts) : null;
  $table.openTooltip(elem, content || '');
}

function hideTooltip(elem, params) {
  var $table = params.$table;

  if ($table) {
    $table.closeTooltip();
  }
}

function createBarVNs(params, renderOpts) {
  var row = params.row,
      column = params.column;
  var _renderOpts$props = renderOpts.props,
      props = _renderOpts$props === void 0 ? {} : _renderOpts$props;
  var margin = props.margin,
      _props$colors = props.colors,
      colors = _props$colors === void 0 ? [] : _props$colors,
      _props$bar = props.bar,
      bar = _props$bar === void 0 ? {} : _props$bar,
      _props$label = props.label,
      barLabel = _props$label === void 0 ? {} : _props$label,
      _props$tooltip = props.tooltip,
      tooltip = _props$tooltip === void 0 ? {} : _props$tooltip;
  var max = bar.max;
  var barHeight = getStyleUnit(bar.width);
  var cellValue = row[column.property];

  if (!_xeUtils["default"].isArray(cellValue)) {
    cellValue = [cellValue];
  }

  var numList = [];
  var maxVal = 0;
  cellValue.forEach(function (num) {
    num = _xeUtils["default"].toNumber(num);
    maxVal = Math.max(maxVal, num);
    numList.push(num);
  });
  var ratio = Math.max(_xeUtils["default"].toNumber(max), maxVal) / 100;
  var barList = numList.map(function (num) {
    return parseInt("".concat(num / ratio));
  });
  return barList.map(function (barValue, index) {
    var labelPosition;

    if (barValue < 30) {
      labelPosition = 'outer';
    } else if (barValue > 70) {
      labelPosition = 'inner';
    }

    return (0, _vue.h)('span', {
      "class": ['vxe-renderer-bar', _defineProperty({}, "label--".concat(labelPosition), labelPosition)],
      style: {
        margin: getStyleUnit(margin),
        height: barHeight,
        lineHeight: barHeight
      }
    }, [(0, _vue.h)('span', {
      "class": 'vxe-renderer-bar--chart',
      style: {
        width: "".concat(barValue, "%"),
        backgroundColor: colors[index] || getDefaultColor(index)
      },
      onMouseenter: function onMouseenter(evnt) {
        var elem = evnt.currentTarget;
        var hoverColor = toRGBLight(elem.style.backgroundColor, 10);

        if (hoverColor) {
          elem.style.backgroundColor = hoverColor;
        }

        if (tooltip.formatter) {
          showTooltip(elem, params, tooltip.formatter, numList[index]);
        }
      },
      onMouseleave: function onMouseleave(evnt) {
        var elem = evnt.currentTarget;
        var reColor = colors[index] || getDefaultColor(index);
        elem.style.backgroundColor = reColor;
        hideTooltip(elem, params);
      }
    }), (0, _vue.h)('span', {
      "class": 'vxe-renderer-bar--label',
      style: {
        color: barLabel.color
      }
    }, _xeUtils["default"].isString(barLabel.formatter) ? _xeUtils["default"].template(barLabel.formatter, {
      value: numList[index],
      row: row,
      column: column
    }, tmplOpts) : '')]);
  });
}

function parsePieAreas(blockList, total) {
  var prves = [];
  var nexts = [];
  var countDeg = 0;
  var ratio = total / 360;
  blockList.forEach(function (item) {
    item.deg = countDeg;
    countDeg += parseInt("".concat(item.val / ratio));

    if (countDeg > 180 && item.deg <= 180) {
      var repairItem = Object.assign({}, item);
      prves.push(repairItem);
      item.deg = 180;
    }

    if (countDeg > 180) {
      nexts.push(item);
    } else {
      prves.push(item);
    }
  });
  return {
    prves: prves,
    nexts: nexts
  };
}

function createPieVNs(params, renderOptList, cellValue) {
  if (!_xeUtils["default"].isArray(cellValue)) {
    cellValue = [cellValue];
  }

  return renderOptList.map(function (renderOpts, renderIndex) {
    var row = params.row,
        column = params.column;
    var _renderOpts$props2 = renderOpts.props,
        props = _renderOpts$props2 === void 0 ? {} : _renderOpts$props2;
    var margin = props.margin,
        _props$colors2 = props.colors,
        colors = _props$colors2 === void 0 ? [] : _props$colors2,
        _props$ring = props.ring,
        ring = _props$ring === void 0 ? {} : _props$ring,
        _props$label2 = props.label,
        ringLabel = _props$label2 === void 0 ? {} : _props$label2,
        _props$tooltip2 = props.tooltip,
        tooltip = _props$tooltip2 === void 0 ? {} : _props$tooltip2;
    var pieVals = cellValue[renderIndex];
    var pieDiameter = getStyleUnit(props.diameter);
    var ringDiameter = getStyleUnit(ring.diameter);
    var blockList = [];
    var countVal = 0;

    if (!_xeUtils["default"].isArray(pieVals)) {
      pieVals = [pieVals];
    }

    pieVals.forEach(function (val, index) {
      val = _xeUtils["default"].toNumber(val);
      countVal += val;
      blockList.push({
        val: val,
        deg: 0,
        index: index
      });
    });

    var _parsePieAreas = parsePieAreas(blockList, countVal),
        prveList = _parsePieAreas.prves,
        nextList = _parsePieAreas.nexts;

    var blockOns = {
      onMouseenter: function onMouseenter(evnt) {
        var elem = evnt.currentTarget;

        var index = _xeUtils["default"].toNumber(elem.getAttribute('block'));

        var hoverColor = toRGBLight(elem.style.backgroundColor, 10);

        if (hoverColor) {
          _xeUtils["default"].arrayEach(elem.parentNode.parentNode.querySelectorAll(".block-".concat(index)), function (elem) {
            elem.style.backgroundColor = hoverColor;
          });
        }

        if (tooltip.formatter) {
          showTooltip(elem, params, tooltip.formatter, blockList[index].val);
        }
      },
      onMouseleave: function onMouseleave(evnt) {
        var elem = evnt.currentTarget;

        var index = _xeUtils["default"].toNumber(elem.getAttribute('block'));

        var reColor = colors[index] || getDefaultColor(index);

        _xeUtils["default"].arrayEach(elem.parentNode.parentNode.querySelectorAll(".block-".concat(index)), function (elem) {
          elem.style.backgroundColor = reColor;
        });

        hideTooltip(elem, params);
      }
    };
    var pieVNs = [(0, _vue.h)('span', {
      "class": 'vxe-renderer-pie--next-half'
    }, nextList.map(function (item) {
      return (0, _vue.h)('span', _objectSpread({
        "class": ['vxe-renderer-pie--block', "block-".concat(item.index)],
        style: {
          backgroundColor: colors[item.index] || getDefaultColor(item.index),
          transform: "rotate(".concat(item.deg - 180, "deg)")
        },
        block: item.index
      }, blockOns));
    })), (0, _vue.h)('span', {
      "class": 'vxe-renderer-pie--prve-half'
    }, prveList.map(function (item) {
      return (0, _vue.h)('span', _objectSpread({
        "class": ['vxe-renderer-pie--block', "block-".concat(item.index)],
        style: {
          backgroundColor: colors[item.index] || getDefaultColor(item.index),
          transform: "rotate(".concat(item.deg, "deg)")
        },
        block: item.index
      }, blockOns));
    }))];

    if (ringDiameter) {
      pieVNs.push((0, _vue.h)('span', {
        "class": 'vxe-renderer-pie--ring-bg',
        style: {
          width: ringDiameter,
          height: ringDiameter,
          backgroundColor: ring.color
        }
      }), (0, _vue.h)('span', {
        "class": 'vxe-renderer-pie--ring-label',
        style: {
          color: ringLabel.color
        }
      }, _xeUtils["default"].isString(ringLabel.formatter) ? _xeUtils["default"].template(ringLabel.formatter, {
        value: row[column.property] || [],
        row: row,
        column: column
      }, tmplOpts) : ''));
    }

    return (0, _vue.h)('span', {
      "class": 'vxe-renderer-pie',
      style: {
        margin: getStyleUnit(margin),
        width: pieDiameter,
        height: pieDiameter
      }
    }, pieVNs);
  });
}
/**
 * 基于 vxe-table 表格的增强插件，提供一些常用的渲染器
 */


var VXETablePluginRenderer = {
  install: function install(vxetablecore) {
    var renderer = vxetablecore.renderer;
    renderer.mixin({
      bar: {
        renderDefault: function renderDefault(renderOpts, params) {
          return createBarVNs(params, renderOpts);
        }
      },
      pie: {
        renderDefault: function renderDefault(renderOpts, params) {
          var row = params.row,
              column = params.column;
          var cellValue = row[column.property];
          return createPieVNs(params, [renderOpts], cellValue ? [cellValue] : []);
        }
      },
      pies: {
        renderDefault: function renderDefault(renderOpts, params) {
          var row = params.row,
              column = params.column;
          var cellValue = row[column.property];
          return createPieVNs(params, renderOpts.children || [], cellValue);
        }
      },
      rate: {
        renderDefault: function renderDefault(renderOpts, params) {
          var row = params.row,
              column = params.column;
          var _renderOpts$props3 = renderOpts.props,
              props = _renderOpts$props3 === void 0 ? {} : _renderOpts$props3;
          var _props$colors3 = props.colors,
              colors = _props$colors3 === void 0 ? [] : _props$colors3;

          var cellValue = _xeUtils["default"].toNumber(row[column.property]);

          var rateVNs = [];
          var lastColor;

          _xeUtils["default"].range(0, _xeUtils["default"].toNumber(props.count) || 5).forEach(function (obj, index) {
            var itemIndex = index + 1;
            var isActive = cellValue >= itemIndex;
            var itemColor;

            if (cellValue >= itemIndex) {
              if (colors[itemIndex]) {
                lastColor = colors[itemIndex];
              }

              itemColor = lastColor || '#F7BA2A';
            } else {
              itemColor = colors[0] || '#E9E9E9';
            }

            var itemOns = isActive ? {
              onMouseenter: function onMouseenter(evnt) {
                var elem = evnt.currentTarget;
                var hoverColor = toRGBLight(elem.style.color, 10);

                if (hoverColor) {
                  elem.style.color = hoverColor;
                }
              },
              onMouseleave: function onMouseleave(evnt) {
                var elem = evnt.currentTarget;
                elem.style.color = itemColor;
              }
            } : {};
            rateVNs.push((0, _vue.h)('span', _objectSpread({
              "class": 'vxe-renderer-rate-item',
              style: {
                color: itemColor
              }
            }, itemOns)));
          });

          return [(0, _vue.h)('div', {
            "class": 'vxe-renderer-rate'
          }, rateVNs)];
        }
      }
    });
  }
};
exports.VXETablePluginRenderer = VXETablePluginRenderer;

if (typeof window !== 'undefined' && window.VXETable) {
  window.VXETable.use(VXETablePluginRenderer);
}

var _default = VXETablePluginRenderer;
exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
