"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderTitle = renderTitle;

var _conf = _interopRequireDefault(require("../../v-x-e-table/src/conf"));

var _vXETable = _interopRequireDefault(require("../../v-x-e-table"));

var _tools = require("../../tools");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function renderPrefixIcon(h, titlePrefix) {
  return h('span', {
    class: 'vxe-form--item-title-prefix'
  }, [h('i', {
    class: titlePrefix.icon || _conf.default.icon.FORM_PREFIX
  })]);
}

function renderSuffixIcon(h, titleSuffix) {
  return h('span', {
    class: 'vxe-form--item-title-suffix'
  }, [h('i', {
    class: titleSuffix.icon || _conf.default.icon.FORM_SUFFIX
  })]);
}

function renderTitle(h, _vm, item) {
  var data = _vm.data;
  var slots = item.slots,
      field = item.field,
      itemRender = item.itemRender,
      titlePrefix = item.titlePrefix,
      titleSuffix = item.titleSuffix;
  var compConf = (0, _tools.isEnableConf)(itemRender) ? _vXETable.default.renderer.get(itemRender.name) : null;
  var params = {
    data: data,
    property: field,
    item: item,
    $form: _vm
  };
  var contVNs = [];
  var titVNs = [];

  if (titlePrefix) {
    titVNs.push(titlePrefix.message ? h('vxe-tooltip', {
      props: {
        content: _tools.UtilTools.getFuncText(titlePrefix.message),
        enterable: titlePrefix.enterable,
        theme: titlePrefix.theme
      }
    }, [renderPrefixIcon(h, titlePrefix)]) : renderPrefixIcon(h, titlePrefix));
  }

  titVNs.push(h('span', {
    class: 'vxe-form--item-title-label'
  }, compConf && compConf.renderItemTitle ? compConf.renderItemTitle(itemRender, params) : slots && slots.title ? _vm.callSlot(slots.title, params, h) : _tools.UtilTools.getFuncText(item.title)));
  contVNs.push(h('div', {
    class: 'vxe-form--item-title-content'
  }, titVNs));
  var fixVNs = [];

  if (titleSuffix) {
    fixVNs.push(titleSuffix.message ? h('vxe-tooltip', {
      props: {
        content: _tools.UtilTools.getFuncText(titleSuffix.message),
        enterable: titleSuffix.enterable,
        theme: titleSuffix.theme
      }
    }, [renderSuffixIcon(h, titleSuffix)]) : renderSuffixIcon(h, titleSuffix));
  }

  contVNs.push(h('div', {
    class: 'vxe-form--item-title-postfix'
  }, fixVNs));
  return contVNs;
}