'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});
exports.init = init;

var _lodash = require('lodash.assign');

var _lodash2 = _interopRequireDefault(_lodash);

var _createElement = require('virtual-dom/create-element');

var _createElement2 = _interopRequireDefault(_createElement);

var _eventEmitter = require('event-emitter');

var _eventEmitter2 = _interopRequireDefault(_eventEmitter);

var _Playlist = require('./Playlist');

var _Playlist2 = _interopRequireDefault(_Playlist);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function init() {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var ee = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : (0, _eventEmitter2.default)();

    if (options.container === undefined) {
        throw new Error("DOM element container must be given.");
    }

    var audioContext = new (window.AudioContext || window.webkitAudioContext)();

    var defaults = {
        ac: audioContext,
        sampleRate: audioContext.sampleRate,
        samplesPerPixel: 4096, //samples per pixel to draw, must be an entry in zoomLevels.
        mono: true, //whether to draw multiple channels or combine them.
        fadeType: 'logarithmic',
        timescale: false, //whether or not to include the time measure.
        controls: {
            show: false, //whether or not to include the track controls
            width: 150 //width of controls in pixels
        },
        colors: {
            waveOutlineColor: 'white',
            timeColor: 'grey',
            fadeColor: 'black'
        },
        seekStyle: 'line',
        waveHeight: 128, //height of each canvas element a waveform is on.
        state: 'cursor',
        zoomLevels: [512, 1024, 2048, 4096] //zoom levels in samples per pixel
    };

    var config = (0, _lodash2.default)(defaults, options);
    var zoomIndex = config.zoomLevels.indexOf(config.samplesPerPixel);

    if (zoomIndex === -1) {
        throw new Error("initial samplesPerPixel must be included in array zoomLevels");
    }

    var playlist = new _Playlist2.default();
    playlist.setSampleRate(config.sampleRate);
    playlist.setSamplesPerPixel(config.samplesPerPixel);
    playlist.setAudioContext(config.ac);
    playlist.setEventEmitter(ee);
    playlist.setUpEventEmitter();
    playlist.setTimeSelection(0, 0);
    playlist.setState(config.state);
    playlist.setControlOptions(config.controls);
    playlist.setWaveHeight(config.waveHeight);
    playlist.setColors(config.colors);
    playlist.setZoomLevels(config.zoomLevels);
    playlist.setZoomIndex(zoomIndex);
    playlist.setMono(config.mono);
    playlist.setShowTimeScale(config.timescale);
    playlist.setSeekStyle(config.seekStyle);

    //take care of initial virtual dom rendering.
    var tree = playlist.render();
    var rootNode = (0, _createElement2.default)(tree);

    config.container.appendChild(rootNode);
    playlist.tree = tree;
    playlist.rootNode = rootNode;

    return playlist;
}