'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function drawFrame(cc, h2, x, minPeak, maxPeak) {
    var min = Math.abs(minPeak * h2);
    var max = Math.abs(maxPeak * h2);

    //draw maxs
    cc.fillRect(x, 0, 1, h2 - max);
    //draw mins
    cc.fillRect(x, h2 + min, 1, h2 - min);
}

/*
* virtual-dom hook for drawing to the canvas element.
*/

var _class = function () {
    function _class(peaks, offset, bits, color) {
        _classCallCheck(this, _class);

        this.peaks = peaks;
        this.offset = offset; //http://stackoverflow.com/questions/6081483/maximum-size-of-a-canvas-element
        this.color = color;
        this.bits = bits;
    }

    _createClass(_class, [{
        key: 'hook',
        value: function hook(canvas, prop, prev) {
            //canvas is up to date
            if (prev !== undefined && prev.peaks === this.peaks) {
                return;
            }

            var i = void 0;
            var len = canvas.width;
            var cc = canvas.getContext('2d');
            var h2 = canvas.height / 2;
            var maxValue = Math.pow(2, this.bits - 1);

            var minPeak = void 0;
            var maxPeak = void 0;

            cc.clearRect(0, 0, canvas.width, canvas.height);
            cc.fillStyle = this.color;

            for (i = 0; i < len; i++) {
                minPeak = this.peaks[(i + this.offset) * 2] / maxValue;
                maxPeak = this.peaks[(i + this.offset) * 2 + 1] / maxValue;
                drawFrame(cc, h2, i, minPeak, maxPeak);
            }
        }
    }]);

    return _class;
}();

exports.default = _class;