'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _fadeMaker = require('fade-maker');

var _fadeCurves = require('fade-curves');

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function createCurve(shape, type, width) {
    var reflection = type === _fadeMaker.FADEIN ? 1 : -1;
    var curve = void 0;

    switch (shape) {
        case _fadeMaker.SCURVE:
            curve = (0, _fadeCurves.sCurve)(width, reflection);
            break;
        case _fadeMaker.LINEAR:
            curve = (0, _fadeCurves.linear)(width, reflection);
            break;
        case _fadeMaker.EXPONENTIAL:
            curve = (0, _fadeCurves.exponential)(width, reflection);
            break;
        case _fadeMaker.LOGARITHMIC:
            curve = (0, _fadeCurves.logarithmic)(width, 10, reflection);
            break;
        default:
            throw new Error("Unsupported Fade type");
    }

    return curve;
}

function drawFadeCurve(ctx, shape, type, width, height) {
    var curve = void 0;
    var i = void 0;
    var len = void 0;
    var y = void 0;

    ctx.strokeStyle = "black";
    curve = createCurve(shape, type, width);

    y = height - curve[0] * height;
    ctx.beginPath();
    ctx.moveTo(0, y);

    for (i = 1, len = curve.length; i < len; i++) {
        y = height - curve[i] * height;
        ctx.lineTo(i, y);
    }
    ctx.stroke();
}

/*
* virtual-dom hook for drawing the fade curve to the canvas element.
*/

var _class = function () {
    function _class(type, shape, duration, samplesPerPixel) {
        _classCallCheck(this, _class);

        this.type = type;
        this.shape = shape;
        this.duration = duration;
        this.samplesPerPixel = samplesPerPixel;
    }

    _createClass(_class, [{
        key: 'hook',
        value: function hook(canvas, prop, prev) {
            //node is up to date.
            if (prev !== undefined && prev.shape === this.shape && prev.type === this.type && prev.duration === this.duration && prev.samplesPerPixel === this.samplesPerPixel) {
                return;
            }

            var cc = canvas.getContext('2d');
            drawFadeCurve(cc, this.shape, this.type, canvas.width, canvas.height);
        }
    }]);

    return _class;
}();

exports.default = _class;