'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _conversions = require('../../utils/conversions');

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var _class = function () {
    function _class(track, samplesPerPixel, sampleRate) {
        _classCallCheck(this, _class);

        this.track = track;
        this.samplesPerPixel = samplesPerPixel;
        this.sampleRate = sampleRate;
    }

    _createClass(_class, [{
        key: 'mousedown',
        value: function mousedown(e) {
            var _this = this;

            e.preventDefault();

            var el = e.target;
            var startX = e.offsetX;
            var startTime = (0, _conversions.pixelsToSeconds)(startX, this.samplesPerPixel, this.sampleRate);

            this.track.ee.emit('select', startTime, startTime, this.track);

            var emitSelection = function emitSelection(x) {
                var minX = Math.min(x, startX);
                var maxX = Math.max(x, startX);
                var startTime = (0, _conversions.pixelsToSeconds)(minX, _this.samplesPerPixel, _this.sampleRate);
                var endTime = (0, _conversions.pixelsToSeconds)(maxX, _this.samplesPerPixel, _this.sampleRate);

                _this.track.ee.emit('select', startTime, endTime, _this.track);
            };

            var complete = function complete(ev) {
                ev.preventDefault();

                emitSelection(ev.offsetX);

                el.onmousemove = el.onmouseup = el.onmouseleave = null;
            };

            //dynamically put an event on the element.
            el.onmousemove = function (ev) {
                ev.preventDefault();

                emitSelection(ev.offsetX);
            };

            el.onmouseup = el.onmouseleave = complete;
        }
    }, {
        key: 'getClasses',
        value: function getClasses() {
            return ".state-select";
        }
    }, {
        key: 'getEvents',
        value: function getEvents() {
            return {
                "mousedown": this.mousedown
            };
        }
    }]);

    return _class;
}();

exports.default = _class;