'use strict';

Object.defineProperty(exports, "__esModule", {
    value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _conversions = require('../../utils/conversions');

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var _class = function () {
    function _class(track, samplesPerPixel, sampleRate) {
        _classCallCheck(this, _class);

        this.track = track;
        this.samplesPerPixel = samplesPerPixel;
        this.sampleRate = sampleRate;
    }

    _createClass(_class, [{
        key: 'mousedown',
        value: function mousedown(e) {
            var _this = this;

            e.preventDefault();

            var el = e.target;
            var prevX = e.offsetX;

            var emitShift = function emitShift(x) {
                var deltaX = x - prevX;
                var deltaTime = (0, _conversions.pixelsToSeconds)(deltaX, _this.samplesPerPixel, _this.sampleRate);
                prevX = x;
                _this.track.ee.emit('shift', deltaTime, _this.track);
            };

            //dynamically put an event on the element.
            el.onmousemove = function (e) {
                e.preventDefault();
                emitShift(e.offsetX);
            };

            var complete = function complete(e) {
                e.preventDefault();
                emitShift(e.offsetX);
                el.onmousemove = el.onmouseup = el.onmouseleave = null;
            };

            el.onmouseup = el.onmouseleave = complete;
        }
    }, {
        key: 'getClasses',
        value: function getClasses() {
            return ".state-shift";
        }
    }, {
        key: 'getEvents',
        value: function getEvents() {
            return {
                "mousedown": this.mousedown
            };
        }
    }]);

    return _class;
}();

exports.default = _class;