/*!
 * wavesurfer.js spectrogram plugin 6.2.0 (2022-05-16)
 * https://wavesurfer-js.org
 * @license BSD-3-Clause
 */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define("WaveSurfer",[],t):"object"==typeof exports?exports.WaveSurfer=t():(e.WaveSurfer=e.WaveSurfer||{},e.WaveSurfer.spectrogram=t())}(self,(()=>(()=>{"use strict";var e={325:(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.default=function(e,t,a,r){switch(this.bufferSize=e,this.sampleRate=t,this.bandwidth=2/e*(t/2),this.sinTable=new Float32Array(e),this.cosTable=new Float32Array(e),this.windowValues=new Float32Array(e),this.reverseTable=new Uint32Array(e),this.peakBand=0,this.peak=0,a){case"bartlett":for(i=0;i<e;i++)this.windowValues[i]=2/(e-1)*((e-1)/2-Math.abs(i-(e-1)/2));break;case"bartlettHann":for(i=0;i<e;i++)this.windowValues[i]=.62-.48*Math.abs(i/(e-1)-.5)-.38*Math.cos(2*Math.PI*i/(e-1));break;case"blackman":for(r=r||.16,i=0;i<e;i++)this.windowValues[i]=(1-r)/2-.5*Math.cos(2*Math.PI*i/(e-1))+r/2*Math.cos(4*Math.PI*i/(e-1));break;case"cosine":for(i=0;i<e;i++)this.windowValues[i]=Math.cos(Math.PI*i/(e-1)-Math.PI/2);break;case"gauss":for(r=r||.25,i=0;i<e;i++)this.windowValues[i]=Math.pow(Math.E,-.5*Math.pow((i-(e-1)/2)/(r*(e-1)/2),2));break;case"hamming":for(i=0;i<e;i++)this.windowValues[i]=.54-.46*Math.cos(2*Math.PI*i/(e-1));break;case"hann":case void 0:for(i=0;i<e;i++)this.windowValues[i]=.5*(1-Math.cos(2*Math.PI*i/(e-1)));break;case"lanczoz":for(i=0;i<e;i++)this.windowValues[i]=Math.sin(Math.PI*(2*i/(e-1)-1))/(Math.PI*(2*i/(e-1)-1));break;case"rectangular":for(i=0;i<e;i++)this.windowValues[i]=1;break;case"triangular":for(i=0;i<e;i++)this.windowValues[i]=2/e*(e/2-Math.abs(i-(e-1)/2));break;default:throw Error("No such window function '"+a+"'")}var i,n=1,s=e>>1;for(;n<e;){for(i=0;i<n;i++)this.reverseTable[i+n]=this.reverseTable[i]+s;n<<=1,s>>=1}for(i=0;i<e;i++)this.sinTable[i]=Math.sin(-Math.PI/i),this.cosTable[i]=Math.cos(-Math.PI/i);this.calculateSpectrum=function(e){var t,a,r,i=this.bufferSize,n=this.cosTable,s=this.sinTable,l=this.reverseTable,o=new Float32Array(i),h=new Float32Array(i),f=2/this.bufferSize,c=Math.sqrt,u=new Float32Array(i/2),p=Math.floor(Math.log(i)/Math.LN2);if(Math.pow(2,p)!==i)throw"Invalid buffer size, must be a power of 2.";if(i!==e.length)throw"Supplied buffer is not the same size as defined FFT. FFT Size: "+i+" Buffer Size: "+e.length;for(var d,v,w,y,m,b,M,g,k=1,x=0;x<i;x++)o[x]=e[l[x]]*this.windowValues[l[x]],h[x]=0;for(;k<i;){d=n[k],v=s[k],w=1,y=0;for(var S=0;S<k;S++){for(x=S;x<i;)b=w*o[m=x+k]-y*h[m],M=w*h[m]+y*o[m],o[m]=o[x]-b,h[m]=h[x]-M,o[x]+=b,h[x]+=M,x+=k<<1;w=(g=w)*d-y*v,y=g*v+y*d}k<<=1}x=0;for(var C=i/2;x<C;x++)(r=f*c((t=o[x])*t+(a=h[x])*a))>this.peak&&(this.peakBand=x,this.peak=r),u[x]=r;return u}},e.exports=t.default},943:(e,t,a)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;var r,i=(r=a(325))&&r.__esModule?r:{default:r};function n(e,t){for(var a=0;a<t.length;a++){var r=t[a];r.enumerable=r.enumerable||!1,r.configurable=!0,"value"in r&&(r.writable=!0),Object.defineProperty(e,r.key,r)}}var s=function(){function e(t,a){var r=this;!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.params=t,this.wavesurfer=a,this.util=a.util,this.frequenciesDataUrl=t.frequenciesDataUrl,this._onScroll=function(e){r.updateScroll(e)},this._onRender=function(){r.render()},this._onWrapperClick=function(e){r._wrapperClickHandler(e)},this._onReady=function(){var e=r.drawer=a.drawer;if(r.container="string"==typeof t.container?document.querySelector(t.container):t.container,!r.container)throw Error("No container for WaveSurfer spectrogram");if(t.colorMap){if(t.colorMap.length<256)throw new Error("Colormap must contain 256 elements");for(var i=0;i<t.colorMap.length;i++){if(4!==t.colorMap[i].length)throw new Error("ColorMap entries must contain 4 values")}r.colorMap=t.colorMap}else{r.colorMap=[];for(var n=0;n<256;n++){var s=(255-n)/256;r.colorMap.push([s,s,s,1])}}r.width=e.width,r.pixelRatio=r.params.pixelRatio||a.params.pixelRatio,r.fftSamples=r.params.fftSamples||a.params.fftSamples||512,r.height=r.params.height||r.fftSamples/2,r.noverlap=t.noverlap,r.windowFunc=t.windowFunc,r.alpha=t.alpha,r.splitChannels=t.splitChannels,r.channels=r.splitChannels?a.backend.buffer.numberOfChannels:1,r.frequencyMin=t.frequencyMin||0,r.frequencyMax=t.frequencyMax||12e3,r.createWrapper(),r.createCanvas(),r.render(),e.wrapper.addEventListener("scroll",r._onScroll),a.on("redraw",r._onRender)}}var t,a,r;return t=e,r=[{key:"create",value:function(t){return{name:"spectrogram",deferInit:!(!t||!t.deferInit)&&t.deferInit,params:t,staticProps:{FFT:i.default},instance:e}}}],(a=[{key:"init",value:function(){this.wavesurfer.isReady?this._onReady():this.wavesurfer.once("ready",this._onReady)}},{key:"destroy",value:function(){this.unAll(),this.wavesurfer.un("ready",this._onReady),this.wavesurfer.un("redraw",this._onRender),this.drawer&&this.drawer.wrapper.removeEventListener("scroll",this._onScroll),this.wavesurfer=null,this.util=null,this.params=null,this.wrapper&&(this.wrapper.removeEventListener("click",this._onWrapperClick),this.wrapper.parentNode.removeChild(this.wrapper),this.wrapper=null)}},{key:"createWrapper",value:function(){var e=this.container.querySelector("spectrogram");e&&this.container.removeChild(e);var t=this.wavesurfer.params;if(this.wrapper=document.createElement("spectrogram"),this.params.labels){var a=this.labelsEl=document.createElement("canvas");a.classList.add("spec-labels"),this.drawer.style(a,{position:"fixed",zIndex:9,height:"".concat(this.height*this.channels,"px"),width:"55px"}),this.wrapper.appendChild(a),this.loadLabels("rgba(68,68,68,0.5)","12px","10px","","#fff","#f7f7f7","center","#specLabels")}this.drawer.style(this.wrapper,{display:"block",position:"relative",userSelect:"none",webkitUserSelect:"none",height:"".concat(this.height*this.channels,"px")}),(t.fillParent||t.scrollParent)&&this.drawer.style(this.wrapper,{width:"100%",overflowX:"hidden",overflowY:"hidden"}),this.container.appendChild(this.wrapper),this.wrapper.addEventListener("click",this._onWrapperClick)}},{key:"_wrapperClickHandler",value:function(e){e.preventDefault();var t="offsetX"in e?e.offsetX:e.layerX;this.fireEvent("click",t/this.width||0)}},{key:"createCanvas",value:function(){var e=this.canvas=this.wrapper.appendChild(document.createElement("canvas"));this.spectrCc=e.getContext("2d"),this.util.style(e,{position:"absolute",zIndex:4})}},{key:"render",value:function(){this.updateCanvasStyle(),this.frequenciesDataUrl?this.loadFrequenciesData(this.frequenciesDataUrl):this.getFrequencies(this.drawSpectrogram)}},{key:"updateCanvasStyle",value:function(){var e=Math.round(this.width/this.pixelRatio)+"px";this.canvas.width=this.width,this.canvas.height=this.fftSamples/2*this.channels,this.canvas.style.width=e,this.canvas.style.height=this.height+"px"}},{key:"drawSpectrogram",value:function(e,t){isNaN(e[0][0])||(e=[e]);var a=t.spectrCc,r=t.fftSamples/2,i=t.width,n=t.buffer.sampleRate/2,s=t.frequencyMin,l=t.frequencyMax;if(a)for(var o=function(o){for(var h=t.resample(e[o]),f=new ImageData(i,r),c=0;c<h.length;c++)for(var u=0;u<h[c].length;u++){var p=t.colorMap[h[c][u]],d=4*((r-u)*i+c);f.data[d]=255*p[0],f.data[d+1]=255*p[1],f.data[d+2]=255*p[2],f.data[d+3]=255*p[3]}createImageBitmap(f).then((function(e){return a.drawImage(e,0,r*(1-l/n),i,r*(l-s)/n,0,r*o,i,r)}))},h=0;h<e.length;h++)o(h)}},{key:"getFrequencies",value:function(e){var t=this.fftSamples,a=this.buffer=this.wavesurfer.backend.buffer,r=this.channels;if(a){var n=a.sampleRate,s=[],l=this.noverlap;if(!l){var o=a.length/this.canvas.width;l=Math.max(0,Math.round(t-o))}for(var h=new i.default(t,n,this.windowFunc,this.alpha),f=0;f<r;f++){for(var c=a.getChannelData(f),u=[],p=0;p+t<c.length;){var d=c.slice(p,p+t),v=h.calculateSpectrum(d),w=new Uint8Array(t/2),y=void 0;for(y=0;y<t/2;y++)w[y]=Math.max(-255,45*Math.log10(v[y]));u.push(w),p+=t-l}s.push(u)}e(s,this)}else this.fireEvent("error","Web Audio buffer is not available")}},{key:"loadFrequenciesData",value:function(e){var t=this,a=this.util.fetchFile({url:e});return a.on("success",(function(e){return t.drawSpectrogram(JSON.parse(e),t)})),a.on("error",(function(e){return t.fireEvent("error",e)})),a}},{key:"freqType",value:function(e){return e>=1e3?(e/1e3).toFixed(1):Math.round(e)}},{key:"unitType",value:function(e){return e>=1e3?"KHz":"Hz"}},{key:"loadLabels",value:function(e,t,a,r,i,n,s,l){e=e||"rgba(68,68,68,0)",t=t||"12px",a=a||"10px",r=r||"Helvetica",i=i||"#fff",n=n||"#fff",s=s||"center",l=l||"#specLabels";var o=this.height||512,h=o/256*5,f=this.frequencyMin,c=(this.frequencyMax-f)/h,u=this.labelsEl.getContext("2d"),p=window.devicePixelRatio;if(this.labelsEl.height=this.height*this.channels*p,this.labelsEl.width=55*p,u.scale(p,p),u)for(var d=0;d<this.channels;d++){u.fillStyle=e,u.fillRect(0,d*o,55,(1+d)*o),u.fill();var v=void 0;for(v=0;v<=h;v++){u.textAlign=s,u.textBaseline="middle";var w=f+c*v,y=this.freqType(w),m=this.unitType(w),b=void 0;0==v?(b=(1+d)*o+v-10,u.fillStyle=n,u.font=a+" "+r,u.fillText(m,40,b),u.fillStyle=i,u.font=t+" "+r,u.fillText(y,16,b)):(b=(1+d)*o-50*v+2,u.fillStyle=n,u.font=a+" "+r,u.fillText(m,40,b),u.fillStyle=i,u.font=t+" "+r,u.fillText(y,16,b))}}}},{key:"updateScroll",value:function(e){this.wrapper&&(this.wrapper.scrollLeft=e.target.scrollLeft)}},{key:"resample",value:function(e){var t,a=this.width,r=[],i=1/e.length,n=1/a;for(t=0;t<a;t++){var s=new Array(e[0].length),l=void 0;for(l=0;l<e.length;l++){var o=l*i,h=o+i,f=t*n,c=f+n,u=h<=f||c<=o?0:Math.min(Math.max(h,f),Math.max(c,o))-Math.max(Math.min(h,f),Math.min(c,o)),p=void 0;if(u>0)for(p=0;p<e[0].length;p++)null==s[p]&&(s[p]=0),s[p]+=u/n*e[l][p]}var d=new Uint8Array(e[0].length),v=void 0;for(v=0;v<e[0].length;v++)d[v]=s[v];r.push(d)}return r}}])&&n(t.prototype,a),r&&n(t,r),Object.defineProperty(t,"prototype",{writable:!1}),e}();t.default=s,e.exports=t.default}},t={};var a=function a(r){var i=t[r];if(void 0!==i)return i.exports;var n=t[r]={exports:{}};return e[r](n,n.exports,a),n.exports}(943);return a})()));
//# sourceMappingURL=wavesurfer.spectrogram.min.js.map