/*!
 * wavesurfer.js markers plugin 6.3.0 (2022-10-03)
 * https://wavesurfer-js.org
 * @license BSD-3-Clause
 */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define("WaveSurfer",[],t):"object"==typeof exports?exports.WaveSurfer=t():(e.WaveSurfer=e.WaveSurfer||{},e.WaveSurfer.markers=t())}(self,(()=>(()=>{"use strict";var e={188:(e,t)=>{function r(e,t){for(var r=0;r<t.length;r++){var n=t[r];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;var n=function(){function e(t,r){var n=this;!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.params=t,this.wavesurfer=r,this.util=r.util,this.style=this.util.style,this.markerLineWidth=1,this.markerWidth=11,this.markerHeight=22,this.dragging=!1,this._onResize=function(){n._updateMarkerPositions()},this._onBackendCreated=function(){n.wrapper=n.wavesurfer.drawer.wrapper,n.params.markers&&n.params.markers.forEach((function(e){return n.add(e)})),window.addEventListener("resize",n._onResize,!0),window.addEventListener("orientationchange",n._onResize,!0),n.wavesurfer.on("zoom",n._onResize),n.markers.find((function(e){return e.draggable}))&&(n.onMouseMove=function(e){return n._onMouseMove(e)},window.addEventListener("mousemove",n.onMouseMove),n.onMouseUp=function(e){return n._onMouseUp(e)},window.addEventListener("mouseup",n.onMouseUp))},this.markers=[],this._onReady=function(){n.wrapper=n.wavesurfer.drawer.wrapper,n._updateMarkerPositions()}}var t,n,i;return t=e,i=[{key:"create",value:function(t){return{name:"markers",deferInit:!(!t||!t.deferInit)&&t.deferInit,params:t,staticProps:{addMarker:function(e){return this.initialisedPluginList.markers||this.initPlugin("markers"),this.markers.add(e)},clearMarkers:function(){this.markers&&this.markers.clear()}},instance:e}}}],(n=[{key:"init",value:function(){this.wavesurfer.isReady?(this._onBackendCreated(),this._onReady()):(this.wavesurfer.once("ready",this._onReady),this.wavesurfer.once("backend-created",this._onBackendCreated))}},{key:"destroy",value:function(){this.wavesurfer.un("ready",this._onReady),this.wavesurfer.un("backend-created",this._onBackendCreated),this.wavesurfer.un("zoom",this._onResize),window.removeEventListener("resize",this._onResize,!0),window.removeEventListener("orientationchange",this._onResize,!0),this.onMouseMove&&window.removeEventListener("mousemove",this.onMouseMove),this.onMouseUp&&window.removeEventListener("mouseup",this.onMouseUp),this.clear()}},{key:"add",value:function(e){var t={time:e.time,label:e.label,color:e.color||"#D8D8D8",position:e.position||"bottom",draggable:!!e.draggable,preventContextMenu:!!e.preventContextMenu};return t.el=this._createMarkerElement(t,e.markerElement),this.wrapper.appendChild(t.el),this.markers.push(t),this._updateMarkerPositions(),t}},{key:"remove",value:function(e){var t=this.markers[e];if(t){var r=t.el.getElementsByClassName("marker-label")[0];r&&(r._onContextMenu&&r.removeEventListener("contextmenu",r._onContextMenu),r._onClick&&r.removeEventListener("click",r._onClick),r._onMouseDown&&r.removeEventListener("mousedown",r._onMouseDown)),this.wrapper.removeChild(t.el),this.markers.splice(e,1)}}},{key:"_createPointerSVG",value:function(e,t){var r="http://www.w3.org/2000/svg",n=document.createElementNS(r,"svg"),i=document.createElementNS(r,"polygon");return n.setAttribute("viewBox","0 0 40 80"),i.setAttribute("id","polygon"),i.setAttribute("stroke","#979797"),i.setAttribute("fill",e),i.setAttribute("points","20 0 40 30 40 80 0 80 0 30"),"top"==t&&i.setAttribute("transform","rotate(180, 20 40)"),n.appendChild(i),this.style(n,{width:this.markerWidth+"px",height:this.markerHeight+"px","min-width":this.markerWidth+"px","margin-right":"5px","z-index":4}),n}},{key:"_createMarkerElement",value:function(e,t){var r=this,n=e.label,i=document.createElement("marker");i.className="wavesurfer-marker",this.style(i,{position:"absolute",height:"100%",display:"flex",overflow:"hidden","flex-direction":"top"==e.position?"column-reverse":"column"});var a=document.createElement("div"),s=t?t.width:this.markerWidth;e.offset=(s-this.markerLineWidth)/2,this.style(a,{"flex-grow":1,"margin-left":e.offset+"px",background:"black",width:this.markerLineWidth+"px",opacity:.1}),i.appendChild(a);var o=document.createElement("div"),u=t||this._createPointerSVG(e.color,e.position);if(e.draggable&&(u.draggable=!1),o.appendChild(u),n){var d=document.createElement("span");d.innerText=n,this.style(d,{"font-family":"monospace","font-size":"90%"}),o.appendChild(d)}return this.style(o,{display:"flex","align-items":"center",cursor:"pointer"}),o.classList.add("marker-label"),i.appendChild(o),o._onClick=function(t){t.stopPropagation(),r.dragging||(r.wavesurfer.setCurrentTime(e.time),r.wavesurfer.fireEvent("marker-click",e,t))},o.addEventListener("click",o._onClick),o._onContextMenu=function(t){e.preventContextMenu&&t.preventDefault(),r.wavesurfer.fireEvent("marker-contextmenu",e,t)},o.addEventListener("contextmenu",o._onContextMenu),e.draggable&&(o._onMouseDown=function(){r.selectedMarker=e},o.addEventListener("mousedown",o._onMouseDown)),i}},{key:"_updateMarkerPositions",value:function(){for(var e=0;e<this.markers.length;e++){var t=this.markers[e];this._updateMarkerPosition(t)}}},{key:"_updateMarkerPosition",value:function(e){var t=this.wavesurfer.getDuration(),r=this.wavesurfer.drawer.width/this.wavesurfer.params.pixelRatio,n=r*Math.min(e.time/t,1)-e.offset;this.style(e.el,{left:n+"px","max-width":r-n+"px"})}},{key:"_onMouseMove",value:function(e){this.selectedMarker&&(this.dragging||(this.dragging=!0,this.wavesurfer.fireEvent("marker-drag",this.selectedMarker,e)),this.selectedMarker.time=this.wavesurfer.drawer.handleEvent(e)*this.wavesurfer.getDuration(),this._updateMarkerPositions())}},{key:"_onMouseUp",value:function(e){var t=this;if(this.selectedMarker&&setTimeout((function(){t.selectedMarker=!1,t.dragging=!1}),0),this.dragging){e.stopPropagation();var r=this.wavesurfer.getDuration();this.selectedMarker.time=this.wavesurfer.drawer.handleEvent(e)*r,this._updateMarkerPositions(),this.wavesurfer.fireEvent("marker-drop",this.selectedMarker,e)}}},{key:"clear",value:function(){for(;this.markers.length>0;)this.remove(0)}}])&&r(t.prototype,n),i&&r(t,i),Object.defineProperty(t,"prototype",{writable:!1}),e}();t.default=n,e.exports=t.default}},t={};var r=function r(n){var i=t[n];if(void 0!==i)return i.exports;var a=t[n]={exports:{}};return e[n](a,a.exports,r),a.exports}(188);return r})()));
//# sourceMappingURL=wavesurfer.markers.min.js.map