/*!
 * wavesurfer.js markers plugin 6.6.4 (2023-06-10)
 * https://wavesurfer-js.org
 * @license BSD-3-Clause
 */
!function(e,t){"object"==typeof exports&&"object"==typeof module?module.exports=t():"function"==typeof define&&define.amd?define("WaveSurfer",[],t):"object"==typeof exports?exports.WaveSurfer=t():(e.WaveSurfer=e.WaveSurfer||{},e.WaveSurfer.markers=t())}(self,(()=>(()=>{"use strict";var e={188:(e,t)=>{function r(e){return r="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},r(e)}function n(e,t){for(var n=0;n<t.length;n++){var i=t[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(e,(o=i.key,s=void 0,s=function(e,t){if("object"!==r(e)||null===e)return e;var n=e[Symbol.toPrimitive];if(void 0!==n){var i=n.call(e,t||"default");if("object"!==r(i))return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===t?String:Number)(e)}(o,"string"),"symbol"===r(s)?s:String(s)),i)}var o,s}Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;var i=function(){function e(t,r){var n=this;!function(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}(this,e),this.params=t,this.wavesurfer=r,this.util=r.util,this.style=this.util.style,this.markerLineWidth=1,this.markerWidth=11,this.markerHeight=22,this.dragging=!1,this._onResize=function(){n._updateMarkerPositions()},this._onBackendCreated=function(){n.wrapper=n.wavesurfer.drawer.wrapper,n.params.markers&&n.params.markers.forEach((function(e){return n.add(e)})),window.addEventListener("resize",n._onResize,!0),window.addEventListener("orientationchange",n._onResize,!0),n.wavesurfer.on("zoom",n._onResize),n.markers.find((function(e){return e.draggable}))&&(n.onMouseMove=function(e){return n._onMouseMove(e)},window.addEventListener("mousemove",n.onMouseMove),n.onMouseUp=function(e){return n._onMouseUp(e)},window.addEventListener("mouseup",n.onMouseUp))},this.markers=[],this._onReady=function(){n.wrapper=n.wavesurfer.drawer.wrapper,n._updateMarkerPositions()}}var t,r,i;return t=e,i=[{key:"create",value:function(t){return{name:"markers",deferInit:!(!t||!t.deferInit)&&t.deferInit,params:t,staticProps:{addMarker:function(e){return this.initialisedPluginList.markers||this.initPlugin("markers"),this.markers.add(e)},getMarkers:function(){return this.markers},clearMarkers:function(){this.markers&&this.markers.clear()}},instance:e}}}],(r=[{key:"init",value:function(){this.wavesurfer.isReady?(this._onBackendCreated(),this._onReady()):(this.wavesurfer.once("ready",this._onReady),this.wavesurfer.once("backend-created",this._onBackendCreated))}},{key:"destroy",value:function(){this.wavesurfer.un("ready",this._onReady),this.wavesurfer.un("backend-created",this._onBackendCreated),this.wavesurfer.un("zoom",this._onResize),window.removeEventListener("resize",this._onResize,!0),window.removeEventListener("orientationchange",this._onResize,!0),this.onMouseMove&&window.removeEventListener("mousemove",this.onMouseMove),this.onMouseUp&&window.removeEventListener("mouseup",this.onMouseUp),this.clear()}},{key:"add",value:function(e){var t={time:e.time,label:e.label,tooltip:e.tooltip,color:e.color||"#D8D8D8",position:e.position||"bottom",draggable:!!e.draggable,preventContextMenu:!!e.preventContextMenu};return t.el=this._createMarkerElement(t,e.markerElement),this.wrapper.appendChild(t.el),this.markers.push(t),this._updateMarkerPositions(),this._registerEvents(),t}},{key:"remove",value:function(e){var t=e;isNaN(t)&&(t=this.markers.findIndex((function(t){return t===e})));var r=this.markers[t];if(r){var n=r.el.getElementsByClassName("marker-label")[0];n&&(n._onContextMenu&&n.removeEventListener("contextmenu",n._onContextMenu),n._onClick&&n.removeEventListener("click",n._onClick),n._onMouseDown&&n.removeEventListener("mousedown",n._onMouseDown)),this.wrapper.removeChild(r.el),this.markers.splice(t,1),this._unregisterEvents()}}},{key:"_createPointerSVG",value:function(e,t){var r="http://www.w3.org/2000/svg",n=document.createElementNS(r,"svg"),i=document.createElementNS(r,"polygon");return n.setAttribute("viewBox","0 0 40 80"),i.setAttribute("id","polygon"),i.setAttribute("stroke","#979797"),i.setAttribute("fill",e),i.setAttribute("points","20 0 40 30 40 80 0 80 0 30"),"top"==t&&i.setAttribute("transform","rotate(180, 20 40)"),n.appendChild(i),this.style(n,{width:this.markerWidth+"px",height:this.markerHeight+"px","min-width":this.markerWidth+"px","margin-right":"5px","z-index":4}),n}},{key:"_createMarkerElement",value:function(e,t){var r=this,n=e.label,i=e.tooltip,o=document.createElement("marker");o.className="wavesurfer-marker",this.style(o,{position:"absolute",height:"100%",display:"flex",overflow:"hidden","flex-direction":"top"==e.position?"column-reverse":"column"});var s=document.createElement("div"),a=t?t.width:this.markerWidth;e.offset=(a-this.markerLineWidth)/2,this.style(s,{"flex-grow":1,"margin-left":e.offset+"px",background:"black",width:this.markerLineWidth+"px",opacity:.1}),o.appendChild(s);var u=document.createElement("div"),d=t||this._createPointerSVG(e.color,e.position);if(e.draggable&&(d.draggable=!1),u.appendChild(d),n){var l=document.createElement("span");l.innerText=n,l.setAttribute("title",i),this.style(l,{"font-family":"inherit","font-size":"90%"}),u.appendChild(l)}return this.style(u,{display:"flex","align-items":"center",cursor:"pointer"}),u.classList.add("marker-label"),o.appendChild(u),u._onClick=function(t){t.stopPropagation(),r.dragging||(r.wavesurfer.setCurrentTime(e.time),r.wavesurfer.fireEvent("marker-click",e,t))},u.addEventListener("click",u._onClick),u._onContextMenu=function(t){e.preventContextMenu&&t.preventDefault(),r.wavesurfer.fireEvent("marker-contextmenu",e,t)},u.addEventListener("contextmenu",u._onContextMenu),e.draggable&&(u._onMouseDown=function(){r.selectedMarker=e},u.addEventListener("mousedown",u._onMouseDown)),o}},{key:"_updateMarkerPositions",value:function(){for(var e=0;e<this.markers.length;e++){var t=this.markers[e];this._updateMarkerPosition(t)}}},{key:"_updateMarkerPosition",value:function(e){var t=this.wavesurfer.getDuration(),r=this.wavesurfer.drawer.width/this.wavesurfer.params.pixelRatio,n=r*Math.min(e.time/t,1)-e.offset;this.style(e.el,{left:n+"px","max-width":r-n+"px"})}},{key:"_onMouseMove",value:function(e){this.selectedMarker&&(this.dragging||(this.dragging=!0,this.wavesurfer.fireEvent("marker-drag",this.selectedMarker,e)),this.selectedMarker.time=this.wavesurfer.drawer.handleEvent(e)*this.wavesurfer.getDuration(),this._updateMarkerPositions())}},{key:"_onMouseUp",value:function(e){var t=this;if(this.selectedMarker&&setTimeout((function(){t.selectedMarker=!1,t.dragging=!1}),0),this.dragging){e.stopPropagation();var r=this.wavesurfer.getDuration();this.selectedMarker.time=this.wavesurfer.drawer.handleEvent(e)*r,this._updateMarkerPositions(),this.wavesurfer.fireEvent("marker-drop",this.selectedMarker,e)}}},{key:"_registerEvents",value:function(){var e=this;this.markers.find((function(e){return e.draggable}))&&(this.onMouseMove||(this.onMouseMove=function(t){return e._onMouseMove(t)},window.addEventListener("mousemove",this.onMouseMove)),this.onMouseUp||(this.onMouseUp=function(t){return e._onMouseUp(t)},window.addEventListener("mouseup",this.onMouseUp)))}},{key:"_unregisterEvents",value:function(){this.markers.find((function(e){return e.draggable}))||(this.onMouseMove&&(window.removeEventListener("mousemove",this.onMouseMove),this.onMouseMove=null),this.onMouseUp&&(window.removeEventListener("mouseup",this.onMouseUp),this.onMouseUp=null))}},{key:"clear",value:function(){for(;this.markers.length>0;)this.remove(0)}}])&&n(t.prototype,r),i&&n(t,i),Object.defineProperty(t,"prototype",{writable:!1}),e}();t.default=i,e.exports=t.default}},t={};var r=function r(n){var i=t[n];if(void 0!==i)return i.exports;var o=t[n]={exports:{}};return e[n](o,o.exports,r),o.exports}(188);return r})()));
//# sourceMappingURL=wavesurfer.markers.min.js.map