/**
 * Record audio from the microphone with a real-time waveform preview
 */
import BasePlugin, { type BasePluginEvents } from '../base-plugin.js';
export type RecordPluginOptions = {
    /** The MIME type to use when recording audio */
    mimeType?: MediaRecorderOptions['mimeType'];
    /** The audio bitrate to use when recording audio, defaults to 128000 to avoid a VBR encoding. */
    audioBitsPerSecond?: MediaRecorderOptions['audioBitsPerSecond'];
    /** Whether to render the recorded audio, true by default */
    renderRecordedAudio?: boolean;
};
export type RecordPluginDeviceOptions = {
    /** The device ID of the microphone to use */
    deviceId?: string | {
        exact: string;
    };
};
export type RecordPluginEvents = BasePluginEvents & {
    'record-start': [];
    'record-pause': [];
    'record-resume': [];
    'record-end': [blob: Blob];
};
declare class RecordPlugin extends BasePlugin<RecordPluginEvents, RecordPluginOptions> {
    private stream;
    private mediaRecorder;
    /** Create an instance of the Record plugin */
    constructor(options: RecordPluginOptions);
    /** Create an instance of the Record plugin */
    static create(options?: RecordPluginOptions): RecordPlugin;
    private renderMicStream;
    /** Request access to the microphone and start monitoring incoming audio */
    startMic(options?: RecordPluginDeviceOptions): Promise<MediaStream>;
    /** Stop monitoring incoming audio */
    stopMic(): void;
    /** Start recording audio from the microphone */
    startRecording(options?: RecordPluginDeviceOptions): Promise<void>;
    /** Check if the audio is being recorded */
    isRecording(): boolean;
    isPaused(): boolean;
    /** Stop the recording */
    stopRecording(): void;
    /** Pause the recording */
    pauseRecording(): void;
    /** Resume the recording */
    resumeRecording(): void;
    /** Get a list of available audio devices
     * You can use this to get the device ID of the microphone to use with the startMic and startRecording methods
     * Will return an empty array if the browser doesn't support the MediaDevices API or if the user has not granted access to the microphone
     * You can ask for permission to the microphone by calling startMic
     */
    static getAvailableAudioDevices(): Promise<MediaDeviceInfo[]>;
    /** Destroy the plugin */
    destroy(): void;
}
export default RecordPlugin;
