/*! *****************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
function t(t,e,s,i){return new(s||(s=Promise))((function(a,n){function r(t){try{o(i.next(t))}catch(t){n(t)}}function h(t){try{o(i.throw(t))}catch(t){n(t)}}function o(t){var e;t.done?a(t.value):(e=t.value,e instanceof s?e:new s((function(t){t(e)}))).then(r,h)}o((i=i.apply(t,e||[])).next())}))}class e{constructor(){this.listeners={}}on(t,e,s){if(this.listeners[t]||(this.listeners[t]=new Set),this.listeners[t].add(e),null==s?void 0:s.once){const s=()=>{this.un(t,s),this.un(t,e)};return this.on(t,s),s}return()=>this.un(t,e)}un(t,e){var s;null===(s=this.listeners[t])||void 0===s||s.delete(e)}once(t,e){return this.on(t,e,{once:!0})}unAll(){this.listeners={}}emit(t,...e){this.listeners[t]&&this.listeners[t].forEach((t=>t(...e)))}}class s extends e{constructor(t){super(),this.subscriptions=[],this.options=t}onInit(){}_init(t){this.wavesurfer=t,this.onInit()}destroy(){this.emit("destroy"),this.subscriptions.forEach((t=>t()))}}function i(t,e){const s=e.xmlns?document.createElementNS(e.xmlns,t):document.createElement(t);for(const[t,a]of Object.entries(e))if("children"===t)for(const[t,a]of Object.entries(e))"string"==typeof a?s.appendChild(document.createTextNode(a)):s.appendChild(i(t,a));else"style"===t?Object.assign(s.style,a):"textContent"===t?s.textContent=a:s.setAttribute(t,a.toString());return s}function a(t,e,s){const a=i(t,e||{});return null==s||s.appendChild(a),a}function n(t,e,s,i){switch(this.bufferSize=t,this.sampleRate=e,this.bandwidth=2/t*(e/2),this.sinTable=new Float32Array(t),this.cosTable=new Float32Array(t),this.windowValues=new Float32Array(t),this.reverseTable=new Uint32Array(t),this.peakBand=0,this.peak=0,s){case"bartlett":for(a=0;a<t;a++)this.windowValues[a]=2/(t-1)*((t-1)/2-Math.abs(a-(t-1)/2));break;case"bartlettHann":for(a=0;a<t;a++)this.windowValues[a]=.62-.48*Math.abs(a/(t-1)-.5)-.38*Math.cos(2*Math.PI*a/(t-1));break;case"blackman":for(i=i||.16,a=0;a<t;a++)this.windowValues[a]=(1-i)/2-.5*Math.cos(2*Math.PI*a/(t-1))+i/2*Math.cos(4*Math.PI*a/(t-1));break;case"cosine":for(a=0;a<t;a++)this.windowValues[a]=Math.cos(Math.PI*a/(t-1)-Math.PI/2);break;case"gauss":for(i=i||.25,a=0;a<t;a++)this.windowValues[a]=Math.pow(Math.E,-.5*Math.pow((a-(t-1)/2)/(i*(t-1)/2),2));break;case"hamming":for(a=0;a<t;a++)this.windowValues[a]=.54-.46*Math.cos(2*Math.PI*a/(t-1));break;case"hann":case void 0:for(a=0;a<t;a++)this.windowValues[a]=.5*(1-Math.cos(2*Math.PI*a/(t-1)));break;case"lanczoz":for(a=0;a<t;a++)this.windowValues[a]=Math.sin(Math.PI*(2*a/(t-1)-1))/(Math.PI*(2*a/(t-1)-1));break;case"rectangular":for(a=0;a<t;a++)this.windowValues[a]=1;break;case"triangular":for(a=0;a<t;a++)this.windowValues[a]=2/t*(t/2-Math.abs(a-(t-1)/2));break;default:throw Error("No such window function '"+s+"'")}for(var a,n=1,r=t>>1;n<t;){for(a=0;a<n;a++)this.reverseTable[a+n]=this.reverseTable[a]+r;n<<=1,r>>=1}for(a=0;a<t;a++)this.sinTable[a]=Math.sin(-Math.PI/a),this.cosTable[a]=Math.cos(-Math.PI/a);this.calculateSpectrum=function(t){var e,s,i,a=this.bufferSize,n=this.cosTable,r=this.sinTable,h=this.reverseTable,o=new Float32Array(a),l=new Float32Array(a),c=2/this.bufferSize,f=Math.sqrt,u=new Float32Array(a/2),p=Math.floor(Math.log(a)/Math.LN2);if(Math.pow(2,p)!==a)throw"Invalid buffer size, must be a power of 2.";if(a!==t.length)throw"Supplied buffer is not the same size as defined FFT. FFT Size: "+a+" Buffer Size: "+t.length;for(var d,w,b,M,g,v,m,y,x=1,q=0;q<a;q++)o[q]=t[h[q]]*this.windowValues[h[q]],l[q]=0;for(;x<a;){d=n[x],w=r[x],b=1,M=0;for(var S=0;S<x;S++){for(q=S;q<a;)v=b*o[g=q+x]-M*l[g],m=b*l[g]+M*o[g],o[g]=o[q]-v,l[g]=l[q]-m,o[q]+=v,l[q]+=m,q+=x<<1;b=(y=b)*d-M*w,M=y*w+M*d}x<<=1}q=0;for(var C=a/2;q<C;q++)(i=c*f((e=o[q])*e+(s=l[q])*s))>this.peak&&(this.peakBand=q,this.peak=i),u[q]=i;return u}}class r extends s{static create(t){return new r(t||{})}constructor(t){if(super(t),this.frequenciesDataUrl=t.frequenciesDataUrl,this.container="string"==typeof t.container?document.querySelector(t.container):t.container,t.colorMap){if(t.colorMap.length<256)throw new Error("Colormap must contain 256 elements");for(let e=0;e<t.colorMap.length;e++){if(4!==t.colorMap[e].length)throw new Error("ColorMap entries must contain 4 values")}this.colorMap=t.colorMap}else{this.colorMap=[];for(let t=0;t<256;t++){const e=(255-t)/256;this.colorMap.push([e,e,e,1])}}this.fftSamples=t.fftSamples||512,this.height=t.height||this.fftSamples/2,this.noverlap=t.noverlap,this.windowFunc=t.windowFunc,this.alpha=t.alpha,this.frequencyMin=t.frequencyMin||0,this.frequencyMax=t.frequencyMax||0,this.createWrapper(),this.createCanvas()}onInit(){this.container=this.container||this.wavesurfer.getWrapper(),this.container.appendChild(this.wrapper),this.wavesurfer.options.fillParent&&Object.assign(this.wrapper.style,{width:"100%",overflowX:"hidden",overflowY:"hidden"}),this.subscriptions.push(this.wavesurfer.on("redraw",(()=>this.render())))}destroy(){this.unAll(),this.wavesurfer.un("ready",this._onReady),this.wavesurfer.un("redraw",this._onRender),this.wavesurfer=null,this.util=null,this.options=null,this.wrapper&&(this.wrapper.remove(),this.wrapper=null),super.destroy()}loadFrequenciesData(e){return t(this,void 0,void 0,(function*(){const t=yield fetch(e);if(!t.ok)throw new Error("Unable to fetch frequencies data");const s=yield t.json();this.drawSpectrogram(s)}))}createWrapper(){this.wrapper=a("div",{style:{display:"block",position:"relative",userSelect:"none"}}),this.options.labels&&(this.labelsEl=a("canvas",{part:"spec-labels",style:{position:"absolute",zIndex:9,width:"55px",height:"100%"}},this.wrapper)),this.wrapper.addEventListener("click",this._onWrapperClick)}createCanvas(){this.canvas=a("canvas",{style:{position:"absolute",left:0,top:0,width:"100%",height:"100%",zIndex:4}},this.wrapper),this.spectrCc=this.canvas.getContext("2d")}render(){var t;if(this.frequenciesDataUrl)this.loadFrequenciesData(this.frequenciesDataUrl);else{const e=null===(t=this.wavesurfer)||void 0===t?void 0:t.getDecodedData();e&&this.drawSpectrogram(this.getFrequencies(e))}}drawSpectrogram(t){isNaN(t[0][0])||(t=[t]),this.wrapper.style.height=this.height*t.length+"px",this.width=this.wavesurfer.getWrapper().offsetWidth,this.canvas.width=this.width,this.canvas.height=this.height*t.length;const e=this.spectrCc,s=this.height,i=this.width,a=this.buffer.sampleRate/2,n=this.frequencyMin,r=this.frequencyMax;if(e){for(let h=0;h<t.length;h++){const o=this.resample(t[h]),l=new ImageData(i,s);for(let t=0;t<o.length;t++)for(let e=0;e<o[t].length;e++){const a=this.colorMap[o[t][e]],n=4*((s-e)*i+t);l.data[n]=255*a[0],l.data[n+1]=255*a[1],l.data[n+2]=255*a[2],l.data[n+3]=255*a[3]}createImageBitmap(l).then((t=>{e.drawImage(t,0,s*(1-r/a),i,s*(r-n)/a,0,s*h,i,s)}))}this.options.labels&&this.loadLabels(this.options.labelsBackground,"12px","12px","",this.options.labelsColor,this.options.labelsHzColor||this.options.labelsColor,"center","#specLabels",t.length),this.emit("ready")}}getFrequencies(t){var e,s;const i=this.fftSamples,a=(null!==(e=this.options.splitChannels)&&void 0!==e?e:null===(s=this.wavesurfer)||void 0===s?void 0:s.options.splitChannels)?t.numberOfChannels:1;if(this.frequencyMax=this.frequencyMax||t.sampleRate/2,!t)return;this.buffer=t;const r=t.sampleRate,h=[];let o=this.noverlap;if(!o){const e=t.length/this.canvas.width;o=Math.max(0,Math.round(i-e))}const l=new n(i,r,this.windowFunc,this.alpha);for(let e=0;e<a;e++){const s=t.getChannelData(e),a=[];let n=0;for(;n+i<s.length;){const t=s.slice(n,n+i),e=l.calculateSpectrum(t),r=new Uint8Array(i/2);for(let t=0;t<i/2;t++)r[t]=Math.max(-255,45*Math.log10(e[t]));a.push(r),n+=i-o}h.push(a)}return h}freqType(t){return t>=1e3?(t/1e3).toFixed(1):Math.round(t)}unitType(t){return t>=1e3?"KHz":"Hz"}loadLabels(t,e,s,i,a,n,r,h,o){t=t||"rgba(68,68,68,0)",e=e||"12px",s=s||"12px",i=i||"Helvetica",a=a||"#fff",n=n||"#fff",r=r||"center";const l=this.height||512,c=l/256*5,f=this.frequencyMin,u=(this.frequencyMax-f)/c,p=this.labelsEl.getContext("2d"),d=window.devicePixelRatio;if(this.labelsEl.height=this.height*o*d,this.labelsEl.width=55*d,p.scale(d,d),p)for(let h=0;h<o;h++){let o;for(p.fillStyle=t,p.fillRect(0,h*l,55,(1+h)*l),p.fill(),o=0;o<=c;o++){p.textAlign=r,p.textBaseline="middle";const t=f+u*o,c=this.freqType(t),d=this.unitType(t),w=16;let b;b=0==o?(1+h)*l+o-10:(1+h)*l-50*o+2,p.fillStyle=n,p.font=s+" "+i,p.fillText(d,w+24,b),p.fillStyle=a,p.font=e+" "+i,p.fillText(c,w,b)}}}resample(t){const e=this.width,s=[],i=1/t.length,a=1/e;let n;for(n=0;n<e;n++){const e=new Array(t[0].length);let r;for(r=0;r<t.length;r++){const s=r*i,h=s+i,o=n*a,l=o+a,c=h<=o||l<=s?0:Math.min(Math.max(h,o),Math.max(l,s))-Math.max(Math.min(h,o),Math.min(l,s));let f;if(c>0)for(f=0;f<t[0].length;f++)null==e[f]&&(e[f]=0),e[f]+=c/a*t[r][f]}const h=new Uint8Array(t[0].length);let o;for(o=0;o<t[0].length;o++)h[o]=e[o];s.push(h)}return s}}export{r as default};
