var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
import { r as registerInstance, c as createEvent, h } from './core-05182590.js';
var Autocomplete = /** @class */ (function () {
    function class_1(hostRef) {
        registerInstance(this, hostRef);
        this.activeIndex = -1;
        this.data = [];
        this.active = false;
        /**
         * The text is displayed by the form field for users
         */
        this.text = "";
        /**
         * The actual value of the form field
         */
        this.value = "";
        /**
         * The placeholder for the input field
         */
        this.placeholder = "";
        /**
         * Enable/Disable the input field
         */
        this.disabled = false;
        /**
         * The minimum input size for generating suggestions
         */
        this.minInput = 0;
        /**
         * The maximally shown suggestions in the list
         */
        this.maxSuggestions = 5;
        /**
         * Form validation: is the form input required
         */
        this.required = false;
        /**
         * id of the input field
         */
        this.inputId = "";
        /**
         * The class names, which should be set on the rendered html elements
         */
        this.cssClasses = {
            wrapper: "",
            input: "",
            suggestions: "suggestions",
            suggestion: "suggestion",
            active: "active"
        };
        this.selected = createEvent(this, "selected", 7);
        this.unselected = createEvent(this, "unselected", 7);
    }
    /**
     * Returns the `value` of the selected item
     */
    class_1.prototype.getValue = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.value];
            });
        });
    };
    /**
     * Returns the `text` of the selected item
     */
    class_1.prototype.getText = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, this.text];
            });
        });
    };
    /**
     * Clears the form field (suggestions and selection)
     */
    class_1.prototype.clear = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                this.handleClose();
                return [2 /*return*/];
            });
        });
    };
    class_1.prototype.handleKeyDown = function (keyCode) {
        if (keyCode == 40 || keyCode == 38) { // up/down arrows
            event.preventDefault();
            this.handleActivation(keyCode == 40);
        }
        else if (keyCode == 13 || keyCode == 9) { // enter/tab
            event.preventDefault();
            this.handleSelection(this.activeIndex);
        }
        else if (keyCode == 27) { // esc
            this.handleClose();
        }
    };
    class_1.prototype.handleKeyUp = function (keyCode, text) {
        if ([40, 38, 13, 9, 27].indexOf(keyCode) < 0) {
            this.clearSelection(true);
            this.prepareSuggestions(text);
        }
        this.active = true;
        this.text = text;
    };
    class_1.prototype.handleFocus = function (e) {
        e.preventDefault();
        this.active = true;
    };
    class_1.prototype.handleBlur = function (e) {
        var _this = this;
        e.preventDefault();
        setTimeout(function () {
            if (_this.active) {
                if (_this.value) {
                    _this.clearData();
                }
                else {
                    _this.handleClose();
                }
            }
        }, 250);
    };
    class_1.prototype.handleClose = function () {
        this.clearSelection();
        this.clearData();
    };
    class_1.prototype.handleActivation = function (next) {
        if (next === void 0) { next = true; }
        if (this.data.length > 0) {
            if (next && (this.activeIndex + 1) < this.data.length) {
                this.activeIndex += 1;
            }
            else if (next) {
                this.activeIndex = 0;
            }
            else if (!next && (this.activeIndex) > 0) {
                this.activeIndex -= 1;
            }
            else if (!next) {
                this.activeIndex = this.data.length - 1;
            }
        }
    };
    class_1.prototype.handleSelection = function (index) {
        if (index >= 0 && index < this.data.length) {
            this.text = this.data[index].text;
            this.value = this.data[index].value;
            this.selected.emit(this.data[index]);
            this.clearData();
        }
    };
    class_1.prototype.clearData = function () {
        this.data = [];
        this.activeIndex = -1;
        this.active = false;
    };
    class_1.prototype.clearSelection = function (clearOnlyValue) {
        if (clearOnlyValue === void 0) { clearOnlyValue = false; }
        if (this.value != "") {
            this.unselected.emit({
                text: this.text,
                value: this.value
            });
            this.value = "";
        }
        if (!clearOnlyValue) {
            this.text = "";
        }
    };
    class_1.prototype.prepareSuggestions = function (text) {
        return __awaiter(this, void 0, void 0, function () {
            var suggestions;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!(this.suggestionGenerator && text.length >= this.minInput)) return [3 /*break*/, 2];
                        return [4 /*yield*/, this.suggestionGenerator(text)];
                    case 1:
                        suggestions = _a.sent();
                        suggestions.splice(this.maxSuggestions);
                        this.data = suggestions;
                        return [3 /*break*/, 3];
                    case 2:
                        this.data = [];
                        _a.label = 3;
                    case 3: return [2 /*return*/];
                }
            });
        });
    };
    class_1.prototype.render = function () {
        var _this = this;
        return (h("div", { class: this.cssClasses.wrapper }, h("input", { value: this.text, class: this.cssClasses.input, onKeyDown: function (e) { return _this.handleKeyDown(e.keyCode); }, onKeyUp: function (e) { return _this.handleKeyUp(e.keyCode, e.target['value']); }, onBlur: function (e) { _this.handleBlur(e); }, onFocus: function (e) { _this.handleFocus(e); }, type: "text", id: this.inputId, required: this.required, autocomplete: "off", disabled: this.disabled, placeholder: this.placeholder }), this.data && this.data.length > 0
            ? h("div", { class: this.cssClasses.suggestions }, this.data.map(function (suggestion, index) {
                return h("button", { onClick: function () { return _this.handleSelection(index); }, type: "button", class: _this.cssClasses.suggestion + (_this.activeIndex == index ? (" " + _this.cssClasses.active) : ""), "data-value": suggestion.value }, suggestion.suggestion ? suggestion.suggestion : suggestion.text);
            }))
            : ""));
    };
    return class_1;
}());
export { Autocomplete as web_complete };
