import { Camera, Mesh, OrthographicCamera, PerspectiveCamera, Vector2 } from 'three';
import CameraControls from 'camera-controls';
import { CameraProjections, IfcComponent, NavigationMode, NavigationModes, NavModeManager } from '../../../base-types';
import { LiteEvent } from '../../../utils/LiteEvent';
import { IfcContext } from '../context';
export declare class IfcCamera extends IfcComponent {
    readonly perspectiveCamera: PerspectiveCamera;
    readonly orthographicCamera: OrthographicCamera;
    readonly cameraControls: CameraControls;
    navMode: NavModeManager;
    currentNavMode: NavigationMode;
    readonly onChange: LiteEvent<any>;
    readonly onChangeProjection: LiteEvent<Camera>;
    private readonly context;
    private readonly projectionManager;
    private previousUserInput;
    constructor(context: IfcContext);
    dispose(): void;
    get projection(): CameraProjections;
    set projection(projection: CameraProjections);
    /**
     * @deprecated Use cameraControls instead.
     */
    get controls(): CameraControls;
    get activeCamera(): Camera;
    update(_delta: number): void;
    updateAspect(dims?: Vector2): void;
    /**
     * @deprecated Use onChange.on() instead.
     */
    submitOnChange(action: (event: any) => void): void;
    setNavigationMode(mode: NavigationModes): void;
    toggleCameraControls(active: boolean): void;
    toggleProjection(): void;
    targetItem(mesh: Mesh): Promise<void>;
    toggleUserInput(active: boolean): void;
    private setOrthoCameraAspect;
    private setupCameras;
    private setCameraPositionAndTarget;
    private setupControls;
}
